/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierPartitionFence;
import io.confluent.kafka.storage.tier.domain.TierPartitionForceRestore;
import io.confluent.kafka.storage.tier.domain.TierPartitionUnfreezeLogStartOffset;
import io.confluent.rest.KafkaRestoreRestApiReturnStatus;
import io.confluent.rest.TierPartitionStateResponse;
import io.confluent.rest.TierRecordMetadataResponse;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.tools.RecoveryUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\tU\u0001\u0011\t\u0011)A\u0005M!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d1\u0004A1A\u0005\u0002]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004bB!\u0001\u0001\u0004%\tA\u0011\u0005\b\r\u0002\u0001\r\u0011\"\u0001H\u0011\u0019i\u0005\u0001)Q\u0005\u0007\"9a\n\u0001b\u0001\n\u0003y\u0005BB0\u0001A\u0003%\u0001\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003r\u0001\u0011\u0005!\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0002\"\u0017\u000647.\u0019+pa&\u001c\u0007+\u0019:uSRLwN\u001c*fgR|'/Z'b]\u0006<WM\u001d\u0006\u00033i\taa]3sm\u0016\u0014(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\ta\u0005\u0005\u0002(Q5\t\u0001$\u0003\u0002*1\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0017-\fgm[1D_:4\u0017nZ\u000b\u0002[A\u0011qEL\u0005\u0003_a\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006a1.\u00194lC\u000e{gNZ5hA\u00051A(\u001b8jiz\"2a\r\u001b6!\t9\u0003\u0001C\u0003%\u000b\u0001\u0007a\u0005C\u0003,\u000b\u0001\u0007Q&\u0001\u0004m_\u001e<WM]\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0006g24GG\u001b\u0006\u0002{\u0005\u0019qN]4\n\u0005}R$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\tA|'\u000f^\u000b\u0002\u0007B\u0011q\u0004R\u0005\u0003\u000b\u0002\u00121!\u00138u\u0003!\u0001xN\u001d;`I\u0015\fHC\u0001%L!\ty\u0012*\u0003\u0002KA\t!QK\\5u\u0011\u001da\u0015\"!AA\u0002\r\u000b1\u0001\u001f\u00132\u0003\u0015\u0001xN\u001d;!\u0003AIg\u000e^3sC2,e\u000e\u001a9pS:$8/F\u0001Q!\r\tFKV\u0007\u0002%*\u00111\u000bI\u0001\u000bG>dG.Z2uS>t\u0017BA+S\u0005\r\u0019V-\u001d\t\u0003/vk\u0011\u0001\u0017\u0006\u00033j\u000baaY8n[>t'BA\u000e\\\u0015\taF(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003=b\u0013\u0001\"\u00128ea>Lg\u000e^\u0001\u0012S:$XM]1m\u000b:$\u0007o\\5oiN\u0004\u0013!C4fi2+\u0017\rZ3s)\r\u0019%m\u001c\u0005\u0006G6\u0001\r\u0001Z\u0001\u0006i>\u0004\u0018n\u0019\t\u0003K2t!A\u001a6\u0011\u0005\u001d\u0004S\"\u00015\u000b\u0005%d\u0012A\u0002\u001fs_>$h(\u0003\u0002lA\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0007\u0005C\u0003q\u001b\u0001\u00071)A\u0005qCJ$\u0018\u000e^5p]\u00061r-\u001a;US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,8\u000fF\u0002t{z\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\tI,7\u000f\u001e\u0006\u0003qf\f\u0011bY8oM2,XM\u001c;\u000b\u0003i\f!![8\n\u0005q,(A\u0007+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u0014Vm\u001d9p]N,\u0007\"B2\u000f\u0001\u0004!\u0007\"\u00029\u000f\u0001\u0004\u0019\u0015aC4fi\u001a#\bo\u001d$jY\u0016$b!a\u0001\u0002\u001e\u0005}\u0001CBA\u0003\u0003\u001f\t\u0019\"\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\b\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\rQ\u00181B\u0005\u0005\u00037\t9B\u0001\u0003GS2,\u0007\"B2\u0010\u0001\u0004!\u0007\"\u00029\u0010\u0001\u0004\u0019\u0015aC5oU\u0016\u001cG/\u0012<f]R$B!!\n\u0002,A\u0019A/a\n\n\u0007\u0005%RO\u0001\u000eUS\u0016\u0014(+Z2pe\u0012lU\r^1eCR\f'+Z:q_:\u001cX\rC\u0004\u0002.A\u0001\r!a\f\u0002\u000b\u00154XM\u001c;\u0011\t\u0005E\u0012\u0011I\u0007\u0003\u0003gQA!!\u000e\u00028\u00051Am\\7bS:TA!!\u000f\u0002<\u0005!A/[3s\u0015\u0011\ti$a\u0010\u0002\u000fM$xN]1hK*\u00111d^\u0005\u0005\u0003\u0007\n\u0019D\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/Y\u0001\u0007O\u0016$Hj\\4\u0015\r\u0005%\u00131LA/!\u0015y\u00121JA(\u0013\r\ti\u0005\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'RA!!\u0016\u0002<\u0005\u0019An\\4\n\t\u0005e\u00131\u000b\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0003d#\u0001\u0007A\rC\u0003q#\u0001\u00071)\u0001\u000etKR4UM\\2f)&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002&\u0005\r\u0014Q\r\u0005\u0006GJ\u0001\r\u0001\u001a\u0005\u0006aJ\u0001\raQ\u0001\u001dg\u0016$hi\u001c:dKJ+7\u000f^8sKRKWM\u001d)beRLG/[8o)9\t)#a\u001b\u0002n\u0005=\u0014\u0011PA?\u0003\u0003CQaY\nA\u0002\u0011DQ\u0001]\nA\u0002\rCq!!\u001d\u0014\u0001\u0004\t\u0019(A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bcA\u0010\u0002v%\u0019\u0011q\u000f\u0011\u0003\t1{gn\u001a\u0005\b\u0003w\u001a\u0002\u0019AA:\u0003%)g\u000eZ(gMN,G\u000f\u0003\u0004\u0002\u0000M\u0001\r\u0001Z\u0001\fG>tG/\u001a8u\u0011\u0006\u001c\b\u000eC\u0004\u0002\u0004N\u0001\r!!\"\u0002#\rDWmY6tk6\fEnZ8sSRDW\u000eE\u0002 \u0003\u000fK1!!#!\u0005\u0011\u0011\u0015\u0010^3\u00023M,G/\u00168ge\u0016,'0\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u0003K\ty)!%\t\u000b\r$\u0002\u0019\u00013\t\u000bA$\u0002\u0019A\"\u0002!Y\fG.\u001b3bi\u0016dun\u001a*b]\u001e,G#C\"\u0002\u0018\u0006e\u00151TAP\u0011\u0015\u0019W\u00031\u0001e\u0011\u0015\u0001X\u00031\u0001D\u0011\u001d\ti*\u0006a\u0001\u0003g\na\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0004\u0002\"V\u0001\r!a\u001d\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0002\u001f\r\fgn\u0015;beR\u0014Vm\u001d;pe\u0016$RaQAT\u0003SCQa\u0019\fA\u0002\u0011DQ\u0001\u001d\fA\u0002\r\u0003")
public class KafkaTopicPartitionRestoreManager {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final Logger logger;
    private int port;
    private final Seq<Endpoint> interalEndpoints;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Logger logger() {
        return this.logger;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public Seq<Endpoint> interalEndpoints() {
        return this.interalEndpoints;
    }

    public int getLeader(String topic, int partition) {
        HostedPartition hostedPartition = this.replicaManager().getPartition(new TopicPartition(topic, partition));
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition2 = online.partition();
            Option<Object> option = partition2.leaderReplicaIdOpt();
            if (option instanceof Some) {
                Some some = (Some)option;
                int brokerId = BoxesRunTime.unboxToInt(some.value());
                return brokerId;
            }
            return KafkaRestoreRestApiReturnStatus.success;
        }
        return KafkaRestoreRestApiReturnStatus.invalid;
    }

    public TierPartitionStateResponse getTierPartitionStatus(String topic, int partition) {
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            TierPartitionStateResponse partitionStateResponse = new TierPartitionStateResponse(topic, partition, log.tierPartitionState().status().ordinal(), log.tierPartitionState().status().name());
            this.logger().info("[" + topic + "-" + partition + "]: tier partition status as " + partitionStateResponse);
            return partitionStateResponse;
        }
        return null;
    }

    public Optional<File> getFtpsFile(String topic, int partition) {
        Optional<File> optional;
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(this.kafkaConfig().logDirs()).asScala().foreach((Function1<String, Nothing$> & Serializable)logDir -> {
                File dir = new File(logDir + "/" + topic + "-" + partition + "/");
                throw new NonLocalReturnControl(object, Optional.of(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(dir.listFiles()), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(KafkaTopicPartitionRestoreManager.$anonfun$getFtpsFile$2(f)))))));
            });
            optional = Optional.empty();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                optional = (Optional<File>)ex.value();
            }
            throw ex;
        }
        return optional;
    }

    private TierRecordMetadataResponse injectEvent(AbstractTierMetadata event) {
        TierRecordMetadataResponse response = null;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:" + this.port());
        Some<Producer<byte[], byte[]>> maybeProducer = new Some<Producer<byte[], byte[]>>(RecoveryUtils.createTierTopicProducer(properties, "restore-rest-server"));
        String tierTopicName = "_confluent-tier-state";
        Short partitions = this.kafkaConfig().confluentConfig().tierMetadataNumPartitions();
        try {
            try {
                RecordMetadata recordMetadata = RecoveryUtils.injectTierTopicEvent((Producer<byte[], byte[]>)((Producer)((Option)maybeProducer).get()), event, tierTopicName, Predef$.MODULE$.Short2short(partitions));
                response = new TierRecordMetadataResponse(event.topicIdPartition().topicPartition().toString(), recordMetadata.timestamp(), recordMetadata.offset(), recordMetadata.partition());
            }
            catch (Exception e) {
                this.logger().error("Exception in injecting " + event, (Throwable)e);
            }
        }
        finally {
            maybeProducer.foreach((Function1<Producer, Object> & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        return response;
    }

    public Option<AbstractLog> getLog(String topic, int partition) {
        return this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
    }

    public TierRecordMetadataResponse setFenceTierTopicPartition(String topic, int partition) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
            Option<TopicIdPartition> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.topicIdPartition()));
            if (option instanceof Some) {
                Some some = (Some)option;
                TopicIdPartition topicId = (TopicIdPartition)some.value();
                return new Some<TierPartitionFence>(new TierPartitionFence(topicId, UUID.randomUUID(), true));
            }
            return None$.MODULE$;
        });
        Option option = eventOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            TierPartitionFence event = (TierPartitionFence)some.value();
            return this.injectEvent(event);
        }
        return null;
    }

    public TierRecordMetadataResponse setForceRestoreTierPartition(String topic, int partition, long startOffset, long endOffset, String contentHash, byte checksumAlgorithm) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
            Option<TopicIdPartition> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.topicIdPartition()));
            if (option instanceof Some) {
                Some some = (Some)option;
                TopicIdPartition topicId = (TopicIdPartition)some.value();
                return new Some<TierPartitionForceRestore>(new TierPartitionForceRestore(topicId, UUID.randomUUID(), startOffset, endOffset, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), contentHash, Predef$.MODULE$.boolean2Boolean(true), checksumAlgorithm));
            }
            return None$.MODULE$;
        });
        Option option = eventOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            TierPartitionForceRestore event = (TierPartitionForceRestore)some.value();
            return this.injectEvent(event);
        }
        return null;
    }

    public TierRecordMetadataResponse setUnfreezeLogStartOffset(String topic, int partition) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
            Option<TopicIdPartition> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(log.topicIdPartition()));
            if (option instanceof Some) {
                Some some = (Some)option;
                TopicIdPartition topicId = (TopicIdPartition)some.value();
                return new Some<TierPartitionUnfreezeLogStartOffset>(new TierPartitionUnfreezeLogStartOffset(topicId, UUID.randomUUID()));
            }
            return None$.MODULE$;
        });
        Option option = eventOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            TierPartitionUnfreezeLogStartOffset event = (TierPartitionUnfreezeLogStartOffset)some.value();
            return this.injectEvent(event);
        }
        return null;
    }

    public int validateLogRange(String topic, int partition, long logStartOffset, long logEndOffset) {
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (logStartOffset >= log.logStartOffset() && logEndOffset <= log.logEndOffset()) {
                return KafkaRestoreRestApiReturnStatus.success;
            }
            this.logger().warn("[" + topic + "-" + partition + "]: validate log range fail, log range to be validated (" + logStartOffset + " - " + logEndOffset + "), log range on broker (" + log.logStartOffset() + " - " + log.logEndOffset() + ")");
            return KafkaRestoreRestApiReturnStatus.failure;
        }
        this.logger().warn("[" + topic + "-" + partition + "]: logManager doesn't contain log for " + topic + "-" + partition);
        return KafkaRestoreRestApiReturnStatus.failure;
    }

    public int canStartRestore(String topic, int partition) {
        Option<AbstractLog> option = this.getLog(topic, partition);
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (log.tierPartitionState().fencedSegments().isEmpty()) {
                return KafkaRestoreRestApiReturnStatus.success;
            }
            this.logger().warn("[" + topic + "-" + partition + "]: contains " + log.tierPartitionState().fencedSegments().size() + " fenced segments");
            return KafkaRestoreRestApiReturnStatus.failure;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn("[" + topic + "-" + partition + "]: logManager doesn't contain log for " + topic + "-" + partition);
            return KafkaRestoreRestApiReturnStatus.invalid;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$interalEndpoints$1(Endpoint endpoint) {
        return endpoint.listener().equalsIgnoreCase("INTERNAL") || endpoint.listener().equalsIgnoreCase("REPLICATION");
    }

    public static final /* synthetic */ boolean $anonfun$getFtpsFile$2(File f) {
        return f.isFile() && MergedLogUtils.isTierStateFile(f);
    }

    public KafkaTopicPartitionRestoreManager(ReplicaManager replicaManager, KafkaConfig kafkaConfig) {
        block0: {
            this.replicaManager = replicaManager;
            this.kafkaConfig = kafkaConfig;
            this.logger = LoggerFactory.getLogger((String)"KafkaTopicPartitionRestoreManager");
            this.port = ((Endpoint)kafkaConfig.listeners().last()).port();
            this.interalEndpoints = (Seq)kafkaConfig.listeners().filter((Function1<Endpoint, Object> & Serializable)endpoint -> BoxesRunTime.boxToBoolean(KafkaTopicPartitionRestoreManager.$anonfun$interalEndpoints$1(endpoint)));
            if (this.interalEndpoints().size() <= 0) break block0;
            this.port_$eq(((Endpoint)this.interalEndpoints().apply(false)).port());
        }
    }
}

