/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.TierOffsetInfo;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.cluster.Partition;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\teb\u0001B\u0010!\u0001\u0015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dI\u0006A1A\u0005\niCa!\u0019\u0001!\u0002\u0013Y\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007O\u0002\u0001\u000b\u0011\u00023\t\u000f!\u0004!\u0019!C\u0005G\"1\u0011\u000e\u0001Q\u0001\n\u0011DqA\u001b\u0001A\u0002\u0013%1\u000eC\u0004v\u0001\u0001\u0007I\u0011\u0002<\t\rq\u0004\u0001\u0015)\u0003m\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u0003\u0001\t\u0003\n9\u0001C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u00111\n\u0001\u0005B\u00055\u0003bBA1\u0001\u0011\u0005\u00131\r\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!a$\u0001\t\u0003\n\t\nC\u0004\u0002R\u0002!\t%a5\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011)\u0003\u0001C!\u0005O\u00111\u0003T8dC2dU-\u00193fe\u0016sG\rU8j]RT!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0019r\u0003\b\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!A.\u00198h\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\r=\u0013'.Z2u!\tyc'D\u00011\u0015\t\t\u0013G\u0003\u0002$e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9\u0004G\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u0012\u0013!B;uS2\u001c\u0018BA\u001f;\u0005\u001daunZ4j]\u001e\fAb]8ve\u000e,'I]8lKJ\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0019\u0002\u000f9,Go^8sW&\u0011A)\u0011\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00031\u0011'o\\6fe\u000e{gNZ5h!\t9\u0005*D\u0001!\u0013\tI\u0005EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003\u000f2K!!\u0014\u0011\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011q\tU\u0005\u0003#\u0002\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fa\u0001P5oSRtD#\u0002+V-^C\u0006CA$\u0001\u0011\u0015qT\u00011\u0001@\u0011\u0015)U\u00011\u0001G\u0011\u0015QU\u00011\u0001L\u0011\u0015qU\u00011\u0001P\u0003%\u0011X\r\u001d7jG\u0006LE-F\u0001\\!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\rIe\u000e^\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013\u0001C7bq\nKH/Z:\u0016\u0003\u0011\u0004\"aJ3\n\u0005\u0019D#aB%oi\u0016<WM]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%A\nj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|g.F\u0001m!\raVn\\\u0005\u0003]v\u0013aa\u00149uS>t\u0007C\u00019t\u001b\u0005\t(B\u0001:2\u0003\u0019\u0019w.\\7p]&\u0011A/\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003]Ig\u000e\u0015:pOJ,7o\u001d)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0002xuB\u0011A\f_\u0005\u0003sv\u0013A!\u00168ji\"910DA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005!\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rF\u0001\u0000!\ra\u0016\u0011A\u0005\u0004\u0003\u0007i&a\u0002\"p_2,\u0017M\\\u0001\u000eS:LG/[1uK\u000ecwn]3\u0015\u0003]\fQa\u00197pg\u0016\faB\u0019:pW\u0016\u0014XI\u001c3Q_&tG\u000fF\u0001@\u0003\u00151W\r^2i)\u0011\t\u0019\"a\r\u0011\u000f\u0005U\u00111D8\u0002 5\u0011\u0011q\u0003\u0006\u0004\u00033Q\u0013\u0001B;uS2LA!!\b\u0002\u0018\t\u0019Q*\u00199\u0011\t\u0005\u0005\u0012Q\u0006\b\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE9\u0002\u000f5,7o]1hK&!\u00111FA\u0013\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003_\t\tDA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003W\t)\u0003C\u0004\u00026M\u0001\r!a\u000e\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005e\u0012Q\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH9\u0002\u0011I,\u0017/^3tiNLA!a\u0011\u0002>\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011qIA%\u0005\u001d\u0011U/\u001b7eKJTA!a\u0011\u0002>\u0005\u0019b-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fiR1\u0011qJA-\u0003;\u0002B!!\u0015\u0002V5\u0011\u00111\u000b\u0006\u0003eBJA!a\u0016\u0002T\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007BBA.)\u0001\u0007q.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\r\u0005}C\u00031\u0001\\\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\u0002=\u0019,Go\u00195US\u0016\u0014X*\u0019;fe&\fG.\u001b>bi&|g\u000eV1sO\u0016$HCBA3\u0003s\nY\b\u0005\u0003\u0002h\u0005UTBAA5\u0015\r\t\u00131\u000e\u0006\u0004G\u00055$\u0002BA8\u0003c\n\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005M\u0014AA5p\u0013\u0011\t9(!\u001b\u0003\u001dQKWM](gMN,G/\u00138g_\"1\u00111L\u000bA\u0002=Da!! \u0016\u0001\u0004Y\u0016a\u00037fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\ty%a!\u0002\u0006\"1\u00111\f\fA\u0002=Da!a\u0018\u0017\u0001\u0004Y\u0016\u0001\u00074fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fiR1\u0011qJAF\u0003\u001bCa!a\u0017\u0018\u0001\u0004y\u0007BBA0/\u0001\u00071,\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003'\u000bi\fE\u0004\u0002\u0016\u0005mq.!&\u0011\t\u0005]\u0015q\u0017\b\u0005\u00033\u000b\u0019L\u0004\u0003\u0002\u001c\u0006Ef\u0002BAO\u0003_sA!a(\u0002.:!\u0011\u0011UAV\u001d\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATI\u00051AH]8pizJ\u0011!N\u0005\u0003gQJ!a\t\u001a\n\u0005I\f\u0014bAA\u0014c&!\u0011QWA\u0013\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005e\u00161\u0018\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\t),!\n\t\u000f\u0005}\u0006\u00041\u0001\u0002B\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000f\u0005U\u00111D8\u0002DB!\u0011QYAf\u001d\u0011\t\u0019#a2\n\t\u0005%\u0017QE\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f\u0017\u0002BAg\u0003\u001f\u0014\u0001d\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d)beRLG/[8o\u0015\u0011\tI-!\n\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0002V\u0006\u001d\b#B\u0018\u0002X\u0006m\u0017bAAma\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N\u0004b!!\u0006\u0002^\u0006\u0005\u0018\u0002BAp\u0003/\u0011\u0001b\u00149uS>t\u0017\r\u001c\t\u0004_\u0005\r\u0018bAAsa\ta!+\u001a9mS\u000e\fg)\u001a;dQ\"9\u0011qX\rA\u0002\u0005%\bcBA\u000b\u00037y\u00171\u001e\t\u0004_\u00055\u0018bAAxa\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u000612/\u001a7fGR\u0004\u0016M\u001d;ji&|g\u000eV8GKR\u001c\u0007\u000e\u0006\u0003\u0002v\u0006u\bCBA\u000b\u0003;\f9\u0010\u0005\u0004]\u0003s|\u00171^\u0005\u0004\u0003wl&A\u0002+va2,'\u0007C\u0004\u0002\u0000j\u0001\r!!;\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0002-\t,\u0018\u000e\u001c3GKR\u001c\u0007NR8s!\u0006\u0014H/\u001b;j_:$b!!6\u0003\u0006\t\u001d\u0001BBA.7\u0001\u0007q\u000eC\u0004\u0003\nm\u0001\r!a;\u0002\u0015\u0019,Go\u00195Ti\u0006$X-\u0001\noKb$(+Z1esB\u000b'\u000f^5uS>tG\u0003\u0002B\b\u0005#\u0001B\u0001X7\u0002x\"9\u0011q \u000fA\u0002\tM\u0001c\u0002B\u000b\u00057y\u00171^\u0007\u0003\u0005/Q1A!\u0007^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\u00119\"A\bjgJ+\u0017\rZ=G_J4U\r^2i)\ry(\u0011\u0005\u0005\u0007\u0005Gi\u0002\u0019A8\u0002\u0005Q\u0004\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t%\u0002\u0003\u0002B\u0016\u0005gqAA!\f\u00030A\u0019\u00111U/\n\u0007\tER,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005k\u00119D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005ci\u0006")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LocalLeaderEndPoint localLeaderEndPoint = this;
        synchronized (localLeaderEndPoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return false;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public java.util.Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef<Object> partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put(topic.topicId(), topic.topic()));
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.data().topics().forEach(topic -> {
            String name = request.version() < 13 ? topic.topic() : (String)topicNames.apply(topic.topicId());
            topic.partitions().forEach(partition -> partitions.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicIdPartition(topic.topicId(), partition.partition(), name)), new FullPartitionFetchMetadata(topic.topicId(), partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch((int)partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch((int)partition.lastFetchedEpoch()), -1L))));
        });
        FetchParams fetchParams = new FetchParams(request.version(), -3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, partitions, QuotaFactory.UNBOUNDED_QUOTA, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1<Seq, Object> & Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, false);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException("Failed to fetch data for partitions " + ((IterableOnceOps)partitions.map((Function1<Tuple2, TopicIdPartition> & Serializable)x$1 -> (TopicIdPartition)x$1._1())).mkString(","));
        }
        return CollectionConverters$.MODULE$.MapHasAsJava(((Seq)partitionData.elem).toMap($less$colon$less$.MODULE$.refl())).asJava();
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Local leader endpoint does not support tiered partitions");
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Local Leader Endpoint.");
    }

    @Override
    public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> tuple22;
                TopicPartition tp = (TopicPartition)tuple2._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)tuple2._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch() == -1) {
                        epochEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code());
                    } else {
                        Partition partition = $this.replicaManager.getPartitionOrException(tp);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    }
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochEndOffset;
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String> & Serializable)() -> "Error when getting EpochEndOffset for " + tp, (Function0<Throwable> & Serializable)() -> t);
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        })).asJava();
    }

    @Override
    public ResultWithPartitions<Optional<ReplicaFetch>> buildFetch(java.util.Map<TopicPartition, PartitionFetchState> partitions) {
        if (this.quota.isQuotaExceeded()) {
            return new ResultWithPartitions<Optional<ReplicaFetch>>(Optional.empty(), java.util.Map.of());
        }
        Optional<Tuple2<TopicPartition, PartitionFetchState>> selectPartition = this.selectPartitionToFetch(partitions);
        if (selectPartition.isPresent()) {
            Tuple2<TopicPartition, PartitionFetchState> tuple2 = selectPartition.get();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = tuple2._1();
            PartitionFetchState fetchState = tuple2._2();
            Tuple2<TopicPartition, PartitionFetchState> tuple22 = new Tuple2<TopicPartition, PartitionFetchState>(tp, fetchState);
            TopicPartition tp2 = tuple22._1();
            PartitionFetchState fetchState2 = tuple22._2();
            return this.buildFetchForPartition(tp2, fetchState2);
        }
        return new ResultWithPartitions<Optional<ReplicaFetch>>(Optional.empty(), java.util.Map.of());
    }

    private Optional<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(java.util.Map<TopicPartition, PartitionFetchState> partitionMap) {
        Optional<Object> optional;
        block5: {
            Object object = new Object();
            try {
                Some some;
                Tuple2 tuple2;
                this.inProgressPartition().foreach((Function1<TopicPartition, Object> & Serializable)tp -> {
                    LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                    return BoxedUnit.UNIT;
                });
                this.inProgressPartition_$eq(None$.MODULE$);
                Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(CollectionConverters$.MODULE$.MapHasAsScala(partitionMap).asScala());
                nextPartitionOpt.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                    LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                    return BoxedUnit.UNIT;
                });
                Option<Tuple2<TopicPartition, PartitionFetchState>> option = nextPartitionOpt;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    TopicPartition tp2 = (TopicPartition)tuple2._1();
                    PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                    optional = Optional.of(new Tuple2<TopicPartition, PartitionFetchState>(tp2, fetchState));
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    optional = Optional.empty();
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    optional = (Optional)ex.value();
                }
                throw ex;
            }
        }
        return optional;
    }

    private ResultWithPartitions<Optional<ReplicaFetch>> buildFetchForPartition(TopicPartition topicPartition, PartitionFetchState fetchState) {
        Optional<Object> optional;
        FetchRequest.PartitionData partitionData;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(topicPartition).logStartOffset();
            Optional<Object> lastFetchedEpoch = this.isTruncationOnFetchSupported() ? fetchState.lastFetchedEpoch() : Optional.empty();
            Uuid topicId = fetchState.topicId().orElse(Uuid.ZERO_UUID);
            partitionData = requestMap.put(topicPartition, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), fetchState.replicationSessionId(), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String> & Serializable)() -> "Failed to build fetch for " + topicPartition, (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable)() -> e);
            partitionData = partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            optional = Optional.empty();
        } else {
            short version = fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion();
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)version, (int)this.replicaId(), (long)-1L, (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            optional = Optional.of(new ReplicaFetch(requestMap, requestBuilder));
        }
        Optional fetchRequestOpt = optional;
        return new ResultWithPartitions<Optional<ReplicaFetch>>(fetchRequestOpt, CollectionConverters$.MODULE$.MutableMapHasAsJava(partitionsWithError).asJava());
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2<Tuple2, Tuple2, Tuple2> & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                FetchPartitionData data = (FetchPartitionData)tuple2._2();
                List abortedTransactions = data.abortedTransactions.orElse(null);
                long lastStableOffset = data.lastStableOffset.orElse(-1L);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp.topicPartition()), new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records));
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(java.util.Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = Option$.MODULE$.apply(partitionMap$1.get(tp));
        fetchStateOpt.filter((Function1<PartitionFetchState, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isReadyForFetch())).foreach((Function1<PartitionFetchState, Nothing$> & Serializable)fetchState -> {
            throw new NonLocalReturnControl<Optional<Tuple2<TopicPartition, PartitionFetchState>>>(nonLocalReturnKey1$1, Optional.of(new Tuple2<TopicPartition, PartitionFetchState>(tp, (PartitionFetchState)fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, java.util.Map partitionMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            $this.inProgressPartition_$eq(new Some<TopicPartition>(tp));
            $this.info((Function0<String> & Serializable)() -> "Beginning/resuming copy of partition " + tp + " from offset " + fetchState.fetchOffset() + ". Including this partition, there are " + partitionMap$1.size() + " remaining partitions to copy by this thread.");
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            return partitionFetchState.isReadyForFetch();
        }
        throw new MatchError(tuple2);
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

