/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.TierMaterializationRequirements;
import io.confluent.kafka.server.TierOffsetInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUe\u0001\u0002\u0012$\u0001!B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"IA\u000b\u0001BC\u0002\u0013\u00051%\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005-\"IQ\f\u0001BC\u0002\u0013\u00051E\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005?\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u000bM\u0004A\u0011\u0001;\t\u000fy\u0004\u0001\u0019!C\t\u007f\"I\u0011q\u0001\u0001A\u0002\u0013E\u0011\u0011\u0002\u0005\t\u0003/\u0001\u0001\u0015)\u0003\u0002\u0002!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003O\u0001A\u0011IA\u0013\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002\u0002\u0002!\t\"a!\t\u000f\u0005m\u0005\u0001\"\u0005\u0002\u001e\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\tI\u000f\u0001C!\u0003WDq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t\u0015\u0003\u0001\"\u0005\u0003H!9!q\u000b\u0001\u0005\u0012\te\u0003b\u0002B0\u0001\u0011E!\u0011\r\u0005\b\u0005O\u0002A\u0011\tB5\u0011\u001d\u00119\t\u0001C\t\u0005\u0013CqA!$\u0001\t\u0003\u0012yI\u0001\u000bSK6|G/\u001a'fC\u0012,'/\u00128e!>Lg\u000e\u001e\u0006\u0003I\u0015\naa]3sm\u0016\u0014(\"\u0001\u0014\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!K\u0019<!\tQs&D\u0001,\u0015\taS&\u0001\u0003mC:<'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012aa\u00142kK\u000e$\bC\u0001\u001a:\u001b\u0005\u0019$B\u0001\u00135\u0015\t1SG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e4\u00059aU-\u00193fe\u0016sG\rU8j]R\u0004\"\u0001P \u000e\u0003uR!AP\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\nY><\u0007K]3gSb\u0004\"a\u0011'\u000f\u0005\u0011S\u0005CA#I\u001b\u00051%BA$(\u0003\u0019a$o\\8u})\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\u00061\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY\u0005*\u0001\bcY>\u001c7.\u001b8h'\u0016tG-\u001a:\u0011\u0005E\u0013V\"A\u0012\n\u0005M\u001b#\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0017a\u00054fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e#\u0014aB2mS\u0016tGo]\u0005\u00037b\u00131CR3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\fACZ3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\u0004\u0013A\u0004:fcV,7\u000f\u001e\"vS2$WM]\u000b\u0002?B\u0011\u0011\u000bY\u0005\u0003C\u000e\u0012aBU3rk\u0016\u001cHOQ;jY\u0012,'/A\bsKF,Xm\u001d;Ck&dG-\u001a:!\u0003%!\bN]8ui2,'\u000f\u0005\u0002RK&\u0011am\t\u0002\u0012\r>dGn\\<feRC'o\u001c;uY\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA)j\u0013\tQ7EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003#6L!A\\\u0012\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011\u0011+]\u0005\u0003e\u000e\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fa\u0001P5oSRtD#C;wobL(p\u001f?~!\t\t\u0006\u0001C\u0003B\u0017\u0001\u0007!\tC\u0003P\u0017\u0001\u0007\u0001\u000bC\u0003U\u0017\u0001\u0007a\u000bC\u0003^\u0017\u0001\u0007q\fC\u0003d\u0017\u0001\u0007A\rC\u0003h\u0017\u0001\u0007\u0001\u000eC\u0003l\u0017\u0001\u0007A\u000eC\u0003p\u0017\u0001\u0007\u0001/A\u0005gKR\u001c\u0007nU5{KV\u0011\u0011\u0011\u0001\t\u0004U\u0005\r\u0011bAA\u0003W\t9\u0011J\u001c;fO\u0016\u0014\u0018!\u00044fi\u000eD7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005M\u0001\u0003BA\u0007\u0003\u001fi\u0011\u0001S\u0005\u0004\u0003#A%\u0001B+oSRD\u0011\"!\u0006\u000e\u0003\u0003\u0005\r!!\u0001\u0002\u0007a$\u0013'\u0001\u0006gKR\u001c\u0007nU5{K\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\r\u0006\u0002\u0002\u001eA!\u0011QBA\u0010\u0013\r\t\t\u0003\u0013\u0002\b\u0005>|G.Z1o\u00035Ig.\u001b;jCR,7\t\\8tKR\u0011\u00111B\u0001\u0006G2|7/Z\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019dM\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t9$!\r\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\u0006)a-\u001a;dQR!\u0011QHA5!!\ty$!\u0012\u0002J\u0005USBAA!\u0015\r\t\u0019%L\u0001\u0005kRLG.\u0003\u0003\u0002H\u0005\u0005#aA'baB!\u00111JA)\u001b\t\tiEC\u0002\u0002PQ\naaY8n[>t\u0017\u0002BA*\u0003\u001b\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002X\u0005\rd\u0002BA-\u0003?j!!a\u0017\u000b\t\u0005u\u0013QJ\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\t'a\u0017\u0002#\u0019+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002f\u0005\u001d$!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0002b\u0005m\u0003bBA6'\u0001\u0007\u0011QN\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003_\nYH\u0004\u0003\u0002r\u0005]TBAA:\u0015\u0011\t)(!\u0014\u0002\u0011I,\u0017/^3tiNLA!!\u001f\u0002t\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011QPA@\u0005\u001d\u0011U/\u001b7eKJTA!!\u001f\u0002t\u0005)\u0002O]8dKN\u001ch)\u001a;dQ\u0016C8-\u001a9uS>tG\u0003BA\u0006\u0003\u000bCq!a\"\u0015\u0001\u0004\tI)A\u0001u!\u0011\tY)!&\u000f\t\u00055\u0015\u0011\u0013\b\u0004\u000b\u0006=\u0015\"A%\n\u0007\u0005M\u0005*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0015\u0011\u0014\u0002\n)\"\u0014xn^1cY\u0016T1!a%I\u0003Q\u0001(o\\2fgN4U\r^2i%\u0016\u001c\bo\u001c8tKR!\u0011QHAP\u0011\u001d\t\t+\u0006a\u0001\u0003G\u000bab\u00197jK:$(+Z:q_:\u001cX\rE\u0002X\u0003KK1!a*Y\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!,\u00028\u0006m\u0006\u0003BAX\u0003gk!!!-\u000b\u0007\u0005=3'\u0003\u0003\u00026\u0006E&AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0003s3\u0002\u0019AA%\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!0\u0017\u0001\u0004\ty,\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007\u0003BA\u0007\u0003\u0003L1!a1I\u0005\rIe\u000e^\u0001\u0012M\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$HCBAW\u0003\u0013\fY\rC\u0004\u0002:^\u0001\r!!\u0013\t\u000f\u0005uv\u00031\u0001\u0002@\u0006qb-\u001a;dQRKWM]'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UCJ<W\r\u001e\u000b\u0007\u0003#\f)/a:\u0011\t\u0005M\u0017\u0011]\u0007\u0003\u0003+T1\u0001JAl\u0015\r1\u0013\u0011\u001c\u0006\u0005\u00037\fi.A\u0005d_:4G.^3oi*\u0011\u0011q\\\u0001\u0003S>LA!a9\u0002V\nqA+[3s\u001f\u001a47/\u001a;J]\u001a|\u0007bBA]1\u0001\u0007\u0011\u0011\n\u0005\b\u0003{C\u0002\u0019AA`\u0003a1W\r^2i\u000b\u0006\u0014H.[3ti2{7-\u00197PM\u001a\u001cX\r\u001e\u000b\u0007\u0003[\u000bi/a<\t\u000f\u0005e\u0016\u00041\u0001\u0002J!9\u0011QX\rA\u0002\u0005}\u0016a\u00034fi\u000eDwJ\u001a4tKR$\u0002\"!>\u0002|\u0006u\u0018q \t\t\u0003\u001b\t90a0\u0002R&\u0019\u0011\u0011 %\u0003\rQ+\b\u000f\\33\u0011\u001d\tIL\u0007a\u0001\u0003\u0013Bq!!0\u001b\u0001\u0004\ty\fC\u0004\u0003\u0002i\u0001\rAa\u0001\u0002\u0013QLW.Z:uC6\u0004\b\u0003BA\u0007\u0005\u000bI1Aa\u0002I\u0005\u0011auN\\4\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\u0011iA!\r\u0011\u0011\u0005}\u0012QIA%\u0005\u001f\u0001BA!\u0005\u0003,9!!1\u0003B\u0014\u001d\u0011\u0011)B!\n\u000f\t\t]!1\u0005\b\u0005\u00053\u0011\tC\u0004\u0003\u0003\u001c\t}abA#\u0003\u001e%\t\u0001(\u0003\u00027o%\u0011a%N\u0005\u0004\u0003\u001f\"\u0014\u0002BA/\u0003\u001bJAA!\u000b\u0002\\\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011iCa\f\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi*!!\u0011FA.\u0011\u001d\u0011\u0019d\u0007a\u0001\u0005k\t!\u0002]1si&$\u0018n\u001c8t!!\ty$!\u0012\u0002J\t]\u0002\u0003\u0002B\u001d\u0005\u007fqA!!\u0017\u0003<%!!QHA.\u0003}yeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005\u0003\u0012\u0019E\u0001\rPM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s!\u0006\u0014H/\u001b;j_:TAA!\u0010\u0002\\\u0005a2M]3bi\u0016,\u0005o\\2i\u000b:$wJ\u001a4tKR\u001c(+Z9vKN$H\u0003\u0002B%\u0005+\u0002BAa\u0013\u0003R9!\u0011\u0011\u000fB'\u0013\u0011\u0011y%a\u001d\u00029=3gm]3ug\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti&!\u0011Q\u0010B*\u0015\u0011\u0011y%a\u001d\t\u000f\tMB\u00041\u0001\u00036\u0005q\u0002O]8dKN\u001cX\t]8dQ\u0016sGm\u00144gg\u0016$8OU3ta>t7/\u001a\u000b\u0005\u0005\u001b\u0011Y\u0006C\u0004\u0003^u\u0001\r!a)\u0002\u0011I,7\u000f]8og\u0016\fQ\u0004\u001d:pG\u0016\u001c8/\u00129pG\",e\u000eZ(gMN,Go\u001d$bS2,(/\u001a\u000b\u0007\u0005\u001b\u0011\u0019G!\u001a\t\u000f\tMb\u00041\u0001\u00036!9\u0011q\u0011\u0010A\u0002\u0005%\u0015A\u00032vS2$g)\u001a;dQR!!1\u000eB?!\u0015\u0011$Q\u000eB9\u0013\r\u0011yg\r\u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u0011\r\u0005}\"1\u000fB<\u0013\u0011\u0011)(!\u0011\u0003\u0011=\u0003H/[8oC2\u00042A\rB=\u0013\r\u0011Yh\r\u0002\r%\u0016\u0004H.[2b\r\u0016$8\r\u001b\u0005\b\u0005gy\u0002\u0019\u0001B@!!\ty$!\u0012\u0002J\t\u0005\u0005c\u0001\u001a\u0003\u0004&\u0019!QQ\u001a\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002\u001d1|wm\u0015;beR|eMZ:fiR!!1\u0001BF\u0011\u001d\tI\f\ta\u0001\u0003\u0013\nq\"[:SK\u0006$\u0017PR8s\r\u0016$8\r\u001b\u000b\u0005\u0003;\u0011\t\nC\u0004\u0003\u0014\u0006\u0002\r!!\u0013\u0002\u0005Q\u0004\b")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RemoteLeaderEndPoint remoteLeaderEndPoint = this;
        synchronized (remoteLeaderEndPoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(Integer x$1) {
        this.fetchSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return true;
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.processFetchException(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        return this.processFetchResponse(clientResponse2);
    }

    public void processFetchException(Throwable t) {
        this.fetchSessionHandler().handleError(t);
    }

    public Map<TopicPartition, FetchResponseData.PartitionData> processFetchResponse(ClientResponse clientResponse) {
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return Map.of();
        }
        return fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse.requestHeader().apiVersion());
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int epoch = tuple2._1$mcI$sp();
        TierOffsetInfo tierOffsetInfo = tuple2._2();
        Tuple2<Integer, TierOffsetInfo> tuple22 = new Tuple2<Integer, TierOffsetInfo>(BoxesRunTime.boxToInteger(epoch), tierOffsetInfo);
        int epoch2 = tuple22._1$mcI$sp();
        TierOffsetInfo tierOffsetInfo2 = tuple22._2();
        long localLogStartOffset = tierOffsetInfo2.localLogStartOffset();
        Optional<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo2.tierRestorePoint();
        if (tierRestorePoint.isPresent()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return new OffsetAndEpoch(localLogStartOffset, epoch2);
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int epoch = tuple2._1$mcI$sp();
        TierOffsetInfo tierOffsetInfo = tuple2._2();
        Tuple2<Integer, TierOffsetInfo> tuple22 = new Tuple2<Integer, TierOffsetInfo>(BoxesRunTime.boxToInteger(epoch), tierOffsetInfo);
        int epoch2 = tuple22._1$mcI$sp();
        TierOffsetInfo tierOffsetInfo2 = tuple22._2();
        long localLogStartOffset = tierOffsetInfo2.localLogStartOffset();
        Optional<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo2.tierRestorePoint();
        if (tierRestorePoint.isPresent()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return new OffsetAndEpoch(localLogStartOffset, epoch2);
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TierOffsetInfo tierOffsetInfo = tuple2._2();
            TierOffsetInfo tierOffsetInfo2 = tierOffsetInfo;
            return tierOffsetInfo2;
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Remote Leader Endpoint.");
    }

    private Tuple2<Object, TierOffsetInfo> fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        ClientResponse clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)listOffsetRequest);
        ListOffsetsResponse response = (ListOffsetsResponse)clientResponse.responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1<ListOffsetsResponseData.ListOffsetsTopicResponse, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala().find((Function1<ListOffsetsResponseData.ListOffsetsPartitionResponse, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            if (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID)) {
                return new Tuple2<Object, TierOffsetInfo>(BoxesRunTime.boxToInteger(responsePartition.leaderEpoch()), new TierOffsetInfo(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()));
            }
            return new Tuple2<Object, TierOffsetInfo>(BoxesRunTime.boxToInteger(responsePartition.leaderEpoch()), new TierOffsetInfo(responsePartition.offset()));
        }
        throw errors.exception();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return Map.of();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.createEpochEndOffsetsRequest(partitions);
        this.debug((Function0<String> & Serializable)() -> "Sending offset for leader epoch request " + epochRequest);
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            map = this.processEpochEndOffsetsResponse(response);
        }
        catch (Throwable t) {
            map = this.processEpochEndOffsetsFailure(partitions, t);
        }
        return map;
    }

    public OffsetsForLeaderEpochRequest.Builder createEpochEndOffsetsRequest(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        partitions.forEach((topicPartition, epochData) -> {
            OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics.find(topicPartition.topic());
            if (topic == null) {
                topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
                v0 = BoxesRunTime.boxToBoolean(topics.add((ImplicitLinkedHashCollection.Element)topic));
            } else {
                v0 = BoxedUnit.UNIT;
            }
            topic.partitions().add(epochData);
        });
        return this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsResponse(ClientResponse response) {
        OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
        this.debug((Function0<String> & Serializable)() -> "Received leaderEpoch response " + response);
        return CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(responseBody.data().topics()).asScala().flatMap((Function1<OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult, Buffer> & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1<OffsetForLeaderEpochResponseData.EpochEndOffset, Tuple2> & Serializable)offsetForLeaderPartitionResult -> {
            TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), offsetForLeaderPartitionResult);
        }))).toMap($less$colon$less$.MODULE$.refl())).asJava();
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsFailure(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions, Throwable t) {
        this.warn((Function0<String> & Serializable)() -> "Error when sending leader epoch request for " + partitions, (Function0<Throwable> & Serializable)() -> t);
        Errors error = AbstractFetcherThread$.MODULE$.exceptionToError(t);
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
            }
            throw new MatchError(tuple2);
        })).asJava();
    }

    @Override
    public ResultWithPartitions<Optional<ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        partitions.forEach((topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || $this.throttler.shouldThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager, $this.quota);
                    return;
                }
                try {
                    long startOffset = this.logStartOffset((TopicPartition)topicPartition);
                    Optional<Object> lastFetchedEpoch = this.isTruncationOnFetchSupported() ? fetchState.lastFetchedEpoch() : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.topicId().orElse(Uuid.ZERO_UUID), fetchState.fetchOffset(), startOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), fetchState.replicationSessionId(), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                }
                catch (KafkaStorageException kafkaStorageException) {
                    partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), Errors.KAFKA_STORAGE_ERROR));
                }
                return;
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Optional fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? Optional.empty() : Optional.of(new ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new ResultWithPartitions<Optional<ReplicaFetch>>(fetchRequestOpt, CollectionConverters$.MODULE$.MutableMapHasAsJava(partitionsWithError).asJava());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaManager.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

