/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.storage.log.AbstractLog;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.OffsetTruncationState;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011ea\u0001\u00028p\u0001QD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005U\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013B!\"a\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA)\u0011)\t9\u0006\u0001B\u0001B\u0003%\u0011\u0011\f\u0005\u000b\u0003[\u0002!\u0011!Q\u0001\n\u0005=\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\u000b\u0003#\u0003!\u0019!C\u0001_\u0006M\u0005\u0002CB%\u0001\u0001\u0006I!!&\t\u000f\r-\u0003\u0001\"\u0015\u0004N!91\u0011\r\u0001\u0005R\r\r\u0004bBB7\u0001\u0011E3q\u000e\u0005\b\u0007g\u0002A\u0011KB;\u0011\u001d\u0019)\t\u0001C!\u0007\u000fCqaa,\u0001\t\u0003\u001a\t\fC\u0004\u0002j\u0002!Ia!3\t\u0011\r=\u0007\u0001\"\u0001p\u0007#Dqa!7\u0001\t\u0013\u0019Y\u000eC\u0004\u0004p\u0002!\te!=\t\u000f\r}\b\u0001\"\u0011\u0005\u0002!9Aq\u0002\u0001\u0005R\u0011EqaBA__\"\u0005\u0011q\u0018\u0004\u0007]>D\t!!1\t\u000f\u0005e$\u0004\"\u0001\u0002L\u001a1\u0011Q\u001a\u000eA\u0003\u001fD!\"!;\u001d\u0005+\u0007I\u0011AAv\u0011)\u0011\t\u000b\bB\tB\u0003%\u0011Q\u001e\u0005\u000b\u0005Gc\"Q3A\u0005\u0002\t\u0015\u0006B\u0003BZ9\tE\t\u0015!\u0003\u0003(\"Q!Q\u0017\u000f\u0003\u0016\u0004%\tA!*\t\u0015\t]FD!E!\u0002\u0013\u00119\u000bC\u0004\u0002zq!\tA!/\t\u000f\t\rG\u0004\"\u0001\u0003F\"I!1\u001a\u000f\u0002\u0002\u0013\u0005!Q\u001a\u0005\n\u0005+d\u0012\u0013!C\u0001\u0005/D\u0011B!<\u001d#\u0003%\tAa<\t\u0013\tMH$%A\u0005\u0002\t=\b\"\u0003B\u00109\u0005\u0005I\u0011\tB\u0011\u0011%\u0011i\u0003HA\u0001\n\u0003\u0011y\u0003C\u0005\u00038q\t\t\u0011\"\u0001\u0003v\"I!Q\t\u000f\u0002\u0002\u0013\u0005#q\t\u0005\n\u0005+b\u0012\u0011!C\u0001\u0005sD\u0011B!@\u001d\u0003\u0003%\tEa@\t\u0013\tmC$!A\u0005B\tu\u0003\"\u0003B09\u0005\u0005I\u0011\tB1\u0011%\u0019\u0019\u0001HA\u0001\n\u0003\u001a)aB\u0005\u0004\ni\t\t\u0011#\u0001\u0004\f\u0019I\u0011Q\u001a\u000e\u0002\u0002#\u00051Q\u0002\u0005\b\u0003s\u001aD\u0011AB\u0013\u0011%\u0011yfMA\u0001\n\u000b\u0012\t\u0007C\u0005\u0004(M\n\t\u0011\"!\u0004*!I1\u0011G\u001a\u0002\u0002\u0013\u000551\u0007\u0005\n\u0005G\u001a\u0014\u0011!C\u0005\u0005K2\u0011\"!=\u001b!\u0003\r\t#a=\t\u000f\u0005U\u0018\b\"\u0001\u0002x\"9\u0011q`\u001d\u0005\u0002\t\u0005qaBB!5!\u0005!\u0011\u0003\u0004\b\u0003cT\u0002\u0012\u0001B\u0007\u0011\u001d\tI(\u0010C\u0001\u0005\u001f9qAa\u0005>\u0011\u0003\u0013)BB\u0004\u0003\u001auB\tIa\u0007\t\u000f\u0005e\u0004\t\"\u0001\u0003\u001e!I!q\u0004!\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005[\u0001\u0015\u0011!C\u0001\u0005_A\u0011Ba\u000eA\u0003\u0003%\tA!\u000f\t\u0013\t\u0015\u0003)!A\u0005B\t\u001d\u0003\"\u0003B+\u0001\u0006\u0005I\u0011\u0001B,\u0011%\u0011Y\u0006QA\u0001\n\u0003\u0012i\u0006C\u0005\u0003`\u0001\u000b\t\u0011\"\u0011\u0003b!I!1\r!\u0002\u0002\u0013%!QM\u0004\b\u0005[j\u0004\u0012\u0011B8\r\u001d\u0011\t(\u0010EA\u0005gBq!!\u001fL\t\u0003\u0011)\bC\u0004\u0002\u0000.#\tE!\u0001\t\u0013\t}1*!A\u0005B\t\u0005\u0002\"\u0003B\u0017\u0017\u0006\u0005I\u0011\u0001B\u0018\u0011%\u00119dSA\u0001\n\u0003\u00119\bC\u0005\u0003F-\u000b\t\u0011\"\u0011\u0003H!I!QK&\u0002\u0002\u0013\u0005!1\u0010\u0005\n\u00057Z\u0015\u0011!C!\u0005;B\u0011Ba\u0018L\u0003\u0003%\tE!\u0019\t\u0013\t\r4*!A\u0005\n\t\u0015ta\u0002B@{!\u0005%\u0011\u0011\u0004\b\u0005\u0017i\u0004\u0012\u0011BK\u0011\u001d\tIh\u0016C\u0001\u0005/Cq!a@X\t\u0003\u0012\t\u0001C\u0005\u0003 ]\u000b\t\u0011\"\u0011\u0003\"!I!QF,\u0002\u0002\u0013\u0005!q\u0006\u0005\n\u0005o9\u0016\u0011!C\u0001\u00053C\u0011B!\u0012X\u0003\u0003%\tEa\u0012\t\u0013\tUs+!A\u0005\u0002\tu\u0005\"\u0003B./\u0006\u0005I\u0011\tB/\u0011%\u0011yfVA\u0001\n\u0003\u0012\t\u0007C\u0005\u0003d]\u000b\t\u0011\"\u0003\u0003f\u001d9!1Q\u001f\t\u0002\n\u0015ea\u0002BD{!\u0005%\u0011\u0012\u0005\b\u0003s\u001aG\u0011\u0001BF\u0011%\u0011ybYA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003.\r\f\t\u0011\"\u0001\u00030!I!qG2\u0002\u0002\u0013\u0005!Q\u0012\u0005\n\u0005\u000b\u001a\u0017\u0011!C!\u0005\u000fB\u0011B!\u0016d\u0003\u0003%\tA!%\t\u0013\tm3-!A\u0005B\tu\u0003\"\u0003B0G\u0006\u0005I\u0011\tB1\u0011%\u0011\u0019gYA\u0001\n\u0013\u0011)\u0007C\u0005\u0004Di\t\n\u0011\"\u0001\u0004F\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u0015\t\u0001\u0018/\u0001\u0004tKJ4XM\u001d\u0006\u0002e\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001v!\t1x/D\u0001p\u0013\tAxNA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0004w\u0006%ab\u0001?\u0002\u0006A\u0019Q0!\u0001\u000e\u0003yT!a`:\u0002\rq\u0012xn\u001c;?\u0015\t\t\u0019!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\b\u0005\u0005\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twM\u0003\u0003\u0002\b\u0005\u0005\u0011A\u00027fC\u0012,'\u000f\u0005\u0003\u0002\u0014\u0005\u0005RBAA\u000b\u0015\r\u0001\u0018q\u0003\u0006\u0004e\u0006e!\u0002BA\u000e\u0003;\ta!\u00199bG\",'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\t)B\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001<\u0002*%\u0019\u00111F8\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001\u00059bkN,G\rU1si&$\u0018n\u001c8t!\r1\u0018\u0011G\u0005\u0004\u0003gy'\u0001\u0005)bkN,G\rU1si&$\u0018n\u001c8t\u0003I)\u0007\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005)Q\u000f^5mg*!\u0011\u0011IA\f\u0003\u0019\u0019w.\\7p]&!\u0011QIA\u001e\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u0002w\u0003\u0017J1!!\u0014p\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u00042A^A*\u0013\r\t)f\u001c\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\f\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\t\u0005m\u0013\u0011N\u0007\u0003\u0003;RA!a\u0018\u0002b\u00059Q.\u001a;sS\u000e\u001c(\u0002BA2\u0003K\n1\u0001\\8h\u0015\u0011\t9'a\u0006\u0002\u000fM$xN]1hK&!\u00111NA/\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\u000beSJ,7\r^8ss\u00163XM\u001c;IC:$G.\u001a:\u0011\t\u0005E\u0014QO\u0007\u0003\u0003gRA!!\u0011\u0002\u0016%!\u0011qOA:\u0005U!\u0015N]3di>\u0014\u00180\u0012<f]RD\u0015M\u001c3mKJ\fa\u0001P5oSRtD\u0003FA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by\t\u0005\u0002w\u0001!)\u0011P\u0003a\u0001u\"9\u0011q\u0002\u0006A\u0002\u0005E\u0001bBA\u0013\u0015\u0001\u0007\u0011q\u0005\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0011\u001d\t)D\u0003a\u0001\u0003oAq!a\u0012\u000b\u0001\u0004\tI\u0005C\u0004\u0002P)\u0001\r!!\u0015\t\u000f\u0005]#\u00021\u0001\u0002Z!I\u0011Q\u000e\u0006\u0011\u0002\u0003\u0007\u0011qN\u0001\u0010aJ|Wn\u001c;j_:\u001cF/\u0019;fgV\u0011\u0011Q\u0013\t\t\u0003/\u000b)+!+\u000226\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0006d_:\u001cWO\u001d:f]RTA!a(\u0002\"\u0006!Q\u000f^5m\u0015\t\t\u0019+\u0001\u0003kCZ\f\u0017\u0002BAT\u00033\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\tY+!,\u000e\u0005\u0005}\u0012\u0002BAX\u0003\u007f\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u00024rq1!!.\u001a\u001d\u0011\t9,a/\u000f\u0007u\fI,C\u0001s\u0013\t\u0001\u0018/A\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$\u0007C\u0001<\u001b'\rQ\u00121\u0019\t\u0005\u0003\u000b\f9-\u0004\u0002\u0002\u0002%!\u0011\u0011ZA\u0001\u0005\u0019\te.\u001f*fMR\u0011\u0011q\u0018\u0002\u000f!J|Wn\u001c;j_:\u001cF/\u0019;f'\u001da\u00121YAi\u0003/\u0004B!!2\u0002T&!\u0011Q[A\u0001\u0005\u001d\u0001&o\u001c3vGR\u0004B!!7\u0002d:!\u00111\\Ap\u001d\ri\u0018Q\\\u0005\u0003\u0003\u0007IA!!9\u0002\u0002\u00059\u0001/Y2lC\u001e,\u0017\u0002BAs\u0003O\u0014AbU3sS\u0006d\u0017N_1cY\u0016TA!!9\u0002\u0002\u0005\t\"/Z1tg&<g.\\3oiN#\u0018\r^3\u0016\u0005\u00055\bcAAxs5\t!DA\tSK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016\u001c2!OAb\u0003\u0019!\u0013N\\5uIQ\u0011\u0011\u0011 \t\u0005\u0003\u000b\fY0\u0003\u0003\u0002~\u0006\u0005!\u0001B+oSR\f\u0011$\\1zE\u0016LenY8og&\u001cH/\u001a8u\u001b\u0016$\u0018\rZ1uCV\u0011!1\u0001\t\u0005\u0003\u000b\u0014)!\u0003\u0003\u0003\b\u0005\u0005!a\u0002\"p_2,\u0017M\\\u0015\u0006s]\u001b\u0007i\u0013\u0002\t\u0003\u000e\u001cW\r\u001d;fIN\u0019Q(a1\u0015\u0005\tE\u0001cAAx{\u0005!aj\u001c8f!\r\u00119\u0002Q\u0007\u0002{\t!aj\u001c8f'%\u0001\u00151YAw\u0003#\f9\u000e\u0006\u0002\u0003\u0016\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\t\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQAA!\u000b\u0002\"\u0006!A.\u00198h\u0013\u0011\tYAa\n\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tE\u0002\u0003BAc\u0005gIAA!\u000e\u0002\u0002\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\bB!!\u0011\t)M!\u0010\n\t\t}\u0012\u0011\u0001\u0002\u0004\u0003:L\b\"\u0003B\"\t\u0006\u0005\t\u0019\u0001B\u0019\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\n\t\u0007\u0005\u0017\u0012\tFa\u000f\u000e\u0005\t5#\u0002\u0002B(\u0003\u0003\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019F!\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0007\u0011I\u0006C\u0005\u0003D\u0019\u000b\t\u00111\u0001\u0003<\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00032\u0005AAo\\*ue&tw\r\u0006\u0002\u0003$\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\r\t\u0005\u0005K\u0011I'\u0003\u0003\u0003l\t\u001d\"AB(cU\u0016\u001cG/\u0001\u0004Rk\u0016,X\r\u001a\t\u0004\u0005/Y%AB)vKV,GmE\u0005L\u0003\u0007\fi/!5\u0002XR\u0011!q\u000e\u000b\u0005\u0005w\u0011I\bC\u0005\u0003DA\u000b\t\u00111\u0001\u00032Q!!1\u0001B?\u0011%\u0011\u0019EUA\u0001\u0002\u0004\u0011Y$\u0001\u0005BG\u000e,\u0007\u000f^3e!\r\u00119bV\u0001\n\u000b\u001a4Wm\u0019;jm\u0016\u00042Aa\u0006d\u0005%)eMZ3di&4XmE\u0005d\u0003\u0007\fi/!5\u0002XR\u0011!Q\u0011\u000b\u0005\u0005w\u0011y\tC\u0005\u0003D\u001d\f\t\u00111\u0001\u00032Q!!1\u0001BJ\u0011%\u0011\u0019%[A\u0001\u0002\u0004\u0011YdE\u0005X\u0003\u0007\fi/!5\u0002XR\u0011!\u0011\u0011\u000b\u0005\u0005w\u0011Y\nC\u0005\u0003Dq\u000b\t\u00111\u0001\u00032Q!!1\u0001BP\u0011%\u0011\u0019EXA\u0001\u0002\u0004\u0011Y$\u0001\nsK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016\u0004\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0003\u0005O\u0003b!!2\u0003*\n5\u0016\u0002\u0002BV\u0003\u0003\u0011aa\u00149uS>t\u0007\u0003BAV\u0005_KAA!-\u0002@\t!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013AC2veJ,g\u000e\u001e#je\u0006Y1-\u001e:sK:$H)\u001b:!)!\u0011YL!0\u0003@\n\u0005\u0007cAAx9!9\u0011\u0011^\u0012A\u0002\u00055\bb\u0002BRG\u0001\u0007!q\u0015\u0005\b\u0005k\u001b\u0003\u0019\u0001BT\u000399\u0018\u000e\u001e5BgNLwM\\7f]R$BAa/\u0003H\"9!\u0011\u001a\u0013A\u0002\u00055\u0018a\u00068fo\u0012K'OU3bgNLwM\\7f]R\u001cF/\u0019;f\u0003\u0011\u0019w\u000e]=\u0015\u0011\tm&q\u001aBi\u0005'D\u0011\"!;&!\u0003\u0005\r!!<\t\u0013\t\rV\u0005%AA\u0002\t\u001d\u0006\"\u0003B[KA\u0005\t\u0019\u0001BT\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!7+\t\u00055(1\\\u0016\u0003\u0005;\u0004BAa8\u0003j6\u0011!\u0011\u001d\u0006\u0005\u0005G\u0014)/A\u0005v]\u000eDWmY6fI*!!q]A\u0001\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0014\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003r*\"!q\u0015Bn\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\"BAa\u000f\u0003x\"I!1I\u0016\u0002\u0002\u0003\u0007!\u0011\u0007\u000b\u0005\u0005\u0007\u0011Y\u0010C\u0005\u0003D5\n\t\u00111\u0001\u0003<\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011\u0019c!\u0001\t\u0013\t\rc&!AA\u0002\tE\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0004\r\u001d\u0001\"\u0003B\"c\u0005\u0005\t\u0019\u0001B\u001e\u00039\u0001&o\\7pi&|gn\u0015;bi\u0016\u00042!a<4'\u0015\u00194qBB\u000e!1\u0019\tba\u0006\u0002n\n\u001d&q\u0015B^\u001b\t\u0019\u0019B\u0003\u0003\u0004\u0016\u0005\u0005\u0011a\u0002:v]RLW.Z\u0005\u0005\u00073\u0019\u0019BA\tBEN$(/Y2u\rVt7\r^5p]N\u0002Ba!\b\u0004$5\u00111q\u0004\u0006\u0005\u0007C\t\t+\u0001\u0002j_&!\u0011Q]B\u0010)\t\u0019Y!A\u0003baBd\u0017\u0010\u0006\u0005\u0003<\u000e-2QFB\u0018\u0011\u001d\tIO\u000ea\u0001\u0003[DqAa)7\u0001\u0004\u00119\u000bC\u0004\u00036Z\u0002\rAa*\u0002\u000fUt\u0017\r\u001d9msR!1QGB\u001f!\u0019\t)M!+\u00048AQ\u0011QYB\u001d\u0003[\u00149Ka*\n\t\rm\u0012\u0011\u0001\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r}r'!AA\u0002\tm\u0016a\u0001=%a\u0005\t\"+Z1tg&<g.\\3oiN#\u0018\r^3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u00199E\u000b\u0003\u0002p\tm\u0017\u0001\u00059s_6|G/[8o'R\fG/Z:!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\r=3Q\f\t\u0007\u0007#\u001a\u0019fa\u0016\u000e\u0005\u0005u\u0015\u0002BB+\u0003;\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0005K\u0019I&\u0003\u0003\u0004\\\t\u001d\"aB%oi\u0016<WM\u001d\u0005\b\u0007?j\u0001\u0019AAU\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0004f\r-\u0004\u0003BAc\u0007OJAa!\u001b\u0002\u0002\t!Aj\u001c8h\u0011\u001d\u0019yF\u0004a\u0001\u0003S\u000bA\u0002\\8h\u000b:$wJ\u001a4tKR$Ba!\u001a\u0004r!91qL\bA\u0002\u0005%\u0016!E3oI>3gm]3u\r>\u0014X\t]8dQR11qOB@\u0007\u0003\u0003ba!\u0015\u0004T\re\u0004\u0003BA9\u0007wJAa! \u0002t\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBB0!\u0001\u0007\u0011\u0011\u0016\u0005\b\u0007\u0007\u0003\u0002\u0019\u0001B\u0019\u0003\u0015)\u0007o\\2i\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRQ1\u0011RBM\u00077\u001byja)\u0011\r\u0005\u0015'\u0011VBF!\u0011\u0019ii!&\u000e\u0005\r=%\u0002BA2\u0007#SAaa%\u0002f\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0007/\u001byIA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007?\n\u0002\u0019AAU\u0011\u001d\u0019i*\u0005a\u0001\u0007K\n1BZ3uG\"|eMZ:fi\"91\u0011U\tA\u0002\tE\u0012\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0004&F\u0001\raa*\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0019Ika+\u000e\u0003\u0001I1a!,x\u0005%1U\r^2i\t\u0006$\u0018-\u0001\tsK6|g/\u001a)beRLG/[8ogR!11WB`!!\u0011Ye!.\u0002*\u000ee\u0016\u0002BB\\\u0005\u001b\u00121!T1q!\u0011\t\u0019ba/\n\t\ru\u0016Q\u0003\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0007\u0003\u0014\u0002\u0019ABb\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B&\u0007\u000b\fI+\u0003\u0003\u0004H\n5#aA*fiR!11ZBg!\r\t\u0019,\u000f\u0005\b\u0007?\u001a\u0002\u0019AAU\u0003])\b\u000fZ1uKJ+\u0017m]:jO:lWM\u001c;Ti\u0006$X\r\u0006\u0004\u0002z\u000eM7Q\u001b\u0005\b\u0007?\"\u0002\u0019AAU\u0011\u001d\u00199\u000e\u0006a\u0001\u0007\u0017\fQa\u001d;bi\u0016\f\u0011$\\1zE\u0016\u0004&o\\7pi\u00164U\u000f^;sKJ+\u0007\u000f\\5dCR1!1HBo\u0007?Dqaa\u0018\u0016\u0001\u0004\tI\u000bC\u0004\u0004bV\u0001\raa9\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BBs\u0007Wl!aa:\u000b\u0007\r%\u0018/A\u0004dYV\u001cH/\u001a:\n\t\r58q\u001d\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BBb\u0007gDqa!>\u0017\u0001\u0004\u001990\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\b\u0003\u0003B&\u0007k\u000bIk!?\u0011\u0007Y\u001cY0C\u0002\u0004~>\u0014\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003!!(/\u001e8dCR,GC\u0002B\u0002\t\u0007!)\u0001C\u0004\u0004`]\u0001\r!!+\t\u000f\u0011\u001dq\u00031\u0001\u0005\n\u0005yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\r\u0005\u0003\u0002\u0014\u0011-\u0011\u0002\u0002C\u0007\u0003+\u0011Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011\u0011 C\n\t+Aqaa\u0018\u0019\u0001\u0004\tI\u000bC\u0004\u0005\u0018a\u0001\ra!\u001a\u0002\r=4gm]3u\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;

    public static DirectoryEventHandler $lessinit$greater$default$9() {
        return ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$9();
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(futureLog.logEndOffset())})));
        }
        None$ logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true, partitionLeaderEpoch) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        DirectoryEventHandler directoryEventHandler3 = directoryEventHandler;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler3) : directoryEventHandler3 != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(promotionState);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                Tuple3<ReassignmentState, Option<Uuid>, Option<Uuid>> tuple3 = new Tuple3<ReassignmentState, Option<Uuid>, Option<Uuid>>(reassignmentState, topicId, originalDir);
                ReassignmentState reassignmentState2 = tuple3._1();
                Option<Uuid> topicId2 = tuple3._2();
                Option<Uuid> originalDir2 = tuple3._3();
                if (originalDir2.isDefined() && topicId2.isDefined() && reassignmentState2.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition(topicId2.get(), topicPartition.partition()), originalDir2.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.debug((Function0<String> & Serializable)() -> "Updating future replica " + topicPartition + " reassignment state to " + state);
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException("Topic " + topicPartition.topic() + " does not have an ID.");
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean(partition.runCallbackIfFutureReplicaCaughtUp((Function1<AbstractLog, BoxedUnit>)(Function1<AbstractLog, Object> & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.trace((Function0<String> & Serializable)() -> "Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError(reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1<Tuple2, PromotionState> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    InitialFetchState state = (InitialFetchState)tuple2._2();
                    Option<Uuid> topicId = state.topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(tuple2);
            });
            set = super.addPartitions(filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$2, AbstractLog x$2) {
        Uuid targetDir = partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$2.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(tuple2);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        String x$1 = name;
        String x$2 = name;
        LeaderEndPoint x$3 = leader;
        TierStateMachine x$4 = new TierStateMachine(leader, replicaMgr, false);
        FailedPartitions x$5 = failedPartitions;
        PausedPartitions x$6 = pausedPartitions;
        ExponentialBackoff x$7 = exponentialBackoff;
        boolean x$8 = false;
        BrokerTopicStats x$9 = brokerTopicStats;
        Map<String, String> x$10 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$10();
        super(x$1, x$2, x$3, x$5, x$6, x$7, x$4, false, x$9, x$10);
        this.promotionStates = new ConcurrentHashMap();
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        @Override
        public String productPrefix() {
            return "PromotionState";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PromotionState)) return false;
            boolean bl = true;
            if (!bl) return false;
            PromotionState promotionState = (PromotionState)x$1;
            ReassignmentState reassignmentState = this.reassignmentState();
            ReassignmentState reassignmentState2 = promotionState.reassignmentState();
            if (reassignmentState == null) {
                if (reassignmentState2 != null) {
                    return false;
                }
            } else if (!reassignmentState.equals(reassignmentState2)) return false;
            Option<Uuid> option = this.topicId();
            Option<Uuid> option2 = promotionState.topicId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Uuid> option3 = this.currentDir();
            Option<Uuid> option4 = promotionState.currentDir();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!promotionState.canEqual(this)) return false;
            return true;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$(this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

