/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherManager$;
import kafka.server.BrokerBlockingSender;
import kafka.server.BrokerBlockingSender$;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherPool;
import kafka.server.FollowerFetchThrottler;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaFetcherManager$;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\n\u0014\u0001aA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tI\u0001\u0011)\u0019!C\tK!A\u0011\u0006\u0001B\u0001B\u0003%a\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"AQ\r\u0001B\u0001B\u0003%a\rC\u0003k\u0001\u0011\u00051\u000eC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\u0016\u0001!\t%a\u0006\b\u0013\u0005}1#!A\t\u0002\u0005\u0005b\u0001\u0003\n\u0014\u0003\u0003E\t!a\t\t\r)|A\u0011AA\u0016\u0011%\ticDI\u0001\n\u0003\tyCA\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u0005Q)\u0012AB:feZ,'OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0007iYR$D\u0001\u0014\u0013\ta2C\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s!\tQb$\u0003\u0002 '\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"A\u0007\u0012\n\u0005\r\u001a\"aC&bM.\f7i\u001c8gS\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001'!\tQr%\u0003\u0002)'\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgB\u0011A&N\u0007\u0002[)\u0011!F\f\u0006\u0003_A\naaY8n[>t'B\u0001\f2\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\n\u0005Yj#aB'fiJL7m]\u0001\u0005i&lW\r\u0005\u0002:y5\t!H\u0003\u0002<]\u0005)Q\u000f^5mg&\u0011QH\u000f\u0002\u0005)&lW-\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB\u0019\u0001iQ#\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013aa\u00149uS>t\u0007C\u0001$N\u001d\t95\n\u0005\u0002I\u00036\t\u0011J\u0003\u0002K/\u00051AH]8pizJ!\u0001T!\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019\u0006\u000bA\"];pi\u0006l\u0015M\\1hKJ\u0004\"A\u0007*\n\u0005M\u001b\"a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002W56\tqK\u0003\u0002Y3\u0006!Q\u000f^5m\u0015\t!\u0002'\u0003\u0002\\/\nI1k\u00195fIVdWM]\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u00042\u0001\u00110a\u0013\ty\u0016IA\u0005Gk:\u001cG/[8oaA\u0011\u0011mY\u0007\u0002E*\u0011q&W\u0005\u0003I\n\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0014EJ|7.\u001a:Fa>\u001c\u0007nU;qa2LWM\u001d\t\u0004\u0001z;\u0007C\u0001!i\u0013\tI\u0017I\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\b\u0006\u0006m[:|\u0007/\u001d:tiV\u0004\"A\u0007\u0001\t\u000b\u0001Z\u0001\u0019A\u0011\t\u000b\u0011Z\u0001\u0019\u0001\u0014\t\u000b)Z\u0001\u0019A\u0016\t\u000b]Z\u0001\u0019\u0001\u001d\t\u000fyZ\u0001\u0013!a\u0001\u007f!)\u0001k\u0003a\u0001#\")Ak\u0003a\u0001+\")Al\u0003a\u0001;\")Qm\u0003a\u0001M\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR)Q\u0004_?\u0002\f!)\u0011\u0010\u0004a\u0001u\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\t\u0003\u0001nL!\u0001`!\u0003\u0007%sG\u000fC\u0003\u007f\u0019\u0001\u0007q0\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!W\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI!a\u0001\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"9\u0011Q\u0002\u0007A\u0002\u0005=\u0011a\u00034fi\u000eDWM\u001d)p_2\u00042AGA\t\u0013\r\t\u0019b\u0005\u0002\f\r\u0016$8\r[3s!>|G.\u0001\u0005tQV$Hm\\<o)\t\tI\u0002E\u0002A\u00037I1!!\bB\u0005\u0011)f.\u001b;\u0002+I+\u0007\u000f\\5dC\u001a+Go\u00195fe6\u000bg.Y4feB\u0011!dD\n\u0004\u001f\u0005\u0015\u0002c\u0001!\u0002(%\u0019\u0011\u0011F!\u0003\r\u0005s\u0017PU3g)\t\t\t#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003cQ3aPA\u001aW\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0013Ut7\r[3dW\u0016$'bAA \u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Function0<Object> brokerEpochSupplier;

    public static Option<String> $lessinit$greater$default$5() {
        return ReplicaFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
        String prefix = (String)this.threadNamePrefix.map((Function1<String, String> & Serializable)tp -> tp + ":").getOrElse((Function0<String> & Serializable)() -> "");
        String threadName = prefix + "ReplicaFetcherThread-" + fetcherId + "-" + sourceBroker.id() + "-" + fetcherPool.name();
        Map tags = (Map)Map$.MODULE$.empty();
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (!(fetchConnectionsMode != null ? !fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$) : fetchConnectionsMode$Isolated$ != null)) {
            tags = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("FetcherPool"), fetcherPool.name())}));
        }
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + this.brokerConfig.brokerId() + ", leaderId=" + sourceBroker.id() + ", fetcherId=" + fetcherId + "] ");
        BrokerBlockingSender endpoint = BrokerBlockingSender$.MODULE$.apply(sourceBroker, this.brokerConfig, this.metrics, this.time, fetcherId, "broker-" + this.brokerConfig.brokerId() + "-fetcher-" + fetcherId, logContext, tags);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, sourceBroker.id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(this.brokerConfig, this.metadataVersionSupplier, this.brokerEpochSupplier);
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), endpoint, fetchSessionHandler, requestBuilder, throttler, this.brokerConfig, this.replicaManager(), this.quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(this.brokerConfig.replicaFetchBackoffMs().longValue(), 2, this.brokerConfig.replicaFetchBackoffMaxMs().longValue(), 0.0);
        String x$1 = threadName;
        int x$2 = fetcherId;
        RemoteLeaderEndPoint x$3 = leader;
        KafkaConfig x$4 = this.brokerConfig;
        FailedPartitions x$5 = this.failedPartitions();
        PausedPartitions x$6 = this.pausedPartitions();
        ExponentialBackoff x$7 = exponentialBackoff;
        ReplicaManager x$8 = this.replicaManager();
        ReplicationQuotaManager x$9 = this.quotaManager;
        Map x$10 = tags;
        Option<LogContext> x$11 = ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
        return new ReplicaFetcherThread(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$11, x$10);
    }

    @Override
    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "shutting down");
        super.shutdown();
        this.info((Function0<String> & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager, Scheduler scheduler, Function0<MetadataVersion> metadataVersionSupplier, Function0<Object> brokerEpochSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.brokerEpochSupplier = brokerEpochSupplier;
        String x$1 = "ReplicaFetcherManager on broker " + brokerConfig.brokerId();
        String x$2 = "Replica";
        int x$3 = brokerConfig.numReplicaFetchers();
        FetchConnectionsMode x$4 = brokerConfig.replicaFetchConnectionsMode();
        Some<Scheduler> x$5 = new Some<Scheduler>(scheduler);
        ApiMessageType.ApiVisibility apiVisibility = brokerConfig.apiVisibility();
        ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
        boolean x$6 = !(apiVisibility != null ? !apiVisibility.equals(apiVisibility2) : apiVisibility2 != null);
        Map<String, String> x$7 = AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6();
        super(x$1, "Replica", x$3, x$4, x$5, x$7, x$6);
    }
}

