/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.storage.log.AbstractLog;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.OffsetTruncationState;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tub\u0001\u0002\u0015*\u00019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Ia\t\u0001B\u0001B\u0003%q)\u0015\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\")Q\u0010\u0001C\u0001}\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\b\u00037\u0001\u0001\u0015!\u0003C\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002C\u0004\u0002\"\u0001\u0001\u000b\u0011B:\t\u0015\u0005\r\u0002A1A\u0005\u0002%\n)\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0014\u0011%\ti\u0004\u0001b\u0001\n#\ny\u0004\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA!\u0011\u001d\tI\u0005\u0001C)\u0003\u0017Bq!!\u001c\u0001\t#\ny\u0007C\u0004\u0002z\u0001!\t&a\u001f\t\u000f\u0005}\u0004\u0001\"\u0015\u0002\u0002\"9\u0011Q\u0013\u0001\u0005R\u0005]\u0005bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t\t\f\u0001C!\u0003_Cq!a-\u0001\t\u0003\n)\f\u0003\u0005\u0002d\u0002!\t!KAX\u0011\u001d\t)\u000f\u0001C!\u0003ODq!a>\u0001\t#\tI\u0010C\u0004\u0003\u0004\u0001!\tF!\u0002\t\u001b\t5\u0001\u0001%A\u0002\u0002\u0003%IAa\u0004R\u000f%\u0011\t\"KA\u0001\u0012\u0003\u0011\u0019B\u0002\u0005)S\u0005\u0005\t\u0012\u0001B\u000b\u0011\u0019iH\u0005\"\u0001\u0003\u001e!I!q\u0004\u0013\u0012\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0005o!\u0013\u0013!C\u0001\u0005s\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'B\u0001\u0016,\u0003\u0019\u0019XM\u001d<fe*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00192\u001b\u0005I\u0013B\u0001\u001a*\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0011QG\u0010\b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR!!O\u0017\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uR\u0014!\u00034fi\u000eDWM]%e!\t\u0019E)D\u0001;\u0013\t)%HA\u0002J]R\fa\u0001\\3bI\u0016\u0014\bC\u0001%P\u001b\u0005I%B\u0001\u0016K\u0015\ta3J\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<\u0017B\u0001)J\u00059aU-\u00193fe\u0016sG\rU8j]RL!AR\u0019\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005A\"\u0016BA+*\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u0019Y\u0013\tI\u0016F\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\u0001\u0002/Y;tK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003aqK!!X\u0015\u0003!A\u000bWo]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018AE3ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0011T\u0015AB2p[6|g.\u0003\u0002gC\n\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003a%L!A[\u0015\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011\u0001'\\\u0005\u0003]&\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fQ\u0002\\8h\u0007>tG/\u001a=u\u001fB$\bcA\"rg&\u0011!O\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001$\u0018BA;b\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0010Kb$(/Y'fiJL7\rV1hgB!\u0001p\u001f\u001b5\u001b\u0005I(B\u0001>;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003yf\u00141!T1q\u0003\u0019a\u0014N\\5u}Q9r0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011Q\u0003\t\u0003a\u0001AQa\r\u0007A\u0002QBQ!\u0011\u0007A\u0002\tCQA\u0012\u0007A\u0002\u001dCQA\u0015\u0007A\u0002MCQA\u0016\u0007A\u0002]CQA\u0017\u0007A\u0002mCQA\u0018\u0007A\u0002}CQa\u001a\u0007A\u0002!DQa\u001b\u0007A\u00021Dqa\u001c\u0007\u0011\u0002\u0003\u0007\u0001\u000fC\u0004w\u0019A\u0005\t\u0019A<\u0002\u0013I,\u0007\u000f\\5dC&#W#\u0001\"\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\u0012a]\u0001\fY><7i\u001c8uKb$\b%\u0001\u0010qCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5OK^D\u0015n\u001a5XCR,'/\\1sWV\u0011\u0011q\u0005\t\u0007\u0003S\ty#a\r\u000e\u0005\u0005-\"bAA\u0017s\u00069Q.\u001e;bE2,\u0017\u0002BA\u0019\u0003W\u0011aAQ;gM\u0016\u0014\b\u0003BA\u001b\u0003oi\u0011aY\u0005\u0004\u0003s\u0019'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001 a\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<\b*[4i/\u0006$XM]7be.\u0004\u0013!\u0007;sC:\u001c\u0018\u000e^5p]R{\u0007+^:i'V\u0004\bo\u001c:uK\u0012,\"!!\u0011\u0011\u0007\r\u000b\u0019%C\u0002\u0002Fi\u0012qAQ8pY\u0016\fg.\u0001\u000eue\u0006t7/\u001b;j_:$v\u000eU;tQN+\b\u000f]8si\u0016$\u0007%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BA'\u0003S\u0002b!a\u0014\u0002Z\u0005uSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003/\nAA[1wC&!\u00111LA)\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\t\u0005\r\u0014QK\u0001\u0005Y\u0006tw-\u0003\u0003\u0002h\u0005\u0005$aB%oi\u0016<WM\u001d\u0005\b\u0003W*\u0002\u0019AA\u001a\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002r\u0005]\u0004cA\"\u0002t%\u0019\u0011Q\u000f\u001e\u0003\t1{gn\u001a\u0005\b\u0003W2\u0002\u0019AA\u001a\u00031awnZ#oI>3gm]3u)\u0011\t\t(! \t\u000f\u0005-t\u00031\u0001\u00024\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005\r\u0015qRAI!\u0019\ty%!\u0017\u0002\u0006B!\u0011qQAF\u001b\t\tII\u0003\u0002e\u0013&!\u0011QRAE\u00059yeMZ:fi\u0006sG-\u00129pG\"Dq!a\u001b\u0019\u0001\u0004\t\u0019\u0004\u0003\u0004\u0002\u0014b\u0001\rAQ\u0001\u0006KB|7\r[\u0001\u001aG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018p\u00144gg\u0016$8\u000f\u0006\u0003\u0002\u001a\u0006}\u0005cA\"\u0002\u001c&\u0019\u0011Q\u0014\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003CK\u0002\u0019AAR\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b#\u0002=\u0002&\u0006M\u0012bAATs\n\u00191+Z9\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA!\u00035\tw/Y5u'\",H\u000fZ8x]R\u0011\u0011\u0011T\u0001\u0007I><vN]6\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b))\t9,!4\u0002P\u0006M\u0017q\u001b\t\u0005\u0007F\fI\f\u0005\u0003\u0002<\u0006%WBAA_\u0015\u0011\ty,!1\u0002\u00071|wM\u0003\u0003\u0002D\u0006\u0015\u0017!C5oi\u0016\u0014h.\u00197t\u0015\r\t9MS\u0001\bgR|'/Y4f\u0013\u0011\tY-!0\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\tY'\ba\u0001\u0003gAq!!5\u001e\u0001\u0004\t\t(A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bBBAk;\u0001\u0007!)\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u00033l\u0002\u0019AAn\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011Q\\Ap\u001b\u0005\u0001\u0011bAAqc\tIa)\u001a;dQ\u0012\u000bG/Y\u0001\u001dG>l\u0007\u000f\\3uK\u0012+G.Y=fI\u001a+Go\u00195SKF,Xm\u001d;t\u0003!!(/\u001e8dCR,GCBA!\u0003S\fi\u000fC\u0004\u0002l~\u0001\r!a\r\u0002\u0005Q\u0004\bbBAx?\u0001\u0007\u0011\u0011_\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\rA\u00151_\u0005\u0004\u0003kL%!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\rI>$&/\u001e8dCRLwN\u001c\u000b\t\u0003\u0003\nY0!@\u0002\u0000\"9\u00111\u001e\u0011A\u0002\u0005M\u0002bBAxA\u0001\u0007\u0011\u0011\u001f\u0005\b\u0005\u0003\u0001\u0003\u0019AA!\u0003!I7/T5se>\u0014\u0018a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0019\tIJa\u0002\u0003\n!9\u00111N\u0011A\u0002\u0005M\u0002b\u0002B\u0006C\u0001\u0007\u0011\u0011O\u0001\u0007_\u001a47/\u001a;\u0002\u0019M,\b/\u001a:%Y\u0016\fG-\u001a:\u0016\u0003\u001d\u000bACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$\u0007C\u0001\u0019%'\r!#q\u0003\t\u0004\u0007\ne\u0011b\u0001B\u000eu\t1\u0011I\\=SK\u001a$\"Aa\u0005\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU\u0011!1\u0005\u0016\u0004a\n\u00152F\u0001B\u0014!\u0011\u0011ICa\r\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE\"(\u0001\u0006b]:|G/\u0019;j_:LAA!\u000e\u0003,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132cU\u0011!1\b\u0016\u0004o\n\u0015\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean transitionToPushSupported;

    public static Map<String, String> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<LogContext> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public void checkpointRecoveryOffsets(Seq<TopicPartition> topicPartitions) {
        if (topicPartitions.isEmpty()) {
            return;
        }
        Object affectedLogs = ArrayBuffer$.MODULE$.empty();
        topicPartitions.foreach(arg_0 -> ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1$adapted(this, (ArrayBuffer)affectedLogs, arg_0));
        ((IterableOnceOps)((SeqOps)((ArrayBuffer)affectedLogs).map((Function1<AbstractLog, File> & Serializable)x$1 -> x$1.parentDirFile())).distinct()).foreach((Function1<File, Object> & Serializable)dir -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$4(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean initiateShutdown() {
        boolean justShutdown;
        block2: {
            justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "Failed to initiate shutdown of leader endpoint " + this.super$leader() + " after initiating replica fetcher thread shutdown", (Function0<Throwable> & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable)() -> "Failed to close leader endpoint " + this.super$leader() + " after shutting down replica fetcher thread", (Function0<Throwable> & Serializable)() -> t);
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Option<LogAppendInfo> logAppendInfo;
        block0: {
            MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
            logAppendInfo = this.replicaMgr.appendRecordsToFollowerReplica(topicPartition, fetchOffset, AppendOrigin.REPLICATION, -1L, Optional.of(Predef$.MODULE$.int2Integer(partitionLeaderEpoch)), records, partitionData.highWatermark(), Optional.of(BoxesRunTime.boxToLong(partitionData.logStartOffset())), this.quota);
            Object object = logAppendInfo.exists((Function1<LogAppendInfo, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(ReplicaFetcherThread.$anonfun$processPartitionData$1(x$2))) ? this.partitionsWithNewHighWatermark().$plus$eq(topicPartition) : BoxedUnit.UNIT;
            if (records.sizeInBytes() <= 0) break block0;
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests(this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        return this.doTruncation(tp, offsetTruncationState, false);
    }

    public boolean doTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState, boolean isMirror) {
        block6: {
            Partition partition = this.replicaMgr.getPartitionOrException(tp);
            AbstractLog log = partition.localLogOrException();
            if (offsetTruncationState.offset() < log.highWatermark()) {
                if (!partition.isUncleanLeader()) {
                    if (partition.isActiveLinkDestinationLeader()) {
                        this.replicaMgr.clusterLinkTruncationBelowHWM().mark();
                    } else {
                        this.replicaMgr.truncationBelowHWM().mark();
                    }
                }
                this.warn((Function0<String> & Serializable)() -> "Truncating " + tp + " to offset " + offsetTruncationState.offset() + " below high watermark " + log.highWatermark());
            }
            if (isMirror) {
                partition.truncateMirrorTo(offsetTruncationState.offset(), false, false, true);
            } else {
                partition.truncateTo(offsetTruncationState.offset(), false, false);
            }
            if (!offsetTruncationState.truncationCompleted()) break block6;
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$1(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        Option<AbstractLog> log = $this.replicaMgr.getLog(tp);
        if (log != null) {
            log.foreach((Function1<AbstractLog, ArrayBuffer> & Serializable)l -> (ArrayBuffer)affectedLogs$1.$plus$eq(l));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$4(ReplicaFetcherThread $this, File dir) {
        $this.replicaMgr.logManager().checkpointRecoveryOffsetsInDir(dir);
    }

    public static final /* synthetic */ boolean $anonfun$processPartitionData$1(LogAppendInfo x$2) {
        LeaderHwChange leaderHwChange = x$2.leaderHwChange();
        LeaderHwChange leaderHwChange2 = LeaderHwChange.INCREASED;
        return !(leaderHwChange != null ? !((Object)((Object)leaderHwChange)).equals((Object)leaderHwChange2) : leaderHwChange2 != null);
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, new ConfluentReplicaFetcherTierStateMachine(leader, replicaMgr, exponentialBackoff), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0<LogContext> & Serializable)() -> new LogContext("[ReplicaFetcher replicaId=" + this.replicaId() + ", leaderId=" + this.super$leader().brokerEndPoint().id() + ", fetcherId=" + $this.fetcherId + "] "));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.transitionToPushSupported = true;
    }

    public static final /* synthetic */ Object $anonfun$checkpointRecoveryOffsets$1$adapted(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1($this, affectedLogs$1, tp);
        return BoxedUnit.UNIT;
    }
}

