/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.common.EvenClusterLoadPlanBrokerStats;
import kafka.common.EvenClusterLoadPlanGoalStats;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadPlanRejectingGoal;
import kafka.network.RequestChannel;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.metadata.MetadataCache;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RequestHandlerHelper$
implements Logging {
    public static final RequestHandlerHelper$ MODULE$ = new RequestHandlerHelper$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RequestHandlerHelper$ requestHandlerHelper$ = this;
        synchronized (requestHandlerHelper$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String routingPathPrefixOrNull(RequestContext context) {
        PathAwareSniHostName sniHostName = context.sniHostName;
        if (sniHostName != null && sniHostName.routingPathPrefix() != null) {
            return sniHostName.routingPathPrefix() + "-";
        }
        return null;
    }

    public void validateAlterBrokerReplicaExclusionRequest(AlterBrokerReplicaExclusionsRequest request) {
        Object brokerIds = CollectionConverters$.MODULE$.ListHasAsScala(request.data().brokersToExclude()).asScala().toList().map((Function1<AlterBrokerReplicaExclusionsRequestData.BrokerExclusion, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.brokerId()));
        if (((List)brokerIds).isEmpty()) {
            throw new InvalidBrokerReplicaExclusionException("At least one broker must be provided for exclusion");
        }
        if (((List)brokerIds).exists(x$2 -> x$2 < 0)) {
            throw new UnrepresentableBrokerIdException("Invalid broker ids specified: " + (List)((List)brokerIds).filter(x$3 -> x$3 < 0));
        }
        if (((AbstractSeq)brokerIds).size() != ((AbstractIterable)brokerIds).toSet().size()) {
            throw new InvalidBrokerReplicaExclusionException("Cannot have duplicate broker ids in the same exclusion request.");
        }
        CollectionConverters$.MODULE$.ListHasAsScala(request.data().brokersToExclude()).asScala().foreach((Function1<AlterBrokerReplicaExclusionsRequestData.BrokerExclusion, Object> & Serializable)exclusion -> {
            RequestHandlerHelper$.$anonfun$validateAlterBrokerReplicaExclusionRequest$4(exclusion);
            return BoxedUnit.UNIT;
        });
    }

    public void validateRemoveBrokersRequest(RemoveBrokersRequest request) {
        Object brokersToRemove = CollectionConverters$.MODULE$.ListHasAsScala(request.data().brokersToRemove()).asScala().toList().map((Function1<RemoveBrokersRequestData.BrokerId, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.brokerId()));
        if (((List)brokersToRemove).isEmpty()) {
            throw new InvalidBrokerRemovalException("At least one broker id need to be specified.");
        }
        if (((AbstractSeq)brokersToRemove).size() != ((AbstractIterable)brokersToRemove).toSet().size()) {
            throw new InvalidBrokerRemovalException("Cannot have duplicate broker ids in the same broker removal request.");
        }
        Object invalidBrokers = ((List)brokersToRemove).filter(x$5 -> x$5 < 0);
        if (((AbstractIterable)invalidBrokers).nonEmpty()) {
            throw new UnrepresentableBrokerIdException("Invalid broker ids specified: " + (List)invalidBrokers);
        }
    }

    public ComputeEvenClusterLoadPlanResponseData convertEvenClusterLoadPlanInternalToResponseData(EvenClusterLoadPlanInternal plan) {
        return new ComputeEvenClusterLoadPlanResponseData().setInterBrokerMoves(plan.movementStats().interBrokerMoves()).setInterBrokerMovesMB(plan.movementStats().interBrokerMovesMB()).setLeadershipMoves(plan.movementStats().leadershipMoves()).setRecentWindows(plan.clusterRelatedStats().recentWindows()).setPartitionCoveragePercent(plan.clusterRelatedStats().partitionCoveragePercent()).setNewBrokers(plan.brokerRelatedStats().newBrokers()).setDeadOrRemovedBrokers(plan.brokerRelatedStats().deadOrRemovedBrokers()).setViolatedGoalsBeforeOptimization(plan.goalRelatedStats().violatedGoalsBeforeOptimization()).setViolatedGoalsAfterOptimization(plan.goalRelatedStats().violatedGoalsAfterOptimization()).setMovementGeneratingGoals(plan.goalRelatedStats().movementGeneratingGoals()).setExcludedTopics(plan.clusterRelatedStats().excludedTopics()).setBrokersExcludedForLeadership(plan.brokerRelatedStats().brokersExcludedForLeadership()).setBrokersExcludedForReplicaMove(plan.brokerRelatedStats().brokersExcludedForReplicaMove()).setTotalBrokers(plan.clusterRelatedStats().totalBrokers()).setTotalReplicas(plan.clusterRelatedStats().totalReplicas()).setTotalTopics(plan.clusterRelatedStats().totalTopics()).setBalancednessScorePreRebalance(plan.clusterBalancedness().balancednessScorePreRebalance()).setBalancednessScorePostRebalance(plan.clusterBalancedness().balancednessScorePostRebalance()).setGoalStats(CollectionConverters$.MODULE$.SeqHasAsJava(this.convertPlanGoalStatsToResponseData(plan)).asJava()).setClusterLoadPreRebalance(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(plan.clusterBalancedness().clusterLoadPreRebalance()).asScala().map((Function1<EvenClusterLoadPlanBrokerStats, ComputeEvenClusterLoadPlanResponseData.PreBrokerStat> & Serializable)bs -> new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(bs.brokerId()).setHost(bs.host()).setDiskMB(bs.diskMB()).setDiskPercent(bs.diskPercent()).setCpuPercent(bs.cpuPercent()).setLeaderNetworkInKBps(bs.leaderNetworkInKBps()).setFollowerNetworkInKBps(bs.followerNetworkInKBps()).setNetworkOutKBps(bs.networkOutKBps()).setPotentialNetworkOutKBps(bs.potentialNetworkOutKBps()).setLeaders(bs.leaders()).setReplicas(bs.replicas()))).toList()).asJava()).setClusterLoadPostRebalance(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(plan.clusterBalancedness().clusterLoadPostRebalance()).asScala().map((Function1<EvenClusterLoadPlanBrokerStats, ComputeEvenClusterLoadPlanResponseData.PostBrokerStat> & Serializable)bs -> new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(bs.brokerId()).setHost(bs.host()).setDiskMB(bs.diskMB()).setDiskPercent(bs.diskPercent()).setCpuPercent(bs.cpuPercent()).setLeaderNetworkInKBps(bs.leaderNetworkInKBps()).setFollowerNetworkInKBps(bs.followerNetworkInKBps()).setNetworkOutKBps(bs.networkOutKBps()).setPotentialNetworkOutKBps(bs.potentialNetworkOutKBps()).setLeaders(bs.leaders()).setReplicas(bs.replicas()))).toList()).asJava());
    }

    public void maybePopulateBrokerZonesInContext(RequestChannel.Request request, MetadataCache metadataCache) {
        if (request.context().isPpv2EndpointSchemeEnabled() && request.context().isPpv2EndpointSchemeMapBrokerToGatewayZoneEnabled()) {
            Buffer<Node> nodes = CollectionConverters$.MODULE$.ListHasAsScala(metadataCache.getAliveBrokerNodes(new ListenerName(request.context().listenerName()))).asScala();
            Set brokerZones = (Set)Option$.MODULE$.apply(((IterableOnceOps)nodes.map((Function1<Node, String> & Serializable)x$6 -> x$6.rack())).toSet()).getOrElse((Function0<Set> & Serializable)() -> (Set)Set$.MODULE$.empty());
            this.debug((Function0<String> & Serializable)() -> "For request " + request.requestDesc(true) + " from connection " + request$1.context().connectionId + ", the broker-zones are " + brokerZones.mkString("Array(", ", ", ")"));
            request.context().setAllBrokerZones(CollectionConverters$.MODULE$.SetHasAsJava(brokerZones).asJava());
            return;
        }
    }

    private List<ComputeEvenClusterLoadPlanResponseData.GoalStat> convertPlanGoalStatsToResponseData(EvenClusterLoadPlanInternal plan) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(plan.goalRelatedStats().goalStats()).asScala().map((Function1<EvenClusterLoadPlanGoalStats, ComputeEvenClusterLoadPlanResponseData.GoalStat> & Serializable)gs -> new ComputeEvenClusterLoadPlanResponseData.GoalStat().setGoalName(gs.goalName()).setAvgResources(new ComputeEvenClusterLoadPlanResponseData.AvgResources().setCpuPercent(gs.avgResources().cpuPercent()).setNetworkInboundKBps(gs.avgResources().networkInboundKBps()).setProducerInboundKBps(gs.avgResources().producerInboundKBps()).setConsumerOutboundKBps(gs.avgResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.avgResources().networkOutboundKBps()).setDiskMB(gs.avgResources().diskMB()).setPotentialNwOutKBps(gs.avgResources().potentialNwOutKBps()).setReplicas(gs.avgResources().replicas()).setLeaderReplicas(gs.avgResources().leaderReplicas()).setTopicReplicas(gs.avgResources().topicReplicas())).setMaxResources(new ComputeEvenClusterLoadPlanResponseData.MaxResources().setCpuPercent(gs.maxResources().cpuPercent()).setNetworkInboundKBps(gs.maxResources().networkInboundKBps()).setProducerInboundKBps(gs.maxResources().producerInboundKBps()).setConsumerOutboundKBps(gs.maxResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.maxResources().networkOutboundKBps()).setDiskMB(gs.maxResources().diskMB()).setPotentialNwOutKBps(gs.maxResources().potentialNwOutKBps()).setReplicas(gs.maxResources().replicas()).setLeaderReplicas(gs.maxResources().leaderReplicas()).setTopicReplicas(gs.maxResources().topicReplicas())).setMinResources(new ComputeEvenClusterLoadPlanResponseData.MinResources().setCpuPercent(gs.minResources().cpuPercent()).setNetworkInboundKBps(gs.minResources().networkInboundKBps()).setProducerInboundKBps(gs.minResources().producerInboundKBps()).setConsumerOutboundKBps(gs.minResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.minResources().networkOutboundKBps()).setDiskMB(gs.minResources().diskMB()).setPotentialNwOutKBps(gs.minResources().potentialNwOutKBps()).setReplicas(gs.minResources().replicas()).setLeaderReplicas(gs.minResources().leaderReplicas()).setTopicReplicas(gs.minResources().topicReplicas())).setStdResources(new ComputeEvenClusterLoadPlanResponseData.StdResources().setCpuPercent(gs.stdResources().cpuPercent()).setNetworkInboundKBps(gs.stdResources().networkInboundKBps()).setProducerInboundKBps(gs.stdResources().producerInboundKBps()).setConsumerOutboundKBps(gs.stdResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.stdResources().networkOutboundKBps()).setDiskMB(gs.stdResources().diskMB()).setPotentialNwOutKBps(gs.stdResources().potentialNwOutKBps()).setReplicas(gs.stdResources().replicas()).setLeaderReplicas(gs.stdResources().leaderReplicas()).setTopicReplicas(gs.stdResources().topicReplicas())).setGoalOverview(new ComputeEvenClusterLoadPlanResponseData.GoalOverview().setGoalStatus(gs.goalOverview().goalStatus()).setRejectingGoals(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(gs.goalOverview().rejectingGoals()).asScala().map((Function1<EvenClusterLoadPlanRejectingGoal, ComputeEvenClusterLoadPlanResponseData.RejectingGoal> & Serializable)rg -> new ComputeEvenClusterLoadPlanResponseData.RejectingGoal().setGoalName(rg.goalName()).setProposalsRejected(rg.proposalsRejected()))).toList()).asJava()).setProposalsGenerated(gs.goalOverview().proposalsGenerated()).setProposalsRejected(gs.goalOverview().proposalsRejected()).setProposalsRejectedPercent(gs.goalOverview().proposalsRejectedPercent()).setProposalsAccepted(gs.goalOverview().proposalsAccepted()).setProposalsAcceptedPercent(gs.goalOverview().proposalsAcceptedPercent()).setMoves(gs.goalOverview().moves()).setSwaps(gs.goalOverview().swaps())))).toList();
    }

    public static final /* synthetic */ void $anonfun$validateAlterBrokerReplicaExclusionRequest$4(AlterBrokerReplicaExclusionsRequestData.BrokerExclusion exclusion) {
        ExclusionOp.OpType opType;
        byte opCode = exclusion.exclusionOperationCode();
        ExclusionOp.OpType opType2 = opType = ExclusionOp.OpType.forId((byte)opCode);
        ExclusionOp.OpType opType3 = ExclusionOp.OpType.UNKNOWN;
        if (!(opType2 != null ? !opType2.equals(opType3) : opType3 != null)) {
            throw new InvalidBrokerReplicaExclusionException("Could not recognize exclusion operation code " + opCode);
        }
        String reason = exclusion.reason();
        try {
            ExclusionRequestUtils.validateReason((String)reason);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBrokerReplicaExclusionException("Invalid reason supplied for replica exclusions", (Throwable)e);
        }
    }

    private RequestHandlerHelper$() {
    }
}

