/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.google.common.base.Throwables;
import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.model.CoreV1Environment;
import io.confluent.flink.apiserver.client.model.CoreV1OrgList;
import java.io.EOFException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalMetadataClient$;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmClientCommandOptions;
import kafka.server.RmRegionalMetadataClient;
import kafka.server.Subscription;
import kafka.server.Subscription$SubscriptionFactory$;
import kafka.server.Watch;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class RmRegionalMetadataClient$
implements Logging {
    public static final RmRegionalMetadataClient$ MODULE$ = new RmRegionalMetadataClient$();
    private static final String kafka$server$RmRegionalMetadataClient$$METRICS_GROUP;
    private static final String kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR;
    private static final String kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR;
    private static final int kafka$server$RmRegionalMetadataClient$$maxRetries;
    private static final Function1<Throwable, Object> retryOnConnectionError;
    private static final Set<String> mtSkuSet;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        kafka$server$RmRegionalMetadataClient$$METRICS_GROUP = "rm-client";
        kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR = "rm-call-count-sensor";
        kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR = "rm-error-count-sensor";
        kafka$server$RmRegionalMetadataClient$$maxRetries = 5;
        retryOnConnectionError = (Function1<Throwable, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(RmRegionalMetadataClient$.$anonfun$retryOnConnectionError$1(e));
        mtSkuSet = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ENTERPRISE", "BASIC", "STANDARD"}));
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RmRegionalMetadataClient$ rmRegionalMetadataClient$ = this;
        synchronized (rmRegionalMetadataClient$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String kafka$server$RmRegionalMetadataClient$$METRICS_GROUP() {
        return kafka$server$RmRegionalMetadataClient$$METRICS_GROUP;
    }

    public String kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR() {
        return kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR;
    }

    public String kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR() {
        return kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR;
    }

    public int kafka$server$RmRegionalMetadataClient$$maxRetries() {
        return kafka$server$RmRegionalMetadataClient$$maxRetries;
    }

    public Function1<Throwable, Object> retryOnConnectionError() {
        return retryOnConnectionError;
    }

    public Set<String> mtSkuSet() {
        return mtSkuSet;
    }

    private boolean isConnectionException(ApiException e) {
        Throwable rootCause = Throwables.getRootCause(e);
        return rootCause instanceof SocketException || rootCause instanceof SocketTimeoutException || rootCause instanceof EOFException;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while executing RM client: " + e.getMessage());
                e.printStackTrace();
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args) {
        Metrics metrics = new Metrics();
        RmClientCommandOptions opts = new RmClientCommandOptions(args);
        opts.checkArgs();
        Properties properties = Utils.loadProps((String)opts.options.valueOf(opts.brokerConfigOpt()));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(properties);
        RmRegionalMetadataClient rmRegionalMetadataClient = new RmRegionalMetadataClient(brokerConfig, metrics);
        try {
            try {
                System.out.println("Configuring RM Regional Metadata Client");
                rmRegionalMetadataClient.configure(brokerConfig.values());
                System.out.println("Configured RM Regional Metadata Client");
                if (opts.options.has(opts.watchOpt())) {
                    System.out.println("Configuring Watch");
                    Subscription<CoreV1Environment> subscription = Subscription$SubscriptionFactory$.MODULE$.newEnvSubscriptionBuilder(true).build();
                    Function1<Throwable, Nothing$> & Serializable errorHandler = (Function1<Throwable, Nothing$> & Serializable)e -> {
                        throw e;
                    };
                    Function1<CoreV1Environment, Object> & Serializable changeHandler = (Function1<CoreV1Environment, Object> & Serializable)env -> {
                        System.out.println(env);
                        return BoxedUnit.UNIT;
                    };
                    CountDownLatch snapshotEnd = new CountDownLatch(1);
                    Watch envWatch = RegionalMetadataClient$.MODULE$.newSimpleWatch(() -> {
                        System.out.println("End of snapshot");
                        snapshotEnd.countDown();
                    }, changeHandler, (Function1<Throwable, BoxedUnit>)errorHandler);
                    AutoCloseable watch = rmRegionalMetadataClient.watch(subscription, envWatch);
                    System.out.println("Watch configured, sleeping for 30 seconds");
                    snapshotEnd.await(30L, TimeUnit.SECONDS);
                    watch.close();
                } else if (opts.options.has(opts.lkcOpt())) {
                    System.out.println("Getting LKC metadata for orgId: " + opts.options.valueOf(opts.orgIdOpt()) + " lkcId: " + opts.options.valueOf(opts.lkcIdOpt()));
                    CompletableFuture<Option<RegionalLkcMetadata>> lkc = rmRegionalMetadataClient.getLkcMetadata(opts.options.valueOf(opts.orgIdOpt()), opts.options.valueOf(opts.lkcIdOpt()));
                    if (lkc.get().isDefined()) {
                        RegionalLkcMetadata value = lkc.get().get();
                        System.out.println("LKC found=" + value);
                    } else {
                        System.out.println("No LKC found");
                    }
                } else if (opts.options.has(opts.networkOpt())) {
                    System.out.println("Getting Network metadata for orgId: " + opts.options.valueOf(opts.orgIdOpt()) + " envId: " + opts.options.valueOf(opts.envIdOpt()) + " networkId: " + opts.options.valueOf(opts.networkIdOpt()));
                    CompletableFuture<Option<RegionalNetworkMetadata>> network = rmRegionalMetadataClient.getNetworkMetadata(opts.options.valueOf(opts.orgIdOpt()), opts.options.valueOf(opts.envIdOpt()), opts.options.valueOf(opts.networkIdOpt()));
                    if (network.get().isDefined()) {
                        RegionalNetworkMetadata value = network.get().get();
                        System.out.println("Network found=" + value);
                    } else {
                        System.out.println("No Network found");
                    }
                } else {
                    CoreV1OrgList orgList = rmRegionalMetadataClient.coreApi().listCoreV1Orgs(null, null, null, null, null);
                    System.out.println(orgList.getItems());
                }
            }
            catch (Throwable e2) {
                Predef$.MODULE$.println("Error while issuing request");
                throw e2;
            }
        }
        finally {
            rmRegionalMetadataClient.close();
            metrics.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$retryOnConnectionError$1(Throwable e) {
        return e instanceof ApiException && MODULE$.isConnectionException((ApiException)e);
    }

    private RmRegionalMetadataClient$() {
    }
}

