/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents;
import kafka.server.link.ClusterLinkFactory;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class ReplicaManagerBuilder {
    private KafkaConfig config = null;
    private Metrics metrics = null;
    private Time time = Time.SYSTEM;
    private Scheduler scheduler = null;
    private LogManager logManager = null;
    private QuotaFactory.QuotaManagers quotaManagers = null;
    private MetadataCache metadataCache = null;
    private LogDirFailureChannel logDirFailureChannel = null;
    private AlterPartitionManager alterPartitionManager = null;
    private ActionQueue actionQueue = null;
    private Supplier<BrokerState> brokerState = null;
    private BrokerTopicStats brokerTopicStats = null;
    private TierReplicaComponents tierReplicaComponents = TierReplicaComponents.EMPTY();
    private Optional<ClusterLinkFactory.LinkManager> clusterLinkManager = Optional.empty();

    public ReplicaManagerBuilder setConfig(KafkaConfig config) {
        this.config = config;
        return this;
    }

    public ReplicaManagerBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ReplicaManagerBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public ReplicaManagerBuilder setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ReplicaManagerBuilder setLogManager(LogManager logManager) {
        this.logManager = logManager;
        return this;
    }

    public ReplicaManagerBuilder setQuotaManagers(QuotaFactory.QuotaManagers quotaManagers) {
        this.quotaManagers = quotaManagers;
        return this;
    }

    public ReplicaManagerBuilder setMetadataCache(MetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        return this;
    }

    public ReplicaManagerBuilder setLogDirFailureChannel(LogDirFailureChannel logDirFailureChannel) {
        this.logDirFailureChannel = logDirFailureChannel;
        return this;
    }

    public ReplicaManagerBuilder setAlterPartitionManager(AlterPartitionManager alterPartitionManager) {
        this.alterPartitionManager = alterPartitionManager;
        return this;
    }

    public ReplicaManagerBuilder setActionQueue(ActionQueue actionQueue) {
        this.actionQueue = actionQueue;
        return this;
    }

    public ReplicaManagerBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public ReplicaManagerBuilder setBrokerState(Supplier<BrokerState> brokerState) {
        this.brokerState = brokerState;
        return this;
    }

    public ReplicaManagerBuilder setTierReplicaComponents(TierReplicaComponents tierReplicaComponents) {
        this.tierReplicaComponents = tierReplicaComponents;
        return this;
    }

    public ReplicaManager build() {
        if (this.config == null) {
            this.config = new KafkaConfig(Map.of());
        }
        if (this.logManager == null) {
            throw new RuntimeException("You must set logManager");
        }
        if (this.metadataCache == null) {
            throw new RuntimeException("You must set metadataCache");
        }
        if (this.logDirFailureChannel == null) {
            throw new RuntimeException("You must set logDirFailureChannel");
        }
        if (this.alterPartitionManager == null) {
            throw new RuntimeException("You must set alterIsrManager");
        }
        if (this.actionQueue == null) {
            throw new RuntimeException("You must set actionQueue");
        }
        if (this.brokerState == null) {
            throw new RuntimeException("You must set brokerState");
        }
        if (this.brokerTopicStats == null) {
            this.brokerTopicStats = new BrokerTopicStats(false, this.config.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        }
        if (this.metrics == null) {
            this.metrics = new Metrics();
        }
        return new ReplicaManager(this.config, this.metrics, this.time, this.scheduler, this.logManager, this.quotaManagers, this.metadataCache, this.logDirFailureChannel, this.alterPartitionManager, this.actionQueue, this.brokerTopicStats, () -> this.brokerState.get(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), this.tierReplicaComponents, OptionConverters.toScala(this.clusterLinkManager), Option.empty(), Option.empty(), () -> -1L, Option.empty(), DirectoryEventHandler.NOOP);
    }
}

