/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import kafka.server.ClusterLinkQuotas;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkBatchAdmin$;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkCheckLinkAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskType;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcZZ$sp;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t%g!\u0002\u001e<\u0003\u0003\u0011\u0005\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011q\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005?\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!b\u0001\n\u0003Q\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011=\u0004!Q1A\u0005\u0002AD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\tw\u0002\u0011\t\u0011)A\u0005y\"Iq\u0010\u0001BA\u0002\u0013%\u0011\u0011\u0001\u0005\u000b\u0003\u0007\u0001!\u00111A\u0005\n\u0005\u0015\u0001\"CA\t\u0001\t\u0005\t\u0015)\u0003u\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0006C\u0006\u0002b\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0004bCA4\u0001\u0001\u0007\t\u0011)Q\u0005\u00037B\u0011\"a\u001b\u0001\u0005\u0004%\t!!\u001c\t\u0011\u0005U\u0004\u0001)A\u0005\u0003_B\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u000f\u0005m\u0004\u0001)A\u0005y\"I\u0011Q\u0010\u0001A\u0002\u0013%\u0011q\u0010\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0005\u0003\u0017C\u0001\"a$\u0001A\u0003&\u0011\u0011\u0011\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003'C\u0001\"!.\u0001A\u0003%\u0011Q\u0013\u0005\f\u0003\u000b\u0004\u0001\u0019!a\u0001\n\u0013\t9\rC\u0006\u0002h\u0002\u0001\r\u00111A\u0005\n\u0005%\bbCAs\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013D\u0011\"!>\u0001\u0005\u0004%\t\"a>\t\u0011\t\u0015\u0001\u0001)A\u0005\u0003sDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003\f\u0001!IA!\u0003\t\u000f\t5\u0001A\"\u0005\u0003\n!9!q\u0002\u0001\u0007\u0012\t%\u0001b\u0002B\t\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011\t\u0004\u0001D\t\u0005gAqAa\u000e\u0001\r#\u0011I\u0001C\u0004\u0003:\u0001!\tBa\u000f\t\u0011\te\u0003\u0001\"\u0001<\u00057BqA!\u001c\u0001\t\u0013\u0011y\u0007\u0003\u0005\u0003r\u0001!\ta\u000fB8\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqA!\"\u0001\t\u0013\u0011I\u0001C\u0004\u0003\b\u0002!IA!\u0003\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\"9!1\u0013\u0001\u0005B\tU\u0005\u0002\u0003BL\u0001\u0011\u00053H!'\t\u000f\t}\u0005\u0001\"\u0001\u0002\u0002!9!\u0011\u0015\u0001\u0005B\t\r\u0006b\u0002BX\u0001\u0019E!\u0011\u0017\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u00119\r\u0001C\u0005\u0005\u0013\u0011\u0001%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe*\u0011A(P\u0001\u0005Y&t7N\u0003\u0002?\u007f\u000511/\u001a:wKJT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u00011)S)\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\tQeJ\u0004\u0002L\u00196\t1(\u0003\u0002Nw\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\ty\u0005KA\u0007DY&,g\u000e^'b]\u0006<WM\u001d\u0006\u0003\u001bn\u0002\"AU+\u000e\u0003MS!\u0001V \u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001b&a\u0002'pO\u001eLgnZ\u0001\u0013G2,8\u000f^3s\u0019&t7.T1oC\u001e,'/F\u0001Z!\tY%,\u0003\u0002\\w\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003!a\u0017N\\6ECR\fW#A0\u0011\u0005-\u0003\u0017BA1<\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u0003-a\u0017N\\6NKR\u0014\u0018nY:\u0016\u0003\u0015\u0004\"a\u00134\n\u0005\u001d\\$AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\fA\u0002\\5oW6+GO]5dg\u0002\n1\u0002^1tW6\u000bg.Y4feV\t1\u000e\u0005\u0002LY&\u0011Qn\u000f\u0002\u0017\u00072,8\u000f^3s\u0019&t7\u000eV1tW6\u000bg.Y4fe\u0006aA/Y:l\u001b\u0006t\u0017mZ3sA\u0005\u0011\"/Z7pi\u0016\fE-\\5o\r\u0006\u001cGo\u001c:z+\u0005\t\b\u0003\u0002#si^L!a]#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA&v\u0013\t18HA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004\"a\u0013=\n\u0005e\\$AF\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;\u0002'I,Wn\u001c;f\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\u0011\u0002\u001f1|7-\u00197CCR\u001c\u0007.\u00113nS:\u0004\"aS?\n\u0005y\\$!F\"mkN$XM\u001d'j].\u0014\u0015\r^2i\u0003\u0012l\u0017N\\\u0001\u000bY&t7nQ8oM&<W#\u0001;\u0002\u001d1Lgn[\"p]\u001aLwm\u0018\u0013fcR!\u0011qAA\u0007!\r!\u0015\u0011B\u0005\u0004\u0003\u0017)%\u0001B+oSRD\u0001\"a\u0004\u000e\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014a\u00037j].\u001cuN\u001c4jO\u0002B3ADA\u000b!\r!\u0015qC\u0005\u0004\u00033)%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\tQLW.\u001a\t\u0005\u0003?\t\t$\u0004\u0002\u0002\")\u0019A+a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0007G>lWn\u001c8\u000b\u0007\u0001\u000bIC\u0003\u0003\u0002,\u00055\u0012AB1qC\u000eDWM\u0003\u0002\u00020\u0005\u0019qN]4\n\t\u0005M\u0012\u0011\u0005\u0002\u0005)&lW-\u0001\u0004rk>$\u0018m\u001d\t\u0005\u0003s\tY$D\u0001>\u0013\r\ti$\u0010\u0002\u0012\u00072,8\u000f^3s\u0019&t7.U;pi\u0006\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u000b\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013Q\u000b\t\u0003\u0017\u0002AQaV\tA\u0002eCQ!X\tA\u0002}CQaY\tA\u0002\u0015DQ![\tA\u0002-DQa\\\tA\u0002EDQa_\tA\u0002qDQa`\tA\u0002QDq!a\u0007\u0012\u0001\u0004\ti\u0002C\u0004\u00026E\u0001\r!a\u000e\u0002\u000b\u0005$W.\u001b8\u0016\u0005\u0005m\u0003\u0003\u0002#\u0002^]L1!a\u0018F\u0005\u0019y\u0005\u000f^5p]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0005\u0003\u000f\t)\u0007C\u0005\u0002\u0010M\t\t\u00111\u0001\u0002\\\u00051\u0011\rZ7j]\u0002B3\u0001FA\u000b\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002pA\u00191*!\u001d\n\u0007\u0005M4H\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u0005:f[>$XMQ1uG\"\fE-\\5o+\u0005a\u0018!\u0005:f[>$XMQ1uG\"\fE-\\5oA\u0005a2\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRLXCAAA!\u0015!\u0015QLAB!\rY\u0015QQ\u0005\u0004\u0003\u000f[$\u0001I\"mkN$XM\u001d'j].\u001c\u0005.Z2l\u0019&t7.\u0011<bS2\f'-\u001b7jif\f\u0001e\u00197vgR,'\u000fT5oW\u000eCWmY6Bm\u0006LG.\u00192jY&$\u0018p\u0018\u0013fcR!\u0011qAAG\u0011%\tyAGA\u0001\u0002\u0004\t\t)A\u000fdYV\u001cH/\u001a:MS:\\7\t[3dW\u00063\u0018-\u001b7bE&d\u0017\u000e^=!\u00035a\u0017M_=SKN|WO]2fgV\u0011\u0011Q\u0013\t\u0007\u0003/\u000b\t+!*\u000e\u0005\u0005e%\u0002BAN\u0003;\u000bq!\\;uC\ndWMC\u0002\u0002 \u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019+!'\u0003\r\t+hMZ3sa\u0011\t9+!-\u0011\u000b-\u000bI+!,\n\u0007\u0005-6H\u0001\u0007MCjL(+Z:pkJ\u001cW\r\u0005\u0003\u00020\u0006EF\u0002\u0001\u0003\f\u0003gk\u0012\u0011!A\u0001\u0006\u0003\t9LA\u0002`IE\na\u0002\\1{sJ+7o\\;sG\u0016\u001c\b%\u0005\u0003\u0002:\u0006}\u0006c\u0001#\u0002<&\u0019\u0011QX#\u0003\u000f9{G\u000f[5oOB\u0019A)!1\n\u0007\u0005\rWIA\u0002B]f\f\u0001\u0004\\1{sJ+7o\\;sG\u0016\u0014V-\u00199fe\u001a+H/\u001e:f+\t\tI\r\r\u0003\u0002L\u0006\u0005\bCBAg\u00037\fy.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003+\f9.\u0001\u0003vi&d'BAAm\u0003\u0011Q\u0017M^1\n\t\u0005u\u0017q\u001a\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!\u0011qVAq\t-\t\u0019\u000fIA\u0001\u0002\u0003\u0015\t!a.\u0003\u0007}##'A\rmCjL(+Z:pkJ\u001cWMU3ba\u0016\u0014h)\u001e;ve\u0016\u0004\u0013\u0001\b7buf\u0014Vm]8ve\u000e,'+Z1qKJ4U\u000f^;sK~#S-\u001d\u000b\u0005\u0003\u000f\tY\u000fC\u0005\u0002\u0010}\t\t\u00111\u0001\u0002nB\"\u0011q^Az!\u0019\ti-a7\u0002rB!\u0011qVAz\t1\t\u0019/a;\u0002\u0002\u0003\u0005)\u0011AA\\\u0003\u0011awnY6\u0016\u0005\u0005e\b\u0003BA~\u0005\u0003i!!!@\u000b\t\u0005}\u0018q[\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0004\u0005u(AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\u001d\u0011AE:uCJ$X\u000f]!di&4X\rV1tWN\fAd\u001d;beR,\b/\u00113eSRLwN\\1m\u0003\u000e$\u0018N^3UCN\\7/\u0001\u0014ti\u0006\u0014H/\u001e9BI\u0012LG/[8oC2\f5\r^5wK>\u0013\u0018J\\1di&4X\rV1tWN\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0014g\",H\u000fZ8x]\u0006\u001bG/\u001b<f)\u0006\u001c8n\u001d\u000b\u0005\u0003\u000f\u00119\u0002C\u0004\u0003\u001a!\u0002\rAa\u0007\u0002\rI,\u0017m]8o!\u0011\u0011iBa\u000b\u000f\t\t}!q\u0005\t\u0004\u0005C)UB\u0001B\u0012\u0015\r\u0011)#Q\u0001\u0007yI|w\u000e\u001e \n\u0007\t%R)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0011yC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005S)\u0015!H:ikR$wn\u001e8BI\u0012LG/[8oC2\f5\r^5wKR\u000b7o[:\u0015\t\u0005\u001d!Q\u0007\u0005\b\u00053I\u0003\u0019\u0001B\u000e\u0003\u001d\u001a\b.\u001e;e_^t\u0017\t\u001a3ji&|g.\u00197BGRLg/Z(s\u0013:\f7\r^5wKR\u000b7o[:\u0002\u0019M\u001c\u0007.\u001a3vY\u0016$\u0016m]6\u0015\r\u0005\u001d!Q\bB$\u0011\u001d\u0011yd\u000ba\u0001\u0005\u0003\n\u0001\u0002^1tWRK\b/\u001a\t\u0004\u0017\n\r\u0013b\u0001B#w\tAA+Y:l)f\u0004X\rC\u0004\u0003J-\u0002\rAa\u0013\u0002\tQ\f7o\u001b\t\u0005\u0005\u001b\u0012\u0019FD\u0002L\u0005\u001fJ1A!\u0015<\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&!!Q\u000bB,\u00051\u0001VM]5pI&\u001cG+Y:l\u0015\r\u0011\tfO\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\b\tu#\u0011\r\u0005\u0007\u0005?b\u0003\u0019\u0001;\u0002\u00139,woQ8oM&<\u0007b\u0002B2Y\u0001\u0007!QM\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000f\u0005\u0004\u0003h\t%$1D\u0007\u0003\u0003;KAAa\u001b\u0002\u001e\n\u00191+\u001a;\u00027\rdWo\u001d;fe2Kgn[!e[&twJ]#yG\u0016\u0004H/[8o+\u00059\u0018aK4fi\u000ecWo\u001d;fe2Kgn[!e[&tgi\u001c:Ce>\\WM\u001d*fcV,7\u000f\u001e%b]\u0012d\u0017N\\4\u0002M\u001d,GOU3n_R,\u0017\tZ7j]\u001a{'O\u0011:pW\u0016\u0014(+Z9vKN$\b*\u00198eY&tw-\u0006\u0002\u0003xA!!\u0011\u0010BA\u001b\t\u0011YH\u0003\u0003\u0002X\tu$\u0002\u0002B@\u0003O\tqa\u00197jK:$8/\u0003\u0003\u0003\u0004\nm$AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0012GJ,\u0017\r^3B]\u0012\u001cV\r^!e[&t\u0017AC2m_N,\u0017\tZ7j]\u0006A\u0011n]!di&4X\r\u0006\u0002\u0003\u000eB\u0019AIa$\n\u0007\tEUIA\u0004C_>dW-\u00198\u0002/%\u001c\u0018i\u0019;jm\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014XC\u0001BG\u0003Qyg.\u0011<bS2\f'-\u001b7jif\u001c\u0005.\u00198hKR!\u0011q\u0001BN\u0011\u001d\u0011i\n\u000ea\u0001\u0005\u001b\u000b1\"[:Bm\u0006LG.\u00192mK\u0006i1-\u001e:sK:$8i\u001c8gS\u001e\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0005\u0005K\u0013i\u000bE\u0003E\u0003;\u00129\u000bE\u0002L\u0005SK1Aa+<\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0007b\u0002B m\u0001\u0007!\u0011I\u0001!i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\u001a{'/\u00113eSRLwN\\1m)\u0006\u001c8\u000e\u0006\u0003\u0003&\nM\u0006b\u0002B o\u0001\u0007!\u0011I\u0001\u0015e\u0016<\u0017n\u001d;fe2\u000b'0\u001f*fg>,(oY3\u0015\t\u0005\u001d!\u0011\u0018\u0005\b\u0005wC\u0004\u0019\u0001B_\u00031a\u0017M_=SKN|WO]2fa\u0011\u0011yLa1\u0011\u000b-\u000bIK!1\u0011\t\u0005=&1\u0019\u0003\r\u0005\u000b\u0014I,!A\u0001\u0002\u000b\u0005\u0011q\u0017\u0002\u0004?\u0012\u001a\u0014!F:ikR$wn\u001e8JI2,'+Z:pkJ\u001cWm\u001d")
public abstract class AbstractClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetrics linkMetrics;
    private final ClusterLinkTaskManager taskManager;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory;
    private final ClusterLinkBatchAdmin localBatchAdmin;
    private volatile ClusterLinkConfig linkConfig;
    private final Time time;
    private final ClusterLinkQuotas quotas;
    private volatile Option<ClusterLinkAdminClient> admin;
    private final ClusterLinkScheduler scheduler;
    private final ClusterLinkBatchAdmin remoteBatchAdmin;
    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability;
    private final Buffer<LazyResource<?>> lazyResources;
    private ScheduledFuture<?> lazyResourceReaperFuture;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractClusterLinkClientManager abstractClusterLinkClientManager = this;
        synchronized (abstractClusterLinkClientManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    @Override
    public ClusterLinkTaskManager taskManager() {
        return this.taskManager;
    }

    public Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    private void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    @Override
    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkBatchAdmin remoteBatchAdmin() {
        return this.remoteBatchAdmin;
    }

    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckLinkAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Buffer<LazyResource<?>> lazyResources() {
        return this.lazyResources;
    }

    private ScheduledFuture<?> lazyResourceReaperFuture() {
        return this.lazyResourceReaperFuture;
    }

    private void lazyResourceReaperFuture_$eq(ScheduledFuture<?> x$1) {
        this.lazyResourceReaperFuture = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    @Override
    public void startup() {
        this.info((Function0<String> & Serializable)() -> "Starting " + this.getClass().getSimpleName() + " with cluster link data " + this.linkData());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        } else {
            this.admin_$eq(None$.MODULE$);
        }
        this.startupAdditionalActiveOrInactiveTasks();
        this.info((Function0<String> & Serializable)() -> "Startup of " + this.getClass().getSimpleName() + " with cluster link data " + this.linkData() + " is complete");
    }

    private void startupActiveTasks() {
        this.clusterLinkCheckAvailability_$eq(new Some<ClusterLinkCheckLinkAvailability>(new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig> & Serializable)() -> this.currentConfig(), this.linkMetrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.scheduler(), this.linkData(), this.remoteBatchAdmin(), this.localBatchAdmin, this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
        this.scheduleTask(ClusterLinkCheckAvailabilityTaskType$.MODULE$, this.clusterLinkCheckAvailability().get());
        this.startupAdditionalActiveTasks();
        this.lazyResourceReaperFuture_$eq(this.scheduler().schedule("ShutdownIdleResources", () -> this.shutdownIdleResources(), this.currentConfig().clientsMaxIdleMs(), this.currentConfig().clientsMaxIdleMs()));
    }

    public abstract void startupAdditionalActiveTasks();

    public abstract void startupAdditionalActiveOrInactiveTasks();

    @Override
    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Shutting down " + this.getClass().getSimpleName() + " with cluster link data " + this.linkData());
        this.taskManager().clusterLinkPeriodicTasks().shutdownTasks(this.linkData().linkId(), "client manager shutdown", this.taskManager().clusterLinkPeriodicTasks().shutdownTasks$default$3());
        this.shutdownAdditionalActiveOrInactiveTasks();
        if (this.isActive()) {
            this.shutdownActiveTasks("client manager shutdown");
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String> & Serializable)() -> "Shutdown of " + this.getClass().getSimpleName() + " with cluster link data " + this.linkData() + " is complete");
    }

    private void shutdownActiveTasks(String reason) {
        this.clusterLinkCheckAvailability().foreach((Function1<ClusterLinkCheckLinkAvailability, Object> & Serializable)task -> {
            AbstractClusterLinkClientManager.$anonfun$shutdownActiveTasks$1(this, reason, task);
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability().foreach((Function1<ClusterLinkCheckLinkAvailability, Object> & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq(None$.MODULE$);
        this.shutdownAdditionalActiveTasks(reason);
        Option$.MODULE$.apply(this.lazyResourceReaperFuture()).foreach((Function1<ScheduledFuture, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.cancel(true)));
        this.lazyResourceReaperFuture_$eq(null);
    }

    public abstract void shutdownAdditionalActiveTasks(String var1);

    public abstract void shutdownAdditionalActiveOrInactiveTasks();

    public void scheduleTask(TaskType taskType, ClusterLinkScheduler.PeriodicTask task) {
        this.taskManager().clusterLinkPeriodicTasks().addTask(taskType, this.linkData(), task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        // MONITORENTER : object
        boolean oldActive = this.isActive();
        this.linkConfig_$eq(newConfig);
        boolean newActive = this.isActive();
        this.trace((Function0<String> & Serializable)() -> "Reconfiguring " + this.getClass().getSimpleName() + ". oldActive=" + oldActive + " and newActive=" + newActive);
        Tuple2$mcZZ$sp tuple2$mcZZ$sp = new Tuple2$mcZZ$sp(oldActive, newActive);
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl2 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (!bl && !bl2) {
                return;
            }
        }
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl3 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (!bl && bl3) {
                this.createAndSetAdmin();
                this.startupActiveTasks();
                return;
            }
        }
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl4 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (bl && !bl4) {
                this.shutdownActiveTasks("link paused");
                this.closeAdmin();
                this.admin_$eq(None$.MODULE$);
                return;
            }
        }
        if (tuple2$mcZZ$sp == null) throw new MatchError(tuple2$mcZZ$sp);
        boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
        boolean bl5 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
        if (true != bl) throw new MatchError(tuple2$mcZZ$sp);
        if (true != bl5) throw new MatchError(tuple2$mcZZ$sp);
        if (!updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) return;
        this.trace((Function0<String> & Serializable)() -> "Reconfiguring AdminClient and restarting tasks for " + this.getClass().getSimpleName());
        this.createAndSetAdmin();
        this.shutdownActiveTasks("link reconfiguration");
        this.startupActiveTasks();
        return;
    }

    private ClusterLinkAdminClient clusterLinkAdminOrException() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException("Client manager for cluster link data " + this.linkData());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new ClusterLinkPausedException("Cluster link for " + this.linkData().linkName() + " is paused");
        });
    }

    public ClusterLinkAdminClient getClusterLinkAdminForBrokerRequestHandling() {
        return this.clusterLinkAdminOrException();
    }

    public ConfluentAdmin getRemoteAdminForBrokerRequestHandling() {
        return this.clusterLinkAdminOrException().admin();
    }

    private void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq(new Some<ClusterLinkAdminClient>(this.remoteAdminFactory().apply(this.linkConfig())));
    }

    private void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            CoreUtils$.MODULE$.swallow(() -> this.remoteBatchAdmin().closeRequests(), this, CoreUtils$.MODULE$.swallow$default$3());
            curAdmin.foreach((Function1<ClusterLinkAdminClient, Object> & Serializable)a -> {
                CoreUtils$.MODULE$.swallow(() -> a.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused());
    }

    @Override
    public boolean isActiveLinkCoordinator() {
        return this.isActive() && this.clusterLinkManager().metadataManager().isLinkCoordinator(this.linkData().linkName());
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String> & Serializable)() -> "Processing link availability change to " + isAvailable);
            this.shutdownActiveTasks("link unavailable");
            if (!Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.linkConfig().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.linkConfig().availabilityCheckMs())));
                    this.debug((Function0<String> & Serializable)() -> "Link is unavailable, starting availability checks with periodic interval " + intervalMs + " ms until link becomes available");
                    this.clusterLinkCheckAvailability_$eq(new Some<ClusterLinkCheckLinkAvailability>(new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig> & Serializable)() -> this.linkConfig(), this.linkMetrics(), this.clusterLinkManager(), intervalMs, this.scheduler(), this.linkData(), this.remoteBatchAdmin(), this.localBatchAdmin, this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.linkConfig();
    }

    @Override
    public Option<TaskDescription> taskDescription(TaskType taskType) {
        TaskType taskType2 = taskType;
        if (ClusterLinkCheckAvailabilityTaskType$.MODULE$.equals(taskType2)) {
            return this.clusterLinkCheckAvailability().flatMap((Function1<ClusterLinkCheckLinkAvailability, Option> & Serializable)x$5 -> x$5.taskDescription());
        }
        return this.taskDescriptionForAdditionalTask(taskType);
    }

    public abstract Option<TaskDescription> taskDescriptionForAdditionalTask(TaskType var1);

    @Override
    public void registerLazyResource(LazyResource<?> lazyResource) {
        this.lazyResources().$plus$eq(lazyResource);
    }

    private void shutdownIdleResources() {
        this.lazyResources().foreach((Function1<LazyResource, Object> & Serializable)x$6 -> {
            x$6.closeIdleResource();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$shutdownActiveTasks$1(AbstractClusterLinkClientManager $this, String reason$1, ClusterLinkCheckLinkAvailability task) {
        $this.taskManager().clusterLinkPeriodicTasks().shutdownTasks($this.linkData().linkId(), reason$1, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkScheduler.PeriodicTask[]{task})));
    }

    public AbstractClusterLinkClientManager(ClusterLinkManager clusterLinkManager, ClusterLinkData linkData, ClusterLinkMetrics linkMetrics, ClusterLinkTaskManager taskManager, Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory, ClusterLinkBatchAdmin localBatchAdmin, ClusterLinkConfig linkConfig, Time time, ClusterLinkQuotas quotas) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.linkMetrics = linkMetrics;
        this.taskManager = taskManager;
        this.remoteAdminFactory = remoteAdminFactory;
        this.localBatchAdmin = localBatchAdmin;
        this.linkConfig = linkConfig;
        this.time = time;
        this.quotas = quotas;
        ClusterLinkFactory.ClientManager.$init$(this);
        Logging.$init$(this);
        this.scheduler = taskManager.scheduler();
        this.remoteBatchAdmin = ClusterLinkBatchAdmin$.MODULE$.apply((Function0<ConfluentAdmin> & Serializable)() -> this.clusterLinkAdminOrException().admin(), () -> Predef$.MODULE$.Integer2int(this.clusterLinkManager().brokerConfig().clusterLinkAdminRequestBatchSize()), () -> Predef$.MODULE$.Integer2int(this.clusterLinkManager().brokerConfig().clusterLinkAdminMaxInFlightRequests()), this.scheduler(), time, (Function0<Sensor> & Serializable)() -> this.linkMetrics().remoteAdminQueueTimeSensor(), (Function0<Sensor> & Serializable)() -> this.linkMetrics().remoteAdminRequestTimeSensor());
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.lazyResources = (Buffer)Buffer$.MODULE$.empty();
        this.lock = new Object();
    }
}

