/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkClearMirrorStartOffsets$;
import kafka.server.link.ClusterLinkClearMirrorStartOffsetsTaskType$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTruncateMode;
import kafka.server.link.MirrorTruncateMode$Ignore$;
import kafka.server.link.MirrorTruncateMode$TruncateAtStart$;
import kafka.server.link.MirrorTruncateMode$TruncateFromEnd$;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorNotFoundTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]e\u0001\u0002\"D\u0001)C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\rC\u0005j\u0001\t\u0005\t\u0015!\u0003ko\"I\u0001\u0010\u0001B\u0001B\u0003%\u00110 \u0005\u000b}\u0002\u0011\t\u0011)A\u0005\u007f\u0006\u001d\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\"CA/\u0001\u0001\u0007I\u0011BA0\u0011\u001d\t\u0019\u0007\u0001Q!\n}D\u0011\"!\u001a\u0001\u0001\u0004%I!a\u001a\t\u0013\u0005=\u0004\u00011A\u0005\n\u0005E\u0004\u0002CA;\u0001\u0001\u0006K!!\u001b\t\u0013\u0005]\u0004\u00011A\u0005\n\u0005\u001d\u0004\"CA=\u0001\u0001\u0007I\u0011BA>\u0011!\ty\b\u0001Q!\n\u0005%\u0004\"CAA\u0001\u0001\u0007I\u0011BA4\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0015BA5\u0011%\tY\t\u0001a\u0001\n\u0013\t9\u0007C\u0005\u0002\u000e\u0002\u0001\r\u0011\"\u0003\u0002\u0010\"A\u00111\u0013\u0001!B\u0013\tI\u0007C\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"I\u0011Q\u0015\u0001A\u0002\u0013%\u0011q\u0015\u0005\t\u0003W\u0003\u0001\u0015)\u0003\u0002\u001a\"Y\u0011Q\u0017\u0001A\u0002\u0003\u0007I\u0011BA\\\u0011-\t\t\u000e\u0001a\u0001\u0002\u0004%I!a5\t\u0017\u0005]\u0007\u00011A\u0001B\u0003&\u0011\u0011\u0018\u0005\f\u00033\u0004\u0001\u0019!a\u0001\n\u0013\tY\u000eC\u0006\u0002p\u0002\u0001\r\u00111A\u0005\n\u0005E\bbCA{\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;D\u0001\"a>\u0001\t#\u001a\u0015\u0011 \u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?AqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\b\u0005/\u0003A\u0011\u0002BM\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005KCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u0003J\u0002!IAa3\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\"9!1\u001d\u0001\u0005\n\t\u0015\bb\u0002Bx\u0001\u0011%!\u0011\u001f\u0005\b\u0005k\u0004A\u0011\u0002B|\u0011\u001d\u0011i\u0010\u0001C)\u0005\u007fDqaa\u0003\u0001\t\u0003\u001ai\u0001C\u0004\u0004\u0010\u0001!Ia!\u0005\t\u000f\rE\u0002\u0001\"\u0003\u0002h!911\u0007\u0001\u0005\n\rU\u0002bBB \u0001\u0011%1\u0011\t\u0005\t\u00077\u0002A\u0011A\"\u0004^!q1q\u000e\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002\\\u0005\u001dq!CB9\u0007\u0006\u0005\t\u0012AB:\r!\u00115)!A\t\u0002\rU\u0004bBA\u0006\u007f\u0011\u00051Q\u0010\u0005\n\u0007\u007fz\u0014\u0013!C\u0001\u0007\u0003\u0013!e\u00117vgR,'\u000fT5oW\u000ecW-\u0019:NSJ\u0014xN]*uCJ$xJ\u001a4tKR\u001c(B\u0001#F\u0003\u0011a\u0017N\\6\u000b\u0005\u0019;\u0015AB:feZ,'OC\u0001I\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A&\u0011\u00051\u0003fBA'O\u001b\u0005\u0019\u0015BA(D\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011\u0011K\u0015\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003\u001f\u000e\u000bQ\u0001^8qS\u000e\u0004\"!\u00160\u000f\u0005Yc\u0006CA,[\u001b\u0005A&BA-J\u0003\u0019a$o\\8u})\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\u00061\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti&,A\u0007dY&,g\u000e^'b]\u0006<WM\u001d\t\u0003\u001b\u000eL!\u0001Z\"\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006QAn\\2bY\u0006#W.\u001b8\u0011\u00055;\u0017B\u00015D\u0005U\u0019E.^:uKJd\u0015N\\6CCR\u001c\u0007.\u00113nS:\fA\u0001^5nKB\u00111.^\u0007\u0002Y*\u0011QN\\\u0001\u0006kRLGn\u001d\u0006\u0003_B\faaY8n[>t'B\u0001%r\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\n\u0005Yd'\u0001\u0002+j[\u0016L!!\u001b)\u0002\u000bE,x\u000e^1\u0011\u0005i\\X\"A#\n\u0005q,%aF\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u0013\tA\b+\u0001\u0006j]R,'O^1m\u001bN\u0004B!!\u0001\u0002\u00045\t!,C\u0002\u0002\u0006i\u00131!\u00138u\u0013\r\tI\u0001U\u0001\u0012e\u0016\u001c8\r[3ek2,G)\u001a7bs6\u001b\u0018A\u0002\u001fj]&$h\b\u0006\b\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0011\u00055\u0003\u0001\"B*\b\u0001\u0004!\u0006\"B1\b\u0001\u0004\u0011\u0007\"B3\b\u0001\u00041\u0007\"B5\b\u0001\u0004Q\u0007\"\u0002=\b\u0001\u0004I\bb\u0002@\b!\u0003\u0005\ra`\u0001\u0014e\u0016l\u0017-\u001b8j]\u001e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003C\u0001b!a\t\u0002.\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000f5,H/\u00192mK*\u0019\u00111\u0006.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\u0005\u0015\"aA*fiB!\u00111GA\u001b\u001b\u0005q\u0017bAA\u001c]\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0006:f[\u0006Lg.\u001b8h!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\ti$a\u0011\u0011\t\u0005\u0005\u0011qH\u0005\u0004\u0003\u0003R&\u0001B+oSRD\u0011\"!\u0012\n\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013'\u0001\u000bsK6\f\u0017N\\5oOB\u000b'\u000f^5uS>t7\u000fI\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\u0016\u0005\u00055\u0003#B+\u0002P\u0005E\u0012bAA\u0018A\u0006\t\u0012\r\u001c7QCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u0005u\u0012Q\u000b\u0005\n\u0003\u000bb\u0011\u0011!a\u0001\u0003\u001b\na\"\u00197m!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0010ok6\u0014V\r\u001e:jKN<\u0006.\u001a8O_R{\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012a`\u0001$]Vl'+\u001a;sS\u0016\u001cx\u000b[3o\u001d>$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\ti$!\u0019\t\u0011\u0005\u0015s\"!AA\u0002}\f\u0001E\\;n%\u0016$(/[3t/\",gNT8U_BL7\rU1si&$\u0018n\u001c8tA\u0005!Am\u001c8f+\t\tI\u0007\u0005\u0003\u0002\u0002\u0005-\u0014bAA75\n9!i\\8mK\u0006t\u0017\u0001\u00033p]\u0016|F%Z9\u0015\t\u0005u\u00121\u000f\u0005\n\u0003\u000b\u0012\u0012\u0011!a\u0001\u0003S\nQ\u0001Z8oK\u0002\n\u0001c\u00197fCJ|eMZ:fiN$uN\\3\u0002)\rdW-\u0019:PM\u001a\u001cX\r^:E_:,w\fJ3r)\u0011\ti$! \t\u0013\u0005\u0015S#!AA\u0002\u0005%\u0014!E2mK\u0006\u0014xJ\u001a4tKR\u001cHi\u001c8fA\u0005y2m\u001c8tk6,'o\u0012:pkB|eMZ:fi\u000ec\u0017-\u001c9j]\u001e$uN\\3\u0002G\r|gn];nKJ<%o\\;q\u001f\u001a47/\u001a;DY\u0006l\u0007/\u001b8h\t>tWm\u0018\u0013fcR!\u0011QHAD\u0011%\t)\u0005GA\u0001\u0002\u0004\tI'\u0001\u0011d_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u00117b[BLgn\u001a#p]\u0016\u0004\u0013AF5t!\u0016tG-\u001b8h%\u0016\u001cHo\u001c:f\u001b&\u0014(o\u001c:\u00025%\u001c\b+\u001a8eS:<'+Z:u_J,W*\u001b:s_J|F%Z9\u0015\t\u0005u\u0012\u0011\u0013\u0005\n\u0003\u000bZ\u0012\u0011!a\u0001\u0003S\nq#[:QK:$\u0017N\\4SKN$xN]3NSJ\u0014xN\u001d\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!!'\u0011\r\u0005\u0005\u00111TAP\u0013\r\tiJ\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00075\u000b\t+C\u0002\u0002$\u000e\u0013q\u0002V1tW\u0012+7o\u0019:jaRLwN\\\u0001\ri\u0006\u001c8\u000eR3tG~#S-\u001d\u000b\u0005\u0003{\tI\u000bC\u0005\u0002Fy\t\t\u00111\u0001\u0002\u001a\u0006IA/Y:l\t\u0016\u001c8\r\t\u0015\u0004?\u0005=\u0006\u0003BA\u0001\u0003cK1!a-[\u0005!1x\u000e\\1uS2,\u0017\u0001D4s_V\u0004h)\u001b7uKJ\u001cXCAA]!\u0019\tY,!2\u0002L:!\u0011QXAa\u001d\r9\u0016qX\u0005\u00027&\u0019\u00111\u0019.\u0002\u000fA\f7m[1hK&!\u0011qYAe\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0007T\u0006cA'\u0002N&\u0019\u0011qZ\"\u00035\u001d\u0013x.\u001e9DYV\u001cH/\u001a:MS:\\g)\u001b7uKJLeNZ8\u0002!\u001d\u0014x.\u001e9GS2$XM]:`I\u0015\fH\u0003BA\u001f\u0003+D\u0011\"!\u0012\"\u0003\u0003\u0005\r!!/\u0002\u001b\u001d\u0014x.\u001e9GS2$XM]:!\u0003y\u0001\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\fe\u000eZ#q_\u000eD7/\u0006\u0002\u0002^BA\u00111EAp\u0003c\t\u0019/\u0003\u0003\u0002b\u0006\u0015\"aA'baB!\u0011Q]Av\u001b\t\t9OC\u0002p\u0003ST!A\u00129\n\t\u00055\u0018q\u001d\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\fe\u000eZ#q_\u000eD7o\u0018\u0013fcR!\u0011QHAz\u0011%\t)\u0005JA\u0001\u0002\u0004\ti.A\u0010qCJ$\u0018\u000e^5p]2{w-\u00128e\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2ig\u0002\n1A];o)\t\tY\u0010\u0005\u0003\u0002~\n-abAA\u0000\u001d:!!\u0011\u0001B\u0005\u001d\u0011\u0011\u0019Aa\u0002\u000f\u0007]\u0013)!C\u0001I\u0013\t1u)\u0003\u0002E\u000b&\u0019!Q\u0002*\u0003\u0015Q\u000b7o\u001b*fgVdG/\u0001\u0006ue\u0006t7/\u001b;j_:$B!a?\u0003\u0014!9!QC\u0014A\u0002\t]\u0011a\u0003;bg.\u001cuN\u001c;fqR\u0004B!!@\u0003\u001a%\u0019!1\u0004*\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\u0012aJ|7-Z:t!\u0006\u0014H/\u001b;j_:\u001cHCBA~\u0005C\u0011\u0019\u0003C\u0004\u0003\u0016!\u0002\rAa\u0006\t\u000f\t\u0015\u0002\u00061\u0001\u0003(\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t%\"1GA\u0019\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012\u0001B;uS2T!A!\r\u0002\t)\fg/Y\u0005\u0005\u0003_\u0011Y#A\riC:$G.\u001a*fa2L7-Y*uCR,8OU3tk2$HCBA~\u0005s\u0011Y\u0004C\u0004\u0003\u0016%\u0002\rAa\u0006\t\u000f\tu\u0012\u00061\u0001\u0003@\u0005\u0001\u0002/\u0019:uSRLwN\u001c*fgVdGo\u001d\t\t\u0005S\u0011\t%!\r\u0003D%!\u0011\u0011\u001dB\u0016!\u0019\t\u0019D!\u0012\u0003J%\u0019!q\t8\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0005\u0017\u0012)&\u0004\u0002\u0003N)!!q\nB)\u0003\u0015\tG-\\5o\u0015\r\u0011\u0019\u0006]\u0001\bG2LWM\u001c;t\u0013\u0011\u00119F!\u0014\u0003\u001fA\u000b'\u000f^5uS>t'+Z:vYR\fQ\u0003\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3U_BL7\r\u0006\u0003\u0002|\nu\u0003b\u0002B\u000bU\u0001\u0007!qC\u0001\u0019Q\u0006tG\r\\3BYR,'/T5se>\u00148OU3tk2$HCBA~\u0005G\u0012)\u0007C\u0004\u0003\u0016-\u0002\rAa\u0006\t\u000f\t\u001d4\u00061\u0001\u0003j\u0005aAo\u001c9jGJ+7/\u001e7ugB9!\u0011\u0006B!)\n-\u0004CBA\u001a\u0005\u000b\u0012i\u0007\u0005\u0003\u0003p\tUTB\u0001B9\u0015\u0011\u0011\u0019Ha\f\u0002\t1\fgnZ\u0005\u0005\u0005o\u0012\tH\u0001\u0003W_&$\u0017A\u00037jgR<%o\\;qgR!\u00111 B?\u0011\u001d\u0011)\u0002\fa\u0001\u0005/\t\u0001\u0003[1oI2,G*[:u\u000fJ|W\u000f]:\u0015\r\u0005m(1\u0011BC\u0011\u001d\u0011)\"\fa\u0001\u0005/AqAa\".\u0001\u0004\u0011I)\u0001\u0004gkR,(/\u001a\t\u0007\u0003g\u0011)Ea#\u0011\r\t%\"Q\u0012BI\u0013\u0011\u0011yIa\u000b\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003L\tM\u0015\u0002\u0002BK\u0005\u001b\u0012AcQ8ogVlWM]$s_V\u0004H*[:uS:<\u0017!\u00059s_\u000e,7o\u001d'jgR<%o\\;qgR1\u00111 BN\u0005;CqA!\u0006/\u0001\u0004\u00119\u0002C\u0004\u0003 :\u0002\rA!)\u0002\r\u001d\u0014x.\u001e9t!\u0011)\u0016q\n+\u0002!1L7\u000f^$s_V\u0004xJ\u001a4tKR\u001cHCBA~\u0005O\u0013I\u000bC\u0004\u0003\u0016=\u0002\rAa\u0006\t\u000f\t}u\u00061\u0001\u0003\"\u00061\u0002.\u00198eY\u0016d\u0015n\u001d;He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0002|\n=&\u0011\u0017\u0005\b\u0005+\u0001\u0004\u0019\u0001B\f\u0011\u001d\u0011\u0019\f\ra\u0001\u0005k\u000bqAZ;ukJ,7\u000f\u0005\u0004V\u0005o#&\u0011X\u0005\u0004\u0003C\u0004\u0007CBA\u001a\u0005\u000b\u0012Y\f\u0005\u0005\u0003*\t\u0005\u0013\u0011\u0007B_!\u0011\u0011yL!2\u000e\u0005\t\u0005'\u0002\u0002Bb\u0005#\n\u0001bY8ogVlWM]\u0005\u0005\u0005\u000f\u0014\tMA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006\faCZ5mi\u0016\u0014H*[:u\u000fJ|W\u000f](gMN,Go\u001d\u000b\u0007\u0005\u001b\u0014yMa5\u0011\u000fU\u00139,!\r\u0003>\"1!\u0011[\u0019A\u0002Q\u000bQa\u001a:pkBDqA!62\u0001\u0004\u0011i-A\u0004pM\u001a\u001cX\r^:\u0002#\u0005dG/\u001a:He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0002|\nm'Q\u001c\u0005\b\u0005+\u0011\u0004\u0019\u0001B\f\u0011\u001d\u0011yN\ra\u0001\u0005C\fAb\u001a:pkB|eMZ:fiN\u0004b!\u0016B\\)\n5\u0017a\u00065b]\u0012dW-\u00117uKJ<%o\\;q\u001f\u001a47/\u001a;t)\u0019\tYPa:\u0003j\"9!QC\u001aA\u0002\t]\u0001b\u0002Bvg\u0001\u0007!Q^\u0001\be\u0016\u001cX\u000f\u001c;t!\u0019)&q\u0017+\u0003l\u0005\u00012\u000f^1si6K'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0003w\u0014\u0019\u0010C\u0004\u0003\u0016Q\u0002\rAa\u0006\u0002/!\fg\u000e\u001a7f'R\f'\u000f^'jeJ|'OU3tk2$HCBA~\u0005s\u0014Y\u0010C\u0004\u0003\u0016U\u0002\rAa\u0006\t\u000f\t\u001dT\u00071\u0001\u0003j\u0005aqN\\\"p[BdW\r^5p]R!\u0011QHB\u0001\u0011\u001d\u0019\u0019A\u000ea\u0001\u0007\u000b\taA]3tk2$\bc\u0001'\u0004\b%\u00191\u0011\u0002*\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!!'\u0002'Q\f7o[#se>\u00148i\u001c3f\u0003:$Wj]4\u0015\u0011\rM1\u0011DB\u000f\u0007C\u00012!TB\u000b\u0013\r\u00199b\u0011\u0002\u0014)\u0006\u001c8.\u0012:s_J\u001cu\u000eZ3B]\u0012l5o\u001a\u0005\u0007\u00077A\u0004\u0019\u0001+\u0002\u0019\u0015\u0014(/T:h!J,g-\u001b=\t\u000f\r}\u0001\b1\u0001\u0002j\u0005qAn\\2bY\u0006#W.\u001b8Vg\u0016$\u0007bBB\u0012q\u0001\u00071QE\u0001\u0003Kb\u0004Baa\n\u0004.5\u00111\u0011\u0006\u0006\u0005\u0007W\u0011Y#\u0001\u0006d_:\u001cWO\u001d:f]RLAaa\f\u0004*\t\u0011R\t_3dkRLwN\\#yG\u0016\u0004H/[8o\u0003UA\u0017m]'jeJ|'o\u0015;beR|eMZ:fiN\f!\u0003\u001e:v]\u000e\fG/[8o\u0007>l\u0007\u000f\\3uKR1\u0011\u0011NB\u001c\u0007wAqa!\u000f;\u0001\u0004\t\t$\u0001\u0002ua\"91Q\b\u001eA\u0002\t%\u0013a\u00049beRLG/[8o%\u0016\u001cX\u000f\u001c;\u0002\u001b5\fGo\u00195SKBd\u0017nY1t)\u0019\tIga\u0011\u0004F!91QH\u001eA\u0002\t%\u0003bBB$w\u0001\u00071\u0011J\u0001\naJ,G-[2bi\u0016\u0004\u0002\"!\u0001\u0004L\r=\u0013\u0011N\u0005\u0004\u0007\u001bR&!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0019\tfa\u0016\u000e\u0005\rM#bAB+]\u00069!/\u001a9mS\u000e\f\u0017\u0002BB-\u0007'\u0012QBU3qY&\u001c\u0017m\u0015;biV\u001c\u0018AE7jeJ|'\u000f\u0016:v]\u000e\fG/Z'pI\u0016$Baa\u0018\u0004fA\u0019Qj!\u0019\n\u0007\r\r4I\u0001\nNSJ\u0014xN\u001d+sk:\u001c\u0017\r^3N_\u0012,\u0007bBB4y\u0001\u00071\u0011N\u0001\f[&\u0014(o\u001c:Ti\u0006$X\rE\u0002N\u0007WJ1a!\u001cD\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016\fqc];qKJ$#/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0002E\rcWo\u001d;fe2Kgn[\"mK\u0006\u0014X*\u001b:s_J\u001cF/\u0019:u\u001f\u001a47/\u001a;t!\tiuhE\u0002@\u0007o\u0002B!!\u0001\u0004z%\u001911\u0010.\u0003\r\u0005s\u0017PU3g)\t\u0019\u0019(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0007\u0007S3a`BCW\t\u00199\t\u0005\u0003\u0004\n\u000eMUBABF\u0015\u0011\u0019iia$\u0002\u0013Ut7\r[3dW\u0016$'bABI5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rU51\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkClearMirrorStartOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private scala.collection.mutable.Set<TopicPartition> remainingPartitions;
    private scala.collection.immutable.Set<TopicPartition> allPartitions;
    private int numRetriesWhenNoTopicPartitions;
    private boolean done;
    private boolean clearOffsetsDone;
    private boolean consumerGroupOffsetClampingDone;
    private boolean isPendingRestoreMirror;
    private volatile Option<TaskDescription> taskDesc;
    private Seq<GroupClusterLinkFilterInfo> groupFilters;
    private scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs;

    public static int $lessinit$greater$default$6() {
        return ClusterLinkClearMirrorStartOffsets$.MODULE$.$lessinit$greater$default$6();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private scala.collection.mutable.Set<TopicPartition> remainingPartitions() {
        return this.remainingPartitions;
    }

    private void remainingPartitions_$eq(scala.collection.mutable.Set<TopicPartition> x$1) {
        this.remainingPartitions = x$1;
    }

    private scala.collection.immutable.Set<TopicPartition> allPartitions() {
        return this.allPartitions;
    }

    private void allPartitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.allPartitions = x$1;
    }

    private int numRetriesWhenNoTopicPartitions() {
        return this.numRetriesWhenNoTopicPartitions;
    }

    private void numRetriesWhenNoTopicPartitions_$eq(int x$1) {
        this.numRetriesWhenNoTopicPartitions = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private boolean clearOffsetsDone() {
        return this.clearOffsetsDone;
    }

    private void clearOffsetsDone_$eq(boolean x$1) {
        this.clearOffsetsDone = x$1;
    }

    private boolean consumerGroupOffsetClampingDone() {
        return this.consumerGroupOffsetClampingDone;
    }

    private void consumerGroupOffsetClampingDone_$eq(boolean x$1) {
        this.consumerGroupOffsetClampingDone = x$1;
    }

    private boolean isPendingRestoreMirror() {
        return this.isPendingRestoreMirror;
    }

    private void isPendingRestoreMirror_$eq(boolean x$1) {
        this.isPendingRestoreMirror = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private Seq<GroupClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(Seq<GroupClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs() {
        return this.partitionLogEndOffsetAndEpochs;
    }

    private void partitionLogEndOffsetAndEpochs_$eq(scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> x$1) {
        this.partitionLogEndOffsetAndEpochs = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        Some some;
        Option mirrorState;
        Option option;
        if (Predef$.MODULE$.Boolean2boolean(this.clientManager.brokerConfig().clusterLinkK1ToK2MigrationEnable())) {
            this.done_$eq(true);
            this.debug((Function0<String> & Serializable)() -> "Not clearing mirror start offsets for K2 mirror topic " + $this.topic);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        if (this.remainingPartitions() == null) {
            this.debug((Function0<String> & Serializable)() -> "Initializing topic " + $this.topic);
            this.remainingPartitions_$eq((scala.collection.mutable.Set)Set$.MODULE$.empty());
            this.remainingPartitions().$plus$plus$eq(this.clientManager.metadataManager().topicPartitions(this.topic));
            this.allPartitions_$eq(this.remainingPartitions().toSet());
            if (this.remainingPartitions().isEmpty()) {
                if (this.numRetriesWhenNoTopicPartitions() < 30) {
                    this.debug((Function0<String> & Serializable)() -> "Can't find " + $this.topic + " from metadata cache, retries so far " + this.numRetriesWhenNoTopicPartitions());
                    this.numRetriesWhenNoTopicPartitions_$eq(this.numRetriesWhenNoTopicPartitions() + 1);
                    this.remainingPartitions_$eq(null);
                } else {
                    this.debug((Function0<String> & Serializable)() -> $this.topic + " can't be found from metadata cache. The topic might be deleted");
                    this.done_$eq(true);
                }
            }
        }
        this.isPendingRestoreMirror_$eq((option = (mirrorState = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic))) instanceof Some && (some = (Some)option).value() instanceof ClusterLinkTopicState.PendingRestoreMirror);
        if (this.remainingPartitions() == null) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        if (!this.done() && (this.hasMirrorStartOffsets() || this.isPendingRestoreMirror()) && this.clientManager.metadataManager().isLinkCoordinator(this.clientManager.linkData().linkName())) {
            return this.transition(new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty()));
        }
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (!this.clearOffsetsDone()) {
            if (this.remainingPartitions().nonEmpty()) {
                return this.processPartitions(taskContext, CollectionConverters$.MODULE$.MutableSetHasAsJava(this.remainingPartitions()).asJava());
            }
            return this.processCompletedTopic(taskContext);
        }
        if (this.isPendingRestoreMirror()) {
            if (!this.consumerGroupOffsetClampingDone()) {
                return this.listGroups(taskContext);
            }
            return this.startMirrorTopic(taskContext);
        }
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult processPartitions(ClusterLinkScheduler.TaskContext taskContext, Set<TopicPartition> partitions) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.debug((Function0<String> & Serializable)() -> "Processing partitions that require update: " + partitions);
        try {
            ReplicaStatusResult result = this.localAdmin.replicaStatus(partitions);
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleReplicaStatusResult((ClusterLinkScheduler.TaskContext)tc, result.partitionResults()), taskContext));
            taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        catch (ExecutionException e) {
            String errMsg = "Failed to retrieve replica status for " + partitions;
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg(errMsg, true, e)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatusResult(ClusterLinkScheduler.TaskContext taskContext, Map<TopicPartition, KafkaFuture<PartitionResult>> partitionResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        IntRef nonRetriableErrors = IntRef.create(0);
        BooleanRef complete = BooleanRef.create(true);
        scala.collection.mutable.Map results = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                TopicPartition tp = (TopicPartition)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    PartitionResult partitionResult = (PartitionResult)future.get();
                    results.update(tp, partitionResult);
                    if (this.truncationComplete(tp, partitionResult)) {
                        v0 = this.remainingPartitions().$minus$eq(tp);
                    } else {
                        complete$1.elem = false;
                        v0 = BoxedUnit.UNIT;
                    }
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RetriableException) {
                        String errMsg = "Got retriable exception when trying to fetch replica status for topic partition " + tp;
                        this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                        option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                    }
                    String errMsg = "Failed to get replica status for partition " + tp;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    ++nonRetriableErrors$1.elem;
                    option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (this.isPendingRestoreMirror()) {
            this.partitionLogEndOffsetAndEpochs_$eq((scala.collection.mutable.Map)results.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition part = (TopicPartition)tuple2._1();
                    PartitionResult partResult = (PartitionResult)tuple2._2();
                    Buffer rsList = CollectionConverters$.MODULE$.ListHasAsScala(partResult.replicas()).asScala();
                    ReplicaStatus leader = (ReplicaStatus)((IterableOps)rsList.filter((Function1<ReplicaStatus, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isLeader()))).head();
                    int leaderEpoch = partResult.leaderEpoch().orElse(-1);
                    Option<Object> mirrorInfo = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null));
                    if (mirrorInfo.exists((Function1<Object, Object>)(Function1<ReplicaStatus.MirrorInfo, Object> & Serializable)info -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleReplicaStatusResult$6(info))) && ((IterableOnceOps)rsList.filter((Function1<ReplicaStatus, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isInIsr()))).forall((Function1<ReplicaStatus, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleReplicaStatusResult$8(leader, x$7))) && leaderEpoch >= 0) {
                        return new Some<Tuple2<TopicPartition, OffsetAndEpoch>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(part), new OffsetAndEpoch(leader.logEndOffset(), leaderEpoch)));
                    }
                    return None$.MODULE$;
                }
                throw new MatchError(tuple2);
            }));
        }
        if (nonRetriableErrors.elem > 0) {
            this.warn((Function0<String> & Serializable)() -> "Failed to get replica status for " + nonRetriableErrors$1.elem + " partitions. Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (this.isPendingRestoreMirror() && this.partitionLogEndOffsetAndEpochs().size() != results.size()) {
            this.info((Function0<String> & Serializable)() -> "Not all mirror partitions are in PendingRestore for topic '" + $this.topic + "', awaiting state change. Will retry in " + this.super$rescheduleDelayMs() + " ms");
            return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
        }
        if (complete.elem && newTaskContext.errs().isEmpty()) {
            return this.processCompletedTopic(newTaskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult processCompletedTopic(ClusterLinkScheduler.TaskContext taskContext) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            this.info((Function0<String> & Serializable)() -> "Clearing start offsets for mirror topic " + $this.topic);
            AlterMirrorsResult result = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.CLEAR_OFFSETS));
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterMirrorsResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
            taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        catch (ExecutionException e) {
            String errMsg = "Failed to clear start offsets for mirror topic " + this.topic;
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg(errMsg, true, e)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleAlterMirrorsResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        scala.collection.mutable.Set nonRetriableErrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    future.get();
                    this.clearOffsetsDone_$eq(true);
                    this.info((Function0<String> & Serializable)() -> "Successfully cleared start offsets for mirror '" + topic + "'");
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RetriableException) {
                        String errMsg = "Got retriable exception when trying to clear start offsets for mirror topic " + topic;
                        this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                        option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                    }
                    String errMsg = "Failed to clear mirror start offsets for mirror topic " + topic;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    nonRetriableErrorTopics.$plus$eq(topic);
                    option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (nonRetriableErrorTopics.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Failed to clear start offsets for mirror topics " + nonRetriableErrorTopics + ". Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        if (errs.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
        }
        return this.transition(taskContext);
    }

    private ClusterLinkScheduler.TaskResult listGroups(ClusterLinkScheduler.TaskContext taskContext) {
        this.debug((Function0<String> & Serializable)() -> "Listing consumer groups for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkGroupFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix(), None$.MODULE$, this.clientManager.currentConfig().linkMode()));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Found empty group filters, no consumer group offsets to sync for consumer offset clamping.");
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        this.info((Function0<String> & Serializable)() -> "Syncing consumer group offsets for mirror topic " + $this.topic + " for consumer offset clamping");
        ListConsumerGroupsResult result = this.localAdmin.listConsumerGroups();
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroups((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ConsumerGroupListing>>)result.all()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroups(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ConsumerGroupListing>> future) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree1$1(future);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option resultOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(resultOpt, errOpt2);
        Option resultOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            this.warn((Function0<String> & Serializable)() -> "Unable to process list consumer groups request for consumer offset clamping.");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.processListGroups(taskContext, ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resultOpt2.get()).asScala().map((Function1<ConsumerGroupListing, String> & Serializable)x$9 -> x$9.groupId())).toSet());
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult processListGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        this.debug((Function0<String> & Serializable)() -> "Processing consumer groups for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)((IterableOps)ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.groupFilters())._1()).map((Function1<MatchedGroup, String> & Serializable)x$10 -> x$10.name());
        if (matchedGroups.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "No consumer groups match the filters for consumer offset clamping. Starting the mirror now.");
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        return this.listGroupOffsets(taskContext, matchedGroups);
    }

    private ClusterLinkScheduler.TaskResult listGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        this.debug((Function0<String> & Serializable)() -> "Listing consumer group offsets for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(this.allPartitions().toList()).asJava());
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groups.foreach((Function1<String, Object> & Serializable)group -> {
            ClusterLinkClearMirrorStartOffsets.$anonfun$listGroupOffsets$2(this, spec, futures, group);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$1.elem), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)futures.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    Map result = (Map)future.get();
                    object = this.filterListGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap($less$colon$less$.MODULE$.refl()));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle list consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    unSyncedGroups.put(group, this.taskErrorCodeAndMsg("Failed to list group offsets for " + group, true, e));
                    object = Predef$.MODULE$.Map().empty();
                }
                scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> res = object;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), res);
            }
            throw new MatchError(tuple2);
        }).filterNot((Function1<Tuple2, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleListGroupOffsets$4(x$11)));
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets " + unSyncedGroups.keySet().mkString(",") + " when handling the list consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        }
        if (groupOffsets.isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        return this.alterGroupOffsets(taskContext, groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetAndMetadata offsetMeta = (OffsetAndMetadata)tuple2._2();
                Option option = this.partitionLogEndOffsetAndEpochs().get(partition).map((Function1<OffsetAndEpoch, Object> & Serializable)x$12 -> BoxesRunTime.boxToLong(x$12.offset()));
                if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    long logEndOffset = BoxesRunTime.unboxToLong(some.value());
                    if (offsetMeta == null) {
                        option2 = None$.MODULE$;
                    } else if (logEndOffset < offsetMeta.offset()) {
                        this.info((Function0<String> & Serializable)() -> "Rolling back offset for group '" + group + "' and topic '" + $this.topic + "' from '" + offsetMeta.offset() + " to '" + logEndOffset + "'");
                        option2 = new Some<Long>(BoxesRunTime.boxToLong(logEndOffset));
                    } else {
                        option2 = None$.MODULE$;
                    }
                    None$ offset = option2;
                    return offset.map((Function1<Object, Tuple2> & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), new OffsetAndMetadata(BoxesRunTime.unboxToLong(off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                }
                if (None$.MODULE$.equals(option)) {
                    this.error((Function0<String> & Serializable)() -> "Unexpected partition '" + partition + "', skipping");
                    return None$.MODULE$;
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        });
    }

    private ClusterLinkScheduler.TaskResult alterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        this.debug((Function0<String> & Serializable)() -> "Altering consumer group offsets for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groupOffsets.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ClusterLinkClearMirrorStartOffsets.$anonfun$alterGroupOffsets$2(this, futures, x0$1);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$2.elem), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleAlterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<TaskErrorCodeAndMsg> option;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    option = future.get();
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle alter consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    option = unSyncedGroups.put(group, this.taskErrorCodeAndMsg("Failed to alter consumer offsets for group " + group, true, e));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets " + unSyncedGroups.keySet().mkString(",") + " when handling the alter consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        }
        this.consumerGroupOffsetClampingDone_$eq(true);
        return this.transition(new ClusterLinkScheduler.TaskContext(taskContext.errs()));
    }

    private ClusterLinkScheduler.TaskResult startMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        Some some;
        this.info((Function0<String> & Serializable)() -> "Clamped necessary consumer group offsets for mirror topic " + $this.topic + ", restoring mirror topic");
        scala.collection.immutable.Set<TopicPartition> topicPartitions = this.clientManager.metadataManager().topicPartitions(this.topic);
        if (topicPartitions.size() != this.allPartitions().size()) {
            this.warn((Function0<String> & Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset clamping.");
            this.consumerGroupOffsetClampingDone_$eq(false);
            return this.transition(taskContext);
        }
        Option option = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some && (some = (Some)option).value() instanceof ClusterLinkTopicState.PendingRestoreMirror) {
            this.info((Function0<String> & Serializable)() -> "Restoring mirror topic " + $this.topic);
            AlterMirrorsResult result = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.START_PENDING_RESTORE_MIRROR));
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleStartMirrorResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        this.warn((Function0<String> & Serializable)() -> "Mirror topic " + $this.topic + " is no longer in in PendingRestore state, shutting down task.");
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult handleStartMirrorResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicResults) {
        Iterable errs;
        block0: {
            ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
            scala.collection.mutable.Set nonRetriableErrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option;
                    String topic = (String)tuple2._1();
                    KafkaFuture future = (KafkaFuture)tuple2._2();
                    try {
                        future.get();
                        this.done_$eq(true);
                        this.info((Function0<String> & Serializable)() -> "Successfully restored mirror topic '" + topic + "'");
                        option = None$.MODULE$;
                    }
                    catch (ExecutionException e) {
                        Throwable throwable = e.getCause();
                        if (throwable instanceof RetriableException) {
                            String errMsg = "Failed to start mirror topic " + topic + " due to retriable exception.";
                            this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                        }
                        String errMsg = "Failed to start mirror topic " + topic;
                        excessiveLoggingHandler.handle(e, this, errMsg);
                        nonRetriableErrorTopics.$plus$eq(topic);
                        option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg(errMsg, true, e));
                    }
                    return option;
                }
                throw new MatchError(tuple2);
            });
            if (!nonRetriableErrorTopics.nonEmpty()) break block0;
            this.warn((Function0<String> & Serializable)() -> "Failed to clear start offsets for mirror topics " + nonRetriableErrorTopics + ". Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.clientManager.metadataManager().isLinkCoordinator(this.clientManager.linkData().linkName())) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkClearMirrorStartOffsetsTaskType$.MODULE$, this.isPendingRestoreMirror(), "clear start offsets"));
        } else {
            this.taskDesc_$eq(None$.MODULE$);
        }
        if (this.done()) {
            this.debug((Function0<String> & Serializable)() -> "Clear start offsets task completed for topic '" + $this.topic + "'.'");
            this.shutdown();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof UnknownTopicOrPartitionException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsgPrefix + " due to the topic not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteMirrorNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the mirror topic not existing on the remote cluster.");
        }
        if (throwable instanceof ClusterLinkNotFoundException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(LinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the remote cluster.");
        }
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasMirrorStartOffsets() {
        Option option = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (!state.mirrorStartOffsets().exists(x$13 -> x$13 > 0L)) return false;
            MirrorTruncateMode mirrorTruncateMode = this.mirrorTruncateMode(state);
            MirrorTruncateMode$Ignore$ mirrorTruncateMode$Ignore$ = MirrorTruncateMode$Ignore$.MODULE$;
            if (mirrorTruncateMode == null) {
                if (mirrorTruncateMode$Ignore$ == null) return false;
                return true;
            } else if (mirrorTruncateMode.equals(mirrorTruncateMode$Ignore$)) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return false;
    }

    private boolean truncationComplete(TopicPartition tp, PartitionResult partitionResult) {
        return this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic).filter((Function1<ClusterLinkTopicState, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$1(this, tp, state))).forall((Function1<ClusterLinkTopicState, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$2(this, tp, partitionResult, state)));
    }

    private boolean matchReplicas(PartitionResult partitionResult, Function1<ReplicaStatus, Object> predicate) {
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(partitionResult.replicas()).asScala().filter((Function1<ReplicaStatus, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.isIsrEligible()));
        return replicas.nonEmpty() && replicas.forall(predicate);
    }

    public MirrorTruncateMode mirrorTruncateMode(ClusterLinkTopicState mirrorState) {
        return mirrorState.state().mirrorTruncateMode();
    }

    public static final /* synthetic */ boolean $anonfun$handleReplicaStatusResult$6(ReplicaStatus.MirrorInfo info) {
        ReplicaStatus.MirrorInfo.State state = info.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_RESTORE;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleReplicaStatusResult$8(ReplicaStatus leader$1, ReplicaStatus x$7) {
        return x$7.logEndOffset() == leader$1.logEndOffset();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture future$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            Collection result = (Collection)future$1.get();
            tuple2 = new Tuple2<Some<Collection>, None$>(new Some<Collection>(result), None$.MODULE$);
        }
        catch (ExecutionException e) {
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to list the consumer groups", true, e)));
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$2(ClusterLinkClearMirrorStartOffsets $this, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, String group) {
        ListConsumerGroupOffsetsResult result = $this.localAdmin.listConsumerGroupOffsets(Collections.singletonMap(group, spec$1));
        futures$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.partitionsToOffsetAndMetadata()));
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$11) {
        return ((IterableOnceOps)x$11._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$2(ClusterLinkClearMirrorStartOffsets $this, ObjectRef futures$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String group = (String)tuple2._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)tuple2._2();
            AlterConsumerGroupOffsetsResult result = $this.localAdmin.alterConsumerGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsJava(offsets).asJava());
            futures$2.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.all()));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$1(ClusterLinkClearMirrorStartOffsets $this, TopicPartition tp$1, ClusterLinkTopicState state) {
        MirrorTruncateMode mirrorTruncateMode = $this.mirrorTruncateMode(state);
        MirrorTruncateMode$Ignore$ mirrorTruncateMode$Ignore$ = MirrorTruncateMode$Ignore$.MODULE$;
        return (mirrorTruncateMode == null ? mirrorTruncateMode$Ignore$ != null : !mirrorTruncateMode.equals(mirrorTruncateMode$Ignore$)) && state.mirrorStartOffsets().size() > tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$3(long expectedOffset$1, ReplicaStatus x$14) {
        return x$14.logStartOffset() >= expectedOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$4(long expectedOffset$1, ReplicaStatus x$15) {
        return x$15.logEndOffset() <= expectedOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$2(ClusterLinkClearMirrorStartOffsets $this, TopicPartition tp$1, PartitionResult partitionResult$1, ClusterLinkTopicState state) {
        long expectedOffset = BoxesRunTime.unboxToLong(state.mirrorStartOffsets().apply(tp$1.partition()));
        MirrorTruncateMode mirrorTruncateMode = $this.mirrorTruncateMode(state);
        if (MirrorTruncateMode$Ignore$.MODULE$.equals(mirrorTruncateMode)) {
            return false;
        }
        if (MirrorTruncateMode$TruncateAtStart$.MODULE$.equals(mirrorTruncateMode)) {
            return $this.matchReplicas(partitionResult$1, (Function1<ReplicaStatus, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$3(expectedOffset, x$14)));
        }
        if (MirrorTruncateMode$TruncateFromEnd$.MODULE$.equals(mirrorTruncateMode)) {
            return $this.matchReplicas(partitionResult$1, (Function1<ReplicaStatus, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$4(expectedOffset, x$15)));
        }
        throw new MatchError(mirrorTruncateMode);
    }

    public ClusterLinkClearMirrorStartOffsets(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkClearMirrorStartOffsets", intervalMs, time, quota);
        this.numRetriesWhenNoTopicPartitions = 0;
        this.done = false;
        this.clearOffsetsDone = false;
        this.consumerGroupOffsetClampingDone = false;
        this.isPendingRestoreMirror = false;
        this.taskDesc = None$.MODULE$;
    }
}

