/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConvertToMirrorTopicTaskType$;
import kafka.server.link.ClusterLinkConvertTopicToMirror$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorNotFoundTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u0016-\u0001MB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011%\u0019\u0006A!A!\u0002\u0013!\u0016\rC\u0005c\u0001\t\u0005\t\u0015!\u0003dO\"I\u0001\u000e\u0001B\u0001B\u0003%\u0011.\u001c\u0005\u0006_\u0002!\t\u0001\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011\u001dq\b\u00011A\u0005\n}Dq!a\u0003\u0001A\u0003&1\u0010\u0003\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003{\u0011%\ty\u0001\u0001a\u0001\n\u0013\t\t\u0002C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B>\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0007\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013%\u0011Q\u0005\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0002\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA%\u0001\u0001\u0007I\u0011BA&\u0011%\tI\u0006\u0001a\u0001\n\u0013\tY\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA'\u0011\u001d\tI\u0007\u0001C)\u0003WBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDq!!>\u0001\t\u0013\t9\u0010C\u0004\u0002~\u0002!I!a@\t\u000f\u0005u\b\u0001\"\u0015\u0003\u0004!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\u000e\u0005g\u0001\u0001\u0013aA\u0001\u0002\u0013%!QG7\b\u0013\t]B&!A\t\u0002\teb\u0001C\u0016-\u0003\u0003E\tAa\u000f\t\r=DC\u0011\u0001B\"\u0011%\u0011)\u0005KI\u0001\n\u0003\u00119EA\u0010DYV\u001cH/\u001a:MS:\\7i\u001c8wKJ$Hk\u001c9jGR{W*\u001b:s_JT!!\f\u0018\u0002\t1Lgn\u001b\u0006\u0003_A\naa]3sm\u0016\u0014(\"A\u0019\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000e\t\u0003ker!AN\u001c\u000e\u00031J!\u0001\u000f\u0017\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tQ4H\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u00029Y\u0005)Ao\u001c9jGB\u0011ah\u0012\b\u0003\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u001a\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001b\u0015!D2mS\u0016tG/T1oC\u001e,'\u000f\u0005\u00027\u0019&\u0011Q\n\f\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0011\u0005Y\u0002\u0016BA)-\u0005U\u0019E.^:uKJd\u0015N\\6CCR\u001c\u0007.\u00113nS:\f!\u0002\\8dC2\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005U{V\"\u0001,\u000b\u0005]C\u0016!B;uS2\u001c(BA-[\u0003\u0019\u0019w.\\7p]*\u0011\u0011g\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a-\n!A+[7f\u0013\t\u0019\u0016(A\u0003rk>$\u0018\r\u0005\u0002eK6\ta&\u0003\u0002g]\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003Ef\n!\"\u001b8uKJ4\u0018\r\\'t!\tQ7.D\u0001D\u0013\ta7IA\u0002J]RL!A\\\u001d\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\tcJ\u001cH/\u001e<xqB\u0011a\u0007\u0001\u0005\u0006y!\u0001\r!\u0010\u0005\u0006\u0015\"\u0001\ra\u0013\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u0006%\"\u0001\ra\u0014\u0005\u0006'\"\u0001\r\u0001\u0016\u0005\u0006E\"\u0001\ra\u0019\u0005\bQ\"\u0001\n\u00111\u0001j\u0003E\u0019\bn\\;mIN#\u0018M\u001d;NSJ\u0014xN]\u000b\u0002wB\u0011!\u000e`\u0005\u0003{\u000e\u0013qAQ8pY\u0016\fg.A\u000btQ>,H\u000eZ*uCJ$X*\u001b:s_J|F%Z9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004U\u0006\r\u0011bAA\u0003\u0007\n!QK\\5u\u0011!\tIACA\u0001\u0002\u0004Y\u0018a\u0001=%c\u0005\u00112\u000f[8vY\u0012\u001cF/\u0019:u\u001b&\u0014(o\u001c:!\u0003%\u0011WmZ5o)\u0006\u001c8.A\u0007cK\u001eLg\u000eV1tW~#S-\u001d\u000b\u0005\u0003\u0003\t\u0019\u0002\u0003\u0005\u0002\n5\t\t\u00111\u0001|\u0003)\u0011WmZ5o)\u0006\u001c8\u000eI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\u0011\u00111\u0004\t\u0004m\u0005u\u0011bAA\u0010Y\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u0001R.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fI\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cXCAA\u0014!\u0015q\u0014\u0011FA\u0017\u0013\r\tY#\u0013\u0002\u0004'\u0016$\b\u0003BA\u0018\u0003ci\u0011\u0001W\u0005\u0004\u0003gA&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\t\t!!\u000f\t\u0013\u0005%!#!AA\u0002\u0005\u001d\u0012a\u00039beRLG/[8og\u0002\nq#\u001a=dKN\u001c\u0018N^3M_\u001e<\u0017N\\4IC:$G.\u001a:\u0016\u0005\u0005\u0005\u0003c\u0001\u001c\u0002D%\u0019\u0011Q\t\u0017\u0003/\u0015C8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014\u0018\u0001G3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3sA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002NA)!.a\u0014\u0002T%\u0019\u0011\u0011K\"\u0003\r=\u0003H/[8o!\r1\u0014QK\u0005\u0004\u0003/b#a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005\u0005\u0011Q\f\u0005\n\u0003\u00139\u0012\u0011!a\u0001\u0003\u001b\n\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007a\t\u0019\u0007E\u0002k\u0003KJ1!a\u001aD\u0005!1x\u000e\\1uS2,\u0017a\u0001:v]R\u0011\u0011Q\u000e\t\u0005\u0003_\niHD\u0002\u0002r]rA!a\u001d\u0002|9!\u0011QOA=\u001d\r\u0001\u0015qO\u0005\u0002c%\u0011q\u0006M\u0005\u0003[9J1!a <\u0005)!\u0016m]6SKN,H\u000e^\u0001\u0017G\",7m[*pkJ\u001cW\rV8qS\u000e\u001cF/\u0019;vgR!\u0011QNAC\u0011\u001d\t9I\u0007a\u0001\u0003\u0013\u000b1\u0002^1tW\u000e{g\u000e^3yiB!\u0011qNAF\u0013\r\tii\u000f\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\u0010iC:$G.\u001a#fg\u000e\u0014\u0018NY3T_V\u00148-\u001a+pa&\u001c'+Z:vYR$b!!\u001c\u0002\u0014\u0006U\u0005bBAD7\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003/[\u0002\u0019AAM\u0003Y\u0019x.\u001e:dKR{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007CBA\u0018\u00037\u000by*C\u0002\u0002\u001eb\u00131bS1gW\u00064U\u000f^;sKB9\u0011\u0011UAV{\u0005=VBAAR\u0015\u0011\t)+a*\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\u000bAA[1wC&!\u0011QVAR\u0005\ri\u0015\r\u001d\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0015\tG-\\5o\u0015\r\tILW\u0001\bG2LWM\u001c;t\u0013\u0011\ti,a-\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0017\u0001H2iK\u000e\\7k\\;sG\u0016$v\u000e]5d\u001b&\u0014(o\u001c:Ti\u0006$Xo\u001d\u000b\u0005\u0003[\n\u0019\rC\u0004\u0002\br\u0001\r!!#\u0002G!\fg\u000e\u001a7f'>,(oY3U_BL7-T5se>\u00148\u000b^1ukN\u0014Vm];miR1\u0011QNAe\u0003\u0017Dq!a\"\u001e\u0001\u0004\tI\tC\u0004\u0002Nv\u0001\r!a4\u00029M|WO]2f\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]B1\u0011qFAN\u0003#\u0004r!!)\u0002,v\n\u0019\u000e\u0005\u0003\u00022\u0006U\u0017\u0002BAl\u0003g\u0013a#T5se>\u0014Hk\u001c9jG\u0012+7o\u0019:jaRLwN\\\u0001\u001agR\f'\u000f^(s!\u0006,8/\u001a)f]\u0012LgnZ'jeJ|'\u000f\u0006\u0003\u0002n\u0005u\u0007bBAD=\u0001\u0007\u0011\u0011R\u0001&Q\u0006tG\r\\3Ti\u0006\u0014Ho\u0014:QCV\u001cX\rU3oI&tw-T5se>\u0014(+Z:vYR$b!!\u001c\u0002d\u0006\u0015\bbBAD?\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003O|\u0002\u0019AAu\u0003\u0019\u0011Xm];miB!\u0011\u0011WAv\u0013\u0011\ti/a-\u0003%\u0005cG/\u001a:NSJ\u0014xN]:SKN,H\u000e^\u0001\u0010M\u0006LG.T5se>\u0014Hk\u001c9jGR!\u0011QNAz\u0011\u001d\t9\t\ta\u0001\u0003\u0013\u000ba\u0003[1oI2,g)Y5m\u001b&\u0014(o\u001c:SKN,H\u000e\u001e\u000b\u0007\u0003[\nI0a?\t\u000f\u0005\u001d\u0015\u00051\u0001\u0002\n\"9\u0011q]\u0011A\u0002\u0005%\u0018\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BA7\u0005\u0003Aq!a\"#\u0001\u0004\tI\t\u0006\u0003\u0002\u0002\t\u0015\u0001bBAtG\u0001\u0007!q\u0001\t\u0004k\t%\u0011b\u0001B\u0006w\t\u00192i\\7qY\u0016$X\r\u001a+bg.\u0014Vm];mi\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u0002N\u0005\u0019B/Y:l\u000bJ\u0014xN]\"pI\u0016\fe\u000eZ'tORA!Q\u0003B\u000e\u0005?\u0011\u0019\u0003E\u00027\u0005/I1A!\u0007-\u0005M!\u0016m]6FeJ|'oQ8eK\u0006sG-T:h\u0011\u0019\u0011i\"\na\u0001{\u0005aQM\u001d:Ng\u001e\u0004&/\u001a4jq\"1!\u0011E\u0013A\u0002m\fa\u0002\\8dC2\fE-\\5o+N,G\rC\u0004\u0003&\u0015\u0002\rAa\n\u0002\u0005\u0015D\b\u0003\u0002B\u0015\u0005_i!Aa\u000b\u000b\t\t5\u00121U\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\u0019\u0005W\u0011!#\u0012=fGV$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u000692/\u001e9fe\u0012\u0012Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u000b\u0002S\u0006y2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>\u0004\u0018n\u0019+p\u001b&\u0014(o\u001c:\u0011\u0005YB3c\u0001\u0015\u0003>A\u0019!Na\u0010\n\u0007\t\u00053I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001B%U\rI'1J\u0016\u0003\u0005\u001b\u0002BAa\u0014\u0003Z5\u0011!\u0011\u000b\u0006\u0005\u0005'\u0012)&A\u0005v]\u000eDWmY6fI*\u0019!qK\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\\\tE#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ClusterLinkConvertTopicToMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private boolean shouldStartMirror;
    private boolean beginTask;
    private final ClusterLinkMetadataManager metadataManager;
    private Set<TopicPartition> partitions;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkConvertTopicToMirror$.MODULE$.$lessinit$greater$default$7();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean shouldStartMirror() {
        return this.shouldStartMirror;
    }

    private void shouldStartMirror_$eq(boolean x$1) {
        this.shouldStartMirror = x$1;
    }

    private boolean beginTask() {
        return this.beginTask;
    }

    private void beginTask_$eq(boolean x$1) {
        this.beginTask = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Cannot reverse and swap mirror topic for deleted topic '" + $this.topic + "'. Shutting down ClusterLinkConvertToMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        boolean bl = false;
        Some some = null;
        Option option = mirrorState;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (state instanceof ClusterLinkTopicState.PendingMirror) {
                ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)state;
                if (pendingMirror.nextState().equals(MirrorTopic.State.PAUSED.stateName())) {
                    this.shouldStartMirror_$eq(false);
                } else if (pendingMirror.nextState().equals(MirrorTopic.State.MIRROR.stateName())) {
                    this.shouldStartMirror_$eq(true);
                } else {
                    this.warn((Function0<String> & Serializable)() -> "See unsupported mirror '" + pendingMirror + "' for the next state for mirror topic " + $this.topic + ", will shut down ClusterLinkConvertToMirrorTopic task");
                    this.beginTask_$eq(false);
                }
                if (this.beginTask()) {
                    this.info((Function0<String> & Serializable)() -> "Starting task to convert PendingMirror topic " + $this.topic + " with shouldStartMirror=" + this.shouldStartMirror());
                    return this.checkSourceTopicStatus(taskContext);
                }
                return this.onCompletion(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See mirror '" + state + "' for mirror topic '" + $this.topic + "', not performing ClusterLinkConvertToMirrorTopic task");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror state for mirror topic '" + $this.topic + "', not performing ClusterLinkConvertToMirrorTopic task");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult checkSourceTopicStatus(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Describing source topic " + $this.topic + " to check existence");
        KafkaFuture sourceTopicDescription = this.remoteAdmin.describeTopics(Collections.singleton(this.topic)).allTopicNames();
        this.scheduleWhenComplete(sourceTopicDescription, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleDescribeSourceTopicResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Map<String, TopicDescription>>)sourceTopicDescription), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeSourceTopicResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Map<String, TopicDescription>> sourceTopicDescription) {
        ClusterLinkScheduler.TaskResult taskResult;
        block13: {
            Object object = new Object();
            try {
                Option errOpt;
                Tuple2 tuple2 = this.liftedTree1$1(sourceTopicDescription, object, taskContext);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option topicDescriptionOpt = (Option)tuple2._1();
                Option errOpt2 = (Option)tuple2._2();
                Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(topicDescriptionOpt, errOpt2);
                Option topicDescriptionOpt2 = tuple22._1();
                Option option = errOpt = tuple22._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
                    taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
                    break block13;
                }
                if (None$.MODULE$.equals(option)) {
                    if (topicDescriptionOpt2.isEmpty()) {
                        throw new IllegalStateException("Topic description is null but there was no error.");
                    }
                    TopicDescription topicDescription = (TopicDescription)topicDescriptionOpt2.get();
                    if (topicDescription == null) {
                        this.warn((Function0<String> & Serializable)() -> "Source topic " + $this.topic + " metadata is null on remote cluster. Will retry ClusterLinkConvertToMirrorTopic task in " + this.super$rescheduleDelayMs());
                        taskResult = ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
                    } else {
                        Uuid sourceTopicId = ((ClusterLinkTopicState)((Tuple2)this.metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).head())._2()).sourceTopicId();
                        Uuid remoteTopicId = topicDescription.topicId();
                        if (!remoteTopicId.equals((Object)sourceTopicId)) {
                            this.warn((Function0<String> & Serializable)() -> "Remote topic id " + remoteTopicId + " is not the same as the source topic id of the local mirror topic " + sourceTopicId + ". Failing local mirror topic and shutting down ClusterLinkConvertToMirrorTopic task.");
                            taskResult = this.failMirrorTopic(taskContext);
                        } else if (topicDescription.partitions().size() != this.partitions().size()) {
                            this.warn((Function0<String> & Serializable)() -> "Remote topic " + $this.topic + " does not have the same number of partitions as the local mirror topic. Will retry ClusterLinkConvertToMirrorTopic task in " + this.super$rescheduleDelayMs());
                            taskResult = ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
                        } else {
                            this.info((Function0<String> & Serializable)() -> "Verified source topic " + $this.topic + " exists on remote cluster with same number of partitions as local mirror topic " + $this.topic + " and same topic id as source topic id of local mirror topic. Will now check for source topic's mirror status.");
                            taskResult = this.checkSourceTopicMirrorStatus(taskContext);
                        }
                    }
                    break block13;
                }
                throw new MatchError(option);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    taskResult = (ClusterLinkScheduler.TaskResult)ex.value();
                }
                throw ex;
            }
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult checkSourceTopicMirrorStatus(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Checking mirror status of source topic " + $this.topic + " on remote cluster.");
        KafkaFuture sourceTopicMirrorDescription = this.remoteAdmin.describeMirrors(Collections.singleton(this.topic)).all();
        this.scheduleWhenComplete(sourceTopicMirrorDescription, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleSourceTopicMirrorStatusResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Map<String, MirrorTopicDescription>>)sourceTopicMirrorDescription), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleSourceTopicMirrorStatusResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Map<String, MirrorTopicDescription>> sourceMirrorTopicDescription) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree2$1(sourceMirrorTopicDescription);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option topicDescriptionMapOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(topicDescriptionMapOpt, errOpt2);
        Option topicDescriptionMapOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            TaskErrorCode taskErrorCode = err.code();
            RemoteLinkNotFoundTaskErrorCode$ remoteLinkNotFoundTaskErrorCode$ = RemoteLinkNotFoundTaskErrorCode$.MODULE$;
            if (!(taskErrorCode != null ? !taskErrorCode.equals(remoteLinkNotFoundTaskErrorCode$) : remoteLinkNotFoundTaskErrorCode$ != null)) {
                String errMsg = "Source topic " + this.topic + " is not a mirror topic on the remote cluster. Shutting down ClusterLinkConvertToMirrorTopic task";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                return this.onCompletion(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$))));
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            if (topicDescriptionMapOpt2.isEmpty()) {
                throw new IllegalStateException("There is no topic description even though there was no error.");
            }
            if (topicDescriptionMapOpt2.get() == null) {
                String errMsg = "Source mirror topic description map is null, may be stale metadata. Will retry in " + super.rescheduleDelayMs();
                this.warn((Function0<String> & Serializable)() -> errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            MirrorTopicDescription topicDescription = (MirrorTopicDescription)((Map)sourceMirrorTopicDescription.get()).get(this.topic);
            if (topicDescription == null) {
                String errMsg = "Source mirror topic description is null, may be stale metadata. Will retry in " + super.rescheduleDelayMs();
                this.warn((Function0<String> & Serializable)() -> errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            MirrorTopicDescription.State state = topicDescription.state();
            MirrorTopicDescription.State state2 = state;
            if (MirrorTopicDescription.State.STOPPED.equals(state2)) {
                String action = this.shouldStartMirror() ? "start" : "pause";
                this.info((Function0<String> & Serializable)() -> "Source topic mirror status is in a STOPPED mirror state. Will proceed to " + action + " the local mirror " + $this.topic + ".");
                return this.startOrPausePendingMirror(taskContext);
            }
            if (MirrorTopicDescription.State.PENDING_SYNCHRONIZE.equals(state2) ? true : (MirrorTopicDescription.State.PENDING_STOPPED.equals(state2) ? true : MirrorTopicDescription.State.PAUSED.equals(state2))) {
                String errMsg = "Source topic is not yet in STOPPED mirror state. Will retry task in " + super.rescheduleDelayMs() + " ms.";
                this.debug((Function0<String> & Serializable)() -> errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            if (MirrorTopicDescription.State.LINK_PAUSED.equals(state2) ? true : (MirrorTopicDescription.State.LINK_FAILED.equals(state2) ? true : (MirrorTopicDescription.State.SOURCE_UNAVAILABLE.equals(state2) ? true : MirrorTopicDescription.State.UNKNOWN.equals(state2)))) {
                String errMsg = "Source topic may have some issues with its link configuration. Will retry task in " + super.rescheduleDelayMs() + " ms.";
                this.debug((Function0<String> & Serializable)() -> errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            if (MirrorTopicDescription.State.ACTIVE.equals(state2) ? true : (MirrorTopicDescription.State.FAILED.equals(state2) ? true : (MirrorTopicDescription.State.PENDING_REPAIR.equals(state2) ? true : (MirrorTopicDescription.State.PENDING_MIRROR.equals(state2) ? true : (MirrorTopicDescription.State.PENDING_SETUP_FOR_RESTORE.equals(state2) ? true : MirrorTopicDescription.State.PENDING_RESTORE.equals(state2)))))) {
                String errMsg = "Source topic is in unexpected state of " + state.toString() + ". This may be due to stale metadata, will retry task in " + super.rescheduleDelayMs() + " ms.";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            throw new MatchError(state2);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult startOrPausePendingMirror(ClusterLinkScheduler.TaskContext taskContext) {
        boolean bl = false;
        Some some = null;
        Option option = this.metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (some.value() instanceof ClusterLinkTopicState.PendingMirror) {
                this.info((Function0<String> & Serializable)() -> "Going to " + (this.shouldStartMirror() ? "start" : "pause") + " local mirror topic " + $this.topic);
                AlterMirrorOp op = this.shouldStartMirror() ? AlterMirrorOp.START_PENDING_MIRROR : AlterMirrorOp.PAUSE_PENDING_MIRROR;
                AlterMirrorsResult startOrPausePendingMirrorResult = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, op));
                this.scheduleWhenComplete(startOrPausePendingMirrorResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleStartOrPausePendingMirrorResult((ClusterLinkScheduler.TaskContext)tc, startOrPausePendingMirrorResult), taskContext));
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See mirror topic state " + state + " for mirror topic " + $this.topic + ", mirror topic state has changed from PendingMirror. Shutting down ClusterLinkConvertToMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror topic state found for mirror topic " + $this.topic + ", shutting down ClusterLinkConvertToMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult handleStartOrPausePendingMirrorResult(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        Option errOpt;
        Option option;
        try {
            result.all().get();
            String action = this.shouldStartMirror() ? "started" : "paused";
            this.info((Function0<String> & Serializable)() -> "Successfully " + action + " local mirror topic " + $this.topic + ". Shutting down task.");
            option = None$.MODULE$;
        }
        catch (ExecutionException e) {
            String action = this.shouldStartMirror() ? "start" : "pause";
            this.debug((Function0<String> & Serializable)() -> "Unable to " + action + " local mirror topic, will retry in " + this.super$rescheduleDelayMs() + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to " + action + " the local mirror topic " + this.topic, true, e));
        }
        Option option2 = errOpt = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option2)) {
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option2);
    }

    private ClusterLinkScheduler.TaskResult failMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        AlterMirrorsResult result = this.localAdmin.failMirror(this.topic, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED);
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleFailMirrorResult((ClusterLinkScheduler.TaskContext)tc, result), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleFailMirrorResult(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        Option errOpt;
        Option option;
        try {
            String action = this.shouldStartMirror() ? "start" : "pause";
            String errMsg = "Failing local mirror topic " + this.topic + " due to issues encountered when trying to " + action + " topic";
            this.warn((Function0<String> & Serializable)() -> errMsg);
            result.all().get();
            option = None$.MODULE$;
        }
        catch (ExecutionException e) {
            String errMsg = "Unable to fail local mirror topic " + this.topic + ", shutting down task. Please execute the failover command on the local mirror topic to make the topic writable";
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Unable to fail the local mirror topic " + this.topic, true, e));
        }
        Option option2 = errOpt = option;
        if (option2 instanceof Some) {
            Option option3 = option2;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)option3).value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option2)) {
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option2);
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Shutting down ClusterLinkConvertToMirrorTopic task.");
        this.shutdown();
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkConvertToMirrorTopicTaskType$.MODULE$, true, "transition the topic to a mirror"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof UnknownTopicOrPartitionException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsgPrefix + " due to the topic not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteMirrorNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the mirror topic not existing on the remote cluster.");
        }
        if (throwable instanceof ClusterLinkNotFoundException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(LinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the remote cluster.");
        }
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture sourceTopicDescription$2, Object nonLocalReturnKey1$1, ClusterLinkScheduler.TaskContext taskContext$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            TopicDescription topicDescription = (TopicDescription)((Map)sourceTopicDescription$2.get()).get(this.topic);
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>((None$)((Object)new Some<TopicDescription>(topicDescription)), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof UnknownTopicOrPartitionException) {
                this.warn((Function0<String> & Serializable)() -> "Topic " + $this.topic + " was not found on remote cluster. Failing mirror topic");
                throw new NonLocalReturnControl<ClusterLinkScheduler.TaskResult>(nonLocalReturnKey1$1, this.failMirrorTopic(taskContext$1));
            }
            this.excessiveLoggingHandler().handle(e, this, "Encountered exception while trying to describe source topic " + this.topic + ".");
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to describe the source topic " + this.topic, false, e)));
        }
        return tuple2;
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture sourceMirrorTopicDescription$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            Map topicDescriptionMap = (Map)sourceMirrorTopicDescription$1.get();
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>((None$)((Object)new Some<Map>(topicDescriptionMap)), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, "Encountered exception while trying to check mirror status of source topic " + this.topic + ".");
            TaskErrorCodeAndMsg errCodeAndMsg = this.taskErrorCodeAndMsg("Failed to check the mirror status of source topic " + this.topic, false, e);
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(errCodeAndMsg));
        }
        return tuple2;
    }

    public ClusterLinkConvertTopicToMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkConvertTopicToMirror-topic-" + topic, intervalMs, time, quota);
        this.shouldStartMirror = true;
        this.beginTask = true;
        this.metadataManager = clientManager.metadataManager();
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.taskDesc = None$.MODULE$;
    }
}

