/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.IOException;
import java.io.Serializable;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterJson;
import kafka.server.link.ClusterLinkGroupFilterJsonValidator;
import kafka.server.link.ClusterLinkTopicFilterJsonValidator;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicFilterJson;
import kafka.server.link.TopicType$;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class ClusterLinkFilterJson$ {
    public static final ClusterLinkFilterJson$ MODULE$ = new ClusterLinkFilterJson$();
    private static final ClusterLinkTopicFilterJsonValidator TOPIC_VALIDATOR = new ClusterLinkTopicFilterJsonValidator();
    private static final ClusterLinkGroupFilterJsonValidator GROUP_VALIDATOR = new ClusterLinkGroupFilterJsonValidator();
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    static {
        MODULE$.JSON_SERDE().configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, true);
        MODULE$.JSON_SERDE().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        MODULE$.JSON_SERDE().registerModule(DefaultScalaModule$.MODULE$);
    }

    public ClusterLinkTopicFilterJsonValidator TOPIC_VALIDATOR() {
        return TOPIC_VALIDATOR;
    }

    public ClusterLinkGroupFilterJsonValidator GROUP_VALIDATOR() {
        return GROUP_VALIDATOR;
    }

    public ObjectMapper JSON_SERDE() {
        return JSON_SERDE;
    }

    public Option<TopicFilterJson> parseTopic(String value) {
        Option<TopicFilterJson> parsed = this.parse(value, TopicFilterJson.class);
        parsed.foreach((Function1<TopicFilterJson, Object> & Serializable)x$2 -> {
            ClusterLinkFilterJson$.MODULE$.validate(x$2);
            return BoxedUnit.UNIT;
        });
        return parsed;
    }

    public Option<GroupFilterJson> parseGroup(String value) {
        Option<GroupFilterJson> parsed = this.parse(value, GroupFilterJson.class);
        this.validateEmptyTopicTypeArray(value);
        parsed.foreach((Function1<GroupFilterJson, Object> & Serializable)groupFilters -> {
            ClusterLinkFilterJson$.$anonfun$parseGroup$1(groupFilters);
            return BoxedUnit.UNIT;
        });
        return parsed;
    }

    private <T extends ClusterLinkFilterJson> Option<T> parse(String value, Class<T> c) {
        Some<ClusterLinkFilterJson> some;
        if (value == null || value.trim().isEmpty()) {
            return Option$.MODULE$.empty();
        }
        try {
            ObjectMapper JSON_SERDE = this.createObjectMapper();
            ClusterLinkFilterJson filterJson = (ClusterLinkFilterJson)JSON_SERDE.readValue(value, c);
            some = new Some<ClusterLinkFilterJson>(filterJson);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException ? true : (throwable2 instanceof JsonMappingException ? true : throwable2 instanceof JsonParseException)) {
                throw new IllegalArgumentException("Exception while parsing filter JSON: " + throwable2);
            }
            throw throwable;
        }
        return some;
    }

    private <T extends ClusterLinkFilterJson> void validateEmptyTopicTypeArray(String value) {
        JsonNode jsonNode = this.JSON_SERDE().readTree(value);
        if (jsonNode.has("groupFilters") && jsonNode.get("groupFilters").isArray()) {
            JsonNode groupFilters = jsonNode.get("groupFilters");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groupFilters.size()).foreach$mVc$sp(i -> {
                JsonNode filter = groupFilters.get(i);
                if (filter.has("topicTypes") && filter.get("topicTypes").isArray() && filter.get("topicTypes").size() == 0) {
                    throw new IllegalArgumentException("topicTypes cannot be empty");
                }
            });
            return;
        }
    }

    private <T extends ClusterLinkFilterJson> ObjectMapper createObjectMapper() {
        ObjectMapper JSON_SERDE = new ObjectMapper();
        JSON_SERDE.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, true);
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_SERDE.registerModule(DefaultScalaModule$.MODULE$);
        return JSON_SERDE;
    }

    private void validate(ClusterLinkFilterJson filterJson) {
        if (filterJson.filters() == null) {
            throw new IllegalArgumentException("ClusterLinkFilters cannot be the JSON null");
        }
        filterJson.filters().foreach((Function1<ClusterLinkFilter, Object> & Serializable)filter -> {
            ClusterLinkFilterJson$.$anonfun$validate$1(filter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$parseGroup$3(String topicType) {
        if (TopicType$.MODULE$.fromString(topicType).isEmpty()) {
            throw new IllegalArgumentException("Unknown topic type: " + topicType);
        }
    }

    public static final /* synthetic */ void $anonfun$parseGroup$2(GroupClusterLinkFilter filter) {
        if (filter.topicTypes() != null && filter.topicTypes().nonEmpty()) {
            Seq<String> topicTypes = filter.topicTypes();
            topicTypes.foreach((Function1<String, Object> & Serializable)topicType -> {
                ClusterLinkFilterJson$.$anonfun$parseGroup$3(topicType);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseGroup$1(GroupFilterJson groupFilters) {
        MODULE$.validate(groupFilters);
        groupFilters.filters().foreach((Function1<GroupClusterLinkFilter, Object> & Serializable)filter -> {
            ClusterLinkFilterJson$.$anonfun$parseGroup$2(filter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validate$1(ClusterLinkFilter filter) {
        String filterType = filter.filterType();
        if (filterType == null) {
            throw new IllegalArgumentException("filterType field may not be null.");
        }
        if (FilterType$.MODULE$.fromString(filterType).isEmpty()) {
            throw new IllegalArgumentException("Unknown filterType: " + filterType);
        }
        String patternType = filter.patternType();
        if (patternType == null) {
            throw new IllegalArgumentException("patternType field may not be null.");
        }
        if (patternType.isEmpty()) {
            throw new IllegalArgumentException("patternType field may not be empty.");
        }
        PatternType patternType2 = SecurityUtils.patternType((String)patternType);
        PatternType patternType3 = PatternType.UNKNOWN;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            throw new IllegalArgumentException("Unknown patternType: " + patternType);
        }
    }

    private ClusterLinkFilterJson$() {
    }
}

