/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.k2.kafka.PartitionRequest;
import io.confluent.k2.kafka.PartitionResponse;
import io.confluent.k2.kafka.link.K2LinkAssignmentProvider;
import io.confluent.k2.kafka.link.K2LinkRequestHandler;
import io.confluent.k2.kafka.link.K2MirrorPartitionMetadata;
import io.confluent.kafka.storage.log.FollowerLog;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.Executor;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkK1ReplicaManager;
import kafka.server.link.K2MirrorLog;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidReplicationOffsetException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t}d\u0001\u0002\r\u001a\u0001\u0001B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0005\f\u0005\nc\u0001\u0011\t\u0011)A\u0005[IB\u0011b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u001c\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u001da\u0007A1A\u0005\u00025Da\u0001\u001e\u0001!\u0002\u0013q\u0007\"B;\u0001\t\u00032\bbBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\ty\u0006\u0001C!\u0003CBq!a:\u0001\t\u0003\nI\u000fC\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!\u001f\u0001\t\u0013\u0011YHA\u000eDYV\u001cH/\u001a:MS:\\7J\r*fa2L7-Y'b]\u0006<WM\u001d\u0006\u00035m\tA\u0001\\5oW*\u0011A$H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003y\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003eI!\u0001J\r\u00037\rcWo\u001d;fe2Kgn[&2%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t1\u0013&D\u0001(\u0015\tAS$A\u0003vi&d7/\u0003\u0002+O\t9Aj\\4hS:<\u0017\u0001\u00042s_.,'oQ8oM&<W#A\u0017\u0011\u00059zS\"A\u000e\n\u0005AZ\"aC&bM.\f7i\u001c8gS\u001e\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\u0013BA\u0016$\u0003Y\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ$U\r\\3hCR,\u0007C\u0001\u00186\u0013\t14D\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\n\u0005a\u001a\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005m\u001aU\"\u0001\u001f\u000b\u0005ur\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0005yy$B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001eL!\u0001\u0012\u001f\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003AY'GU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0005\u0002H!6\t\u0001J\u0003\u0002\u001b\u0013*\u0011aD\u0013\u0006\u0003\u00172\u000b!a\u001b\u001a\u000b\u00055s\u0015!C2p]\u001adW/\u001a8u\u0015\u0005y\u0015AA5p\u0013\t\t\u0006J\u0001\u000bLe1Kgn\u001b*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0019WJb\u0015N\\6BgNLwM\\7f]R\u0004&o\u001c<jI\u0016\u0014\bCA$U\u0013\t)\u0006J\u0001\rLe1Kgn[!tg&<g.\\3oiB\u0013xN^5eKJ\f\u0001\"\u001a=fGV$xN]\u000b\u00021B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/_\u0003\u0011)H/\u001b7\u000b\u0003}\u000bAA[1wC&\u0011\u0011M\u0017\u0002\t\u000bb,7-\u001e;pe\u0006IQ\r_3dkR|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u00154w\r[5kWB\u0011!\u0005\u0001\u0005\u0006W%\u0001\r!\f\u0005\u0006g%\u0001\r\u0001\u000e\u0005\u0006s%\u0001\rA\u000f\u0005\u0006\u000b&\u0001\rA\u0012\u0005\u0006%&\u0001\ra\u0015\u0005\u0006-&\u0001\r\u0001W\u0001\r\u0007\u0006cEj\u0018+J\u001b\u0016{U\u000bV\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011OX\u0001\u0005i&lW-\u0003\u0002ta\nAA)\u001e:bi&|g.A\u0007D\u00032cu\fV%N\u000b>+F\u000bI\u0001\u001eC\u0012$g)\u001a;dQ\u0016\u0014hi\u001c:MK\u0006$WM\u001d)beRLG/[8ogR!q/`A\u0006!\tA80D\u0001z\u0015\u0005Q\u0018!B:dC2\f\u0017B\u0001?z\u0005\u0011)f.\u001b;\t\u000byd\u0001\u0019A@\u0002\r1Lgn[%e!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003}\u000511m\\7n_:LA!!\u0003\u0002\u0004\t!Q+^5e\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\t1\u0002\\5oW6\u000bg.Y4feB!\u0011\u0011CA\u0015\u001d\u0011\t\u0019\"!\n\u000f\t\u0005U\u00111\u0005\b\u0005\u0003/\t\tC\u0004\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tibH\u0001\u0007yI|w\u000e\u001e \n\u0003yI!\u0001H\u000f\n\u0005iY\u0012bAA\u00143\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\u0011\tY#!\f\u0003\u00171Kgn['b]\u0006<WM\u001d\u0006\u0004\u0003OI\u0012aH:i_VdGm\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ss>3gm]3ugV\u0011\u00111\u0007\t\u0004q\u0006U\u0012bAA\u001cs\n9!i\\8mK\u0006t\u0017!\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\u0007\u0003{\t\u0019%!\u0015\u0011\u00079\ny$C\u0002\u0002Bm\u0011\u0001\u0003V5feN#\u0018\r^3NC\u000eD\u0017N\\3\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u00051A.Z1eKJ\u0004B!!\u0013\u0002N5\u0011\u00111\n\u0006\u00039yJA!a\u0014\u0002L\tqA*Z1eKJ,e\u000e\u001a)pS:$\bbBA*\u001d\u0001\u0007\u0011QK\u0001\u0013Kb\u0004xN\\3oi&\fGNQ1dW>4g\r\u0005\u0003\u0002X\u0005mSBAA-\u0015\rA\u00131A\u0005\u0005\u0003;\nIF\u0001\nFqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0017AH1qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s%\u0016\u0004H.[2b)Y\t\u0019'! \u0002\b\u0006E\u00151TAP\u0003o\u000b9-a3\u0002R\u0006u\u0007#\u0002=\u0002f\u0005%\u0014bAA4s\n1q\n\u001d;j_:\u0004B!a\u001b\u0002z5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0002m_\u001eTA!a\u001d\u0002v\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003or\u0014aB:u_J\fw-Z\u0005\u0005\u0003w\niGA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003\u007fz\u0001\u0019AAA\u0003\t!\b\u000f\u0005\u0003\u0002\u0002\u0005\r\u0015\u0002BAC\u0003\u0007\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\n>\u0001\r!a#\u0002)\u0015D\b/Z2uK\u0012dunZ#oI>3gm]3u!\rA\u0018QR\u0005\u0004\u0003\u001fK(\u0001\u0002'p]\u001eDq!a%\u0010\u0001\u0004\t)*\u0001\u0007baB,g\u000eZ(sS\u001eLg\u000e\u0005\u0003\u0002l\u0005]\u0015\u0002BAM\u0003[\u0012A\"\u00119qK:$wJ]5hS:Dq!!(\u0010\u0001\u0004\tY)\u0001\u000bsKBd\u0017nY1uS>t7+Z:tS>t\u0017\n\u001a\u0005\b\u0003C{\u0001\u0019AAR\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\r\u0005\u0015\u0016qUAV\u001b\u0005a\u0016bAAU9\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\tLX\u0001\u0005Y\u0006tw-\u0003\u0003\u00026\u0006=&aB%oi\u0016<WM\u001d\u0005\b\u0003s{\u0001\u0019AA^\u0003\u001d\u0011XmY8sIN\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019!\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u000b\fyLA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003\u0013|\u0001\u0019AAF\u0003MaW-\u00193fe\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\tim\u0004a\u0001\u0003\u001f\fA\u0003\\3bI\u0016\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bCBAS\u0003O\u000bY\tC\u0004\u0002T>\u0001\r!!6\u0002\u00195\f\u0007PQ1uG\"\u001c\u0016N_3\u0011\u000ba\f)'a6\u0011\u0007a\fI.C\u0002\u0002\\f\u00141!\u00138u\u0011\u001d\tyn\u0004a\u0001\u0003C\fQ!];pi\u0006\u00042ALAr\u0013\r\t)o\u0007\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0017[\u0006L(-Z\"sK\u0006$Xm\u0013\u001aNSJ\u0014xN\u001d'pOR1\u00111^A~\u0005\u0017\u0001R\u0001_A3\u0003[\u0004B!a<\u0002x6\u0011\u0011\u0011\u001f\u0006\u0005\u0003_\n\u0019P\u0003\u0003\u0002x\u0005U(B\u0001\u0010M\u0013\u0011\tI0!=\u0003\u0017\u0019{G\u000e\\8xKJdun\u001a\u0005\b\u0003{\u0004\u0002\u0019AA\u0000\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\r\u0011)!H\u0001\bG2,8\u000f^3s\u0013\u0011\u0011IAa\u0001\u0003\u0013A\u000b'\u000f^5uS>t\u0007b\u0002B\u0007!\u0001\u0007!qB\u0001\nY><7i\u001c8gS\u001e\u0004B!a\u001b\u0003\u0012%!!1CA7\u0005%aunZ\"p]\u001aLw-A\u000enCf\u0014W-\u00138ji&\fG.\u001b>f\u0017Jj\u0015N\u001d:pe2{wm\u001d\u000b\u0004o\ne\u0001b\u0002B\u000e#\u0001\u0007!QD\u0001\u000b[&\u0014(o\u001c:M_\u001e\u001c\bC\u0002B\u0010\u0005K\ti/\u0004\u0002\u0003\")\u0019!1E=\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003(\t\u0005\"aA*fi\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\bo\n5\"q\u0007B\u001e\u0011\u001d\u0011yC\u0005a\u0001\u0005c\t\u0011\"\\5se>\u0014Hj\\4\u0011\u0007\t\u0012\u0019$C\u0002\u00036e\u00111b\u0013\u001aNSJ\u0014xN\u001d'pO\"9!\u0011\b\nA\u0002\u0005-\u0015!C3oI>3gm]3u\u0011\u001d\u0011iD\u0005a\u0001\u0003\u0017\u000b\u0011B\\3x\u001f\u001a47/\u001a;\u0002\u001f\u0005$G-R7qif$\u0015\r^1SK\u001a$ra\u001eB\"\u0005\u001b\u0012\t\u0006C\u0004\u0003FM\u0001\rAa\u0012\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA\u0001\u0005\u0013JAAa\u0013\u0002\u0004\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005\u001f\u001a\u0002\u0019AAF\u00031\u0019WO]#oI>3gm]3u\u0011\u001d\u0011id\u0005a\u0001\u0003\u0017\u000b!\u0003^8QCJ$\u0018\u000e^5p]J+\u0017/^3tiR!!q\u000bB3!\u0019\u0011IFa\u0017\u0003`5\t\u0011*C\u0002\u0003^%\u0013\u0001\u0003U1si&$\u0018n\u001c8SKF,Xm\u001d;\u0011\t\u00055&\u0011M\u0005\u0005\u0005G\nyK\u0001\u0003W_&$\u0007bBA@)\u0001\u0007\u0011\u0011Q\u0001\u0013i>$v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003H\t-\u0004bBA@+\u0001\u0007\u0011\u0011Q\u0001\u001be\u00164'/Z:i\u0017J\u001aF/\u0019:u\u0003:$WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0005c\u00129\bE\u0004y\u0005g\nY)a#\n\u0007\tU\u0014P\u0001\u0004UkBdWM\r\u0005\b\u0005_1\u0002\u0019\u0001B\u0019\u0003-Y''T5se>\u0014Hj\\4\u0015\t\tE\"Q\u0010\u0005\b\u0003\u007f:\u0002\u0019AAA\u0001")
public class ClusterLinkK2ReplicaManager
extends ClusterLinkK1ReplicaManager {
    private final MetadataCache metadataCache;
    private final K2LinkRequestHandler k2RequestHandler;
    private final K2LinkAssignmentProvider k2LinkAssignmentProvider;
    private final Executor executor;
    private final Duration CALL_TIMEOUT;

    @Override
    public KafkaConfig brokerConfig() {
        return super.brokerConfig();
    }

    public Executor executor() {
        return this.executor;
    }

    public Duration CALL_TIMEOUT() {
        return this.CALL_TIMEOUT;
    }

    @Override
    public void addFetcherForLeaderPartitions(Uuid linkId, ClusterLinkFactory.LinkManager linkManager) {
        this.k2LinkAssignmentProvider.fetcherAssignments(linkId).whenCompleteAsyncRaw((partitions, throwable) -> {
            block3: {
                try {
                    if (throwable == null) {
                        this.debug((Function0<String> & Serializable)() -> "response for assignments on " + linkId + " is " + partitions);
                        linkManager.handleFetcherAssignment((java.util.Set)partitions);
                        break block3;
                    }
                    this.error((Function0<String> & Serializable)() -> "error response for assignments on " + linkId, (Function0<Throwable> & Serializable)() -> throwable);
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "assignments request result ret: " + partitions + " throwable: " + throwable + ", complete block exception:", (Function0<Throwable> & Serializable)() -> e);
                }
            }
        }, this.executor());
    }

    @Override
    public boolean shouldCheckpointRecoveryOffsets() {
        return false;
    }

    @Override
    public TierStateMachine fetchTierStateMachine(LeaderEndPoint leader, ExponentialBackoff exponentialBackoff) {
        return new TierStateMachine(leader, this.replicaManager(), false);
    }

    @Override
    public Option<LogAppendInfo> appendRecordsToFollowerReplica(TopicPartition tp, long expectedLogEndOffset, AppendOrigin appendOrigin, long replicationSessionId, Optional<Integer> leaderEpoch, MemoryRecords records, long leaderHighWatermark, Optional<Object> leaderLogStartOffset, Option<Object> maxBatchSize, ReplicaQuota quota) {
        K2MirrorLog mirrorLog = this.k2MirrorLog(tp);
        TopicIdPartition topicIdPartition = this.toTopicIdPartition(tp);
        LongRef firstOffset = LongRef.create(-1L);
        LongRef nextOffset = LongRef.create(-1L);
        IntRef bufferPosition = IntRef.create(0);
        LongRef lastOffsetOfFirstBatch = LongRef.create(-1L);
        ObjectRef lastLeaderEpoch = ObjectRef.create(Optional.empty());
        ObjectRef<CompressionType> compressionType = ObjectRef.create(CompressionType.NONE);
        this.trace((Function0<String> & Serializable)() -> "appendRecordsToFollowerReplica " + tp + " expectedLogEndOffset=" + expectedLogEndOffset);
        records.batches().forEach(batch -> {
            PartitionResponse<ProduceResponseData.PartitionProduceResponse> partitionResponse;
            nextOffset$1.elem = batch.baseOffset();
            this.trace((Function0<String> & Serializable)() -> "Appending next batch " + tp + " at offset " + nextOffset$1.elem);
            int size = batch.sizeInBytes();
            if (maxBatchSize.exists(x$4 -> x$4 < size)) {
                String message = "The record batch size in the append to " + tp + " is " + size + " bytes, which exceeds the maximum configured value of " + maxBatchSize + " for the cluster link.";
                this.warn((Function0<String> & Serializable)() -> message);
                throw new RecordTooLargeException(message);
            }
            MemoryRecords batchRecords = records.slice(bufferPosition$1.elem, size);
            Iterator iterator = batchRecords.batches().iterator();
            if (!iterator.hasNext()) {
                this.warn((Function0<String> & Serializable)() -> "Empty batch found during mirroring of " + tp);
                throw new InvalidRecordException("Empty batch found during mirroring of " + tp);
            }
            MutableRecordBatch recordBatch = (MutableRecordBatch)iterator.next();
            if (recordBatch.magic() != 2) {
                this.warn((Function0<String> & Serializable)() -> "Record batch with magic value " + recordBatch.magic() + " not supported");
                throw new InvalidRecordException("Record batch with magic value " + recordBatch.magic() + " not supported");
            }
            Tuple2<Object, Object> tuple2 = this.refreshK2StartAndEndOffset(mirrorLog);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long endOffset = tuple2._2$mcJ$sp();
            long endOffset2 = endOffset;
            if (firstOffset$1.elem == -1L) {
                if (expectedLogEndOffset != endOffset2) {
                    throw new InvalidReplicationOffsetException("Offset mismatch for partition " + tp + ": expectedOffset = " + expectedLogEndOffset + ", logEndOffset = " + endOffset2);
                }
                firstOffset$1.elem = nextOffset$1.elem;
            }
            if (nextOffset$1.elem < endOffset2) {
                this.warn((Function0<String> & Serializable)() -> "Truncation of " + tp + " from offset " + endOffset2 + " to " + nextOffset$1.elem + " not supported for K2");
                throw new InvalidRecordException("Truncation of " + tp + " from offset " + endOffset2 + " to " + nextOffset$1.elem + " not supported for K2");
            }
            if (nextOffset$1.elem > endOffset2) {
                this.debug((Function0<String> & Serializable)() -> "Skipping offsets for " + tp + " from " + endOffset2 + " to " + nextOffset$1.elem + " for preserving source offsets");
                this.addEmptyDataRef(topicIdPartition, endOffset2, nextOffset$1.elem);
            }
            if (iterator.hasNext()) {
                this.warn((Function0<String> & Serializable)() -> "Rejecting appends for " + tp + " due to unexpected batch after slicing");
                throw new InvalidRecordException("Rejecting appends for " + tp + " due to unexpected batch after slicing");
            }
            PartitionRequest<MemoryRecords> request = new PartitionRequest<MemoryRecords>(topicIdPartition, batchRecords);
            try {
                partitionResponse = $this.k2RequestHandler.appendMirrorRecords(Collections.singletonList(request)).block(this.CALL_TIMEOUT()).get(0);
            }
            catch (Exception e) {
                String message = "Failed to mirror records for partition " + tp;
                this.error((Function0<String> & Serializable)() -> message, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                throw new KafkaException(message, (Throwable)e);
            }
            PartitionResponse<ProduceResponseData.PartitionProduceResponse> result = partitionResponse;
            if (result.response().errorCode() != Errors.NONE.code()) {
                this.warn((Function0<String> & Serializable)() -> "Mirror append failed with error " + result.response());
                throw Errors.forCode((short)result.response().errorCode()).exception();
            }
            if (result.response().baseOffset() != nextOffset$1.elem) {
                String errorMessage = "Unexpected K2 mirror append offset for " + tp + ", expected " + nextOffset$1.elem + ", got " + result.response().baseOffset();
                this.warn((Function0<String> & Serializable)() -> errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            bufferPosition$1.elem += size;
            nextOffset$1.elem = result.response().baseOffset() + batch.lastOffset() + 1L;
            mirrorLog.updateLogEndOffset(nextOffset$1.elem);
            if (lastOffsetOfFirstBatch$1.elem == -1L) {
                lastOffsetOfFirstBatch$1.elem = nextOffset$1.elem - 1L;
            }
            compressionType$1.elem = batch.compressionType();
            lastLeaderEpoch$1.elem = Optional.of(Predef$.MODULE$.int2Integer(batch.partitionLeaderEpoch()));
        });
        LogAppendInfo logAppendInfo = new LogAppendInfo(firstOffset.elem, nextOffset.elem - 1L, (Optional)lastLeaderEpoch.elem, -1L, -1L, mirrorLog.logStartOffset(), RecordValidationStats.EMPTY, (CompressionType)compressionType.elem, records.sizeInBytes(), lastOffsetOfFirstBatch.elem);
        if (quota.isThrottled(tp)) {
            quota.record(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(tp.topic(), records.sizeInBytes());
        return new Some<LogAppendInfo>(logAppendInfo);
    }

    @Override
    public Option<FollowerLog> maybeCreateK2MirrorLog(Partition partition, LogConfig logConfig) {
        K2MirrorLog mirrorLog2 = new K2MirrorLog(partition.topicPartition(), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(partition.topicId())), logConfig, (Function2<K2MirrorLog, Object, BoxedUnit>)(Function2<K2MirrorLog, Object, Object> & Serializable)(mirrorLog, newOffset) -> {
            ClusterLinkK2ReplicaManager.$anonfun$maybeCreateK2MirrorLog$1(this, mirrorLog, BoxesRunTime.unboxToLong(newOffset));
            return BoxedUnit.UNIT;
        });
        this.debug((Function0<String> & Serializable)() -> "Created K2 mirror log for " + partition.topicPartition());
        return new Some<FollowerLog>(mirrorLog2);
    }

    @Override
    public void maybeInitializeK2MirrorLogs(Set<FollowerLog> mirrorLogs) {
        mirrorLogs.foreach((Function1<FollowerLog, Object> & Serializable)x0$1 -> {
            ClusterLinkK2ReplicaManager.$anonfun$maybeInitializeK2MirrorLogs$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void truncateFullyAndStartAt(K2MirrorLog mirrorLog, long endOffset, long newOffset) {
        TopicPartition tp = mirrorLog.topicPartition();
        try {
            this.addEmptyDataRef(this.toTopicIdPartition(tp), endOffset, newOffset);
            mirrorLog.updateLogEndOffset(newOffset);
        }
        catch (Exception e) {
            String message = "Failed to truncate mirror log for " + tp + " and start at " + newOffset;
            this.error((Function0<String> & Serializable)() -> message, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            throw new KafkaException(message, (Throwable)e);
        }
    }

    private void addEmptyDataRef(TopicIdPartition topicIdPartition, long curEndOffset, long newOffset) {
        try {
            this.k2RequestHandler.skipMirrorOffsets(topicIdPartition, curEndOffset, newOffset).block(this.CALL_TIMEOUT());
            this.debug((Function0<String> & Serializable)() -> "Added empty data ref " + topicIdPartition + " to skip offsets from " + curEndOffset + " to " + newOffset);
        }
        catch (Exception e) {
            String message = "Failed to append empty data ref for " + topicIdPartition + " to skip offsets from " + curEndOffset + " to " + newOffset;
            this.error((Function0<String> & Serializable)() -> message, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            throw new KafkaException(message, (Throwable)e);
        }
    }

    private PartitionRequest<Void> toPartitionRequest(TopicPartition tp) {
        TopicIdPartition topicIdPartition = this.toTopicIdPartition(tp);
        return new PartitionRequest<Object>(topicIdPartition, null);
    }

    private TopicIdPartition toTopicIdPartition(TopicPartition tp) {
        Uuid topicId = this.metadataCache.getTopicId(tp.topic());
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, tp);
        return topicIdPartition;
    }

    private Tuple2<Object, Object> refreshK2StartAndEndOffset(K2MirrorLog mirrorLog) {
        Tuple2$mcJJ$sp tuple2$mcJJ$sp;
        TopicPartition tp = mirrorLog.topicPartition();
        try {
            long l;
            Some some;
            long pendingStartOffset;
            K2MirrorPartitionMetadata metadata = this.k2RequestHandler.mirrorPartitionMetadata(this.toPartitionRequest(tp)).block(this.CALL_TIMEOUT()).response();
            Option<Object> option = mirrorLog.pendingLogStartOffset();
            if (option instanceof Some && (pendingStartOffset = BoxesRunTime.unboxToLong((some = (Some)option).value())) > metadata.stop()) {
                this.truncateFullyAndStartAt(mirrorLog, metadata.stop(), pendingStartOffset);
                l = pendingStartOffset;
            } else {
                mirrorLog.updateLogEndOffset(metadata.stop());
                l = metadata.stop();
            }
            long logEndOffset = l;
            mirrorLog.updateLogStartOffset(metadata.start());
            tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(metadata.start(), logEndOffset);
        }
        catch (Exception e) {
            String message = "Failed to refresh K2 offsets for " + tp;
            this.error((Function0<String> & Serializable)() -> message, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            throw new KafkaException(message, (Throwable)e);
        }
        return tuple2$mcJJ$sp;
    }

    private K2MirrorLog k2MirrorLog(TopicPartition tp) {
        FollowerLog mirrorLog = this.replicaManager().getPartitionOrException(tp).mirrorLocalLogOrException();
        FollowerLog followerLog = mirrorLog;
        if (followerLog instanceof K2MirrorLog) {
            K2MirrorLog k2MirrorLog = (K2MirrorLog)followerLog;
            return k2MirrorLog;
        }
        throw new IllegalStateException("Mirror log is not a K2 log: " + mirrorLog);
    }

    public static final /* synthetic */ void $anonfun$maybeCreateK2MirrorLog$1(ClusterLinkK2ReplicaManager $this, K2MirrorLog mirrorLog, long newOffset) {
        Tuple2<Object, Object> tuple2 = $this.refreshK2StartAndEndOffset(mirrorLog);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long endOffset = tuple2._2$mcJ$sp();
        long endOffset2 = endOffset;
        $this.truncateFullyAndStartAt(mirrorLog, endOffset2, newOffset);
    }

    public static final /* synthetic */ void $anonfun$maybeInitializeK2MirrorLogs$1(ClusterLinkK2ReplicaManager $this, FollowerLog x0$1) {
        FollowerLog followerLog = x0$1;
        if (followerLog instanceof K2MirrorLog) {
            K2MirrorLog k2MirrorLog = (K2MirrorLog)followerLog;
            if (!k2MirrorLog.initialized()) {
                $this.refreshK2StartAndEndOffset(k2MirrorLog);
                k2MirrorLog.markInitialized();
                return;
            }
            return;
        }
        throw new IllegalStateException("Mirror log is not a K2 log: " + followerLog);
    }

    public ClusterLinkK2ReplicaManager(KafkaConfig brokerConfig, ReplicaManager replicaManagerDelegate, MetadataCache metadataCache, K2LinkRequestHandler k2RequestHandler, K2LinkAssignmentProvider k2LinkAssignmentProvider, Executor executor) {
        this.metadataCache = metadataCache;
        this.k2RequestHandler = k2RequestHandler;
        this.k2LinkAssignmentProvider = k2LinkAssignmentProvider;
        this.executor = executor;
        super(brokerConfig, replicaManagerDelegate);
        this.CALL_TIMEOUT = Duration.ofSeconds(30L);
    }
}

