/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkMetrics$ {
    public static final ClusterLinkMetrics$ MODULE$ = new ClusterLinkMetrics$();
    private static final String metricsGroup = "cluster-link-metrics";
    private static final long expirationInSeconds = TimeUnit.MINUTES.toSeconds(10L);

    public String metricsGroup() {
        return metricsGroup;
    }

    public long expirationInSeconds() {
        return expirationInSeconds;
    }

    public String activeClientConnectionsCountSensorName() {
        return "link-client-connections-sensor";
    }

    public MetricName activeClientConnectionsCountMetricName() {
        return new MetricName("link-client-connections-total", "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String clientConnectionsThrottleSensorName() {
        return "link-client-connections-throttle-sensor";
    }

    public MetricName clientConnectionsThrottleRateMetricName() {
        return new MetricName("link-client-connections-throttle-rate", "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String throttleTimeSensorName(String linkName) {
        return "linked-fetcher-throttle-time-" + linkName;
    }

    public String unavailabilitySensorName(String linkName) {
        return "link-unavailable-" + linkName;
    }

    public String kafka$server$link$ClusterLinkMetrics$$linkCountDescription(ClusterLinkConfig.LinkMode linkMode) {
        ClusterLinkConfig.LinkMode linkMode2 = linkMode;
        if (((Object)((Object)ClusterLinkConfig.LinkMode.DESTINATION)).equals((Object)linkMode2)) {
            return "Number of destination links for this cluster.";
        }
        if (((Object)((Object)ClusterLinkConfig.LinkMode.SOURCE)).equals((Object)linkMode2)) {
            return "Number of source links for this cluster.";
        }
        if (((Object)((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL)).equals((Object)linkMode2)) {
            return "Number of bidirectional links for this cluster.";
        }
        throw new IllegalArgumentException("Unsupported cluster link mode " + linkMode);
    }

    public String kafka$server$link$ClusterLinkMetrics$$controllerReverseConnectionDescription(ConnectionMode connectionMode) {
        ConnectionMode connectionMode2 = connectionMode;
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode2)) {
            return "Number of persistent reverse connections for this link from the remote cluster to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode2)) {
            return "Number of persistent reverse connections for this link from this broker to the remote link coordinator.";
        }
        throw new IllegalArgumentException("Unsupported cluster link connection mode " + connectionMode);
    }

    public String kafka$server$link$ClusterLinkMetrics$$reverseConnectionDescription(ConnectionMode connectionMode) {
        ConnectionMode connectionMode2 = connectionMode;
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode2)) {
            return "Total number of reverse connections for this link from remote brokers to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode2)) {
            return "Total number of reverse connections for this link from this broker to remote brokers.";
        }
        throw new IllegalArgumentException("Unsupported connection mode " + connectionMode);
    }

    public Map<String, String> linkModeTag(ClusterLinkConfig.LinkMode linkMode) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("mode"), linkMode.lowerCaseName())}));
    }

    public Map<String, String> linkTypeTag(LinkType linkType) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("deployed-link-type"), linkType.lowerCaseName())}));
    }

    public Map<String, String> connectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("connection-mode"), connectionMode.lowerCaseName())}));
    }

    public Map<String, String> remoteLinkConnectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("remote-link-connection-mode"), connectionMode.lowerCaseName())}));
    }

    public Map<String, String> stateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("state"), state)}));
    }

    public Map<String, String> remoteLinkStateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("remote-link-state"), state)}));
    }

    public Map<String, String> reasonTag(String reason) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("reason"), reason)}));
    }

    public Map<String, String> taskNameTag(String taskName) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("task-name"), taskName)}));
    }

    public Map<String, String> poolTag(String pool) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("pool"), pool)}));
    }

    public int activeClientConnectionsCount(Metrics metrics) {
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(this.activeClientConnectionsCountMetricName());
        if (kafkaMetric != null) {
            return (int)BoxesRunTime.unboxToDouble(kafkaMetric.metricValue());
        }
        return 0;
    }

    private ClusterLinkMetrics$() {
    }
}

