/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirror$;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrorsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorNotFoundTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochOptions;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rMb\u0001\u0002\u001e<\u0001\tC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003_\u0011%\u0011\u0007A!A!\u0002\u0013\u0019\u0007\u000fC\u0005r\u0001\t\u0005\t\u0015!\u0003sm\"Iq\u000f\u0001B\u0001B\u0003%\u0001\u0010 \u0005\u0006}\u0002!\ta \u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0002C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0002bCA\u0019\u0001\u0001\u0007\t\u0011)Q\u0005\u0003+A1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA \u0011-\t\u0019\u0005\u0001a\u0001\u0002\u0003\u0006K!a\u000e\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA,\u0001\u0001\u0006I!!\u0013\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\"CA2\u0001\u0001\u0007I\u0011BA3\u0011!\tI\u0007\u0001Q!\n\u0005u\u0003\"CA6\u0001\u0001\u0007I\u0011BA.\u0011%\ti\u0007\u0001a\u0001\n\u0013\ty\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0015BA/\u0011%\t)\b\u0001a\u0001\n\u0013\tY\u0006C\u0005\u0002x\u0001\u0001\r\u0011\"\u0003\u0002z!A\u0011Q\u0010\u0001!B\u0013\ti\u0006C\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011\u0011\u0012\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011Q\u0013\u0001!\u0002\u0013\ty\tC\u0005\u0002\u0018\u0002\u0011\r\u0011\"\u0003\u0002\u001a\"A\u0011q\u0015\u0001!\u0002\u0013\tY\nC\u0005\u0002*\u0002\u0011\r\u0011\"\u0003\u0002,\"A\u0011q\u0016\u0001!\u0002\u0013\ti\u000bC\u0005\u00022\u0002\u0001\r\u0011\"\u0003\u00024\"I\u0011\u0011\u0019\u0001A\u0002\u0013%\u00111\u0019\u0005\t\u0003\u000f\u0004\u0001\u0015)\u0003\u00026\"A\u0011\u0011\u001b\u0001\u0005Rm\n\u0019\u000eC\u0004\u0002j\u0002!I!a;\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011!\u00119\u0005\u0001C\tw\t%\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqA!,\u0001\t\u0013\u0011y\u000bC\u0004\u0003>\u0002!IAa0\t\u000f\tM\u0007\u0001\"\u0003\u0003V\"9!\u0011\u001c\u0001\u0005B\tm\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005'\u0004A\u0011\u000bB\u0000\u00115\u0019I\u0001\u0001I\u0001\u0004\u0003\u0005I\u0011BB\u0006y\u001eI1QB\u001e\u0002\u0002#\u00051q\u0002\u0004\tum\n\t\u0011#\u0001\u0004\u0012!1ap\u000eC\u0001\u00073A\u0011ba\u00078#\u0003%\ta!\b\u0003M\rcWo\u001d;fe2Kgn\u001b)sKB\f'/\u001a)f]\u0012Lgn\u001a*fgR|'/Z'jeJ|'O\u0003\u0002={\u0005!A.\u001b8l\u0015\tqt(\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0001\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001D!\t!\u0005J\u0004\u0002F\r6\t1(\u0003\u0002Hw\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!!\u0013&\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005\u001d[\u0014!\u0002;pa&\u001c\u0007CA'W\u001d\tqE\u000b\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0003\u00061AH]8pizR\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011QKU\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0011\u0005\u0015[\u0016B\u0001/<\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\f!\u0002\\8dC2\fE-\\5o!\t)u,\u0003\u0002aw\t)2\t\\;ti\u0016\u0014H*\u001b8l\u0005\u0006$8\r[!e[&t\u0017a\u0003:f[>$X-\u00113nS:\fA\u0001^5nKB\u0011AM\\\u0007\u0002K*\u0011amZ\u0001\u0006kRLGn\u001d\u0006\u0003Q&\faaY8n[>t'B\u0001!k\u0015\tYG.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0006\u0019qN]4\n\u0005=,'\u0001\u0002+j[\u0016L!A\u0019%\u0002\u000bE,x\u000e^1\u0011\u0005M$X\"A\u001f\n\u0005Ul$aF\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u0013\t\t\b*\u0001\u0006j]R,'O^1m\u001bN\u0004\"!\u001f>\u000e\u0003IK!a\u001f*\u0003\u0007%sG/\u0003\u0002~\u0011\u0006\t\"/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0002\rqJg.\u001b;?)A\t\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0002F\u0001!)1\n\u0003a\u0001\u0019\")\u0011\f\u0003a\u00015\")Q\f\u0003a\u0001=\")\u0011\r\u0003a\u0001=\")!\r\u0003a\u0001G\")\u0011\u000f\u0003a\u0001e\"9q\u000f\u0003I\u0001\u0002\u0004A\u0018A\u00039beRLG/[8ogV\u0011\u0011Q\u0003\t\u0006\u001b\u0006]\u00111D\u0005\u0004\u00033A&aA*fiB!\u0011QDA\u0010\u001b\u00059\u0017bAA\u0011O\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00049beRLG/[8og~#S-\u001d\u000b\u0005\u0003O\ti\u0003E\u0002z\u0003SI1!a\u000bS\u0005\u0011)f.\u001b;\t\u0013\u0005=\"\"!AA\u0002\u0005U\u0011a\u0001=%c\u0005Y\u0001/\u0019:uSRLwN\\:!\u00035\u0011X-\\8uKR{\u0007/[2JIV\u0011\u0011q\u0007\t\u0005\u0003;\tI$C\u0002\u0002<\u001d\u0014A!V;jI\u0006\t\"/Z7pi\u0016$v\u000e]5d\u0013\u0012|F%Z9\u0015\t\u0005\u001d\u0012\u0011\t\u0005\n\u0003_i\u0011\u0011!a\u0001\u0003o\taB]3n_R,Gk\u001c9jG&#\u0007%A\nd_6\u0004H.\u001a;fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002JA1\u00111JA+\u00037i!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019FU\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\r\u0003\u001b\nAcY8na2,G/\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013!H5oSRL\u0017\r\u001c#fg\u000e\u0014\u0018NY3U_BL7m\u00115fG.$uN\\3\u0016\u0005\u0005u\u0003cA=\u0002`%\u0019\u0011\u0011\r*\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0013N\\5uS\u0006dG)Z:de&\u0014W\rV8qS\u000e\u001c\u0005.Z2l\t>tWm\u0018\u0013fcR!\u0011qEA4\u0011%\tyCEA\u0001\u0002\u0004\ti&\u0001\u0010j]&$\u0018.\u00197EKN\u001c'/\u001b2f)>\u0004\u0018nY\"iK\u000e\\Gi\u001c8fA\u0005Yb-\u001b8bY\u0012+7o\u0019:jE\u0016$v\u000e]5d\u0007\",7m\u001b#p]\u0016\fqDZ5oC2$Um]2sS\n,Gk\u001c9jG\u000eCWmY6E_:,w\fJ3r)\u0011\t9#!\u001d\t\u0013\u0005=R#!AA\u0002\u0005u\u0013\u0001\b4j]\u0006dG)Z:de&\u0014W\rV8qS\u000e\u001c\u0005.Z2l\t>tW\rI\u0001\u0015e\u0016lw\u000e^3PM\u001a\u001cX\r^:GKR\u001c\u0007.\u001a3\u00021I,Wn\u001c;f\u001f\u001a47/\u001a;t\r\u0016$8\r[3e?\u0012*\u0017\u000f\u0006\u0003\u0002(\u0005m\u0004\"CA\u00181\u0005\u0005\t\u0019AA/\u0003U\u0011X-\\8uK>3gm]3ug\u001a+Go\u00195fI\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u00032!RAC\u0013\r\t9i\u000f\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\nq#\u001a=dKN\u001c\u0018N^3M_\u001e<\u0017N\\4IC:$G.\u001a:\u0016\u0005\u0005=\u0005cA#\u0002\u0012&\u0019\u00111S\u001e\u0003/\u0015C8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014\u0018\u0001G3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3sA\u0005\u0011\u0002/\u0019:uSRLwN\\:U_>3gm]3u+\t\tY\n\u0005\u0005\u0002L\u0005u\u00151DAQ\u0013\u0011\ty*!\u0014\u0003\u00075\u000b\u0007\u000fE\u0002z\u0003GK1!!*S\u0005\u0011auN\\4\u0002'A\f'\u000f^5uS>t7\u000fV8PM\u001a\u001cX\r\u001e\u0011\u0002#A\f'\u000f^5uS>t7\u000fV8Fa>\u001c\u0007.\u0006\u0002\u0002.B9\u00111JAO\u00037A\u0018A\u00059beRLG/[8ogR{W\t]8dQ\u0002\n\u0001\u0002^1tW\u0012+7oY\u000b\u0003\u0003k\u0003R!_A\\\u0003wK1!!/S\u0005\u0019y\u0005\u000f^5p]B\u0019Q)!0\n\u0007\u0005}6HA\bUCN\\G)Z:de&\u0004H/[8o\u00031!\u0018m]6EKN\u001cw\fJ3r)\u0011\t9#!2\t\u0013\u0005=2%!AA\u0002\u0005U\u0016!\u0003;bg.$Um]2!Q\r!\u00131\u001a\t\u0004s\u00065\u0017bAAh%\nAao\u001c7bi&dW-A\u0002sk:$\"!!6\u0011\t\u0005]\u0017Q\u001d\b\u0004\u000334e\u0002BAn\u0003GtA!!8\u0002b:\u0019q*a8\n\u0003\u0001K!AP \n\u0005qj\u0014bAAt\u0015\nQA+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\u0003\u0002V\u00065\bbBAxM\u0001\u0007\u0011\u0011_\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002X\u0006M\u0018bAA{\u0015\nYA+Y:l\u0007>tG/\u001a=u\u0003M!Wm]2sS\n,7k\\;sG\u0016$v\u000e]5d)\u0019\t).a?\u0002~\"9\u0011q^\u0014A\u0002\u0005E\bbBA\u0000O\u0001\u0007\u0011QL\u0001\rS:LG/[1m\u0007\",7m[\u0001 Q\u0006tG\r\\3EKN\u001c'/\u001b2f'>,(oY3U_BL7MU3tk2$H\u0003CAk\u0005\u000b\u00119A!\u0003\t\u000f\u0005=\b\u00061\u0001\u0002r\"9\u0011q \u0015A\u0002\u0005u\u0003b\u0002B\u0006Q\u0001\u0007!QB\u0001\fi>\u0004\u0018n\u0019*fgVdG\u000fE\u0004\u0003\u0010\teAJa\u0007\u000e\u0005\tE!\u0002\u0002B\n\u0005+\tA!\u001e;jY*\u0011!qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002 \nE\u0001CBA\u000f\u0005;\u0011\t#C\u0002\u0003 \u001d\u00141bS1gW\u00064U\u000f^;sKB!!1\u0005B\u0017\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012!B1e[&t'b\u0001B\u0016S\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\u0018\u0005K\u0011\u0001\u0003V8qS\u000e$Um]2sSB$\u0018n\u001c8\u0002\u001f\u0019\f\u0017\u000e\\'jeJ|'\u000fV8qS\u000e$B!!6\u00036!9\u0011q^\u0015A\u0002\u0005E\u0018A\u00065b]\u0012dWMR1jY6K'O]8s%\u0016\u001cX\u000f\u001c;\u0015\r\u0005U'1\bB\u001f\u0011\u001d\tyO\u000ba\u0001\u0003cDqAa\u0010+\u0001\u0004\u0011\t%\u0001\u0004sKN,H\u000e\u001e\t\u0005\u0005G\u0011\u0019%\u0003\u0003\u0003F\t\u0015\"AE!mi\u0016\u0014X*\u001b:s_J\u001c(+Z:vYR\fAcZ3u!\u0006\u0014H/\u001b;j_:$vn\u00144gg\u0016$XC\u0001B&!!\u0011iEa\u0015\u0002\u001c\u0005\u0005VB\u0001B(\u0015\u0011\u0011\t&!\u0015\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAP\u0005\u001f\nAd\u001c4gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0002\u0003ZA1!q\u0002B.\u0005?JAA!\u0018\u0003\u0012\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\t\u0005$q\u0010\b\u0005\u0005G\u0012IH\u0004\u0003\u0003f\tUd\u0002\u0002B4\u0005grAA!\u001b\u0003r9!!1\u000eB8\u001d\ry%QN\u0005\u0002[&\u00111\u000e\\\u0005\u0003\u0001*L!\u0001[5\n\u0007\t]t-A\u0004nKN\u001c\u0018mZ3\n\t\tm$QP\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f'b\u0001B<O&!!\u0011\u0011BB\u0005QyeMZ:fi\u001a{'\u000fT3bI\u0016\u0014Hk\u001c9jG*!!1\u0010B?\u0003UygMZ:fiN4uN\u001d'fC\u0012,'/\u00129pG\"$b!!6\u0003\n\n-\u0005bBAx[\u0001\u0007\u0011\u0011\u001f\u0005\b\u0005\u001bk\u0003\u0019\u0001B-\u0003-\u0011X-];fgR$\u0015\r^1\u0002C!\fg\u000e\u001a7f\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001cX\u000f\u001c;\u0015\r\u0005U'1\u0013BK\u0011\u001d\tyO\fa\u0001\u0003cDqAa&/\u0001\u0004\u0011I*\u0001\u0006f]\u0012|eMZ:fiN\u0004\u0002Ba\u0004\u0003\u001a\u0005m!1\u0014\t\u0007\u0003;\u0011iB!(\u0011\t\t}%q\u0015\b\u0005\u0005C\u0013\u0019+\u0004\u0002\u0003~%!!Q\u0015B?\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t%&1\u0016\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\u0011)K! \u0002;\r|gN^3siR{\u0007+\u001a8eS:<'+Z:u_J,W*\u001b:s_J$b!!6\u00032\nM\u0006bBAx_\u0001\u0007\u0011\u0011\u001f\u0005\b\u0005k{\u0003\u0019\u0001B\\\u0003Ii\u0017N\u001d:peN#\u0018M\u001d;PM\u001a\u001cX\r^:\u0011\r\t5#\u0011XAQ\u0013\u0011\u0011YLa\u0014\u0003\u0007M+\u0017/A\u0015iC:$G.Z\"p]Z,'\u000f\u001e+p!\u0016tG-\u001b8h%\u0016\u001cHo\u001c:f\u001b&\u0014(o\u001c:SKN,H\u000e\u001e\u000b\u0007\u0003+\u0014\tMa1\t\u000f\u0005=\b\u00071\u0001\u0002r\"9!q\b\u0019A\u0002\t\u0015\u0007CBA\u000f\u0005;\u00119\r\u0005\u0003\u0003J\n=WB\u0001Bf\u0015\u0011\u0011iM!\u0006\u0002\t1\fgnZ\u0005\u0005\u0005#\u0014YM\u0001\u0003W_&$\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BAk\u0005/Dq!a<2\u0001\u0004\t\t0A\buCN\\G)Z:de&\u0004H/[8o)\t\t),A\nuCN\\WI\u001d:pe\u000e{G-Z!oI6\u001bx\r\u0006\u0005\u0003b\n\u001d(1\u001eBx!\r)%1]\u0005\u0004\u0005K\\$a\u0005+bg.,%O]8s\u0007>$W-\u00118e\u001bN<\u0007B\u0002Bug\u0001\u0007A*\u0001\u0007feJl5o\u001a)sK\u001aL\u0007\u0010C\u0004\u0003nN\u0002\r!!\u0018\u0002\u001d1|7-\u00197BI6Lg.V:fI\"9!\u0011_\u001aA\u0002\tM\u0018AA3y!\u0011\u0011)Pa?\u000e\u0005\t](\u0002\u0002B}\u0005#\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011iPa>\u0003%\u0015CXmY;uS>tW\t_2faRLwN\u001c\u000b\u0005\u0003O\u0019\t\u0001C\u0004\u0003@Q\u0002\raa\u0001\u0011\u0007\u0011\u001b)!C\u0002\u0004\b)\u00131cQ8na2,G/\u001a3UCN\\'+Z:vYR\fqc];qKJ$#/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0016\u0003a\fae\u00117vgR,'\u000fT5oWB\u0013X\r]1sKB+g\u000eZ5oOJ+7\u000f^8sK6K'O]8s!\t)ugE\u00028\u0007'\u00012!_B\u000b\u0013\r\u00199B\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r=\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0004 )\u001a\u0001p!\t,\u0005\r\r\u0002\u0003BB\u0013\u0007_i!aa\n\u000b\t\r%21F\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\fS\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007c\u00199CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ClusterLinkPreparePendingRestoreMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private Uuid remoteTopicId;
    private final Set<TopicPartition> completedPartitions;
    private boolean initialDescribeTopicCheckDone;
    private boolean finalDescribeTopicCheckDone;
    private boolean remoteOffsetsFetched;
    private final ClusterLinkMetadataManager metadataManager;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private final scala.collection.mutable.Map<TopicPartition, Object> partitionsToOffset;
    private final scala.collection.mutable.Map<TopicPartition, Object> partitionsToEpoch;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkPreparePendingRestoreMirror$.MODULE$.$lessinit$greater$default$7();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private Uuid remoteTopicId() {
        return this.remoteTopicId;
    }

    private void remoteTopicId_$eq(Uuid x$1) {
        this.remoteTopicId = x$1;
    }

    private Set<TopicPartition> completedPartitions() {
        return this.completedPartitions;
    }

    private boolean initialDescribeTopicCheckDone() {
        return this.initialDescribeTopicCheckDone;
    }

    private void initialDescribeTopicCheckDone_$eq(boolean x$1) {
        this.initialDescribeTopicCheckDone = x$1;
    }

    private boolean finalDescribeTopicCheckDone() {
        return this.finalDescribeTopicCheckDone;
    }

    private void finalDescribeTopicCheckDone_$eq(boolean x$1) {
        this.finalDescribeTopicCheckDone = x$1;
    }

    private boolean remoteOffsetsFetched() {
        return this.remoteOffsetsFetched;
    }

    private void remoteOffsetsFetched_$eq(boolean x$1) {
        this.remoteOffsetsFetched = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private scala.collection.mutable.Map<TopicPartition, Object> partitionsToOffset() {
        return this.partitionsToOffset;
    }

    private scala.collection.mutable.Map<TopicPartition, Object> partitionsToEpoch() {
        return this.partitionsToEpoch;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq)Seq$.MODULE$.empty());
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Cannot restore mirror topic '" + $this.topic + "' since it is deleted - shutting down task.");
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        boolean bl = false;
        Some some = null;
        Option option = mirrorState;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingSetupForRestoreMirror) {
                ClusterLinkTopicState.PendingSetupForRestoreMirror pendingSetupForRestoreMirror = (ClusterLinkTopicState.PendingSetupForRestoreMirror)clusterLinkTopicState;
                Uuid sourceTopicId = pendingSetupForRestoreMirror.sourceTopicId();
                Seq<Object> epochs = pendingSetupForRestoreMirror.truncationEpochs();
                Seq<Object> offsets = pendingSetupForRestoreMirror.truncationOffsets();
                if (epochs == null || epochs.isEmpty()) {
                    this.warn((Function0<String> & Serializable)() -> "Mirror topic '" + $this.topic + " has invalid truncationEpochs', shutting down ClusterLinkPreparePendingRestoreMirror task");
                    return this.onCompletion(taskContext);
                }
                if (offsets == null || offsets.isEmpty()) {
                    this.warn((Function0<String> & Serializable)() -> "Mirror topic '" + $this.topic + " has invalid truncationOffsets', shutting down ClusterLinkPreparePendingRestoreMirror task");
                    return this.onCompletion(taskContext);
                }
                this.remoteTopicId_$eq(sourceTopicId);
                this.partitions().foreach((Function1<TopicPartition, Option> & Serializable)tp -> {
                    this.partitionsToEpoch().put((TopicPartition)tp, epochs.apply(tp.partition()));
                    return this.partitionsToOffset().put((TopicPartition)tp, offsets.apply(tp.partition()));
                });
                return this.transition(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See mirror '" + state + "' for mirror topic '" + $this.topic + "', shutting down ClusterLinkPreparePendingRestoreMirror task");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror state for mirror topic '" + $this.topic + "', shutting down ClusterLinkPreparePendingRestoreMirror task");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (!this.initialDescribeTopicCheckDone()) {
            return this.describeSourceTopic(taskContext, true);
        }
        if (!this.remoteOffsetsFetched()) {
            return this.offsetsForLeaderEpoch(taskContext, this.offsetsForLeaderEpochRequest());
        }
        if (!this.finalDescribeTopicCheckDone()) {
            return this.describeSourceTopic(taskContext, false);
        }
        Object mirrorStartOffsets = ((List)this.partitionsToOffset().toList().sortBy((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToInteger(ClusterLinkPreparePendingRestoreMirror.$anonfun$transition$1(x0$1)), (Ordering)Ordering.Int$.MODULE$)).map((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToLong(ClusterLinkPreparePendingRestoreMirror.$anonfun$transition$2(x0$2)));
        return this.convertToPendingRestoreMirror(taskContext, (scala.collection.immutable.Seq<Object>)mirrorStartOffsets);
    }

    private ClusterLinkScheduler.TaskResult describeSourceTopic(ClusterLinkScheduler.TaskContext taskContext, boolean initialCheck) {
        this.debug((Function0<String> & Serializable)() -> "Describing source topic for mirror topic " + $this.topic);
        DescribeTopicsResult describeRemoteTopic = this.remoteAdmin.describeTopics(Collections.singletonList(this.topic));
        this.scheduleWhenComplete(describeRemoteTopic.allTopicNames(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleDescribeSourceTopicResult((ClusterLinkScheduler.TaskContext)tc, initialCheck, describeRemoteTopic.topicNameValues()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeSourceTopicResult(ClusterLinkScheduler.TaskContext taskContext, boolean initialCheck, Map<String, KafkaFuture<TopicDescription>> topicResult) {
        ClusterLinkScheduler.TaskResult taskResult;
        block7: {
            try {
                TopicDescription remoteTopicDescription = (TopicDescription)topicResult.get(this.topic).get();
                Uuid topicId = remoteTopicDescription.topicId();
                if (!topicId.equals((Object)this.remoteTopicId())) {
                    this.warn((Function0<String> & Serializable)() -> "Remote topic id " + topicId + " does not match the expected remote topic id " + this.remoteTopicId() + ". Failing mirror topic " + $this.topic);
                    v0 = this.failMirrorTopic(taskContext);
                } else {
                    if (initialCheck) {
                        this.initialDescribeTopicCheckDone_$eq(true);
                    } else {
                        this.finalDescribeTopicCheckDone_$eq(true);
                    }
                    v0 = BoxedUnit.UNIT;
                }
                taskResult = this.transition(taskContext);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    this.warn((Function0<String> & Serializable)() -> "Topic " + $this.topic + " was not found on remote cluster. Failing mirror topic");
                    taskResult = this.failMirrorTopic(taskContext);
                    break block7;
                }
                String errorString = "Failed to retrieve source topic information for topic " + this.topic + ". Retrying the task in " + super.rescheduleDelayMs() + ".";
                ApiException ex = ClusterLinkUtils$.MODULE$.apiException(e, errorString);
                this.excessiveLoggingHandler().handle(ex, this, "Encountered exception when trying to describe remote topic " + this.topic + ". Will retry in " + super.rescheduleDelayMs() + ".");
                taskResult = ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg(errorString, false, e)), Nil$.MODULE$)));
            }
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult failMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        this.debug((Function0<String> & Serializable)() -> "Failing mirror topic " + $this.topic);
        AlterMirrorsResult result = this.localAdmin.failMirror(this.topic, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED);
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleFailMirrorResult((ClusterLinkScheduler.TaskContext)tc, result), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleFailMirrorResult(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            this.debug((Function0<String> & Serializable)() -> "Failing mirror topic " + $this.topic + " due to issues encountered when trying to restore mirror topic");
            result.all().get();
            taskResult = this.onCompletion(taskContext);
        }
        catch (ExecutionException e) {
            this.warn((Function0<String> & Serializable)() -> "Unable to fail local mirror topic " + $this.topic + ", shutting down task. Please execute the failover command on the local mirror topic to make the topic writable: " + e);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg("Failed to fail the local mirror topic " + this.topic, true, e)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> getPartitionToOffset() {
        return this.partitionsToOffset().toMap($less$colon$less$.MODULE$.refl());
    }

    private Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> offsetsForLeaderEpochRequest() {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic offsetForLeaderTopic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic();
        ArrayList offsetsForLeaderPartitions = new ArrayList();
        scala.collection.immutable.Set partitionsToRequest = (scala.collection.immutable.Set)this.partitions().$minus$minus(this.completedPartitions());
        partitionsToRequest.foreach((Function1<TopicPartition, Object> & Serializable)tp -> BoxesRunTime.boxToBoolean(ClusterLinkPreparePendingRestoreMirror.$anonfun$offsetsForLeaderEpochRequest$1(this, offsetsForLeaderPartitions, tp)));
        offsetForLeaderTopic.setTopic(this.topic).setPartitions(offsetsForLeaderPartitions);
        return Collections.singletonList(offsetForLeaderTopic);
    }

    private ClusterLinkScheduler.TaskResult offsetsForLeaderEpoch(ClusterLinkScheduler.TaskContext taskContext, Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> requestData) {
        this.debug((Function0<String> & Serializable)() -> "Fetching offsets for leader epoch from remote topic for mirror topic " + $this.topic + ".");
        OffsetForLeaderEpochResult offsetsForLeaderEpochResult = this.remoteAdmin.offsetsForLeaderEpoch(requestData, new OffsetForLeaderEpochOptions());
        this.scheduleWhenComplete(offsetsForLeaderEpochResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleOffsetsForLeaderEpochResult((ClusterLinkScheduler.TaskContext)tc, offsetsForLeaderEpochResult.endOffsets()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleOffsetsForLeaderEpochResult(ClusterLinkScheduler.TaskContext taskContext, Map<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> endOffsets) {
        HashMap errorPartitions = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        CollectionConverters$.MODULE$.MapHasAsScala(endOffsets).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Serializable serializable;
                TopicPartition tp = (TopicPartition)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset offset = (OffsetForLeaderEpochResponseData.EpochEndOffset)future.get();
                    Serializable serializable2 = offset != null && offset.endOffset() != -1L ? this.partitionsToOffset().put(tp, BoxesRunTime.boxToLong(offset.endOffset())) : BoxedUnit.UNIT;
                    serializable = BoxesRunTime.boxToBoolean(this.completedPartitions().add(tp));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Error fetching offset for partition " + tp + ": " + e + ". Will retry this partition in " + this.super$rescheduleDelayMs() + "ms.");
                    serializable = errorPartitions.put(tp, this.taskErrorCodeAndMsg("Failed to fetch the offsetsForLeaderEpochResults for topic partition " + tp, false, e));
                }
                return serializable;
            }
            throw new MatchError(tuple2);
        });
        if (errorPartitions.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Successfully completed OffsetsForLeaderEpoch request for all partitions of topic " + $this.topic);
            this.remoteOffsetsFetched_$eq(true);
            return this.transition(taskContext);
        }
        this.debug((Function0<String> & Serializable)() -> "Got errors when trying to submit the OffsetsForLeaderEpoch request for the following partitions' " + errorPartitions.keySet().mkString(",") + ". Will retry in " + this.super$rescheduleDelayMs() + ".");
        return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(errorPartitions.values().toSeq()));
    }

    private ClusterLinkScheduler.TaskResult convertToPendingRestoreMirror(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<Object> mirrorStartOffsets) {
        if (mirrorStartOffsets.size() != this.partitions().size()) {
            String errMsg = "The number of truncation offsets for mirror topic " + this.topic + " differs from the number of the partitions. Retrying the task in " + super.rescheduleDelayMs() + ".";
            this.warn((Function0<String> & Serializable)() -> errMsg);
            this.remoteOffsetsFetched_$eq(false);
            this.initialDescribeTopicCheckDone_$eq(false);
            this.finalDescribeTopicCheckDone_$eq(false);
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        this.debug((Function0<String> & Serializable)() -> "Converting mirror topic " + $this.topic + " to PendingRestoreMirror state.");
        KafkaFuture convertFuture = this.localAdmin.convertToPendingRestoreMirror(this.topic, mirrorStartOffsets).all();
        this.scheduleWhenComplete(convertFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleConvertToPendingRestoreMirrorResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Void>)convertFuture), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleConvertToPendingRestoreMirrorResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Void> result) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            result.get();
            this.info((Function0<String> & Serializable)() -> "Successfully converted mirror topic " + $this.topic + " to PendingRestoreMirror state.");
            taskResult = this.onCompletion(taskContext);
        }
        catch (ExecutionException ex) {
            String errorString = "Failed to convert to PendingRestoreMirror state for mirror topic " + this.topic + ". Retrying the task to convert the state";
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, errorString);
            this.excessiveLoggingHandler().handle(e, this, "Encountered exception when trying to convert topic to PendingRestoreMirror " + this.topic + ".");
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg("Failed to convert to PendingRestoreMirror for mirror topic " + this.topic, true, ex)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Shutting PreparePendingRestoreMirror task for mirror topic " + $this.topic + ".");
        this.shutdown();
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof UnknownTopicOrPartitionException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsgPrefix + " due to the topic not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteMirrorNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the mirror topic not existing on the remote cluster.");
        }
        if (throwable instanceof ClusterLinkNotFoundException) {
            if (localAdminUsed) {
                return new TaskErrorCodeAndMsg(LinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the local cluster.");
            }
            return new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, errMsgPrefix + " due to the link not existing on the remote cluster.");
        }
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkPreparePendingRestoreMirrorsTaskType$.MODULE$, true, "convert to PendingRestoreMirror"));
    }

    public static final /* synthetic */ int $anonfun$transition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            return tp.partition();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$transition$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long offset = tuple2._2$mcJ$sp();
            return offset;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$offsetsForLeaderEpochRequest$1(ClusterLinkPreparePendingRestoreMirror $this, java.util.List offsetsForLeaderPartitions$1, TopicPartition tp) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition offsetForLeaderPartition = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setLeaderEpoch(BoxesRunTime.unboxToInt($this.partitionsToEpoch().apply(tp)));
        return offsetsForLeaderPartitions$1.add(offsetForLeaderPartition);
    }

    public ClusterLinkPreparePendingRestoreMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin localAdmin, ClusterLinkBatchAdmin remoteAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        this.remoteAdmin = remoteAdmin;
        super(clientManager.scheduler(), "ClusterLinkPreparePendingRestoreMirror", intervalMs, time, quota);
        this.completedPartitions = new HashSet<TopicPartition>();
        this.initialDescribeTopicCheckDone = false;
        this.finalDescribeTopicCheckDone = false;
        this.remoteOffsetsFetched = false;
        this.metadataManager = clientManager.metadataManager();
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.partitionsToOffset = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.partitionsToEpoch = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.taskDesc = None$.MODULE$;
    }
}

