/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import kafka.server.KafkaConfig;
import kafka.server.UnboundedClusterLinkRequestQuota$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkReporter$;
import kafka.server.link.ClusterLinkReporter$MirrorState$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.ReportClusterLinkStatusOptions;
import org.apache.kafka.clients.admin.ReportClusterLinkStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ReportClusterLinkStatusRequest;
import org.apache.kafka.common.requests.ReportClusterLinkStatusResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001B\u001f?\u0001\u0015C\u0001B\u0014\u0001\u0003\u0006\u0004%Ia\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005!\"IQ\u000b\u0001B\u0001B\u0003%a+\u0017\u0005\t5\u0002\u0011\t\u0011)A\u00057\"AA\r\u0001B\u0001B\u0003%Q\rC\u0005l\u0001\t\u0005\t\u0015!\u0003ms\"I!\u0010\u0001B\u0001B\u0003%1P \u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\f\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u00030\u0001\u0001\u000b\u0011BA\u001e\u0011%\u0011\t\u0004\u0001a\u0001\n\u0013\u0011\u0019\u0004C\u0005\u0003B\u0001\u0001\r\u0011\"\u0003\u0003D!A!q\t\u0001!B\u0013\u0011)\u0004C\u0005\u0003R\u0001\u0001\r\u0011\"\u0001\u0003T!I!Q\u000b\u0001A\u0002\u0013\u0005!q\u000b\u0005\t\u00057\u0002\u0001\u0015)\u0003\u0003\u0014!9!q\f\u0001\u0005B\t\u0005\u0004b\u0002B2\u0001\u0011E#Q\r\u0005\b\u0005w\u0002A\u0011\tB?\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003CqA!$\u0001\t\u0013\u0011y\tC\u0004\u0003N\u0002!\tAa4\t\u000f\tM\u0007\u0001\"\u0003\u0003V\"9!q\u001e\u0001\u0005\n\tE\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007'\u0001A\u0011KB\u000b\u0011\u001d\u0019\t\u0003\u0001C\u0005\u0007GAqa!\f\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00040\u0001!\tAa\t\u0007\r\u0005\u0005\u0003\u0001RA\"\u0011)\tI\u0007\tBK\u0002\u0013\u0005\u00111\u000e\u0005\u000b\u00037\u0003#\u0011#Q\u0001\n\u00055\u0004BCAOA\tU\r\u0011\"\u0001\u0002 \"Q\u0011\u0011\u0017\u0011\u0003\u0012\u0003\u0006I!!)\t\u000f\u0005\u0005\u0001\u0005\"\u0001\u00024\"I\u0011\u0011\u0018\u0011\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0003\u0004\u0013\u0013!C\u0001\u0003\u0007D\u0011\"!7!#\u0003%\t!a7\t\u0013\u0005}\u0007%!A\u0005B\u0005\u0005\b\"CAyA\u0005\u0005I\u0011AAz\u0011%\t)\u0010IA\u0001\n\u0003\t9\u0010C\u0005\u0003\u0004\u0001\n\t\u0011\"\u0011\u0003\u0006!I!q\u0002\u0011\u0002\u0002\u0013\u0005!\u0011\u0003\u0005\n\u00057\u0001\u0013\u0011!C!\u0005;A\u0011B!\t!\u0003\u0003%\tEa\t\t\u0013\t\u0015\u0002%!A\u0005B\t\u001d\u0002\"\u0003B\u0015A\u0005\u0005I\u0011\tB\u0016\u000f%\u0019\t\u0004AA\u0001\u0012\u0013\u0019\u0019DB\u0005\u0002B\u0001\t\t\u0011#\u0003\u00046!9\u0011\u0011A\u001a\u0005\u0002\r5\u0003\"\u0003B\u0013g\u0005\u0005IQ\tB\u0014\u0011%\u0019yeMA\u0001\n\u0003\u001b\t\u0006C\u0005\u0004XM\n\t\u0011\"!\u0004Z\u001d91q\r \t\u0002\r%dAB\u001f?\u0011\u0003\u0019Y\u0007C\u0004\u0002\u0002e\"\ta!\u001c\t\u000f\r=\u0014\b\"\u0001\u0004r!I1qQ\u001d\u0012\u0002\u0013\u00051\u0011\u0012\u0002\u0014\u00072,8\u000f^3s\u0019&t7NU3q_J$XM\u001d\u0006\u0003\u007f\u0001\u000bA\u0001\\5oW*\u0011\u0011IQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\rB\u0011qi\u0013\b\u0003\u0011&k\u0011AP\u0005\u0003\u0015z\nAc\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018B\u0001'N\u00051\u0001VM]5pI&\u001cG+Y:l\u0015\tQe(\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001Q!\t\t&+D\u0001A\u0013\t\u0019\u0006IA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%A\u0005tG\",G-\u001e7feB\u0011\u0001jV\u0005\u00031z\u0012Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018BA+L\u0003EawnY1m\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\t\u00049~\u000bW\"A/\u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001%c\u0013\t\u0019gHA\u000bDYV\u001cH/\u001a:MS:\\Gj\\2bY\u0006#W.\u001b8\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t1\u0017.D\u0001h\u0015\tA\u0007)\u0001\u0005nKR\fG-\u0019;b\u0013\tQwM\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017\u0001\u0002;j[\u0016\u0004\"!\\<\u000e\u00039T!a\u001c9\u0002\u000bU$\u0018\u000e\\:\u000b\u0005E\u0014\u0018AB2p[6|gN\u0003\u0002Dg*\u0011A/^\u0001\u0007CB\f7\r[3\u000b\u0003Y\f1a\u001c:h\u0013\tAhN\u0001\u0003US6,\u0017BA6L\u0003)Ig\u000e^3sm\u0006dWj\u001d\t\u00039rL!!`/\u0003\u0007%sG/\u0003\u0002\u0000\u0017\u0006\t\"/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0002\rqJg.\u001b;?)9\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\u0001\"\u0001\u0013\u0001\t\u000b9C\u0001\u0019\u0001)\t\u000bUC\u0001\u0019\u0001,\t\u000biC\u0001\u0019A.\t\u000b\u0011D\u0001\u0019A3\t\u000b-D\u0001\u0019\u00017\t\u000fiD\u0001\u0013!a\u0001w\u0006q\u0001/\u001a8eS:<\u0007+\u001e2mSNDWCAA\f!!\tI\"a\t\u0002(\u0005=RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\"u\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)#a\u0007\u0003\u000fQ\u0013\u0018.Z'baB!\u0011\u0011FA\u0016\u001b\u0005\u0001\u0018bAA\u0017a\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007c\u0001/\u00022%\u0019\u00111G/\u0003\tUs\u0017\u000e^\u0001\u0010a\u0016tG-\u001b8h!V\u0014G.[:iA\u0005i1-\u001e:sK:$8\u000b^1uKN,\"!a\u000f\u0011\u0011\u0005e\u00111EA\u0014\u0003{\u00012!a\u0010!\u001b\u0005\u0001!aC'jeJ|'o\u0015;bi\u0016\u001cr\u0001IA#\u0003\u0017\n\t\u0006E\u0002]\u0003\u000fJ1!!\u0013^\u0005\u0019\te.\u001f*fMB\u0019A,!\u0014\n\u0007\u0005=SLA\u0004Qe>$Wo\u0019;\u0011\t\u0005M\u00131\r\b\u0005\u0003+\nyF\u0004\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006R\u0001\u0007yI|w\u000e\u001e \n\u0003yK1!!\u0019^\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011\u0011M/\u0002\u000bM$\u0018\r^3\u0016\u0005\u00055\u0004\u0003BA8\u0003+sA!!\u001d\u0002\u0010:!\u00111OAE\u001d\u0011\t)(!\"\u000f\t\u0005]\u00141\u0011\b\u0005\u0003s\n\tI\u0004\u0003\u0002|\u0005}d\u0002BA,\u0003{J\u0011A^\u0005\u0003iVL!aQ:\n\u0005E\u0014\u0018bAADa\u00069!/\u001a9mS\u000e\f\u0017\u0002BAF\u0003\u001b\u000bQBU3qY&\u001c\u0017m\u0015;biV\u001c(bAADa&!\u0011\u0011SAJ\u0003)i\u0015N\u001d:pe&sgm\u001c\u0006\u0005\u0003\u0017\u000bi)\u0003\u0003\u0002\u0018\u0006e%!B*uCR,'\u0002BAI\u0003'\u000baa\u001d;bi\u0016\u0004\u0013\u0001\u00037j].t\u0015-\\3\u0016\u0005\u0005\u0005\u0006\u0003BAR\u0003WsA!!*\u0002(B\u0019\u0011qK/\n\u0007\u0005%V,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\u000byK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Sk\u0016!\u00037j].t\u0015-\\3!)\u0019\ti$!.\u00028\"9\u0011\u0011N\u0013A\u0002\u00055\u0004bBAOK\u0001\u0007\u0011\u0011U\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002>\u0005u\u0016q\u0018\u0005\n\u0003S2\u0003\u0013!a\u0001\u0003[B\u0011\"!('!\u0003\u0005\r!!)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0019\u0016\u0005\u0003[\n9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019.X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!8+\t\u0005\u0005\u0016qY\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0006!!.\u0019<b\u0013\u0011\ti+a:\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003m\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002z\u0006}\bc\u0001/\u0002|&\u0019\u0011Q`/\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\u0002-\n\t\u00111\u0001|\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0001\t\u0007\u0005\u0013\u0011Y!!?\u000e\u0005\u0005}\u0011\u0002\u0002B\u0007\u0003?\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0003B\r!\ra&QC\u0005\u0004\u0005/i&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u0003i\u0013\u0011!a\u0001\u0003s\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u001dB\u0010\u0011!\u0011\tALA\u0001\u0002\u0004Y\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003m\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\fa!Z9vC2\u001cH\u0003\u0002B\n\u0005[A\u0011B!\u00012\u0003\u0003\u0005\r!!?\u0002\u001d\r,(O]3oiN#\u0018\r^3tA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u00036A)ALa\u000e\u0003<%\u0019!\u0011H/\u0003\r=\u0003H/[8o!\rA%QH\u0005\u0004\u0005\u007fq$a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005=\"Q\t\u0005\n\u0005\u0003q\u0011\u0011!a\u0001\u0005k\t\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007=\u0011Y\u0005E\u0002]\u0005\u001bJ1Aa\u0014^\u0005!1x\u000e\\1uS2,\u0017a\u00044pe\u000e,g)\u001e7m%\u0016\u0004xN\u001d;\u0016\u0005\tM\u0011a\u00054pe\u000e,g)\u001e7m%\u0016\u0004xN\u001d;`I\u0015\fH\u0003BA\u0018\u00053B\u0011B!\u0001\u0012\u0003\u0003\u0005\rAa\u0005\u0002!\u0019|'oY3Gk2d'+\u001a9peR\u0004\u0003f\u0001\n\u0003L\u0005yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u00036\u0005\u0019!/\u001e8\u0015\u0005\t\u001d\u0004\u0003\u0002B5\u0005or1Aa\u001bJ\u001d\u0011\u0011iG!\u001e\u000f\t\t=$1\u000f\b\u0005\u0003/\u0012\t(C\u0001D\u0013\t\t%)\u0003\u0002@\u0001&\u0019!\u0011P'\u0003\u0015Q\u000b7o\u001b*fgVdG/\u0001\u0005tQV$Hm\\<o)\t\ty#A\u000esKB|'\u000f\u001e)beRLG/[8o\u001b&\u0014(o\u001c:Ti\u0006$Xm\u001d\u000b\u0005\u0005O\u0012\u0019\tC\u0004\u0003\u0006Z\u0001\rAa\"\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0005S\u0012I)C\u0002\u0003\f6\u00131\u0002V1tW\u000e{g\u000e^3yi\u0006\u0011\u0002.\u00198eY\u0016\u0014V\r]8siJ+7/\u001e7u)!\u00119G!%\u0003\u0014\n}\u0006b\u0002BC/\u0001\u0007!q\u0011\u0005\b\u0005+;\u0002\u0019\u0001BL\u0003\u001d\u0011Xm];miN\u0004\u0002B!'\u0003 \u0006\u0005&1U\u0007\u0003\u00057SAA!(\u0002l\u0006!Q\u000f^5m\u0013\u0011\u0011\tKa'\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002*\t\u0015&\u0011V\u0005\u0004\u0005O\u0003(aC&bM.\fg)\u001e;ve\u0016\u0004BAa+\u0003::!!Q\u0016BZ\u001d\u0011\t)Ha,\n\u0007\tE\u0006/\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011)La.\u0002?I+\u0007o\u001c:u\u00072,8\u000f^3s\u0019&t7n\u0015;biV\u001c(+Z:q_:\u001cXMC\u0002\u00032BLAAa/\u0003>\ni\u0001+\u001e2mSND'+Z:vYRTAA!.\u00038\"9!\u0011Y\fA\u0002\t\r\u0017\u0001\u00059beRLG/[8og\nKH*\u001b8l!!\t\u0019K!2\u0002\"\n\u001d\u0017\u0002\u0002BQ\u0003_\u0003b!a\u0015\u0003J\u0006\u001d\u0012\u0002\u0002Bf\u0003O\u0012A\u0001T5ti\u0006)#/\u001a4sKND\u0017I\u001c3SKB|'\u000f\u001e)beRLG/[8o\u001b&\u0014(o\u001c:Ti\u0006$Xm\u001d\u000b\u0005\u0005O\u0012\t\u000eC\u0004\u0003\u0006b\u0001\rAa\"\u00023!\fg\u000e\u001a7f%\u0016\u0004H.[2b'R\fG/^:SKN,H\u000e\u001e\u000b\u0007\u0005O\u00129N!7\t\u000f\t\u0015\u0015\u00041\u0001\u0003\b\"9!QS\rA\u0002\tm\u0007\u0003\u0003BM\u0005?\u000b9C!8\u0011\r\u0005%\"Q\u0015Bp!\u0011\u0011\tOa;\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\fQ!\u00193nS:T1A!;s\u0003\u001d\u0019G.[3oiNLAA!<\u0003d\ny\u0001+\u0019:uSRLwN\u001c*fgVdG/\u0001\u000fdY\u0016\fg.\u00169QCJ$\u0018\u000e^5p]6K'O]8s'R\fG/Z:\u0015\t\u0005=\"1\u001f\u0005\b\u0005kT\u0002\u0019\u0001B|\u0003Ai\u0017N\u001d:peB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0002$\ne\u0018qE\u0005\u0005\u0005w\fyKA\u0002TKR\fabZ3u\u001b&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0004\u0004\u0002\r\r1q\u0001\t\u00069\n]\u0012Q\b\u0005\b\u0007\u000bY\u0002\u0019AA\u0014\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dqa!\u0003\u001c\u0001\u0004\u0019Y!\u0001\u0004mCR,7\u000f\u001e\t\u0005\u0007\u001b\u0019y!\u0004\u0002\u0002\u000e&!1\u0011CAG\u00055\u0011V\r\u001d7jG\u0006\u001cF/\u0019;vg\u0006aqN\\\"p[BdW\r^5p]R!\u0011qFB\f\u0011\u001d\u0019I\u0002\ba\u0001\u00077\taA]3tk2$\bcA$\u0004\u001e%\u00191qD'\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0017\u001d,G\u000fT5oW:\u000bW.\u001a\u000b\u0007\u0007K\u00199c!\u000b\u0011\u000bq\u00139$!)\t\u000f\r\u0015Q\u00041\u0001\u0002(!911F\u000fA\u0002\r-\u0011AB:uCR,8/\u0001\nqK:$\u0017N\\4Qk\nd\u0017n\u001d5TSj,\u0017!E2veJ,g\u000e^*uCR,7oU5{K\u0006YQ*\u001b:s_J\u001cF/\u0019;f!\r\tydM\n\u0006g\r]21\t\t\u000b\u0007s\u0019y$!\u001c\u0002\"\u0006uRBAB\u001e\u0015\r\u0019i$X\u0001\beVtG/[7f\u0013\u0011\u0019\tea\u000f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004F\r-SBAB$\u0015\u0011\u0019I%a;\u0002\u0005%|\u0017\u0002BA3\u0007\u000f\"\"aa\r\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005u21KB+\u0011\u001d\tIG\u000ea\u0001\u0003[Bq!!(7\u0001\u0004\t\t+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rm31\r\t\u00069\n]2Q\f\t\b9\u000e}\u0013QNAQ\u0013\r\u0019\t'\u0018\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\r\u0015t'!AA\u0002\u0005u\u0012a\u0001=%a\u0005\u00192\t\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004xN\u001d;feB\u0011\u0001*O\n\u0004s\u0005\u0015CCAB5\u0003e\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn\u001b*fa>\u0014H/\u001a:\u0015\u0019\rM4QOB<\u0007s\u001aYh!\"\u0011\u000bq\u00139$!\u0002\t\u000b9[\u0004\u0019\u0001)\t\u000bU[\u0004\u0019\u0001,\t\u000bi[\u0004\u0019A.\t\u000f\ru4\b1\u0001\u0004\u0000\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fE\u0002I\u0007\u0003K1aa!?\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0011\u0015Y7\b1\u0001m\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u001111\u0012\u0016\u0004w\u0006\u001d\u0007")
public class ClusterLinkReporter
extends ClusterLinkScheduler.PeriodicTask {
    private volatile ClusterLinkReporter$MirrorState$ MirrorState$module;
    private final KafkaConfig brokerConfig;
    private final Function0<ClusterLinkLocalAdmin> localAdminFactory;
    private final KRaftMetadataCache metadataCache;
    private final TrieMap<TopicPartition, BoxedUnit> pendingPublish;
    private final TrieMap<TopicPartition, MirrorState> currentStates;
    private volatile Option<TaskDescription> taskDesc;
    private volatile boolean forceFullReport;

    public static int $lessinit$greater$default$6() {
        return ClusterLinkReporter$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<ClusterLinkReporter> createClusterLinkReporter(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, Function0<ClusterLinkLocalAdmin> localAdminFactory, ClusterLinkMetadataManager metadataManager, Time time) {
        return ClusterLinkReporter$.MODULE$.createClusterLinkReporter(brokerConfig, scheduler, localAdminFactory, metadataManager, time);
    }

    private ClusterLinkReporter$MirrorState$ MirrorState() {
        if (this.MirrorState$module == null) {
            this.MirrorState$lzycompute$1();
        }
        return this.MirrorState$module;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private TrieMap<TopicPartition, BoxedUnit> pendingPublish() {
        return this.pendingPublish;
    }

    private TrieMap<TopicPartition, MirrorState> currentStates() {
        return this.currentStates;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    public boolean forceFullReport() {
        return this.forceFullReport;
    }

    public void forceFullReport_$eq(boolean x$1) {
        this.forceFullReport = x$1;
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        return this.refreshAndReportPartitionMirrorStates(new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty()));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.pendingPublish().clear();
        this.currentStates().clear();
    }

    public ClusterLinkScheduler.TaskResult reportPartitionMirrorStates(ClusterLinkScheduler.TaskContext taskContext) {
        scala.collection.immutable.Map grouped = (scala.collection.immutable.Map)this.currentStates().groupBy((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MirrorState mirrorState = (MirrorState)tuple2._2();
                return mirrorState.linkName();
            }
            throw new MatchError(tuple2);
        }).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String linkName = (String)tuple2._1();
                TrieMap states = (TrieMap)tuple2._2();
                List partitionStates = ((IterableOnceOps)((IterableOps)states.filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(ClusterLinkReporter.$anonfun$reportPartitionMirrorStates$3(this, x0$3)))).map((Function1<Tuple2, ReportClusterLinkStatusRequest.PartitionMirrorState> & Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        MirrorState mirrorState = (MirrorState)tuple2._2();
                        return new ReportClusterLinkStatusRequest.PartitionMirrorState(topicPartition.partition(), topicPartition.topic(), mirrorState.state());
                    }
                    throw new MatchError(tuple2);
                })).toList();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(linkName), partitionStates);
            }
            throw new MatchError(tuple2);
        });
        java.util.List<ReportClusterLinkStatusRequest.ClusterLinkMirrorState> linkStates = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)grouped.map((Function1<Tuple2, ReportClusterLinkStatusRequest.ClusterLinkMirrorState> & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                String linkName = (String)tuple2._1();
                List partitionStates = (List)tuple2._2();
                return new ReportClusterLinkStatusRequest.ClusterLinkMirrorState(linkName, CollectionConverters$.MODULE$.SeqHasAsJava(partitionStates).asJava());
            }
            throw new MatchError(tuple2);
        })).toList()).asJava();
        ReportClusterLinkStatusResult result = this.localAdminFactory.apply().reportClusterLinkStatus(this.brokerConfig().brokerId(), linkStates, new ReportClusterLinkStatusOptions());
        scala.collection.immutable.Map reported = (scala.collection.immutable.Map)grouped.map((Function1<Tuple2, Tuple2> & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                String linkName = (String)tuple2._1();
                List partitionStates = (List)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(linkName), partitionStates.map((Function1<ReportClusterLinkStatusRequest.PartitionMirrorState, TopicPartition> & Serializable)state -> new TopicPartition(state.topicName(), state.partitionId())));
            }
            throw new MatchError(tuple2);
        });
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleReportResult((ClusterLinkScheduler.TaskContext)tc, result.results(), reported), taskContext));
        this.trace((Function0<String> & Serializable)() -> "Report mirror states for broker: " + this.brokerConfig().brokerId() + " with linkStates: " + Predef$.MODULE$.wrapRefArray(linkStates.toArray()).mkString(", ") + " and result: " + result + ".");
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleReportResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<ReportClusterLinkStatusResponse.PublishResult>> results, scala.collection.immutable.Map<String, List<TopicPartition>> partitionsByLink) {
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ReportClusterLinkStatusResponse.PublishResult result;
                ReportClusterLinkStatusResponse.PublishResult publishResult;
                String linkName = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    publishResult = (ReportClusterLinkStatusResponse.PublishResult)future.get();
                }
                catch (Throwable throwable) {
                    this.debug((Function0<String> & Serializable)() -> "Fail to report partition mirrorStates for " + linkName, (Function0<Throwable> & Serializable)() -> throwable);
                    publishResult = ReportClusterLinkStatusResponse.PublishResult.FAILED;
                }
                ReportClusterLinkStatusResponse.PublishResult publishResult2 = result = publishResult;
                if (ReportClusterLinkStatusResponse.PublishResult.SUCCESS.equals(publishResult2)) {
                    Option option = partitionsByLink.get(linkName);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        List value = (List)some.value();
                        value.foreach((Function1<TopicPartition, TrieMap> & Serializable)topicPartition -> (TrieMap)this.pendingPublish().$minus$eq((TopicPartition)topicPartition));
                        return None$.MODULE$;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.debug((Function0<String> & Serializable)() -> "Link " + linkName + " missed in pendingPublish when handling result.");
                        TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Link " + linkName + " missed in pendingPublish when handling result.");
                        return new Some<TaskErrorCodeAndMsg>(err);
                    }
                    throw new MatchError(option);
                }
                if (ReportClusterLinkStatusResponse.PublishResult.FAILED.equals(publishResult2)) {
                    this.debug((Function0<String> & Serializable)() -> "Fail to report clusterLink status for " + linkName + ".");
                    TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Fail to report clusterLink status for " + linkName + ".");
                    return new Some<TaskErrorCodeAndMsg>(err);
                }
                if (ReportClusterLinkStatusResponse.PublishResult.LINK_NOT_AVAILABLE.equals(publishResult2)) {
                    this.debug((Function0<String> & Serializable)() -> "Link coordinator not available for " + linkName + ".");
                    TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Link coordinator not available for " + linkName + ".");
                    return new Some<TaskErrorCodeAndMsg>(err);
                }
                throw new MatchError(publishResult2);
            }
            throw new MatchError(tuple2);
        });
        this.forceFullReport_$eq(false);
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
    }

    public ClusterLinkScheduler.TaskResult refreshAndReportPartitionMirrorStates(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.forceFullReport()) {
            this.pendingPublish().clear();
            this.currentStates().clear();
        }
        this.forceFullReport_$eq(true);
        Set<TopicPartition> mirrorPartitions = this.metadataCache.getMirrorPartitionsByLeader(this.brokerConfig().brokerId()).toSet();
        this.cleanUpPartitionMirrorStates(mirrorPartitions);
        ReplicaStatusResult results = this.localAdminFactory.apply().replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(mirrorPartitions).asJava(), new ReplicaStatusOptions());
        this.scheduleWhenComplete(results.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleReplicaStatusResult((ClusterLinkScheduler.TaskContext)tc, results.partitionResults()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatusResult(ClusterLinkScheduler.TaskContext taskContext, Map<TopicPartition, KafkaFuture<PartitionResult>> results) {
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((PartitionResult)future.get()).replicas()).asScala().filter((Function1<ReplicaStatus, Object> & Serializable)status -> BoxesRunTime.boxToBoolean(status.isLeader()))).foreach((Function1<ReplicaStatus, Object> & Serializable)status -> {
                        ClusterLinkReporter.$anonfun$handleReplicaStatusResult$3(this, topicPartition, status);
                        return BoxedUnit.UNIT;
                    });
                    option = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    this.debug((Function0<String> & Serializable)() -> "Fail to get replicaStatus for TopicPartition: " + topicPartition + ".", (Function0<Throwable> & Serializable)() -> throwable);
                    TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Fail to get replicaStatus for TopicPartition: " + topicPartition + ".");
                    option = new Some<TaskErrorCodeAndMsg>(err);
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (newTaskContext.errs().isEmpty()) {
            return this.reportPartitionMirrorStates(newTaskContext);
        }
        this.info((Function0<String> & Serializable)() -> "Report mirror states skipped due to failure in replicaStatus call for broker: " + this.brokerConfig().brokerId() + ".");
        return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
    }

    private void cleanUpPartitionMirrorStates(Set<TopicPartition> mirrorPartitions) {
        this.currentStates().keySet().foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            if (!mirrorPartitions.contains((TopicPartition)topicPartition)) {
                this.pendingPublish().$minus$eq((TopicPartition)topicPartition);
                return this.currentStates().$minus$eq((TopicPartition)topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        this.pendingPublish().keySet().foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            if (!this.currentStates().contains((TopicPartition)topicPartition)) {
                return this.pendingPublish().$minus$eq((TopicPartition)topicPartition);
            }
            return BoxedUnit.UNIT;
        });
    }

    private Option<MirrorState> getMirrorState(TopicPartition topicPartition, ReplicaStatus latest) {
        if (latest.mirrorInfo().isPresent()) {
            Option<MirrorState> option = this.currentStates().get(topicPartition);
            if (option instanceof Some) {
                Some some = (Some)option;
                MirrorState value = (MirrorState)some.value();
                ReplicaStatus.MirrorInfo.State state = value.state();
                ReplicaStatus.MirrorInfo.State state2 = ((ReplicaStatus.MirrorInfo)latest.mirrorInfo().get()).state();
                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                    return None$.MODULE$;
                }
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            Option<String> option2 = this.getLinkName(topicPartition, latest);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String linkName = (String)some.value();
                return new Some<MirrorState>(new MirrorState(this, ((ReplicaStatus.MirrorInfo)latest.mirrorInfo().get()).state(), linkName));
            }
            if (None$.MODULE$.equals(option2)) {
            } else {
                throw new MatchError(option2);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (result.errs().isEmpty() && result.ex().isEmpty()) {
            this.taskDesc_$eq(new Some<TaskDescription>(new TaskDescription(ActiveTaskState$.MODULE$, (Seq)package$.MODULE$.Seq().empty())));
            return;
        }
        Seq errs = (Seq)result.errs().$plus$plus((IterableOnce)result.ex().map((Function1<Throwable, Seq> & Serializable)x$1 -> new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to report partition mirrorStates for an unknown reason.")), Nil$.MODULE$)).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()));
        this.taskDesc_$eq(new Some<TaskDescription>(new TaskDescription(InErrorTaskState$.MODULE$, errs)));
    }

    private Option<String> getLinkName(TopicPartition topicPartition, ReplicaStatus status) {
        if (status.linkName().isPresent()) {
            return new Some<String>((String)status.linkName().get());
        }
        return this.metadataCache.getLinkNameByPartition(topicPartition);
    }

    public int pendingPublishSize() {
        return this.pendingPublish().size();
    }

    public int currentStatesSize() {
        return this.currentStates().size();
    }

    private final void MirrorState$lzycompute$1() {
        ClusterLinkReporter clusterLinkReporter = this;
        synchronized (clusterLinkReporter) {
            if (this.MirrorState$module == null) {
                this.MirrorState$module = new ClusterLinkReporter$MirrorState$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$reportPartitionMirrorStates$3(ClusterLinkReporter $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            return $this.pendingPublish().contains(topicPartition);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$handleReplicaStatusResult$3(ClusterLinkReporter $this, TopicPartition topicPartition$1, ReplicaStatus status) {
        Option<MirrorState> option = $this.getMirrorState(topicPartition$1, status);
        if (option instanceof Some) {
            Some some = (Some)option;
            MirrorState mirrorState = (MirrorState)some.value();
            $this.currentStates().update(topicPartition$1, mirrorState);
            $this.pendingPublish().update(topicPartition$1, BoxedUnit.UNIT);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public ClusterLinkReporter(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, Function0<ClusterLinkLocalAdmin> localAdminFactory, KRaftMetadataCache metadataCache, Time time, int intervalMs) {
        this.brokerConfig = brokerConfig;
        this.localAdminFactory = localAdminFactory;
        this.metadataCache = metadataCache;
        super(scheduler, "ClusterLinkReporter", intervalMs, time, UnboundedClusterLinkRequestQuota$.MODULE$);
        this.pendingPublish = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.currentStates = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.taskDesc = None$.MODULE$;
        this.forceFullReport = true;
    }

    private class MirrorState
    implements Product,
    Serializable {
        private final ReplicaStatus.MirrorInfo.State state;
        private final String linkName;
        public final /* synthetic */ ClusterLinkReporter $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public ReplicaStatus.MirrorInfo.State state() {
            return this.state;
        }

        public String linkName() {
            return this.linkName;
        }

        public MirrorState copy(ReplicaStatus.MirrorInfo.State state, String linkName) {
            return new MirrorState(this.kafka$server$link$ClusterLinkReporter$MirrorState$$$outer(), state, linkName);
        }

        public ReplicaStatus.MirrorInfo.State copy$default$1() {
            return this.state();
        }

        public String copy$default$2() {
            return this.linkName();
        }

        @Override
        public String productPrefix() {
            return "MirrorState";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.state();
                }
                case 1: {
                    return this.linkName();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof MirrorState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "state";
                }
                case 1: {
                    return "linkName";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MirrorState)) return false;
            if (((MirrorState)object).kafka$server$link$ClusterLinkReporter$MirrorState$$$outer() != this.kafka$server$link$ClusterLinkReporter$MirrorState$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MirrorState mirrorState = (MirrorState)x$1;
            ReplicaStatus.MirrorInfo.State state = this.state();
            ReplicaStatus.MirrorInfo.State state2 = mirrorState.state();
            if (state == null) {
                if (state2 != null) {
                    return false;
                }
            } else if (!state.equals(state2)) return false;
            String string = this.linkName();
            String string2 = mirrorState.linkName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!mirrorState.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClusterLinkReporter kafka$server$link$ClusterLinkReporter$MirrorState$$$outer() {
            return this.$outer;
        }

        public MirrorState(ClusterLinkReporter $outer, ReplicaStatus.MirrorInfo.State state, String linkName) {
            this.state = state;
            this.linkName = linkName;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

