/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkStopMirror$;
import kafka.server.link.ClusterLinkStopMirrorTopicTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002\"D\u0001)C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003g\u0011%Q\u0007A!A!\u0002\u0013Y\u0007\u0010C\u0005z\u0001\t\u0005\t\u0015!\u0003{}\"Yq\u0010\u0001B\u0001B\u0003%\u0011\u0011AA\u0005\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fA\u0011\"!\t\u0001\u0001\u0004%I!a\t\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0002\u0002CA\u001d\u0001\u0001\u0006K!!\n\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005\r\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011!\t\u0019\u0005\u0001Q!\n\u0005\u0015\u0002\"CA#\u0001\u0001\u0007I\u0011BA\u0012\u0011%\t9\u0005\u0001a\u0001\n\u0013\tI\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA\u0013\u0011%\ty\u0005\u0001a\u0001\n\u0013\t\u0019\u0003C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!A\u0011q\u000b\u0001!B\u0013\t)\u0003C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0004bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"! \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002j!Y\u0011q\u0010\u0001A\u0002\u0003\u0007I\u0011BAA\u0011-\t)\n\u0001a\u0001\u0002\u0004%I!a&\t\u0017\u0005m\u0005\u00011A\u0001B\u0003&\u00111\u0011\u0005\f\u0003;\u0003\u0001\u0019!a\u0001\n\u0013\ty\nC\u0006\u0002:\u0002\u0001\r\u00111A\u0005\n\u0005m\u0006bCA`\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CC\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u0005-\u0007\u0001)A\u0005\u0003\u000bD\u0011\"!4\u0001\u0001\u0004%I!a4\t\u0013\u0005u\u0007\u00011A\u0005\n\u0005}\u0007\u0002CAr\u0001\u0001\u0006K!!5\t\u000f\u00055\b\u0001\"\u0015\u0002p\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0012\u0001\t\u0013\u00119\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!q\r\u0001\u0005\n\t%\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00034\u0002!IA!.\t\u000f\tM\u0007\u0001\"\u0003\u0003V\"9!\u0011\u001d\u0001\u0005\n\t\r\bb\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0007\u000f\u0001A\u0011BA\u0012\u0011\u001d\u0019I\u0001\u0001C\u0005\u0007\u0017Aqaa\u0004\u0001\t\u0013\u0019\t\u0002C\u0004\u0004\"\u0001!Iaa\t\t\u000f\r\u0005\u0002\u0001\"\u0015\u0004(!91\u0011\u0007\u0001\u0005B\rM\u0002bBB\u001b\u0001\u0011%1q\u0007\u0005\u000f\u0007;\u0002\u0001\u0013aA\u0001\u0002\u0013%1qLA\u0005\u000f%\u0019\tgQA\u0001\u0012\u0003\u0019\u0019G\u0002\u0005C\u0007\u0006\u0005\t\u0012AB3\u0011\u001d\tia\u0010C\u0001\u0007[B\u0011ba\u001c@#\u0003%\ta!\u001d\u0003+\rcWo\u001d;fe2Kgn[*u_Bl\u0015N\u001d:pe*\u0011A)R\u0001\u0005Y&t7N\u0003\u0002G\u000f\u000611/\u001a:wKJT\u0011\u0001S\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\n\u0005\u0002M!:\u0011QJT\u0007\u0002\u0007&\u0011qjQ\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005E\u0013&\u0001\u0004)fe&|G-[2UCN\\'BA(D\u0003\u0015!x\u000e]5d!\t)fL\u0004\u0002W9B\u0011qKW\u0007\u00021*\u0011\u0011,S\u0001\u0007yI|w\u000e\u001e \u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;j\u000bQb\u00197jK:$X*\u00198bO\u0016\u0014\bCA'd\u0013\t!7I\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\t\u0003\u001b\u001eL!\u0001[\"\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006QAn\\2bY\u0006#W.\u001b8\u0002\tQLW.\u001a\t\u0003YZl\u0011!\u001c\u0006\u0003]>\fQ!\u001e;jYNT!\u0001]9\u0002\r\r|W.\\8o\u0015\tA%O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<n\u0005\u0011!\u0016.\\3\n\u0005)\u0004\u0016!B9v_R\f\u0007CA>}\u001b\u0005)\u0015BA?F\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0002z!\u0006Q\u0011N\u001c;feZ\fG.T:\u0011\t\u0005\r\u0011QA\u0007\u00025&\u0019\u0011q\u0001.\u0003\u0007%sG/C\u0002\u0002\fA\u000b\u0011C]3tG\",G-\u001e7f\t\u0016d\u0017-_'t\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003\u001b\u0002AQa\u0015\u0005A\u0002QCQ!\u0019\u0005A\u0002\tDQ!\u001a\u0005A\u0002\u0019DQ!\u001b\u0005A\u0002\u0019DQA\u001b\u0005A\u0002-DQ!\u001f\u0005A\u0002iD\u0001b \u0005\u0011\u0002\u0003\u0007\u0011\u0011A\u0001\fgft7\r\u001b:p]&TX-\u0006\u0002\u0002&A!\u00111AA\u0014\u0013\r\tIC\u0017\u0002\b\u0005>|G.Z1o\u0003=\u0019\u0018P\\2ie>t\u0017N_3`I\u0015\fH\u0003BA\u0018\u0003k\u0001B!a\u0001\u00022%\u0019\u00111\u0007.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003oQ\u0011\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u00031\u0019\u0018P\\2ie>t\u0017N_3!\u0003I)\b\u000fZ1uK\u0012$v\u000e]5d\u0007>tg-[4\u0002-U\u0004H-\u0019;fIR{\u0007/[2D_:4\u0017nZ0%KF$B!a\f\u0002B!I\u0011qG\u0007\u0002\u0002\u0003\u0007\u0011QE\u0001\u0014kB$\u0017\r^3e)>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0014kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]\u0001\u0018kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]0%KF$B!a\f\u0002L!I\u0011q\u0007\t\u0002\u0002\u0003\u0007\u0011QE\u0001\u0015kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go\u001d\u0011\u0002)U\u0004H-\u0019;fIJ+\u0007\u000f\\5dCN#\u0018\r^;t\u0003a)\b\u000fZ1uK\u0012\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003_\t)\u0006C\u0005\u00028M\t\t\u00111\u0001\u0002&\u0005)R\u000f\u001d3bi\u0016$'+\u001a9mS\u000e\f7\u000b^1ukN\u0004\u0013aF3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3s+\t\ti\u0006E\u0002N\u0003?J1!!\u0019D\u0005])\u0005pY3tg&4X\rT8hO&tw\rS1oI2,'/\u0001\rfq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7fe\u0002\n!\u0002]1si&$\u0018n\u001c8t+\t\tI\u0007E\u0003V\u0003W\ny'C\u0002\u0002n\u0001\u00141aU3u!\u0011\t\t(a\u001d\u000e\u0003=L1!!\u001ep\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002]1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005m\u0004\"CA\u001c1\u0005\u0005\t\u0019AA5\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002=A\f'\u000f^5uS>tGj\\4F]\u0012|eMZ:fi\u0006sG-\u00129pG\"\u001cXCAAB!\u001d)\u0016QQA8\u0003\u0013K1!a\"a\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0001/a$\u000b\u0005\u0019\u000b\u0018\u0002BAJ\u0003\u001b\u0013ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.\u0001\u0012qCJ$\u0018\u000e^5p]2{w-\u00128e\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2ig~#S-\u001d\u000b\u0005\u0003_\tI\nC\u0005\u00028m\t\t\u00111\u0001\u0002\u0004\u0006y\u0002/\u0019:uSRLwN\u001c'pO\u0016sGm\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007n\u001d\u0011\u0002\u0019\u001d\u0014x.\u001e9GS2$XM]:\u0016\u0005\u0005\u0005\u0006CBAR\u0003[\u000b\u0019L\u0004\u0003\u0002&\u0006%fbA,\u0002(&\t1,C\u0002\u0002,j\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0006E&aA*fc*\u0019\u00111\u0016.\u0011\u00075\u000b),C\u0002\u00028\u000e\u0013!d\u0012:pkB\u001cE.^:uKJd\u0015N\\6GS2$XM]%oM>\f\u0001c\u001a:pkB4\u0015\u000e\u001c;feN|F%Z9\u0015\t\u0005=\u0012Q\u0018\u0005\n\u0003oq\u0012\u0011!a\u0001\u0003C\u000bQb\u001a:pkB4\u0015\u000e\u001c;feN\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0005\u0005\u0015\u0007cA'\u0002H&\u0019\u0011\u0011Z\"\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0003;bg.$Um]2\u0016\u0005\u0005E\u0007CBA\u0002\u0003'\f9.C\u0002\u0002Vj\u0013aa\u00149uS>t\u0007cA'\u0002Z&\u0019\u00111\\\"\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\fA\u0002^1tW\u0012+7oY0%KF$B!a\f\u0002b\"I\u0011qG\u0012\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\ni\u0006\u001c8\u000eR3tG\u0002B3\u0001JAt!\u0011\t\u0019!!;\n\u0007\u0005-(L\u0001\u0005w_2\fG/\u001b7f\u0003\r\u0011XO\u001c\u000b\u0003\u0003c\u0004B!a=\u0003\u00029\u0019\u0011Q\u001f(\u000f\t\u0005]\u0018q \b\u0005\u0003s\fiPD\u0002X\u0003wL\u0011\u0001S\u0005\u0003\r\u001eK!\u0001R#\n\u0007\t\r!K\u0001\u0006UCN\\'+Z:vYR\f!\u0002\u001e:b]NLG/[8o)\u0011\t\tP!\u0003\t\u000f\t-a\u00051\u0001\u0003\u000e\u0005YA/Y:l\u0007>tG/\u001a=u!\u0011\t\u0019Pa\u0004\n\u0007\tE!KA\u0006UCN\\7i\u001c8uKb$\u0018\u0001\u00049s_\u000e,7o\u001d+pa&\u001cG\u0003BAy\u0005/AqAa\u0003(\u0001\u0004\u0011i!A\niC:$G.\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0004\u0002r\nu!q\u0004\u0005\b\u0005\u0017A\u0003\u0019\u0001B\u0007\u0011\u001d\u0011\t\u0003\u000ba\u0001\u0005G\taA]3tk2$\bcB+\u0002\u0006\u0006=$Q\u0005\t\u0007\u0003c\u00129Ca\u000b\n\u0007\t%rNA\u0006LC\u001a\\\u0017MR;ukJ,\u0007\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0005k\t\u0018aB2mS\u0016tGo]\u0005\u0005\u0005s\u0011yCA\bQCJ$\u0018\u000e^5p]J+7/\u001e7u\u0003Q\u0001(o\\2fgN\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vgR1\u0011\u0011\u001fB \u0005\u0003BqAa\u0003*\u0001\u0004\u0011i\u0001C\u0004\u0003\"%\u0002\rAa\u0011\u0011\u000fU\u000b))a\u001c\u0003,\u0005y1/\u001f8d)>\u0004\u0018nY\"p]\u001aLw\r\u0006\u0003\u0002r\n%\u0003b\u0002B\u0006U\u0001\u0007!QB\u0001\u0016Q\u0006tG\r\\3Ts:\u001cGk\u001c9jG\u000e{gNZ5h)\u0019\t\tPa\u0014\u0003R!9!1B\u0016A\u0002\t5\u0001b\u0002B*W\u0001\u0007!QK\u0001\u0007MV$XO]3\u0011\r\u0005E$q\u0005B,!\u0011\u0011iC!\u0017\n\t\tm#q\u0006\u0002\u0007\u0007>tg-[4\u0002-A\u0014xnY3tgNKhn\u0019+pa&\u001c7i\u001c8gS\u001e$b!!=\u0003b\t\r\u0004b\u0002B\u0006Y\u0001\u0007!Q\u0002\u0005\b\u0005Kb\u0003\u0019\u0001B,\u0003-!x\u000e]5d\u0007>tg-[4\u0002-!\fg\u000e\u001a7f\u00032$XM\u001d+pa&\u001c7i\u001c8gS\u001e$b!!=\u0003l\t5\u0004b\u0002B\u0006[\u0001\u0007!Q\u0002\u0005\b\u0005Ci\u0003\u0019\u0001B8!\u0011\u0011iC!\u001d\n\t\tM$q\u0006\u0002\u0013\u00032$XM]\"p]\u001aLwm\u001d*fgVdG/\u0001\u0006mSN$xI]8vaN$B!!=\u0003z!9!1\u0002\u0018A\u0002\t5\u0011\u0001\u00055b]\u0012dW\rT5ti\u001e\u0013x.\u001e9t)!\t\tPa \u0003\u0002\nm\u0005b\u0002B\u0006_\u0001\u0007!Q\u0002\u0005\b\u0005'z\u0003\u0019\u0001BB!\u0019\t\tHa\n\u0003\u0006B1!q\u0011BI\u0005+k!A!#\u000b\t\t-%QR\u0001\u0005kRLGN\u0003\u0002\u0003\u0010\u0006!!.\u0019<b\u0013\u0011\u0011\u0019J!#\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003.\t]\u0015\u0002\u0002BM\u0005_\u0011AcQ8ogVlWM]$s_V\u0004H*[:uS:<\u0007b\u0002BO_\u0001\u0007\u0011QE\u0001\u000fY>\u001c\u0017\r\\!e[&tWk]3e\u0003E\u0001(o\\2fgNd\u0015n\u001d;He>,\bo\u001d\u000b\u0007\u0003c\u0014\u0019K!*\t\u000f\t-\u0001\u00071\u0001\u0003\u000e!9!q\u0015\u0019A\u0002\t%\u0016AB4s_V\u00048\u000f\u0005\u0003V\u0003W\"\u0016\u0001\u00057jgR<%o\\;q\u001f\u001a47/\u001a;t)\u0019\t\tPa,\u00032\"9!1B\u0019A\u0002\t5\u0001b\u0002BTc\u0001\u0007!\u0011V\u0001\u0017Q\u0006tG\r\\3MSN$xI]8va>3gm]3ugRA\u0011\u0011\u001fB\\\u0005s\u0013\t\u000eC\u0004\u0003\fI\u0002\rA!\u0004\t\u000f\tm&\u00071\u0001\u0003>\u00069a-\u001e;ve\u0016\u001c\bCB+\u0002\u0006R\u0013y\f\u0005\u0004\u0002r\t\u001d\"\u0011\u0019\t\t\u0005\u000f\u0013\u0019-a\u001c\u0003F&!\u0011q\u0011BE!\u0011\u00119M!4\u000e\u0005\t%'\u0002\u0002Bf\u0005g\t\u0001bY8ogVlWM]\u0005\u0005\u0005\u001f\u0014IMA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006DqA!(3\u0001\u0004\t)#\u0001\fgS2$XM\u001d'jgR<%o\\;q\u001f\u001a47/\u001a;t)\u0019\u00119N!7\u0003^B9Q+!\"\u0002p\t\u0015\u0007B\u0002Bng\u0001\u0007A+A\u0003he>,\b\u000fC\u0004\u0003`N\u0002\rAa6\u0002\u000f=4gm]3ug\u0006\t\u0012\r\u001c;fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\r\u0005E(Q\u001dBt\u0011\u001d\u0011Y\u0001\u000ea\u0001\u0005\u001bAqA!;5\u0001\u0004\u0011Y/\u0001\u0007he>,\bo\u00144gg\u0016$8\u000f\u0005\u0004V\u0003\u000b#&q[\u0001\u0018Q\u0006tG\r\\3BYR,'o\u0012:pkB|eMZ:fiN$b!!=\u0003r\nM\bb\u0002B\u0006k\u0001\u0007!Q\u0002\u0005\b\u0005k,\u0004\u0019\u0001B|\u0003\u001d\u0011Xm];miN\u0004b!VAC)\ne\bCBA9\u0005O\u0011Y\u0010\u0005\u0003\u0003~\u000e\rQB\u0001B\u0000\u0015\u0011\u0019\tA!$\u0002\t1\fgnZ\u0005\u0005\u0007\u000b\u0011yP\u0001\u0003W_&$\u0017AG5t)>\u0004\u0018nY*uCR,\u0007+\u001a8eS:<7\u000b^8qa\u0016$\u0017aD:u_Bl\u0015N\u001d:peR{\u0007/[2\u0015\t\u0005E8Q\u0002\u0005\b\u0005\u00179\u0004\u0019\u0001B\u0007\u0003AA\u0017M\u001c3mKN#x\u000e]'jeJ|'\u000f\u0006\u0005\u0002r\u000eM1QCB\f\u0011\u001d\u0011Y\u0001\u000fa\u0001\u0005\u001bAqA!\t9\u0001\u0004\u0011I\u0010C\u0004\u0004\u001aa\u0002\raa\u0007\u00027A,g\u000eZ5oON#x\u000e\u001d9fIV\u0003H-\u0019;fIRKW.Z't!\u0011\t\u0019a!\b\n\u0007\r}!L\u0001\u0003M_:<\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BAy\u0007KAqAa\u0003:\u0001\u0004\u0011i\u0001\u0006\u0003\u00020\r%\u0002b\u0002B\u0011u\u0001\u000711\u0006\t\u0004\u0019\u000e5\u0012bAB\u0018%\n\u00192i\\7qY\u0016$X\r\u001a+bg.\u0014Vm];mi\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u0002R\u0006\u0019B/Y:l\u000bJ\u0014xN]\"pI\u0016\fe\u000eZ'tORA1\u0011HB \u0007\u0007\u001a)\u0005E\u0002N\u0007wI1a!\u0010D\u0005M!\u0016m]6FeJ|'oQ8eK\u0006sG-T:h\u0011\u0019\u0019\t\u0005\u0010a\u0001)\u0006aQM\u001d:Ng\u001e\u0004&/\u001a4jq\"9!Q\u0014\u001fA\u0002\u0005\u0015\u0002bBB$y\u0001\u00071\u0011J\u0001\u0003Kb\u0004Baa\u0013\u0004X9!1QJB*\u001d\u0011\t)ka\u0014\n\u0007\rE#,\u0001\u0006d_:\u001cWO\u001d:f]RLA!a+\u0004V)\u00191\u0011\u000b.\n\t\re31\f\u0002\u0013\u000bb,7-\u001e;j_:,\u0005pY3qi&|gN\u0003\u0003\u0002,\u000eU\u0013aF:va\u0016\u0014HE]3tG\",G-\u001e7f\t\u0016d\u0017-_'t+\t\t\t!A\u000bDYV\u001cH/\u001a:MS:\\7\u000b^8q\u001b&\u0014(o\u001c:\u0011\u00055{4cA \u0004hA!\u00111AB5\u0013\r\u0019YG\u0017\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r\r\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0004t)\"\u0011\u0011AB;W\t\u00199\b\u0005\u0003\u0004z\r\rUBAB>\u0015\u0011\u0019iha \u0002\u0013Ut7\r[3dW\u0016$'bABA5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001551\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkStopMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private boolean synchronize;
    private boolean updatedTopicConfig;
    private boolean updatedGroupOffsets;
    private boolean updatedReplicaStatus;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private scala.collection.immutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs;
    private Seq<GroupClusterLinkFilterInfo> groupFilters;
    private final ClusterLinkMetadataManager metadataManager;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkStopMirror$.MODULE$.$lessinit$greater$default$7();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean synchronize() {
        return this.synchronize;
    }

    private void synchronize_$eq(boolean x$1) {
        this.synchronize = x$1;
    }

    private boolean updatedTopicConfig() {
        return this.updatedTopicConfig;
    }

    private void updatedTopicConfig_$eq(boolean x$1) {
        this.updatedTopicConfig = x$1;
    }

    private boolean updatedGroupOffsets() {
        return this.updatedGroupOffsets;
    }

    private void updatedGroupOffsets_$eq(boolean x$1) {
        this.updatedGroupOffsets = x$1;
    }

    private boolean updatedReplicaStatus() {
        return this.updatedReplicaStatus;
    }

    private void updatedReplicaStatus_$eq(boolean x$1) {
        this.updatedReplicaStatus = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs() {
        return this.partitionLogEndOffsetAndEpochs;
    }

    private void partitionLogEndOffsetAndEpochs_$eq(scala.collection.immutable.Map<TopicPartition, OffsetAndEpoch> x$1) {
        this.partitionLogEndOffsetAndEpochs = x$1;
    }

    private Seq<GroupClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(Seq<GroupClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Cannot stop mirror topic for deleted topic '" + $this.topic + "'. Shutting down stop mirror topic task.");
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        boolean bl = false;
        Some some = null;
        Option option = mirrorState;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (state instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)state;
                this.synchronize_$eq(pendingStoppedMirror.synchronize());
                this.info((Function0<String> & Serializable)() -> "Attempting to stop mirror topic " + $this.topic + " with synchronize=" + this.synchronize());
                if (this.updatedReplicaStatus()) {
                    return this.transition(taskContext);
                }
                return this.processTopic(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See mirror '" + state + "' for mirror topic '" + $this.topic + "', not performing stop mirror topic task");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror state for mirror topic '" + $this.topic + "', not performing stop mirror topic task");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    public ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.synchronize() && !this.updatedTopicConfig()) {
            return this.syncTopicConfig(taskContext);
        }
        if (!this.updatedGroupOffsets() && this.clientManager.currentConfig().consumerOffsetSyncEnable()) {
            return this.listGroups(taskContext);
        }
        return this.stopMirrorTopic(taskContext);
    }

    private ClusterLinkScheduler.TaskResult processTopic(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Invoking replica status on mirror topic " + $this.topic);
        ReplicaStatusResult result = this.localAdmin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleReplicaStatus((ClusterLinkScheduler.TaskContext)tc, CollectionConverters$.MODULE$.MapHasAsScala(result.partitionResults()).asScala().toMap($less$colon$less$.MODULE$.refl())), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<TopicPartition, KafkaFuture<PartitionResult>> result) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree1$1(result);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option resOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(resOpt, errOpt2);
        Option resOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.processReplicaStatus(taskContext, (scala.collection.immutable.Map)resOpt2.get());
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult processReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<TopicPartition, PartitionResult> result) {
        this.partitionLogEndOffsetAndEpochs_$eq((scala.collection.immutable.Map)result.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition part = (TopicPartition)tuple2._1();
                PartitionResult partResult = (PartitionResult)tuple2._2();
                Buffer rsList = CollectionConverters$.MODULE$.ListHasAsScala(partResult.replicas()).asScala();
                ReplicaStatus leader = (ReplicaStatus)((IterableOps)rsList.filter((Function1<ReplicaStatus, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isLeader()))).head();
                int leaderEpoch = partResult.leaderEpoch().orElse(-1);
                Option<Object> mirrorInfo = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null));
                if (mirrorInfo.exists((Function1<Object, Object>)(Function1<ReplicaStatus.MirrorInfo, Object> & Serializable)info -> BoxesRunTime.boxToBoolean(ClusterLinkStopMirror.$anonfun$processReplicaStatus$5(this, info))) && this.allIsrsCaughtup$1(rsList, leader) && leaderEpoch >= 0) {
                    return new Some<Tuple2<TopicPartition, OffsetAndEpoch>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(part), new OffsetAndEpoch(leader.logEndOffset(), leaderEpoch)));
                }
                return None$.MODULE$;
            }
            throw new MatchError(tuple2);
        }));
        if (this.partitionLogEndOffsetAndEpochs().size() == result.size()) {
            this.updatedReplicaStatus_$eq(true);
            this.info((Function0<String> & Serializable)() -> "Partitions from topic " + $this.topic + " are synced with their leader log end offset and epoch");
            return this.transition(taskContext);
        }
        this.info((Function0<String> & Serializable)() -> "Not all mirror partitions are ready to be stopped for mirror topic '" + $this.topic + "', awaiting state change. Will retry in " + this.super$rescheduleDelayMs() + " ms");
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult syncTopicConfig(ClusterLinkScheduler.TaskContext taskContext) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic);
        this.info((Function0<String> & Serializable)() -> "Syncing topic configs for mirror topic " + $this.topic);
        DescribeConfigsResult result = this.remoteAdmin.describeConfigs(Collections.singleton(resource));
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleSyncTopicConfig((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Config>)((KafkaFuture)result.values().get(resource))), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleSyncTopicConfig(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Config> future) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree2$1(future);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option configOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(configOpt, errOpt2);
        Option configOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.processSyncTopicConfig(taskContext, (Config)configOpt2.get());
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult processSyncTopicConfig(ClusterLinkScheduler.TaskContext taskContext, Config topicConfig) {
        Option policyErrOpt;
        Properties curProps = this.metadataManager().getTopicConfig(this.topic);
        MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate = new MirrorTopicConfigsDelegate(curProps, topicConfig, this.clientManager.topicConfigSyncRules());
        Tuple2 tuple2 = this.liftedTree3$1(mirrorTopicConfigsDelegate);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option newPropsOpt = (Option)tuple2._1();
        Option policyErrOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(newPropsOpt, policyErrOpt2);
        Option newPropsOpt2 = tuple22._1();
        Option option = policyErrOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg policyErr = (TaskErrorCodeAndMsg)some.value();
            return this.transition(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)policyErr), Nil$.MODULE$))));
        }
        if (None$.MODULE$.equals(option)) {
            Properties newProps;
            Properties properties = newProps = (Properties)newPropsOpt2.get();
            Properties properties2 = curProps;
            if (properties == null ? properties2 != null : !((Object)properties).equals(properties2)) {
                if (!this.isTopicStatePendingStopped()) {
                    this.warn((Function0<String> & Serializable)() -> "Detected stopped topic '" + $this.topic + "' unexpectedly right before topic config was going to be changed. Shutting down stop mirror topic task.");
                    return this.onCompletion(taskContext);
                }
                scala.collection.immutable.Map newTopicConfigs = CollectionConverters$.MODULE$.PropertiesHasAsScala(newProps).asScala().toSet().diff(CollectionConverters$.MODULE$.PropertiesHasAsScala(curProps).asScala().toSet()).toMap($less$colon$less$.MODULE$.refl());
                this.trace((Function0<String> & Serializable)() -> "Adding configs " + newTopicConfigs + " for topic " + $this.topic + " on target cluster");
                HashSet newConfigs = new HashSet();
                newTopicConfigs.foreach((Function1<Tuple2, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                this.debug((Function0<String> & Serializable)() -> "Updating topic config for mirror topic " + $this.topic + " with " + newConfigs.size() + " entries");
                AlterConfigsResult result = this.localAdmin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, this.topic), newConfigs));
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterTopicConfig((ClusterLinkScheduler.TaskContext)tc, result), taskContext));
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            this.updatedTopicConfig_$eq(true);
            return this.transition(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult handleAlterTopicConfig(ClusterLinkScheduler.TaskContext taskContext, AlterConfigsResult result) {
        Set errs = (Set)CollectionConverters$.MODULE$.SetHasAsScala(result.values().entrySet()).asScala().flatMap((Function1<Map.Entry, Option> & Serializable)entry -> {
            Option option;
            block3: {
                String topic = ((ConfigResource)entry.getKey()).name();
                try {
                    ((KafkaFuture)entry.getValue()).get();
                    this.trace((Function0<String> & Serializable)() -> "Successfully updated configuration for mirror topic " + topic);
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    if (this.synchronize()) {
                        this.debug((Function0<String> & Serializable)() -> "Encountered error during promote, will retry in " + this.super$rescheduleDelayMs(), (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                        option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to alter the topic config", true, e));
                        break block3;
                    }
                    this.warn((Function0<String> & Serializable)() -> "Error encountered while altering configuration on mirror topic " + topic + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    option = None$.MODULE$;
                }
            }
            return option;
        });
        if (errs.isEmpty()) {
            this.updatedTopicConfig_$eq(true);
            return this.transition(taskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs.toSeq()));
    }

    private ClusterLinkScheduler.TaskResult listGroups(ClusterLinkScheduler.TaskContext taskContext) {
        Tuple2<ListConsumerGroupsResult, Boolean> tuple2;
        None$ clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.clientManager.currentConfig().clusterLinkPrefixConsumerGroupEnable()) ? this.clientManager.currentConfig().clusterLinkPrefix() : None$.MODULE$;
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkGroupFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix(), clusterLinkPrefix, this.clientManager.currentConfig().linkMode()));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Found empty group filters, no consumer group offsets to sync.");
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        this.info((Function0<String> & Serializable)() -> "Syncing consumer group offsets for mirror topic " + $this.topic);
        Tuple2<ListConsumerGroupsResult, Boolean> tuple22 = tuple2 = this.synchronize() ? new Tuple2<ListConsumerGroupsResult, Boolean>(this.remoteAdmin.listConsumerGroups(), BoxesRunTime.boxToBoolean(false)) : new Tuple2<ListConsumerGroupsResult, Boolean>(this.localAdmin.listConsumerGroups(), BoxesRunTime.boxToBoolean(true));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListConsumerGroupsResult result = tuple2._1();
        boolean localAdminUsed = tuple2._2$mcZ$sp();
        Tuple2<ListConsumerGroupsResult, Boolean> tuple23 = new Tuple2<ListConsumerGroupsResult, Boolean>(result, BoxesRunTime.boxToBoolean(localAdminUsed));
        ListConsumerGroupsResult result2 = tuple23._1();
        boolean localAdminUsed2 = tuple23._2$mcZ$sp();
        this.scheduleWhenComplete(result2.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroups((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ConsumerGroupListing>>)result2.all(), localAdminUsed2), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroups(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ConsumerGroupListing>> future, boolean localAdminUsed) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree4$1(future, localAdminUsed);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option resultOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(resultOpt, errOpt2);
        Option resultOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            if (!this.synchronize()) {
                this.warn((Function0<String> & Serializable)() -> "Unable to process list consumer groups request. Skipping over syncing consumer group offsets for mirror topic " + $this.topic);
                this.updatedGroupOffsets_$eq(true);
                return this.transition(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$))));
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.processListGroups(taskContext, ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resultOpt2.get()).asScala().map((Function1<ConsumerGroupListing, String> & Serializable)x$12 -> x$12.groupId())).toSet());
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult processListGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)((IterableOps)ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.groupFilters())._1()).map((Function1<MatchedGroup, String> & Serializable)x$13 -> x$13.name());
        if (matchedGroups.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        return this.listGroupOffsets(taskContext, matchedGroups);
    }

    private ClusterLinkScheduler.TaskResult listGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        Tuple2<ClusterLinkBatchAdmin, Boolean> tuple2;
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions().toList()).asJava());
        Tuple2<ClusterLinkBatchAdmin, Boolean> tuple22 = tuple2 = this.synchronize() ? new Tuple2<ClusterLinkBatchAdmin, Boolean>(this.remoteAdmin, BoxesRunTime.boxToBoolean(false)) : new Tuple2<ClusterLinkBatchAdmin, Boolean>(this.localAdmin, BoxesRunTime.boxToBoolean(true));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ClusterLinkBatchAdmin admin = tuple2._1();
        boolean localAdminUsed = tuple2._2$mcZ$sp();
        Tuple2<ClusterLinkBatchAdmin, Boolean> tuple23 = new Tuple2<ClusterLinkBatchAdmin, Boolean>(admin, BoxesRunTime.boxToBoolean(localAdminUsed));
        ClusterLinkBatchAdmin admin2 = tuple23._1();
        boolean localAdminUsed2 = tuple23._2$mcZ$sp();
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groups.foreach((Function1<String, Object> & Serializable)group -> {
            ClusterLinkStopMirror.$anonfun$listGroupOffsets$1(admin2, spec, futures, group);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$1.elem, localAdminUsed2), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures, boolean localAdminUsed) {
        ClusterLinkScheduler.TaskContext newTaskContext;
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)futures.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    Map result = (Map)future.get();
                    object = this.filterListGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap($less$colon$less$.MODULE$.refl()));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle list consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    unSyncedGroups.put(group, this.taskErrorCodeAndMsg("Failed to list group offsets for " + group, localAdminUsed, e));
                    object = Predef$.MODULE$.Map().empty();
                }
                scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> res = object;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), res);
            }
            throw new MatchError(tuple2);
        }).filterNot((Function1<Tuple2, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(ClusterLinkStopMirror.$anonfun$handleListGroupOffsets$4(x$15)));
        if (unSyncedGroups.nonEmpty() && this.synchronize()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets " + unSyncedGroups.keySet().mkString(",") + " when handling the list consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        }
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets when handling the list consumer group offset request. These consumer groups will be skipped: " + unSyncedGroups.keySet().mkString(","));
            v0 = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        } else {
            v0 = newTaskContext = taskContext;
        }
        if (groupOffsets.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(newTaskContext);
        }
        if (!this.isTopicStatePendingStopped()) {
            this.warn((Function0<String> & Serializable)() -> "Detected stopped topic '" + $this.topic + "' unexpectedly right before group offsets were going to be altered. Shutting down stop mirror topic task.");
            return this.onCompletion(newTaskContext);
        }
        return this.alterGroupOffsets(newTaskContext, groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetAndMetadata offsetMeta = (OffsetAndMetadata)tuple2._2();
                Option option = this.partitionLogEndOffsetAndEpochs().get(partition).map((Function1<OffsetAndEpoch, Object> & Serializable)x$16 -> BoxesRunTime.boxToLong(x$16.offset()));
                if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    long logEndOffset = BoxesRunTime.unboxToLong(some.value());
                    if (offsetMeta == null) {
                        option2 = None$.MODULE$;
                    } else if (logEndOffset < offsetMeta.offset()) {
                        this.info((Function0<String> & Serializable)() -> "Rolling back offset for group '" + group + "' and topic '" + $this.topic + "' from '" + offsetMeta.offset() + " to '" + logEndOffset + "'");
                        option2 = new Some<Long>(BoxesRunTime.boxToLong(logEndOffset));
                    } else {
                        option2 = this.synchronize() ? new Some<Long>(BoxesRunTime.boxToLong(offsetMeta.offset())) : None$.MODULE$;
                    }
                    None$ offset = option2;
                    return offset.map((Function1<Object, Tuple2> & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), new OffsetAndMetadata(BoxesRunTime.unboxToLong(off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                }
                if (None$.MODULE$.equals(option)) {
                    this.error((Function0<String> & Serializable)() -> "Unexpected partition '" + partition + "', skipping");
                    return None$.MODULE$;
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        });
    }

    private ClusterLinkScheduler.TaskResult alterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groupOffsets.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ClusterLinkStopMirror.$anonfun$alterGroupOffsets$1(this, futures, x0$1);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$2.elem), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleAlterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<TaskErrorCodeAndMsg> option;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    option = future.get();
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle alter consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    option = unSyncedGroups.put(group, this.taskErrorCodeAndMsg("Failed to alter consumer offsets for group " + group, true, e));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets when handling the alter consumer group offset request. These consumer groups will be skipped: " + unSyncedGroups.keySet().mkString(","));
                this.updatedGroupOffsets_$eq(true);
                return this.transition(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values())));
            }
            this.debug((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' " + unSyncedGroups.keySet().mkString(",") + " offsets when handling the alter consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values()));
        }
        this.updatedGroupOffsets_$eq(true);
        return this.transition(new ClusterLinkScheduler.TaskContext(taskContext.errs()));
    }

    private boolean isTopicStatePendingStopped() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic).exists((Function1<ClusterLinkTopicState, Object> & Serializable)x$17 -> BoxesRunTime.boxToBoolean(ClusterLinkStopMirror.$anonfun$isTopicStatePendingStopped$1(x$17)));
    }

    private ClusterLinkScheduler.TaskResult stopMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        scala.collection.immutable.Set<TopicPartition> topicPartitions = this.metadataManager().topicPartitions(this.topic);
        if (topicPartitions.size() != this.partitions().size()) {
            this.warn((Function0<String> & Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset sync.");
            this.updatedGroupOffsets_$eq(false);
            return this.transition(taskContext);
        }
        boolean bl = false;
        Some some = null;
        Option option = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState currentState = (ClusterLinkTopicState)some.value();
            if (currentState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)currentState;
                this.info((Function0<String> & Serializable)() -> "Setting the mirror topic " + $this.topic + " state from " + pendingStoppedMirror.state().name() + " to STOPPED");
                Object logEndOffsetAndEpochs = ((List)this.partitionLogEndOffsetAndEpochs().toList().sortBy((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToInteger(ClusterLinkStopMirror.$anonfun$stopMirrorTopic$3(x0$1)), (Ordering)Ordering.Int$.MODULE$)).map((Function1<Tuple2, OffsetAndEpoch> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        OffsetAndEpoch offset = (OffsetAndEpoch)tuple2._2();
                        return offset;
                    }
                    throw new MatchError(tuple2);
                });
                AlterMirrorsResult result = this.localAdmin.stopMirror(this.topic, (Seq<OffsetAndEpoch>)logEndOffsetAndEpochs, pendingStoppedMirror.stoppedSequenceNumber() + 1L);
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleStopMirror((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Void>)result.all(), pendingStoppedMirror.timeMs()), taskContext));
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See cluster link state '" + state + "' for mirror topic '" + $this.topic + "', not performing stop mirror topic task");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No cluster link state for mirror topic '" + $this.topic + "', not performing stop mirror topic task");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult handleStopMirror(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Void> result, long pendingStoppedUpdatedTimeMs) {
        None$ errOpt;
        Option option;
        try {
            result.get();
            option = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            String errorString = "Failed to update the stopped state for mirror topic " + this.topic + ". Retrying the task to stop the mirror";
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, errorString);
            this.warn((Function0<String> & Serializable)() -> errorString, (Function0<Throwable>)(Function0<ApiException> & Serializable)() -> e);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to update the mirror topic " + this.topic + " state to stopped", true, ex));
        }
        None$ none$ = errOpt = option;
        if (none$ instanceof Some) {
            Some some = (Some)((Object)none$);
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(none$)) {
            long timeToStopMirrorTopicMs = Time.SYSTEM.milliseconds() - pendingStoppedUpdatedTimeMs;
            if (this.synchronize()) {
                this.clientManager.metrics().timeToStopMirrorTopicPromoteSensor().record((double)timeToStopMirrorTopicMs);
            } else {
                this.clientManager.metrics().timeToStopMirrorTopicFailoverSensor().record((double)timeToStopMirrorTopicMs);
            }
            this.info((Function0<String> & Serializable)() -> "Mirror topic " + $this.topic + " took " + timeToStopMirrorTopicMs + " ms to transition to STOPPED state with synchronize=" + this.synchronize() + ".");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(none$);
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Shutting down stop mirror topic task for " + $this.topic + ".");
        this.shutdown();
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkStopMirrorTopicTaskType$.MODULE$, true, "stop the mirror"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof UnknownTopicOrPartitionException && !localAdminUsed) {
            return new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsgPrefix + " due to unknown topic or partition.");
        }
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(scala.collection.immutable.Map result$2) {
        Tuple2<Some<scala.collection.immutable.Map>, None$> tuple2;
        try {
            scala.collection.immutable.Map res = (scala.collection.immutable.Map)result$2.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    KafkaFuture future = (KafkaFuture)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), future.get());
                }
                throw new MatchError(tuple2);
            });
            tuple2 = new Tuple2<Some<scala.collection.immutable.Map>, None$>(new Some<scala.collection.immutable.Map>(res), None$.MODULE$);
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, "Encountered exception when trying to handle replica status for mirror topic " + this.topic + ".");
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to get the replicas statuses", true, e)));
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$4(ReplicaStatus leader$1, ReplicaStatus x$7) {
        return x$7.logEndOffset() == leader$1.logEndOffset();
    }

    private final boolean allIsrsCaughtup$1(Buffer rsList$1, ReplicaStatus leader$1) {
        return ((IterableOnceOps)rsList$1.filter((Function1<ReplicaStatus, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isInIsr()))).forall((Function1<ReplicaStatus, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ClusterLinkStopMirror.$anonfun$processReplicaStatus$4(leader$1, x$7))) || Predef$.MODULE$.Boolean2boolean(this.clientManager.brokerConfig().clusterLinkK1ToK2MigrationEnable());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$5(ClusterLinkStopMirror $this, ReplicaStatus.MirrorInfo info) {
        ReplicaStatus.MirrorInfo.State state = info.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        if (state == null) {
            if (state2 == null) return true;
        } else if (state.equals(state2)) return true;
        if ($this.synchronize()) return false;
        ReplicaStatus.MirrorInfo.State state3 = info.state();
        ReplicaStatus.MirrorInfo.State state4 = ReplicaStatus.MirrorInfo.State.LINK_FAILED;
        if (state3 != null) {
            if (!state3.equals(state4)) return false;
            return true;
        }
        if (state4 == null) return true;
        return false;
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            Config config = (Config)future$1.get();
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>((None$)((Object)new Some<Config>(config)), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, "Encountered exception when trying to process topic configs for mirror topic " + this.topic + ".");
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to describe topic configs", false, e)));
        }
        return tuple2;
    }

    private final /* synthetic */ Tuple2 liftedTree3$1(MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate$1) {
        Tuple2<Some<Properties>, None$> tuple2;
        try {
            Properties props = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(this.topic, mirrorTopicConfigsDelegate$1.updateMirrorProps(this.topic), this.clientManager.alterConfigPolicy());
            tuple2 = new Tuple2<Some<Properties>, None$>(new Some<Properties>(props), None$.MODULE$);
        }
        catch (PolicyViolationException e) {
            String errMsg = "Encountered policy violation when finalizing topic configuration for '" + this.topic + "', skipping topic config update";
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<PolicyViolationException> & Serializable)() -> e);
            this.updatedTopicConfig_$eq(true);
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
        }
        return tuple2;
    }

    private final /* synthetic */ Tuple2 liftedTree4$1(KafkaFuture future$2, boolean localAdminUsed$2) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            Collection result = (Collection)future$2.get();
            tuple2 = new Tuple2<Some<Collection>, None$>(new Some<Collection>(result), None$.MODULE$);
        }
        catch (ExecutionException e) {
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to list the consumer groups", localAdminUsed$2, e)));
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$1(ClusterLinkBatchAdmin admin$1, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, String group) {
        ListConsumerGroupOffsetsResult result = admin$1.listConsumerGroupOffsets(Collections.singletonMap(group, spec$1));
        futures$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.partitionsToOffsetAndMetadata()));
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$15) {
        return ((IterableOnceOps)x$15._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$1(ClusterLinkStopMirror $this, ObjectRef futures$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String group = (String)tuple2._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)tuple2._2();
            AlterConsumerGroupOffsetsResult result = $this.localAdmin.alterConsumerGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsJava(offsets).asJava());
            futures$2.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.all()));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isTopicStatePendingStopped$1(ClusterLinkTopicState x$17) {
        TopicLinkState topicLinkState = x$17.state();
        TopicLinkPendingStoppedMirror$ topicLinkPendingStoppedMirror$ = TopicLinkPendingStoppedMirror$.MODULE$;
        return !(topicLinkState != null ? !topicLinkState.equals(topicLinkPendingStoppedMirror$) : topicLinkPendingStoppedMirror$ != null);
    }

    public static final /* synthetic */ int $anonfun$stopMirrorTopic$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            return tp.partition();
        }
        throw new MatchError(tuple2);
    }

    public ClusterLinkStopMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkStopMirror-topic-" + topic, intervalMs, time, quota);
        this.synchronize = true;
        this.updatedTopicConfig = false;
        this.updatedGroupOffsets = false;
        this.updatedReplicaStatus = false;
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.metadataManager = clientManager.metadataManager();
        this.taskDesc = None$.MODULE$;
    }
}

