/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSwitchoverStateTransition$;
import kafka.server.link.ClusterLinkSwitchoverStateTransitionTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.FailedToUpdateMetadataErrorCode$;
import kafka.server.link.FailoverTimeoutErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnexpectedMirrorStateErrorCode$;
import kafka.server.link.UnexpectedSwitchoverStateErrorCode$;
import org.apache.kafka.clients.admin.AlterClusterLinkOp;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.TruncateAndRestoreResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;
import org.apache.kafka.metadata.MirrorTopicSwitchoverMetadata;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r-b\u0001\u0002\u001d:\u0001\u0001C\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0013u\u0003!\u0011!Q\u0001\ny[\u0007\"\u00037\u0001\u0005\u0003\u0005\u000b\u0011B7r\u0011%\u0011\bA!A!\u0002\u0013\u0019\u0018\u0010C\u0003|\u0001\u0011\u0005A\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\u0010!I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003\u000b\u0002\u0001\u0019!C\u0005\u0003\u000fB\u0001\"a\u0013\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003\u001b\u0002\u0001\u0019!C\u0005\u0003OA\u0011\"a\u0014\u0001\u0001\u0004%I!!\u0015\t\u0011\u0005U\u0003\u0001)Q\u0005\u0003SA\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005\r\u0004\u0001)A\u0005\u00037B\u0011\"!\u001a\u0001\u0001\u0004%I!a\u001a\t\u0013\u0005e\u0004\u00011A\u0005\n\u0005m\u0004\u0002CA@\u0001\u0001\u0006K!!\u001b\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0005\"CAF\u0001\u0001\u0007I\u0011BAG\u0011!\t\t\n\u0001Q!\n\u0005\u0015\u0005\"CAJ\u0001\u0001\u0007I\u0011BAK\u0011%\ti\n\u0001a\u0001\n\u0013\ty\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0015BAL\u0011%\t)\u000b\u0001b\u0001\n\u001b\t9\u000b\u0003\u0005\u0002.\u0002\u0001\u000bQBAU\u0011%\ty\u000b\u0001a\u0001\n\u0013\t\t\fC\u0005\u0002@\u0002\u0001\r\u0011\"\u0003\u0002B\"A\u0011Q\u0019\u0001!B\u0013\t\u0019\fC\u0004\u0002P\u0002!\t&!5\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u0011Q\u001f\u0001\u0005\n\u0005]\b\"\u0003B\u0019\u0001E\u0005I\u0011\u0002B\u001a\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017B\u0011B!\u001b\u0001#\u0003%IAa\r\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BT\u0001\u0011%!\u0011\u0016\u0005\b\u0005s\u0003A\u0011\u0002B^\u0011\u001d\u0011y\f\u0001C\u0005\u0005\u0003D\u0011B!7\u0001#\u0003%IAa\r\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0003\u0001\u0011\u00053q\u0001\u0005\b\u0007\u0013\u0001A\u0011KB\u0006\u000f%\u00199\"OA\u0001\u0012\u0003\u0019IB\u0002\u00059s\u0005\u0005\t\u0012AB\u000e\u0011\u0019YX\u0007\"\u0001\u0004$!I1QE\u001b\u0012\u0002\u0013\u00051q\u0005\u0002%\u00072,8\u000f^3s\u0019&t7nU<ji\u000eDwN^3s'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]*\u0011!hO\u0001\u0005Y&t7N\u0003\u0002={\u000511/\u001a:wKJT\u0011AP\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\t\u0005\u0002C\r:\u00111\tR\u0007\u0002s%\u0011Q)O\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005\u001dC%\u0001\u0004)fe&|G-[2UCN\\'BA#:\u00035\u0019G.[3oi6\u000bg.Y4feV\t1\n\u0005\u0002D\u0019&\u0011Q*\u000f\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u00039\u0019G.[3oi6\u000bg.Y4fe\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002#B\u00111IU\u0005\u0003'f\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u00111Lgn\u001b#bi\u0006\u0004\"aQ,\n\u0005aK$aD\"mkN$XM\u001d'j].$\u0015\r^1\u0002\u00151|7-\u00197BI6Lg\u000e\u0005\u0002D7&\u0011A,\u000f\u0002\u0016\u00072,8\u000f^3s\u0019&t7NQ1uG\"\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005}KW\"\u00011\u000b\u0005\u0005\u0014\u0017!B;uS2\u001c(BA2e\u0003\u0019\u0019w.\\7p]*\u0011a(\u001a\u0006\u0003M\u001e\fa!\u00199bG\",'\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kA\n!A+[7f\u0013\tif)A\u0003rk>$\u0018\r\u0005\u0002o_6\t1(\u0003\u0002qw\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003Y\u001a\u000b!\"\u001b8uKJ4\u0018\r\\'t!\t!x/D\u0001v\u0015\u00051\u0018!B:dC2\f\u0017B\u0001=v\u0005\rIe\u000e^\u0005\u0003u\u001a\u000b\u0011C]3tG\",G-\u001e7f\t\u0016d\u0017-_'t\u0003\u0019a\u0014N\\5u}QiQP`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\u0001\"a\u0011\u0001\t\u000b%S\u0001\u0019A&\t\u000b=S\u0001\u0019A)\t\u000bUS\u0001\u0019\u0001,\t\u000beS\u0001\u0019\u0001.\t\u000buS\u0001\u0019\u00010\t\u000b1T\u0001\u0019A7\t\u000fIT\u0001\u0013!a\u0001g\u0006!Am\u001c8f+\t\ty\u0001E\u0002u\u0003#I1!a\u0005v\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z8oK~#S-\u001d\u000b\u0005\u00033\ty\u0002E\u0002u\u00037I1!!\bv\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005B\"!AA\u0002\u0005=\u0011a\u0001=%c\u0005)Am\u001c8fA\u0005yQO\\1mi\u0016\u0014X\r\u001a+pa&\u001c7/\u0006\u0002\u0002*A1\u00111FA\u001d\u0003\u007fqA!!\f\u00026A\u0019\u0011qF;\u000e\u0005\u0005E\"bAA\u001a\u007f\u00051AH]8pizJ1!a\u000ev\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\r\u0019V\r\u001e\u0006\u0004\u0003o)\b\u0003BA\u0016\u0003\u0003JA!a\u0011\u0002>\t11\u000b\u001e:j]\u001e\f1#\u001e8bYR,'/\u001a3U_BL7m]0%KF$B!!\u0007\u0002J!I\u0011\u0011E\b\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0011k:\fG\u000e^3sK\u0012$v\u000e]5dg\u0002\na#Y2uSZ,7k^5uG\"|g/\u001a:U_BL7m]\u0001\u001bC\u000e$\u0018N^3To&$8\r[8wKJ$v\u000e]5dg~#S-\u001d\u000b\u0005\u00033\t\u0019\u0006C\u0005\u0002\"I\t\t\u00111\u0001\u0002*\u00059\u0012m\u0019;jm\u0016\u001cv/\u001b;dQ>4XM\u001d+pa&\u001c7\u000fI\u0001\u0007Y&t7.\u00133\u0016\u0005\u0005m\u0003\u0003BA/\u0003?j\u0011AY\u0005\u0004\u0003C\u0012'\u0001B+vS\u0012\fq\u0001\\5oW&#\u0007%\u0001\bto&$8\r[8wKJ$\u0016\u0010]3\u0016\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u001e\u00072,8\u000f^3s\u0019&t7nU<ji\u000eDwN^3s\u001b\u0016$\u0018\rZ1uC*\u0019\u00111\u000f3\u0002\u00115,G/\u00193bi\u0006LA!a\u001e\u0002n\tq1k^5uG\"|g/\u001a:UsB,\u0017AE:xSR\u001c\u0007n\u001c<feRK\b/Z0%KF$B!!\u0007\u0002~!I\u0011\u0011E\f\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u0010g^LGo\u00195pm\u0016\u0014H+\u001f9fA\u0005y1o^5uG\"|g/\u001a:Ti\u0006$X-\u0006\u0002\u0002\u0006B!\u00111NAD\u0013\u0011\tI)!\u001c\u0003\u001fM;\u0018\u000e^2i_Z,'o\u0015;bi\u0016\f1c]<ji\u000eDwN^3s'R\fG/Z0%KF$B!!\u0007\u0002\u0010\"I\u0011\u0011\u0005\u000e\u0002\u0002\u0003\u0007\u0011QQ\u0001\u0011g^LGo\u00195pm\u0016\u00148\u000b^1uK\u0002\n1c]<ji\u000eDwN^3s)&lWm\u001d;b[B,\"!a&\u0011\u0007Q\fI*C\u0002\u0002\u001cV\u0014A\u0001T8oO\u000692o^5uG\"|g/\u001a:US6,7\u000f^1na~#S-\u001d\u000b\u0005\u00033\t\t\u000bC\u0005\u0002\"u\t\t\u00111\u0001\u0002\u0018\u0006!2o^5uG\"|g/\u001a:US6,7\u000f^1na\u0002\nqBZ1jY>4XM\u001d+j[\u0016|W\u000f^\u000b\u0003\u0003S{!!a+\u001e\u0007\u0011\u0019\n=\u0001\tgC&dwN^3s)&lWm\\;uA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u00024B)A/!.\u0002:&\u0019\u0011qW;\u0003\r=\u0003H/[8o!\r\u0019\u00151X\u0005\u0004\u0003{K$a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005e\u00111\u0019\u0005\n\u0003C\u0011\u0013\u0011!a\u0001\u0003g\u000b\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007\r\nI\rE\u0002u\u0003\u0017L1!!4v\u0005!1x\u000e\\1uS2,\u0017a\u0001:v]R\u0011\u00111\u001b\t\u0005\u0003+\f\u0019OD\u0002\u0002X\u0012sA!!7\u0002b:!\u00111\\Ap\u001d\u0011\ty#!8\n\u0003yJ!\u0001P\u001f\n\u0005iZ\u0014bAAs\u0011\nQA+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\u0003\u0002T\u0006-\bbBAwK\u0001\u0007\u0011q^\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002V\u0006E\u0018bAAz\u0011\nYA+Y:l\u0007>tG/\u001a=u\u0003q1XM]5gs2Kgn[*xSR\u001c\u0007n\u001c<feB\u0013xn\u001a:fgN$\"\"a5\u0002z\u0006m(q\u0003B\u0017\u0011\u001d\tiO\na\u0001\u0003_Dq!!@'\u0001\u0004\ty0A\u0007d_6\u0004H.\u001a;f'R\fG/\u001a\t\u0005\u0005\u0003\u0011\tB\u0004\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0007\t-A-A\u0004dY&,g\u000e^:\n\t\t=!QA\u0001\u0017\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]&!!1\u0003B\u000b\u0005\u0015\u0019F/\u0019;f\u0015\u0011\u0011yA!\u0002\t\u000f\tea\u00051\u0001\u0003\u001c\u0005\u0011\u0012N\u001c;fe6,G-[1uKN#\u0018\r^3t!\u0019\u0011iBa\n\u0002\u0000:!!q\u0004B\u0012\u001d\u0011\tyC!\t\n\u0003YL1A!\nv\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u000b\u0003,\t\u00191+Z9\u000b\u0007\t\u0015R\u000fC\u0005\u00030\u0019\u0002\n\u00111\u0001\u0002\u0010\u0005\u0019\u0012\r\u001c7po:{g.T5se>\u00148\u000b^1uK\u00061c/\u001a:jMfd\u0015N\\6To&$8\r[8wKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tU\"\u0006BA\b\u0005oY#A!\u000f\u0011\t\tm\"QI\u0007\u0003\u0005{QAAa\u0010\u0003B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0007*\u0018AC1o]>$\u0018\r^5p]&!!q\tB\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\"m\u0016\u0014\u0018NZ=NSJ\u0014xN]*uCR,\u0017I\u001c3D_6\u0004H.\u001a;f)>\u0004\u0018n\u0019\u000b\r\u0005\u001b\u0012YFa\u0018\u0003b\t\r$Q\r\t\u0006i\u0006U&q\n\t\bi\nE\u0013q\bB+\u0013\r\u0011\u0019&\u001e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\r\u00139&C\u0002\u0003Ze\u00121\u0003V1tW\u0016\u0013(o\u001c:D_\u0012,\u0017I\u001c3Ng\u001eDqA!\u0018)\u0001\u0004\ty$A\u0003u_BL7\rC\u0004\u0002~\"\u0002\r!a@\t\u000f\te\u0001\u00061\u0001\u0003\u001c!9!q\u0006\u0015A\u0002\u0005=\u0001\"\u0003B4QA\u0005\t\u0019AA\b\u0003)1XM]5gs>sG._\u0001,m\u0016\u0014\u0018NZ=NSJ\u0014xN]*uCR,\u0017I\u001c3D_6\u0004H.\u001a;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%k\u0005Q2/\u001a8e'^LGo\u00195pm\u0016\u0014\u0018\t\u001c;fe6K'O]8sgR1\u00111\u001bB8\u0005cBq!!<+\u0001\u0004\ty\u000fC\u0004\u0003t)\u0002\rA!\u001e\u0002\u0005=\u0004\b\u0003\u0002B\u0002\u0005oJAA!\u001f\u0003\u0006\ti\u0011\t\u001c;fe6K'O]8s\u001fB\f!\u0005[1oI2,7k^5uG\"|g/\u001a:BYR,'/T5se>\u00148OU3tk2$HCBAj\u0005\u007f\u0012\t\tC\u0004\u0002n.\u0002\r!a<\t\u000f\t\r5\u00061\u0001\u0003\u0006\u0006aAo\u001c9jGJ+7/\u001e7ugBA!q\u0011BI\u0003\u007f\u0011)*\u0004\u0002\u0003\n*!!1\u0012BG\u0003\u0011)H/\u001b7\u000b\u0005\t=\u0015\u0001\u00026bm\u0006LAAa%\u0003\n\n\u0019Q*\u00199\u0011\r\u0005u#q\u0013BN\u0013\r\u0011IJ\u0019\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\u0011\u0011\tK!$\u0002\t1\fgnZ\u0005\u0005\u0005K\u0013yJ\u0001\u0003W_&$\u0017A\b5b]\u0012dW\r\u0016:v]\u000e\fG/Z!oIJ+7\u000f^8sKJ+7/\u001e7u)\u0019\t\u0019Na+\u0003.\"9\u0011Q\u001e\u0017A\u0002\u0005=\bb\u0002BBY\u0001\u0007!q\u0016\t\t\u0005\u000f\u0013\t*a\u0010\u00032B1\u0011Q\fBL\u0005g\u0003BAa\u0001\u00036&!!q\u0017B\u0003\u0005a!&/\u001e8dCR,\u0017I\u001c3SKN$xN]3SKN,H\u000e^\u0001\u000eG>l\u0007\u000f\\3uKR{\u0007/[2\u0015\t\u0005e!Q\u0018\u0005\b\u0005;j\u0003\u0019AA \u0003u)\b\u000fZ1uKR{\u0007/[2To&$8\r[8wKJlU\r^1eCR\fG\u0003CAj\u0005\u0007\u0014)M!6\t\u000f\u00055h\u00061\u0001\u0002p\"9!q\u0019\u0018A\u0002\t%\u0017A\u0002<bYV,7\u000f\u0005\u0005\u0002,\t-\u0017q\bBg\u0013\u0011\u0011\u0019*!\u0010\u0011\t\t='\u0011[\u0007\u0003\u0003cJAAa5\u0002r\tiR*\u001b:s_J$v\u000e]5d'^LGo\u00195pm\u0016\u0014X*\u001a;bI\u0006$\u0018\rC\u0005\u0003X:\u0002\n\u00111\u0001\u0002\u0010\u00059\u0011n]#se>\u0014\u0018aJ;qI\u0006$X\rV8qS\u000e\u001cv/\u001b;dQ>4XM]'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM\n\u0011\u0006[1oI2,W\u000b\u001d3bi\u0016$v\u000e]5d'^LGo\u00195pm\u0016\u0014X*\u001a;bI\u0006$\u0018MU3tk2$H\u0003CAj\u0005?\u0014\tO!@\t\u000f\u00055\b\u00071\u0001\u0002p\"9!1\u001d\u0019A\u0002\t\u0015\u0018\u0001\u0004:fgVdGOR;ukJ,\u0007C\u0002Bt\u0005[\u0014\t0\u0004\u0002\u0003j*!!1\u001eBE\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005_\u0014IOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004BAa=\u0003z6\u0011!Q\u001f\u0006\u0004\u0005o\u0014\u0017\u0001\u0003:fcV,7\u000f^:\n\t\tm(Q\u001f\u0002\u0015\u00032$XM]'jeJ|'o\u001d*fgB|gn]3\t\u000f\t]\u0007\u00071\u0001\u0002\u0010\u0005\u00112m\\7qY\u0016$XmU<ji\u000eDwN^3s)\u0011\t\u0019na\u0001\t\u000f\u00055\u0018\u00071\u0001\u0002p\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u00024\u0006aqN\\\"p[BdW\r^5p]R!\u0011\u0011DB\u0007\u0011\u001d\u0019ya\ra\u0001\u0007#\taA]3tk2$\bc\u0001\"\u0004\u0014%\u00191Q\u0003%\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002I\rcWo\u001d;fe2Kgn[*xSR\u001c\u0007n\u001c<feN#\u0018\r^3Ue\u0006t7/\u001b;j_:\u0004\"aQ\u001b\u0014\u0007U\u001ai\u0002E\u0002u\u0007?I1a!\tv\u0005\u0019\te.\u001f*fMR\u00111\u0011D\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r%\"fA:\u00038\u0001")
public class ClusterLinkSwitchoverStateTransition
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin localAdmin;
    private boolean done;
    private Set<String> unalteredTopics;
    private Set<String> activeSwitchoverTopics;
    private final Uuid linkId;
    private ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType;
    private ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState;
    private long switchoverTimestamp;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkSwitchoverStateTransition$.MODULE$.$lessinit$greater$default$7();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private Set<String> unalteredTopics() {
        return this.unalteredTopics;
    }

    private void unalteredTopics_$eq(Set<String> x$1) {
        this.unalteredTopics = x$1;
    }

    private Set<String> activeSwitchoverTopics() {
        return this.activeSwitchoverTopics;
    }

    private void activeSwitchoverTopics_$eq(Set<String> x$1) {
        this.activeSwitchoverTopics = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType() {
        return this.switchoverType;
    }

    private void switchoverType_$eq(ClusterLinkSwitchoverMetadata.SwitchoverType x$1) {
        this.switchoverType = x$1;
    }

    private ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState() {
        return this.switchoverState;
    }

    private void switchoverState_$eq(ClusterLinkSwitchoverMetadata.SwitchoverState x$1) {
        this.switchoverState = x$1;
    }

    private long switchoverTimestamp() {
        return this.switchoverTimestamp;
    }

    private void switchoverTimestamp_$eq(long x$1) {
        this.switchoverTimestamp = x$1;
    }

    private final int failoverTimeout() {
        return 300000;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        Option<ClusterLinkSwitchoverMetadata> switchoverMetadataOption;
        if (!this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName())) {
            this.done_$eq(true);
            v0 = ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (this.activeSwitchoverTopics().equals(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})))) {
            this.activeSwitchoverTopics_$eq((Set)this.metadataManager().getAllTopicsInCluster().filter((Function1<String, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(ClusterLinkSwitchoverStateTransition.$anonfun$run$1(topic))));
            this.unalteredTopics_$eq((Set)this.metadataManager().getAllTopicsInCluster().filter((Function1<String, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(ClusterLinkSwitchoverStateTransition.$anonfun$run$2(topic))));
        }
        if ((switchoverMetadataOption = this.metadataManager().clusterLinkSwitchoverMetadata(this.linkId())).isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "No switchover metadata found for link " + this.linkId());
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(UnexpectedSwitchoverStateErrorCode$.MODULE$, "No switchover metadata found for link " + this.linkId());
            this.done_$eq(true);
            return ClusterLinkScheduler$.MODULE$.completedTask(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$));
        }
        ClusterLinkSwitchoverMetadata switchoverMetadata = switchoverMetadataOption.get();
        this.switchoverType_$eq(switchoverMetadata.switchoverType());
        this.switchoverState_$eq(switchoverMetadata.switchoverState());
        this.switchoverTimestamp_$eq(switchoverMetadata.switchoverTimestamp());
        return this.transition(new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty()));
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        Tuple2<ClusterLinkSwitchoverMetadata.SwitchoverType, ClusterLinkSwitchoverMetadata.SwitchoverState> tuple2;
        while (this.unalteredTopics().nonEmpty()) {
            Tuple2<ClusterLinkSwitchoverMetadata.SwitchoverType, ClusterLinkSwitchoverMetadata.SwitchoverState> tuple22 = new Tuple2<ClusterLinkSwitchoverMetadata.SwitchoverType, ClusterLinkSwitchoverMetadata.SwitchoverState>(this.switchoverType(), this.switchoverState());
            if (tuple22 != null) {
                ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType = tuple22._1();
                ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple22._2();
                if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.FAILOVER)).equals((Object)switchoverType) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_ACTIVE)).equals((Object)switchoverState)) {
                    return this.sendSwitchoverAlterMirrors(taskContext, AlterMirrorOp.FAILOVER);
                }
            }
            if (tuple22 != null) {
                ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType = tuple22._1();
                ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple22._2();
                if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.REVERSE)).equals((Object)switchoverType) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_ACTIVE)).equals((Object)switchoverState)) {
                    return this.sendSwitchoverAlterMirrors(taskContext, AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR);
                }
            }
            if (tuple22 != null) {
                ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType = tuple22._1();
                ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple22._2();
                if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.RESTORE)).equals((Object)switchoverType) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_PASSIVE)).equals((Object)switchoverState)) {
                    return this.sendSwitchoverAlterMirrors(taskContext, AlterMirrorOp.TRUNCATE_AND_RESTORE);
                }
            }
            if (tuple22 != null) {
                this.unalteredTopics_$eq((Set<String>)Predef$.MODULE$.Set().empty());
                continue;
            }
            throw new MatchError(tuple22);
        }
        ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType = this.switchoverType();
        ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType2 = ClusterLinkSwitchoverMetadata.SwitchoverType.FAILOVER;
        if (!(switchoverType != null ? !((Object)((Object)switchoverType)).equals((Object)switchoverType2) : switchoverType2 != null) && super.time().milliseconds() - this.switchoverTimestamp() > 300000L) {
            Uuid x$1 = this.linkId();
            short x$2 = FailoverTimeoutErrorCode$.MODULE$.id();
            String x$3 = "Failover is taking an unexpectedly long time.";
            AlterClusterLinkOp x$4 = this.metadataManager().alterClusterLink$default$2();
            ClusterLinkSwitchoverMetadata.SwitchoverType x$5 = this.metadataManager().alterClusterLink$default$3();
            long x$6 = this.metadataManager().alterClusterLink$default$4();
            ClusterLinkSwitchoverMetadata.SwitchoverState x$7 = this.metadataManager().alterClusterLink$default$5();
            long x$8 = this.metadataManager().alterClusterLink$default$8();
            this.metadataManager().alterClusterLink(x$1, x$4, x$5, x$6, x$7, x$2, "Failover is taking an unexpectedly long time.", x$8);
        }
        if ((tuple2 = new Tuple2<ClusterLinkSwitchoverMetadata.SwitchoverType, ClusterLinkSwitchoverMetadata.SwitchoverState>(this.switchoverType(), this.switchoverState())) != null) {
            ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType3 = tuple2._1();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple2._2();
            if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.FAILOVER)).equals((Object)switchoverType3) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_ACTIVE)).equals((Object)switchoverState)) {
                return this.verifyLinkSwitchoverProgress(taskContext, MirrorTopicDescription.State.STOPPED, new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.ACTIVE, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_STOPPED, Nil$.MODULE$)), this.verifyLinkSwitchoverProgress$default$4());
            }
        }
        if (tuple2 != null) {
            ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType4 = tuple2._1();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple2._2();
            if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.REVERSE)).equals((Object)switchoverType4) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_ACTIVE)).equals((Object)switchoverState)) {
                return this.verifyLinkSwitchoverProgress(taskContext, MirrorTopicDescription.State.STOPPED, new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.ACTIVE, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_SYNCHRONIZE, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_STOPPED, Nil$.MODULE$))), this.verifyLinkSwitchoverProgress$default$4());
            }
        }
        if (tuple2 != null) {
            ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType5 = tuple2._1();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple2._2();
            if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.REVERSE)).equals((Object)switchoverType5) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_PASSIVE)).equals((Object)switchoverState)) {
                return this.verifyLinkSwitchoverProgress(taskContext, MirrorTopicDescription.State.ACTIVE, new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.STOPPED, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_MIRROR, Nil$.MODULE$)), true);
            }
        }
        if (tuple2 != null) {
            ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType6 = tuple2._1();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple2._2();
            if (((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverType.RESTORE)).equals((Object)switchoverType6) && ((Object)((Object)ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_PASSIVE)).equals((Object)switchoverState)) {
                return this.verifyLinkSwitchoverProgress(taskContext, MirrorTopicDescription.State.ACTIVE, new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.STOPPED, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_SETUP_FOR_RESTORE, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)MirrorTopicDescription.State.PENDING_RESTORE, Nil$.MODULE$))), true);
            }
        }
        if (tuple2 != null) {
            ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType7 = tuple2._1();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = tuple2._2();
            if (switchoverType7 != null) {
                ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType8 = switchoverType7;
                if (switchoverState != null) {
                    ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState2 = switchoverState;
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(UnexpectedSwitchoverStateErrorCode$.MODULE$, "Unexpected switchover state " + switchoverState2 + " for switchover type " + switchoverType8)), Nil$.MODULE$)));
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private ClusterLinkScheduler.TaskResult verifyLinkSwitchoverProgress(ClusterLinkScheduler.TaskContext taskContext, MirrorTopicDescription.State completeState, Seq<MirrorTopicDescription.State> intermediateStates, boolean allowNonMirrorState) {
        Set errs = (Set)this.activeSwitchoverTopics().flatMap((Function1<String, Option> & Serializable)topic -> this.verifyMirrorStateAndCompleteTopic((String)topic, completeState, intermediateStates, allowNonMirrorState, this.verifyMirrorStateAndCompleteTopic$default$5()));
        if (errs.nonEmpty()) {
            scala.collection.immutable.Map<String, MirrorTopicSwitchoverMetadata> requestMap = ((IterableOnceOps)errs.flatMap((Function1<Tuple2, Option> & Serializable)pair -> {
                String topic = (String)pair._1();
                TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)pair._2();
                if (err.msg().equals("No mirror topic information found for " + topic)) {
                    return None$.MODULE$;
                }
                MirrorTopicSwitchoverMetadata metadata = MirrorTopicSwitchoverMetadata.unchanged();
                metadata.setErrorCode(err.code().id());
                metadata.setErrorMessage(err.msg());
                return new Some<Tuple2<String, MirrorTopicSwitchoverMetadata>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), metadata));
            })).toMap($less$colon$less$.MODULE$.refl());
            return this.updateTopicSwitchoverMetadata(taskContext, requestMap, this.updateTopicSwitchoverMetadata$default$3());
        }
        if (this.activeSwitchoverTopics().isEmpty()) {
            return this.completeSwitchover(taskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus((IterableOnce)errs.map((Function1<Tuple2, TaskErrorCodeAndMsg> & Serializable)x$1 -> (TaskErrorCodeAndMsg)x$1._2())));
    }

    private boolean verifyLinkSwitchoverProgress$default$4() {
        return false;
    }

    private Option<Tuple2<String, TaskErrorCodeAndMsg>> verifyMirrorStateAndCompleteTopic(String topic, MirrorTopicDescription.State completeState, Seq<MirrorTopicDescription.State> intermediateStates, boolean allowNonMirrorState, boolean verifyOnly) {
        MirrorTopicDescription.State state;
        Option mirrorTopicState = this.clientManager().metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get(topic);
        if (mirrorTopicState.isEmpty()) {
            if (!allowNonMirrorState) {
                if (!verifyOnly) {
                    this.warn((Function0<String> & Serializable)() -> "No mirror topic information for topic " + topic);
                }
                return new Some<Tuple2<String, TaskErrorCodeAndMsg>>(new Tuple2<String, TaskErrorCodeAndMsg>(topic, new TaskErrorCodeAndMsg(UnexpectedMirrorStateErrorCode$.MODULE$, "No mirror topic information found for " + topic)));
            }
            return None$.MODULE$;
        }
        MirrorTopicDescription.State state2 = state = ((ClusterLinkTopicState)mirrorTopicState.get()).mirrorTopicDescriptionState();
        MirrorTopicDescription.State state3 = completeState;
        if (!(state2 != null ? !state2.equals(state3) : state3 != null)) {
            if (!verifyOnly) {
                this.debug((Function0<String> & Serializable)() -> "Switchover finished for topic " + topic);
                this.completeTopic(topic);
            }
            return None$.MODULE$;
        }
        if (intermediateStates.contains(state)) {
            if (!verifyOnly) {
                this.debug((Function0<String> & Serializable)() -> "Switchover still in progress for topic " + topic);
            }
            return None$.MODULE$;
        }
        return new Some<Tuple2<String, TaskErrorCodeAndMsg>>(new Tuple2<String, TaskErrorCodeAndMsg>(topic, new TaskErrorCodeAndMsg(UnexpectedMirrorStateErrorCode$.MODULE$, "Unexpected mirror state " + state + " for topic " + topic)));
    }

    private boolean verifyMirrorStateAndCompleteTopic$default$5() {
        return false;
    }

    private ClusterLinkScheduler.TaskResult sendSwitchoverAlterMirrors(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorOp op) {
        scala.collection.immutable.Map map;
        this.info((Function0<String> & Serializable)() -> "Sending switchover op " + op + " ");
        AlterMirrorOp alterMirrorOp = op;
        if (AlterMirrorOp.FAILOVER.equals(alterMirrorOp)) {
            map = ((IterableOnceOps)this.unalteredTopics().flatMap((Function1<String, Option> & Serializable)topic -> this.verifyMirrorStateAndCompleteTopic((String)topic, MirrorTopicDescription.State.ACTIVE, (Seq)package$.MODULE$.Seq().empty(), false, true))).toMap($less$colon$less$.MODULE$.refl());
        } else if (AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR.equals(alterMirrorOp)) {
            map = ((IterableOnceOps)this.unalteredTopics().flatMap((Function1<String, Option> & Serializable)topic -> this.verifyMirrorStateAndCompleteTopic((String)topic, MirrorTopicDescription.State.ACTIVE, (Seq)package$.MODULE$.Seq().empty(), false, true))).toMap($less$colon$less$.MODULE$.refl());
        } else if (AlterMirrorOp.TRUNCATE_AND_RESTORE.equals(alterMirrorOp)) {
            map = ((IterableOnceOps)this.unalteredTopics().flatMap((Function1<String, Option> & Serializable)topic -> this.verifyMirrorStateAndCompleteTopic((String)topic, MirrorTopicDescription.State.STOPPED, (Seq)package$.MODULE$.Seq().empty(), true, true))).toMap($less$colon$less$.MODULE$.refl());
        } else {
            throw new RuntimeException("Unexpected alter mirror operation " + op);
        }
        scala.collection.immutable.Map wrongStateTopics = map;
        if (wrongStateTopics.nonEmpty()) {
            String errMsg = "Topics " + wrongStateTopics.keySet() + " are in the incorrect mirror states for the provided switchover operation. The switchover operation will not proceed until they are in the correct state.";
            Uuid x$1 = this.linkId();
            short x$2 = UnexpectedMirrorStateErrorCode$.MODULE$.id();
            String x$3 = errMsg;
            AlterClusterLinkOp x$4 = this.metadataManager().alterClusterLink$default$2();
            ClusterLinkSwitchoverMetadata.SwitchoverType x$5 = this.metadataManager().alterClusterLink$default$3();
            long x$6 = this.metadataManager().alterClusterLink$default$4();
            ClusterLinkSwitchoverMetadata.SwitchoverState x$7 = this.metadataManager().alterClusterLink$default$5();
            long x$8 = this.metadataManager().alterClusterLink$default$8();
            this.metadataManager().alterClusterLink(x$1, x$4, x$5, x$6, x$7, x$2, x$3, x$8);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(UnexpectedMirrorStateErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.unalteredTopics().map((Function1<String, Tuple2> & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), op))).toMap($less$colon$less$.MODULE$.refl())).asJava());
        AlterMirrorOp alterMirrorOp2 = op;
        AlterMirrorOp alterMirrorOp3 = AlterMirrorOp.TRUNCATE_AND_RESTORE;
        if (!(alterMirrorOp2 != null ? !alterMirrorOp2.equals(alterMirrorOp3) : alterMirrorOp3 != null)) {
            this.scheduleWhenComplete(result.allTruncateAndRestoreResults(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleTruncateAndRestoreResult((ClusterLinkScheduler.TaskContext)tc, result.truncateAndRestoreValues()), taskContext));
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleSwitchoverAlterMirrorsResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleSwitchoverAlterMirrorsResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        scala.collection.immutable.Map errs = CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    future.get();
                    this.unalteredTopics_$eq((Set)this.unalteredTopics().$minus(topic));
                    this.debug((Function0<String> & Serializable)() -> "Successfully sent the alterMirrors for mirror topic '" + topic + "'");
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RetriableException) {
                        String errMsg = "Failed to send alterMirrors for " + topic + " due to retriable exception.";
                        this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                        TaskErrorCodeAndMsg err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
                        option = new Some<Tuple2<String, TaskErrorCodeAndMsg>>(new Tuple2<String, TaskErrorCodeAndMsg>(topic, err));
                    }
                    String errMsg = "Failed to send alterMirrors for " + topic;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    TaskErrorCodeAndMsg err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
                    option = new Some<Tuple2<String, TaskErrorCodeAndMsg>>(new Tuple2<String, TaskErrorCodeAndMsg>(topic, err));
                }
                return option;
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
        if (errs.nonEmpty()) {
            scala.collection.immutable.Map requestMap = (scala.collection.immutable.Map)errs.map((Function1<Tuple2, Tuple2> & Serializable)pair -> {
                String topic = (String)pair._1();
                TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)pair._2();
                MirrorTopicSwitchoverMetadata metadata = MirrorTopicSwitchoverMetadata.unchanged();
                metadata.setErrorCode(err.code().id());
                metadata.setErrorMessage(err.msg());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), metadata);
            });
            return this.updateTopicSwitchoverMetadata(taskContext, requestMap, this.updateTopicSwitchoverMetadata$default$3());
        }
        this.info((Function0<String> & Serializable)() -> "Successfully sent the alterMirrors for all topics on link " + $this.linkData.linkName() + ".");
        return this.transition(taskContext);
    }

    private ClusterLinkScheduler.TaskResult handleTruncateAndRestoreResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<TruncateAndRestoreResult>> topicResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        scala.collection.immutable.Map<String, MirrorTopicSwitchoverMetadata> newMetadata = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(topicResults.keySet()).asScala().map((Function1<String, Tuple2> & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), MirrorTopicSwitchoverMetadata.empty()))).toMap($less$colon$less$.MODULE$.refl());
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    TruncateAndRestoreResult result = (TruncateAndRestoreResult)future.get();
                    this.unalteredTopics_$eq((Set)this.unalteredTopics().$minus(topic));
                    this.debug((Function0<String> & Serializable)() -> "Successfully sent the truncate and restore for mirror topic '" + topic + "'. " + result.messagesTruncated() + " messages were truncated.");
                    ((MirrorTopicSwitchoverMetadata)newMetadata.apply(topic)).setMessagesTruncated(result.messagesTruncated());
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RetriableException) {
                        String errMsg = "Failed to send alterMirrors for " + topic + " due to retriable exception.";
                        this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                        TaskErrorCodeAndMsg err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
                        ((MirrorTopicSwitchoverMetadata)newMetadata.apply(topic)).setErrorCode(err.code().id());
                        ((MirrorTopicSwitchoverMetadata)newMetadata.apply(topic)).setErrorMessage(err.msg());
                        option = new Some<TaskErrorCodeAndMsg>(err);
                    }
                    String errMsg = "Failed to send alterMirrors for " + topic;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    TaskErrorCodeAndMsg err = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
                    ((MirrorTopicSwitchoverMetadata)newMetadata.apply(topic)).setErrorCode(err.code().id());
                    ((MirrorTopicSwitchoverMetadata)newMetadata.apply(topic)).setErrorMessage(err.msg());
                    option = new Some<TaskErrorCodeAndMsg>(err);
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (errs.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Successfully sent the alterMirrors for all topics on link " + $this.linkData.linkName() + ".");
        }
        return this.updateTopicSwitchoverMetadata(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs)), newMetadata, errs.nonEmpty());
    }

    private void completeTopic(String topic) {
        this.activeSwitchoverTopics_$eq((Set)this.activeSwitchoverTopics().$minus(topic));
    }

    private ClusterLinkScheduler.TaskResult updateTopicSwitchoverMetadata(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, MirrorTopicSwitchoverMetadata> values, boolean isError) {
        this.info((Function0<String> & Serializable)() -> "Updating switchover metadata for topics " + values.keySet());
        CompletableFuture<AlterMirrorsResponse> result = this.metadataManager().updateMirrorTopicSwitchoverMetadata(values);
        this.scheduleWhenComplete(result, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleUpdateTopicSwitchoverMetadataResult((ClusterLinkScheduler.TaskContext)tc, result, isError), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private boolean updateTopicSwitchoverMetadata$default$3() {
        return true;
    }

    private ClusterLinkScheduler.TaskResult handleUpdateTopicSwitchoverMetadataResult(ClusterLinkScheduler.TaskContext taskContext, CompletableFuture<AlterMirrorsResponse> resultFuture, boolean isError) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        scala.collection.mutable.Map topicErrs = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        TaskErrorCodeAndMsg linkErr = null;
        try {
            AlterMirrorsResponse result = resultFuture.get();
            result.data().results().forEach(topicResult -> {
                String topic = topicResult.topic();
                if (topicResult.errorCode() == Errors.NONE.code()) {
                    this.debug((Function0<String> & Serializable)() -> "Successfully updated switchover metadata for topic " + topic + ".");
                    return;
                }
                topicErrs.put(topic, new TaskErrorCodeAndMsg(FailedToUpdateMetadataErrorCode$.MODULE$, topicResult.errorMessage()));
            });
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RetriableException) {
                String errMsg = "Failed to send update switchover metadata for " + this.linkId() + " due to retriable exception.";
                this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                linkErr = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
            }
            String errMsg = "Failed to send update switchover metadata for " + this.linkId();
            excessiveLoggingHandler.handle(e, this, errMsg);
            linkErr = ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsg, true, e);
        }
        if (linkErr != null) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)linkErr), Nil$.MODULE$)));
        }
        if (topicErrs.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(topicErrs.values()));
        }
        if (isError) {
            return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
        }
        return this.transition(taskContext);
    }

    private ClusterLinkScheduler.TaskResult completeSwitchover(ClusterLinkScheduler.TaskContext taskContext) {
        ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState = this.switchoverState();
        ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState2 = ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_ACTIVE;
        if (!(switchoverState != null ? !((Object)((Object)switchoverState)).equals((Object)switchoverState2) : switchoverState2 != null)) {
            Uuid x$1 = this.linkId();
            ClusterLinkSwitchoverMetadata.SwitchoverState x$2 = ClusterLinkSwitchoverMetadata.SwitchoverState.ACTIVE;
            AlterClusterLinkOp x$3 = this.metadataManager().alterClusterLink$default$2();
            ClusterLinkSwitchoverMetadata.SwitchoverType x$4 = this.metadataManager().alterClusterLink$default$3();
            long x$5 = this.metadataManager().alterClusterLink$default$4();
            short x$6 = this.metadataManager().alterClusterLink$default$6();
            String x$7 = this.metadataManager().alterClusterLink$default$7();
            long x$8 = this.metadataManager().alterClusterLink$default$8();
            this.metadataManager().alterClusterLink(x$1, x$3, x$4, x$5, ClusterLinkSwitchoverMetadata.SwitchoverState.ACTIVE, x$6, x$7, x$8);
        } else {
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState3 = this.switchoverState();
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState4 = ClusterLinkSwitchoverMetadata.SwitchoverState.PENDING_PASSIVE;
            if (!(switchoverState3 != null ? !((Object)((Object)switchoverState3)).equals((Object)switchoverState4) : switchoverState4 != null)) {
                Uuid x$9 = this.linkId();
                ClusterLinkSwitchoverMetadata.SwitchoverState x$10 = ClusterLinkSwitchoverMetadata.SwitchoverState.PASSIVE;
                AlterClusterLinkOp x$11 = this.metadataManager().alterClusterLink$default$2();
                ClusterLinkSwitchoverMetadata.SwitchoverType x$12 = this.metadataManager().alterClusterLink$default$3();
                long x$13 = this.metadataManager().alterClusterLink$default$4();
                short x$14 = this.metadataManager().alterClusterLink$default$6();
                String x$15 = this.metadataManager().alterClusterLink$default$7();
                long x$16 = this.metadataManager().alterClusterLink$default$8();
                this.metadataManager().alterClusterLink(x$9, x$11, x$12, x$13, ClusterLinkSwitchoverMetadata.SwitchoverState.PASSIVE, x$14, x$15, x$16);
            }
        }
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.info((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName())) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager().metrics(), ClusterLinkSwitchoverStateTransitionTaskType$.MODULE$, false, "switchover state transition"));
        } else {
            this.taskDesc_$eq(None$.MODULE$);
        }
        if (this.done()) {
            this.info((Function0<String> & Serializable)() -> "Switchover state transition task completed for link '" + $this.linkData.linkName() + "'.'");
            this.shutdown();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$1(String topic) {
        return !Topic.isInternal((String)topic);
    }

    public static final /* synthetic */ boolean $anonfun$run$2(String topic) {
        return !Topic.isInternal((String)topic);
    }

    public ClusterLinkSwitchoverStateTransition(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkSwitchoverStateTransition", intervalMs, time, quota);
        this.done = false;
        this.unalteredTopics = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}));
        this.activeSwitchoverTopics = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}));
        this.linkId = linkData.linkId();
        this.switchoverType = ClusterLinkSwitchoverMetadata.SwitchoverType.UNKNOWN;
        this.switchoverState = ClusterLinkSwitchoverMetadata.SwitchoverState.UNKNOWN;
        this.switchoverTimestamp = 0L;
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-" + linkData.linkName() + "] ");
        this.taskDesc = None$.MODULE$;
    }
}

