/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.AclLimitExceededTaskErrorCode$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSyncAcls$;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.SecurityDisabledTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011ma\u0001B,Y\u0001}C\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t!\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005U\"Aa\u000e\u0001BC\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003q\u0011!!\bA!b\u0001\n\u0003)\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011i\u0004!\u0011!Q\u0001\nmD\u0001B \u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\n\u007f\u0002\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\r\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0011q\u0006\u0005\r\u0003c\u0001!\u0011!Q\u0001\n\u0005M\u00121\b\u0005\u000b\u0003{\u0001!Q1A\u0005\u0002\u0005}\u0002BCA'\u0001\t\u0005\t\u0015!\u0003\u0002B!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006I!!\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!I\u00111\u000f\u0001A\u0002\u0013%\u0011Q\u000f\u0005\n\u0003{\u0002\u0001\u0019!C\u0005\u0003\u007fB\u0001\"a#\u0001A\u0003&\u0011q\u000f\u0005\n\u0003\u001b\u0003!\u0019!C\u0005\u0003\u001fC\u0001\"!'\u0001A\u0003%\u0011\u0011\u0013\u0005\n\u00037\u0003!\u0019!C\u0005\u0003;C\u0001\"a,\u0001A\u0003%\u0011q\u0014\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0011\"!.\u0001\u0001\u0004%I!a.\t\u0011\u0005m\u0006\u0001)Q\u0005\u0003#B\u0011\"!0\u0001\u0001\u0004%I!a\u0010\t\u0013\u0005}\u0006\u00011A\u0005\n\u0005\u0005\u0007\u0002CAc\u0001\u0001\u0006K!!\u0011\t\u0013\u0005\u001d\u0007\u00011A\u0005\n\u0005%\u0007\"CAl\u0001\u0001\u0007I\u0011BAm\u0011!\ti\u000e\u0001Q!\n\u0005-\u0007\"CAt\u0001\t\u0007I\u0011BAu\u0011!\t\t\u0010\u0001Q\u0001\n\u0005-\b\"CAz\u0001\t\u0007I\u0011BA{\u0011!\u0011I\u000b\u0001Q\u0001\n\u0005]\bb\u0002BV\u0001\u0011E#Q\u0016\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005GDqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003n\u0002!IAa<\t\u000f\tU\b\u0001\"\u0003\u0003x\"9!1 \u0001\u0005\n\tu\bbBB\u0014\u0001\u0011%1\u0011\u0006\u0005\b\u0007\u0003\u0002A\u0011BB\"\u0011\u001d\u0019i\u0005\u0001C\u0005\u0007\u001fBqa!\u0018\u0001\t\u0013\u0019y\u0006C\u0004\u0004p\u0001!Ia!\u001d\t\u0011\r\r\u0005\u0001\"\u0001Y\u0007\u000bCqaa(\u0001\t\u0013\u0019\t\u000bC\u0004\u0004,\u0002!Ia!,\t\u000f\r\u0005\u0007\u0001\"\u0011\u0003\"\"911\u0019\u0001\u0005\u0002\u0005M\u0006bBBc\u0001\u0011\u00051q\u0019\u0005\b\u0007\u001b\u0004A\u0011AA \u0011\u001d\u0019y\r\u0001C)\u0007#Dqa!8\u0001\t\u0013\u0019y\u000eC\u0004\u0004d\u0002!\te!:\t\u000f\r\u001d\b\u0001\"\u0001\u0004j\"A11\u001e\u0001\u0005\u0002a\u001biO\u0002\u0004\u0002|\u0002!\u0011Q \u0005\u000b\u0005\u000bq$\u0011!Q\u0001\n\t\u001d\u0001bBA,}\u0011\u0005!Q\u0002\u0005\n\u0005#q\u0004\u0019!C\u0001\u0003gC\u0011Ba\u0005?\u0001\u0004%\tA!\u0006\t\u0011\tea\b)Q\u0005\u0003#B\u0011Ba\u0007?\u0001\u0004%\tA!\b\t\u0013\t\u001db\b1A\u0005\u0002\t%\u0002\u0002\u0003B\u0017}\u0001\u0006KAa\b\t\u0013\t=b\b1A\u0005\n\tE\u0002\"\u0003B\u001b}\u0001\u0007I\u0011\u0002B\u001c\u0011!\u0011YD\u0010Q!\n\tM\u0002\"\u0003B\u001f}\t\u0007I\u0011\u0002B \u0011!\u0011YF\u0010Q\u0001\n\t\u0005\u0003b\u0002B/}\u0011\u0005!q\f\u0005\b\u0005\u0017sD\u0011\u0001BG\u0011\u001d\u0011yJ\u0010C\u0005\u0005CCqAa)?\t\u0003\u0011)\u000bC\u0004\u0003(z\"IA!)\t\u001d\rE\b\u0001%A\u0002\u0002\u0003%Iaa=\u00020\u001dI1Q\u001f-\u0002\u0002#\u00051q\u001f\u0004\t/b\u000b\t\u0011#\u0001\u0004z\"9\u0011qK*\u0005\u0002\rm\b\"CB\u007f'F\u0005I\u0011AB\u0000\u0011%!)bUI\u0001\n\u0003!9BA\nDYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7O\u0003\u0002Z5\u0006!A.\u001b8l\u0015\tYF,\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001a!\t\tWM\u0004\u0002cG6\t\u0001,\u0003\u0002e1\u0006!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!AZ4\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005\u0011D\u0016!D2mS\u0016tG/T1oC\u001e,'/F\u0001k!\t\u00117.\u0003\u0002m1\na2\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHo\u00117jK:$X*\u00198bO\u0016\u0014\u0018AD2mS\u0016tG/T1oC\u001e,'\u000fI\u0001\tY&t7\u000eR1uCV\t\u0001\u000f\u0005\u0002cc&\u0011!\u000f\u0017\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feV\ta\u000f\u0005\u0002co&\u0011\u0001\u0010\u0017\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n1B]3n_R,\u0017\tZ7j]B\u0011!\r`\u0005\u0003{b\u0013Qc\u00117vgR,'\u000fT5oW\n\u000bGo\u00195BI6Lg.\u0001\u0006m_\u000e\fG.\u00113nS:\fq!\\3ue&\u001c7\u000fE\u0002c\u0003\u0007I1!!\u0002Y\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u00027\u0005\u001cGNQ5oI&twMR5mi\u0016\u0014HK]1og\u001a|'/\\3s+\t\tY\u0001E\u0002c\u0003\u001bI1!a\u0004Y\u0005m\t5\r\u001c\"j]\u0012Lgn\u001a$jYR,'\u000f\u0016:b]N4wN]7fe\u0006a\u0012m\u00197CS:$\u0017N\\4GS2$XM\u001d+sC:\u001chm\u001c:nKJ\u0004\u0013\u0001\u0002;j[\u0016\u0004B!a\u0006\u0002,5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0003vi&d7O\u0003\u0003\u0002 \u0005\u0005\u0012AB2p[6|gNC\u0002^\u0003GQA!!\n\u0002(\u00051\u0011\r]1dQ\u0016T!!!\u000b\u0002\u0007=\u0014x-\u0003\u0003\u0002.\u0005e!\u0001\u0002+j[\u0016L1!a\u0005f\u0003\u0015\tXo\u001c;b!\u0011\t)$a\u000e\u000e\u0003iK1!!\u000f[\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-C\u0002\u00022\u0015\f\u0001%Y2m\r&dG/\u001a:XSRD'+Z:pkJ\u001cW-\u00133Qe&t7-\u001b9bYV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0011\u0011qI\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0017\n)EA\u0004C_>dW-\u00198\u0002C\u0005\u001cGNR5mi\u0016\u0014x+\u001b;i%\u0016\u001cx.\u001e:dK&#\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u0013\t\fGo\u00195TSj,\u0007\u0003BA\"\u0003'JA!!\u0016\u0002F\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)a\tY&!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\u0002n\u0005=\u0014\u0011\u000f\t\u0003E\u0002AQ\u0001[\tA\u0002)DQA\\\tA\u0002ADQ\u0001^\tA\u0002YDQA_\tA\u0002mDQA`\tA\u0002mDaa`\tA\u0002\u0005\u0005\u0001bBA\u0004#\u0001\u0007\u00111\u0002\u0005\b\u0003'\t\u0002\u0019AA\u000b\u0011\u001d\t\t$\u0005a\u0001\u0003gA\u0011\"!\u0010\u0012!\u0003\u0005\r!!\u0011\t\u0013\u0005=\u0013\u0003%AA\u0002\u0005E\u0013AB2p]\u001aLw-\u0006\u0002\u0002xA\u0019!-!\u001f\n\u0007\u0005m\u0004LA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\t\t)a\"\u0011\t\u0005\r\u00131Q\u0005\u0005\u0003\u000b\u000b)E\u0001\u0003V]&$\b\"CAE'\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\bG>tg-[4!\u0003\u0019a\u0017N\\6JIV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b)*\u0004\u0002\u0002\u001e%!\u0011qSA\u000f\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005a\u0011m\u00197MS:\\\u0017\nZ*fiV\u0011\u0011q\u0014\t\u0007\u0003C\u000bY+!%\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000bA!\u001e;jY*\u0011\u0011\u0011V\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002.\u0006\r&aA*fi\u0006i\u0011m\u00197MS:\\\u0017\nZ*fi\u0002\n\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0016\u0005\u0005E\u0013\u0001\u0006;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0006e\u0006\"CAE5\u0005\u0005\t\u0019AA)\u0003E!\u0018m]6t\u001fV$8\u000f^1oI&tw\rI\u0001\fS:LG/[1mSj,G-A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\u0011\t\t)a1\t\u0013\u0005%U$!AA\u0002\u0005\u0005\u0013\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001\u0003;bg.$Um]2\u0016\u0005\u0005-\u0007CBA\"\u0003\u001b\f\t.\u0003\u0003\u0002P\u0006\u0015#AB(qi&|g\u000eE\u0002c\u0003'L1!!6Y\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0017\u0001\u0004;bg.$Um]2`I\u0015\fH\u0003BAA\u00037D\u0011\"!#!\u0003\u0003\u0005\r!a3\u0002\u0013Q\f7o\u001b#fg\u000e\u0004\u0003fA\u0011\u0002bB!\u00111IAr\u0013\u0011\t)/!\u0012\u0003\u0011Y|G.\u0019;jY\u0016\fq#\u001a=dKN\u001c\u0018N^3M_\u001e<\u0017N\\4IC:$G.\u001a:\u0016\u0005\u0005-\bc\u00012\u0002n&\u0019\u0011q\u001e-\u0003/\u0015C8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014\u0018\u0001G3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3sA\u0005)2M]3bi\u0016\f5\r\u001c*fiJL()Y2l_\u001a4WCAA|!\r\tIPP\u0007\u0002\u0001\t)2I]3bi\u0016\f5\r\u001c*fiJL()Y2l_\u001a47c\u0001 \u0002\u0000B!\u00111\tB\u0001\u0013\u0011\u0011\u0019!!\u0012\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0011\u0017mY6pM\u001a\u0004B!a\u0006\u0003\n%!!1BA\r\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0015\t\u0005](q\u0002\u0005\b\u0005\u000b\u0001\u0005\u0019\u0001B\u0004\u00035\u0011X\r\u001e:z\u0003R$X-\u001c9ug\u0006\t\"/\u001a;ss\u0006#H/Z7qiN|F%Z9\u0015\t\u0005\u0005%q\u0003\u0005\n\u0003\u0013\u0013\u0015\u0011!a\u0001\u0003#\naB]3uef\fE\u000f^3naR\u001c\b%A\u0006oKb$(+\u001a;ss6\u001bXC\u0001B\u0010!\u0019\t\u0019%!4\u0003\"A!\u00111\tB\u0012\u0013\u0011\u0011)#!\u0012\u0003\t1{gnZ\u0001\u0010]\u0016DHOU3uefl5o\u0018\u0013fcR!\u0011\u0011\u0011B\u0016\u0011%\tI)RA\u0001\u0002\u0004\u0011y\"\u0001\u0007oKb$(+\u001a;ss6\u001b\b%A\u000bmS6LGOV5pY\u0006$X\rZ!dY\u000e{WO\u001c;\u0016\u0005\tM\u0002CBA\"\u0003\u001b\f\t&A\rmS6LGOV5pY\u0006$X\rZ!dY\u000e{WO\u001c;`I\u0015\fH\u0003BAA\u0005sA\u0011\"!#I\u0003\u0003\u0005\rAa\r\u0002-1LW.\u001b;WS>d\u0017\r^3e\u0003\u000ed7i\\;oi\u0002\n1#\u001b8wC2LGMU3t_V\u00148-Z!dYN,\"A!\u0011\u0011\r\t\r#Q\nB(\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0005\u0017\n)%\u0001\u0006d_2dWm\u0019;j_:LA!!,\u0003FA!!\u0011\u000bB,\u001b\t\u0011\u0019F\u0003\u0003\u0003V\u0005u\u0011aA1dY&!!\u0011\fB*\u0005)\t5\r\u001c\"j]\u0012LgnZ\u0001\u0015S:4\u0018\r\\5e%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0011\u0002\rU\u0004H-\u0019;f)!\t\tI!\u0019\u0003f\t%\u0004b\u0002B2\u0019\u0002\u0007!\u0011I\u0001\u001e]>$8I]3bi\u0016$\u0017J\u001c<bY&$'+Z:pkJ\u001cW-Q2mg\"9!q\r'A\u0002\u0005E\u0013\u0001\u00068pi\u000e\u0013X-\u0019;fI\u0012+X\rV8MS6LG\u000fC\u0004\u0003l1\u0003\rA!\u001c\u0002#\u0019LG\u000e^3sK\u0012\f5\r\\#se>\u00148\u000f\u0005\u0004\u0003p\t}$Q\u0011\b\u0005\u0005c\u0012YH\u0004\u0003\u0003t\teTB\u0001B;\u0015\r\u00119HX\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\u001d\u0013\u0002\u0002B?\u0003\u000b\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0002\n\r%aA*fc*!!QPA#!\r\u0011'qQ\u0005\u0004\u0005\u0013C&a\u0005+bg.,%O]8s\u0007>$W-\u00118e\u001bN<\u0017a\u00054jYR,'o\u0011:fCR\f'\r\\3BG2\u001cHC\u0002BH\u0005/\u0013Y\n\u0005\u0005\u0002D\tE%Q\u0013B7\u0013\u0011\u0011\u0019*!\u0012\u0003\rQ+\b\u000f\\33!\u0019\u0011yGa \u0003P!9!\u0011T'A\u0002\tU\u0015\u0001D1dYN$vn\u0011:fCR,\u0007b\u0002BO\u001b\u0002\u0007!\u0011E\u0001\u0004]><\u0018!F7bs\n,\u0017J\\2sK6,g\u000e\u001e\"bG.|gM\u001a\u000b\u0003\u0003\u0003\u000b\u0011d\u00197fCJd\u0015.\\5u\u000bb\u001cW-\u001a3fI\n\u000b7m[8gMR\u0011\u0011\u0011I\u0001\u0006G2,\u0017M]\u0001\u0017GJ,\u0017\r^3BG2\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4gA\u0005\u0019!/\u001e8\u0015\u0005\t=\u0006\u0003\u0002BY\u0005\u007fs1Aa-d\u001d\u0011\u0011)L!0\u000f\t\t]&1\u0018\b\u0005\u0005g\u0012I,C\u0001^\u0013\tYF,\u0003\u0002Z5&\u0019!\u0011Y4\u0003\u0015Q\u000b7o\u001b*fgVdG/\u0001\u0005ts:\u001c\u0017i\u00197t)\u0019\u0011yKa2\u0003R\"9!\u0011Z\u0014A\u0002\t-\u0017a\u0003;bg.\u001cuN\u001c;fqR\u0004BA!-\u0003N&\u0019!qZ4\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0005'<\u0003\u0019\u0001Bk\u00035\t7\r\u001c$jYR,'\u000fT5tiB1!1\tBl\u00057LAA!7\u0003F\tQA*[:u\u0005V4g-\u001a:\u0011\t\tE#Q\\\u0005\u0005\u0005?\u0014\u0019F\u0001\tBG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;fe\u0006I\u0011M\\=GS2$XM\u001d\u000b\u0003\u00057\fa#\u001b8ji&\fG.\u001b>f)\",gnU=oG\u0006\u001bGn\u001d\u000b\u0007\u0005_\u0013IOa;\t\u000f\t%\u0017\u00061\u0001\u0003L\"9!1[\u0015A\u0002\tU\u0017A\u00037j].4\u0015\u000e\u001c;feR!!1\u001cBy\u0011\u001d\u0011\u0019P\u000ba\u0001\u00057\f\u0011\"Y2m\r&dG/\u001a:\u0002\u000f1Lgn[!dYR!!q\nB}\u0011\u001d\u0011)f\u000ba\u0001\u0005\u001f\n\u0011dY;se\u0016tG\u000fR3ti\u0006\u001bGn],ji\"d\u0015N\\6JIR1!q`B\u0007\u0007?\u0001ba!\u0001\u0004\n\t=c\u0002BB\u0002\u0007\u000b\u0001BAa\u001d\u0002F%!1qAA#\u0003\u0019\u0001&/\u001a3fM&!\u0011QVB\u0006\u0015\u0011\u00199!!\u0012\t\u000f\r=A\u00061\u0001\u0004\u0012\u0005!\u0011-\u001e;i!\u0011\u0019\u0019ba\u0007\u000e\u0005\rU!\u0002BB\f\u00073\t!\"Y;uQ>\u0014\u0018N_3s\u0015\rY\u0016\u0011E\u0005\u0005\u0007;\u0019)B\u0001\u0006BkRDwN]5{KJDqAa5-\u0001\u0004\u0019\t\u0003\u0005\u0004\u0003D\r\r\"1\\\u0005\u0005\u0007K\u0011)E\u0001\u0004Ck\u001a4WM]\u0001\u0013Q\u0006tG\r\\3EKN\u001c'/\u001b2f\u0003\u000ed7\u000f\u0006\u0005\u00030\u000e-2QFB\u0018\u0011\u001d\u0011I-\fa\u0001\u0005\u0017DqAa5.\u0001\u0004\u0011)\u000eC\u0004\u000425\u0002\raa\r\u0002\u0015\u0019,H/\u001e:f\u0019&\u001cH\u000f\u0005\u0004\u0003D\t]7Q\u0007\t\u0007\u0003'\u001b9da\u000f\n\t\re\u0012Q\u0004\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0004\u0002\"\u000eu\"qJ\u0005\u0005\u0007\u007f\t\u0019K\u0001\u0006D_2dWm\u0019;j_:\fq#\u001e9eCR,\u0017i\u00197t\u001f:$Um\u001d;j]\u0006$\u0018n\u001c8\u0015\u0011\t=6QIB$\u0007\u0013BqA!3/\u0001\u0004\u0011Y\rC\u0004\u0003T:\u0002\rA!6\t\u000f\r-c\u00061\u0001\u0003\u0000\u0006Q1o\\;sG\u0016\f5\r\\:\u0002;\u0005$G\r\u00165f]\u0012+G.\u001a;f\u0003\u000ed7\u000f\u00165f]NKhnY!dYN$\"Ba,\u0004R\rM3qKB.\u0011\u001d\u0011Im\fa\u0001\u0005\u0017Dqa!\u00160\u0001\u0004\u0011)*\u0001\u000esK6\f\u0017N\\5oO2{7-\u00197BG2\u001cHk\\\"sK\u0006$X\rC\u0004\u0004Z=\u0002\rA!&\u0002+I,W.Y5oS:<\u0017i\u00197t)>$U\r\\3uK\"9!1[\u0018A\u0002\tU\u0017aF;qI\u0006$X-Q2mg\u0012+g.\u001f+iK:\fE\u000e\\8x))\u0011yk!\u0019\u0004d\r\u001d41\u000e\u0005\b\u0005\u0013\u0004\u0004\u0019\u0001Bf\u0011\u001d\u0019)\u0007\ra\u0001\u0005+\u000b\u0011E]3nC&t\u0017N\\4EK:L\u0018I\u001c3BY2|w/Q2mgR{7I]3bi\u0016Dqa!\u001b1\u0001\u0004\u0011)*\u0001\u000esK6\f\u0017N\\5oO\u0006cGn\\<BG2\u001cHk\u001c#fY\u0016$X\rC\u0004\u0004nA\u0002\rA!&\u00023I,W.Y5oS:<G)\u001a8z\u0003\u000ed7\u000fV8EK2,G/Z\u0001\u000bI\u0016dW\r^3BG2\u001cH\u0003\u0003BX\u0007g\u001a)h!\u001f\t\u000f\t%\u0017\u00071\u0001\u0003L\"91qO\u0019A\u0002\tU\u0015\u0001D1dYN$v\u000eR3mKR,\u0007bBB>c\u0001\u00071QP\u0001\tG\u0006dGNY1dWBA\u00111IB@\u0005\u0017\u0014y+\u0003\u0003\u0004\u0002\u0006\u0015#!\u0003$v]\u000e$\u0018n\u001c82\u0003UA\u0017M\u001c3mK\u0006\u001bG\u000eR3mKR,'+Z:vYR$\u0002Ba,\u0004\b\u000e%5Q\u0014\u0005\b\u0005\u0013\u0014\u0004\u0019\u0001Bf\u0011\u001d\u0019YI\ra\u0001\u0007\u001b\u000b\u0001\u0003Z3mKR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\u0011\t\r=5\u0011T\u0007\u0003\u0007#SAaa%\u0004\u0016\u0006)\u0011\rZ7j]*!1qSA\u0011\u0003\u001d\u0019G.[3oiNLAaa'\u0004\u0012\n\u0001B)\u001a7fi\u0016\f5\r\\:SKN,H\u000e\u001e\u0005\b\u0007w\u0012\u0004\u0019AB?\u0003)\u0019'/Z1uK\u0006\u001bGn\u001d\u000b\t\u0005_\u001b\u0019k!*\u0004*\"9!\u0011Z\u001aA\u0002\t-\u0007bBBTg\u0001\u0007!QS\u0001\b]\u0016<\u0018i\u00197t\u0011\u001d\u0019Yh\ra\u0001\u0007{\nQ\u0003[1oI2,\u0017i\u00197De\u0016\fG/\u001a*fgVdG\u000f\u0006\u0006\u00030\u000e=6\u0011WB^\u0007{CqA!35\u0001\u0004\u0011Y\rC\u0004\u00044R\u0002\ra!.\u0002!\r\u0014X-\u0019;f\u0003\u000ed7OU3tk2$\b\u0003BBH\u0007oKAa!/\u0004\u0012\n\u00012I]3bi\u0016\f5\r\\:SKN,H\u000e\u001e\u0005\b\u0005W\"\u0004\u0019\u0001B7\u0011\u001d\u0019y\f\u000ea\u0001\u0007{\n\u0001bY1mY\n\u000b7m[\u0001\tg\",H\u000fZ8x]\u000692-\u001e:sK:$H+Y:lg>+Ho\u001d;b]\u0012LgnZ\u0001\u0012i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F\u0003BAA\u0007\u0013Dqaa38\u0001\u0004\t\t&A\u0001u\u00035I7/\u00138ji&\fG.\u001b>fI\u0006aqN\\\"p[BdW\r^5p]R!\u0011\u0011QBj\u0011\u001d\u0019).\u000fa\u0001\u0007/\faA]3tk2$\bcA1\u0004Z&\u001911\\4\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002-M,G\u000fV1tWN#\u0018\r^3Ge>l'+Z:vYR$B!!\u0011\u0004b\"91Q\u001b\u001eA\u0002\r]\u0017a\u0004;bg.$Um]2sSB$\u0018n\u001c8\u0015\u0005\u0005-\u0017A\u00047pO\u001eLgn\u001a%b]\u0012dWM\u001d\u000b\u0003\u0003W\f!B]3uef\u001cF/\u0019;f+\t\u0019y\u000f\u0005\u0005\u0002D\tE\u0015\u0011\u000bB\u0010\u0003)\u0019X\u000f]3sIQLW.Z\u000b\u0003\u0003+\t1c\u00117vgR,'\u000fT5oWNKhnY!dYN\u0004\"AY*\u0014\u0007M\u000by\u0010\u0006\u0002\u0004x\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001C\u0001U\u0011\t\t\u0005b\u0001,\u0005\u0011\u0015\u0001\u0003\u0002C\u0004\t#i!\u0001\"\u0003\u000b\t\u0011-AQB\u0001\nk:\u001c\u0007.Z2lK\u0012TA\u0001b\u0004\u0002F\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0011MA\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'M\u000b\u0003\t3QC!!\u0015\u0005\u0004\u0001")
public class ClusterLinkSyncAcls
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final boolean aclFilterWithResourceIdPrincipal;
    private final int batchSize;
    private ClusterLinkConfig config;
    private final Uuid linkId;
    private final Set<Uuid> aclLinkIdSet;
    private int tasksOutstanding;
    private boolean initialized;
    private volatile Option<TaskDescription> taskDesc;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private final CreateAclRetryBackoff createAclRetryBackoff;

    public static int $lessinit$greater$default$11() {
        return ClusterLinkSyncAcls$.MODULE$.$lessinit$greater$default$11();
    }

    public static boolean $lessinit$greater$default$10() {
        return ClusterLinkSyncAcls$.MODULE$.$lessinit$greater$default$10();
    }

    public /* synthetic */ Time kafka$server$link$ClusterLinkSyncAcls$$super$time() {
        return super.time();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    public boolean aclFilterWithResourceIdPrincipal() {
        return this.aclFilterWithResourceIdPrincipal;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Set<Uuid> aclLinkIdSet() {
        return this.aclLinkIdSet;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private CreateAclRetryBackoff createAclRetryBackoff() {
        return this.createAclRetryBackoff;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName()) && this.config().aclSyncEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String> & Serializable)() -> "Number of outstanding tasks was " + this.tasksOutstanding() + " at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().aclFilters().isEmpty()) {
                String errMsg = "ACL migration is enabled but acl.filters is not set. Please set acl.filters to proceed with ACL migration.";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$));
            }
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
            AclFiltersJson aclFilterJson = this.config().aclFilters().get();
            ListBuffer<AclBindingFilter> aclFilterList = AclJson$.MODULE$.toAclBindingFilters(aclFilterJson);
            if (!this.initialized()) {
                this.info((Function0<String> & Serializable)() -> "Not initialized for " + this.linkId() + ". Starting initialization process.");
                return this.initializeThenSyncAcls(taskContext, aclFilterList);
            }
            return this.syncAcls(taskContext, aclFilterList);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult syncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        ListBuffer describeAclsFutureList = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        aclFilterList.foreach((Function1<AclBindingFilter, ListBuffer> & Serializable)aclFilter -> {
            this.trace((Function0<String> & Serializable)() -> "Attempting to retrieve ACLs from source cluster");
            return (ListBuffer)describeAclsFutureList.$plus$eq($this.remoteAdmin.describeAcls((AclBindingFilter)aclFilter));
        });
        if (describeAclsFutureList.nonEmpty()) {
            ListBuffer futureList = (ListBuffer)describeAclsFutureList.map((Function1<DescribeAclsResult, KafkaFuture> & Serializable)result -> result.values());
            KafkaFuture future = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futureList.toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
            this.scheduleWhenComplete(future, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleDescribeAcls((ClusterLinkScheduler.TaskContext)tc, aclFilterList, futureList), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private AclBindingFilter anyFilter() {
        if (this.aclFilterWithResourceIdPrincipal()) {
            return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(MultiTenantPrincipal.WILDCARD_USERV2_PRINCIPAL.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        }
        return AclBindingFilter.ANY;
    }

    private ClusterLinkScheduler.TaskResult initializeThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Authorizer auth = (Authorizer)some.value();
            scala.collection.immutable.Set<AclBinding> linkAcls = this.currentDestAclsWithLinkId(auth, (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.anyFilter()})));
            scala.collection.immutable.Set<AclBinding> matchingAcls = this.currentDestAclsWithLinkId(auth, aclFilterList);
            scala.collection.immutable.Set notMatchingLinkAclsToDelete = (scala.collection.immutable.Set)linkAcls.diff(matchingAcls);
            scala.collection.immutable.Set localAclsToCreate = (scala.collection.immutable.Set)notMatchingLinkAclsToDelete.map((Function1<AclBinding, AclBinding> & Serializable)acl -> {
                AccessControlEntry ace = acl.entry();
                AccessControlEntry linkAce = new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
                return new AclBinding(acl.pattern(), linkAce);
            });
            return this.addThenDeleteAclsThenSyncAcls(taskContext, localAclsToCreate.toSeq(), notMatchingLinkAclsToDelete.toSeq(), aclFilterList);
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. Aborting initialization. No ACLs will be synced.";
            this.warn((Function0<String> & Serializable)() -> errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        throw new MatchError(option);
    }

    private AclBindingFilter linkFilter(AclBindingFilter aclFilter) {
        AccessControlEntryFilter ace = aclFilter.entryFilter();
        AccessControlEntryFilter linkFilter = new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), this.aclLinkIdSet());
        return new AclBindingFilter(aclFilter.patternFilter(), linkFilter);
    }

    private AclBinding linkAcl(AclBinding acl) {
        AccessControlEntry ace = acl.entry();
        Collection collection = ace.clusterLinkIds();
        Set<Uuid> set = this.aclLinkIdSet();
        if (!(collection != null ? !((Object)collection).equals(set) : set != null)) {
            return acl;
        }
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, this.aclLinkIdSet());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclsWithLinkId(Authorizer auth, Buffer<AclBindingFilter> aclFilterList) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)aclFilterList.map((Function1<AclBindingFilter, AclBindingFilter> & Serializable)aclFilter -> this.linkFilter((AclBindingFilter)aclFilter))).flatMap((Function1<AclBindingFilter, Iterable> & Serializable)filter -> {
            AclBindingFilter transformedFilter = this.aclBindingFilterTransformer().transform((AclBindingFilter)filter);
            this.debug((Function0<String> & Serializable)() -> "Transformed filter from " + filter + " to " + transformedFilter);
            return CollectionConverters$.MODULE$.IterableHasAsScala(auth.acls(transformedFilter)).asScala();
        })).map((Function1<AclBinding, AclBinding> & Serializable)acl -> this.linkAcl((AclBinding)acl))).toSet();
    }

    private ClusterLinkScheduler.TaskResult handleDescribeAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, ListBuffer<KafkaFuture<Collection<AclBinding>>> futureList) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.immutable.Seq bindingsAndErrors = ((IterableOnceOps)futureList.map((Function1<KafkaFuture, Tuple2> & Serializable)future -> {
            Tuple2<Object, Some<TaskErrorCodeAndMsg>> tuple2;
            block6: {
                try {
                    tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)future.get()).asScala().map((Function1<AclBinding, AclBinding> & Serializable)acl -> this.linkAcl((AclBinding)acl))).toSeq(), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
                }
                catch (ExecutionException e) {
                    KafkaException kafkaException;
                    String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    Throwable throwable = e.getCause();
                    if (throwable instanceof SecurityDisabledException) {
                        String errMsg = errMsgPrefix + " because no authorizer is configured on the source cluster. Please configure authorizer to proceed with ACL migration.";
                        this.excessiveLoggingHandler().handle(e, this, errMsg);
                        tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(null, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(SecurityDisabledTaskErrorCode$.MODULE$, errMsg)));
                        break block6;
                    }
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        String errMsg = errMsgPrefix + " due to authentication issues.";
                        this.excessiveLoggingHandler().handle(e, this, errMsg);
                        tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(null, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)));
                        break block6;
                    }
                    if (throwable instanceof AuthorizationException) {
                        String errMsg = errMsgPrefix + " due to authorization failure. Please enable DESCRIBE ACLs on the source cluster to proceed with ACL migration";
                        this.excessiveLoggingHandler().handle(e, this, errMsg);
                        tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(null, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)));
                        break block6;
                    }
                    String errMsg = errMsgPrefix + " for an unknown reason.";
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(null, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
                }
                catch (Throwable e) {
                    String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    String errMsg = errMsgPrefix + " for an unknown reason.";
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(null, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
                }
            }
            return tuple2;
        })).toSeq();
        scala.collection.immutable.Seq errs = (scala.collection.immutable.Seq)bindingsAndErrors.flatMap((Function1<Tuple2, Option> & Serializable)x$1 -> (Option)x$1._2());
        if (errs.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(errs));
        }
        scala.collection.immutable.Set<AclBinding> sourceAcls = ((IterableOnceOps)bindingsAndErrors.flatMap((Function1<Tuple2, scala.collection.immutable.Seq> & Serializable)x$2 -> (scala.collection.immutable.Seq)x$2._1())).toSet();
        return this.updateAclsOnDestination(taskContext, aclFilterList, sourceAcls);
    }

    private ClusterLinkScheduler.TaskResult updateAclsOnDestination(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, scala.collection.immutable.Set<AclBinding> sourceAcls) {
        this.trace((Function0<String> & Serializable)() -> "Result of describeAcls on source cluster for " + this.linkId() + ": " + sourceAcls);
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Authorizer auth = (Authorizer)some.value();
            scala.collection.immutable.Set<AclBinding> currentDestAcls = this.currentDestAclsWithLinkId(auth, aclFilterList);
            scala.collection.immutable.Set aclsToDelete = (scala.collection.immutable.Set)currentDestAcls.diff(sourceAcls);
            scala.collection.immutable.Set aclsToAdd = (scala.collection.immutable.Set)sourceAcls.diff(currentDestAcls);
            this.trace((Function0<String> & Serializable)() -> "Removing following ACLs on destination cluster: " + aclsToDelete);
            this.trace((Function0<String> & Serializable)() -> "Adding following ACLs on destination cluster: " + aclsToAdd);
            Tuple2 tuple2 = aclsToDelete.partition((Function1<AclBinding, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncAcls.$anonfun$updateAclsOnDestination$4(x$3)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Set denyAclsToDelete = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set allowAclsToDelete = (scala.collection.immutable.Set)tuple2._2();
            Tuple2<scala.collection.immutable.Set, scala.collection.immutable.Set> tuple22 = new Tuple2<scala.collection.immutable.Set, scala.collection.immutable.Set>(denyAclsToDelete, allowAclsToDelete);
            scala.collection.immutable.Set denyAclsToDelete2 = tuple22._1();
            scala.collection.immutable.Set allowAclsToDelete2 = tuple22._2();
            Tuple2 tuple23 = aclsToAdd.partition((Function1<AclBinding, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncAcls.$anonfun$updateAclsOnDestination$5(x$5)));
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            scala.collection.immutable.Set denyAclsToAdd = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set allowAclsToAdd = (scala.collection.immutable.Set)tuple23._2();
            Tuple2<scala.collection.immutable.Set, scala.collection.immutable.Set> tuple24 = new Tuple2<scala.collection.immutable.Set, scala.collection.immutable.Set>(denyAclsToAdd, allowAclsToAdd);
            scala.collection.immutable.Set denyAclsToAdd2 = tuple24._1();
            scala.collection.immutable.Set allowAclsToAdd2 = tuple24._2();
            return this.updateAclsDenyThenAllow(taskContext, (scala.collection.immutable.Seq)denyAclsToAdd2.toSeq().$plus$plus(allowAclsToAdd2.toSeq()), allowAclsToDelete2.toSeq(), denyAclsToDelete2.toSeq());
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. No ACLs will be synced.";
            this.warn((Function0<String> & Serializable)() -> errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult addThenDeleteAclsThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<AclBinding> remainingLocalAclsToCreate, scala.collection.immutable.Seq<AclBinding> remainingAclsToDelete, ListBuffer<AclBindingFilter> aclFilterList) {
        if (remainingLocalAclsToCreate.nonEmpty()) {
            Tuple2 tuple2 = remainingLocalAclsToCreate.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toCreateNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toCreateLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple22 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toCreateNow, toCreateLater);
            scala.collection.immutable.Seq toCreateNow2 = tuple22._1();
            scala.collection.immutable.Seq toCreateLater2 = tuple22._2();
            return this.createAcls(taskContext, toCreateNow2, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.addThenDeleteAclsThenSyncAcls((ClusterLinkScheduler.TaskContext)tc, toCreateLater2, remainingAclsToDelete, aclFilterList));
        }
        if (remainingAclsToDelete.nonEmpty()) {
            Tuple2 tuple2 = remainingAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toDeleteNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toDeleteLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple23 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toDeleteNow, toDeleteLater);
            scala.collection.immutable.Seq toDeleteNow2 = tuple23._1();
            scala.collection.immutable.Seq toDeleteLater2 = tuple23._2();
            return this.deleteAcls(taskContext, toDeleteNow2, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.addThenDeleteAclsThenSyncAcls((ClusterLinkScheduler.TaskContext)tc, remainingLocalAclsToCreate, toDeleteLater2, aclFilterList));
        }
        this.initialized_$eq(true);
        return this.syncAcls(taskContext, aclFilterList);
    }

    private ClusterLinkScheduler.TaskResult updateAclsDenyThenAllow(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<AclBinding> remainingDenyAndAllowAclsToCreate, scala.collection.immutable.Seq<AclBinding> remainingAllowAclsToDelete, scala.collection.immutable.Seq<AclBinding> remainingDenyAclsToDelete) {
        boolean mergeDeletes;
        boolean bl = remainingAllowAclsToDelete.nonEmpty() || remainingDenyAclsToDelete.nonEmpty() ? this.createAclRetryBackoff().clearLimitExceededBackoff() || remainingDenyAndAllowAclsToCreate.isEmpty() : (mergeDeletes = false);
        if (mergeDeletes) {
            scala.collection.immutable.Seq allDeletes = (scala.collection.immutable.Seq)remainingAllowAclsToDelete.$plus$plus(remainingDenyAclsToDelete);
            Tuple2 tuple2 = allDeletes.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toDeleteNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toDeleteLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple22 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toDeleteNow, toDeleteLater);
            scala.collection.immutable.Seq toDeleteNow2 = tuple22._1();
            scala.collection.immutable.Seq toDeleteLater2 = tuple22._2();
            return this.deleteAcls(taskContext, toDeleteNow2, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.updateAclsDenyThenAllow((ClusterLinkScheduler.TaskContext)tc, remainingDenyAndAllowAclsToCreate, toDeleteLater2, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        }
        if (remainingAllowAclsToDelete.nonEmpty()) {
            Tuple2 tuple2 = remainingAllowAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toDeleteNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toDeleteLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple23 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toDeleteNow, toDeleteLater);
            scala.collection.immutable.Seq toDeleteNow3 = tuple23._1();
            scala.collection.immutable.Seq toDeleteLater3 = tuple23._2();
            return this.deleteAcls(taskContext, toDeleteNow3, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.updateAclsDenyThenAllow((ClusterLinkScheduler.TaskContext)tc, remainingDenyAndAllowAclsToCreate, toDeleteLater3, remainingDenyAclsToDelete));
        }
        if (remainingDenyAndAllowAclsToCreate.nonEmpty()) {
            Tuple2 tuple2 = remainingDenyAndAllowAclsToCreate.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toCreateNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toCreateLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple24 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toCreateNow, toCreateLater);
            scala.collection.immutable.Seq toCreateNow2 = tuple24._1();
            scala.collection.immutable.Seq toCreateLater2 = tuple24._2();
            return this.createAcls(taskContext, toCreateNow2, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.updateAclsDenyThenAllow((ClusterLinkScheduler.TaskContext)tc, toCreateLater2, remainingAllowAclsToDelete, remainingDenyAclsToDelete));
        }
        if (remainingDenyAclsToDelete.nonEmpty()) {
            Tuple2 tuple2 = remainingDenyAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq toDeleteNow = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq toDeleteLater = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple25 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(toDeleteNow, toDeleteLater);
            scala.collection.immutable.Seq toDeleteNow4 = tuple25._1();
            scala.collection.immutable.Seq toDeleteLater4 = tuple25._2();
            return this.deleteAcls(taskContext, toDeleteNow4, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.updateAclsDenyThenAllow((ClusterLinkScheduler.TaskContext)tc, remainingDenyAndAllowAclsToCreate, remainingAllowAclsToDelete, toDeleteLater4));
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult deleteAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<AclBinding> aclsToDelete, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        if (aclsToDelete.nonEmpty()) {
            ClusterLinkScheduler.TaskResult taskResult;
            try {
                List deleteAclsFilterList = ((IterableOnceOps)aclsToDelete.map((Function1<AclBinding, AclBindingFilter> & Serializable)acl -> acl.toFilter())).toList();
                DeleteAclsResult deleteAclsResult = this.localAdmin.deleteAcls(CollectionConverters$.MODULE$.SeqHasAsJava(deleteAclsFilterList).asJava());
                Iterable deleteAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAclsResult, callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + e);
                this.metrics.aclsDeletedSensor().record((double)aclsToDelete.size());
                taskResult = ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            return taskResult;
        }
        return callback.apply(taskContext);
    }

    public ClusterLinkScheduler.TaskResult handleAclDeleteResult(ClusterLinkScheduler.TaskContext taskContext, DeleteAclsResult deleteAclsResult, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.immutable.Seq errs = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().flatMap((Function1<Tuple2, Seq> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                $colon$colon<Nothing$> $colon$colon;
                AclBindingFilter binding = (AclBindingFilter)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)future.get();
                    java.util.List filters = filterResults.values();
                    $colon$colon = ($colon$colon<Nothing$>)CollectionConverters$.MODULE$.ListHasAsScala(filters).asScala().flatMap((Function1<DeleteAclsResult.FilterResult, Option> & Serializable)aclBindingDeleteResult -> {
                        ApiException ex = aclBindingDeleteResult.exception();
                        if (ex != null) {
                            KafkaException kafkaException;
                            this.excessiveLoggingHandler().handle(ex, this, "Encountered the following exception while trying to delete ACL: " + aclBindingDeleteResult.exception());
                            $this.metrics.aclsDeleteFailedSensor().record();
                            String errMsgPrefix = "Failed to delete ACL binding " + binding;
                            Throwable throwable = ex.getCause();
                            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                                return new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authentication issues."));
                            }
                            if (throwable instanceof AuthorizationException) {
                                return new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authorization issues."));
                            }
                            return new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsgPrefix + " for an unknown reason."));
                        }
                        $this.metrics.aclsDeletedSensor().record();
                        return None$.MODULE$;
                    });
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to delete ACL");
                    $this.metrics.aclsDeleteFailedSensor().record();
                    String errMsgPrefix = "Failed to delete ACL binding " + binding;
                    Throwable throwable = ex.getCause();
                    $colon$colon = throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authentication issues.")), Nil$.MODULE$) : (throwable instanceof AuthorizationException ? new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authorization issues.")), Nil$.MODULE$) : new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsgPrefix + " for an unknown reason.")), Nil$.MODULE$));
                }
                return $colon$colon;
            }
            throw new MatchError(tuple2);
        })).toSeq();
        if (errs.nonEmpty()) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(this.logIdent() + "Failed to delete ACLs but there are still " + this.tasksOutstanding());
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(errs));
        }
        return callback.apply(taskContext);
    }

    private ClusterLinkScheduler.TaskResult createAcls(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<AclBinding> newAcls, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        Tuple2<scala.collection.immutable.Seq<AclBinding>, scala.collection.immutable.Seq<TaskErrorCodeAndMsg>> tuple2 = this.createAclRetryBackoff().filterCreatableAcls(newAcls, super.time().milliseconds());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq<AclBinding> aclsToCreate = tuple2._1();
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> filteredAclErrors = tuple2._2();
        Tuple2<scala.collection.immutable.Seq<AclBinding>, scala.collection.immutable.Seq<TaskErrorCodeAndMsg>> tuple22 = new Tuple2<scala.collection.immutable.Seq<AclBinding>, scala.collection.immutable.Seq<TaskErrorCodeAndMsg>>(aclsToCreate, filteredAclErrors);
        scala.collection.immutable.Seq<AclBinding> aclsToCreate2 = tuple22._1();
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> filteredAclErrors2 = tuple22._2();
        if (aclsToCreate2.nonEmpty()) {
            ClusterLinkScheduler.TaskResult taskResult;
            try {
                List aclsToCreateList = aclsToCreate2.toList();
                CreateAclsResult createAclResult = this.localAdmin.createAcls(CollectionConverters$.MODULE$.SeqHasAsJava(aclsToCreateList).asJava());
                Map values = createAclResult.values();
                Iterable createAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(values).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAclCreateResult((ClusterLinkScheduler.TaskContext)tc, createAclResult, filteredAclErrors2, callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate2.size());
                taskResult = ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
            return taskResult;
        }
        if (filteredAclErrors2.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)taskContext.errs().$plus$plus(filteredAclErrors2));
        }
        return callback.apply(taskContext);
    }

    private ClusterLinkScheduler.TaskResult handleAclCreateResult(ClusterLinkScheduler.TaskContext taskContext, CreateAclsResult createAclsResult, scala.collection.immutable.Seq<TaskErrorCodeAndMsg> filteredAclErrors, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callBack) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.mutable.Set invalidResourceAcls = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.immutable.Seq errs = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(createAclsResult.values()).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                AclBinding binding = (AclBinding)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    future.get();
                    $this.metrics.aclsAddedSensor().record();
                    option = None$.MODULE$;
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    $this.metrics.aclsAddFailedSensor().record();
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to create ACL");
                    String errMsgPrefix = "Failed to create ACL binding " + binding;
                    boolean bl = false;
                    InvalidRequestException invalidRequestException = null;
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authentication issues."));
                    }
                    if (throwable instanceof AuthorizationException) {
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, errMsgPrefix + " due to authorization issues."));
                    }
                    if (throwable instanceof InvalidRequestException) {
                        bl = true;
                        invalidRequestException = (InvalidRequestException)throwable;
                        if (invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("ACLs not created since it will exceed the limit")) {
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, errMsgPrefix + " due to reaching the ACL limit on the destination cluster."));
                        }
                    }
                    if (bl && invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("Could not create ACLs because following resource names are invalid")) {
                        invalidResourceAcls.$plus$eq(binding);
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, errMsgPrefix + " due to the ACL resource name(s) being invalid."));
                    }
                    option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsgPrefix + " for an unknown reason."));
                }
                return option;
            }
            throw new MatchError(tuple2);
        })).toSeq();
        if (errs.nonEmpty() || filteredAclErrors.nonEmpty()) {
            if (errs.nonEmpty()) {
                this.warn((Function0<String> & Serializable)() -> "Failed to create " + errs.size() + " ACLs.");
            }
            if (filteredAclErrors.nonEmpty()) {
                this.debug((Function0<String> & Serializable)() -> "Filtered out " + filteredAclErrors.size() + " ACLs from create list due to backoff.");
            }
            int limitExceeded = errs.count((Function1<TaskErrorCodeAndMsg, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$4(x$14)));
            this.createAclRetryBackoff().update(invalidResourceAcls, limitExceeded, filteredAclErrors);
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(this.logIdent() + "Failed to create ACLs but there are still " + this.tasksOutstanding());
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((scala.collection.immutable.Seq)((IterableOps)taskContext.errs().$plus$plus(errs)).$plus$plus(filteredAclErrors));
        }
        return callBack.apply(taskContext);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.info((Function0<String> & Serializable)() -> "Task " + this.getClass().getName() + " shutting down");
    }

    public int currentTasksOutstanding() {
        return this.tasksOutstanding();
    }

    public void tasksOutstanding_(int t) {
        this.tasksOutstanding_$eq(t);
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        boolean clearExcessiveLoggingHandler = this.setTaskStateFromResult(result);
        if (clearExcessiveLoggingHandler) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    private boolean setTaskStateFromResult(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.metadataManager().isLinkCoordinator(this.linkData().linkName())) {
            if (this.config().aclSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncAclsTaskType$.MODULE$, false, "run the sync acls task"));
                Option<TaskDescription> option = this.taskDesc();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskDescription td = (TaskDescription)some.value();
                    TaskState taskState = td.state();
                    ActiveTaskState$ activeTaskState$ = ActiveTaskState$.MODULE$;
                    return !(taskState != null ? !taskState.equals(activeTaskState$) : activeTaskState$ != null);
                }
                return false;
            }
            this.taskDesc_$eq(new Some<TaskDescription>(new TaskDescription(NotConfiguredTaskState$.MODULE$, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())));
            return true;
        }
        this.taskDesc_$eq(None$.MODULE$);
        return true;
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public ExcessiveLoggingHandler loggingHandler() {
        return this.excessiveLoggingHandler();
    }

    public Tuple2<Object, Option<Object>> retryState() {
        return new Tuple2<Object, Option<Object>>(BoxesRunTime.boxToInteger(this.createAclRetryBackoff().retryAttempts()), this.createAclRetryBackoff().nextRetryMs());
    }

    public static final /* synthetic */ boolean $anonfun$updateAclsOnDestination$4(AclBinding x$3) {
        AclPermissionType aclPermissionType = x$3.entry().permissionType();
        AclPermissionType aclPermissionType2 = AclPermissionType.DENY;
        return !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateAclsOnDestination$5(AclBinding x$5) {
        AclPermissionType aclPermissionType = x$5.entry().permissionType();
        AclPermissionType aclPermissionType2 = AclPermissionType.DENY;
        return !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleAclCreateResult$4(TaskErrorCodeAndMsg x$14) {
        TaskErrorCode taskErrorCode = x$14.code();
        AclLimitExceededTaskErrorCode$ aclLimitExceededTaskErrorCode$ = AclLimitExceededTaskErrorCode$.MODULE$;
        return !(taskErrorCode != null ? !taskErrorCode.equals(aclLimitExceededTaskErrorCode$) : aclLimitExceededTaskErrorCode$ != null);
    }

    public ClusterLinkSyncAcls(ClusterLinkDestClientManager clientManager, ClusterLinkData linkData, ClusterLinkMetadataManager metadataManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, AclBindingFilterTransformer aclBindingFilterTransformer, Time time, ClusterLinkRequestQuota quota, boolean aclFilterWithResourceIdPrincipal, int batchSize) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.aclFilterWithResourceIdPrincipal = aclFilterWithResourceIdPrincipal;
        this.batchSize = batchSize;
        super(clientManager.scheduler(), "ClusterLinkSyncAcls", Predef$.MODULE$.Integer2int(clientManager.currentConfig().aclSyncMs()), time, quota);
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-" + linkData.linkName() + "] ");
        this.config = clientManager.currentConfig();
        this.linkId = linkData.linkId();
        this.aclLinkIdSet = Collections.singleton(this.linkId());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.createAclRetryBackoff = new CreateAclRetryBackoff(this, this.config().aclSyncBackoff());
    }

    private class CreateAclRetryBackoff {
        private final ExponentialBackoff backoff;
        private int retryAttempts;
        private Option<Object> nextRetryMs;
        private Option<Object> limitViolatedAclCount;
        private final scala.collection.mutable.Set<AclBinding> invalidResourceAcls;
        public final /* synthetic */ ClusterLinkSyncAcls $outer;

        public int retryAttempts() {
            return this.retryAttempts;
        }

        public void retryAttempts_$eq(int x$1) {
            this.retryAttempts = x$1;
        }

        public Option<Object> nextRetryMs() {
            return this.nextRetryMs;
        }

        public void nextRetryMs_$eq(Option<Object> x$1) {
            this.nextRetryMs = x$1;
        }

        private Option<Object> limitViolatedAclCount() {
            return this.limitViolatedAclCount;
        }

        private void limitViolatedAclCount_$eq(Option<Object> x$1) {
            this.limitViolatedAclCount = x$1;
        }

        private scala.collection.mutable.Set<AclBinding> invalidResourceAcls() {
            return this.invalidResourceAcls;
        }

        public void update(scala.collection.mutable.Set<AclBinding> notCreatedInvalidResourceAcls, int notCreatedDueToLimit, scala.collection.immutable.Seq<TaskErrorCodeAndMsg> filteredAclErrors) {
            if (!this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().isInitialized()) {
                return;
            }
            if (notCreatedDueToLimit == 0 && notCreatedInvalidResourceAcls.isEmpty() && filteredAclErrors.isEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Clearing retry state after successful update");
                this.retryAttempts_$eq(0);
                this.nextRetryMs_$eq(None$.MODULE$);
            }
            if (notCreatedDueToLimit > 0) {
                this.limitViolatedAclCount_$eq(this.limitViolatedAclCount().map(x$15 -> x$15 + notCreatedDueToLimit).orElse((Function0<Some> & Serializable)() -> new Some<Integer>(BoxesRunTime.boxToInteger(notCreatedDueToLimit))));
                this.maybeIncrementBackoff();
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().info((Function0<String> & Serializable)() -> "Failed to create " + notCreatedDueToLimit + " ACLs due to ACL limit, ACL creation will be retried with exponential backoff for attempt #" + this.retryAttempts() + " or when ACL count reduces.");
            }
            if (notCreatedInvalidResourceAcls.nonEmpty()) {
                this.invalidResourceAcls().$plus$plus$eq(notCreatedInvalidResourceAcls);
                this.maybeIncrementBackoff();
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().info((Function0<String> & Serializable)() -> "Failed to create " + notCreatedInvalidResourceAcls + " ACLs due to invalid resources, Creation of these ACLs will be retried after exponential backoff for attempt #" + this.retryAttempts() + ".");
                return;
            }
        }

        public Tuple2<scala.collection.immutable.Seq<AclBinding>, scala.collection.immutable.Seq<TaskErrorCodeAndMsg>> filterCreatableAcls(scala.collection.immutable.Seq<AclBinding> aclsToCreate, long now) {
            if (this.nextRetryMs().isEmpty()) {
                return new Tuple2<scala.collection.immutable.Seq<AclBinding>, Object>(aclsToCreate, package$.MODULE$.Seq().empty());
            }
            if (now >= BoxesRunTime.unboxToLong(this.nextRetryMs().get())) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Clearing retry backoff state for ACL creation since backoff interval has elapsed.");
                this.clear();
                return new Tuple2<scala.collection.immutable.Seq<AclBinding>, Object>(aclsToCreate, package$.MODULE$.Seq().empty());
            }
            if (this.limitViolatedAclCount().exists(x$16 -> x$16 > aclsToCreate.size())) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Clearing retry backoff state for limit exceeded error for ACL creation since new ACL count has reduced from " + this.limitViolatedAclCount().get() + " to " + aclsToCreate.size() + ".");
                this.clear();
                return new Tuple2<scala.collection.immutable.Seq<AclBinding>, Object>(aclsToCreate, package$.MODULE$.Seq().empty());
            }
            if (this.limitViolatedAclCount().nonEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Not creating ACLs due to limit exceeded retry backoff for " + (BoxesRunTime.unboxToLong(this.nextRetryMs().get()) - now) + " more milliseconds.");
                return new Tuple2(package$.MODULE$.Seq().empty(), aclsToCreate.map((Function1<AclBinding, TaskErrorCodeAndMsg> & Serializable)binding -> new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, "Failed to create ACL binding " + binding + " due to reaching the ACL limit on the destination cluster.")));
            }
            Tuple2 tuple2 = aclsToCreate.partition((Function1<AclBinding, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(CreateAclRetryBackoff.$anonfun$filterCreatableAcls$6(this, elem)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq invalid = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq creatable = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple22 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(invalid, creatable);
            scala.collection.immutable.Seq invalid2 = tuple22._1();
            scala.collection.immutable.Seq creatable2 = tuple22._2();
            if (aclsToCreate.size() > creatable2.size()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Not creating " + (aclsToCreate.size() - creatable2.size()) + " ACLs due to invalid request retry backoff for " + (BoxesRunTime.unboxToLong(this.nextRetryMs().get()) - now) + " more milliseconds..");
            }
            return new Tuple2<scala.collection.immutable.Seq<AclBinding>, scala.collection.immutable.Seq<TaskErrorCodeAndMsg>>(creatable2, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)invalid2.map((Function1<AclBinding, TaskErrorCodeAndMsg> & Serializable)binding -> new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, "Failed to create ACL binding " + binding + " due to the ACL resource name(s) being invalid.")));
        }

        private void maybeIncrementBackoff() {
            long now = this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().kafka$server$link$ClusterLinkSyncAcls$$super$time().milliseconds();
            if (this.nextRetryMs().forall(x$18 -> x$18 <= now)) {
                long nextBackoff = this.backoff.backoff((long)this.retryAttempts());
                this.nextRetryMs_$eq(new Some<Object>(BoxesRunTime.boxToLong(now + nextBackoff)));
                this.retryAttempts_$eq(this.retryAttempts() + 1);
                return;
            }
        }

        public boolean clearLimitExceededBackoff() {
            if (this.limitViolatedAclCount().nonEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String> & Serializable)() -> "Clearing retry backoff due to ACL limit since source ACLs have been deleted");
                this.clear();
                return true;
            }
            return false;
        }

        private void clear() {
            this.limitViolatedAclCount_$eq(None$.MODULE$);
            this.invalidResourceAcls().clear();
        }

        public /* synthetic */ ClusterLinkSyncAcls kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$filterCreatableAcls$6(CreateAclRetryBackoff $this, AclBinding elem) {
            return $this.invalidResourceAcls().contains(elem);
        }

        public CreateAclRetryBackoff(ClusterLinkSyncAcls $outer, ExponentialBackoff backoff) {
            this.backoff = backoff;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.retryAttempts = 0;
            this.nextRetryMs = None$.MODULE$;
            this.limitViolatedAclCount = None$.MODULE$;
            this.invalidResourceAcls = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        }
    }
}

