/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSyncOffsets$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LocalAndRemoteMirrorTopic;
import kafka.server.link.LocalMirrorTopic;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.RegularTopic;
import kafka.server.link.RemoteLinkMetadata;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorTopic;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicType$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u001dt!\u0002\u001d:\u0011\u0003\u0001e!\u0002\":\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005b\u0002'\u0002\u0005\u0004%\t!\u0014\u0005\u0007#\u0006\u0001\u000b\u0011\u0002(\t\u000fI\u000b!\u0019!C\u0001'\"1\u0011-\u0001Q\u0001\nQ+AAY\u0001\u0001G\u001a)!)\u000f\u0001\u0002\u0010!Q\u0011q\u0004\u0005\u0003\u0006\u0004%\t!!\t\t\u0015\u0005%\u0002B!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002,!\u0011)\u0019!C\u0001\u0003[A!\"!\u000e\t\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\t9\u0004\u0003B\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u007fA!\u0011!Q\u0001\n\u0005\u0005\u0003BCA$\u0011\t\u0005\t\u0015!\u0003\u0002B!Q\u0011\u0011\n\u0005\u0003\u0002\u0003\u0006I!a\u0013\t\u0019\u0005E\u0003B!A!\u0002\u0013\t\u0019&a\u0018\t\u0019\u0005\u0005\u0004B!A!\u0002\u0013\t\u0019'a\u001b\t\r)CA\u0011AA7\u0011%\t\t\t\u0003a\u0001\n\u0013\t\u0019\tC\u0005\u0002\f\"\u0001\r\u0011\"\u0003\u0002\u000e\"A\u0011\u0011\u0014\u0005!B\u0013\t)\t\u0003\u0005\u0002\u001c\"\u0001\r\u0011\"\u0003N\u0011%\ti\n\u0003a\u0001\n\u0013\ty\nC\u0004\u0002$\"\u0001\u000b\u0015\u0002(\t\u0013\u0005\u0015\u0006\u00021A\u0005\n\u0005\u001d\u0006\"CA[\u0011\u0001\u0007I\u0011BA\\\u0011!\tY\f\u0003Q!\n\u0005%\u0006\"CA_\u0011\u0001\u0007I\u0011BA`\u0011%\tI\r\u0003a\u0001\n\u0013\tY\r\u0003\u0005\u0002P\"\u0001\u000b\u0015BAa\u0011%\tI\u000e\u0003b\u0001\n\u0013\tY\u000e\u0003\u0005\u0002d\"\u0001\u000b\u0011BAo\u0011\u001d\t)\u000f\u0003C)\u0003ODq!!@\t\t\u0013\ty\u0010C\u0004\u0003\f!!IA!\u0004\t\u000f\tE\u0001\u0002\"\u0003\u0003\u0014!9!q\u0006\u0005\u0005\n\tE\u0002b\u0002B \u0011\u0011%!\u0011\t\u0005\b\u0005\u001fBA\u0011\u0002B)\u0011\u001d\u0011y\u0006\u0003C\u0005\u0005CBqA!\u001b\t\t\u0013\u0011Y\u0007C\u0004\u0003p!!IA!\u001d\t\u000f\t\u0005\u0005\u0002\"\u0003\u0003\u0004\"9!q\u0012\u0005\u0005\n\tE\u0005b\u0002B`\u0011\u0011%!\u0011\u0019\u0005\b\u0005;DA\u0011\u0002Bp\u0011\u001d\u0011\t\u0010\u0003C\u0005\u0005gDqA!@\t\t\u0013\u0011y\u0010C\u0004\u0004\u0012!!Iaa\u0005\t\u000f\r\u001d\u0002\u0002\"\u0003\u0004*!9!q\u000e\u0005\u0005\u0012\r\r\u0003bBB*\u0011\u0011%1Q\u000b\u0005\b\u0007/BA\u0011KB-\u0011\u001d\u0019\u0019\u0007\u0003C!\u0007K\nac\u00117vgR,'\u000fT5oWNKhnY(gMN,Go\u001d\u0006\u0003um\nA\u0001\\5oW*\u0011A(P\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003y\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002B\u00035\t\u0011H\u0001\fDYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t'\t\tA\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u000b\u0001\u0005T5ti\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;CCR\u001c\u0007nU5{KV\ta\n\u0005\u0002F\u001f&\u0011\u0001K\u0012\u0002\u0004\u0013:$\u0018!\t'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u\u0005\u0006$8\r[*ju\u0016\u0004\u0013a\u0007'jgR|eMZ:fiN4uN]!mYB\u000b'\u000f^5uS>t7/F\u0001U!\t)v,D\u0001W\u0015\t9\u0006,A\u0003bI6LgN\u0003\u0002Z5\u000691\r\\5f]R\u001c(B\u0001 \\\u0015\taV,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0006\u0019qN]4\n\u0005\u00014&\u0001\b'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ugN\u0003XmY\u0001\u001d\u0019&\u001cHo\u00144gg\u0016$8OR8s\u00032d\u0007+\u0019:uSRLwN\\:!\u00055yeMZ:fi\u001a+H/\u001e:fgB!Am\u001b8r\u001d\t)\u0017\u000e\u0005\u0002g\r6\tqM\u0003\u0002i\u007f\u00051AH]8pizJ!A\u001b$\u0002\rA\u0013X\rZ3g\u0013\taWNA\u0002NCBT!A\u001b$\u0011\u0005\u0005{\u0017B\u00019:\u00051i\u0015\r^2iK\u0012<%o\\;q!\r\u0011Xo^\u0007\u0002g*\u0011AOW\u0001\u0007G>lWn\u001c8\n\u0005Y\u001c(aC&bM.\fg)\u001e;ve\u0016\u0004R\u0001_?\u007f\u0003\u0007i\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u00017z!\t\u0011x0C\u0002\u0002\u0002M\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001W\u0001\tG>t7/^7fe&!\u0011QBA\u0004\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/Y\n\u0004\u0011\u0005E\u0001\u0003BA\n\u00033q1!QA\u000b\u0013\r\t9\"O\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\t\u0005m\u0011Q\u0004\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0004\u0003/I\u0014!D2mS\u0016tG/T1oC\u001e,'/\u0006\u0002\u0002$A\u0019\u0011)!\n\n\u0007\u0005\u001d\u0012H\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u00020A\u0019\u0011)!\r\n\u0007\u0005M\u0012H\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA.\u001b8l\t\u0006$\u0018\rE\u0002B\u0003wI1!!\u0010:\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017a\u0003:f[>$X-\u00113nS:\u00042!QA\"\u0013\r\t)%\u000f\u0002\u0016\u00072,8\u000f^3s\u0019&t7NQ1uG\"\fE-\\5o\u0003)awnY1m\u0003\u0012l\u0017N\\\u0001\b[\u0016$(/[2t!\r\t\u0015QJ\u0005\u0004\u0003\u001fJ$AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\fA\u0001^5nKB!\u0011QKA.\u001b\t\t9FC\u0002\u0002ZM\fQ!\u001e;jYNLA!!\u0018\u0002X\t!A+[7f\u0013\u0011\t\t&!\u0007\u0002\u000bE,x\u000e^1\u0011\t\u0005\u0015\u0014qM\u0007\u0002w%\u0019\u0011\u0011N\u001e\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017\u0002BA1\u00033!\"#a\u001c\u0002r\u0005M\u0014QOA<\u0003s\nY(! \u0002\u0000A\u0011\u0011\t\u0003\u0005\b\u0003?\u0019\u0002\u0019AA\u0012\u0011\u001d\tYc\u0005a\u0001\u0003_Aq!a\u000e\u0014\u0001\u0004\tI\u0004C\u0004\u0002@M\u0001\r!!\u0011\t\u000f\u0005\u001d3\u00031\u0001\u0002B!9\u0011\u0011J\nA\u0002\u0005-\u0003bBA)'\u0001\u0007\u00111\u000b\u0005\b\u0003C\u001a\u0002\u0019AA2\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u0011\t\u0004\u0003\u0006\u001d\u0015bAAEs\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0006U\u0005cA#\u0002\u0012&\u0019\u00111\u0013$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003/+\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0002)Q\f7o[:PkR\u001cH/\u00198eS:<w\fJ3r)\u0011\ty)!)\t\u0011\u0005]\u0005$!AA\u00029\u000b\u0011\u0003^1tWN|U\u000f^:uC:$\u0017N\\4!\u0003I\u0011X-\\8uK2Kgn['fi\u0006$\u0017\r^1\u0016\u0005\u0005%\u0006#B#\u0002,\u0006=\u0016bAAW\r\n1q\n\u001d;j_:\u00042!QAY\u0013\r\t\u0019,\u000f\u0002\u0013%\u0016lw\u000e^3MS:\\W*\u001a;bI\u0006$\u0018-\u0001\fsK6|G/\u001a'j].lU\r^1eCR\fw\fJ3r)\u0011\ty)!/\t\u0013\u0005]5$!AA\u0002\u0005%\u0016a\u0005:f[>$X\rT5oW6+G/\u00193bi\u0006\u0004\u0013\u0001\u0003;bg.$Um]2\u0016\u0005\u0005\u0005\u0007#B#\u0002,\u0006\r\u0007cA!\u0002F&\u0019\u0011qY\u001d\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\fA\u0002^1tW\u0012+7oY0%KF$B!a$\u0002N\"I\u0011q\u0013\u0010\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\ni\u0006\u001c8\u000eR3tG\u0002B3aHAj!\r)\u0015Q[\u0005\u0004\u0003/4%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002-\u0011,7o\u0019:jE\u0016l\u0015N\u001d:peN|\u0005\u000f^5p]N,\"!!8\u0011\u0007U\u000by.C\u0002\u0002bZ\u0013a\u0003R3tGJL'-Z'jeJ|'o](qi&|gn]\u0001\u0018I\u0016\u001c8M]5cK6K'O]8sg>\u0003H/[8og\u0002\n1A];o)\t\tI\u000f\u0005\u0003\u0002l\u0006eh\u0002BAw\u0003+qA!a<\u0002x:!\u0011\u0011_A{\u001d\r1\u00171_\u0005\u0002}%\u0011A(P\u0005\u0003umJA!a?\u0002\u001e\tQA+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0017MLhnY(gMN,Go\u001d\u000b\u0005\u0003S\u0014\t\u0001C\u0004\u0003\u0004\r\u0002\rA!\u0002\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0003W\u00149!\u0003\u0003\u0003\n\u0005u!a\u0003+bg.\u001cuN\u001c;fqR\fa\u0006\u001e:z\u0013:LG/[1mSj,'+Z7pi\u0016l\u0015N\u001d:peNKhnY5oO\u0006sGmU=oG>3gm]3ugR!\u0011\u0011\u001eB\b\u0011\u001d\u0011\u0019\u0001\na\u0001\u0005\u000b\t1\t[1oI2,G)Z:de&\u0014WmQ8oM&<7OU3ta>t7/\u001a+p\u0013:LG/[1mSj,'+Z7pi\u0016l\u0015N\u001d:peNKhnY5oO\u0006sGmU=oGRA\u0011\u0011\u001eB\u000b\u0005/\u0011)\u0003C\u0004\u0003\u0004\u0015\u0002\rA!\u0002\t\u000f\teQ\u00051\u0001\u0003\u001c\u0005A!/Z:pkJ\u001cW\r\u0005\u0003\u0003\u001e\t\u0005RB\u0001B\u0010\u0015\r\t\ti]\u0005\u0005\u0005G\u0011yB\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000f\t\u001dR\u00051\u0001\u0003*\u00051!/Z:vYR\u00042!\u0016B\u0016\u0013\r\u0011iC\u0016\u0002\u0016\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+7/\u001e7u\u0003yA\u0017M\u001c3mK2K7\u000f^\"p]N,X.\u001a:He>,\bo\u001d*fgVdG\u000f\u0006\u0004\u0002j\nM\"Q\u0007\u0005\b\u0005\u00071\u0003\u0019\u0001B\u0003\u0011\u001d\u00119D\na\u0001\u0005s\t\u0001\u0004\\5ti\u000e{gn];nKJ<%o\\;qgJ+7/\u001e7u!\r)&1H\u0005\u0004\u0005{1&\u0001\u0007'jgR\u001cuN\\:v[\u0016\u0014xI]8vaN\u0014Vm];mi\u0006!\u0002.\u00198eY\u00164\u0015\u000e\u001c;fe\u0016$wI]8vaN$b!!;\u0003D\t\u0015\u0003b\u0002B\u0002O\u0001\u0007!Q\u0001\u0005\b\u0005\u000f:\u0003\u0019\u0001B%\u000391\u0017\u000e\u001c;fe\u0016$wI]8vaN\u0004B\u0001\u001aB&]&\u0019!QJ7\u0003\u0007M+G/\u0001\u000bgS2$XM]\"p]N,X.\u001a:He>,\bo\u001d\u000b\u0005\u0005\u0013\u0012\u0019\u0006C\u0004\u0003V!\u0002\rAa\u0016\u0002\r\u001d\u0014x.\u001e9t!\u0015!'1\nB-!\r!'1L\u0005\u0004\u0005;j'AB*ue&tw-\u0001\u000fmSN$H)Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\t\r$q\r\t\u0004\u0005K:abAAw\u0001!9!QK\u0015A\u0002\t%\u0013A\b7jgR\u001cv.\u001e:dK\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;t)\u0011\u0011\u0019G!\u001c\t\u000f\tU#\u00061\u0001\u0003J\u0005AB.[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\u0011\t\r$1\u000fB;\u0005oBqA!\u0016,\u0001\u0004\u0011I\u0005\u0003\u0004XW\u0001\u0007\u0011\u0011\t\u0005\b\u0005sZ\u0003\u0019\u0001B>\u0003!I7oU8ve\u000e,\u0007cA#\u0003~%\u0019!q\u0010$\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0002.\u00198eY\u0016\u001cv.\u001e:dK\u0006sG\rR3ti>3gm]3ugRA\u0011\u0011\u001eBC\u0005\u000f\u0013Y\tC\u0004\u0003\u00041\u0002\rA!\u0002\t\u000f\t%E\u00061\u0001\u0003d\u0005\u00192o\\;sG\u0016|eMZ:fi\u001a+H/\u001e:fg\"9!Q\u0012\u0017A\u0002\t\r\u0014!\u00053fgR|eMZ:fi\u001a+H/\u001e:fg\u0006\u0001T.\u00199U_BL7\rU1si&$\u0018n\u001c8U_\u000e{W.\\5ui\u0016$wJ\u001a4tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:$bAa%\u0003\u001e\n\u0015\u0006C\u00023l\u00053\u0012)\n\u0005\u0004eW\n]\u00151\u0001\t\u0004\u0003\ne\u0015b\u0001BNs\ti2i\\7nSR$X\rZ(gMN,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003 6\u0002\rA!)\u0002\u001bM|WO]2f\u001f\u001a47/\u001a;t!\u0015!7N\u001cBR!\u0015!7N`A\u0002\u0011\u001d\t)+\fa\u0001\u0005O\u0003r!\u0012BU\u0005[\u0013i,C\u0002\u0003,\u001a\u0013a\u0001V;qY\u0016\u0014\u0004C\u00023l\u00053\u0012y\u000b\u0005\u0003\u00032\n]fbA+\u00034&\u0019!Q\u0017,\u0002-5K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:LAA!/\u0003<\n)1\u000b^1uK*\u0019!Q\u0017,\u0011\u000b\u0015\u000bYK!\u0017\u0002+!\fg\u000e\u001a7f\t\u0016\u001c8M]5cK6K'O]8sgRa\u0011\u0011\u001eBb\u0005\u000b\u00149Ma3\u0003Z\"9!1\u0001\u0018A\u0002\t\u0015\u0001b\u0002BP]\u0001\u0007!\u0011\u0015\u0005\b\u0005\u0013t\u0003\u0019\u0001BQ\u0003-!Wm\u001d;PM\u001a\u001cX\r^:\t\u000f\t5g\u00061\u0001\u0003P\u0006)B-Z:de&\u0014W-T5se>\u00148OR;ukJ,\u0007C\u00023l\u00053\u0012\t\u000e\u0005\u0003sk\nM\u0007cA+\u0003V&\u0019!q\u001b,\u0003-5K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:DqAa7/\u0001\u0004\u0011i,\u0001\u0007sK6|G/\u001a)sK\u001aL\u00070A\u0010u_\u000e{W.\\5ui\u0016$wJ\u001a4tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\"Ba&\u0003b\n\u0015(\u0011\u001eBx\u0011\u0019\u0011\u0019o\fa\u0001]\u0006)qM]8va\"1!q]\u0018A\u0002y\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003l>\u0002\rA!<\u0002-I,Wn\u001c;f\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u0004R!RAV\u0005_CqAa70\u0001\u0004\u0011i,A\u0007d_6l\u0017\u000e^(gMN,Go\u001d\u000b\t\u0003S\u0014)Pa>\u0003z\"9!1\u0001\u0019A\u0002\t\u0015\u0001b\u0002BPa\u0001\u0007!1\u0013\u0005\b\u0005\u0013\u0004\u0004\u0019\u0001B~!\u0019!7N!\u0017\u0003$\u0006A\u0003.\u00198eY\u0016$Um\u001d;j]\u0006$\u0018n\u001c8DYV\u001cH/\u001a:D_6l\u0017\u000e\u001e;fI>3gm]3ugRA\u0011\u0011^B\u0001\u0007\u0007\u0019y\u0001C\u0004\u0003\u0004E\u0002\rA!\u0002\t\u000f\r\u0015\u0011\u00071\u0001\u0004\b\u0005i1m\\7nSR\u0014Vm];miN\u0004b\u0001Z6\u0003Z\r%\u0001cA+\u0004\f%\u00191Q\u0002,\u0003?\u0005cG/\u001a:D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d*fgVdG\u000fC\u0004\u0003 F\u0002\rAa%\u0002\u000f=4gm]3ugRA1QCB\u0010\u0007C\u0019)\u0003E\u0004F\u0005S\u0013\u0019ka\u0006\u0011\u000b\u0015\u000bYk!\u0007\u0011\u0007\u0005\u001bY\"C\u0002\u0004\u001ee\u00121\u0003V1tW\u0016\u0013(o\u001c:D_\u0012,\u0017I\u001c3Ng\u001eDqAa93\u0001\u0004\u0011I\u0006\u0003\u0004\u0004$I\u0002\r!]\u0001\u0007MV$XO]3\t\u000f\te$\u00071\u0001\u0003|\u0005\trN\u001a4tKR4U\r^2i\r\u0006LG.\u001a3\u0015\r\u0005=51FB\u0017\u0011\u001d\u0011Ih\ra\u0001\u0005wBqaa\f4\u0001\u0004\u0019\t$A\u0001f!\u0011\u0019\u0019d!\u0010\u000f\t\rU2\u0011\b\b\u0004M\u000e]\u0012\"A$\n\u0007\rmb)A\u0004qC\u000e\\\u0017mZ3\n\t\r}2\u0011\t\u0002\n)\"\u0014xn^1cY\u0016T1aa\u000fG)\u0019\u0019)ea\u0013\u0004NA\u0019Qka\u0012\n\u0007\r%cK\u0001\u0010MSN$8i\u001c8tk6,'o\u0012:pkB|eMZ:fiN\u0014Vm];mi\"1q\u000b\u000ea\u0001\u0003\u0003Bqaa\u00145\u0001\u0004\u0019\t&\u0001\u0006he>,\bo\u00159fGN\u0004R\u0001_?\u0003ZQ\u000b\u0001eY8oM&<WO]3e)>Len\u00197vI\u0016\u0014V-\\8uK6K'O]8sgV\u0011!1P\u0001\r_:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u0003\u001f\u001bY\u0006C\u0004\u0003(Y\u0002\ra!\u0018\u0011\t\u0005-8qL\u0005\u0005\u0007C\niBA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\buCN\\G)Z:de&\u0004H/[8o)\t\t\t\r")
public class ClusterLinkSyncOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private int tasksOutstanding;
    private Option<RemoteLinkMetadata> remoteLinkMetadata;
    private volatile Option<TaskDescription> taskDesc;
    private final DescribeMirrorsOptions describeMirrorsOptions;

    public static ListConsumerGroupOffsetsSpec ListOffsetsForAllPartitions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions();
    }

    public static int ListConsumerGroupOffsetBatchSize() {
        return ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private Option<RemoteLinkMetadata> remoteLinkMetadata() {
        return this.remoteLinkMetadata;
    }

    private void remoteLinkMetadata_$eq(Option<RemoteLinkMetadata> x$1) {
        this.remoteLinkMetadata = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private DescribeMirrorsOptions describeMirrorsOptions() {
        return this.describeMirrorsOptions;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().consumerOffsetSyncEnable()) {
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String> & Serializable)() -> "Number of outstanding tasks was " + this.tasksOutstanding() + " at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isEmpty()) {
                return this.tryInitializeRemoteMirrorSyncingAndSyncOffsets(taskContext);
            }
            return this.syncOffsets(taskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult syncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.config().consumerGroupFilters().isEmpty()) {
            String errMsg = ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp() + " is true but no consumer group filters are specified. No consumer offsets will be migrated.";
            this.warn((Function0<String> & Serializable)() -> errMsg);
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        this.debug((Function0<String> & Serializable)() -> "Attempting to retrieve consumer groups from source cluster");
        ListConsumerGroupsResult listConsumerGroupsResult = this.remoteAdmin.listConsumerGroups();
        this.scheduleWhenComplete(listConsumerGroupsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleListConsumerGroupsResult((ClusterLinkScheduler.TaskContext)tc, listConsumerGroupsResult);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult tryInitializeRemoteMirrorSyncingAndSyncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkData.linkName());
        DescribeConfigsResult result = this.remoteAdmin.describeConfigs(CollectionConverters$.MODULE$.SeqHasAsJava(new $colon$colon<Nothing$>((Nothing$)resource, Nil$.MODULE$)).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync((ClusterLinkScheduler.TaskContext)tc, resource, result);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync(ClusterLinkScheduler.TaskContext taskContext, ConfigResource resource, DescribeConfigsResult result) {
        KafkaFuture configFuture = (KafkaFuture)result.values().get(resource);
        if (configFuture == null) {
            throw new IllegalStateException("Failed to find link " + this.linkData.linkName() + " in the response.");
        }
        Tuple2 tuple2 = this.liftedTree1$1(configFuture);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option configOpt = (Option)tuple2._1();
        Seq errs = (Seq)tuple2._2();
        Tuple2<Option, Seq> tuple22 = new Tuple2<Option, Seq>(configOpt, errs);
        Option configOpt2 = tuple22._1();
        Seq errs2 = tuple22._2();
        configOpt2.foreach((Function1<Config, Object> & Serializable)linkConfig -> {
            ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$3(this, linkConfig);
            return BoxedUnit.UNIT;
        });
        return this.syncOffsets(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs2)));
    }

    private ClusterLinkScheduler.TaskResult handleListConsumerGroupsResult(ClusterLinkScheduler.TaskContext taskContext, ListConsumerGroupsResult listConsumerGroupsResult) {
        Option errOpt;
        Tuple2 tuple2 = this.liftedTree2$1(listConsumerGroupsResult, taskContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Collection consumerGroupListing = (Collection)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Collection, Option> tuple22 = new Tuple2<Collection, Option>(consumerGroupListing, errOpt2);
        Collection consumerGroupListing2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkScheduler.TaskResult err = (ClusterLinkScheduler.TaskResult)some.value();
            return err;
        }
        if (None$.MODULE$.equals(option)) {
            Set<MatchedGroup> filteredGroups = this.filterConsumerGroups(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(consumerGroupListing2).asScala().map((Function1<ConsumerGroupListing, String> & Serializable)x$6 -> x$6.groupId())).toSet());
            return this.handleFilteredGroups(taskContext, filteredGroups);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult handleFilteredGroups(ClusterLinkScheduler.TaskContext taskContext, Set<MatchedGroup> filteredGroups) {
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures = this.listDestConsumerGroupOffsets(filteredGroups);
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures = this.listSourceConsumerGroupOffsets(filteredGroups);
        if (sourceOffsetFutures.nonEmpty()) {
            Iterable futures = (Iterable)sourceOffsetFutures.values().$plus$plus(destOffsetFutures.values());
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleSourceAndDestOffsets((ClusterLinkScheduler.TaskContext)tc, sourceOffsetFutures, destOffsetFutures);
            }, taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private Set<MatchedGroup> filterConsumerGroups(Set<String> groups) {
        this.trace((Function0<String> & Serializable)() -> "Filtering consumer groups " + groups + " to match consumer group JSON");
        None$ clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPrefixConsumerGroupEnable()) ? this.config().clusterLinkPrefix() : None$.MODULE$;
        Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.config().consumerGroupFilters(), this.linkData.tenantPrefix(), clusterLinkPrefix, this.config().linkMode());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set<MatchedGroup> filtered = tuple2._1();
        Seq<ClusterLinkFilterInfo> unusedFilters = tuple2._2();
        Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> tuple22 = new Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>>(filtered, unusedFilters);
        Set<MatchedGroup> filtered2 = tuple22._1();
        Seq<ClusterLinkFilterInfo> unusedFilters2 = tuple22._2();
        unusedFilters2.foreach((Function1<ClusterLinkFilterInfo, Object> & Serializable)unusedFilter -> {
            ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$2(this, unusedFilter);
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String> & Serializable)() -> "Filtered consumer groups: " + filtered2);
        return filtered2;
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listDestConsumerGroupOffsets(Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.localAdmin, false);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listSourceConsumerGroupOffsets(Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.remoteAdmin, true);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listConsumerGroupOffsets(Set<MatchedGroup> groups, ClusterLinkBatchAdmin admin, boolean isSource) {
        String targetCluster = isSource ? "source" : "destination";
        this.trace((Function0<String> & Serializable)() -> "Listing consumer group offsets on " + targetCluster + " cluster for following consumer groups: " + groups);
        scala.collection.mutable.Map groupFutures = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        try {
            Iterator batchedGroups = groups.grouped(ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize());
            batchedGroups.foreach((Function1<Set, Object> & Serializable)batch -> {
                ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$2(this, targetCluster, admin, groupFutures, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            this.offsetFetchFailed(isSource, ex);
        }
        return groupFutures.toMap($less$colon$less$.MODULE$.refl());
    }

    private ClusterLinkScheduler.TaskResult handleSourceAndDestOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures) {
        scala.collection.immutable.Map sourceGroupToOffsets = (scala.collection.immutable.Map)sourceOffsetFutures.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), true)));
        scala.collection.immutable.Map sourceOffsets = (scala.collection.immutable.Map)sourceGroupToOffsets.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()));
        Seq sourceErrs = (Seq)((IterableOps)((MapOps)sourceGroupToOffsets.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()))).values().toSeq().filter((Function1<Option, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(x$8.nonEmpty()))).map((Function1<Option, TaskErrorCodeAndMsg> & Serializable)x$9 -> (TaskErrorCodeAndMsg)x$9.get());
        scala.collection.immutable.Map destGroupToOffsets = (scala.collection.immutable.Map)destOffsetFutures.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), false)));
        scala.collection.immutable.Map destOffsets = (scala.collection.immutable.Map)destGroupToOffsets.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()));
        Seq destErrs = (Seq)((IterableOps)((MapOps)destGroupToOffsets.map((Function1<Tuple2, Tuple2> & Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()))).values().toSeq().filter((Function1<Option, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(x$10.nonEmpty()))).map((Function1<Option, TaskErrorCodeAndMsg> & Serializable)x$11 -> (TaskErrorCodeAndMsg)x$11.get());
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)((IterableOps)taskContext.errs().$plus$plus(sourceErrs)).$plus$plus(destErrs));
        if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isDefined()) {
            Option<String> remotePrefix = this.remoteLinkMetadata().get().remotePrefix();
            Set topics = (Set)((scala.collection.immutable.MapOps)sourceOffsets.flatMap((Function1<Tuple2, scala.collection.immutable.Map> & Serializable)x$12 -> (scala.collection.immutable.Map)x$12._2())).keySet().map((Function1<TopicPartition, String> & Serializable)x$13 -> x$13.topic());
            DescribeMirrorsResult describeMirrorsResult = this.remoteAdmin.describeActiveMirrors(CollectionConverters$.MODULE$.SetHasAsJava(topics).asJava(), this.describeMirrorsOptions());
            this.scheduleWhenComplete(describeMirrorsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleDescribeMirrors((ClusterLinkScheduler.TaskContext)tc, sourceOffsets, destOffsets, CollectionConverters$.MODULE$.MapHasAsScala(describeMirrorsResult.result()).asScala().toMap($less$colon$less$.MODULE$.refl()), remotePrefix);
            }, newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(newTaskContext.errs());
        }
        return this.commitOffsets(newTaskContext, this.mapTopicPartitionToCommittedOffsetTopicPartition(sourceOffsets, new Tuple2<Object, None$>(Predef$.MODULE$.Map().empty(), None$.MODULE$)), (scala.collection.immutable.Map)destOffsets.map((Function1<Tuple2, Tuple2> & Serializable)kv -> new Tuple2(((MatchedGroup)kv._1()).name(), kv._2())));
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> mapTopicPartitionToCommittedOffsetTopicPartition(scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>> remoteLinkMetadata) {
        return (scala.collection.immutable.Map)sourceOffsets.map((Function1<Tuple2, Tuple2> & Serializable)groupToTopicPartitionToOffsetMetadata -> {
            scala.collection.immutable.Map mappedTopicPartitionAndOffsetMetadataMap = (scala.collection.immutable.Map)((MapOps)groupToTopicPartitionToOffsetMetadata._2()).map((Function1<Tuple2, Tuple2> & Serializable)topicPartitionToOffsetMetadata -> {
                TopicPartition topicPartition = (TopicPartition)topicPartitionToOffsetMetadata._1();
                String sourceTopicName = topicPartition.topic();
                return new Tuple2(this.toCommittedOffsetTopicPartition((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1(), topicPartition, ((MapOps)remoteLinkMetadata._1()).get(sourceTopicName), (Option)remoteLinkMetadata._2()), topicPartitionToOffsetMetadata._2());
            });
            return new Tuple2<String, scala.collection.immutable.Map>(((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1()).name(), mappedTopicPartitionAndOffsetMetadataMap);
        });
    }

    private ClusterLinkScheduler.TaskResult handleDescribeMirrors(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets, scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>> describeMirrorsFuture, Option<String> remotePrefix) {
        scala.collection.immutable.Map describeMirrorAndErrors = (scala.collection.immutable.Map)describeMirrorsFuture.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2<Option, Option> tuple22;
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    MirrorTopicDescription mirrorTopicDescription = (MirrorTopicDescription)future.get();
                    tuple22 = mirrorTopicDescription == null ? new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$)) : new Tuple2<Some<Tuple2<String, MirrorTopicDescription>>, None$>(new Some<Tuple2<String, MirrorTopicDescription>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), mirrorTopicDescription)), None$.MODULE$);
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.debug((Function0<String> & Serializable)() -> "Failed to describe remote mirror.", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> ex);
                    Throwable throwable = ex.getCause();
                    Option taskErrorCodeAndMsg = throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authentication issues.")) : (throwable instanceof AuthorizationException ? new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authorization issues.")) : (throwable instanceof ClusterLinkNotFoundException ? None$.MODULE$ : new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to describe remote mirror for an unknown reason."))));
                    tuple22 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, (Some<TaskErrorCodeAndMsg>)taskErrorCodeAndMsg);
                }
                Tuple2<None$, Some<TaskErrorCodeAndMsg>> desc = tuple22;
                return desc;
            }
            throw new MatchError(tuple2);
        });
        scala.collection.immutable.Map describeMirrors = (scala.collection.immutable.Map)((MapOps)describeMirrorAndErrors.filter((Function1<Tuple2, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$4(x$14)))).map((Function1<Tuple2, Tuple2> & Serializable)x$15 -> (Tuple2)((Option)x$15._1()).get());
        scala.collection.immutable.Map remoteMirrors = (scala.collection.immutable.Map)describeMirrors.flatMap((Function1<Tuple2, Option> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                MirrorTopicDescription desc = (MirrorTopicDescription)tuple2._2();
                if (desc.linkName().equals($this.linkData.linkName()) && desc.clusterLinkId().equals((Object)$this.linkData.linkId())) {
                    return new Some<Tuple2<String, MirrorTopicDescription.State>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), desc.state()));
                }
                this.debug((Function0<String> & Serializable)() -> "Filtering out " + topic + " from a different link " + desc.linkName() + " " + desc.clusterLinkId() + ".");
                return None$.MODULE$;
            }
            throw new MatchError(tuple2);
        });
        return this.commitOffsets(new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(((IterableOnceOps)((IterableOps)describeMirrorAndErrors.filter((Function1<Tuple2, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$8(x$16)))).map((Function1<Tuple2, TaskErrorCodeAndMsg> & Serializable)x$17 -> (TaskErrorCodeAndMsg)((Option)x$17._2()).get())).toSeq())), this.mapTopicPartitionToCommittedOffsetTopicPartition(sourceOffsets, new Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>(remoteMirrors, remotePrefix)), (scala.collection.immutable.Map)destOffsets.map((Function1<Tuple2, Tuple2> & Serializable)kv -> new Tuple2(((MatchedGroup)kv._1()).name(), kv._2())));
    }

    private CommittedOffsetTopicPartition toCommittedOffsetTopicPartition(MatchedGroup group, TopicPartition topicPartition, Option<MirrorTopicDescription.State> remoteMirrorTopicState, Option<String> remotePrefix) {
        boolean isRemoteMirror = remoteMirrorTopicState.isDefined();
        Option localMirrorTopicsState = this.metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicPartition.topic()}))).get(topicPartition.topic());
        boolean isLocalMirror = localMirrorTopicsState.isDefined();
        if (isRemoteMirror && isLocalMirror) {
            return new LocalAndRemoteMirrorTopic(new LocalMirrorTopic(topicPartition, new Some<TopicLinkState>(((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group), new RemoteMirrorTopic(topicPartition, remoteMirrorTopicState.get(), this.linkData, this.config().clusterLinkPrefix(), remotePrefix, group));
        }
        if (isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, new Some<TopicLinkState>(((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isRemoteMirror) {
            return new RemoteMirrorTopic(topicPartition, remoteMirrorTopicState.get(), this.linkData, this.config().clusterLinkPrefix(), remotePrefix, group);
        }
        return new RegularTopic(topicPartition);
    }

    private ClusterLinkScheduler.TaskResult commitOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets) {
        scala.collection.immutable.Map commitResults = (scala.collection.immutable.Map)sourceOffsets.flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                String consumerGroup = (String)tuple2._1();
                scala.collection.immutable.Map offsetMetadata = (scala.collection.immutable.Map)tuple2._2();
                Option option = destOffsets.get(consumerGroup);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Map m = (scala.collection.immutable.Map)some.value();
                    object = m;
                } else if (None$.MODULE$.equals(option)) {
                    object = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError(option);
                }
                Object destTopicPartition = object;
                scala.collection.immutable.Map offsetsToCommit = (scala.collection.immutable.Map)offsetMetadata.filter(arg_0 -> ClusterLinkSyncOffsets.$anonfun$commitOffsets$2$adapted(this, consumerGroup, (scala.collection.immutable.Map)destTopicPartition, arg_0));
                if (offsetsToCommit.nonEmpty()) {
                    this.trace((Function0<String> & Serializable)() -> "Committing offsets on destination cluster for consumer group " + consumerGroup + ": " + offsetsToCommit);
                    scala.collection.immutable.Map offsetAndMetadataToCommit = Predef$.MODULE$.Boolean2boolean(this.clientManager().brokerConfig().clusterLinkK1ToK2MigrationEnable()) ? (scala.collection.immutable.Map)offsetsToCommit.map((Function1<Tuple2, Tuple2> & Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((CommittedOffsetTopicPartition)keyVal._1()).destTopic()), new OffsetAndMetadata(((OffsetAndMetadata)keyVal._2()).offset(), Optional.empty(), ((OffsetAndMetadata)keyVal._2()).metadata()))) : (scala.collection.immutable.Map)offsetsToCommit.map((Function1<Tuple2, Tuple2> & Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((CommittedOffsetTopicPartition)keyVal._1()).destTopic()), keyVal._2()));
                    return new Some<Tuple2<String, AlterConsumerGroupOffsetsResult>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(consumerGroup), $this.localAdmin.alterConsumerGroupOffsets(consumerGroup, CollectionConverters$.MODULE$.MapHasAsJava(offsetAndMetadataToCommit).asJava())));
                }
                return None$.MODULE$;
            }
            throw new MatchError(tuple2);
        });
        if (commitResults.nonEmpty()) {
            return this.handleDestinationClusterCommittedOffsets(taskContext, commitResults, sourceOffsets);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDestinationClusterCommittedOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets) {
        KafkaFuture allCommitFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((IterableOnceOps)commitResults.values().map((Function1<AlterConsumerGroupOffsetsResult, KafkaFuture> & Serializable)x$19 -> x$19.all())).toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allCommitFutures, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
            scala.collection.immutable.Iterable errs = (scala.collection.immutable.Iterable)commitResults.flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option;
                    String group = (String)tuple2._1();
                    AlterConsumerGroupOffsetsResult commitResult = (AlterConsumerGroupOffsetsResult)tuple2._2();
                    try {
                        commitResult.all().get();
                        ((IterableOnceOps)sourceOffsets.apply(group)).foreach((Function1<Tuple2, Object> & Serializable)topicPartitionAndOffsetMetadata -> {
                            ClusterLinkSyncOffsets.$anonfun$handleDestinationClusterCommittedOffsets$4(this, group, topicPartitionAndOffsetMetadata);
                            return BoxedUnit.UNIT;
                        });
                        option = None$.MODULE$;
                    }
                    catch (ExecutionException ex) {
                        KafkaException kafkaException;
                        Throwable throwable = ex.getCause();
                        if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                            String errMsg = "Unable to commit offsets for group " + group + " on the destination due to authentication issues on the broker.";
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
                        } else if (throwable instanceof UnknownMemberIdException) {
                            String errMsg = "Unable to commit offsets for consumer group " + group + " on the destination cluster because there are active members on the destination already.";
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(ConsumerGroupInUseTaskErrorCode$.MODULE$, errMsg));
                        } else if (throwable instanceof GroupAuthorizationException) {
                            GroupAuthorizationException groupAuthorizationException = (GroupAuthorizationException)throwable;
                            String errMsg = "Unable to commit offsets for consumer group " + group + " on the destination cluster due to group authorization issues on the broker. Please add READ ACLs for the consumer group. This action is taken by the inter-broker principal defined in the broker configuration so ACLs should be added for this principal.";
                            excessiveLoggingHandler.handle((Throwable)groupAuthorizationException, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, "Unable to commit offsets for group " + group + " due to group authorization issues."));
                        } else if (throwable instanceof TopicAuthorizationException) {
                            String errMsg = "Unable to commit offsets for consumer group " + group + " on the destination cluster due to topic authorization issues on the broker. Please add READ ACLs for the topics being migrated. This action is taken by the inter-broker principal defined in the broker configuration so ACLs should be added for this principal.";
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, "Unable to commit offsets for group " + group + " due to topic authorization issues."));
                        } else if (throwable instanceof UnknownTopicOrPartitionException) {
                            String errMsg = "Unable to commit offsets for consumer group " + group + " on destination cluster due to unknown topic or partition.";
                            excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply(ex.getCause()).getOrElse((Function0<ExecutionException> & Serializable)() -> ex), this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg));
                        } else {
                            String errMsg = "Unable to commit offsets for consumer group " + group + " on destination cluster for an unknown reason.";
                            excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply(ex.getCause()).getOrElse((Function0<ExecutionException> & Serializable)() -> ex), this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                        }
                    }
                    catch (Throwable ex) {
                        String errMsg = "Unable to commit offsets for consumer group " + group + " on destination cluster due to an unexpected exception.";
                        excessiveLoggingHandler.handle(ex, this, errMsg);
                        $this.metrics.consumerOffsetCommitFailedSensor().record();
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                    return option;
                }
                throw new MatchError(tuple2);
            });
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)tc.errs().$plus$plus(errs));
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, Option<TaskErrorCodeAndMsg>> offsets(String group, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> future, boolean isSource) {
        Tuple2<Object, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(CollectionConverters$.MODULE$.MapHasAsScala((Map)future.get()).asScala().map((Function1<Tuple2, Tuple2> & Serializable)topicPartitionAndOffsetMetadata -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartitionAndOffsetMetadata._1()), topicPartitionAndOffsetMetadata._2())).toMap($less$colon$less$.MODULE$.refl()), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable;
            KafkaException kafkaException2;
            Throwable throwable2;
            this.offsetFetchFailed(isSource, ex);
            this.debug((Function0<String> & Serializable)() -> "Failed to get offsets for group " + group, (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> ex);
            TaskErrorCodeAndMsg taskErrorCodeAndMsg = isSource ? ((throwable2 = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException2 = (KafkaException)throwable2) ? new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the source due to authentication issues with the link.") : (throwable2 instanceof AuthorizationException ? new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the source due to authorization issues with the link.") : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the source for an unknown reason."))) : ((throwable = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the destination due to authentication issues on the broker.") : (throwable instanceof AuthorizationException ? new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the destination due to authorization issues on the broker.") : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to get offsets for group " + group + " on the destination for an unknown reason.")));
            TaskErrorCodeAndMsg err = taskErrorCodeAndMsg;
            tuple2 = new Tuple2<Object, Some<TaskErrorCodeAndMsg>>(Predef$.MODULE$.Map().empty(), new Some<TaskErrorCodeAndMsg>(err));
        }
        return tuple2;
    }

    private void offsetFetchFailed(boolean isSource, Throwable e) {
        if (isSource) {
            this.warn((Function0<String> & Serializable)() -> "Unable to list consumer group offsets on source cluster. Offsets will not be migrated. " + e);
            this.metrics.listConsumerGroupOffsetsFromSourceFailedSensor().record();
            return;
        }
        this.info((Function0<String> & Serializable)() -> "Unable to list consumer group offsets on destination cluster. All available source offsets will be committed. " + e);
        this.metrics.listConsumerGroupOffsetsFromDestinationFailedSensor().record();
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(ClusterLinkBatchAdmin admin, Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        return admin.listConsumerGroupOffsets(groupSpecs);
    }

    private boolean configuredToIncludeRemoteMirrors() {
        return this.config().linkMode().equals((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL) && this.config().consumerGroupFilters().exists((Function1<GroupFilterJson, Object> & Serializable)groupFiltersJson -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$1(this, groupFiltersJson)));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName())) {
            if (this.config().consumerOffsetSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncOffsetsTaskType$.MODULE$, false, "run the consumer offsets sync task"));
                return;
            }
            this.taskDesc_$eq(new Some<TaskDescription>(new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq)package$.MODULE$.Seq().empty())));
            return;
        }
        this.taskDesc_$eq(None$.MODULE$);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture configFuture$1) {
        Tuple2<None$, $colon$colon<Nothing$>> tuple2;
        block5: {
            try {
                this.debug((Function0<String> & Serializable)() -> "Attempting to fetch remote link configuration for link " + $this.linkData.linkName());
                tuple2 = new Tuple2<None$, $colon$colon<Nothing$>>((None$)((Object)new Some<Object>(configFuture$1.get())), ($colon$colon<Nothing$>)package$.MODULE$.Seq().empty());
            }
            catch (ExecutionException ex) {
                KafkaException kafkaException;
                this.warn((Function0<String> & Serializable)() -> "Failed to get remote link config on the remote cluster for bi-directional link " + $this.linkData.linkName() + ". " + ex);
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    tuple2 = new Tuple2<None$, $colon$colon<Nothing$>>(None$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authentication issues.")), Nil$.MODULE$));
                    break block5;
                }
                if (throwable instanceof AuthorizationException) {
                    tuple2 = new Tuple2<None$, $colon$colon<Nothing$>>(None$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authorization issues.")), Nil$.MODULE$));
                    break block5;
                }
                if (throwable instanceof ClusterLinkNotFoundException) {
                    tuple2 = new Tuple2<None$, $colon$colon<Nothing$>>(None$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, "Failed to get remote link config due to link not being found on the remote cluster.")), Nil$.MODULE$));
                    break block5;
                }
                tuple2 = new Tuple2<None$, $colon$colon<Nothing$>>(None$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to get remote link config for an unknown reason.")), Nil$.MODULE$));
            }
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$3(ClusterLinkSyncOffsets $this, Config linkConfig) {
        ConfigEntry prefix = linkConfig.get(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp());
        Option<String> remotePrefix = Option$.MODULE$.apply(prefix).map((Function1<ConfigEntry, String> & Serializable)x$2 -> x$2.value()).filter((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(x$3))).filter((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4))));
        $this.remoteLinkMetadata_$eq(new Some<RemoteLinkMetadata>(new RemoteLinkMetadata(remotePrefix)));
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(ListConsumerGroupsResult listConsumerGroupsResult$2, ClusterLinkScheduler.TaskContext taskContext$1) {
        Tuple2<Object, Some<ClusterLinkScheduler.TaskResult>> tuple2;
        block4: {
            try {
                Collection result = (Collection)listConsumerGroupsResult$2.all().get();
                tuple2 = new Tuple2<Object, Some<ClusterLinkScheduler.TaskResult>>(result, (Some<ClusterLinkScheduler.TaskResult>)((Object)None$.MODULE$));
            }
            catch (ExecutionException ex) {
                KafkaException kafkaException;
                this.warn((Function0<String> & Serializable)() -> "Unable to list consumer group offsets. Offsets will not be migrated. " + ex);
                this.metrics.listConsumerGroupsFromSourceFailedSensor().record();
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    tuple2 = new Tuple2<Object, Some<ClusterLinkScheduler.TaskResult>>(null, new Some<ClusterLinkScheduler.TaskResult>(ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext$1.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authentication issues.")), Nil$.MODULE$)))));
                    break block4;
                }
                if (throwable instanceof AuthorizationException) {
                    tuple2 = new Tuple2<Object, Some<ClusterLinkScheduler.TaskResult>>(null, new Some<ClusterLinkScheduler.TaskResult>(ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext$1.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authorization issues.")), Nil$.MODULE$)))));
                    break block4;
                }
                tuple2 = new Tuple2<Object, Some<ClusterLinkScheduler.TaskResult>>(null, new Some<ClusterLinkScheduler.TaskResult>(ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext$1.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Unable to list consumer groups for an unknown reason.")), Nil$.MODULE$)))));
            }
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$filterConsumerGroups$2(ClusterLinkSyncOffsets $this, ClusterLinkFilterInfo unusedFilter) {
        String string = unusedFilter.configuredFilter().filterType();
        String string2 = "EXCLUDE";
        if (string == null ? string2 != null : !string.equals(string2)) {
            $this.warn((Function0<String> & Serializable)() -> "The filter " + unusedFilter + " does not match any consumer group. This filter may not be required or the groups it referred to may not have the correct DESCRIBE ACL for the cluster link principal on the source cluster.");
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$5(ListConsumerGroupOffsetsResult result$2, scala.collection.mutable.Map groupFutures$1, MatchedGroup group) {
        Option$.MODULE$.apply(result$2.partitionsToOffsetAndMetadata(group.name())).foreach((Function1<KafkaFuture, scala.collection.mutable.Map> & Serializable)offsets -> (scala.collection.mutable.Map)groupFutures$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), offsets)));
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$2(ClusterLinkSyncOffsets $this, String targetCluster$1, ClusterLinkBatchAdmin admin$1, scala.collection.mutable.Map groupFutures$1, Set batch) {
        $this.trace((Function0<String> & Serializable)() -> "Listing consumer group offsets on " + targetCluster$1 + " cluster for following consumer groups: " + batch);
        Map<String, ListConsumerGroupOffsetsSpec> groupMap = CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)batch.map((Function1<MatchedGroup, Tuple2> & Serializable)g -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(g.name()), ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions()))).toMap($less$colon$less$.MODULE$.refl())).asJava();
        ListConsumerGroupOffsetsResult result = $this.listConsumerGroupOffsets(admin$1, groupMap);
        batch.foreach((Function1<MatchedGroup, Object> & Serializable)group -> {
            ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$5(result, groupFutures$1, group);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$4(Tuple2 x$14) {
        return ((Option)x$14._1()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$8(Tuple2 x$16) {
        return ((Option)x$16._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$5(OffsetAndMetadata sourceOffset$1, OffsetAndMetadata destOffset) {
        return destOffset != null && destOffset.offset() == sourceOffset$1.offset();
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$2(ClusterLinkSyncOffsets $this, String consumerGroup$1, scala.collection.immutable.Map destTopicPartition$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            CommittedOffsetTopicPartition tp = (CommittedOffsetTopicPartition)tuple2._1();
            OffsetAndMetadata sourceOffset = (OffsetAndMetadata)tuple2._2();
            Tuple2<Object, String> tuple22 = tp.shouldSync();
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            boolean shouldSync = tuple22._1$mcZ$sp();
            String reason = tuple22._2();
            Tuple2<Boolean, String> tuple23 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(shouldSync), reason);
            boolean shouldSync2 = tuple23._1$mcZ$sp();
            String reason2 = tuple23._2();
            if (!shouldSync2) {
                $this.trace((Function0<String> & Serializable)() -> "Not committing offsets for " + tp + " because " + reason2);
                return false;
            }
            if (sourceOffset == null) {
                $this.trace((Function0<String> & Serializable)() -> "Not committing offsets for " + tp + " since no committed offset exists on the source cluster for " + consumerGroup$1);
                return false;
            }
            if (destTopicPartition$1.get(tp.destTopic()).exists((Function1<OffsetAndMetadata, Object> & Serializable)destOffset -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$commitOffsets$5(sourceOffset, destOffset)))) {
                $this.trace((Function0<String> & Serializable)() -> "Not committing offsets for " + tp + " since offset=" + sourceOffset + " is already committed on the destination.");
                return false;
            }
            return true;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$handleDestinationClusterCommittedOffsets$4(ClusterLinkSyncOffsets $this, String group$2, Tuple2 topicPartitionAndOffsetMetadata) {
        if (((CommittedOffsetTopicPartition)topicPartitionAndOffsetMetadata._1()).shouldSync()._1$mcZ$sp()) {
            $this.metrics.consumerOffsetCommitSensor().record();
            $this.trace((Function0<String> & Serializable)() -> "Committed offsets on destination cluster for consumer group " + group$2);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$2(ClusterLinkSyncOffsets $this, GroupClusterLinkFilter filter) {
        return FilterType$.MODULE$.fromString(filter.filterType()).contains(FilterType$.MODULE$.INCLUDE()) && filter.effectiveTopicTypes($this.config().linkMode()).contains(TopicType$.MODULE$.REMOTE_MIRROR());
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$1(ClusterLinkSyncOffsets $this, GroupFilterJson groupFiltersJson) {
        return groupFiltersJson.filters().exists((Function1<GroupClusterLinkFilter, Object> & Serializable)filter -> BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$2($this, filter)));
    }

    public ClusterLinkSyncOffsets(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkSyncOffsets", Predef$.MODULE$.Integer2int(clientManager.currentConfig().consumerOffsetSyncMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.tasksOutstanding = 0;
        this.remoteLinkMetadata = None$.MODULE$;
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-" + linkData.linkName() + "] ");
        this.taskDesc = None$.MODULE$;
        this.describeMirrorsOptions = new DescribeMirrorsOptions().linkNames(Collections.singleton(linkData.linkName())).states(Collections.singleton(MirrorTopicDescription.State.ACTIVE.name()));
    }

    public static final /* synthetic */ Object $anonfun$commitOffsets$2$adapted(ClusterLinkSyncOffsets $this, String consumerGroup$1, scala.collection.immutable.Map destTopicPartition$1, Tuple2 x0$2) {
        return BoxesRunTime.boxToBoolean(ClusterLinkSyncOffsets.$anonfun$commitOffsets$2($this, consumerGroup$1, destTopicPartition$1, x0$2));
    }
}

