/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\r\u001b\u0001\u0005B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011%9\u0004A!A!\u0002\u0013Ad\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\"\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%W\u0011%9\u0006A!A!\u0002\u0013AF\fC\u0003^\u0001\u0011\u0005a\fC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\u000f-\u0004\u0001\u0019!C\u0005Y\"1!\u000f\u0001Q!\naBqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\n\u0001\u0001\u000b\u0015B>\t\u000f\u0005M\u0001\u0001\"\u0015\u0002\u0016!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003\u0003\u0003A\u0011KAB\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!!%\u0001\t\u0013\t\u0019J\u0001\u000fDYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY:D_:4\u0017nZ:\u000b\u0005ma\u0012\u0001\u00027j].T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"aI\u0014\u000f\u0005\u0011*S\"\u0001\u000e\n\u0005\u0019R\u0012\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002)S\ta\u0001+\u001a:j_\u0012L7\rV1tW*\u0011aEG\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0011\u0005\u0011b\u0013BA\u0017\u001b\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fq\"\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0003IAJ!!\r\u000e\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\t\u0003IQJ!!\u000e\u000e\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006QAn\\2bY\u0006#W.\u001b8\u0002\u001dMLhnY%oi\u0016\u0014h/\u00197NgB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t\u0019\u0011J\u001c;\n\u0005}:\u0013!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u00069Q.\u001a;sS\u000e\u001c\bC\u0001\u0013C\u0013\t\u0019%D\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u00037j].$\u0015\r^1\u0011\u0005\u00112\u0015BA$\u001b\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017\u0001\u0002;j[\u0016\u0004\"A\u0013+\u000e\u0003-S!\u0001T'\u0002\u000bU$\u0018\u000e\\:\u000b\u00059{\u0015AB2p[6|gN\u0003\u0002 !*\u0011\u0011KU\u0001\u0007CB\f7\r[3\u000b\u0003M\u000b1a\u001c:h\u0013\t)6J\u0001\u0003US6,\u0017B\u0001%(\u0003\u0015\tXo\u001c;b!\tI&,D\u0001\u001d\u0013\tYFDA\fDYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC&\u0011qkJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015}\u0003\u0017MY2eK\u001a<\u0007\u000e\u0005\u0002%\u0001!)!F\u0003a\u0001W!)aF\u0003a\u0001_!)!G\u0003a\u0001g!)aG\u0003a\u0001g!)qG\u0003a\u0001q!)\u0001I\u0003a\u0001\u0003\")AI\u0003a\u0001\u000b\")\u0001J\u0003a\u0001\u0013\")qK\u0003a\u00011\u0006\u0001B/Y:lg>+Ho\u001d;b]\u0012LgnZ\u000b\u0002q\u0005!B/Y:lg>+Ho\u001d;b]\u0012LgnZ0%KF$\"!\u001c9\u0011\u0005er\u0017BA8;\u0005\u0011)f.\u001b;\t\u000fEd\u0011\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\u0002#Q\f7o[:PkR\u001cH/\u00198eS:<\u0007%A\ffq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7feV\tQ\u000f\u0005\u0002%m&\u0011qO\u0007\u0002\u0018\u000bb\u001cWm]:jm\u0016dunZ4j]\u001eD\u0015M\u001c3mKJ\f\u0001$\u001a=dKN\u001c\u0018N^3M_\u001e<\u0017N\\4IC:$G.\u001a:!\u0003!!\u0018m]6EKN\u001cW#A>\u0011\u0007ebh0\u0003\u0002~u\t1q\n\u001d;j_:\u0004\"\u0001J@\n\u0007\u0005\u0005!DA\bUCN\\G)Z:de&\u0004H/[8o\u00031!\u0018m]6EKN\u001cw\fJ3r)\ri\u0017q\u0001\u0005\bcF\t\t\u00111\u0001|\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002\u0013\u0003\u001b\u00012!OA\b\u0013\r\t\tB\u000f\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005]\u0001\u0003BA\r\u0003[q1!a\u0007&\u001d\u0011\ti\"a\u000b\u000f\t\u0005}\u0011\u0011\u0006\b\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$C\u0002\u00020%\u0012!\u0002V1tWJ+7/\u001e7u\u0003iA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016$v\u000e]5d\u0007>tg-[4t)\u0019\t9\"!\u000e\u0002@!9\u0011q\u0007\u000bA\u0002\u0005e\u0012a\u0003;bg.\u001cuN\u001c;fqR\u0004B!!\u0007\u0002<%\u0019\u0011QH\u0015\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0003\"\u0002\u0019AA\"\u0003\u0019\u0011Xm];miBA\u0011QIA&\u0003\u001f\nY&\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0005\u001d#aA'baB!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V5\u000baaY8oM&<\u0017\u0002BA-\u0003'\u0012abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0004\u0002^\u0005}\u00131M\u0007\u0002\u001b&\u0019\u0011\u0011M'\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0015\tG-\\5o\u0015\r\tigT\u0001\bG2LWM\u001c;t\u0013\u0011\t\t(a\u001a\u0003\r\r{gNZ5h\u0003]A\u0017M\u001c3mK\u0006cG/\u001a:U_BL7mQ8oM&<7\u000f\u0006\u0004\u0002\u0018\u0005]\u0014\u0011\u0010\u0005\b\u0003o)\u0002\u0019AA\u001d\u0011\u001d\t\t%\u0006a\u0001\u0003w\u0002B!!\u001a\u0002~%!\u0011qPA4\u0005I\tE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\u00075\f)\tC\u0004\u0002BY\u0001\r!a\"\u0011\u0007\r\nI)C\u0002\u0002\f&\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0002w\u0006\u0001Bn\\4B]\u0012,U.\u001b;NKR\u0014\u0018n\u0019\u000b\b[\u0006U\u00151VA`\u0011\u001d\t9\n\u0007a\u0001\u00033\u000b!!\u001a=\u0011\t\u0005m\u0015Q\u0015\b\u0005\u0003;\u000b\tK\u0004\u0003\u0002\"\u0005}\u0015\"A\u001e\n\u0007\u0005\r&(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0016\u0011\u0016\u0002\n)\"\u0014xn^1cY\u0016T1!a);\u0011\u001d\ti\u000b\u0007a\u0001\u0003_\u000ba!\u001a:s\u001bN<\u0007\u0003BAY\u0003ssA!a-\u00026B\u0019\u0011\u0011\u0005\u001e\n\u0007\u0005]&(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\u000biL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003oS\u0004bBAa1\u0001\u0007\u00111Y\u0001\u0007g\u0016t7o\u001c:\u0011\t\u0005\u0015\u0017\u0011Z\u0007\u0003\u0003\u000fT!\u0001Q'\n\t\u0005-\u0017q\u0019\u0002\u0007'\u0016t7o\u001c:")
public class ClusterLinkSyncTopicsConfigs
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkData linkData;
    private int tasksOutstanding;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private volatile Option<TaskDescription> taskDesc;

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    public ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.tasksOutstanding() != 0) {
            this.warn((Function0<String> & Serializable)() -> "Number of outstanding tasks was " + this.tasksOutstanding() + " at the beginning of run. Resetting to 0 and continuing on.");
            this.tasksOutstanding_$eq(0);
        }
        Set<String> topics = this.clientManager.getTopics();
        scala.collection.immutable.Set resources = ((IterableOnceOps)topics.map((Function1<String, ConfigResource> & Serializable)name -> new ConfigResource(ConfigResource.Type.TOPIC, name))).toSet();
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        if (resources.nonEmpty()) {
            this.trace((Function0<String> & Serializable)() -> "Attempting to retrieve topic configs from source cluster for following mirror topics: " + topics);
            DescribeConfigsResult describeConfigsResult = this.remoteAdmin.describeConfigs(CollectionConverters$.MODULE$.SetHasAsJava(resources).asJava());
            this.scheduleWhenComplete(describeConfigsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleDescribeTopicConfigs((ClusterLinkScheduler.TaskContext)tc, (Map<ConfigResource, KafkaFuture<Config>>)CollectionConverters$.MODULE$.MapHasAsScala(describeConfigsResult.values()).asScala().toMap($less$colon$less$.MODULE$.refl())), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, Map<ConfigResource, KafkaFuture<Config>> result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        HashMap<ConfigResource, Collection<AlterConfigOp>> alterConfigRequestMap = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        scala.collection.mutable.Map updatedConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Iterable errs = (Iterable)result.flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option errOpt;
                String topic;
                ConfigResource resource = (ConfigResource)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                Tuple2 tuple22 = this.liftedTree1$1(future, topic = resource.name());
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Option newSourceTopicConfigOpt = (Option)tuple22._1();
                Option errOpt2 = (Option)tuple22._2();
                Tuple2<Option, Option> tuple23 = new Tuple2<Option, Option>(newSourceTopicConfigOpt, errOpt2);
                Option newSourceTopicConfigOpt2 = tuple23._1();
                Option option = errOpt = tuple23._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
                    return new Some<TaskErrorCodeAndMsg>(err);
                }
                if (None$.MODULE$.equals(option)) {
                    Option option2;
                    try {
                        Properties newProps;
                        if (newSourceTopicConfigOpt2.isEmpty()) {
                            throw new IllegalStateException(this.logIdent() + "There should be a source config for " + topic + " if there was no error.");
                        }
                        Config newSourceTopicConfig = (Config)newSourceTopicConfigOpt2.get();
                        this.trace((Function0<String> & Serializable)() -> "Topic configuration for source topic " + topic + " is: " + newSourceTopicConfig);
                        MirrorTopicConfigSyncRules topicConfigSyncRules = $this.clientManager.topicConfigSyncRules();
                        Properties curProps = $this.metadataManager.getTopicConfig(topic);
                        Properties resolvedProps = new MirrorTopicConfigsDelegate(curProps, newSourceTopicConfig, topicConfigSyncRules).updateMirrorProps(topic);
                        Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(topic, resolvedProps, $this.clientManager.alterConfigPolicy());
                        Properties properties2 = curProps;
                        if (properties == null ? properties2 != null : !((Object)properties).equals(properties2)) {
                            this.debug((Function0<String> & Serializable)() -> "Updating local configuration for mirror topic '" + topic + "' on cluster link '" + $this.clientManager.linkData().linkName() + "'");
                            scala.collection.immutable.Map newTopicConfigs = CollectionConverters$.MODULE$.PropertiesHasAsScala(newProps).asScala().toSet().diff(CollectionConverters$.MODULE$.PropertiesHasAsScala(curProps).asScala().toSet()).toMap($less$colon$less$.MODULE$.refl());
                            this.trace((Function0<String> & Serializable)() -> "Adding configs " + newTopicConfigs + " for topic " + topic + " on target cluster");
                            HashSet newConfigs = new HashSet();
                            newTopicConfigs.foreach((Function1<Tuple2, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                            alterConfigRequestMap.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), newConfigs);
                            v1 = updatedConfigs.put(topic, new Some<Config>(newSourceTopicConfig));
                        } else {
                            v1 = BoxedUnit.UNIT;
                        }
                        option2 = None$.MODULE$;
                    }
                    catch (PolicyViolationException e) {
                        String errMsg = "Could not update mirror topic '" + topic + "' configuration due to policy violation on cluster link " + $this.clientManager.linkData().linkName();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        option2 = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, errMsg));
                    }
                    catch (Throwable e) {
                        String errMsg = "Error encountered while processing remote configuration for mirror topic '" + topic + "' on cluster link " + $this.clientManager.linkData().linkName();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        option2 = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                    return option2;
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (!alterConfigRequestMap.isEmpty()) {
            AlterConfigsResult alterConfigResult = this.localAdmin.incrementalAlterConfigs(alterConfigRequestMap);
            this.scheduleWhenComplete(alterConfigResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterTopicConfigs((ClusterLinkScheduler.TaskContext)tc, alterConfigResult), newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(newTaskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleAlterTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, AlterConfigsResult result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.mutable.Set errs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(result.values().entrySet()).asScala().flatMap((Function1<Map.Entry, Option> & Serializable)entry -> {
            Option option;
            String topic = ((ConfigResource)entry.getKey()).name();
            try {
                ((KafkaFuture)entry.getValue()).get();
                $this.metrics.topicConfigUpdateSensor().record();
                this.trace((Function0<String> & Serializable)() -> "Successfully updated configuration for mirror topic " + topic);
                option = None$.MODULE$;
            }
            catch (ExecutionException ex) {
                TaskErrorCodeAndMsg taskErrorCodeAndMsg;
                KafkaException kafkaException;
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = "Unable to alter topic configs due to authentication issues for " + topic + ".";
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
                } else if (throwable instanceof AuthorizationException) {
                    String errMsg = "Unable to alter topic configs due to authorization issues for " + topic + ".";
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
                } else if (throwable instanceof InvalidConfigurationException) {
                    String errMsg = "Unable to alter topic configs due to invalid configuration exception for " + topic + ": " + ex.getMessage();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, errMsg);
                } else {
                    String errMsg = "Unable to alter topic configs due to internal issues for " + topic + ".";
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
                }
                TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
                this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), $this.metrics.topicConfigUpdateFailedSensor());
                option = new Some<TaskErrorCodeAndMsg>(taskErrorCodeAndMsg2);
            }
            catch (Throwable e) {
                String errMsg = "Error encountered while altering configuration on mirror topic " + topic;
                this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
            return option;
        });
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        boolean clearExcessiveLoggingHandler;
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        boolean isLinkCoordinator = this.metadataManager.isLinkCoordinator(this.linkData.linkName());
        if (isLinkCoordinator) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncTopicConfigsTaskType$.MODULE$, false, "run the topic configs sync task"));
            v0 = false;
        } else {
            this.taskDesc_$eq(None$.MODULE$);
            v0 = clearExcessiveLoggingHandler = true;
        }
        if (clearExcessiveLoggingHandler) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private void logAndEmitMetric(Throwable ex, String errMsg, Sensor sensor) {
        this.excessiveLoggingHandler().handle(ex, this, errMsg);
        sensor.record();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture future$1, String topic$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>((None$)((Object)new Some<Object>(future$1.get())), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to describe topic configs due to authentication issues for " + topic$1 + ".";
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to describe topic configs due to authorization issues for " + topic$1 + ".";
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof UnknownTopicOrPartitionException) {
                String errMsg = "Unable to describe topic configs due to unknown topic partition on the source for " + topic$1 + ".";
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to describe topic configs due to internal issues for " + topic$1 + ".";
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
            this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), this.metrics.topicConfigUpdateFailedSensor());
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(taskErrorCodeAndMsg2));
        }
        catch (Throwable ex) {
            String errMsg = "Unable to describe topic configs due to internal issues for " + topic$1 + ".";
            this.logAndEmitMetric(ex, errMsg, this.metrics.topicConfigUpdateFailedSensor());
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
        }
        return tuple2;
    }

    public ClusterLinkSyncTopicsConfigs(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, int syncIntervalMs, ClusterLinkMetrics metrics, ClusterLinkData linkData, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.linkData = linkData;
        super(clientManager.scheduler(), "ClusterLinkSyncTopicsConfigs", syncIntervalMs, time, quota);
        this.tasksOutstanding = 0;
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-" + linkData.linkName() + "] ");
        this.taskDesc = None$.MODULE$;
    }
}

