/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.ForwardingManager;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.MirrorTopicRequestHelperKraft;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.MetadataCache;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\r\u001b\u0001\u0005B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\nw\u0001\u0011\t\u0011)A\u0005y\u0019C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!9\u0007A!A!\u0002\u0013A\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011u\u0004!\u0011!Q\u0001\nyDaa \u0001\u0005\u0002\u0005\u0005\u0001\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\tI\u0006\u0001Q\u0001\n\u0005\u001d\u0002\"CA.\u0001\t\u0007I\u0011BA/\u0011!\ty\u0007\u0001Q\u0001\n\u0005}\u0003bBA9\u0001\u0011E\u00131\u000f\u0005\b\u0003\u0003\u0003A\u0011KAB\u0011\u001d\t)\t\u0001C)\u0003\u0007Cq!a\"\u0001\t#\nI\tC\u0004\u0002\u0016\u0002!\t&a\u001d\t\u000f\u0005]\u0005\u0001\"\u0015\u0002\u0004\"9\u0011\u0011\u0014\u0001\u0005R\u0005m\u0005\"DAR\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0015fIA\u000fEK2,G/Z'jeJ|'\u000fV8qS\u000e\u001c\b*\u001a7qKJ\\%/\u00194u\u0015\tYB$\u0001\u0003mS:\\'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003cA\u0012%M5\t!$\u0003\u0002&5\tiR*\u001b:s_J$v\u000e]5d%\u0016\fX/Z:u\u0011\u0016d\u0007/\u001a:Le\u00064G\u000f\u0005\u0002(c5\t\u0001F\u0003\u0002*U\u00059Q.Z:tC\u001e,'BA\u0016-\u0003\u0019\u0019w.\\7p]*\u0011q$\f\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023Q\tAB)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016$\u0015\r^1\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0011\u0005UBdBA\u00127\u0013\t9$$\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018BA\u001d;\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0015\t9$$A\u0004sKF,Xm\u001d;\u0011\u0005u\u001aeB\u0001 B\u001b\u0005y$B\u0001!\u001f\u0003\u001dqW\r^<pe.L!AQ \u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011A)\u0012\u0002\b%\u0016\fX/Z:u\u0015\t\u0011u(\u0003\u0002<I\u0005Q\u0011-\u001e;i\u0011\u0016d\u0007/\u001a:\u0011\u0005%SU\"\u0001\u000f\n\u0005-c\"AC!vi\"DU\r\u001c9fe\u00061am\u001e3NOJ\u0004\"!\u0013(\n\u0005=c\"!\u0005$pe^\f'\u000fZ5oO6\u000bg.Y4fe\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0017\u0002\u00115,G/\u00193bi\u0006L!AV*\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003U\u0019XM\u001c3G_J<\u0018M\u001d3fIJ+7\u000f]8og\u0016\u0004R!\u0017/==\u0012l\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\n\rVt7\r^5p]J\u0002\"a\u00182\u000e\u0003\u0001T!!\u0019\u0016\u0002\u0011I,\u0017/^3tiNL!a\u00191\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007CA-f\u0013\t1'L\u0001\u0003V]&$\u0018!F:f]\u0012$\u0006N]8ui2,GMU3ta>t7/\u001a\t\u00063rc\u0014\u000e\u001a\t\u00053*dg,\u0003\u0002l5\nIa)\u001e8di&|g.\r\t\u000336L!A\u001c.\u0003\u0007%sG/A\niC:$G.Z#se>\u0014(+Z:q_:\u001cX\rE\u0003Z9r\nH\r\u0005\u0002su:\u00111\u000f\u001f\b\u0003i^l\u0011!\u001e\u0006\u0003m\u0002\na\u0001\u0010:p_Rt\u0014\"A.\n\u0005eT\u0016a\u00029bG.\fw-Z\u0005\u0003wr\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005eT\u0016!\n5b]\u0012dW-\u00138wC2LGMV3sg&|gn\u001d#ve&twMR8so\u0006\u0014H-\u001b8h!\u0011I&\u000e\u00103\u0002\rqJg.\u001b;?)Q\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016A\u00111\u0005\u0001\u0005\u0006g)\u0001\r\u0001\u000e\u0005\u0006w)\u0001\r\u0001\u0010\u0005\u0006\u000f*\u0001\r\u0001\u0013\u0005\u0006\u0019*\u0001\r!\u0014\u0005\u0006!*\u0001\r!\u0015\u0005\u0006/*\u0001\r\u0001\u0017\u0005\u0006O*\u0001\r\u0001\u001b\u0005\u0006_*\u0001\r\u0001\u001d\u0005\u0006{*\u0001\rA`\u0001\u0013I\u0016dW\r^3U_BL7MU3rk\u0016\u001cH/\u0006\u0002\u0002\u001cA\u0019q,!\b\n\u0007\u0005}\u0001MA\nEK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH/A\neK2,G/\u001a+pa&\u001c'+Z9vKN$\b%\u0001\tbkR|W*\u001b:s_J$v\u000e]5dgV\u0011\u0011q\u0005\t\u0007\u0003S\t\u0019$a\u000e\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tq!\\;uC\ndWMC\u0002\u00022i\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)$a\u000b\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0003\u0002:\u0005Mc\u0002BA\u001e\u0003\u001frA!!\u0010\u0002N9!\u0011qHA&\u001d\u0011\t\t%!\u0013\u000f\t\u0005\r\u0013q\t\b\u0004i\u0006\u0015\u0013\"\u0001\u0019\n\u00059z\u0013BA\u0010.\u0013\tYC&\u0003\u0002*U%\u0019\u0011\u0011\u000b\u0015\u0002/\u0011+G.\u001a;f)>\u0004\u0018nY:SKF,Xm\u001d;ECR\f\u0017\u0002BA+\u0003/\u0012\u0001\u0003R3mKR,Gk\u001c9jGN#\u0018\r^3\u000b\u0007\u0005E\u0003&A\tbkR|W*\u001b:s_J$v\u000e]5dg\u0002\n\u0001$Y;u_6K'O]8s)>\u0004\u0018n\u0019*fgB|gn]3t+\t\ty\u0006\u0005\u0004\u0002*\u0005M\u0012\u0011\r\t\u0005\u0003G\nIG\u0004\u0003\u0002<\u0005\u0015\u0014bAA4Q\u0005AB)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005-\u0014Q\u000e\u0002\u0015\t\u0016dW\r^1cY\u0016$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005\u001d\u0004&A\rbkR|W*\u001b:s_J$v\u000e]5d%\u0016\u001c\bo\u001c8tKN\u0004\u0013A\n3p\u0007J,\u0017\r^3WC2LG-\u0019;f\u001f:d\u00170T5se>\u0014Hk\u001c9jGJ+\u0017/^3tiR\u0011\u0011Q\u000f\t\u00063\u0006]\u00141P\u0005\u0004\u0003sR&AB(qi&|g\u000eE\u0002`\u0003{J1!a a\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018A\u00063p-\u0006d\u0017\u000eZ1uK6K'O]8s)>\u0004\u0018nY:\u0015\u0003\u0011\fQ\u0004Z8GKR\u001c\u0007nU8ve\u000e,Gk\u001c9jG&sgm\u001c:nCRLwN\\\u0001%I>4\u0016\r\\5eCR,W*\u001b:s_J$v\u000e]5dg^KG\u000f[*pkJ\u001cW-\u00138g_R\u0019A-a#\t\u000f\u00055E\u00031\u0001\u0002\u0010\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u0003Z\u0003##\u0017bAAJ5\nIa)\u001e8di&|g\u000eM\u0001\u001aI>\u001c%/Z1uK\u001aKg.\u00197U_BL7MU3rk\u0016\u001cH/\u0001\fe_N+g\u000e\u001a*fgB|gn]3U_\u000ec\u0017.\u001a8u\u0003=rw.T5se>\u0014Hk\u001c9jGN|%/\u00117m\u001b&\u0014(o\u001c:U_BL7m\u001d$bS2,GMV1mS\u0012\fG/[8o)\t\ti\nE\u0002Z\u0003?K1!!)[\u0005\u001d\u0011un\u001c7fC:\fQb];qKJ$#/Z9vKN$X#\u0001\u001f")
public class DeleteMirrorTopicsHelperKraft
extends MirrorTopicRequestHelperKraft<DeleteTopicsResponseData> {
    private final ClusterLinkFactory.AdminManager adminManager;
    private final AuthHelper authHelper;
    private final MetadataCache metadataCache;
    private final Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse;
    private final Function2<RequestChannel.Request, Function1<Object, AbstractResponse>, BoxedUnit> sendThrottledResponse;
    private final DeleteTopicsRequest deleteTopicRequest;
    private final ListBuffer<DeleteTopicsRequestData.DeleteTopicState> autoMirrorTopics;
    private final ListBuffer<DeleteTopicsResponseData.DeletableTopicResult> autoMirrorTopicResponses;

    private /* synthetic */ RequestChannel.Request super$request() {
        return super.request();
    }

    private DeleteTopicsRequest deleteTopicRequest() {
        return this.deleteTopicRequest;
    }

    private ListBuffer<DeleteTopicsRequestData.DeleteTopicState> autoMirrorTopics() {
        return this.autoMirrorTopics;
    }

    private ListBuffer<DeleteTopicsResponseData.DeletableTopicResult> autoMirrorTopicResponses() {
        return this.autoMirrorTopicResponses;
    }

    @Override
    public Option<AbstractRequest> doCreateValidateOnlyMirrorTopicRequest() {
        return None$.MODULE$;
    }

    @Override
    public void doValidateMirrorTopics() {
        this.deleteTopicRequest().topics().forEach(topic -> {
            if (topic.name() != null) {
                Uuid uuid = topic.topicId();
                Uuid uuid2 = Uuid.ZERO_UUID;
                if (uuid != null ? !uuid.equals(uuid2) : uuid2 != null) return;
            }
            if (topic.name() == null) {
                Uuid uuid = topic.topicId();
                Uuid uuid3 = Uuid.ZERO_UUID;
                if (!(uuid == null ? uuid3 != null : !uuid.equals(uuid3))) return;
            }
            Option topicName = Option$.MODULE$.apply(topic.name()).orElse((Function0<Option> & Serializable)() -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.metadataCache.getTopicName(topic.topicId()))));
            boolean isAutoMirrorTopic = topicName.exists((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(DeleteMirrorTopicsHelperKraft.$anonfun$doValidateMirrorTopics$7(this, name)));
            if ($this.adminManager.clusterLinkManager().isMigratingMirroredTopic(topic.name())) {
                throw new InvalidRequestException("Cannot delete mirror topic: " + topic + " before promotion.");
            }
            if (!isAutoMirrorTopic) return;
            this.autoMirrorTopics().$plus$eq((DeleteTopicsRequestData.DeleteTopicState)topic);
            if (!$this.authHelper.authorize(this.super$request().context(), AclOperation.DESCRIBE, ResourceType.TOPIC, (String)topicName.get(), $this.authHelper.authorize$default$5(), $this.authHelper.authorize$default$6(), $this.authHelper.authorize$default$7())) {
                this.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED));
                return;
            }
            if (!$this.authHelper.authorize(this.super$request().context(), AclOperation.DELETE, ResourceType.TOPIC, (String)topicName.get(), $this.authHelper.authorize$default$5(), $this.authHelper.authorize$default$6(), $this.authHelper.authorize$default$7())) {
                this.appendResponse$1((String)topicName.get(), topic.topicId(), new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED));
                return;
            }
            if ($this.adminManager.clusterLinkingIsDisabled()) {
                this.appendResponse$1((String)topicName.get(), topic.topicId(), ApiError.fromThrowable((Throwable)ClusterLinkDisabled$.MODULE$.exception(ClusterLinkDisabled$.MODULE$.exception$default$1())));
                return;
            }
            Object errMsg = "Auto-mirrored topic cannot be deleted. The topic " + topicName.get() + " should be excluded from auto.create.mirror.topics.filters on cluster link";
            Option<ClusterLinkMetadataManager> option = $this.adminManager.clusterLinkManager().clusterLinkMetadataManager();
            if (option instanceof Some) {
                Some some = (Some)option;
                ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)some.value();
                Option option2 = metadataManager.mirrorTopicStatesFromMetadataCache((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topicName.get()}))).get((String)topicName.get());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ClusterLinkTopicState mirrorTopic = (ClusterLinkTopicState)some2.value();
                    String linkName = mirrorTopic.linkName();
                    if (linkName != null) {
                        errMsg = StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString((String)errMsg), " " + linkName);
                    }
                } else if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            } else if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.appendResponse$1((String)topicName.get(), topic.topicId(), new ApiError(Errors.TOPIC_DELETION_DISABLED.code(), (String)errMsg));
        });
    }

    @Override
    public void doFetchSourceTopicInformation() {
    }

    @Override
    public void doValidateMirrorTopicsWithSourceInfo(Function0<BoxedUnit> callback) {
        callback.apply$mcV$sp();
    }

    @Override
    public Option<AbstractRequest> doCreateFinalTopicRequest() {
        if (this.autoMirrorTopics().isEmpty()) {
            return new Some<DeleteTopicsRequest>(this.deleteTopicRequest());
        }
        boolean bl = !this.deleteTopicRequest().data().topicNames().isEmpty() ? this.deleteTopicRequest().data().topicNames().removeAll(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.autoMirrorTopics().map((Function1<DeleteTopicsRequestData.DeleteTopicState, String> & Serializable)x$23 -> x$23.name())).asJavaCollection()) : this.deleteTopicRequest().data().topics().removeAll(CollectionConverters$.MODULE$.IterableHasAsJava(this.autoMirrorTopics()).asJavaCollection());
        if (this.deleteTopicRequest().numberOfTopics() != 0) {
            return new Some<DeleteTopicsRequest>(this.deleteTopicRequest());
        }
        return None$.MODULE$;
    }

    @Override
    public void doSendResponseToClient() {
        Option<AbstractResponse> option = this.finalResponseFromController();
        if (option instanceof Some) {
            Some some = (Some)option;
            AbstractResponse finalResponse = (AbstractResponse)some.value();
            this.autoMirrorTopicResponses().foreach((Function1<DeleteTopicsResponseData.DeletableTopicResult, Object> & Serializable)response -> BoxesRunTime.boxToBoolean(DeleteMirrorTopicsHelperKraft.$anonfun$doSendResponseToClient$5(finalResponse, response)));
            this.sendForwardedResponse.apply(super.request(), finalResponse);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.sendThrottledResponse.apply(super.request(), (Function1<Object, AbstractResponse>)(Function1<Object, DeleteTopicsResponse> & Serializable)throttleTimeMs -> DeleteMirrorTopicsHelperKraft.$anonfun$doSendResponseToClient$6(this, BoxesRunTime.unboxToInt(throttleTimeMs)));
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean noMirrorTopicsOrAllMirrorTopicsFailedValidation() {
        return false;
    }

    private final void appendResponse$1(String topicName, Uuid topicId, ApiError apiError) {
        this.autoMirrorTopicResponses().$plus$eq(new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setTopicId(topicId).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
    }

    public static final /* synthetic */ boolean $anonfun$doValidateMirrorTopics$7(DeleteMirrorTopicsHelperKraft $this, String name) {
        return $this.adminManager.clusterLinkManager().isAutoMirroredTopic(name);
    }

    public static final /* synthetic */ boolean $anonfun$doSendResponseToClient$5(AbstractResponse finalResponse$3, DeleteTopicsResponseData.DeletableTopicResult response) {
        return ((DeleteTopicsResponse)finalResponse$3).data().responses().add((ImplicitLinkedHashCollection.Element)response.duplicate());
    }

    public static final /* synthetic */ DeleteTopicsResponse $anonfun$doSendResponseToClient$6(DeleteMirrorTopicsHelperKraft $this, int throttleTimeMs) {
        return new DeleteTopicsResponse(new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(CollectionConverters$.MODULE$.BufferHasAsJava($this.autoMirrorTopicResponses()).asJava().iterator())).setThrottleTimeMs(throttleTimeMs));
    }

    public DeleteMirrorTopicsHelperKraft(ClusterLinkFactory.AdminManager adminManager, RequestChannel.Request request, AuthHelper authHelper, ForwardingManager fwdMgr, MetadataCache metadataCache, Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse, Function2<RequestChannel.Request, Function1<Object, AbstractResponse>, BoxedUnit> sendThrottledResponse, Function2<RequestChannel.Request, Throwable, BoxedUnit> handleErrorResponse, Function1<RequestChannel.Request, BoxedUnit> handleInvalidVersionsDuringForwarding) {
        this.adminManager = adminManager;
        this.authHelper = authHelper;
        this.metadataCache = metadataCache;
        this.sendForwardedResponse = sendForwardedResponse;
        this.sendThrottledResponse = sendThrottledResponse;
        super(request, fwdMgr, handleErrorResponse, handleInvalidVersionsDuringForwarding);
        this.deleteTopicRequest = (DeleteTopicsRequest)super.request().body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class));
        this.autoMirrorTopics = new ListBuffer();
        this.autoMirrorTopicResponses = new ListBuffer();
    }
}

