/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkCoordinatorEndpointResolver;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.LinkCoordinatorManager;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u00192\u0001aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000b5\u0004A\u0011\u00018\t\u000fY\u0004!\u0019!C\to\"9\u0011q\u0001\u0001!\u0002\u0013A\bbCA\u0005\u0001\u0001\u0007\t\u0019!C\t\u0003\u0017A1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\u0010!Q\u00111\u0004\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u001c\u0001\u0001\u0006I!!\t\t\u0017\u0005e\u0002\u00011AA\u0002\u0013%\u00111\b\u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0004C\u0006\u0002D\u0001\u0001\r\u0011!Q!\n\u0005E\u0002\"CA#\u0001\u0001\u0007I\u0011BA$\u0011%\ty\u0005\u0001a\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002V\u0001\u0001\u000b\u0015BA%\u0011%\t9\u0006\u0001b\u0001\n#\tY\u0004\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA\u0019\u0011%\tY\u0006\u0001b\u0001\n\u0013\ti\u0006\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA0\u0011%\ty\u0007\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA\u0019\u0011%\t\u0019\b\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA%\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\t\u0001b\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAD\u0011\u001d\tI\n\u0001C!\u00037Cq!!(\u0001\t\u0013\ty\nC\u0004\u00020\u0002!I!!-\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\tI\u0010\u0001C!\u00037Cq!a?\u0001\t\u0003\ni\u0010C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!q\u0005\u0001\u0005R\u0005m\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005k\u0001A\u0011BAN\u0011\u001d\u00119\u0004\u0001C\u0005\u0005s\u0011\u0001dS\u0019MS:\\7i\\8sI&t\u0017\r^8s\u001b\u0006t\u0017mZ3s\u0015\t\u00114'\u0001\u0003mS:\\'B\u0001\u001b6\u0003\u0019\u0019XM\u001d<fe*\ta'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0004C\u0001\u001e<\u001b\u0005\t\u0014B\u0001\u001f2\u0005Ya\u0015N\\6D_>\u0014H-\u001b8bi>\u0014X*\u00198bO\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA A\u001b\u0005\u0019\u0014BA!4\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u001eE\u0013\t)\u0015G\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005![U\"A%\u000b\u0005)\u001b\u0014\u0001C7fi\u0006$\u0017\r^1\n\u00051K%aF&SC\u001a$\u0018*\\1hK6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003EawnY1m\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\t\u0004\u001fJ#V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA+`\u001b\u00051&BA,Y\u0003\u0015\tG-\\5o\u0015\tI&,A\u0004dY&,g\u000e^:\u000b\u0005YZ&B\u0001/^\u0003\u0019\t\u0007/Y2iK*\ta,A\u0002pe\u001eL!\u0001\u0019,\u0003\u000b\u0005#W.\u001b8\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0002dO6\tAM\u0003\u0002fM\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005QR\u0016B\u00015e\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\u0006yB.\u001b8l\u0007>|'\u000fZ5oCR|'/\u00128ea>Lg\u000e\u001e*fg>dg/\u001a:\u0011\u0005iZ\u0017B\u000172\u0005\u0019\u001aE.^:uKJd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014XI\u001c3q_&tGOU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\u0004\u0018O]:ukB\u0011!\b\u0001\u0005\u0006{\u001d\u0001\rA\u0010\u0005\u0006\u0005\u001e\u0001\ra\u0011\u0005\u0006\r\u001e\u0001\ra\u0012\u0005\u0006\u001b\u001e\u0001\rA\u0014\u0005\u0006C\u001e\u0001\rA\u0019\u0005\u0006S\u001e\u0001\rA[\u0001\u000e[\u0016$\u0018\rZ1uCR{\u0007/[2\u0016\u0003a\u00042!_A\u0001\u001d\tQh\u0010\u0005\u0002|!6\tAP\u0003\u0002~o\u00051AH]8pizJ!a )\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\ty\b+\u0001\bnKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002\u00151|7-\u00197BI6Lg.F\u0001U\u00039awnY1m\u0003\u0012l\u0017N\\0%KF$B!!\u0005\u0002\u0018A\u0019q*a\u0005\n\u0007\u0005U\u0001K\u0001\u0003V]&$\b\u0002CA\r\u0017\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0013'A\u0006m_\u000e\fG.\u00113nS:\u0004\u0013a\u00059beRLG/[8o)>,\u0005o\\2i\u001b\u0006\u0004XCAA\u0011!!\t\u0019#!\f\u00022\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000f5,H/\u00192mK*\u0019\u00111\u0006)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\u0005\u0015\"aA'baB\u0019q*a\r\n\u0007\u0005U\u0002KA\u0002J]R\fA\u0003]1si&$\u0018n\u001c8U_\u0016\u0003xn\u00195NCB\u0004\u0013!\u00068v[6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003c\t\u0011D\\;n\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011\u0011CA!\u0011%\tI\u0002EA\u0001\u0002\u0004\t\t$\u0001\fok6lU\r^1eCR\f\u0007+\u0019:uSRLwN\\:!\u0003)qW/\u001c*fiJLWm]\u000b\u0003\u0003\u0013\u00022aTA&\u0013\r\ti\u0005\u0015\u0002\u0005\u0019>tw-\u0001\bok6\u0014V\r\u001e:jKN|F%Z9\u0015\t\u0005E\u00111\u000b\u0005\n\u00033\u0019\u0012\u0011!a\u0001\u0003\u0013\n1B\\;n%\u0016$(/[3tA\u0005\u0001\"/Z9vKN$H+[7f_V$Xj]\u0001\u0012e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0013a\u0005:fiJL\u0018J\\5uS\u0006dG)\u001a7bs6\u001bXCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0005\r\u0014\u0001\u0006:fiJL\u0018J\\5uS\u0006dG)\u001a7bs6\u001b\b%A\bsKR\u0014\u00180T;mi&\u0004H.[3s\u0003A\u0011X\r\u001e:z\u001bVdG/\u001b9mS\u0016\u0014\b%\u0001\nsKR\u0014\u00180T1y\u0013:$XM\u001d<bY6\u001b\u0018a\u0005:fiJLX*\u0019=J]R,'O^1m\u001bN\u0004\u0013a\u0003:fiJL(*\u001b;uKJ,\"!a\u001f\u0011\u0007=\u000bi(C\u0002\u0002\u0000A\u0013a\u0001R8vE2,\u0017\u0001\u0004:fiJL(*\u001b;uKJ\u0004\u0013\u0001\u0004:fiJL()Y2l_\u001a4WCAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000bQ!\u001e;jYNT1!!%[\u0003\u0019\u0019w.\\7p]&!\u0011QSAF\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u001bI,GO]=CC\u000e\\wN\u001a4!\u0003\u001d\u0019H/\u0019:ukB$\"!!\u0005\u0002\u001fM$\u0018M\u001d;va&sG/\u001a:oC2$b!!\u0005\u0002\"\u0006\u0015\u0006bBARE\u0001\u0007\u0011\u0011J\u0001\bI\u0016d\u0017-_'t\u0011\u001d\t9K\ta\u0001\u0003S\u000b1b\u0019:fCR,Gk\u001c9jGB\u0019q*a+\n\u0007\u00055\u0006KA\u0004C_>dW-\u00198\u0002C1|wn[;q\u0003:$W*Y=cK\u000e\u0013X-\u0019;f\u001b\u0016$\u0018\rZ1uCR{\u0007/[2\u0015\t\u0005E\u00111\u0017\u0005\b\u0003O\u001b\u0003\u0019AAU\u0003)yg.\u00127fGRLwN\u001c\u000b\u0007\u0003#\tI,!0\t\u000f\u0005mF\u00051\u0001\u00022\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\ty\f\na\u0001\u0003c\t1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006iqN\u001c*fg&<g.\u0019;j_:$b!!\u0005\u0002F\u0006\u001d\u0007bBA^K\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003\u007f+\u0003\u0019AAe!\u0015y\u00151ZA\u0019\u0013\r\ti\r\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u000235\f\u0017PY3Va\u0012\fG/\u001a)beRLG/[8o\u000bB|7\r\u001b\u000b\u0007\u0003S\u000b\u0019.!6\t\u000f\u0005mf\u00051\u0001\u00022!9\u0011q\u0018\u0014A\u0002\u0005%\u0017a\u00047j].\u001cun\u001c:eS:\fGo\u001c:\u0015\r\u0005m\u0017Q]Au!\u0015y\u00151ZAo!\u0011\ty.!9\u000e\u0005\u0005=\u0015\u0002BAr\u0003\u001f\u0013AAT8eK\"1\u0011q]\u0014A\u0002a\f\u0001\u0002\\5oW:\u000bW.\u001a\u0005\b\u0003W<\u0003\u0019AAw\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\ty/!>\u000e\u0005\u0005E(\u0002BAz\u0003\u001f\u000bqA\\3uo>\u00148.\u0003\u0003\u0002x\u0006E(\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001C:ikR$wn\u001e8\u0002\u0011I,w-[:uKJ$B!!\u0005\u0002\u0000\"9!\u0011A\u0015A\u0002\t\r\u0011\u0001\u00037jgR,g.\u001a:\u0011\t\t\u0015!1\u0002\b\u0004u\t\u001d\u0011b\u0001B\u0005c\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\u0011\u0011iAa\u0004\u0003/1Kgn[\"p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u0014(b\u0001B\u0005c\u0005\u0019R.\u001a;bI\u0006$\u0018\rV8qS\u000e\u001cuN\u001c4jOV\u0011!Q\u0003\t\u0007\u0005/\u0011i\u0002\u001f=\u000e\u0005\te!\u0002\u0002B\u000e\u0003O\nA!\u001e;jY&!\u0011q\u0006B\r\u0003IawnZ#se>\u00148o\u00148GC&dWO]3\u0015\t\u0005E!1\u0005\u0005\u0007\u0005KY\u0003\u0019\u0001=\u0002\u0007M$(/\u0001\rhKRtU/\\'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N\fadZ3u\u001b\u0016$\u0018\rZ1uCR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0016\u0005\t5\u0002#B(\u0002L\n=\u0002\u0003BA1\u0005cIAAa\r\u0002d\t9\u0011J\u001c;fO\u0016\u0014\u0018aE2sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001c\u0017!G5oSRL\u0017\r\\5{K6+G/\u00193bi\u0006l\u0015M\\1hKJ$B!!\u0005\u0003<!9!QH\u0018A\u0002\u0005E\u0012A\u00049beRLG/[8o\u0007>,h\u000e\u001e")
public class K1LinkCoordinatorManager
extends LinkCoordinatorManager {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private final KRaftImageMetadataCache metadataCache;
    private final Function0<Admin> localAdminFactory;
    private final ClusterLinkCoordinatorEndpointResolver linkCoordinatorEndpointResolver;
    private final String metadataTopic;
    private Admin localAdmin;
    private final scala.collection.mutable.Map<Object, Object> partitionToEpochMap;
    private int numMetadataPartitions;
    private long numRetries;
    private final int requestTimeoutMs;
    private final Long retryInitialDelayMs;
    private final int retryMultiplier;
    private final long retryMaxIntervalMs;
    private final double retryJitter;
    private final ExponentialBackoff retryBackoff;

    public String metadataTopic() {
        return this.metadataTopic;
    }

    public Admin localAdmin() {
        return this.localAdmin;
    }

    public void localAdmin_$eq(Admin x$1) {
        this.localAdmin = x$1;
    }

    private scala.collection.mutable.Map<Object, Object> partitionToEpochMap() {
        return this.partitionToEpochMap;
    }

    private int numMetadataPartitions() {
        return this.numMetadataPartitions;
    }

    private void numMetadataPartitions_$eq(int x$1) {
        this.numMetadataPartitions = x$1;
    }

    private long numRetries() {
        return this.numRetries;
    }

    private void numRetries_$eq(long x$1) {
        this.numRetries = x$1;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private Long retryInitialDelayMs() {
        return this.retryInitialDelayMs;
    }

    private int retryMultiplier() {
        return this.retryMultiplier;
    }

    private long retryMaxIntervalMs() {
        return this.retryMaxIntervalMs;
    }

    private double retryJitter() {
        return this.retryJitter;
    }

    private ExponentialBackoff retryBackoff() {
        return this.retryBackoff;
    }

    @Override
    public void startup() {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkMetadataTopicEnable()) || this.metadataCache instanceof KRaftMetadataCache) {
            this.startupInternal(0L, true);
            return;
        }
    }

    private void startupInternal(long delayMs, boolean createTopic) {
        if (this.localAdmin() == null) {
            this.localAdmin_$eq(this.localAdminFactory.apply());
        }
        this.scheduler.scheduleOnce("lookupOrMaybeClusterLinkMetadataTopic", () -> this.lookupAndMaybeCreateMetadataTopic(createTopic), delayMs);
    }

    private void lookupAndMaybeCreateMetadataTopic(boolean createTopic) {
        Option<Integer> numPartitions = this.getMetadataTopicPartitionCount();
        if (numPartitions.nonEmpty()) {
            if (!BoxesRunTime.equals(numPartitions.get(), this.brokerConfig.clusterLinkMetadataTopicPartitions())) {
                this.warn((Function0<String> & Serializable)() -> "Found internal metadata topic with different number of partitions(" + numPartitions.get() + ") than in the config(" + $this.brokerConfig.clusterLinkMetadataTopicPartitions());
            }
            this.initializeMetadataManager(Predef$.MODULE$.Integer2int(numPartitions.get()));
            return;
        }
        if (createTopic) {
            this.createMetadataTopic();
            return;
        }
        this.startupInternal(Predef$.MODULE$.Long2long(this.retryInitialDelayMs()), false);
    }

    @Override
    public void onElection(int partitionId, int leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, new Some<Object>(BoxesRunTime.boxToInteger(leaderEpoch)))) {
                this.debug((Function0<String> & Serializable)() -> "Elected as link coordinator for links with metadata topic partition " + partitionId + " at epoch " + leaderEpoch);
                bl2 = this.ownedPartitions().add(BoxesRunTime.boxToInteger(partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean elected = bl;
        Object links = elected ? this.getClusterLinksForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach(arg_0 -> K1LinkCoordinatorManager.$anonfun$onElection$2$adapted((Set)links, arg_0));
    }

    @Override
    public void onResignation(int partitionId, Option<Object> leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, leaderEpoch)) {
                this.debug((Function0<String> & Serializable)() -> "Resigned as link coordinator for links with metadata topic partition " + partitionId + " at epoch " + leaderEpoch);
                bl2 = this.ownedPartitions().remove(BoxesRunTime.boxToInteger(partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean resigned = bl;
        Object linkIds = resigned ? (Set)this.getClusterLinksForPartitionId(partitionId).map((Function1<ClusterLinkData, Uuid> & Serializable)x$4 -> x$4.linkId()) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach(arg_0 -> K1LinkCoordinatorManager.$anonfun$onResignation$3$adapted((Set)linkIds, arg_0));
    }

    private boolean maybeUpdatePartitionEpoch(int partitionId, Option<Object> leaderEpoch) {
        if (leaderEpoch.isEmpty()) {
            return true;
        }
        int newLeaderEpoch = BoxesRunTime.unboxToInt(leaderEpoch.get());
        boolean bl = false;
        Some some = null;
        Option option = this.partitionToEpochMap().get(BoxesRunTime.boxToInteger(partitionId));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int epoch = BoxesRunTime.unboxToInt(some.value());
            if (newLeaderEpoch > epoch) {
                this.partitionToEpochMap().put(BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToInteger(newLeaderEpoch));
                return true;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.partitionToEpochMap().put(BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToInteger(newLeaderEpoch));
            return true;
        }
        if (bl) {
            return false;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Node> linkCoordinator(String linkName, ListenerName listenerName) {
        Option<Node> option;
        block5: {
            Object object = this.lock();
            synchronized (object) {
                None$ none$;
                block4: {
                    if (!this.initialized()) {
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    option = this.linkCoordinatorEndpointResolver.getPartitionEndpoint(this.linkNameToPartitionId(linkName), listenerName).get(this.brokerConfig.requestTimeoutMs(), TimeUnit.MILLISECONDS);
                    break block5;
                }
                return none$;
            }
        }
        return option;
    }

    @Override
    public void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            super.shutdown();
            this.partitionToEpochMap().clear();
            this.numMetadataPartitions_$eq(-1);
        }
    }

    @Override
    public void register(ClusterLinkFactory.LinkCoordinatorListener listener) {
        super.register(listener);
    }

    private Map<String, String> metadataTopicConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", this.brokerConfig.clusterLinkMetadataTopicMinInSyncReplicas().toString());
        return props;
    }

    private void logErrorsOnFailure(String str) {
        if (this.numRetries() % 30L == 0L) {
            this.error((Function0<String> & Serializable)() -> str);
            return;
        }
        this.debug((Function0<String> & Serializable)() -> str);
    }

    @Override
    public int getNumMetadataPartitions() {
        return this.numMetadataPartitions();
    }

    private Option<Integer> getMetadataTopicPartitionCount() {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.metadataCache.numPartitions(this.metadataTopic())));
    }

    private void createMetadataTopic() {
        NewTopic topic = new NewTopic(this.metadataTopic(), Predef$.MODULE$.Integer2int(this.brokerConfig.clusterLinkMetadataTopicPartitions()), Predef$.MODULE$.Short2short(this.brokerConfig.clusterLinkMetadataTopicReplicationFactor()));
        topic.configs(this.metadataTopicConfig());
        CreateTopicsResult createResult = this.localAdmin().createTopics(Collections.singletonList(topic));
        this.scheduler.scheduleWhenComplete("createClusterLinkMetadataTopicResponse", createResult.all(), () -> {
            Throwable ex;
            Throwable throwable;
            try {
                this.initializeMetadataManager(Predef$.MODULE$.Integer2int((Integer)createResult.numPartitions(this.metadataTopic()).get()));
                throwable = null;
            }
            catch (ExecutionException ex2) {
                Throwable throwable2 = ex2.getCause();
                if (throwable2 instanceof TopicExistsException) {
                    this.debug((Function0<String> & Serializable)() -> "Cluster link metadata topic creation failed as it is already created.");
                } else if (throwable2 instanceof TopicAuthorizationException) {
                    TopicAuthorizationException topicAuthorizationException = (TopicAuthorizationException)throwable2;
                    this.logErrorsOnFailure("Unable to create cluster link metadata topic due to " + topicAuthorizationException + ": " + ex2.getMessage());
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.logErrorsOnFailure("Cluster link metadata topic creation failed: " + throwable3);
                } else if (throwable2 == null) {
                    this.logErrorsOnFailure("Cluster link metadata topic creation failed but found no underlying cause: " + ex2);
                } else {
                    throw new MatchError((Object)throwable2);
                }
                throwable = (Throwable)Option$.MODULE$.apply(ex2.getCause()).getOrElse((Function0<ExecutionException> & Serializable)() -> ex2);
            }
            catch (Throwable e) {
                this.logErrorsOnFailure("Cluster link metadata topic creation failed: " + e);
                throwable = ex = e;
            }
            if (ex != null) {
                Throwable throwable4 = ex;
                if (throwable4 instanceof TopicExistsException) {
                    this.startupInternal(Predef$.MODULE$.Long2long(this.retryInitialDelayMs()), false);
                    return;
                }
                if (throwable4 != null) {
                    this.numRetries_$eq(this.numRetries() + 1L);
                    this.startupInternal(this.retryBackoff().backoff(this.numRetries() - 1L), true);
                    return;
                }
                throw new MatchError((Object)throwable4);
            }
        });
    }

    private void initializeMetadataManager(int partitionCount) {
        Object object = this.lock();
        synchronized (object) {
            this.numMetadataPartitions_$eq(partitionCount);
            this.initialized_$eq(true);
        }
        this.numRetries_$eq(0L);
        Set<ClusterLinkData> links = this.getClusterLinksWithOwnedLinkCoordinator();
        this.metadataImageListeners().foreach((Function1<ClusterLinkFactory.LinkCoordinatorListener, Object> & Serializable)x$6 -> {
            x$6.onClusterLinkCoordinatorElection(links);
            return BoxedUnit.UNIT;
        });
    }

    public K1LinkCoordinatorManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftImageMetadataCache metadataCache, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo, ClusterLinkCoordinatorEndpointResolver linkCoordinatorEndpointResolver) {
        this.brokerConfig = brokerConfig;
        this.scheduler = scheduler;
        this.metadataCache = metadataCache;
        this.localAdminFactory = localAdminFactory;
        this.linkCoordinatorEndpointResolver = linkCoordinatorEndpointResolver;
        super(metadataCache);
        this.metadataTopic = "_confluent-link-metadata";
        this.partitionToEpochMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.numRetries = 0L;
        this.requestTimeoutMs = Predef$.MODULE$.Integer2int(new AdminClientConfig(ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint())).getInt("request.timeout.ms"));
        this.retryInitialDelayMs = brokerConfig.clusterLinkMetadataTopicCreateRetryDelayMs();
        this.retryMultiplier = 2;
        this.retryMaxIntervalMs = TimeUnit.SECONDS.toMillis(32L);
        this.retryJitter = 0.2;
        this.retryBackoff = new ExponentialBackoff(Predef$.MODULE$.Long2long(this.retryInitialDelayMs()), this.retryMultiplier(), this.retryMaxIntervalMs(), this.retryJitter());
    }

    public static final /* synthetic */ Object $anonfun$onElection$2$adapted(Set links$1, ClusterLinkFactory.LinkCoordinatorListener x$3) {
        x$3.onClusterLinkCoordinatorElection(links$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$onResignation$3$adapted(Set linkIds$1, ClusterLinkFactory.LinkCoordinatorListener x$5) {
        x$5.onClusterLinkCoordinatorResignation(linkIds$1);
        return BoxedUnit.UNIT;
    }
}

