/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkData;
import kafka.server.metadata.KRaftImageMetadataCache;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterClusterLinkOp;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterClusterLinksRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClusterLinksRequest;
import org.apache.kafka.common.requests.AlterClusterLinksResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u000e\u001c\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\t\u0006A1A\u0005\u0012ICaA\u0016\u0001!\u0002\u0013\u0019\u0006\"B,\u0001\t\u0003A\u0006\"\u0002:\u0001\t\u0003\u0019\b\"B?\u0001\t\u0003q\bbBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0001\u0003\u000fC\u0011\"!(\u0001#\u0003%\t!a(\t\u0013\u0005\r\u0006!%A\u0005\u0002\u0005\u0015\u0006\"CAU\u0001E\u0005I\u0011AAV\u0011%\ty\u000bAI\u0001\n\u0003\t\t\fC\u0005\u00026\u0002\t\n\u0011\"\u0001\u00028\"I\u00111\u0018\u0001\u0012\u0002\u0013\u0005\u0011Q\u0015\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t)\u0010\u0001C\u0001\u0003oDq!a?\u0001\t\u0003\ti\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\u001c!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0002\u0019\u0017J\u000bg\r\u001e'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014(B\u0001\u000f\u001e\u0003\u0011a\u0017N\\6\u000b\u0005yy\u0012AB:feZ,'OC\u0001!\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u00031\u0011'o\\6fe\u000e{gNZ5h!\tYC&D\u0001\u001e\u0013\tiSDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u00021g5\t\u0011G\u0003\u00023;\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u00025c\t92JU1gi&k\u0017mZ3NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\bCA\u001cA\u001b\u0005A$BA\u001d;\u0003\u0019\u0019w.\\7p]*\u0011ad\u000f\u0006\u0003AqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011\t\u000f\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f!b]3sm\u0016\u0014\u0018J\u001c4p!\t!u)D\u0001F\u0015\t1%(\u0001\u0006bkRDwN]5{KJL!\u0001S#\u0003)\u0005+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p\u0003\u0019a\u0014N\\5u}Q)1*\u0014(P!B\u0011A\nA\u0007\u00027!)\u0011&\u0002a\u0001U!)a&\u0002a\u0001_!)Q'\u0002a\u0001m!)!)\u0002a\u0001\u0007\u0006\u0001\"/Z9vKN$H+[7f_V$Xj]\u000b\u0002'B\u0011A\u0005V\u0005\u0003+\u0016\u00121!\u00138u\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000fI\u0001\u0013GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0002ZUB\u0019!,Y2\u000e\u0003mS!\u0001X/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002_?\u0006!Q\u000f^5m\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY.\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0002eQ6\tQM\u0003\u0002gO\u0006A!/Z9vKN$8O\u0003\u0002:w%\u0011\u0011.\u001a\u0002\u001b\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3ta>t7/\u001a\u0005\u0006W\"\u0001\r\u0001\\\u0001\u001eGJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3rk\u0016\u001cH\u000fR1uCB\u0011Q\u000e]\u0007\u0002]*\u0011qnZ\u0001\b[\u0016\u001c8/Y4f\u0013\t\thNA\u000fDe\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b\u0003a!W\r\\3uKN;\u0018\u000e^2i_Z,'/T3uC\u0012\fG/\u0019\u000b\u0003i^\u0004\"\u0001J;\n\u0005Y,#\u0001B+oSRDQ\u0001_\u0005A\u0002e\fa\u0001\\5oW&#\u0007C\u0001>|\u001b\u00059\u0017B\u0001?h\u0005\u0011)V/\u001b3\u00021\r\u0014X-\u0019;f'^LGo\u00195pm\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004u\u007f\u0006\u0005\u00111\u0002\u0005\u0006q*\u0001\r!\u001f\u0005\b\u0003\u0007Q\u0001\u0019AA\u0003\u0003M\u0019x/\u001b;dQ>4XM\u001d+j[\u0016\u001cH/Y7q!\r!\u0013qA\u0005\u0004\u0003\u0013)#\u0001\u0002'p]\u001eDq!!\u0004\u000b\u0001\u0004\ty!A\bto&$8\r[8wKJ\u001cF/\u0019;f!\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011qC\u0007\u0003\u0003+Q!AM\u001e\n\t\u0005e\u0011QC\u0001\u001e\u00072,8\u000f^3s\u0019&t7nU<ji\u000eDwN^3s\u001b\u0016$\u0018\rZ1uC&!\u0011QDA\u0010\u0005=\u0019v/\u001b;dQ>4XM]*uCR,'\u0002BA\r\u0003+\t\u0001#\u00197uKJ\u001cE.^:uKJd\u0015N\\6\u0015#Q\f)#a\n\u0002<\u0005u\u0013qLA2\u0003[\n\t\tC\u0003y\u0017\u0001\u0007\u0011\u0010C\u0005\u0002*-\u0001\n\u00111\u0001\u0002,\u0005\u0011\u0012\r\u001c;fe\u000ecWo\u001d;fe2Kgn[(q!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tQ!\u00193nS:T1!!\u000e<\u0003\u001d\u0019G.[3oiNLA!!\u000f\u00020\t\u0011\u0012\t\u001c;fe\u000ecWo\u001d;fe2Kgn[(q\u0011%\tid\u0003I\u0001\u0002\u0004\ty$\u0001\bto&$8\r[8wKJ$\u0016\u0010]3\u0011\t\u0005\u0005\u0013\u0011\f\b\u0005\u0003\u0007\n9B\u0004\u0003\u0002F\u0005]c\u0002BA$\u0003+rA!!\u0013\u0002T9!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0005\na\u0001\u0010:p_Rt\u0014\"A \n\u0005ur\u0014B\u0001\u0011=\u0013\t\u00114(\u0003\u0003\u0002\\\u0005}!AD*xSR\u001c\u0007n\u001c<feRK\b/\u001a\u0005\n\u0003\u0007Y\u0001\u0013!a\u0001\u0003\u000bA\u0011\"!\u0004\f!\u0003\u0005\r!!\u0019\u0011\t\u0005\u0005\u00131\u0004\u0005\n\u0003KZ\u0001\u0013!a\u0001\u0003O\n\u0011\"\u001a:s_J\u001cu\u000eZ3\u0011\u0007\u0011\nI'C\u0002\u0002l\u0015\u0012Qa\u00155peRD\u0011\"a\u001c\f!\u0003\u0005\r!!\u001d\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\t\u0005M\u00141\u0010\b\u0005\u0003k\n9\bE\u0002\u0002L\u0015J1!!\u001f&\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011P\u0013\t\u0013\u0005\r5\u0002%AA\u0002\u0005\u0015\u0011!F2p]R\u0014x\u000e\u001c)mC:,G+[7fgR\fW\u000e]\u0001\u001bC2$XM]\"mkN$XM\u001d'j].$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013SC!a\u000b\u0002\f.\u0012\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018\u0016\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY*!%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ebYR,'o\u00117vgR,'\u000fT5oW\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\"*\"\u0011qHAF\u0003i\tG\u000e^3s\u00072,8\u000f^3s\u0019&t7\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\t9K\u000b\u0003\u0002\u0006\u0005-\u0015AG1mi\u0016\u00148\t\\;ti\u0016\u0014H*\u001b8lI\u0011,g-Y;mi\u0012*TCAAWU\u0011\t\t'a#\u00025\u0005dG/\u001a:DYV\u001cH/\u001a:MS:\\G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005M&\u0006BA4\u0003\u0017\u000b!$\u00197uKJ\u001cE.^:uKJd\u0015N\\6%I\u00164\u0017-\u001e7uI]*\"!!/+\t\u0005E\u00141R\u0001\u001bC2$XM]\"mkN$XM\u001d'j].$C-\u001a4bk2$H\u0005O\u0001\u001cg\u0016tG-\u00117uKJ\u001cE.^:uKJd\u0015N\\6SKF,Xm\u001d;\u0015\u000bQ\f\t-!7\t\u000f\u0005\u00052\u00031\u0001\u0002DB!\u0011QYAj\u001d\u0011\t9-a4\u000f\t\u0005%\u0017Q\u001a\b\u0005\u0003\u000b\nY-\u0003\u0002:w%\u0011qnZ\u0005\u0004\u0003#t\u0017\u0001H!mi\u0016\u00148\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003+\f9N\u0001\u000bBYR,'o\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u0006\u0004\u0003#t\u0007bBAn'\u0001\u0007\u0011Q\\\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\r\u0005}\u0017Q]Au\u001b\t\t\tOC\u0002\u0002d\u001e\f\u0011\"\u001b8uKJt\u0017\r\\:\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0010\u0017\u000647.\u0019$viV\u0014X-S7qYB!\u00111^Ay\u001b\t\tiOC\u0002\u0002p~\u000bA\u0001\\1oO&!\u00111_Aw\u0005\u00111v.\u001b3\u0002/\u0015t7/\u001e:f\u00072,8\u000f^3s\u0019&t7.\u0012=jgR\u001cHc\u0001;\u0002z\")\u0001\u0010\u0006a\u0001s\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\t\u0005}(Q\u0001\t\u0004I\t\u0005\u0011b\u0001B\u0002K\t9!i\\8mK\u0006t\u0007\"\u0002=\u0016\u0001\u0004I\u0018AE4fi\u000ecWo\u001d;fe2Kgn\u001b#bi\u0006$BAa\u0003\u0003\u0018A)AE!\u0004\u0003\u0012%\u0019!qB\u0013\u0003\r=\u0003H/[8o!\ra%1C\u0005\u0004\u0005+Y\"aD\"mkN$XM\u001d'j].$\u0015\r^1\t\u000f\tea\u00031\u0001\u0002r\u0005AA.\u001b8l\u001d\u0006lW\r\u0006\u0003\u0003\f\tu\u0001\"\u0002=\u0018\u0001\u0004I\u0018!H2mkN$XM\u001d'j].\u001cv/\u001b;dQ>4XM]'fi\u0006$\u0017\r^1\u0015\t\t\r\"1\u0006\t\u0006I\t5!Q\u0005\t\u0005\u0003'\u00119#\u0003\u0003\u0003*\u0005U!!H\"mkN$XM\u001d'j].\u001cv/\u001b;dQ>4XM]'fi\u0006$\u0017\r^1\t\u000baD\u0002\u0019A=\u00023\u001d,Go\u00117vgR,'\u000fT5oW\u000e{gNZ5h!J|\u0007o\u001d\u000b\u0005\u0005c\u0011I\u0004\u0005\u0003\u00034\tUR\"A/\n\u0007\t]RL\u0001\u0006Qe>\u0004XM\u001d;jKNDQ\u0001_\rA\u0002e\u0004")
public class KRaftLinkMetadataManager {
    private final KRaftImageMetadataCache metadataCache;
    private final NodeToControllerChannelManager controllerChannelManager;
    private final int requestTimeoutMs;

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData createClusterLinksRequestData) {
        CompletableFuture<CreateClusterLinksResponse> result = new CompletableFuture<CreateClusterLinksResponse>();
        CreateClusterLinksRequest.Builder requestBuilder = new CreateClusterLinksRequest.Builder(createClusterLinksRequestData);
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, result){
            private final CompletableFuture result$1;

            public void handleResponse(AbstractResponse response) {
                this.debug((Function0<String> & Serializable)() -> "Received response for createClusterLinksRequest");
                this.result$1.complete((CreateClusterLinksResponse)response);
            }

            public void onFailure(Throwable ex) {
                this.debug((Function0<String> & Serializable)() -> "createClusterLinksRequest failed with exception", (Function0<Throwable> & Serializable)() -> ex);
                this.result$1.completeExceptionally(ex);
            }
            {
                this.result$1 = result$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleResponse$1(), $anonfun$onFailure$1(), $anonfun$onFailure$2(java.lang.Throwable )}, serializedLambda);
            }
        };
        this.controllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder, requestHandler);
        return result;
    }

    public void deleteSwitchoverMetadata(Uuid linkId) {
        this.alterClusterLink(linkId, AlterClusterLinkOp.DELETE, this.alterClusterLink$default$3(), this.alterClusterLink$default$4(), this.alterClusterLink$default$5(), this.alterClusterLink$default$6(), this.alterClusterLink$default$7(), this.alterClusterLink$default$8());
    }

    public void createSwitchoverMetadata(Uuid linkId, long switchoverTimestamp, ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState) {
        Uuid x$1 = linkId;
        AlterClusterLinkOp x$2 = AlterClusterLinkOp.CREATE;
        long x$3 = switchoverTimestamp;
        ClusterLinkSwitchoverMetadata.SwitchoverState x$4 = switchoverState;
        ClusterLinkSwitchoverMetadata.SwitchoverType x$5 = this.alterClusterLink$default$3();
        short x$6 = this.alterClusterLink$default$6();
        String x$7 = this.alterClusterLink$default$7();
        long x$8 = this.alterClusterLink$default$8();
        this.alterClusterLink(x$1, AlterClusterLinkOp.CREATE, x$5, x$3, x$4, x$6, x$7, x$8);
    }

    public void alterClusterLink(Uuid linkId, AlterClusterLinkOp alterClusterLinkOp, ClusterLinkSwitchoverMetadata.SwitchoverType switchoverType, long switchoverTimestamp, ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState, short errorCode, String errorMessage, long controlPlaneTimestamp) {
        this.ensureClusterLinkExists(linkId);
        KafkaFutureImpl result = new KafkaFutureImpl();
        Option<ClusterLinkSwitchoverMetadata> existingSwitchoverMetadata = this.clusterLinkSwitchoverMetadata(linkId);
        AlterClusterLinkOp alterClusterLinkOp2 = alterClusterLinkOp;
        AlterClusterLinkOp alterClusterLinkOp3 = AlterClusterLinkOp.CREATE;
        if (!(alterClusterLinkOp2 != null ? !alterClusterLinkOp2.equals(alterClusterLinkOp3) : alterClusterLinkOp3 != null)) {
            if (existingSwitchoverMetadata.isDefined()) {
                throw new InvalidRequestException("Trying to create switchover metadata but it already exists.");
            }
            if (switchoverTimestamp == -1L) {
                throw new InvalidRequestException("No timestamp was provided for creating the switchover metadata");
            }
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState2 = switchoverState;
            ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState3 = ClusterLinkSwitchoverMetadata.SwitchoverState.ACTIVE;
            if (switchoverState2 == null ? switchoverState3 != null : !((Object)((Object)switchoverState2)).equals((Object)switchoverState3)) {
                ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState4 = switchoverState;
                ClusterLinkSwitchoverMetadata.SwitchoverState switchoverState5 = ClusterLinkSwitchoverMetadata.SwitchoverState.PASSIVE;
                if (switchoverState4 == null ? switchoverState5 != null : !((Object)((Object)switchoverState4)).equals((Object)switchoverState5)) {
                    throw new InvalidRequestException("Initial switchover state must be either primary or secondary");
                }
            }
        } else if (existingSwitchoverMetadata.isEmpty()) {
            throw new InvalidRequestException("Trying to update or delete switchover metadata that does not exist.");
        }
        AlterClusterLinksRequestData.AlterClusterLinkData alterClusterLink = new AlterClusterLinksRequestData.AlterClusterLinkData().setLinkId(linkId).setAlterClusterLinkOp(alterClusterLinkOp.id()).setSwitchoverType(switchoverType.value()).setSwitchoverTimestamp(switchoverTimestamp).setSwitchoverState(switchoverState.value()).setErrorCode(errorCode).setErrorMessage(errorMessage).setControlPlaneTimestamp(controlPlaneTimestamp);
        this.sendAlterClusterLinkRequest(alterClusterLink, (KafkaFutureImpl<Void>)result);
    }

    public AlterClusterLinkOp alterClusterLink$default$2() {
        return AlterClusterLinkOp.UPDATE;
    }

    public ClusterLinkSwitchoverMetadata.SwitchoverType alterClusterLink$default$3() {
        return ClusterLinkSwitchoverMetadata.SwitchoverType.UNKNOWN;
    }

    public long alterClusterLink$default$4() {
        return -1L;
    }

    public ClusterLinkSwitchoverMetadata.SwitchoverState alterClusterLink$default$5() {
        return ClusterLinkSwitchoverMetadata.SwitchoverState.UNKNOWN;
    }

    public short alterClusterLink$default$6() {
        return (short)-1;
    }

    public String alterClusterLink$default$7() {
        return "unchanged";
    }

    public long alterClusterLink$default$8() {
        return -1L;
    }

    private void sendAlterClusterLinkRequest(AlterClusterLinksRequestData.AlterClusterLinkData alterClusterLink, KafkaFutureImpl<Void> result) {
        AlterClusterLinksRequest.Builder builder = new AlterClusterLinksRequest.Builder(alterClusterLink, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterClusterLink, result){
            private final AlterClusterLinksRequestData.AlterClusterLinkData alterClusterLink$1;
            private final KafkaFutureImpl result$2;

            public void handleResponse(AbstractResponse response) {
                this.debug((Function0<String> & Serializable)() -> "Received response for alterClusterLinksRequest");
                AlterClusterLinksResponse message = (AlterClusterLinksResponse)response;
                message.complete(Collections.singletonMap(this.alterClusterLink$1.linkId().toString(), this.result$2));
            }

            public void onFailure(Throwable ex) {
                this.debug((Function0<String> & Serializable)() -> "alterClusterLinks request failed with exception", (Function0<Throwable> & Serializable)() -> ex);
                this.result$2.completeExceptionally(ex);
            }
            {
                this.alterClusterLink$1 = alterClusterLink$1;
                this.result$2 = result$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleResponse$2(), $anonfun$onFailure$3(), $anonfun$onFailure$4(java.lang.Throwable )}, serializedLambda);
            }
        };
        this.controllerChannelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
    }

    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException("Cluster link with ID '" + linkId + "' does not exist.");
        }
    }

    public boolean clusterLinkExists(Uuid linkId) {
        return this.metadataCache.currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        Map<String, ClusterLink> clusterLinks = this.metadataCache.currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = clusterLinks.get(linkName);
            return new Some<ClusterLinkData>(new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        Map<Uuid, ClusterLink> clusterLinks = this.metadataCache.currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = clusterLinks.get(linkId);
            return new Some<ClusterLinkData>(new ClusterLinkData(clusterLink.linkName(), linkId, new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    public Option<ClusterLinkSwitchoverMetadata> clusterLinkSwitchoverMetadata(Uuid linkId) {
        Map<Uuid, ClusterLink> clusterLinks = this.metadataCache.currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = clusterLinks.get(linkId);
            return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.switchoverMetadata()));
        }
        return None$.MODULE$;
    }

    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return this.metadataCache.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    public KRaftLinkMetadataManager(KafkaConfig brokerConfig, KRaftImageMetadataCache metadataCache, NodeToControllerChannelManager controllerChannelManager, AuthorizerServerInfo serverInfo) {
        this.metadataCache = metadataCache;
        this.controllerChannelManager = controllerChannelManager;
        this.requestTimeoutMs = Predef$.MODULE$.Integer2int(new AdminClientConfig(ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint())).getInt("request.timeout.ms"));
    }
}

