/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.MatchedGroup;
import kafka.server.link.TopicType$;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0005\n\u00053!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u0003'\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011\u0005\u0003!Q1A\u0005\u0002\tC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"Aq\u000b\u0001B\u0001B\u0003%\u0011\n\u0003\u0005Y\u0001\t\u0015\r\u0011\"\u0001I\u0011!I\u0006A!A!\u0002\u0013I\u0005\u0002\u0003.\u0001\u0005\u000b\u0007I\u0011A.\t\u0011}\u0003!\u0011!Q\u0001\nqCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ!\u001b\u0001\u0005B)DQ!\u001d\u0001\u0005B\u0015BQA\u001d\u0001\u0005BM\u0014\u0011CU3n_R,W*\u001b:s_J$v\u000e]5d\u0015\t\u0019B#\u0001\u0003mS:\\'BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\tj\u0011AE\u0005\u0003GI\u0011QdQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\te\u0016lw\u000e^3UaV\ta\u0005\u0005\u0002(_5\t\u0001F\u0003\u0002*U\u000511m\\7n_:T!aF\u0016\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0005\u0003a!\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0005sK6|G/\u001a+qA\u0005)1\u000f^1uKV\tA\u0007\u0005\u00026{9\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003u)\nqa\u00197jK:$8/\u0003\u0002=o\u00051R*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g.\u0003\u0002?\u007f\t)1\u000b^1uK*\u0011AhN\u0001\u0007gR\fG/\u001a\u0011\u0002\u00111Lgn\u001b#bi\u0006,\u0012a\u0011\t\u0003C\u0011K!!\u0012\n\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u00171|7-\u00197Qe\u00164\u0017\u000e_\u000b\u0002\u0013B\u00191D\u0013'\n\u0005-c\"AB(qi&|g\u000e\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fri\u0011\u0001\u0015\u0006\u0003#b\ta\u0001\u0010:p_Rt\u0014BA*\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Mc\u0012\u0001\u00047pG\u0006d\u0007K]3gSb\u0004\u0013\u0001\u0004:f[>$X\r\u0015:fM&D\u0018!\u0004:f[>$X\r\u0015:fM&D\b%A\u0003he>,\b/F\u0001]!\t\tS,\u0003\u0002_%\taQ*\u0019;dQ\u0016$wI]8va\u00061qM]8va\u0002\na\u0001P5oSRtDc\u00022dI\u00164w\r\u001b\t\u0003C\u0001AQ\u0001J\u0007A\u0002\u0019BQAM\u0007A\u0002QBQ!Q\u0007A\u0002\rCQaR\u0007A\u0002%CQ\u0001W\u0007A\u0002%CQAW\u0007A\u0002q\u000b!b\u001d5pk2$7+\u001f8d+\u0005Y\u0007\u0003B\u000em]2K!!\u001c\u000f\u0003\rQ+\b\u000f\\33!\tYr.\u0003\u0002q9\t9!i\\8mK\u0006t\u0017!\u00033fgR$v\u000e]5d\u0003!!xn\u0015;sS:<G#\u0001;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001\u00027b]\u001eT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002Vm\u0002")
public class RemoteMirrorTopic
implements CommittedOffsetTopicPartition {
    private final TopicPartition remoteTp;
    private final MirrorTopicDescription.State state;
    private final ClusterLinkData linkData;
    private final Option<String> localPrefix;
    private final Option<String> remotePrefix;
    private final MatchedGroup group;

    public TopicPartition remoteTp() {
        return this.remoteTp;
    }

    public MirrorTopicDescription.State state() {
        return this.state;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public Option<String> localPrefix() {
        return this.localPrefix;
    }

    public Option<String> remotePrefix() {
        return this.remotePrefix;
    }

    public MatchedGroup group() {
        return this.group;
    }

    @Override
    public Tuple2<Object, String> shouldSync() {
        if (this.group().topicTypes().contains(TopicType$.MODULE$.REMOTE_MIRROR()) && this.state().equals((Object)MirrorTopicDescription.State.ACTIVE)) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(true), null);
        }
        return new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("remote mirror " + this.remoteTp().topic() + " is not active")));
    }

    @Override
    public TopicPartition destTopic() {
        String tenantPrefix = (String)this.linkData().tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "");
        String localName = tenantPrefix + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(this.remoteTp().topic()), tenantPrefix)), (String)this.localPrefix().getOrElse((Function0<String> & Serializable)() -> ""))), (String)this.remotePrefix().getOrElse((Function0<String> & Serializable)() -> ""));
        return new TopicPartition(localName, this.remoteTp().partition());
    }

    public String toString() {
        return "RemoteMirrorTopic(" + this.remoteTp() + ", " + this.state() + ", " + this.linkData() + ", " + this.localPrefix() + ", " + this.remotePrefix() + ", " + this.group() + ")";
    }

    public RemoteMirrorTopic(TopicPartition remoteTp, MirrorTopicDescription.State state, ClusterLinkData linkData, Option<String> localPrefix, Option<String> remotePrefix, MatchedGroup group) {
        this.remoteTp = remoteTp;
        this.state = state;
        this.linkData = linkData;
        this.localPrefix = localPrefix;
        this.remotePrefix = remotePrefix;
        this.group = group;
    }
}

