/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.logger;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.logger.LoggingController;
import org.slf4j.Logger;

public class RuntimeLoggerManager {
    static final String VALID_LOG_LEVELS_STRING;
    private final int nodeId;
    private final Logger log;

    public RuntimeLoggerManager(int nodeId, Logger log) {
        this.nodeId = nodeId;
        this.log = log;
    }

    public void applyChangesForResource(boolean authorizedForClusterResource, boolean validateOnly, IncrementalAlterConfigsRequestData.AlterConfigsResource resource) {
        if (!authorizedForClusterResource) {
            throw new ClusterAuthorizationException(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
        }
        this.validateResourceNameIsNodeId(resource.resourceName());
        this.validateLogLevelConfigs((Collection<IncrementalAlterConfigsRequestData.AlterableConfig>)resource.configs());
        if (!validateOnly) {
            this.alterLogLevelConfigs((Collection<IncrementalAlterConfigsRequestData.AlterableConfig>)resource.configs());
        }
    }

    void alterLogLevelConfigs(Collection<IncrementalAlterConfigsRequestData.AlterableConfig> ops) {
        ops.forEach(op -> {
            String loggerName = op.name();
            String logLevel = op.value();
            switch (AlterConfigOp.OpType.forId((byte)op.configOperation())) {
                case SET: {
                    if (LoggingController.logLevel(loggerName, logLevel)) {
                        this.log.warn("Updated the log level of {} to {}", (Object)loggerName, (Object)logLevel);
                        break;
                    }
                    this.log.error("Failed to update the log level of {} to {}", (Object)loggerName, (Object)logLevel);
                    break;
                }
                case DELETE: {
                    if (LoggingController.unsetLogLevel(loggerName)) {
                        this.log.warn("Unset the log level of {}", (Object)loggerName);
                        break;
                    }
                    this.log.error("Failed to unset the log level of {}", (Object)loggerName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid log4j configOperation: " + op.configOperation());
                }
            }
        });
    }

    void validateResourceNameIsNodeId(String resourceName) {
        int requestId;
        try {
            requestId = Integer.parseInt(resourceName);
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException("Node id must be an integer, but it is: " + resourceName);
        }
        if (requestId != this.nodeId) {
            throw new InvalidRequestException("Unexpected node id. Expected " + this.nodeId + ", but received " + requestId);
        }
    }

    void validateLoggerNameExists(String loggerName) {
        if (!LoggingController.loggerExists(loggerName)) {
            throw new InvalidConfigurationException("Logger " + loggerName + " does not exist!");
        }
    }

    void validateLogLevelConfigs(Collection<IncrementalAlterConfigsRequestData.AlterableConfig> ops) {
        ops.forEach(op -> {
            String loggerName = op.name();
            switch (AlterConfigOp.OpType.forId((byte)op.configOperation())) {
                case SET: {
                    this.validateLoggerNameExists(loggerName);
                    String logLevel = op.value();
                    if (LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) break;
                    throw new InvalidConfigurationException("Cannot set the log level of " + loggerName + " to " + logLevel + " as it is not a supported log level. Valid log levels are " + VALID_LOG_LEVELS_STRING);
                }
                case DELETE: {
                    this.validateLoggerNameExists(loggerName);
                    if (!loggerName.equals("root")) break;
                    throw new InvalidRequestException("Removing the log level of the root logger is not allowed");
                }
                case APPEND: {
                    throw new InvalidRequestException(String.valueOf(AlterConfigOp.OpType.APPEND) + " operation is not allowed for the " + String.valueOf(ConfigResource.Type.BROKER_LOGGER) + " resource");
                }
                case SUBTRACT: {
                    throw new InvalidRequestException(String.valueOf(AlterConfigOp.OpType.SUBTRACT) + " operation is not allowed for the " + String.valueOf(ConfigResource.Type.BROKER_LOGGER) + " resource");
                }
                default: {
                    throw new InvalidRequestException("Unknown operation type " + op.configOperation() + " is not allowed for the " + String.valueOf(ConfigResource.Type.BROKER_LOGGER) + " resource");
                }
            }
        });
    }

    static {
        ArrayList logLevels = new ArrayList(LogLevelConfig.VALID_LOG_LEVELS);
        logLevels.sort(String::compareTo);
        VALID_LOG_LEVELS_STRING = String.join((CharSequence)", ", logLevels);
    }
}

