/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.image.publisher.GroupCoordinatorDeletedTopicsPublisher;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.server.share.SharePartitionManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.config.BrokerReconfigurable;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.metadata.publisher.AclPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.ShareVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.storage.internals.log.LogManager;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rMq!\u0002\u00192\u0011\u0003Ad!\u0002\u001e2\u0011\u0003Y\u0004\"\u0002%\u0002\t\u0003I\u0005\"\u0002&\u0002\t\u0003Ye\u0001\u0002\u001e2\u0001ED\u0011\"!\u0001\u0005\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0015\u0005\rAA!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\u000e\u0011\u0011\t\u0011)A\u0005\u0003\u001fA!\"!\u0006\u0005\u0005\u0003\u0005\u000b\u0011BA\f\u0011)\t\u0019\u0003\u0002B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003W!!\u0011!Q\u0001\n\u00055\u0002BCA\u001f\t\t\u0005\t\u0015!\u0003\u0002@!Q\u0011Q\n\u0003\u0003\u0002\u0003\u0006I!a\u0014\t\u0015\u0005mCA!A!\u0002\u0013\ti\u0006\u0003\u0006\u0002h\u0011\u0011\t\u0019!C\u0001\u0003SB!\"!\u001d\u0005\u0005\u0003\u0007I\u0011AA:\u0011)\ty\b\u0002B\u0001B\u0003&\u00111\u000e\u0005\u000b\u0003\u0003#!\u0011!Q\u0001\n\u0005\r\u0005BCAE\t\t\u0005\t\u0015!\u0003\u0002\f\"Q\u0011\u0011\u0013\u0003\u0003\u0002\u0003\u0006I!a%\t\u0015\u0005eEA!A!\u0002\u0013\tY\n\u0003\u0006\u0002(\u0012\u0011\t\u0011)A\u0005\u0003SC!\"!.\u0005\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\t)\r\u0002B\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0003\u000f$!\u0011!Q\u0001\n\u0005%\u0007BCAu\t\t\u0005\t\u0015!\u0003\u0002l\"Q\u0011\u0011 \u0003\u0003\u0002\u0003\u0006I!a?\t\u0015\t%AA!A!\u0002\u0013\u0011Y\u0001\u0003\u0006\u0003\u001a\u0011\u0011\t\u0011)A\u0005\u00057A!B!\u000b\u0005\u0005\u0003\u0005\u000b\u0011\u0002B\u0016\u0011\u0019AE\u0001\"\u0001\u0003B!I!1\u000f\u0003C\u0002\u0013\u0005!Q\u000f\u0005\t\u0005{\"\u0001\u0015!\u0003\u0003x!I!q\u0010\u0003A\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0005\u0013#\u0001\u0019!C\u0001\u0005\u0017C\u0001Ba$\u0005A\u0003&!1\u0011\u0005\n\u0005##!\u0019!C\u0001\u0005'C\u0001Ba+\u0005A\u0003%!Q\u0013\u0005\n\u0005[#\u0001\u0019!C\u0005\u0005_C\u0011Ba.\u0005\u0001\u0004%IA!/\t\u0011\tuF\u0001)Q\u0005\u0005cCqAa0\u0005\t\u0003\u0012\t\rC\u0004\u0003D\u0012!\tE!2\t\u000f\tmG\u0001\"\u0003\u0003^\"9!Q\u001e\u0003\u0005\u0002\t=\bbBB\u0004\t\u0011%1\u0011\u0002\u0005\b\u0007\u001b!A\u0011BB\b\u0011\u001d\u0019\t\u0002\u0002C!\u0007\u001f\tqC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u000b\u0005I\u001a\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0005Q*\u0014AB:feZ,'OC\u00017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!O\u0001\u000e\u0003E\u0012qC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0014\u0007\u0005a$\t\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bV\nQ!\u001e;jYNL!a\u0012#\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001O\u0001\u000eO\u0016$Hk\u001c9jG\u0012+G\u000e^1\u0015\t1Sv\r\u001c\t\u0004{5{\u0015B\u0001(?\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\u000bW\u0007\u0002#*\u0011!kU\u0001\u0006S6\fw-\u001a\u0006\u0003mQS!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0016aA8sO&\u0011\u0011,\u0015\u0002\u000b)>\u0004\u0018n\u0019#fYR\f\u0007\"B.\u0004\u0001\u0004a\u0016!\u0003;pa&\u001cg*Y7f!\tiFM\u0004\u0002_EB\u0011qLP\u0007\u0002A*\u0011\u0011mN\u0001\u0007yI|w\u000e\u001e \n\u0005\rt\u0014A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019 \t\u000b!\u001c\u0001\u0019A5\u0002\u00119,w/S7bO\u0016\u0004\"\u0001\u00156\n\u0005-\f&!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0003n\u0007\u0001\u0007a.A\u0003eK2$\u0018\r\u0005\u0002Q_&\u0011\u0001/\u0015\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\u0014\t\u0011\u0011(P\u0011\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019y%M[3diB\u00111P`\u0007\u0002y*\u0011Q0U\u0001\naV\u0014G.[:iKJL!a ?\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/A\u0005dYV\u001cH/\u001a:JI\u0006!1m\u001c8g!\u0011\t9!!\u0003\u000e\u0003MJ1!a\u00034\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\rI\u0014\u0011C\u0005\u0004\u0003'\t$aF&SC\u001a$\u0018*\\1hK6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003)awnZ'b]\u0006<WM\u001d\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u001b\u0002\u00071|w-\u0003\u0003\u0002\"\u0005m!A\u0003'pO6\u000bg.Y4fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BA\u0004\u0003OI1!!\u000b4\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005)qM]8va*\u0019\u0011qG*\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u0003w\t\tD\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\b\u0003BA!\u0003\u0013j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\fiJ\fgn]1di&|gNC\u0002\u00028UJA!a\u0013\u0002D\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\ttQ\u0006\u0014XmQ8pe\u0012Lg.\u0019;peB!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005U\u0012!B:iCJ,\u0017\u0002BA-\u0003'\u0012\u0001c\u00155be\u0016\u001cun\u001c:eS:\fGo\u001c:\u0002+MD\u0017M]3QCJ$\u0018\u000e^5p]6\u000bg.Y4feB!\u0011qLA2\u001b\t\t\tGC\u0002\u0002VMJA!!\u001a\u0002b\t)2\u000b[1sKB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\u0018A\u00063z]\u0006l\u0017nY\"p]\u001aLw\rU;cY&\u001c\b.\u001a:\u0016\u0005\u0005-\u0004cA\u001d\u0002n%\u0019\u0011qN\u0019\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ\f!\u0004Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]0%KF$B!!\u001e\u0002|A\u0019Q(a\u001e\n\u0007\u0005edH\u0001\u0003V]&$\b\"CA?\u001f\u0005\u0005\t\u0019AA6\u0003\rAH%M\u0001\u0018Ift\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0002\n1\u0004Z=oC6L7m\u00117jK:$\u0018+^8uCB+(\r\\5tQ\u0016\u0014\bcA\u001d\u0002\u0006&\u0019\u0011qQ\u0019\u00037\u0011Kh.Y7jG\u000ec\u0017.\u001a8u#V|G/\u0019)vE2L7\u000f[3s\u00039\u00198M]1n!V\u0014G.[:iKJ\u00042!OAG\u0013\r\ty)\r\u0002\u000f'\u000e\u0014\u0018-\u001c)vE2L7\u000f[3s\u0003a!W\r\\3hCRLwN\u001c+pW\u0016t\u0007+\u001e2mSNDWM\u001d\t\u0004s\u0005U\u0015bAALc\tAB)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000eU;cY&\u001c\b.\u001a:\u0002\u0019\u0005\u001cG\u000eU;cY&\u001c\b.\u001a:\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!`AQ\u0015\t\u00114+\u0003\u0003\u0002&\u0006}%\u0001D!dYB+(\r\\5tQ\u0016\u0014\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_\u001b\u0016\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005M\u0016Q\u0016\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/A\tgCR\fGNR1vYRD\u0015M\u001c3mKJ\u0004B!!/\u0002B6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0003gCVdGO\u0003\u00025'&!\u00111YA^\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003yiW\r^1eCR\f\u0007+\u001e2mSND\u0017N\\4GCVdG\u000fS1oI2,'/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b\u0003B\u001fN\u0003\u0017\u0004B!!4\u0002d:!\u0011qZAo\u001d\u0011\t\t.!7\u000f\t\u0005M\u0017q\u001b\b\u0004?\u0006U\u0017\"\u0001\u001c\n\u0005Q*\u0014bAAng\u0005!A.\u001b8l\u0013\u0011\ty.!9\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/\u001f\u0006\u0004\u00037\u001c\u0014\u0002BAs\u0003O\u00141\u0002T5oW6\u000bg.Y4fe*!\u0011q\\Aq\u0003E!\u0018.\u001a:fI\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005{5\u000bi\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u00190N\u0001\u0005i&,'/\u0003\u0003\u0002x\u0006E(\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\f!FY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;pe>\u0003H\u000f\u0005\u0003>\u001b\u0006u\b\u0003BA\u0000\u0005\u000bi!A!\u0001\u000b\t\t\r\u0011\u0011_\u0001\u0016E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u0013\u0011\u00119A!\u0001\u0003O\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN]\u0001 i&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$8i\\8sI&t\u0017\r^8s\u001fB$\b\u0003B\u001fN\u0005\u001b\u0001BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0005'\t\t0\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\u00119B!\u0005\u00039QKWM\u001d+pa&\u001c7K\\1qg\"|GoQ8pe\u0012Lg.\u0019;pe\u0006\u0019\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN](qiB!Q(\u0014B\u000f!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0003\u000f\nQ!];pi\u0006LAAa\n\u0003\"\t\u0001\u0012+^8uC\u000e{wN\u001d3j]\u0006$xN]\u0001'OJ|W\u000f]\"p_J$\u0017N\\1u_J$U\r\\3uK\u0012$v\u000e]5dgB+(\r\\5tQ\u0016\u0014\b\u0003\u0002B\u0017\u0005{i!Aa\f\u000b\u0007u\u0014\tDC\u0002S\u0005gQ1A\u000eB\u001b\u0015\u0011\u00119D!\u000f\u0002\u0013\r|gN\u001a7vK:$(B\u0001B\u001e\u0003\tIw.\u0003\u0003\u0003@\t=\"AJ$s_V\u00048i\\8sI&t\u0017\r^8s\t\u0016dW\r^3e)>\u0004\u0018nY:Qk\nd\u0017n\u001d5feR\u0001$1\tB#\u0005\u000f\u0012IEa\u0013\u0003N\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu#q\fB1\u0005G\u0012)Ga\u001a\u0003j\t-$Q\u000eB8\u0005c\u0002\"!\u000f\u0003\t\r\u0005\u0005a\u00041\u0001]\u0011\u001d\t\u0019A\ba\u0001\u0003\u000bAq!!\u0004\u001f\u0001\u0004\ty\u0001C\u0004\u0002\u0016y\u0001\r!a\u0006\t\u000f\u0005\rb\u00041\u0001\u0002&!9\u00111\u0006\u0010A\u0002\u00055\u0002bBA\u001f=\u0001\u0007\u0011q\b\u0005\b\u0003\u001br\u0002\u0019AA(\u0011\u001d\tYF\ba\u0001\u0003;Bq!a\u001a\u001f\u0001\u0004\tY\u0007C\u0004\u0002\u0002z\u0001\r!a!\t\u000f\u0005%e\u00041\u0001\u0002\f\"9\u0011\u0011\u0013\u0010A\u0002\u0005M\u0005bBAM=\u0001\u0007\u00111\u0014\u0005\b\u0003Os\u0002\u0019AAU\u0011\u001d\t)L\ba\u0001\u0003oCq!!2\u001f\u0001\u0004\t9\fC\u0004\u0002Hz\u0001\r!!3\t\u000f\u0005%h\u00041\u0001\u0002l\"9\u0011\u0011 \u0010A\u0002\u0005m\bb\u0002B\u0005=\u0001\u0007!1\u0002\u0005\b\u00053q\u0002\u0019\u0001B\u000e\u0011\u001d\u0011IC\ba\u0001\u0005W\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0005o\u00022!\u0010B=\u0013\r\u0011YH\u0010\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u00035yf-\u001b:tiB+(\r\\5tQV\u0011!1\u0011\t\u0004{\t\u0015\u0015b\u0001BD}\t9!i\\8mK\u0006t\u0017!E0gSJ\u001cH\u000fU;cY&\u001c\bn\u0018\u0013fcR!\u0011Q\u000fBG\u0011%\tiHIA\u0001\u0002\u0004\u0011\u0019)\u0001\b`M&\u00148\u000f\u001e)vE2L7\u000f\u001b\u0011\u0002%\u0019L'o\u001d;Qk\nd\u0017n\u001d5GkR,(/Z\u000b\u0003\u0005+\u0003bAa&\u0003\"\n\u0015VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0003 Z\fA!\u001e;jY&!!1\u0015BM\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0004g\n\u001d\u0016b\u0001BUi\n!ak\\5e\u0003M1\u0017N]:u!V\u0014G.[:i\rV$XO]3!\u0003U1\u0017N\\1mSj,Gm\u00155be\u00164VM]:j_:,\"A!-\u0011\u0007u\u0012\u0019,C\u0002\u00036z\u0012Qa\u00155peR\f\u0011DZ5oC2L'0\u001a3TQ\u0006\u0014XMV3sg&|gn\u0018\u0013fcR!\u0011Q\u000fB^\u0011%\tihJA\u0001\u0002\u0004\u0011\t,\u0001\fgS:\fG.\u001b>fINC\u0017M]3WKJ\u001c\u0018n\u001c8!\u0003\u0011q\u0017-\\3\u0015\u0003q\u000b\u0001c\u001c8NKR\fG-\u0019;b+B$\u0017\r^3\u0015\u0011\u0005U$q\u0019Be\u0005\u0017DQ!\u001c\u0016A\u00029DQ\u0001\u001b\u0016A\u0002%DqA!4+\u0001\u0004\u0011y-\u0001\u0005nC:Lg-Z:u!\u0011\u0011\tNa6\u000e\u0005\tM'b\u0001Bk#\u00061An\\1eKJLAA!7\u0003T\nqAj\\1eKJl\u0015M\\5gKN$\u0018!\u0004;p\u001fB$\u0018n\u001c8bY&sG\u000f\u0006\u0003\u0003`\n\u001d\b\u0003\u0002Bq\u0005Gl!A!(\n\t\t\u0015(Q\u0014\u0002\f\u001fB$\u0018n\u001c8bY&sG\u000fC\u0004\u0003j.\u0002\rAa;\u0002\r=\u0004H/[8o!\u0011iTJa\u001e\u0002#U\u0004H-\u0019;f\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0007\u0002v\tE(1\u001fB{\u0005o\u001c\t\u0001C\u0003SY\u0001\u0007\u0011\u000eC\u0003nY\u0001\u0007a\u000eC\u0003\\Y\u0001\u0007A\fC\u0004\u0003z2\u0002\rAa?\u0002\u0011\u0015dWm\u0019;j_:\u0004\u0012\"\u0010B\u007f\u0005o\u00129(!\u001e\n\u0007\t}hHA\u0005Gk:\u001cG/[8oe!911\u0001\u0017A\u0002\r\u0015\u0011a\u0003:fg&<g.\u0019;j_:\u0004\u0012\"\u0010B\u007f\u0005o\u0012Y/!\u001e\u0002%%t\u0017\u000e^5bY&TX-T1oC\u001e,'o\u001d\u000b\u0005\u0003k\u001aY\u0001C\u0003i[\u0001\u0007\u0011.\u0001\u0011gS:L7\u000f[%oSRL\u0017\r\\5{S:<'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014HCAA;\u0003\u0015\u0019Gn\\:f\u0001")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftImageMetadataCache metadataCache;
    private final kafka.log.LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ShareCoordinator shareCoordinator;
    private final SharePartitionManager sharePartitionManager;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final CredentialProvider credentialProvider;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final GroupCoordinatorDeletedTopicsPublisher groupCoordinatorDeletedTopicsPublisher;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private short finalizedShareVersion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    private Logger logger$lzycompute() {
        BrokerMetadataPublisher brokerMetadataPublisher = this;
        synchronized (brokerMetadataPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    private short finalizedShareVersion() {
        return this.finalizedShareVersion;
    }

    private void finalizedShareVersion_$eq(short x$1) {
        this.finalizedShareVersion = x$1;
    }

    @Override
    public String name() {
        return "BrokerMetadataPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        block19: {
            OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
            String deltaName = this._firstPublish() ? "initial MetadataDelta up to " + highestOffsetAndEpoch.offset() : "MetadataDelta up to " + highestOffsetAndEpoch.offset();
            try {
                try {
                    Serializable serializable;
                    Serializable serializable2;
                    Serializable serializable3;
                    if (this.isTraceEnabled()) {
                        this.trace((Function0<String> & Serializable)() -> "Publishing delta " + delta + " with highest offset " + highestOffsetAndEpoch);
                    }
                    this.metadataCache.setImage(newImage);
                    if (this._firstPublish()) {
                        this.info((Function0<String> & Serializable)() -> "Publishing initial metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                        this.initializeManagers(newImage);
                    } else if (this.isDebugEnabled()) {
                        this.debug((Function0<String> & Serializable)() -> "Publishing metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                    }
                    Option$.MODULE$.apply(delta.topicsDelta()).foreach((Function1<TopicsDelta, Object> & Serializable)topicsDelta -> {
                        Serializable serializable;
                        block23: {
                            Serializable serializable2;
                            Serializable serializable3;
                            Serializable serializable4;
                            Serializable serializable5;
                            Serializable serializable6;
                            Serializable serializable7;
                            Serializable serializable8;
                            Serializable serializable9;
                            Serializable serializable10;
                            Serializable serializable11;
                            try {
                                $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                                serializable11 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable11 = $this.metadataPublishingFaultHandler.handleFault("Error applying topics delta in " + deltaName, t);
                            }
                            try {
                                this.updateCoordinator(newImage, delta, "__consumer_offsets", (groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch) -> $this.groupCoordinator.onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                    this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt(partitionIndex), this.toOptionalInt(leaderEpochOpt));
                                    return BoxedUnit.UNIT;
                                });
                                serializable10 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable10 = $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                this.updateCoordinator(newImage, delta, "__transaction_state", (txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                                    this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt(txnTopicPartitionId), coordinatorEpoch);
                                    return BoxedUnit.UNIT;
                                });
                                serializable9 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable9 = $this.metadataPublishingFaultHandler.handleFault("Error updating txn coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                this.updateCoordinator(newImage, delta, "__share_group_state", (partitionIndex, partitionLeaderEpoch) -> $this.shareCoordinator.onElection(partitionIndex, partitionLeaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                    this.shareCoordinator.onResignation(BoxesRunTime.unboxToInt(partitionIndex), this.toOptionalInt(leaderEpochOpt));
                                    return BoxedUnit.UNIT;
                                });
                                serializable8 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable8 = $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                $this.tieredCoordinator.foreach((Function1<TierDeletedPartitionsCoordinator, Object> & Serializable)tieredCoord -> {
                                    this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$2) -> {
                                        tieredCoord.handleEmigration(BoxesRunTime.unboxToInt(partitionId));
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                serializable7 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable7 = $this.metadataPublishingFaultHandler.handleFault("Error updating tiered storage coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                $this.quotaCoordinatorOpt.foreach((Function1<QuotaCoordinator, Object> & Serializable)quotaCoordinator -> {
                                    this.updateCoordinator(newImage, delta, "_confluent-quotas", (quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                        quotaCoordinator.onResignation(BoxesRunTime.unboxToInt(quotaTopicPartitionId), coordinatorEpoch);
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                serializable6 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable6 = $this.metadataPublishingFaultHandler.handleFault("Error updating quota coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1<BackupObjectLifecycleManagerCoordinator, Object> & Serializable)backupObjectLifecycleManagerCoord -> {
                                    this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$4) -> {
                                        backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt(partitionId));
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                serializable5 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable5 = $this.metadataPublishingFaultHandler.handleFault("Error updating backup object lifecycle manager coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                $this.tierTopicSnapshotCoordinatorOpt.foreach((Function1<TierTopicSnapshotCoordinator, Object> & Serializable)tierSnapshotCoord -> {
                                    this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$5) -> tierSnapshotCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$6) -> {
                                        tierSnapshotCoord.onResignation(BoxesRunTime.unboxToInt(partitionId));
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                serializable4 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable4 = $this.metadataPublishingFaultHandler.handleFault("Error updating tier topic snapshot coordinator with local changes in " + deltaName, t);
                            }
                            try {
                                $this.clusterLinkManager.foreach((Function1<ClusterLinkFactory.LinkManager, Object> & Serializable)manager -> {
                                    this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, leaderEpoch) -> {
                                        manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt(partitionId), leaderEpoch);
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                serializable3 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable3 = $this.metadataPublishingFaultHandler.handleFault("Error updating cluster link manager with local changes in " + deltaName, t);
                            }
                            try {
                                $this.groupCoordinatorDeletedTopicsPublisher.onMetadataUpdate(delta, newImage, manifest);
                                serializable2 = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable2 = $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with deleted KRaft partitions in " + deltaName, t);
                            }
                            try {
                                Set<Uuid> deletedTopicIds = delta.topicsDelta().deletedTopicIds();
                                if (!deletedTopicIds.isEmpty()) {
                                    $this.shareCoordinator.onTopicsDeleted(deletedTopicIds, RequestLocal.noCaching().bufferSupplier());
                                    serializable = BoxedUnit.UNIT;
                                    break block23;
                                }
                                serializable = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                serializable = $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with deleted partitions in " + deltaName, t);
                            }
                        }
                        return serializable;
                    });
                    this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                    this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                    this.scramPublisher.onMetadataUpdate(delta, newImage);
                    Option$.MODULE$.apply(delta.scramDelta()).foreach((Function1<ScramDelta, Object> & Serializable)scramDelta -> {
                        BrokerMetadataPublisher.$anonfun$onMetadataUpdate$26(this, scramDelta);
                        return BoxedUnit.UNIT;
                    });
                    this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                    this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                    try {
                        this.groupCoordinator.onNewMetadataImage(newImage, delta);
                        serializable3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable3 = this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        this.shareCoordinator.onNewMetadataImage(newImage, delta);
                        serializable2 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable2 = this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                    }
                    if (this._firstPublish()) {
                        this.finishInitializingReplicaManager();
                    }
                    if (delta.featuresDelta() == null) break block19;
                    try {
                        FinalizedFeatures newFinalizedFeatures = new FinalizedFeatures(newImage.features().metadataVersionOrThrow(), newImage.features().finalizedVersions(), newImage.provenance().lastContainedOffset());
                        Short newFinalizedShareVersion = newFinalizedFeatures.finalizedFeatures().getOrDefault("share.version", Predef$.MODULE$.short2Short((short)0));
                        if (!BoxesRunTime.equalsNumObject(newFinalizedShareVersion, BoxesRunTime.boxToShort(this.finalizedShareVersion()))) {
                            this.finalizedShareVersion_$eq(Predef$.MODULE$.Short2short(newFinalizedShareVersion));
                            ShareVersion shareVersion = ShareVersion.fromFeatureLevel(this.finalizedShareVersion());
                            this.info((Function0<String> & Serializable)() -> "Feature share.version has been updated to version " + this.finalizedShareVersion());
                            this.sharePartitionManager.onShareVersionToggle(shareVersion, this.conf.shareGroupConfig().isShareGroupEnabled(), this.conf.shareGroupConfig().isShareGroupRollOutReady());
                        }
                        serializable = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable = this.metadataPublishingFaultHandler.handleFault("Error updating share partition manager  with share version feature change in " + deltaName, t);
                    }
                    if (delta.metadataVersionChanged().isPresent()) {
                        ApiMessageType.ApiVisibility apiVisibility = this.conf.apiVisibility();
                        ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
                        if (apiVisibility == null ? apiVisibility2 != null : !apiVisibility.equals(apiVisibility2)) {
                            this.replicaManager.updatePushReplicationModeForMetadataVersion(false);
                        }
                    }
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault("Uncaught exception while publishing broker metadata from " + deltaName, t);
                }
            }
            finally {
                this._firstPublish_$eq(false);
                this.firstPublishFuture().complete(null);
            }
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        Option<Object> option2 = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int leaderEpoch = BoxesRunTime.unboxToInt(some.value());
            return OptionalInt.of(leaderEpoch);
        }
        if (None$.MODULE$.equals(option2)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option2);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply(delta.topicsDelta()).foreach((Function1<TopicsDelta, Object> & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1<TopicDelta, Object> & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Serializable serializable5;
        Serializable serializable6;
        try {
            this.logManager.startup(CollectionConverters$.MODULE$.SetHasAsScala(this.metadataCache.getAllTopics()).asScala(), (Function1<MergedLog, Object> & Serializable)log -> BoxesRunTime.boxToBoolean(BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, newImage, log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply(this.logManager.cleaner()).foreach((Function1<BrokerReconfigurable, Object> & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
            serializable6 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable6 = this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
            ApiMessageType.ApiVisibility apiVisibility = this.conf.apiVisibility();
            ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
            if (apiVisibility == null ? apiVisibility2 != null : !apiVisibility.equals(apiVisibility2)) {
                this.replicaManager.updatePushReplicationModeForMetadataVersion(true);
            }
            serializable5 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable5 = this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1<ClusterLinkFactory.LinkManager, Object> & Serializable)x$7 -> {
                x$7.startup(x$7.startup$default$1());
                return BoxedUnit.UNIT;
            });
            serializable4 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable4 = this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__consumer_offsets").orElse(Predef$.MODULE$.int2Integer($this.conf.groupCoordinatorConfig().offsetsTopicPartitions()))));
            serializable3 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable3 = this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            TransactionLogConfig transactionLogConfig = new TransactionLogConfig(this.conf);
            this.txnCoordinator.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__transaction_state").orElse(Predef$.MODULE$.int2Integer(transactionLogConfig.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            serializable2 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable2 = this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1<QuotaCoordinator, Object> & Serializable)x$8 -> {
                x$8.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("_confluent-quotas").orElse($this.conf.confluentConfig().quotasTopicPartitions())));
                return BoxedUnit.UNIT;
            });
            serializable = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable = this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
        }
        try {
            this.shareCoordinator.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__share_group_state").orElse(Predef$.MODULE$.int2Integer($this.conf.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting Share coordinator", t);
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
        }
    }

    @Override
    public void close() {
        this.firstPublishFuture().completeExceptionally(new TimeoutException());
    }

    private static final String metadataVersionLogMsg$1(MetadataImage newImage$1) {
        return "metadata.version " + newImage$1.features().metadataVersion();
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$26(BrokerMetadataPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> {
            Tuple2<ScramMechanism, Map> tuple2 = new Tuple2<ScramMechanism, Map>((ScramMechanism)x0$1, (Map)x1$1);
            if (tuple2 != null) {
                ScramMechanism mechanism = tuple2._1();
                Map userChanges = tuple2._2();
                userChanges.forEach((x0$2, x1$2) -> {
                    Tuple2<String, Optional> tuple2 = new Tuple2<String, Optional>((String)x0$2, (Optional)x1$2);
                    if (tuple2 != null) {
                        String userName = tuple2._1();
                        Optional change = tuple2._2();
                        if (change.isPresent()) {
                            $this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential());
                            return;
                        }
                        $this.credentialProvider.removeCredentials(mechanism, userName);
                        return;
                    }
                    throw new MatchError(tuple2);
                });
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int((Integer)entry.getKey())), None$.MODULE$);
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply(BoxesRunTime.boxToInteger(topicPartition.partition()), None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply(BoxesRunTime.boxToInteger(topicPartition.partition()), new Some<Integer>(BoxesRunTime.boxToInteger(partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ boolean $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, MetadataImage newImage$2, MergedLog log) {
        return LogManager.isStrayKraftReplica($this.brokerId(), newImage$2.topics(), log);
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftImageMetadataCache metadataCache, kafka.log.LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ShareCoordinator shareCoordinator, SharePartitionManager sharePartitionManager, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, CredentialProvider credentialProvider, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt, GroupCoordinatorDeletedTopicsPublisher groupCoordinatorDeletedTopicsPublisher) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.sharePartitionManager = sharePartitionManager;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.credentialProvider = credentialProvider;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.tierTopicSnapshotCoordinatorOpt = tierTopicSnapshotCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        this.groupCoordinatorDeletedTopicsPublisher = groupCoordinatorDeletedTopicsPublisher;
        Logging.$init$(this);
        this.logIdent_$eq("[BrokerMetadataPublisher id=" + conf.nodeId() + "] ");
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
        this.finalizedShareVersion = Predef$.MODULE$.Short2short(FinalizedFeatures.fromKRaftVersion(MetadataVersion.MINIMUM_VERSION).finalizedFeatures().getOrDefault("share.version", Predef$.MODULE$.short2Short((short)0)));
    }
}

