/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.image.DelegationTokenDelta;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.DelegationTokenManager;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005m4A\u0001D\u0007\u0001)!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b1\u0003A\u0011A'\t\u000fQ\u0003\u0001\u0019!C\u0001+\"9\u0011\f\u0001a\u0001\n\u0003Q\u0006B\u00021\u0001A\u0003&a\u000bC\u0003b\u0001\u0011\u0005#\rC\u0003d\u0001\u0011\u0005C\rC\u0003d\u0001\u0011\u0005\u0001P\u0001\rEK2,w-\u0019;j_:$vn[3o!V\u0014G.[:iKJT!AD\b\u0002\u00115,G/\u00193bi\u0006T!\u0001E\t\u0002\rM,'O^3s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0005\u0001UY\u0012\u0005\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039}i\u0011!\b\u0006\u0003=E\tQ!\u001e;jYNL!\u0001I\u000f\u0003\u000f1{wmZ5oOB\u0011!\u0005L\u0007\u0002G)\u0011A%J\u0001\naV\u0014G.[:iKJT!AJ\u0014\u0002\u000b%l\u0017mZ3\u000b\u0005IA#BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!L\u0012\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/\u0001\u0003d_:4\u0007C\u0001\u00192\u001b\u0005y\u0011B\u0001\u001a\u0010\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0011\u0005UJT\"\u0001\u001c\u000b\u0005]B\u0014!\u00024bk2$(B\u0001\t(\u0013\tQdG\u0001\u0007GCVdG\u000fS1oI2,'/\u0001\u0005o_\u0012,G+\u001f9f!\tiDI\u0004\u0002?\u0005B\u0011qhF\u0007\u0002\u0001*\u0011\u0011iE\u0001\u0007yI|w\u000e\u001e \n\u0005\r;\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\f\u0002\u0019Q|7.\u001a8NC:\fw-\u001a:\u0011\u0005%SU\"\u0001\u001d\n\u0005-C$A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0015q\u0005+\u0015*T!\ty\u0005!D\u0001\u000e\u0011\u0015qS\u00011\u00010\u0011\u0015\u0019T\u00011\u00015\u0011\u0015YT\u00011\u0001=\u0011\u00159U\u00011\u0001I\u00035yf-\u001b:tiB+(\r\\5tQV\ta\u000b\u0005\u0002\u0017/&\u0011\u0001l\u0006\u0002\b\u0005>|G.Z1o\u0003Eyf-\u001b:tiB+(\r\\5tQ~#S-\u001d\u000b\u00037z\u0003\"A\u0006/\n\u0005u;\"\u0001B+oSRDqaX\u0004\u0002\u0002\u0003\u0007a+A\u0002yIE\nab\u00184jeN$\b+\u001e2mSND\u0007%\u0001\u0003oC6,G#\u0001\u001f\u0002!=tW*\u001a;bI\u0006$\u0018-\u00169eCR,G\u0003B.fWBDQA\u001a\u0006A\u0002\u001d\fQ\u0001Z3mi\u0006\u0004\"\u0001[5\u000e\u0003\u0015J!A[\u0013\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b\u0011\u0015a'\u00021\u0001n\u0003!qWm^%nC\u001e,\u0007C\u00015o\u0013\tyWEA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\u0006c*\u0001\rA]\u0001\t[\u0006t\u0017NZ3tiB\u00111O^\u0007\u0002i*\u0011Q/J\u0001\u0007Y>\fG-\u001a:\n\u0005]$(A\u0004'pC\u0012,'/T1oS\u001a,7\u000f\u001e\u000b\u00047fT\b\"\u00024\f\u0001\u00049\u0007\"\u00027\f\u0001\u0004i\u0007")
public class DelegationTokenPublisher
implements Logging,
MetadataPublisher {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final DelegationTokenManager tokenManager;
    private boolean _firstPublish;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    @Override
    public void close() throws Exception {
        MetadataPublisher.super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelegationTokenPublisher delegationTokenPublisher = this;
        synchronized (delegationTokenPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    @Override
    public String name() {
        return "DelegationTokenPublisher " + this.nodeType + " id=" + this.conf.nodeId();
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = this._firstPublish() ? "initial MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset() : "update MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset();
        try {
            if (this._firstPublish()) {
                Option$.MODULE$.apply(newImage.delegationTokens()).foreach((Function1<DelegationTokenImage, Object> & Serializable)delegationTokenImage -> {
                    DelegationTokenPublisher.$anonfun$onMetadataUpdate$1(this, delegationTokenImage);
                    return BoxedUnit.UNIT;
                });
                this._firstPublish_$eq(false);
            }
            Option$.MODULE$.apply(delta.delegationTokenDelta()).foreach((Function1<DelegationTokenDelta, Object> & Serializable)delegationTokenDelta -> {
                DelegationTokenPublisher.$anonfun$onMetadataUpdate$3(this, delegationTokenDelta);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing DelegationToken changes from " + deltaName, t);
        }
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$1(DelegationTokenPublisher $this, DelegationTokenImage delegationTokenImage) {
        delegationTokenImage.tokens().forEach((x$1, delegationTokenData) -> $this.tokenManager.updateToken($this.tokenManager.getDelegationToken(delegationTokenData.tokenInformation())));
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$3(DelegationTokenPublisher $this, DelegationTokenDelta delegationTokenDelta) {
        delegationTokenDelta.changes().forEach((x0$1, x1$1) -> {
            Tuple2<String, Optional> tuple2 = new Tuple2<String, Optional>((String)x0$1, (Optional)x1$1);
            if (tuple2 != null) {
                String tokenId = tuple2._1();
                Optional delegationTokenData = tuple2._2();
                if (delegationTokenData.isPresent()) {
                    $this.tokenManager.updateToken($this.tokenManager.getDelegationToken(((DelegationTokenData)delegationTokenData.get()).tokenInformation()));
                    return;
                }
                $this.tokenManager.removeToken(tokenId);
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public DelegationTokenPublisher(KafkaConfig conf, FaultHandler faultHandler, String nodeType, DelegationTokenManager tokenManager) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.tokenManager = tokenManager;
        Logging.$init$(this);
        this.logIdent_$eq("[" + this.name() + "] ");
        this._firstPublish = true;
    }
}

