/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import io.confluent.kafka.storage.LogConfigRetriever;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kafka.server.KafkaConfigLogConfigRetriever;
import kafka.server.metadata.K2MetadataCache;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMb\u0001B\u001d;\u0001\u0005C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003l\u0001\u0011\u0005A\u000eC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\u0013\u0005U\u0001\u00011A\u0005\n\u0005]\u0001bBA\u0012\u0001\u0001\u0006Ka\u001d\u0005\n\u0003K\u0001\u0001\u0019!C\u0005\u0003OA\u0011\"!\r\u0001\u0001\u0004%I!a\r\t\u0011\u0005]\u0002\u0001)Q\u0005\u0003SA\u0011\"!\u000f\u0001\u0001\u0004%I!a\n\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\u0002CA!\u0001\u0001\u0006K!!\u000b\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0003\"CA(\u0001\u0001\u0007I\u0011BA)\u0011!\t)\u0006\u0001Q!\n\u0005\u001d\u0003\"CA,\u0001\u0001\u0007I\u0011BA-\u0011%\tI\u0007\u0001a\u0001\n\u0013\tY\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0015BA.\u0011%\t\t\b\u0001a\u0001\n\u0013\t9\u0003C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v!A\u0011\u0011\u0010\u0001!B\u0013\tI\u0003C\u0005\u0002|\u0001\u0001\r\u0011\"\u0003\u0002(!I\u0011Q\u0010\u0001A\u0002\u0013%\u0011q\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015)\u0003\u0002*!I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003'C\u0001\"a&\u0001A\u0003&\u0011\u0011\u0012\u0005\n\u00033\u0003\u0001\u0019!C\u0005\u0003OA\u0011\"a'\u0001\u0001\u0004%I!!(\t\u0011\u0005\u0005\u0006\u0001)Q\u0005\u0003SA\u0011\"a)\u0001\u0001\u0004%I!a\n\t\u0013\u0005\u0015\u0006\u00011A\u0005\n\u0005\u001d\u0006\u0002CAV\u0001\u0001\u0006K!!\u000b\t\u0013\u00055\u0006\u00011A\u0005\n\u0005\u001d\u0002\"CAX\u0001\u0001\u0007I\u0011BAY\u0011!\t)\f\u0001Q!\n\u0005%\u0002\"CA\\\u0001\u0001\u0007I\u0011BA]\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0015BA^\u0011%\tY\r\u0001a\u0001\n\u0013\ti\rC\u0005\u0002X\u0002\u0001\r\u0011\"\u0003\u0002Z\"A\u0011Q\u001c\u0001!B\u0013\ty\rC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005\r\b\u0001\"\u0011\u0002b\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBAu\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003[\u0004A\u0011IAq\u0011\u001d\ty\u000f\u0001C!\u0003CDq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0002v\u0002!\t%!9\t\u000f\u0005]\b\u0001\"\u0011\u0002b\"9\u0011\u0011 \u0001\u0005B\u0005\u0005\bbBA~\u0001\u0011\u0005\u0013Q \u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000b\u0011\u0011D\u0012:fS\u001eDG\u000fT8h\u0007>tg-[4SKR\u0014\u0018.\u001a<fe*\u00111\bP\u0001\t[\u0016$\u0018\rZ1uC*\u0011QHP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0005*\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004PE*,7\r\u001e\t\u0003\u0017Nk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bqa\u001d;pe\u0006<WM\u0003\u0002@\u001f*\u0011\u0001+U\u0001\nG>tg\r\\;f]RT\u0011AU\u0001\u0003S>L!\u0001\u0016'\u0003%1{wmQ8oM&<'+\u001a;sS\u00164XM]\u0001\u0015W\u000647.Y\"p]\u001aLwMU3ue&,g/\u001a:\u0011\u0005]CV\"\u0001\u001f\n\u0005ec$!H&bM.\f7i\u001c8gS\u001edunZ\"p]\u001aLwMU3ue&,g/\u001a:\u0002\u001f-\u0014T*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"\u0001X/\u000e\u0003iJ!A\u0018\u001e\u0003\u001f-\u0013T*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fq\u0001^8qS\u000eLE\r\u0005\u0002bS6\t!M\u0003\u0002dI\u000611m\\7n_:T!aP3\u000b\u0005\u0019<\u0017AB1qC\u000eDWMC\u0001i\u0003\ry'oZ\u0005\u0003U\n\u0014A!V;jI\u00061A(\u001b8jiz\"B!\u001c8paB\u0011A\f\u0001\u0005\u0006+\u0012\u0001\rA\u0016\u0005\u00065\u0012\u0001\ra\u0017\u0005\u0006?\u0012\u0001\r\u0001Y\u0001\u0016e\u0016$(/[3wK\u0012$v\u000e]5d\u0007>tg-[4t+\u0005\u0019\bc\u0001;xs6\tQOC\u0001w\u0003\u0015\u00198-\u00197b\u0013\tAXO\u0001\u0004PaRLwN\u001c\t\u0005uv|x0D\u0001|\u0015\tah)\u0001\u0003vi&d\u0017B\u0001@|\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0003\tyA\u0004\u0003\u0002\u0004\u0005-\u0001cAA\u0003k6\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0001\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u000eU\fa\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007k\u0006I\"/\u001a;sS\u00164X\r\u001a+pa&\u001c7i\u001c8gS\u001e\u001cx\fJ3r)\u0011\tI\"a\b\u0011\u0007Q\fY\"C\u0002\u0002\u001eU\u0014A!\u00168ji\"A\u0011\u0011\u0005\u0004\u0002\u0002\u0003\u00071/A\u0002yIE\naC]3ue&,g/\u001a3U_BL7mQ8oM&<7\u000fI\u0001\u001be\u0016$(/[3wK\u0012dun\u001a*fi\u0016tG/[8o\u0005f$Xm]\u000b\u0003\u0003S\u0001B\u0001^<\u0002,A\u0019A/!\f\n\u0007\u0005=RO\u0001\u0003M_:<\u0017A\b:fiJLWM^3e\u0019><'+\u001a;f]RLwN\u001c\"zi\u0016\u001cx\fJ3r)\u0011\tI\"!\u000e\t\u0013\u0005\u0005\u0012\"!AA\u0002\u0005%\u0012a\u0007:fiJLWM^3e\u0019><'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\b%A\u0010sKR\u0014\u0018.\u001a<fI2{wMU3uK:$\u0018n\u001c8US6,W*\u001b7mSN\f1E]3ue&,g/\u001a3M_\u001e\u0014V\r^3oi&|g\u000eV5nK6KG\u000e\\5t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005}\u0002\"CA\u0011\u0019\u0005\u0005\t\u0019AA\u0015\u0003\u0001\u0012X\r\u001e:jKZ,G\rT8h%\u0016$XM\u001c;j_:$\u0016.\\3NS2d\u0017n\u001d\u0011\u00021I,GO]5fm\u0016$W*Z:tC\u001e,W*\u0019=CsR,7/\u0006\u0002\u0002HA!Ao^A%!\r!\u00181J\u0005\u0004\u0003\u001b*(aA%oi\u0006a\"/\u001a;sS\u00164X\rZ'fgN\fw-Z'bq\nKH/Z:`I\u0015\fH\u0003BA\r\u0003'B\u0011\"!\t\u0010\u0003\u0003\u0005\r!a\u0012\u00023I,GO]5fm\u0016$W*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001!e\u0016$(/[3wK\u0012dunZ'fgN\fw-\u001a+j[\u0016\u001cH/Y7q)f\u0004X-\u0006\u0002\u0002\\A!Ao^A/!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2E\u00061!/Z2pe\u0012LA!a\u001a\u0002b\tiA+[7fgR\fW\u000e\u001d+za\u0016\fAE]3ue&,g/\u001a3M_\u001elUm]:bO\u0016$\u0016.\\3ti\u0006l\u0007\u000fV=qK~#S-\u001d\u000b\u0005\u00033\ti\u0007C\u0005\u0002\"I\t\t\u00111\u0001\u0002\\\u0005\t#/\u001a;sS\u00164X\r\u001a'pO6+7o]1hKRKW.Z:uC6\u0004H+\u001f9fA\u0005Y#/\u001a;sS\u00164X\r\u001a'pO6+7o]1hKRKW.Z:uC6\u0004()\u001a4pe\u0016l\u0015\r_'jY2L7/A\u0018sKR\u0014\u0018.\u001a<fI2{w-T3tg\u0006<W\rV5nKN$\u0018-\u001c9CK\u001a|'/Z'bq6KG\u000e\\5t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005]\u0004\"CA\u0011+\u0005\u0005\t\u0019AA\u0015\u00031\u0012X\r\u001e:jKZ,G\rT8h\u001b\u0016\u001c8/Y4f)&lWm\u001d;b[B\u0014UMZ8sK6\u000b\u00070T5mY&\u001c\b%\u0001\u0016sKR\u0014\u0018.\u001a<fI2{w-T3tg\u0006<W\rV5nKN$\u0018-\u001c9BMR,'/T1y\u001b&dG.[:\u0002]I,GO]5fm\u0016$Gj\\4NKN\u001c\u0018mZ3US6,7\u000f^1na\u00063G/\u001a:NCbl\u0015\u000e\u001c7jg~#S-\u001d\u000b\u0005\u00033\t\t\tC\u0005\u0002\"a\t\t\u00111\u0001\u0002*\u0005Y#/\u001a;sS\u00164X\r\u001a'pO6+7o]1hKRKW.Z:uC6\u0004\u0018I\u001a;fe6\u000b\u00070T5mY&\u001c\b%A\rsKR\u0014\u0018.\u001a<fI2{wm\u00117fC:,\b\u000fU8mS\u000eLXCAAE!\u0011!x/a#\u0011\ti\fii`\u0005\u0004\u0003\u001f[(\u0001\u0002'jgR\fQD]3ue&,g/\u001a3M_\u001e\u001cE.Z1okB\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u00033\t)\nC\u0005\u0002\"m\t\t\u00111\u0001\u0002\n\u0006Q\"/\u001a;sS\u00164X\r\u001a'pO\u000ecW-\u00198vaB{G.[2zA\u0005\u0011#/\u001a;sS\u00164X\r\u001a'pO6KgnQ8na\u0006\u001cG/[8o\u0019\u0006<W*\u001b7mSN\faE]3ue&,g/\u001a3M_\u001el\u0015N\\\"p[B\f7\r^5p]2\u000bw-T5mY&\u001cx\fJ3r)\u0011\tI\"a(\t\u0013\u0005\u0005b$!AA\u0002\u0005%\u0012a\t:fiJLWM^3e\u0019><W*\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015mZ'jY2L7\u000fI\u0001#e\u0016$(/[3wK\u0012dunZ'bq\u000e{W\u000e]1di&|g\u000eT1h\u001b&dG.[:\u0002MI,GO]5fm\u0016$Gj\\4NCb\u001cu.\u001c9bGRLwN\u001c'bO6KG\u000e\\5t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005%\u0006\"CA\u0011C\u0005\u0005\t\u0019AA\u0015\u0003\r\u0012X\r\u001e:jKZ,G\rT8h\u001b\u0006D8i\\7qC\u000e$\u0018n\u001c8MC\u001el\u0015\u000e\u001c7jg\u0002\n\u0011E]3ue&,g/\u001a3M_\u001e$U\r\\3uKJ+G/\u001a8uS>tW*\u001b7mSN\fQE]3ue&,g/\u001a3M_\u001e$U\r\\3uKJ+G/\u001a8uS>tW*\u001b7mSN|F%Z9\u0015\t\u0005e\u00111\u0017\u0005\n\u0003C!\u0013\u0011!a\u0001\u0003S\t!E]3ue&,g/\u001a3M_\u001e$U\r\\3uKJ+G/\u001a8uS>tW*\u001b7mSN\u0004\u0013A\t:fiJLWM^3e\u0019><W*\u001b8DY\u0016\fg.\u00192mK\u0012K'\u000f^=SCRLw.\u0006\u0002\u0002<B!Ao^A_!\r!\u0018qX\u0005\u0004\u0003\u0003,(A\u0002#pk\ndW-\u0001\u0014sKR\u0014\u0018.\u001a<fI2{w-T5o\u00072,\u0017M\\1cY\u0016$\u0015N\u001d;z%\u0006$\u0018n\\0%KF$B!!\u0007\u0002H\"I\u0011\u0011E\u0014\u0002\u0002\u0003\u0007\u00111X\u0001$e\u0016$(/[3wK\u0012dunZ'j]\u000ecW-\u00198bE2,G)\u001b:usJ\u000bG/[8!\u00031\u0012X\r\u001e:jKZ,G\rT8h\u00072,\u0017M\\3s)&lWm\u001d;b[B4\u0016\r\\5eCRLwN\\#oC\ndW-\u0006\u0002\u0002PB!Ao^Ai!\r!\u00181[\u0005\u0004\u0003+,(a\u0002\"p_2,\u0017M\\\u00011e\u0016$(/[3wK\u0012dunZ\"mK\u0006tWM\u001d+j[\u0016\u001cH/Y7q-\u0006d\u0017\u000eZ1uS>tWI\\1cY\u0016|F%Z9\u0015\t\u0005e\u00111\u001c\u0005\n\u0003CQ\u0013\u0011!a\u0001\u0003\u001f\fQF]3ue&,g/\u001a3M_\u001e\u001cE.Z1oKJ$\u0016.\\3ti\u0006l\u0007OV1mS\u0012\fG/[8o\u000b:\f'\r\\3!\u0003Eawn\u001a*fi\u0016tG/[8o\u0005f$Xm\u001d\u000b\u0003\u0003W\ta\u0003\\8h%\u0016$XM\u001c;j_:$\u0016.\\3NS2d\u0017n]\u0001\u0010[\u0016\u001c8/Y4f\u001b\u0006D()\u001f;fgR\u0011\u0011\u0011J\u0001\u0018Y><W*Z:tC\u001e,G+[7fgR\fW\u000e\u001d+za\u0016$\"!!\u0018\u0002E1|w-T3tg\u0006<W\rV5nKN$\u0018-\u001c9CK\u001a|'/Z'bq6KG\u000e\\5t\u0003\u0005bwnZ'fgN\fw-\u001a+j[\u0016\u001cH/Y7q\u0003\u001a$XM]'bq6KG\u000e\\5t\u0003AawnZ\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010\u0006\u0002\u0002\f\u0006IBn\\4NS:\u001cu.\u001c9bGRLwN\u001c'bO6KG\u000e\\5t\u0003eawnZ'bq\u000e{W\u000e]1di&|g\u000eT1h\u001b&dG.[:\u000211|w\rR3mKR,'+\u001a;f]RLwN\\'jY2L7/A\rm_\u001el\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|GCAA_\u0003\rbwnZ\"mK\u0006tWM\u001d+j[\u0016\u001cH/Y7q-\u0006d\u0017\u000eZ1uS>tWI\\1cY\u0016$\"!!5\u0002\u0011I,GO]5fm\u0016,BAa\u0002\u0003\u000eQA!\u0011\u0002B\u0010\u0005G\u0011i\u0003\u0005\u0003\u0003\f\t5A\u0002\u0001\u0003\b\u0005\u001fA$\u0019\u0001B\t\u0005\u0005\t\u0015\u0003\u0002B\n\u00053\u00012\u0001\u001eB\u000b\u0013\r\u00119\"\u001e\u0002\b\u001d>$\b.\u001b8h!\r!(1D\u0005\u0004\u0005;)(aA!os\"1!\u0011\u0005\u001dA\u0002}\f\u0011bY8oM&<7*Z=\t\u000f\t\u0015\u0002\b1\u0001\u0003(\u0005y\u0001/\u0019:tKN#(/\u001b8h\rVt7\r\u0005\u0004u\u0005Sy(\u0011B\u0005\u0004\u0005W)(!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u0011y\u0003\u000fa\u0001\u0005c\tQB]3ue&,g/\u001a:Gk:\u001c\u0007C\u0002;\u0003*)\u0013I\u0001")
public class FreightLogConfigRetriever
implements LogConfigRetriever {
    private final KafkaConfigLogConfigRetriever kafkaConfigRetriever;
    private final K2MetadataCache k2MetadataCache;
    private final Uuid topicId;
    private Option<Map<String, String>> retrievedTopicConfigs;
    private Option<Object> retrievedLogRetentionBytes;
    private Option<Object> retrievedLogRetentionTimeMillis;
    private Option<Object> retrievedMessageMaxBytes;
    private Option<TimestampType> retrievedLogMessageTimestampType;
    private Option<Object> retrievedLogMessageTimestampBeforeMaxMillis;
    private Option<Object> retrievedLogMessageTimestampAfterMaxMillis;
    private Option<List<String>> retrievedLogCleanupPolicy;
    private Option<Object> retrievedLogMinCompactionLagMillis;
    private Option<Object> retrievedLogMaxCompactionLagMillis;
    private Option<Object> retrievedLogDeleteRetentionMillis;
    private Option<Object> retrievedLogMinCleanableDirtyRatio;
    private Option<Object> retrievedLogCleanerTimestampValidationEnable;

    private Option<Map<String, String>> retrievedTopicConfigs() {
        return this.retrievedTopicConfigs;
    }

    private void retrievedTopicConfigs_$eq(Option<Map<String, String>> x$1) {
        this.retrievedTopicConfigs = x$1;
    }

    private Option<Object> retrievedLogRetentionBytes() {
        return this.retrievedLogRetentionBytes;
    }

    private void retrievedLogRetentionBytes_$eq(Option<Object> x$1) {
        this.retrievedLogRetentionBytes = x$1;
    }

    private Option<Object> retrievedLogRetentionTimeMillis() {
        return this.retrievedLogRetentionTimeMillis;
    }

    private void retrievedLogRetentionTimeMillis_$eq(Option<Object> x$1) {
        this.retrievedLogRetentionTimeMillis = x$1;
    }

    private Option<Object> retrievedMessageMaxBytes() {
        return this.retrievedMessageMaxBytes;
    }

    private void retrievedMessageMaxBytes_$eq(Option<Object> x$1) {
        this.retrievedMessageMaxBytes = x$1;
    }

    private Option<TimestampType> retrievedLogMessageTimestampType() {
        return this.retrievedLogMessageTimestampType;
    }

    private void retrievedLogMessageTimestampType_$eq(Option<TimestampType> x$1) {
        this.retrievedLogMessageTimestampType = x$1;
    }

    private Option<Object> retrievedLogMessageTimestampBeforeMaxMillis() {
        return this.retrievedLogMessageTimestampBeforeMaxMillis;
    }

    private void retrievedLogMessageTimestampBeforeMaxMillis_$eq(Option<Object> x$1) {
        this.retrievedLogMessageTimestampBeforeMaxMillis = x$1;
    }

    private Option<Object> retrievedLogMessageTimestampAfterMaxMillis() {
        return this.retrievedLogMessageTimestampAfterMaxMillis;
    }

    private void retrievedLogMessageTimestampAfterMaxMillis_$eq(Option<Object> x$1) {
        this.retrievedLogMessageTimestampAfterMaxMillis = x$1;
    }

    private Option<List<String>> retrievedLogCleanupPolicy() {
        return this.retrievedLogCleanupPolicy;
    }

    private void retrievedLogCleanupPolicy_$eq(Option<List<String>> x$1) {
        this.retrievedLogCleanupPolicy = x$1;
    }

    private Option<Object> retrievedLogMinCompactionLagMillis() {
        return this.retrievedLogMinCompactionLagMillis;
    }

    private void retrievedLogMinCompactionLagMillis_$eq(Option<Object> x$1) {
        this.retrievedLogMinCompactionLagMillis = x$1;
    }

    private Option<Object> retrievedLogMaxCompactionLagMillis() {
        return this.retrievedLogMaxCompactionLagMillis;
    }

    private void retrievedLogMaxCompactionLagMillis_$eq(Option<Object> x$1) {
        this.retrievedLogMaxCompactionLagMillis = x$1;
    }

    private Option<Object> retrievedLogDeleteRetentionMillis() {
        return this.retrievedLogDeleteRetentionMillis;
    }

    private void retrievedLogDeleteRetentionMillis_$eq(Option<Object> x$1) {
        this.retrievedLogDeleteRetentionMillis = x$1;
    }

    private Option<Object> retrievedLogMinCleanableDirtyRatio() {
        return this.retrievedLogMinCleanableDirtyRatio;
    }

    private void retrievedLogMinCleanableDirtyRatio_$eq(Option<Object> x$1) {
        this.retrievedLogMinCleanableDirtyRatio = x$1;
    }

    private Option<Object> retrievedLogCleanerTimestampValidationEnable() {
        return this.retrievedLogCleanerTimestampValidationEnable;
    }

    private void retrievedLogCleanerTimestampValidationEnable_$eq(Option<Object> x$1) {
        this.retrievedLogCleanerTimestampValidationEnable = x$1;
    }

    @Override
    public long logRetentionBytes() {
        Option<Object> option = this.retrievedLogRetentionBytes();
        if (None$.MODULE$.equals(option)) {
            String configKey = "retention.bytes";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logRetentionBytes());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogRetentionBytes_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logRetentionTimeMillis() {
        Option<Object> option = this.retrievedLogRetentionTimeMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "retention.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logRetentionTimeMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogRetentionTimeMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public int messageMaxBytes() {
        Option<Object> option = this.retrievedMessageMaxBytes();
        if (None$.MODULE$.equals(option)) {
            String configKey = "max.message.bytes";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToInteger(retriever.messageMaxBytes());
            int retrieved = BoxesRunTime.unboxToInt(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedMessageMaxBytes_$eq(new Some<Object>(BoxesRunTime.boxToInteger(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int alreadyRetrieved = BoxesRunTime.unboxToInt(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public TimestampType logMessageTimestampType() {
        Option<TimestampType> option = this.retrievedLogMessageTimestampType();
        if (None$.MODULE$.equals(option)) {
            String configKey = "message.timestamp.type";
            Function1<String, TimestampType> & Serializable parseStringFunc = (Function1<String, TimestampType> & Serializable)value -> TimestampType.forName((String)value);
            Function1<LogConfigRetriever, TimestampType> & Serializable retrieverFunc = (Function1<LogConfigRetriever, TimestampType> & Serializable)retriever -> retriever.logMessageTimestampType();
            TimestampType retrieved = (TimestampType)this.retrieve(configKey, parseStringFunc, retrieverFunc);
            this.retrievedLogMessageTimestampType_$eq(new Some<TimestampType>(retrieved));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TimestampType alreadyRetrieved = (TimestampType)some.value();
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logMessageTimestampBeforeMaxMillis() {
        Option<Object> option = this.retrievedLogMessageTimestampBeforeMaxMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "message.timestamp.before.max.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logMessageTimestampBeforeMaxMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogMessageTimestampBeforeMaxMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logMessageTimestampAfterMaxMillis() {
        Option<Object> option = this.retrievedLogMessageTimestampAfterMaxMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "message.timestamp.after.max.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logMessageTimestampAfterMaxMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogMessageTimestampAfterMaxMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public List<String> logCleanupPolicy() {
        Option<List<String>> option = this.retrievedLogCleanupPolicy();
        if (None$.MODULE$.equals(option)) {
            String configKey = "cleanup.policy";
            Function1<String, List> & Serializable parseStringFunc = (Function1<String, List> & Serializable)value -> {
                List<String> cleanupPolicy = Arrays.stream((Object[])value.split(",", -1)).map(x$1 -> x$1.trim()).filter(x$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)x$2))).toList();
                ConfigDef.ValidList validator = ConfigDef.ValidList.in((String[])new String[]{"compact", "delete"});
                validator.ensureValid("cleanup.policy", cleanupPolicy);
                if (cleanupPolicy.isEmpty()) {
                    throw new ConfigException("cleanup.policy cannot be empty");
                }
                return cleanupPolicy;
            };
            Function1<LogConfigRetriever, List> & Serializable retrieverFunc = (Function1<LogConfigRetriever, List> & Serializable)retriever -> retriever.logCleanupPolicy();
            List retrieved = (List)this.retrieve(configKey, parseStringFunc, retrieverFunc);
            this.retrievedLogCleanupPolicy_$eq(new Some<List<String>>(retrieved));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            List alreadyRetrieved = (List)some.value();
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logMinCompactionLagMillis() {
        Option<Object> option = this.retrievedLogMinCompactionLagMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "min.compaction.lag.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logMinCompactionLagMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogMinCompactionLagMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logMaxCompactionLagMillis() {
        Option<Object> option = this.retrievedLogMaxCompactionLagMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "max.compaction.lag.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logMaxCompactionLagMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogMaxCompactionLagMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public long logDeleteRetentionMillis() {
        Option<Object> option = this.retrievedLogDeleteRetentionMillis();
        if (None$.MODULE$.equals(option)) {
            String configKey = "delete.retention.ms";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToLong(retriever.logDeleteRetentionMillis());
            long retrieved = BoxesRunTime.unboxToLong(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogDeleteRetentionMillis_$eq(new Some<Object>(BoxesRunTime.boxToLong(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long alreadyRetrieved = BoxesRunTime.unboxToLong(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public double logMinCleanableDirtyRatio() {
        Option<Object> option = this.retrievedLogMinCleanableDirtyRatio();
        if (None$.MODULE$.equals(option)) {
            String configKey = "min.cleanable.dirty.ratio";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToDouble(retriever.logMinCleanableDirtyRatio());
            double retrieved = BoxesRunTime.unboxToDouble(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogMinCleanableDirtyRatio_$eq(new Some<Object>(BoxesRunTime.boxToDouble(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            double alreadyRetrieved = BoxesRunTime.unboxToDouble(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean logCleanerTimestampValidationEnable() {
        Option<Object> option = this.retrievedLogCleanerTimestampValidationEnable();
        if (None$.MODULE$.equals(option)) {
            String configKey = "confluent.log.cleaner.timestamp.validation.enable";
            Function1<String, Object> & Serializable parseStringFunc = (Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(value)));
            Function1<LogConfigRetriever, Object> & Serializable retrieverFunc = (Function1<LogConfigRetriever, Object> & Serializable)retriever -> BoxesRunTime.boxToBoolean(retriever.logCleanerTimestampValidationEnable());
            boolean retrieved = BoxesRunTime.unboxToBoolean(this.retrieve(configKey, parseStringFunc, retrieverFunc));
            this.retrievedLogCleanerTimestampValidationEnable_$eq(new Some<Object>(BoxesRunTime.boxToBoolean(retrieved)));
            return retrieved;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            boolean alreadyRetrieved = BoxesRunTime.unboxToBoolean(some.value());
            return alreadyRetrieved;
        }
        throw new MatchError(option);
    }

    private <A> A retrieve(String configKey, Function1<String, A> parseStringFunc, Function1<LogConfigRetriever, A> retrieverFunc) {
        Object object;
        try {
            Option<Map<String, String>> option = this.retrievedTopicConfigs();
            if (None$.MODULE$.equals(option)) {
                this.retrievedTopicConfigs_$eq(Option$.MODULE$.apply(this.k2MetadataCache.topicIdsToNames().get(this.topicId)).map((Function1<String, Map> & Serializable)topicName -> (Map)Option$.MODULE$.apply($this.k2MetadataCache.topicConfigMap((String)topicName)).getOrElse((Function0<Map> & Serializable)() -> Collections.emptyMap())).orElse((Function0<Some> & Serializable)() -> new Some(Collections.emptyMap())));
            }
            object = Option$.MODULE$.apply(this.retrievedTopicConfigs().get().get(configKey)).map(parseStringFunc).getOrElse((Function0<Object> & Serializable)() -> retrieverFunc.apply($this.kafkaConfigRetriever));
        }
        catch (Throwable throwable) {
            object = retrieverFunc.apply(LogConfigRetriever.DEFAULT_VALUE_RETRIEVER);
        }
        return object;
    }

    public FreightLogConfigRetriever(KafkaConfigLogConfigRetriever kafkaConfigRetriever, K2MetadataCache k2MetadataCache, Uuid topicId) {
        this.kafkaConfigRetriever = kafkaConfigRetriever;
        this.k2MetadataCache = k2MetadataCache;
        this.topicId = topicId;
        this.retrievedTopicConfigs = None$.MODULE$;
        this.retrievedLogRetentionBytes = None$.MODULE$;
        this.retrievedLogRetentionTimeMillis = None$.MODULE$;
        this.retrievedMessageMaxBytes = None$.MODULE$;
        this.retrievedLogMessageTimestampType = None$.MODULE$;
        this.retrievedLogMessageTimestampBeforeMaxMillis = None$.MODULE$;
        this.retrievedLogMessageTimestampAfterMaxMillis = None$.MODULE$;
        this.retrievedLogCleanupPolicy = None$.MODULE$;
        this.retrievedLogMinCompactionLagMillis = None$.MODULE$;
        this.retrievedLogMaxCompactionLagMillis = None$.MODULE$;
        this.retrievedLogDeleteRetentionMillis = None$.MODULE$;
        this.retrievedLogMinCleanableDirtyRatio = None$.MODULE$;
        this.retrievedLogCleanerTimestampValidationEnable = None$.MODULE$;
    }
}

