/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.image.publisher.K2TopicsImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.KRaftClientQuotaClusterDescriber;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d4A\u0001C\u0005\u0001!!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u001d\u0001\u0005A1A\u0005\n\u0005Ca!\u0012\u0001!\u0002\u0013\u0011\u0005\"\u0002$\u0001\t\u0003:\u0005\"B.\u0001\t\u0003b&AI&3\u0017J\u000bg\r^\"mS\u0016tG/U;pi\u0006\u001cE.^:uKJ$Um]2sS\n,'O\u0003\u0002\u000b\u0017\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\r\u001b\u000511/\u001a:wKJT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011#\u0007\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tA\u0001\\1oO*\ta#\u0001\u0003kCZ\f\u0017B\u0001\r\u0014\u0005\u0019y%M[3diB\u0011!dI\u0007\u00027)\u0011A$H\u0001\u0006cV|G/\u0019\u0006\u0003\u0019yQ!AD\u0010\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0005\u0003Im\u00111d\u00117jK:$\u0018+^8uC\u000ecWo\u001d;fe\u0012+7o\u0019:jE\u0016\u0014\u0018!B5nC\u001e,\u0007CA\u0014*\u001b\u0005A#BA\u0013\u001f\u0013\tQ\u0003FA\u0006U_BL7m]%nC\u001e,\u0017!D63)>\u0004\u0018nY:J[\u0006<W\r\u0005\u0002.q5\taF\u0003\u00020a\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0003KER!A\u0004\u001a\u000b\u0005M\"\u0014AA63\u0015\t)d'A\u0005d_:4G.^3oi*\tq'\u0001\u0002j_&\u0011\u0011H\f\u0002\u000e\u0017J\"v\u000e]5dg&k\u0017mZ3\u0002\rqJg.\u001b;?)\radh\u0010\t\u0003{\u0001i\u0011!\u0003\u0005\u0006K\r\u0001\rA\n\u0005\u0006W\r\u0001\r\u0001L\u0001\u001aWJ\fg\r^\"mS\u0016tG/U;pi\u0006$Um]2sS\n,'/F\u0001C!\t93)\u0003\u0002EQ\t\u00013JU1gi\u000ec\u0017.\u001a8u#V|G/Y\"mkN$XM\u001d#fg\u000e\u0014\u0018NY3s\u0003iY'/\u00194u\u00072LWM\u001c;Rk>$\u0018\rR3tGJL'-\u001a:!\u0003)!x\u000e]5d\u001d\u0006lWm\u001d\u000b\u0002\u0011B\u0019\u0011\n\u0014(\u000e\u0003)S!aS\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003\u001b*\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003\u001fbs!\u0001\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005M{\u0011A\u0002\u001fs_>$hHC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9F+\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,U\u0003I\u0001\u0018M\u001d;ji&|gn\u001d$peR{\u0007/[2\u0015\u0005u+\u0007cA%M=B\u0011qL\u0019\b\u00035\u0001L!!Y\u000e\u00027\rc\u0017.\u001a8u#V|G/Y\"mkN$XM\u001d#fg\u000e\u0014\u0018NY3s\u0013\t\u0019GMA\u0005QCJ$\u0018\u000e^5p]*\u0011\u0011m\u0007\u0005\u0006M\u001e\u0001\rAT\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004")
public class K2KRaftClientQuotaClusterDescriber
implements ClientQuotaClusterDescriber {
    private final TopicsImage image;
    private final K2TopicsImage k2TopicsImage;
    private final KRaftClientQuotaClusterDescriber kraftClientQuotaDescriber;

    private KRaftClientQuotaClusterDescriber kraftClientQuotaDescriber() {
        return this.kraftClientQuotaDescriber;
    }

    public Iterator<String> topicNames() {
        Stream kraftNames = StreamSupport.stream(this.image.topicsByName().keySet().spliterator(), false);
        Stream k2Names = this.k2TopicsImage.topicNameToId().keySet().stream();
        return Stream.concat(kraftNames, k2Names).iterator();
    }

    public Iterator<ClientQuotaClusterDescriber.Partition> partitionsForTopic(String topicName) {
        Stream<Object> stream;
        Stream<ClientQuotaClusterDescriber.Partition> kraftPartitions = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.kraftClientQuotaDescriber().partitionsForTopic(topicName), 16), false);
        Option option = Option$.MODULE$.apply(this.k2TopicsImage.topicNameToId().get(topicName));
        if (option instanceof Some) {
            Some some = (Some)option;
            Uuid topicId = (Uuid)some.value();
            Option<Map<TopicIdPartition, List<K2Node>>> option2 = Option$.MODULE$.apply(this.k2TopicsImage.assignmentsForTopic(topicId));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Map topicAssignments = (Map)some2.value();
                stream = topicAssignments.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(entry -> new ClientQuotaClusterDescriber.Partition(((TopicIdPartition)entry.getKey()).partition(), Integer.parseInt(((K2Node)((List)entry.getValue()).get(0)).id())));
            } else {
                stream = Stream.empty();
            }
        } else {
            stream = Stream.empty();
        }
        Stream k2Partitions = stream;
        return Stream.concat(kraftPartitions, k2Partitions).iterator();
    }

    public K2KRaftClientQuotaClusterDescriber(TopicsImage image, K2TopicsImage k2TopicsImage) {
        this.image = image;
        this.k2TopicsImage = k2TopicsImage;
        this.kraftClientQuotaDescriber = new KRaftClientQuotaClusterDescriber(image);
    }
}

