/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.affinity.AffinitySelector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kafka.server.metadata.K2MetadataCache;
import kafka.server.metadata.K2MetadataCache$;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u0015e\u0001\u0002\u001a4\u0001iB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\u0002eCa\u0001\u0019\u0001!\u0002\u0013Q\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00024\u0001\t\u0003:\u0007\"B:\u0001\t\u0003\"\b\"CA-\u0001E\u0005I\u0011AA.\u0011%\t\t\bAI\u0001\n\u0003\tY\u0006C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005M\u0004\u0001\"\u0011\u0002x!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\tI\u000b\u0001C!\u0003WCq!a.\u0001\t\u0003\nI\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\tI\u0010\u0001C!\u0003wDqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!1\u0006\u0001\u0005\n\t5\u0002b\u0002B\u0019\u0001\u0011\u0005#1\u0007\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u00119\u0005\u0001C!\u0005\u0013BqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003\\\u0001!\tE!\u0018\t\u000f\tm\u0003\u0001\"\u0011\u0003b!9!Q\r\u0001\u0005B\t\u001d\u0004b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005\u0017\u0003A\u0011\tBG\u0011\u001d\u0011Y\n\u0001C!\u0005;CqA!*\u0001\t\u0003\u00129\u000bC\u0004\u0003,\u0002!\tE!,\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!Q\u001b\u0001\u0005\u0002\t]\u0007bBB\r\u0001\u0011\u000531\u0004\u0005\b\u0007[\u0001A\u0011IB\u0018\u0011\u001d\u0019y\u0004\u0001C!\u0007\u0003Bqa!\u0014\u0001\t\u0003\u001ay\u0005C\u0004\u0004T\u0001!\te!\u0016\t\u000f\re\u0003\u0001\"\u0001\u0004\\\t!2JM&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!\u0001N\u001b\u0002\u00115,G/\u00193bi\u0006T!AN\u001c\u0002\rM,'O^3s\u0015\u0005A\u0014!B6bM.\f7\u0001A\n\u0004\u0001m\u001a\u0005C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011a\u0017M\\4\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0011+U\"A\u001a\n\u0005\u0019\u001b$aF&SC\u001a$\u0018*\\1hK6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003)Y'/\u00194u\u0007\u0006\u001c\u0007.Z\u000b\u0002\u0013B\u0011AIS\u0005\u0003\u0017N\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK\u0006Y1N]1gi\u000e\u000b7\r[3!\u0003\u001dY'gQ1dQ\u0016,\u0012a\u0014\t\u0003\tBK!!U\u001a\u0003\u001f-\u0013T*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f\u0001b\u001b\u001aDC\u000eDW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U3v\u000b\u0005\u0002E\u0001!)q)\u0002a\u0001\u0013\")Q*\u0002a\u0001\u001f\u0006yb/\u00197jI\u0006$X-\u0012=dYV\u001c\u0018N^5us\u0006\u001b'o\\:t\u0007\u0006\u001c\u0007.Z:\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013qAQ8pY\u0016\fg.\u0001\u0011wC2LG-\u0019;f\u000bb\u001cG.^:jm&$\u00180Q2s_N\u001c8)Y2iKN\u0004\u0013\u0001\u00032s_.,'/\u00133\u0016\u0003\r\u0004\"a\u00173\n\u0005\u0015d&aA%oi\u0006a1-\u001e:sK:$\u0018*\\1hKR\t\u0001\u000e\u0005\u0002jc6\t!N\u0003\u0002lY\u0006)\u0011.\\1hK*\u0011\u0001(\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sU\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0013U\f9#!\u0011\u0002R\u0005U\u0003c\u0001<zw6\tqO\u0003\u0002y\u007f\u0005!Q\u000f^5m\u0013\tQxO\u0001\u0003MSN$\bc\u0001?\u0002\"9\u0019Q0a\u0007\u000f\u0007y\f)BD\u0002\u0000\u0003#qA!!\u0001\u0002\u00109!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005s\u00051AH]8pizJ\u0011\u0001]\u0005\u0003]>L!\u0001O7\n\u0007\u0005MA.\u0001\u0004d_6lwN\\\u0005\u0005\u0003/\tI\"A\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005MA.\u0003\u0003\u0002\u001e\u0005}\u0011\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002\u0018\u0005e\u0011\u0002BA\u0012\u0003K\u0011Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7M\u0003\u0003\u0002\u001e\u0005}\u0001bBA\u0015\u0015\u0001\u0007\u00111F\u0001\u0007i>\u0004\u0018nY:\u0011\u000bY\fi#!\r\n\u0007\u0005=rOA\u0002TKR\u0004B!a\r\u0002<9!\u0011QGA\u001c!\r\t)\u0001X\u0005\u0004\u0003sa\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:qCq!a\u0011\u000b\u0001\u0004\t)%\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%!\u0007\u0002\u000f9,Go^8sW&!\u0011qJA%\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011!\t\u0019F\u0003I\u0001\u0002\u0004Q\u0016!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiND\u0001\"a\u0016\u000b!\u0003\u0005\rAW\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0002^)\u001a!,a\u0018,\u0005\u0005\u0005\u0004\u0003BA2\u0003[j!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001b]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\n)GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nAbZ3u\u00032dGk\u001c9jGN$\"!a\u000b\u0015\t\u0005-\u0012\u0011\u0010\u0005\b\u0003wr\u0001\u0019AA?\u0003=!XM\\1oiB\u0013XMZ5y\u001fB$\b#\u0002<\u0002\u0000\u0005E\u0012bAAAo\nAq\n\u001d;j_:\fG.\u0001\nhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAD\u0003#\u0003RA^A\u0017\u0003\u0013\u0003B!a#\u0002\u000e6\u0011\u0011\u0011D\u0005\u0005\u0003\u001f\u000bIB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005Mu\u00021\u0001\u00022\u0005IAo\u001c9jG:\u000bW.Z\u0001\u000bO\u0016$Hk\u001c9jG&#G\u0003BAM\u0003?\u0003B!a#\u0002\u001c&!\u0011QTA\r\u0005\u0011)V/\u001b3\t\u000f\u0005M\u0005\u00031\u0001\u00022\u0005aq-\u001a;U_BL7MT1nKR!\u0011QPAS\u0011\u001d\t9+\u0005a\u0001\u00033\u000bq\u0001^8qS\u000eLE-\u0001\u0007hKR$v\u000e]5d)f\u0004X\r\u0006\u0003\u0002.\u0006U\u0006#\u0002<\u0002\u0000\u0005=\u0006\u0003BAF\u0003cKA!a-\u0002\u001a\tIAk\u001c9jGRK\b/\u001a\u0005\b\u0003'\u0013\u0002\u0019AA\u0019\u00039A\u0017m]!mSZ,'I]8lKJ$2AWA^\u0011\u0015\t7\u00031\u0001d\u0003=9W\r^!mSZ,'I]8lKJ\u001cHCAAa!\u0015a\u00141YAd\u0013\r\t)-\u0010\u0002\t\u0013R,'/\u00192mKB!\u0011\u0011ZAi\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017!\u00039mC\u000e,W.\u001a8u\u0015\t!D.\u0003\u0003\u0002T\u0006-'\u0001D+tC\ndWM\u0011:pW\u0016\u0014\u0018AE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016$b!!7\u0002b\u0006\r\b#\u0002<\u0002\u0000\u0005m\u0007\u0003BAF\u0003;LA!a8\u0002\u001a\t!aj\u001c3f\u0011\u0015\tW\u00031\u0001d\u0011\u001d\t\u0019%\u0006a\u0001\u0003\u000b\nqbZ3u\u0005J|7.\u001a:DK2d\u0017\n\u001a\u000b\u0004G\u0006%\b\"B1\u0017\u0001\u0004\u0019\u0017aE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016\u001cH\u0003BAx\u0003c\u0004BA^=\u0002\\\"9\u00111I\fA\u0002\u0005\u0015\u0013AD4fi\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0003_\f9\u0010C\u0004\u0002Da\u0001\r!!\u0012\u0002\u001f\u001d,G\u000fT3bI\u0016\u0014\u0018I\u001c3JgJ$b!!@\u0003\b\t%\u0001#\u0002<\u0002\u0000\u0005}\b\u0003\u0002B\u0001\u0005\u0007i!!a4\n\t\t\u0015\u0011q\u001a\u0002\r\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003'K\u0002\u0019AA\u0019\u0011\u0019\u0011Y!\u0007a\u0001G\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!\u0011\u0003B\r!\u00151\u0018q\u0010B\n!\ra$QC\u0005\u0004\u0005/i$aB%oi\u0016<WM\u001d\u0005\b\u0003'S\u0002\u0019AA\u0019\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHC\u0001B\u0010!\u001d1(\u0011EA\u0019\u00033K1Aa\tx\u0005\ri\u0015\r]\u0001\u0010i>\u0004\u0018nY%egR{g*Y7fgR\u0011!\u0011\u0006\t\bm\n\u0005\u0012\u0011TA\u0019\u0003%I7o\u0013\u001aU_BL7\rF\u0002[\u0005_Aq!a%\u001e\u0001\u0004\t\t$\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0002Z\nU\"q\u0007B\u001d\u0011\u001d\t\u0019J\ba\u0001\u0003cAaAa\u0003\u001f\u0001\u0004\u0019\u0007bBA\"=\u0001\u0007\u0011QI\u0001\u001dO\u0016$\b+\u0019:uSRLwN\u001c*fa2L7-Y#oIB|\u0017N\u001c;t)\u0019\u0011yD!\u0011\u0003FA9aO!\t\u0003\u0014\u0005m\u0007b\u0002B\"?\u0001\u0007\u0011\u0011R\u0001\u0003iBDq!a\u0011 \u0001\u0004\t)%\u0001\fhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM]%e)\t\u0011\t\"\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGC\u0002B(\u0005+\u0012I\u0006\u0005\u0003\u0002\f\nE\u0013\u0002\u0002B*\u00033\u0011qa\u00117vgR,'\u000fC\u0004\u0003X\u0005\u0002\r!!\r\u0002\u0013\rdWo\u001d;fe&#\u0007bBA\"C\u0001\u0007\u0011QI\u0001\tG>tG/Y5ogR\u0019!La\u0018\t\u000f\u0005M%\u00051\u0001\u00022Q\u0019!La\u0019\t\u000f\t\r3\u00051\u0001\u0002\n\u0006A1/\u001a;J[\u0006<W\r\u0006\u0003\u0003j\t=\u0004cA.\u0003l%\u0019!Q\u000e/\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005c\"\u0003\u0019\u00015\u0002\u00119,w/S7bO\u0016\faaY8oM&<G\u0003\u0002B<\u0005{\u00022A\u001eB=\u0013\r\u0011Yh\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B@K\u0001\u0007!\u0011Q\u0001\u000fG>tg-[4SKN|WO]2f!\u0011\u0011\u0019Ia\"\u000e\u0005\t\u0015%\u0002\u0002B:\u00033IAA!#\u0003\u0006\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0015\u0005\t=\u0005\u0003\u0002BI\u0005/k!Aa%\u000b\t\u0005M!Q\u0013\u0006\u0003m1LAA!'\u0003\u0014\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u0005gK\u0006$XO]3t)\t\u0011y\n\u0005\u0003\u0003\u0012\n\u0005\u0016\u0002\u0002BR\u0005'\u0013\u0011CR5oC2L'0\u001a3GK\u0006$XO]3t\u0003AI7O\u0011:pW\u0016\u0014H)Z4sC\u0012,G\rF\u0002[\u0005SCQ!\u0019\u0015A\u0002\r\f\u0011$[:Ce>\\WM]\"p[B|g.\u001a8u\t\u0016<'/\u00193fIR)!La,\u00032\")\u0011-\u000ba\u0001G\"9!1W\u0015A\u0002\tU\u0016!C2p[B|g.\u001a8u!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000bQ!\u00193nS:T1Aa0m\u0003\u001d\u0019G.[3oiNLAAa1\u0003:\ny!I]8lKJ\u001cu.\u001c9p]\u0016tG/\u0001\tnSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKR!!\u0011\u001aBi!\u00151\u0018q\u0010Bf!\u0011\u0011\tA!4\n\t\t=\u0017q\u001a\u0002\f\u001b&\u0014(o\u001c:U_BL7\rC\u0004\u0003T*\u0002\r!!\r\u0002\u000bQ|\u0007/[2\u0002=\u0005$'.^:u)>\u0004\u0018nY'fi\u0006$\u0017\r^1G_J\feMZ5oSRLH\u0003\u0003Bm\u0005W\u001c)a!\u0006\u0011\r\tm'\u0011\u001dBs\u001b\t\u0011iNC\u0002\u0003`^\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011\u0019O!8\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0003h\u0006\u0005b\u0002\u0002Bu\u00037i!!a\b\t\u000f\t58\u00061\u0001\u0003p\u000691NM*uC\u000e\\\u0007\u0003\u0002By\u0007\u0003i!Aa=\u000b\u0007a\u0012)P\u0003\u0003\u0003x\ne\u0018AA63\u0015\u0011\u0011YP!@\u0002\u0013\r|gN\u001a7vK:$(B\u0001B\u0000\u0003\tIw.\u0003\u0003\u0004\u0004\tM(aB&3'R\f7m\u001b\u0005\b\u0007\u000fY\u0003\u0019AB\u0005\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004Baa\u0003\u0004\u00125\u00111Q\u0002\u0006\u0005\u0007\u001f\tI\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019\u0019b!\u0004\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"91qC\u0016A\u0002\t\u0015\u0018!\u0004;pa&\u001cW*\u001a;bI\u0006$\u0018-\u0001\u000beKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u0007;\u0019\u0019\u0003\u0005\u0003\u0003j\u000e}\u0011\u0002BB\u0011\u0003?\u0011\u0001\u0005R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rR1uC\"91Q\u0005\u0017A\u0002\r\u001d\u0012a\u0002:fcV,7\u000f\u001e\t\u0005\u0005S\u001cI#\u0003\u0003\u0004,\u0005}!a\b#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fR1uC\u0006AB-Z:de&\u0014WmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\rE2q\u0007\t\u0005\u0005S\u001c\u0019$\u0003\u0003\u00046\u0005}!\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0007bBB\u0013[\u0001\u00071\u0011\b\t\u0005\u0005S\u001cY$\u0003\u0003\u0004>\u0005}!a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e#bi\u0006\f1cZ3u\u00032Lg/\u001a\"s_.,'/\u00129pG\"$Baa\u0011\u0004LA)a/a \u0004FA\u0019Aha\u0012\n\u0007\r%SH\u0001\u0003M_:<\u0007\"B1/\u0001\u0004\u0019\u0017AD5t\u0005J|7.\u001a:GK:\u001cW\r\u001a\u000b\u00045\u000eE\u0003\"B10\u0001\u0004\u0019\u0017\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000eF\u0002[\u0007/BQ!\u0019\u0019A\u0002\r\fQ\u0003Z3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0004^\r\r41NB7\u0007{\u001a\t\t\u0005\u0003\u0003j\u000e}\u0013\u0002BB1\u0003?\u00111\u0005R3tGJL'-\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0002*E\u0002\ra!\u001a\u0011\u000bY\u001c9'!\r\n\u0007\r%tO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u001d\t\u0019%\ra\u0001\u0003\u000bBqaa\u001c2\u0001\u0004\u0019\t(\u0001\ru_BL7\rU1si&$\u0018n\u001c8Ti\u0006\u0014H/\u00138eKb\u0004\u0002ba\u001d\u0004z\u0005E\"1C\u0007\u0003\u0007kR1aa\u001ex\u0003!1WO\\2uS>t\u0017\u0002BB>\u0007k\u0012\u0001BR;oGRLwN\u001c\u0005\u0007\u0007\u007f\n\u0004\u0019A2\u000235\f\u00070[7v[:+XNY3s\u001f\u001a\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0007\u0007\u000b\u0004\u0019\u0001.\u00025%<gn\u001c:f)>\u0004\u0018nY:XSRDW\t_2faRLwN\\:")
public class K2KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final KRaftMetadataCache kraftCache;
    private final K2MetadataCache k2Cache;
    private final boolean validateExclusivityAcrossCaches;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        K2KRaftMetadataCache k2KRaftMetadataCache = this;
        synchronized (k2KRaftMetadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KRaftMetadataCache kraftCache() {
        return this.kraftCache;
    }

    public K2MetadataCache k2Cache() {
        return this.k2Cache;
    }

    public boolean validateExclusivityAcrossCaches() {
        return this.validateExclusivityAcrossCaches;
    }

    @Override
    public int brokerId() {
        return this.kraftCache().brokerId();
    }

    @Override
    public MetadataImage currentImage() {
        return this.kraftCache().currentImage();
    }

    @Override
    public List<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        ArrayList<MetadataResponseData.MetadataResponseTopic> list = new ArrayList<MetadataResponseData.MetadataResponseTopic>(this.kraftCache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners));
        list.addAll(this.k2Cache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners));
        return list;
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        HashSet<String> set = new HashSet<String>(this.kraftCache().getAllTopics());
        set.addAll(this.k2Cache().getAllTopics());
        return set;
    }

    @Override
    public Set<String> getAllTopics(Optional<String> tenantPrefixOpt) {
        HashSet<String> set = new HashSet<String>(this.kraftCache().getAllTopics(tenantPrefixOpt));
        set.addAll(this.k2Cache().getAllTopics(tenantPrefixOpt));
        return set;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        HashSet<TopicPartition> set = new HashSet<TopicPartition>(this.kraftCache().getTopicPartitions(topicName));
        set.addAll(this.k2Cache().getTopicPartitions(topicName));
        return set;
    }

    @Override
    public Uuid getTopicId(String topicName) {
        Uuid id = this.k2Cache().getTopicId(topicName);
        if (id.equals((Object)Uuid.ZERO_UUID)) {
            return this.kraftCache().getTopicId(topicName);
        }
        return id;
    }

    @Override
    public Optional<String> getTopicName(Uuid topicId) {
        Optional<String> topicName = this.kraftCache().getTopicName(topicId);
        if (topicName.isPresent()) {
            return topicName;
        }
        return this.k2Cache().getTopicName(topicId);
    }

    @Override
    public Optional<TopicType> getTopicType(String topicName) {
        Optional<TopicType> topicType = this.kraftCache().getTopicType(topicName);
        if (topicType.isPresent()) {
            return topicType;
        }
        return this.k2Cache().getTopicType(topicName);
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.kraftCache().hasAliveBroker(brokerId);
    }

    public Iterable<UsableBroker> getAliveBrokers() {
        return this.kraftCache().getAliveBrokers();
    }

    @Override
    public Optional<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNode(brokerId, listenerName);
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this.kraftCache().getBrokerCellId(brokerId);
    }

    @Override
    public List<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNodes(listenerName);
    }

    @Override
    public List<Node> getBrokerNodes(ListenerName listenerName) {
        return this.kraftCache().getBrokerNodes(listenerName);
    }

    @Override
    public Optional<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        Optional<LeaderAndIsr> leaderAndIsr = this.kraftCache().getLeaderAndIsr(topicName, partitionId);
        if (leaderAndIsr.isPresent()) {
            return leaderAndIsr;
        }
        return this.k2Cache().getLeaderAndIsr(topicName, partitionId);
    }

    @Override
    public Optional<Integer> numPartitions(String topicName) {
        Optional<Integer> numPart = this.kraftCache().numPartitions(topicName);
        if (numPart.isPresent()) {
            return numPart;
        }
        return this.k2Cache().numPartitions(topicName);
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        int combinedSize = this.kraftCache().topicNamesToIds().size() + this.k2Cache().topicNamesToIds().size();
        HashMap<String, Uuid> cache = new HashMap<String, Uuid>(combinedSize);
        cache.putAll(this.kraftCache().topicNamesToIds());
        cache.putAll(this.k2Cache().topicNamesToIds());
        return cache;
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        int combinedSize = this.kraftCache().topicIdsToNames().size() + this.k2Cache().topicIdsToNames().size();
        HashMap<Uuid, String> cache = new HashMap<Uuid, String>(combinedSize);
        cache.putAll(this.kraftCache().topicIdsToNames());
        cache.putAll(this.k2Cache().topicIdsToNames());
        return cache;
    }

    private boolean isK2Topic(String topicName) {
        boolean found = this.k2Cache().topicNamesToIds().containsKey(topicName);
        if (this.validateExclusivityAcrossCaches() && found && this.kraftCache().topicNamesToIds().containsKey(topicName)) {
            throw new IllegalStateException("Topic " + topicName + " found in both kraft and k2 metadata caches.");
        }
        return found;
    }

    @Override
    public Optional<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        Optional<Node> endpoint = this.kraftCache().getPartitionLeaderEndpoint(topicName, partitionId, listenerName);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        return this.getLeaderAndIsr(topicName, partitionId).flatMap(state -> this.kraftCache().getAliveBrokerNode(state.leader(), listenerName));
    }

    @Override
    public Map<Integer, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        Map<Integer, Node> replicaEndpoints = this.kraftCache().getPartitionReplicaEndpoints(tp, listenerName);
        if (!replicaEndpoints.isEmpty()) {
            return replicaEndpoints;
        }
        Option<K2MetadataCache.ReplicaSetMetadata> option = this.k2Cache().getPartitionInfo(tp, AffinitySelector.noAffinity(), K2MetadataCache$.MODULE$.EMPTY_CLIENT_CONTEXT());
        if (None$.MODULE$.equals(option)) {
            return Map.of();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            K2MetadataCache.ReplicaSetMetadata replicaSetMetadata = (K2MetadataCache.ReplicaSetMetadata)some.value();
            return CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaSetMetadata.availableReplicas()).asScala().flatMap((Function1<Integer, Option> & Serializable)r -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.kraftCache().getAliveBrokerNode(Predef$.MODULE$.Integer2int((Integer)r), listenerName))).map((Function1<Node, Tuple2> & Serializable)n -> new Tuple2<Integer, Node>((Integer)r, (Node)n)))).toMap($less$colon$less$.MODULE$.refl())).asJava();
        }
        throw new MatchError(option);
    }

    @Override
    public Optional<Integer> getRandomAliveBrokerId() {
        return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.k2Cache().getRandomControllerId().map((Function1<Object, Integer> & Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1))));
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        return this.kraftCache().getClusterMetadata(clusterId, listenerName);
    }

    @Override
    public boolean contains(String topicName) {
        return this.kraftCache().contains(topicName) || this.k2Cache().contains(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.kraftCache().contains(tp) || this.k2Cache().contains(tp);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this.kraftCache().setImage(newImage);
        this.k2Cache().setImage(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        block2: {
            block3: {
                TopicType topicType = this.getTopicType(configResource.name()).orElse(TopicType.UNKNOWN);
                ConfigResource.Type type = configResource.type();
                ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
                if (type != null ? !type.equals(type2) : type2 != null) break block2;
                TopicType topicType2 = topicType;
                TopicType topicType3 = TopicType.FREIGHT;
                if (!(topicType2 == null ? topicType3 != null : !topicType2.equals(topicType3))) break block3;
                TopicType topicType4 = topicType;
                TopicType topicType5 = TopicType.VIRTUAL;
                if (topicType4 != null ? !topicType4.equals(topicType5) : topicType5 != null) break block2;
            }
            return this.k2Cache().topicConfig(configResource.name());
        }
        return this.kraftCache().config(configResource);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.kraftCache().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        return this.kraftCache().features();
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return this.kraftCache().isBrokerDegraded(brokerId);
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return this.kraftCache().isBrokerComponentDegraded(brokerId, component);
    }

    @Override
    public Optional<MirrorTopic> mirrorTopicState(String topic) {
        if (this.isK2Topic(topic)) {
            return Optional.empty();
        }
        return this.kraftCache().mirrorTopicState(topic);
    }

    public CompletableFuture<MetadataResponseData.MetadataResponseTopic> adjustTopicMetadataForAffinity(K2Stack k2Stack, RequestContext requestContext, MetadataResponseData.MetadataResponseTopic topicMetadata) {
        block3: {
            block2: {
                Optional<TopicType> topicType = this.getTopicType(topicMetadata.name());
                if (topicType.isEmpty()) break block2;
                TopicType topicType2 = topicType.get();
                TopicType topicType3 = TopicType.FREIGHT;
                if (!(topicType2 == null ? topicType3 != null : !topicType2.equals(topicType3))) break block3;
            }
            return CompletableFuture.completedFuture(topicMetadata);
        }
        return this.k2Cache().adjustTopicMetadataForAffinity(k2Stack, requestContext, topicMetadata);
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this.kraftCache().describeClientQuotas(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this.kraftCache().describeScramCredentials(request);
    }

    @Override
    public Optional<Long> getAliveBrokerEpoch(int brokerId) {
        throw new UnsupportedOperationException("The ISR-specific method GetAliveBrokerEpoch is not currently implemented for K2.");
    }

    @Override
    public boolean isBrokerFenced(int brokerId) {
        throw new UnsupportedOperationException("The ISR-specific method IsBrokerFenced is not currently implemented for K2.");
    }

    @Override
    public boolean isBrokerShuttingDown(int brokerId) {
        throw new UnsupportedOperationException("The ISR-specific method IsBrokerShuttingDown is not currently implemented for K2.");
    }

    @Override
    public DescribeTopicPartitionsResponseData describeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function<String, Integer> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        throw new UnsupportedOperationException("DescribeTopicResponse is not currently implemented for K2 as no clients currently implement it yet.");
    }

    public K2KRaftMetadataCache(KRaftMetadataCache kraftCache, K2MetadataCache k2Cache) {
        this.kraftCache = kraftCache;
        this.k2Cache = k2Cache;
        Logging.$init$(this);
        this.validateExclusivityAcrossCaches = true;
        if (kraftCache.brokerId() != k2Cache.brokerId()) {
            throw new IllegalStateException("Mismatch in kraftCache.brokerId=" + kraftCache.brokerId() + " and k2Cache.brokerId=" + k2Cache.brokerId());
        }
        this.logIdent_$eq("[K2KRaftMetadataCache brokerId=" + kraftCache + ".brokerId] ");
    }
}

