/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.persister.ShareCoordinatorMetadataCacheHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareCoordinatorMetadataCacheHelperImpl
implements ShareCoordinatorMetadataCacheHelper {
    private final MetadataCache metadataCache;
    private final Function<SharePartitionKey, Integer> keyToPartitionMapper;
    private final ListenerName interBrokerListenerName;
    private final Logger log = LoggerFactory.getLogger(ShareCoordinatorMetadataCacheHelperImpl.class);

    public ShareCoordinatorMetadataCacheHelperImpl(MetadataCache metadataCache, Function<SharePartitionKey, Integer> keyToPartitionMapper, ListenerName interBrokerListenerName) {
        this.metadataCache = Objects.requireNonNull(metadataCache, "metadataCache must not be null");
        this.keyToPartitionMapper = Objects.requireNonNull(keyToPartitionMapper, "keyToPartitionMapper must not be null");
        this.interBrokerListenerName = Objects.requireNonNull(interBrokerListenerName, "interBrokerListenerName must not be null");
    }

    @Override
    public boolean containsTopic(String topic) {
        try {
            return this.metadataCache.contains(topic);
        }
        catch (Exception e) {
            this.log.warn("Exception checking {} in metadata cache", (Object)topic, (Object)e);
            return false;
        }
    }

    @Override
    public Node getShareCoordinator(SharePartitionKey key, String internalTopicName) {
        try {
            if (this.metadataCache.contains(internalTopicName)) {
                HashSet<String> topicSet = new HashSet<String>();
                topicSet.add(internalTopicName);
                List<MetadataResponseData.MetadataResponseTopic> topicMetadata = this.metadataCache.getTopicMetadata(topicSet, this.interBrokerListenerName, false, false);
                if (topicMetadata == null || topicMetadata.isEmpty() || topicMetadata.get(0).errorCode() != Errors.NONE.code()) {
                    return Node.noNode();
                }
                int partition = this.keyToPartitionMapper.apply(key);
                Optional<MetadataResponseData.MetadataResponsePartition> response = topicMetadata.get(0).partitions().stream().filter(responsePart -> responsePart.partitionIndex() == partition && responsePart.leaderId() != -1).findFirst();
                if (response.isPresent()) {
                    return this.metadataCache.getAliveBrokerNode(response.get().leaderId(), this.interBrokerListenerName).orElse(Node.noNode());
                }
                return Node.noNode();
            }
        }
        catch (Exception e) {
            this.log.warn("Exception while getting share coordinator", (Throwable)e);
        }
        return Node.noNode();
    }

    @Override
    public List<Node> getClusterNodes() {
        try {
            return this.metadataCache.getAliveBrokerNodes(this.interBrokerListenerName);
        }
        catch (Exception e) {
            this.log.warn("Exception while getting cluster nodes", (Throwable)e);
            return List.of();
        }
    }
}

