/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierMetadataSnapshotUploadComplete;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteComplete;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteInitiate;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeletePreInitiate;
import io.confluent.kafka.storage.tier.domain.TierTopicInitLeader;
import io.confluent.kafka.storage.tier.state.TierPartitionStatus;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.server.BrokerReconfigurable;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.MaterializationComplete$;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002%J\u00019C\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\t]\u0002\u0011\t\u0011)A\u0005_\"A!\u000f\u0001B\u0001B\u0003%1\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003{\u0011!i\bA!A!\u0002\u0013q\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003{\u0011)\t)\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005}\u0001BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u00020!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\t)\b\u0001Q\u0001\n\u0005}\u0003\"CA<\u0001\t\u0007I\u0011BA=\u0011!\t\t\t\u0001Q\u0001\n\u0005m\u0004\"CAB\u0001\t\u0007I\u0011BAC\u0011!\t\t\n\u0001Q\u0001\n\u0005\u001d\u0005bCAJ\u0001\u0001\u0007\t\u0019!C\u0005\u0003+C1\"!(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 \"Y\u00111\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAL\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\u000bC\u0005\u00022\u0002\u0001\r\u0011\"\u0003\u00024\"9\u0011q\u0017\u0001!B\u0013Q\b\"CA]\u0001\u0001\u0007I\u0011BA^\u0011%\ti\f\u0001a\u0001\n\u0013\ty\fC\u0004\u0002D\u0002\u0001\u000b\u0015\u0002@\t\u0015\u0005\u0015\u0007A1A\u0005\u0002%\u000b9\r\u0003\u0005\u0002`\u0002\u0001\u000b\u0011BAe\u0011-\t\t\u000f\u0001a\u0001\u0002\u0004%I!a9\t\u0017\t=\u0001\u00011AA\u0002\u0013%!\u0011\u0003\u0005\f\u0003o\u0004\u0001\u0019!A!B\u0013\t)\u000fC\u0005\u0003\u001e\u0001\u0001\r\u0011\"\u0003\u0003 !I!q\u0005\u0001A\u0002\u0013%!\u0011\u0006\u0005\t\u0005[\u0001\u0001\u0015)\u0003\u0003\"!I!\u0011\u0007\u0001C\u0002\u0013%!1\u0007\u0005\t\u0005\u0003\u0002\u0001\u0015!\u0003\u00036!9!1\t\u0001\u0005B\t\u0015\u0003b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0005\b\u0005;\u0002A\u0011\tB0\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!q\u0010\u0001\u0005\u0002\t%\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\n\u0005\u0013\u0003\u0011\u0013!C\u0005\u0005\u0017CqA!)\u0001\t\u0013\u0011I\u0007\u0003\u0005\u0003$\u0002!\t!\u0013B5\u0011!\u0011)\u000b\u0001C\u0001\u0013\n%\u0004b\u0002BT\u0001\u0011%!\u0011\u000e\u0005\b\u0005S\u0003A\u0011\u0002B5\u0011!\u0011Y\u000b\u0001C\u0001\u0013\n5\u0006\u0002\u0003Bk\u0001\u0011\u0005\u0011J!\u001b\t\u0011\t]\u0007\u0001\"\u0001J\u0005SB\u0001B!7\u0001\t\u0003I%\u0011\u000e\u0005\t\u00057\u0004A\u0011A%\u0003^\"A1Q\u0002\u0001\u0005\u0002%\u001by\u0001\u0003\u0005\u0004\u001c\u0001!\t!SB\u000f\u0011!\u00199\u0003\u0001C\u0001\u0013\u000e%\u0002\u0002\u0003B/\u0001\u0011\u0005\u0011ja\f\t\u000f\rU\u0002\u0001\"\u0003\u00048!91q\b\u0001\u0005\n\r\u0005\u0003bBB%\u0001\u0011%11J\u0004\b\u0007/J\u0005\u0012AB-\r\u0019A\u0015\n#\u0001\u0004\\!9\u00111\t!\u0005\u0002\ru\u0003\"CB0\u0001\n\u0007I\u0011AAC\u0011!\u0019\t\u0007\u0011Q\u0001\n\u0005\u001d\u0005\"CB2\u0001\n\u0007I\u0011AB3\u0011!\u0019\t\b\u0011Q\u0001\n\r\u001d\u0004bBB:\u0001\u0012\u00051Q\u000f\u0005\n\u0007\u000f\u0003\u0015\u0013!C\u0001\u0007\u0013\u0013\u0001\u0005V5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe*\u0011!jS\u0001\u0005i&,'OC\u0001M\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A(V7B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n1\u0011I\\=SK\u001a\u0004\"AV-\u000e\u0003]S!\u0001W&\u0002\u000bU$\u0018\u000e\\:\n\u0005i;&a\u0002'pO\u001eLgn\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000baa]3sm\u0016\u0014\u0018B\u00011^\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u0006I1o\u00195fIVdWM\u001d\t\u0003G2l\u0011\u0001\u001a\u0006\u0003K\u001a\fA!\u001e;jY*\u0011al\u001a\u0006\u0003\u0019\"T!!\u001b6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0017aA8sO&\u0011Q\u000e\u001a\u0002\n'\u000eDW\rZ;mKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002]a&\u0011\u0011/\u0018\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m&\u000bQ\u0001^8qS\u000eL!\u0001_;\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'/A\tj]&$\u0018.\u00197J]R,'O^1m\u001bN\u0004\"\u0001U>\n\u0005q\f&\u0001\u0002'p]\u001e\fa$\u001b8ji&\fG.T1y\u0013:\u0004(o\\4sKN\u001c\b+\u0019:uSRLwN\\:\u0011\u0005A{\u0018bAA\u0001#\n\u0019\u0011J\u001c;\u0002!%t\u0017\u000e^5bY\n\u000b7m[8gM6\u001b\u0018!\u0004;jKJt\u0015-\\3ta\u0006\u001cW\r\u0005\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'\u00012!!\u0004R\u001b\t\tyAC\u0002\u0002\u00125\u000ba\u0001\u0010:p_Rt\u0014bAA\u000b#\u00061\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006R\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005\u0012\u0011F\u0007\u0003\u0003GQ1\u0001WA\u0013\u0015\r\t9cZ\u0001\u0007G>lWn\u001c8\n\t\u0005-\u00121\u0005\u0002\u0005)&lW-\u0001\u000buS\u0016\u0014xJ\u00196fGR<5iU;qa2LWM\u001d\t\u0006!\u0006E\u0012QG\u0005\u0004\u0003g\t&AB(qi&|g\u000eE\u0003Q\u0003o\tY$C\u0002\u0002:E\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005u\u0012qH\u0007\u0002\u0013&\u0019\u0011\u0011I%\u00035QKWM](cU\u0016\u001cGoR1sE\u0006<WmQ8mY\u0016\u001cGo\u001c:\u0002\rqJg.\u001b;?)Q\t9%!\u0013\u0002L\u00055\u0013qJA)\u0003'\n)&a\u0016\u0002ZA\u0019\u0011Q\b\u0001\t\u000b\u0005T\u0001\u0019\u00012\t\u000b9T\u0001\u0019A8\t\u000bIT\u0001\u0019A:\t\u000beT\u0001\u0019\u0001>\t\u000buT\u0001\u0019\u0001@\t\r\u0005\r!\u00021\u0001{\u0011\u001d\t)A\u0003a\u0001\u0003\u000fAq!!\b\u000b\u0001\u0004\ty\u0002C\u0005\u0002.)\u0001\n\u00111\u0001\u00020\u0005yA.Y:u\u0011\u0016\f'\u000f\u001e2fCRl5/\u0006\u0002\u0002`A!\u0011\u0011MA9\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AB1u_6L7M\u0003\u0003\u0002j\u0005-\u0014AC2p]\u000e,(O]3oi*\u0019Q-!\u001c\u000b\u0005\u0005=\u0014\u0001\u00026bm\u0006LA!a\u001d\u0002d\tQ\u0011\t^8nS\u000eduN\\4\u0002!1\f7\u000f\u001e%fCJ$(-Z1u\u001bN\u0004\u0013\u0001D5t\u0013:<vN]6M_>\u0004XCAA>!\u0011\t\t'! \n\t\u0005}\u00141\r\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001b%\u001c\u0018J\\,pe.dun\u001c9!\u00035!\u0018.\u001a:U_BL7MT1nKV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*!\u0011QRA7\u0003\u0011a\u0017M\\4\n\t\u0005e\u00111R\u0001\u000fi&,'\u000fV8qS\u000et\u0015-\\3!\u0003!a\u0017n\u001d;f]\u0016\u0014XCAAL!\u0011\ti$!'\n\u0007\u0005m\u0015JA\u0010EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0005.\u00198hK2K7\u000f^3oKJ\fA\u0002\\5ti\u0016tWM]0%KF$B!!)\u0002(B\u0019\u0001+a)\n\u0007\u0005\u0015\u0016K\u0001\u0003V]&$\b\"CAU%\u0005\u0005\t\u0019AAL\u0003\rAH%M\u0001\nY&\u001cH/\u001a8fe\u0002\n1\u0004\\1ti\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7\t[3dW6\u001bX#\u0001>\u0002?1\f7\u000f\u001e#fY\u0016$X\r\u001a)beRLG/[8o\u0007\",7m['t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0006U\u0006\u0002CAU+\u0005\u0005\t\u0019\u0001>\u000291\f7\u000f\u001e#fY\u0016$X\r\u001a)beRLG/[8o\u0007\",7m['tA\u0005ia.^7J]B\u0013xn\u001a:fgN,\u0012A`\u0001\u0012]Vl\u0017J\u001c)s_\u001e\u0014Xm]:`I\u0015\fH\u0003BAQ\u0003\u0003D\u0001\"!+\u0019\u0003\u0003\u0005\rA`\u0001\u000f]Vl\u0017J\u001c)s_\u001e\u0014Xm]:!\u0003QIW.\\5he\u0006$X\r\u001a)beRLG/[8ogV\u0011\u0011\u0011\u001a\t\b\u0003\u0017\f)N`Am\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'\f\u0016AC2pY2,7\r^5p]&!\u0011q[Ag\u0005\ri\u0015\r\u001d\t\u0005\u0003{\tY.C\u0002\u0002^&\u0013A$S7nS\u001e\u0014\u0018\r^3e)&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000bj[6LwM]1uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u001f\r|wN\u001d3j]\u0006$xN\u001d+bg.,\"!!:1\t\u0005\u001d\u00181\u001f\t\u0007\u0003S\fY/a<\u000e\u0005\u0005\u001d\u0014\u0002BAw\u0003O\u0012qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u0003c\f\u0019\u0010\u0004\u0001\u0005\u0017\u0005Uh$!A\u0001\u0002\u000b\u0005!\u0011\u0001\u0002\u0004?\u0012\n\u0014\u0001E2p_J$\u0017N\\1u_J$\u0016m]6!Q\rq\u00121 \t\u0004!\u0006u\u0018bAA\u0000#\nAao\u001c7bi&dW-\u0005\u0003\u0003\u0004\t%\u0001c\u0001)\u0003\u0006%\u0019!qA)\u0003\u000f9{G\u000f[5oOB\u0019\u0001Ka\u0003\n\u0007\t5\u0011KA\u0002B]f\f1cY8pe\u0012Lg.\u0019;peR\u000b7o[0%KF$B!!)\u0003\u0014!I\u0011\u0011V\u000f\u0002\u0002\u0003\u0007!Q\u0003\u0019\u0005\u0005/\u0011Y\u0002\u0005\u0004\u0002j\u0006-(\u0011\u0004\t\u0005\u0003c\u0014Y\u0002\u0002\u0007\u0002v\nM\u0011\u0011!A\u0001\u0006\u0003\u0011\t!\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0005C\u0001B!!\u0010\u0003$%\u0019!QE%\u0003\r\r{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\u0013Y\u0003C\u0005\u0002*\u0002\n\t\u00111\u0001\u0003\"\u000591m\u001c8gS\u001e\u0004\u0003fA\u0011\u0002|\u0006aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011!Q\u0007\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)\u0019!1\b4\u0002\u000f5,GO]5dg&!!q\bB\u001d\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!q\t\t\u0007\u0005\u0013\u0012Y%a\u0002\u000e\u0005\u0005E\u0017\u0002\u0002B'\u0003#\u00141aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002\"\nM\u0003b\u0002B+K\u0001\u0007!qK\u0001\n]\u0016<8i\u001c8gS\u001e\u00042\u0001\u0018B-\u0013\r\u0011Y&\u0018\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,GCBAQ\u0005C\u0012)\u0007C\u0004\u0003d\u0019\u0002\rAa\u0016\u0002\u0013=dGmQ8oM&<\u0007b\u0002B+M\u0001\u0007!qK\u0001\bgR\f'\u000f^;q)\t\t\t+A\tiC:$G.Z%n[&<'/\u0019;j_:$B!!)\u0003p!1!\u0011\u000f\u0015A\u0002y\fA\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]&#\u0017\u0001\u00055b]\u0012dW-R7jOJ\fG/[8o)\u0011\t\tKa\u001e\t\r\tE\u0014\u00061\u0001\u007f\u0003A\u0011XmZ5ti\u0016\u0014H*[:uK:,'\u000f\u0006\u0003\u0002\"\nu\u0004bBAJU\u0001\u0007\u0011qS\u0001\tg\",H\u000fZ8x]\u0006\u00012\u000f^1si\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0005\u0003C\u0013)\t\u0003\u0005\u0003\b2\u0002\n\u00111\u0001\u007f\u0003\u0015!W\r\\1z\u0003i\u0019H/\u0019:u\u0007>|'\u000fZ5oCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iIK\u0002\u007f\u0005\u001f[#A!%\u0011\t\tM%QT\u0007\u0003\u0005+SAAa&\u0003\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057\u000b\u0016AC1o]>$\u0018\r^5p]&!!q\u0014BK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010gR|\u0007oQ8pe\u0012Lg.\u0019;pe\u0006I\u0001.Z1si\n,\u0017\r^\u0001\u0007I><vN]6\u0002+\u0019Lg\u000e\u001a#fY\u0016$X\r\u001a)beRLG/[8og\u0006yQ.Y6f)J\fgn]5uS>t7/\u0001\rd_2dWm\u0019;EK2,G/\u001a3QCJ$\u0018\u000e^5p]N$\u0002Ba,\u0003B\n5'\u0011\u001b\t\u0007!\nE&P!.\n\u0007\tM\u0016K\u0001\u0004UkBdWM\r\t\u0005\u0005o\u0013i,\u0004\u0002\u0003:*!!1XA7\u0003\rq\u0017n\\\u0005\u0005\u0005\u007f\u0013IL\u0001\u0006CsR,')\u001e4gKJDqAa14\u0001\u0004\u0011)-\u0001\nuS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002Bd\u0005\u0013l!!!\n\n\t\t-\u0017Q\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011ym\ra\u0001u\u0006Y1\u000f^1si>3gm]3u\u0011\u001d\u0011\u0019n\ra\u0001\u0005k\u000bq\"\u00197m_\u000e\fG/\u001a3Ck\u001a4WM]\u0001\u0019eVtw)\u0019:cC\u001e,7i\u001c7mK\u000e$xN\u001d+bg.\u001c\u0018!G7bs\n,')Z4j]6\u000bG/\u001a:jC2L'0\u0019;j_:\f!#\\1zE\u0016\u0014UmZ5o\t\u0016dW\r^5p]\u0006ACO]1dW&s\u0017\u000e\u001e'fC\u0012,'/\u00118e':\f\u0007o\u001d5piV\u0003Hn\\1e\u0007>l\u0007\u000f\\3uKRA\u0011\u0011\u0015Bp\u0005C\u0014i\u0010\u0003\u0004\u0003r]\u0002\rA \u0005\b\u0005G<\u0004\u0019\u0001Bs\u00031qWm\u001e)beRLG/[8o!\u0011\u00119O!?\u000e\u0005\t%(b\u0001&\u0003l*!!Q\u001eBx\u0003\u001d\u0019Ho\u001c:bO\u0016T1\u0001\u0014By\u0015\u0011\u0011\u0019P!>\u0002\u0013\r|gN\u001a7vK:$(B\u0001B|\u0003\tIw.\u0003\u0003\u0003|\n%(\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\u0011yp\u000ea\u0001\u0007\u0003\t\u0011d\u0019:fCRLwN\\(gMN,G/\u00118e\u000bB|7\r[(qiB)\u0001+!\r\u0004\u0004A!1QAB\u0005\u001b\t\u00199AC\u0002\u0002(\u0019LAaa\u0003\u0004\b\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0017a\b;sC\u000e\\\u0007K]3J]&$\u0018.\u0019;f!\u0006\u0014H/\u001b;j_:$U\r\\3uKRA\u0011\u0011UB\t\u0007'\u00199\u0002\u0003\u0004\u0003ra\u0002\rA \u0005\b\u0007+A\u0004\u0019\u0001Bs\u0003A!W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0004\u001aa\u0002\rA_\u0001\ni&lWm\u001d;b[B\fA\u0004\u001e:bG.Le.\u001b;jCR,\u0007+\u0019:uSRLwN\u001c#fY\u0016$X\r\u0006\u0005\u0002\"\u000e}1\u0011EB\u0012\u0011\u0019\u0011\t(\u000fa\u0001}\"91QC\u001dA\u0002\t\u0015\bBBB\u0013s\u0001\u0007!0\u0001\u0004pM\u001a\u001cX\r^\u0001\u001diJ\f7m[\"p[BdW\r^3QCJ$\u0018\u000e^5p]\u0012+G.\u001a;f)\u0019\t\tka\u000b\u0004.!1!\u0011\u000f\u001eA\u0002yDqa!\u0006;\u0001\u0004\u0011)\u000f\u0006\u0003\u0002\"\u000eE\u0002bBB\u001aw\u0001\u0007!\u0011E\u0001\u000faJ|\u0007o\\:fI\u000e{gNZ5h\u0003E)\b\u000fZ1uKN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u0003C\u001bIda\u000f\t\r\tED\b1\u0001\u007f\u0011\u0019\u0019i\u0004\u0010a\u0001u\u0006qa.Z<Ti\u0006\u0014Ho\u00144gg\u0016$\u0018a\b;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i!>\u001c\u0018\u000e^5p]V\u001111\t\t\t\u0005\u0013\u001a)E!2\u0004H%!\u0011q[Ai!\u0011\u0001\u0016\u0011\u0007>\u0002!\r\fgnY3m\u0013:\u0004&o\\4sKN\u001cH\u0003BAQ\u0007\u001bBqaa\u0014?\u0001\u0004\u0019\t&\u0001\nj]B\u0013xn\u001a:fgN$U\r\\3uS>t\u0007\u0003BA\u001f\u0007'J1a!\u0016J\u0005IIe\u000e\u0015:pOJ,7o\u001d#fY\u0016$\u0018n\u001c8\u0002AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0004\u0003{\u00015C\u0001!P)\t\u0019I&\u0001\u0007T\u001d\u0006\u00036\u000bS(U?\u0012K%+A\u0007T\u001d\u0006\u00036\u000bS(U?\u0012K%\u000bI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u00199\u0007\u0005\u0004\u0004j\r=\u0014qQ\u0007\u0003\u0007WRAa!\u001c\u0002R\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005\u001b\u001aY'\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u0003-\u0019h.\u00199tQ>$H)\u001b:\u0015\t\r]41\u0011\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)!1Q\u0010B]\u0003\u00111\u0017\u000e\\3\n\t\r\u000551\u0010\u0002\u0005!\u0006$\b\u000eC\u0004\u0004\u0006\u001a\u0003\r!a\u0002\u0002\u0011I|w\u000e\u001e)bi\"\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTCABFU\u0011\tyCa$")
public class TierDeletedPartitionsCoordinator
implements Logging,
BrokerReconfigurable {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TierTopicConsumer tierTopicConsumer;
    private final Time time;
    private final Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier;
    private final AtomicLong lastHeartbeatMs;
    private final AtomicBoolean isInWorkLoop;
    private final String tierTopicName;
    private DeletedPartitionsChangeListener listener;
    private long lastDeletedPartitionCheckMs;
    private int numInProgress;
    private final scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions;
    private volatile ScheduledFuture<?> coordinatorTask;
    private volatile Config config;
    private final KafkaMetricsGroup metricsGroup;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Function0<TierObjectGarbageCollector>> $lessinit$greater$default$9() {
        return TierDeletedPartitionsCoordinator$.MODULE$.$lessinit$greater$default$9();
    }

    public static Path snapshotDir(String rootPath) {
        return TierDeletedPartitionsCoordinator$.MODULE$.snapshotDir(rootPath);
    }

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    public static String SNAPSHOT_DIR() {
        return TierDeletedPartitionsCoordinator$.MODULE$.SNAPSHOT_DIR();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = this;
        synchronized (tierDeletedPartitionsCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicLong lastHeartbeatMs() {
        return this.lastHeartbeatMs;
    }

    private AtomicBoolean isInWorkLoop() {
        return this.isInWorkLoop;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private DeletedPartitionsChangeListener listener() {
        return this.listener;
    }

    private void listener_$eq(DeletedPartitionsChangeListener x$1) {
        this.listener = x$1;
    }

    private long lastDeletedPartitionCheckMs() {
        return this.lastDeletedPartitionCheckMs;
    }

    private void lastDeletedPartitionCheckMs_$eq(long x$1) {
        this.lastDeletedPartitionCheckMs = x$1;
    }

    private int numInProgress() {
        return this.numInProgress;
    }

    private void numInProgress_$eq(int x$1) {
        this.numInProgress = x$1;
    }

    public scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions() {
        return this.immigratedPartitions;
    }

    private ScheduledFuture<?> coordinatorTask() {
        return this.coordinatorTask;
    }

    private void coordinatorTask_$eq(ScheduledFuture<?> x$1) {
        this.coordinatorTask = x$1;
    }

    private Config config() {
        return this.config;
    }

    private void config_$eq(Config x$1) {
        this.config = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Config proposedConfigs = new Config(Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteCheckIntervalMs()), Predef$.MODULE$.Integer2int(newConfig.confluentConfig().tierTopicDeleteMaxInprogressPartitions()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteBackoffMs()));
        this.reconfigure(proposedConfigs);
    }

    public void startup() {
        this.replicaManager.liveLogDirs().foreach((Function1<File, Object> & Serializable)logDir -> {
            TierDeletedPartitionsCoordinator.$anonfun$startup$1(logDir);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String> & Serializable)() -> "Starting up TierDeletedPartitionCoordinator with config=" + this.config());
        this.startCoordinator(100);
    }

    public void handleImmigration(int tierTopicPartitionId) {
        TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = this;
        synchronized (tierDeletedPartitionsCoordinator) {
            Option tierObjectGarbageCollectorOpt = this.tierObjectGCSupplier.map((Function1<Function0, TierObjectGarbageCollector> & Serializable)x$4 -> (TierObjectGarbageCollector)x$4.apply());
            ImmigratedTierTopicPartition cfr_ignored_0 = (ImmigratedTierTopicPartition)this.immigratedPartitions().getOrElseUpdate(BoxesRunTime.boxToInteger(tierTopicPartitionId), (Function0<ImmigratedTierTopicPartition> & Serializable)() -> new ImmigratedTierTopicPartition(tierObjectGarbageCollectorOpt));
        }
    }

    public synchronized void handleEmigration(int tierTopicPartitionId) {
        this.immigratedPartitions().remove(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)emigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1(this, emigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void registerListener(DeletedPartitionsChangeListener listener) {
        this.listener_$eq(listener);
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Shutting down TierDeletedPartitionCoordinator.");
        this.stopCoordinator();
        this.removeMetrics$1();
    }

    private void startCoordinator(int delay) {
        if (this.coordinatorTask() != null) {
            throw new IllegalStateException("Attempt to start a duplicate coordinator");
        }
        this.coordinatorTask_$eq(this.scheduler.schedule("tier-deleted-partition-task", () -> this.doWork(), delay, Math.min(60000L, this.config().intervalMs())));
    }

    private int startCoordinator$default$1() {
        return 0;
    }

    private void stopCoordinator() {
        if (this.coordinatorTask() != null) {
            this.coordinatorTask().cancel(false);
            this.coordinatorTask_$eq(null);
            return;
        }
    }

    public void heartbeat() {
        this.lastHeartbeatMs().set(this.time.milliseconds());
    }

    public void doWork() {
        block8: {
            block7: {
                try {
                    try {
                        if (!this.isInWorkLoop().compareAndSet(false, true)) {
                            this.debug((Function0<String> & Serializable)() -> "Work loop is already running; backing off");
                            break block7;
                        }
                        this.heartbeat();
                        long now = this.time.hiResClockMs();
                        if (this.lastDeletedPartitionCheckMs() == 0L || now - this.lastDeletedPartitionCheckMs() >= this.config().intervalMs()) {
                            this.findDeletedPartitions();
                            this.runGarbageCollectorTasks();
                            this.lastDeletedPartitionCheckMs_$eq(now);
                        }
                        this.makeTransitions();
                    }
                    catch (Exception e) {
                        this.error((Function0<String> & Serializable)() -> "Caught exception in work loop", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                    }
                    break block8;
                }
                finally {
                    this.isInWorkLoop().set(false);
                }
            }
            return;
        }
    }

    private void findDeletedPartitions() {
        int maxReadSize = 10000;
        ObjectRef<ByteBuffer> allocatedBuffer = ObjectRef.create(ByteBuffer.allocate(maxReadSize));
        this.tierTopicPartitionsWithPosition().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$1(this, allocatedBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void makeTransitions() {
        this.maybeBeginMaterialization();
        this.maybeBeginDeletion();
    }

    public Tuple2<Object, ByteBuffer> collectDeletedPartitions(TopicPartition tierTopicPartition, long startOffset, ByteBuffer allocatedBuffer) {
        ByteBuffer buffer = allocatedBuffer;
        HostedPartition hostedPartition = this.replicaManager.getPartition(tierTopicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            HostedPartition.Online online = (HostedPartition.Online)hostedPartition;
            Partition partition = online.partition();
            AbstractLog log = partition.localLogOrException();
            long lastOffset = log.highWatermark();
            LongRef currentOffset = LongRef.create(startOffset);
            while (currentOffset.elem < lastOffset) {
                MemoryRecords memoryRecords;
                if (!this.immigratedPartitions().contains(BoxesRunTime.boxToInteger(tierTopicPartition.partition()))) {
                    this.debug((Function0<String> & Serializable)() -> tierTopicPartition + " no longer hosted on this broker, stopping materialization from offset " + startOffset + " to " + currentOffset$1.elem);
                    return new Tuple2<Object, ByteBuffer>(BoxesRunTime.boxToLong(currentOffset.elem), buffer);
                }
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, buffer.capacity(), FetchIsolation.HIGH_WATERMARK, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException("Unexpected tiered segment for tier topic in " + tierTopicPartition);
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                FetchDataInfo fetchDataInfo2 = fetchDataInfo;
                Records records = fetchDataInfo2.records;
                if (records instanceof MemoryRecords) {
                    MemoryRecords memoryRecords2;
                    memoryRecords = memoryRecords2 = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    buffer.clear();
                    if (buffer.capacity() < fileRecords.sizeInBytes()) {
                        buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                } else {
                    throw new IllegalArgumentException("Unexpected record type " + records);
                }
                MemoryRecords records2 = memoryRecords;
                CollectionConverters$.MODULE$.IterableHasAsScala(records2.batches()).asScala().foreach((Function1<MutableRecordBatch, Object> & Serializable)batch -> {
                    TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$2(this, tierTopicPartition, currentOffset, batch);
                    return BoxedUnit.UNIT;
                });
                lastOffset = Math.min(lastOffset, log.highWatermark());
            }
            this.debug((Function0<String> & Serializable)() -> "Processed messages in " + tierTopicPartition + " from offset " + startOffset + " to " + currentOffset$1.elem);
            return new Tuple2<Object, ByteBuffer>(BoxesRunTime.boxToLong(currentOffset.elem), buffer);
        }
        if (HostedPartition$None$.MODULE$.equals(hostedPartition) ? true : (hostedPartition instanceof HostedPartition.Offline ? true : true)) {
            return new Tuple2<Object, ByteBuffer>(BoxesRunTime.boxToLong(startOffset), buffer);
        }
        throw new MatchError(hostedPartition);
    }

    public synchronized void runGarbageCollectorTasks() {
        this.immigratedPartitions().values().foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)x$6 -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$1(this, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void maybeBeginMaterialization() {
        Iterator immigratedPartitionIt = this.immigratedPartitions().iterator();
        scala.collection.mutable.Map newDeletions = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        while (this.capacity$1() > 0 && immigratedPartitionIt.hasNext()) {
            Tuple2 tuple2 = (Tuple2)immigratedPartitionIt.next();
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition partitionState = (ImmigratedTierTopicPartition)tuple2._2();
                if (partitionState.inProgressDeletions().isEmpty()) {
                    scala.collection.mutable.Map<TopicIdPartition, Object> pendingDeletions = partitionState.pendingDeletions();
                    List toDelete = ((IterableOnceOps)pendingDeletions.take(this.capacity$1())).toList();
                    toDelete.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                        TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1(this, tierTopicPartitionId, partitionState, newDeletions, pendingDeletions, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                continue;
            }
            throw new MatchError(tuple2);
        }
        this.debug((Function0<String> & Serializable)() -> "Beginning tier partition state materialization for " + newDeletions.map((Function1<Tuple2, TopicIdPartition> & Serializable)x$7 -> (TopicIdPartition)x$7._1()));
        newDeletions.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer.register(CollectionConverters$.MODULE$.MutableMapHasAsJava(newDeletions).asJava());
    }

    public synchronized void maybeBeginDeletion() {
        this.immigratedPartitions().values().foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)immigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$1(this, immigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitLeaderAndSnapshotUploadComplete(int tierTopicPartitionId, TopicIdPartition newPartition, Option<OffsetAndEpoch> creationOffsetAndEpochOpt) {
        this.immigratedPartitions().get(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeaderAndSnapshotUploadComplete$1(this, newPartition, creationOffsetAndEpochOpt, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackPreInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long timestamp) {
        this.immigratedPartitions().get(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$1(this, deletedPartition, timestamp, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long offset) {
        this.immigratedPartitions().get(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitiatePartitionDelete$1(this, deletedPartition, offset, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackCompletePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition) {
        this.immigratedPartitions().get(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$1(this, deletedPartition, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void reconfigure(Config proposedConfig) {
        Config currentConfig;
        Config config = currentConfig = this.config();
        Config config2 = proposedConfig;
        if (config == null ? config2 != null : !((Object)config).equals(config2)) {
            this.info((Function0<String> & Serializable)() -> "Reconfiguring from " + currentConfig + " to " + proposedConfig);
            long oldIntervalMs = currentConfig.intervalMs();
            long newIntervalMs = proposedConfig.intervalMs();
            this.config_$eq(proposedConfig);
            if (oldIntervalMs != newIntervalMs) {
                this.stopCoordinator();
                this.startCoordinator(this.startCoordinator$default$1());
                return;
            }
            return;
        }
    }

    private synchronized void updateStartOffset(int tierTopicPartitionId, long newStartOffset) {
        this.immigratedPartitions().get(BoxesRunTime.boxToInteger(tierTopicPartitionId)).foreach((Function1<ImmigratedTierTopicPartition, Object> & Serializable)x$8 -> {
            x$8.lastReadOffset_$eq(new Some<Object>(BoxesRunTime.boxToLong(newStartOffset)));
            return BoxedUnit.UNIT;
        });
    }

    private synchronized Map<TopicPartition, Option<Object>> tierTopicPartitionsWithPosition() {
        return this.immigratedPartitions().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(this.tierTopicName(), tierTopicPartitionId)), immigratedPartition.lastReadOffset());
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
    }

    private void cancelInProgress(InProgressDeletion inProgressDeletion) {
        this.listener().stopPartitionDeletion(inProgressDeletion.topicIdPartition());
        inProgressDeletion.stopMaterialization();
        this.numInProgress_$eq(this.numInProgress() - 1);
    }

    public static final /* synthetic */ long $anonfun$new$3(ImmigratedTierTopicPartition x$3) {
        return x$3.pendingDeletions().size();
    }

    public static final /* synthetic */ long $anonfun$new$2(TierDeletedPartitionsCoordinator $this) {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)$this.immigratedPartitions().values().map((Function1<ImmigratedTierTopicPartition, Object> & Serializable)x$3 -> BoxesRunTime.boxToLong(TierDeletedPartitionsCoordinator.$anonfun$new$3(x$3)))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$new$4(TierDeletedPartitionsCoordinator $this) {
        return $this.time.milliseconds() - $this.lastHeartbeatMs().get();
    }

    public static final /* synthetic */ void $anonfun$startup$1(File logDir) {
        Path oldSnapshotDir = TierDeletedPartitionsCoordinator$.MODULE$.snapshotDir(logDir.getAbsolutePath());
        if (FilesWrapper.exists((Path)oldSnapshotDir, (LinkOption[])new LinkOption[0])) {
            Utils.delete((File)oldSnapshotDir.toFile());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        $this.info((Function0<String> & Serializable)() -> "Cancelling segment deletion for " + inProgressDeletion.topicIdPartition() + " on partition emigration");
        $this.cancelInProgress(inProgressDeletion);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        emigratedPartition.inProgressDeletions().values().foreach((Function1<InProgressDeletion, Object> & Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    private final void removeMetrics$1() {
        this.metricsGroup().removeMetric("TierNumInProgressPartitionDeletions");
        this.metricsGroup().removeMetric("TierNumQueuedPartitionDeletions");
        this.metricsGroup().removeMetric("HeartbeatMs");
    }

    public static final /* synthetic */ void $anonfun$findDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, ObjectRef allocatedBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option startOffsetOpt;
            TopicPartition tierTopicPartition = (TopicPartition)tuple2._1();
            Tuple2<Object, ByteBuffer> tuple22 = $this.collectDeletedPartitions(tierTopicPartition, BoxesRunTime.unboxToLong((startOffsetOpt = (Option)tuple2._2()).getOrElse(() -> 0L)), (ByteBuffer)allocatedBuffer$1.elem);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            long endOffset = tuple22._1$mcJ$sp();
            ByteBuffer buffer = tuple22._2();
            Tuple2<Long, ByteBuffer> tuple23 = new Tuple2<Long, ByteBuffer>(BoxesRunTime.boxToLong(endOffset), buffer);
            long endOffset2 = tuple23._1$mcJ$sp();
            ByteBuffer buffer2 = tuple23._2();
            $this.updateStartOffset(tierTopicPartition.partition(), endOffset2);
            allocatedBuffer$1.elem = buffer2;
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$4(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        AbstractTierMetadata abstractTierMetadata = x0$1;
        if (abstractTierMetadata instanceof TierTopicInitLeader) {
            TierTopicInitLeader tierTopicInitLeader = (TierTopicInitLeader)abstractTierMetadata;
            $this.trackInitLeaderAndSnapshotUploadComplete(tierTopicPartition$1.partition(), tierTopicInitLeader.topicIdPartition(), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(tierTopicInitLeader.partitionCreationOffsetAndEpoch())));
            return;
        }
        if (abstractTierMetadata instanceof TierMetadataSnapshotUploadComplete) {
            TierMetadataSnapshotUploadComplete tierMetadataSnapshotUploadComplete = (TierMetadataSnapshotUploadComplete)abstractTierMetadata;
            $this.trackInitLeaderAndSnapshotUploadComplete(tierTopicPartition$1.partition(), tierMetadataSnapshotUploadComplete.topicIdPartition(), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(tierMetadataSnapshotUploadComplete.partitionCreationOffsetAndEpoch())));
            return;
        }
        if (abstractTierMetadata instanceof TierPartitionDeletePreInitiate) {
            TierPartitionDeletePreInitiate tierPartitionDeletePreInitiate = (TierPartitionDeletePreInitiate)abstractTierMetadata;
            $this.trackPreInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeletePreInitiate.topicIdPartition(), record$1.timestamp());
            return;
        }
        if (abstractTierMetadata instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)abstractTierMetadata;
            $this.trackInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteInitiate.topicIdPartition(), record$1.offset());
            return;
        }
        if (abstractTierMetadata instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)abstractTierMetadata;
            $this.trackCompletePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteComplete.topicIdPartition());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$3(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record) {
        OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(AbstractTierMetadata.deserialize(record.key(), record.value(), record.timestamp()))).foreach((Function1<AbstractTierMetadata, Object> & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$4($this, tierTopicPartition$1, record, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$2(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, LongRef currentOffset$1, MutableRecordBatch batch) {
        CollectionConverters$.MODULE$.IterableHasAsScala(batch).asScala().foreach((Function1<Record, Object> & Serializable)record -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record);
            return BoxedUnit.UNIT;
        });
        currentOffset$1.elem = batch.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$2(TierDeletedPartitionsCoordinator $this, TierObjectGarbageCollector garbageCollector) {
        garbageCollector.maybePreInitiatePartitionDeletion();
        garbageCollector.maybeDeletePartitions($this.config().deleteBackoffMs());
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition x$6) {
        x$6.tierObjectGarbageCollectorOpt().foreach((Function1<TierObjectGarbageCollector, Object> & Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$2($this, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    private final int capacity$1() {
        return this.config().maxInprogressPartitions() - this.numInProgress();
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$1(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicIdPartition partitionToDelete = (TopicIdPartition)tuple2._1();
            long deleteInitiateOffset = tuple2._2$mcJ$sp();
            int x$1 = tierTopicPartitionId$1;
            TopicIdPartition x$2 = partitionToDelete;
            long x$3 = deleteInitiateOffset;
            TierTopicConsumer x$4 = $this.tierTopicConsumer;
            ReplicaManager x$5 = $this.replicaManager;
            Scheduler x$6 = $this.scheduler;
            Time x$7 = $this.time;
            scala.collection.mutable.Map<UUID, ObjectMetadata> x$8 = InProgressDeletion$.MODULE$.$lessinit$greater$default$5();
            TierPartitionStatus x$9 = InProgressDeletion$.MODULE$.$lessinit$greater$default$6();
            DeletionState x$10 = InProgressDeletion$.MODULE$.$lessinit$greater$default$7();
            InProgressDeletion inProgressDeletion = new InProgressDeletion(x$1, x$2, x$3, x$4, x$8, x$9, x$10, x$5, x$6, x$7);
            partitionState$1.inProgressDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionToDelete), inProgressDeletion));
            newDeletions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionToDelete), inProgressDeletion));
            pendingDeletions$1.remove(partitionToDelete);
            $this.numInProgress_$eq($this.numInProgress() + 1);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$4(TierDeletedPartitionsCoordinator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicIdPartition partitionId = (TopicIdPartition)tuple2._1();
            $this.tierTopicConsumer.deregister(partitionId);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        DeletionState deletionState = inProgressDeletion.deletionState();
        if (MaterializationComplete$.MODULE$.equals(deletionState)) {
            $this.info((Function0<String> & Serializable)() -> "Beginning segment deletion for " + inProgressDeletion.topicIdPartition());
            inProgressDeletion.awaitDeleteComplete();
            $this.listener().initiatePartitionDeletion(inProgressDeletion.topicIdPartition(), inProgressDeletion.allTieredObjects());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition immigratedPartition) {
        immigratedPartition.inProgressDeletions().values().foreach((Function1<InProgressDeletion, Object> & Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitLeaderAndSnapshotUploadComplete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String> & Serializable)() -> "Processing InitLeader/SnapshotUploadComplete for " + newPartition$1);
        if (creationOffsetAndEpochOpt$1.isEmpty()) {
            $this.debug((Function0<String> & Serializable)() -> "Partition [" + newPartition$1 + "] is ignored because topic creation OffsetAndEpoch is missing. It is possible that this event was generated before the cluster was upgraded to KRaft mode.");
            return;
        }
        garbageCollector.addTopicPartition(newPartition$1, (OffsetAndEpoch)creationOffsetAndEpochOpt$1.get());
    }

    public static final /* synthetic */ void $anonfun$trackInitLeaderAndSnapshotUploadComplete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1<TierObjectGarbageCollector, Object> & Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeaderAndSnapshotUploadComplete$2($this, newPartition$1, creationOffsetAndEpochOpt$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String> & Serializable)() -> "Processing PreInitiateDelete for " + deletedPartition$1);
        garbageCollector.onPartitionDeletePreInitiate(deletedPartition$1, timestamp$1);
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1<TierObjectGarbageCollector, Object> & Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$2($this, deletedPartition$1, timestamp$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, long offset$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String> & Serializable)() -> "Processing InitiateDelete for " + deletedPartition$2 + " at offset " + offset$1);
        Object object = !immigratedTierTopicPartition.inProgressDeletions().contains(deletedPartition$2) ? immigratedTierTopicPartition.pendingDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(deletedPartition$2), BoxesRunTime.boxToLong(offset$1))) : BoxedUnit.UNIT;
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1<TierObjectGarbageCollector, Object> & Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteInitiate(deletedPartition$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$3(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, InProgressDeletion inProgress) {
        $this.info((Function0<String> & Serializable)() -> "Completed deleting segments for " + deletedPartition$3);
        $this.cancelInProgress(inProgress);
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String> & Serializable)() -> "Processing CompleteDelete for " + deletedPartition$3);
        immigratedTierTopicPartition.pendingDeletions().$minus$eq(deletedPartition$3);
        immigratedTierTopicPartition.inProgressDeletions().remove(deletedPartition$3).foreach((Function1<InProgressDeletion, Object> & Serializable)inProgress -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$3, inProgress);
            return BoxedUnit.UNIT;
        });
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1<TierObjectGarbageCollector, Object> & Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteComplete(deletedPartition$3);
            return BoxedUnit.UNIT;
        });
    }

    public TierDeletedPartitionsCoordinator(Scheduler scheduler, ReplicaManager replicaManager, TierTopicConsumer tierTopicConsumer, long initialIntervalMs, int initialMaxInprogressPartitions, long initialBackoffMs, String tierNamespace, Time time, Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.tierTopicConsumer = tierTopicConsumer;
        this.time = time;
        this.tierObjectGCSupplier = tierObjectGCSupplier;
        Logging.$init$(this);
        this.lastHeartbeatMs = new AtomicLong(time.milliseconds());
        this.isInWorkLoop = new AtomicBoolean(false);
        this.tierTopicName = TierTopic.topicName(tierNamespace);
        this.lastDeletedPartitionCheckMs = 0L;
        this.numInProgress = 0;
        this.immigratedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.config = new Config(initialIntervalMs, initialMaxInprogressPartitions, initialBackoffMs);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().newGauge("TierNumInProgressPartitionDeletions", () -> BoxesRunTime.boxToInteger(this.numInProgress()));
        this.metricsGroup().newGauge("TierNumQueuedPartitionDeletions", () -> BoxesRunTime.boxToLong(TierDeletedPartitionsCoordinator.$anonfun$new$2(this)));
        this.metricsGroup().newGauge("HeartbeatMs", () -> BoxesRunTime.boxToLong(TierDeletedPartitionsCoordinator.$anonfun$new$4(this)));
    }
}

