/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import io.confluent.kafka.storage.tier.fetcher.TierFetchMetadata;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.tier.TierUnfetchedTimestampAndOffset;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import kafka.tier.fetcher.PendingOffsetForTimestampAsync;
import kafka.tier.fetcher.PendingOffsetForTimestampSync;
import kafka.tier.fetcher.TierFetcherConfig;
import kafka.tier.fetcher.TierFetcherMetrics;
import kafka.tier.fetcher.objectcache.ObjectCacheConfig;
import kafka.tier.fetcher.objectcache.PrefetchCache;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.purgatory.DelayedOperationKey;
import org.apache.kafka.server.util.KafkaScheduler;
import org.slf4j.Logger;
import scala.collection.JavaConverters;
import scala.collection.Set;

public class TierFetcher
implements BrokerReconfigurable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CancellationContext cancellationContext = CancellationContext.newContext();
    private final Logger logger;
    private final TierObjectStore tierObjectStore;
    public volatile Optional<PrefetchCache> prefetchCacheOpt;
    private final ThreadPoolExecutor executorService;
    public final TierFetcherMetrics tierFetcherMetrics;
    final FetchOffsetCache offsetCache;
    private final MemoryTracker memoryTracker;
    private final Time time;
    public boolean asyncFetchEnabled;
    public int asyncOffsetForTimestampParallelism;
    public static Set<String> reconfigurableConfigs = JavaConverters.asScalaSet(new HashSet<String>(Arrays.asList(KafkaConfig.TierFetcherMemoryPoolSizeBytesProp(), KafkaConfig.TierFetcherAsyncEnableProp(), KafkaConfig.TierFetcherAsyncOffsetForTimestampParallelismProp(), KafkaConfig.TierPrefetchCacheEnableProp(), KafkaConfig.TierPrefetchCacheEntrySizeBytesProp(), KafkaConfig.TierPrefetchCacheRangeBytesProp(), KafkaConfig.TierPrefetchCacheMaxSizeBytesProp())));

    public TierFetcher(Time time, TierFetcherConfig tierFetcherConfig, TierObjectStore tierObjectStore, KafkaScheduler scheduler, Metrics metrics, LogContext logContext) {
        this.tierObjectStore = tierObjectStore;
        this.logger = logContext.logger(TierFetcher.class);
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(tierFetcherConfig.numFetchThreads);
        this.offsetCache = new FetchOffsetCache(time, tierFetcherConfig.offsetCacheSize, tierFetcherConfig.offsetCacheExpirationMs);
        this.tierFetcherMetrics = new TierFetcherMetrics(metrics, this.executorService, this.offsetCache);
        this.memoryTracker = new MemoryTracker(time, metrics, tierFetcherConfig.memoryPoolSizeBytes);
        this.prefetchCacheOpt = tierFetcherConfig.objectCacheConfig.prefetchCacheEnabled ? Optional.of(new PrefetchCache(tierFetcherConfig.objectCacheConfig, tierObjectStore, Optional.of(this.tierFetcherMetrics))) : Optional.empty();
        this.time = time;
        this.asyncFetchEnabled = tierFetcherConfig.asyncFetchEnabled;
        this.asyncOffsetForTimestampParallelism = tierFetcherConfig.asyncOffsetForTimestampParallelism;
        scheduler.schedule("tier-fetcher-clear-fetch-offset-cache", () -> this.offsetCache.expireEntries(), tierFetcherConfig.offsetCacheExpiryPeriodMs, tierFetcherConfig.offsetCacheExpiryPeriodMs);
    }

    TierFetcher(Time time, TierObjectStore tierObjectStore, KafkaScheduler scheduler, Metrics metrics) {
        this(time, new TierFetcherConfig(), tierObjectStore, scheduler, metrics, new LogContext());
    }

    public void close() {
        this.logger.info("Closing TierFetcher");
        if (this.stopped.compareAndSet(false, true)) {
            this.cancellationContext.cancel();
            this.executorService.shutdownNow();
            this.memoryTracker.close();
            this.prefetchCacheOpt.ifPresent(PrefetchCache::close);
        }
    }

    public PendingFetch buildFetch(List<TierFetchMetadata> tierFetchMetadataList, IsolationLevel isolationLevel, Consumer<DelayedOperationKey> fetchCompletionCallback, int maxPartitionFetchBytesOverride) {
        this.tierFetcherMetrics.fetchPartitionCount().record((double)tierFetchMetadataList.size());
        if (!tierFetchMetadataList.isEmpty()) {
            TierFetchMetadata firstFetchMetadata = tierFetchMetadataList.get(0);
            List<TopicPartition> ignoredTopicPartitions = tierFetchMetadataList.subList(1, tierFetchMetadataList.size()).stream().map(TierFetchMetadata::topicPartition).collect(Collectors.toList());
            if (firstFetchMetadata == null) {
                throw new IllegalStateException("No TierFetchMetadata supplied, cannot start fetch");
            }
            if (!this.stopped.get()) {
                this.logger.debug("Fetching " + String.valueOf(firstFetchMetadata.topicPartition()) + " from tiered storage");
                long targetOffset = firstFetchMetadata.fetchStartOffset();
                int maxBytes = Math.max(firstFetchMetadata.maxBytes(), maxPartitionFetchBytesOverride);
                CancellationContext cancellationContext = this.cancellationContext.subContext();
                return new PendingFetch(cancellationContext, this.tierObjectStore, this.prefetchCacheOpt, this.offsetCache, Optional.of(this.tierFetcherMetrics), firstFetchMetadata.segmentMetadata(), fetchCompletionCallback, targetOffset, maxBytes, firstFetchMetadata.segmentSize(), isolationLevel, this.memoryTracker, ignoredTopicPartitions, this.time, this.executorService::remove);
            }
            throw new IllegalStateException("TierFetcher is shutting down, request was not scheduled");
        }
        throw new IllegalStateException("No TierFetchMetadata supplied to TierFetcher fetch request");
    }

    public PendingFetch fetch(List<TierFetchMetadata> tierFetchMetadataList, IsolationLevel isolationLevel, Consumer<DelayedOperationKey> fetchCompletionCallback, int maxPartitionFetchBytesOverride) {
        PendingFetch fetch = this.buildFetch(tierFetchMetadataList, isolationLevel, fetchCompletionCallback, maxPartitionFetchBytesOverride);
        this.executorService.execute(fetch);
        return fetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingOffsetForTimestamp fetchOffsetForTimestamp(Map<TopicPartition, TierUnfetchedTimestampAndOffset> tierTimestampAndOffsets, Consumer<DelayedOperationKey> fetchCompletionCallback) {
        int parallelism;
        boolean isAsyncEnabled;
        CancellationContext cancellationContext = this.cancellationContext.subContext();
        TierFetcher tierFetcher = this;
        synchronized (tierFetcher) {
            isAsyncEnabled = this.asyncFetchEnabled;
            parallelism = this.asyncOffsetForTimestampParallelism;
        }
        PendingOffsetForTimestamp pending = isAsyncEnabled ? new PendingOffsetForTimestampAsync(cancellationContext, this.tierObjectStore, tierTimestampAndOffsets, Optional.of(this.tierFetcherMetrics), fetchCompletionCallback, this.time, parallelism, this.executorService::remove) : new PendingOffsetForTimestampSync(cancellationContext, this.tierObjectStore, tierTimestampAndOffsets, Optional.of(this.tierFetcherMetrics), fetchCompletionCallback, this.time, this.executorService::remove);
        this.executorService.execute(pending);
        return pending;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public ThreadPoolExecutor executorService() {
        return this.executorService;
    }

    public CancellationContext cancellationContext() {
        return this.cancellationContext;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return reconfigurableConfigs;
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        long newMemoryBytesValue = newConfig.confluentConfig().tierFetcherMemoryPoolSizeBytes();
        if (newMemoryBytesValue < 0L) {
            throw new ConfigException(String.format("%s should not be less than 0", KafkaConfig.TierFetcherMemoryPoolSizeBytesProp()));
        }
        boolean asyncFetchEnabled = newConfig.confluentConfig().tierFetcherAsyncEnable();
        int asyncOffsetForTimestampParallelism = newConfig.confluentConfig().tierFetcherAsyncOffsetForTimestampParallelism();
        if (asyncFetchEnabled && asyncOffsetForTimestampParallelism <= 0) {
            throw new ConfigException(String.format("%s should be at least 1 when %s is enabled", KafkaConfig.TierFetcherAsyncOffsetForTimestampParallelismProp(), KafkaConfig.TierFetcherAsyncEnableProp()));
        }
        TierFetcher.validateObjectCacheConfig(new ObjectCacheConfig(newConfig));
    }

    public static void validateObjectCacheConfig(ObjectCacheConfig config) {
        if (!config.prefetchCacheEnabled) {
            return;
        }
        if (config.prefetchCacheEntrySizeBytes > config.prefetchCacheRangeBytes || config.prefetchCacheRangeBytes > config.prefetchCacheMaxSizeBytes) {
            throw new ConfigException(String.format("Invalid prefetch cache configuration: %s must be less than or equal to %s, and %s must be less than or equal to %s", KafkaConfig.TierPrefetchCacheEntrySizeBytesProp(), KafkaConfig.TierPrefetchCacheRangeBytesProp(), KafkaConfig.TierPrefetchCacheRangeBytesProp(), KafkaConfig.TierPrefetchCacheMaxSizeBytesProp()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        TierFetcherConfig newTierFetcherConfig = new TierFetcherConfig(newConfig);
        this.memoryTracker.setPoolSize(newTierFetcherConfig.memoryPoolSizeBytes);
        TierFetcher tierFetcher = this;
        synchronized (tierFetcher) {
            this.asyncFetchEnabled = newTierFetcherConfig.asyncFetchEnabled;
            this.asyncOffsetForTimestampParallelism = newTierFetcherConfig.asyncOffsetForTimestampParallelism;
        }
        this.reconfigureObjectCache(new ObjectCacheConfig(oldConfig), newTierFetcherConfig.objectCacheConfig);
    }

    public void reconfigureObjectCache(ObjectCacheConfig oldConfig, ObjectCacheConfig newConfig) {
        if (oldConfig.prefetchCacheEnabled != newConfig.prefetchCacheEnabled || oldConfig.prefetchCacheEntrySizeBytes != newConfig.prefetchCacheEntrySizeBytes || oldConfig.prefetchCacheRangeBytes != newConfig.prefetchCacheRangeBytes || oldConfig.prefetchCacheMaxSizeBytes != newConfig.prefetchCacheMaxSizeBytes) {
            this.logger.info("Reconfiguring object cache with config: {}", (Object)newConfig);
            this.prefetchCacheOpt.ifPresent(PrefetchCache::close);
            this.prefetchCacheOpt = newConfig.prefetchCacheEnabled ? Optional.of(new PrefetchCache(newConfig, this.tierObjectStore, Optional.of(this.tierFetcherMetrics))) : Optional.empty();
        }
    }
}

