/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.store.objects.metadata.TierStateRestoreSnapshotMetadata;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierStateFetcher {
    private static final Logger log = LoggerFactory.getLogger(TierStateFetcher.class);
    private final TierObjectStore tierObjectStore;
    private final ExecutorService executorService;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    public static final Integer ESTIMATED_BUFFER_SIZE = 5192;

    public TierStateFetcher(Integer numThreads, TierObjectStore tierObjectStore) {
        this.tierObjectStore = tierObjectStore;
        this.executorService = Executors.newFixedThreadPool(numThreads);
    }

    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            this.executorService.shutdownNow();
        }
    }

    public CompletableFuture<List<EpochEntry>> fetchLeaderEpochStateAsync(ObjectMetadata metadata) {
        CompletableFuture<List<EpochEntry>> entries = new CompletableFuture<List<EpochEntry>>();
        this.executorService.execute(() -> {
            try (TierObjectStoreResponse response = this.tierObjectStore.getObjectStoreFragment(metadata, FragmentType.EPOCH_STATE);
                 InputStreamReader inputStreamReader = new InputStreamReader(response.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                entries.complete(LeaderEpochCheckpointFile.read(metadata.toString(), bufferedReader));
            }
            catch (Throwable e) {
                entries.completeExceptionally(e);
            }
        });
        return entries;
    }

    public CompletableFuture<ByteBuffer> fetchProducerStateSnapshotAsync(ObjectMetadata metadata) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.fetchSnapshot(metadata, FragmentType.PRODUCER_STATE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.executorService);
    }

    private ByteBuffer fetchSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType) {
        return this.tierObjectStore.getSnapshot(metadata, fragmentType, ESTIMATED_BUFFER_SIZE);
    }

    public ByteBuffer fetchRecoverSnapshot(TierStateRestoreSnapshotMetadata metadata) {
        return this.fetchSnapshot(metadata, FragmentType.TIER_STATE_SNAPSHOT);
    }

    public ByteBuffer fetchTierPartitionStateSnapshot(TierPartitionStateSnapshotMetadata metadata) {
        return this.fetchSnapshot(metadata, FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
    }
}

