/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStoreConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import scala.jdk.javaapi.OptionConverters;

public class S3TierObjectStoreConfig
extends TierObjectStoreConfig {
    public String s3Bucket;
    public String s3Region;
    public String s3Prefix;
    public Optional<String> s3CredFilePath;
    public Optional<String> s3EndpointOverride;
    public Optional<String> s3SignerOverride;
    public String s3SseAlgorithm;
    public String s3SseCustomerEncryptionKey;
    public Integer s3AutoAbortThresholdBytes;
    public Optional<String> assumeRoleArn;
    public Boolean s3ForcePathStyleAccess;
    public Boolean s3V2Enabled;
    public String s3UserAgentPrefix;
    public String s3SslProtocol;
    public List<String> s3SslEnabledProtocols;
    public Optional<String> s3SslTrustStoreLocation;
    public Optional<Password> s3SslTrustStorePassword;
    public Optional<String> s3SslTrustStoreType;
    public Optional<String> s3SslKeyStoreLocation;
    public Optional<Password> s3SslKeyStorePassword;
    public Optional<String> s3SslKeyStoreType;
    public Optional<Password> s3SslKeyPassword;
    public Optional<String> s3SslProvider;
    public Optional<String> s3SecurityProviders;
    public Optional<String> s3StorageClass;
    public boolean s3Ipv6Enabled;
    public boolean tenantAwareEncryptionKeyManagerEnable;
    public Duration tenantAwareEncryptionKeyManagerKeyRotationIntervalMs;
    public int tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize;
    public long tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec;
    public boolean tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable;

    public S3TierObjectStoreConfig(Optional<String> clusterIdOpt, KafkaConfig config) {
        super(clusterIdOpt, config);
        this.validateConfig(config);
        this.s3Bucket = config.confluentConfig().tierS3Bucket();
        this.s3Region = config.confluentConfig().tierS3Region();
        this.s3Prefix = config.confluentConfig().tierS3Prefix();
        this.s3V2Enabled = config.confluentConfig().tierS3V2Enabled();
        this.s3CredFilePath = OptionConverters.toJava(config.confluentConfig().tierS3CredFilePath());
        this.s3EndpointOverride = OptionConverters.toJava(config.confluentConfig().tierS3EndpointOverride());
        this.s3SignerOverride = OptionConverters.toJava(config.confluentConfig().tierS3SignerOverride());
        if (!config.confluentConfig().tierS3SseAlgorithm().equals(KafkaConfig.TIER_S3_SSE_ALGORITHM_NONE())) {
            this.s3SseAlgorithm = config.confluentConfig().tierS3SseAlgorithm();
        }
        this.s3SseCustomerEncryptionKey = config.confluentConfig().s3SseCustomerEncryptionKey();
        this.s3AutoAbortThresholdBytes = config.confluentConfig().tierS3AutoAbortThresholdBytes();
        this.assumeRoleArn = OptionConverters.toJava(config.confluentConfig().tierS3AssumeRoleArn());
        this.s3ForcePathStyleAccess = config.confluentConfig().tierS3ForcePathStyleAccess();
        this.s3UserAgentPrefix = config.confluentConfig().tierS3UserAgentPrefix();
        this.s3SslProtocol = config.confluentConfig().tierS3SslProtocol();
        this.s3SslEnabledProtocols = config.confluentConfig().tierS3SslEnabledProtocols();
        this.s3SslTrustStoreLocation = OptionConverters.toJava(config.confluentConfig().tierS3SslTrustStoreLocation());
        this.s3SslTrustStorePassword = OptionConverters.toJava(config.confluentConfig().tierS3SslTrustStorePassword());
        this.s3SslTrustStoreType = OptionConverters.toJava(config.confluentConfig().tierS3SslTrustStoreType());
        this.s3SslKeyStoreLocation = OptionConverters.toJava(config.confluentConfig().tierS3SslKeyStoreLocation());
        this.s3SslKeyStorePassword = OptionConverters.toJava(config.confluentConfig().tierS3SslKeyStorePassword());
        this.s3SslKeyStoreType = OptionConverters.toJava(config.confluentConfig().tierS3SslKeyStoreType());
        this.s3SslKeyPassword = OptionConverters.toJava(config.confluentConfig().tierS3SslKeyPassword());
        this.s3SslProvider = OptionConverters.toJava(config.confluentConfig().tierS3SslProvider());
        this.s3SecurityProviders = OptionConverters.toJava(config.confluentConfig().tierS3SecurityProviders());
        this.s3StorageClass = OptionConverters.toJava(config.confluentConfig().tierS3StorageClass());
        this.s3Ipv6Enabled = config.confluentConfig().tierS3Ipv6Enabled();
        this.tenantAwareEncryptionKeyManagerEnable = config.confluentConfig().tenantAwareEncryptionKeyManagerEnable();
        this.tenantAwareEncryptionKeyManagerKeyRotationIntervalMs = Duration.ofMillis(config.confluentConfig().tenantAwareEncryptionKeyManagerKeyRotationIntervalMs());
        this.tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize = config.confluentConfig().tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize();
        this.tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec = config.confluentConfig().tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec();
        this.tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable = config.confluentConfig().tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable();
    }

    protected S3TierObjectStoreConfig(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt, String bucket, String region, String credFilePath, String endpointOverride, String signerOverride, String sseAlgorithm, String s3SseCustomerEncryptionKey, Integer s3AutoAbortThresholdBytes, String s3Prefix, String assumeRoleArn, Boolean s3ForcePathStyleAccess, String s3UserAgentPrefix, String sslProtocol, String sslEnabledProtocols, String sslTrustStoreLocation, Password sslTrustStorePassword, String sslTrustStoreType, String sslKeyStoreLocation, Password sslKeyStorePassword, String sslKeyStoreType, Password sslKeyPassword, String sslProvider, String securityProviders, String storageClass, boolean ipv6Enabled, boolean tenantAwareEncryptionKeyManagerEnable, Duration tenantAwareEncryptionKeyManagerKeyRotationIntervalMs, Integer tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize, long tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec, boolean tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable) {
        super(clusterIdOpt, brokerIdOpt);
        this.s3Bucket = bucket;
        this.s3Region = region;
        this.s3CredFilePath = Optional.ofNullable(credFilePath);
        this.s3EndpointOverride = Optional.ofNullable(endpointOverride);
        this.s3SignerOverride = Optional.ofNullable(signerOverride);
        this.s3SseAlgorithm = sseAlgorithm;
        this.s3SseCustomerEncryptionKey = s3SseCustomerEncryptionKey;
        this.s3AutoAbortThresholdBytes = s3AutoAbortThresholdBytes;
        this.s3Prefix = s3Prefix;
        this.assumeRoleArn = Optional.ofNullable(assumeRoleArn);
        this.s3ForcePathStyleAccess = s3ForcePathStyleAccess;
        this.s3UserAgentPrefix = s3UserAgentPrefix;
        this.s3SslProtocol = sslProtocol;
        this.s3SslEnabledProtocols = (List)ConfigDef.parseType((String)KafkaConfig.TierS3SslEnabledProtocolsProp(), (Object)sslEnabledProtocols, (ConfigDef.Type)ConfigDef.Type.LIST);
        this.s3SslTrustStoreLocation = Optional.ofNullable(sslTrustStoreLocation);
        this.s3SslTrustStorePassword = Optional.ofNullable(sslTrustStorePassword);
        this.s3SslTrustStoreType = Optional.ofNullable(sslTrustStoreType);
        this.s3SslKeyStoreLocation = Optional.ofNullable(sslKeyStoreLocation);
        this.s3SslKeyStorePassword = Optional.ofNullable(sslKeyStorePassword);
        this.s3SslKeyStoreType = Optional.ofNullable(sslKeyStoreType);
        this.s3SslKeyPassword = Optional.ofNullable(sslKeyPassword);
        this.s3SslProvider = Optional.ofNullable(sslProvider);
        this.s3SecurityProviders = Optional.ofNullable(securityProviders);
        this.s3StorageClass = Optional.ofNullable(storageClass);
        this.s3Ipv6Enabled = ipv6Enabled;
        this.tenantAwareEncryptionKeyManagerEnable = tenantAwareEncryptionKeyManagerEnable;
        this.tenantAwareEncryptionKeyManagerKeyRotationIntervalMs = tenantAwareEncryptionKeyManagerKeyRotationIntervalMs;
        this.tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize = tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize;
        this.tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec = tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec;
        this.tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable = tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable;
        this.s3V2Enabled = false;
    }

    public static S3TierObjectStoreConfig createWithEmptyClusterIdBrokerId(String bucket, String region, String credFilePath, String endpointOverride, String signerOverride, String sseAlgorithm, String s3SseCustomerEncryptionKey, Integer s3AutoAbortThresholdBytes, String s3Prefix, String assumeRoleArn, Boolean s3ForcePathStyleAccess, String s3UserAgentPrefix, String sslProtocol, String sslEnabledProtocols, String sslTrustStoreLocation, Password sslTrustStorePassword, String sslTrustStoreType, String sslKeyStoreLocation, Password sslKeyStorePassword, String sslKeyStoreType, Password sslKeyPassword, String sslProvider, String securityProviders, String storageClass, boolean ipv6Enabled, boolean tenantAwareEncryptionKeyManagerEnable, Duration tenantAwareEncryptionKeyManagerKeyRotationIntervalMs, Integer tenantAwareEncyrptionKeyManagerTenantKeyCacheSize, long tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec, boolean tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable) {
        return new S3TierObjectStoreConfig(Optional.empty(), Optional.empty(), bucket, region, credFilePath, endpointOverride, signerOverride, sseAlgorithm, s3SseCustomerEncryptionKey, s3AutoAbortThresholdBytes, s3Prefix, assumeRoleArn, s3ForcePathStyleAccess, s3UserAgentPrefix, sslProtocol, sslEnabledProtocols, sslTrustStoreLocation, sslTrustStorePassword, sslTrustStoreType, sslKeyStoreLocation, sslKeyStorePassword, sslKeyStoreType, sslKeyPassword, sslProvider, securityProviders, storageClass, ipv6Enabled, tenantAwareEncryptionKeyManagerEnable, tenantAwareEncryptionKeyManagerKeyRotationIntervalMs, tenantAwareEncyrptionKeyManagerTenantKeyCacheSize, tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec, tenantAwareEncryptionKeyManagerProactiveKeyGenerationEnable);
    }

    private void validateConfig(KafkaConfig config) {
        if (config.confluentConfig().tierS3Region() == null && config.confluentConfig().tierS3EndpointOverride().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierS3RegionProp() + " or " + KafkaConfig.TierS3EndpointOverrideProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to S3.");
        }
        if (config.confluentConfig().tierS3Bucket() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierS3BucketProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to S3.");
        }
        if (config.confluentConfig().tierS3EndpointOverride().isDefined() && config.confluentConfig().tierS3Region() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierS3RegionProp() + " must be set if " + KafkaConfig.TierS3EndpointOverrideProp() + " is set.");
        }
        if (config.confluentConfig().tierS3SslTrustStoreLocation().isDefined() && config.confluentConfig().tierS3SslTrustStoreType().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierS3SslTrustStoreTypeProp() + " must be set if " + KafkaConfig.TierS3SslTrustStoreLocationProp() + " is set.");
        }
        if (config.confluentConfig().tierS3SslKeyStoreLocation().isDefined() && config.confluentConfig().tierS3SslKeyStoreType().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierS3SslKeyStoreTypeProp() + " must be set if " + KafkaConfig.TierS3SslKeyStoreLocationProp() + " is set.");
        }
    }

    public boolean usesKms() {
        return this.s3SseCustomerEncryptionKey != null && this.s3SseAlgorithm.equals("aws:kms");
    }
}

