/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Optional;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import org.slf4j.Logger;

public class TierObjectStoreByokUtils {
    private static <T> DataEncryptionKeyHolder maybeRefillCache(String key, ObjectMetadata objectMetadata, Optional<T> objectSpecificMetadataOpt, TenantAwareEncryptionKeyManager encryptionKeyManager, EncryptionKeyCacheRefiller<T> encryptionKeyCacheRefiller, Logger log) {
        KeySha keySha;
        String logicalClusterId = encryptionKeyManager.getLogicalClusterIdOrThrow(objectMetadata.topicIdPartition());
        DataEncryptionKeyHolder keyInfo = encryptionKeyManager.key(logicalClusterId, keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray()));
        if (keyInfo == null) {
            log.info("[{}] TenantAwareEncryptionKeyManager cache miss while downloading object at key {} with {}, fetching object metadata for cache hydration", new Object[]{logicalClusterId, key, keySha});
            ByteBuffer encryptedDekBytes = encryptionKeyCacheRefiller.get(logicalClusterId, objectMetadata.topicIdPartition(), objectMetadata.objectId(), objectSpecificMetadataOpt);
            if (encryptedDekBytes == null) {
                throw new TierObjectStoreFatalException(String.format("[%s] Could not obtain metadata to refill cache for KeySha %s", logicalClusterId, keySha));
            }
            EncryptedDataKey encryptedDataKey = new EncryptedDataKey(encryptedDekBytes.array());
            HashMap<String, String> metadata = encryptionKeyManager.keyToObjectMetadata(keySha, encryptedDataKey, Optional.empty());
            keyInfo = encryptionKeyManager.registerKeyFromObjectMetadata(logicalClusterId, metadata);
            if (!keyInfo.keySha.equals(keySha)) {
                throw new TierObjectStoreFatalException(String.format("[%s] KeySha of key material restored from object metadata %s does not match KeySha provided via OpaqueData %s", logicalClusterId, keyInfo.keySha, keySha));
            }
        }
        return encryptionKeyManager.key(logicalClusterId, keySha);
    }

    static boolean shouldUploadEncrypted(ObjectMetadata objectMetadata, String key, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt) {
        boolean isNonEmptyOpaqueData;
        OpaqueData opaqueData = objectMetadata.opaqueData();
        boolean bl = isNonEmptyOpaqueData = opaqueData != null && !opaqueData.isEmpty();
        if (isNonEmptyOpaqueData && encryptionKeyManagerOpt.isEmpty()) {
            throw new TierObjectStoreFatalException(String.format("Attempted to upload a segment with non-empty OpaqueData, but encryption is not configured. key=%s, objectMetadata=%s", key, objectMetadata));
        }
        return isNonEmptyOpaqueData;
    }

    static <T> CleartextDataKey maybeGetEncryptionKeyForObject(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata, Optional<T> objectSpecificMetadataOpt, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt, Optional<EncryptionKeyCacheRefiller<T>> encryptionKeyCacheRefillerOpt, Logger log) {
        if (TierObjectStore.isEncryptedObject(objectMetadata, objectType)) {
            if (encryptionKeyManagerOpt.isEmpty()) {
                throw new TierObjectStoreFatalException("A TenantAwareEncryptionKeyManager instance is not configured, while OpaqueData is non-empty for object at path " + key);
            }
            if (encryptionKeyCacheRefillerOpt.isEmpty()) {
                throw new TierObjectStoreFatalException("EncryptionKeyCacheRefiller is not configured while BYOK is enabled.");
            }
            if (!(objectMetadata instanceof ObjectMetadata)) {
                throw new IllegalStateException(String.format("For ObjectType %s expected an instance of ObjectMetadata to be supplied, but received: %s", new Object[]{ObjectType.SEGMENT, objectMetadata.getClass()}));
            }
            DataEncryptionKeyHolder keyContext = TierObjectStoreByokUtils.maybeRefillCache(key, (ObjectMetadata)objectMetadata, objectSpecificMetadataOpt, encryptionKeyManagerOpt.get(), encryptionKeyCacheRefillerOpt.get(), log);
            return keyContext.cleartextDataKey;
        }
        return null;
    }

    static DataEncryptionKeyHolder generateEncryptionKeyForObject(TopicIdPartition topicIdPartition, KeySha keySha, TenantAwareEncryptionKeyManager encryptionKeyManager) {
        String logicalClusterId = encryptionKeyManager.getLogicalClusterIdOrThrow(topicIdPartition);
        DataEncryptionKeyHolder key = encryptionKeyManager.key(logicalClusterId, keySha);
        if (key == null) {
            throw new TierObjectStoreFatalException(String.format("No valid DataEncryptionKeyHolder for KeySha '%s'", keySha));
        }
        return key;
    }

    static TierObjectStore.ByokKeyHolder getByokKeyHolderForTopicIdPartition(TopicIdPartition topicIdPartition, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt, Logger log) {
        String logicalClusterId;
        if (encryptionKeyManagerOpt.isPresent() && (logicalClusterId = encryptionKeyManagerOpt.get().maybeGetLogicalClusterId(topicIdPartition)) != null) {
            log.debug("[{}] Logical cluster ID found for partition {}", (Object)logicalClusterId, (Object)topicIdPartition);
            return encryptionKeyManagerOpt.get().getActiveKey(logicalClusterId);
        }
        return TierObjectStore.ByokKeyHolder.defaultByokKeyHolder();
    }
}

