/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.aead.KmsAeadKeyManager;
import com.google.crypto.tink.integration.gcpkms.GcpKmsClient;
import com.google.crypto.tink.proto.Keyset;
import io.confluent.kafka.multitenant.ByokMetadata;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.GcsSingleTenantMetadata;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import kafka.tier.store.encryption.Util;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsDedicatedEncryptionManager
extends TenantAwareEncryptionKeyManager {
    private static final String LKC_DEFAULT = "lkc-dedicated";
    private static final Logger log = LoggerFactory.getLogger(GcsDedicatedEncryptionManager.class);
    private final String bucket;
    private final Storage storage;
    private final String gcsPrefix;
    private final Aead remoteKek;

    public GcsDedicatedEncryptionManager(String bucket, Storage storage, GcsTierObjectStoreConfig config, KafkaScheduler kafkaScheduler, Time time, Metrics metrics) {
        super(new GcsSingleTenantMetadata("gcsDedicatedKeyId"), config.encryptionKeyManagerKeyRotationInterval, Integer.MAX_VALUE, Long.MAX_VALUE, time, metrics, kafkaScheduler, false);
        this.bucket = bucket;
        this.storage = storage;
        this.gcsPrefix = config.gcsPrefix;
        try {
            String keyId = GcsDedicatedEncryptionManager.getUri(config.gcsSseCustomerEncryptionKey);
            GcpKmsClient.register(Optional.of(keyId), config.gcsCredFilePath);
            AeadConfig.register();
            KeysetHandle keysetHandle = KeysetHandle.generateNew(KmsAeadKeyManager.createKeyTemplate(keyId));
            this.remoteKek = keysetHandle.getPrimitive(Aead.class);
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("Could not construct master key AEAD", e);
        }
    }

    GcsDedicatedEncryptionManager(Aead remoteKek, String bucket, Storage storage, GcsTierObjectStoreConfig config, KafkaScheduler kafkaScheduler, Time time, Metrics metrics) {
        super(new GcsSingleTenantMetadata(GcsDedicatedEncryptionManager.getUri(config.gcsSseCustomerEncryptionKey)), config.encryptionKeyManagerKeyRotationInterval, Integer.MAX_VALUE, Long.MAX_VALUE, time, metrics, kafkaScheduler, false);
        this.bucket = bucket;
        this.storage = storage;
        this.gcsPrefix = config.gcsPrefix;
        this.remoteKek = remoteKek;
    }

    private static String getUri(String uri) {
        String prefix = "gcp-kms://";
        if (!((String)uri).startsWith(prefix)) {
            uri = prefix + (String)uri;
        }
        return uri;
    }

    @Override
    public String maybeGetLogicalClusterId(TopicIdPartition partitionUnused) {
        return LKC_DEFAULT;
    }

    @Override
    public HashMap<String, String> keyToObjectMetadata(KeySha keySha, EncryptedDataKey encryptedDataKey, Optional<Instant> keyCreationTimeOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("io.confluent/key-sha-256", keySha.base64Encoded());
        keyCreationTimeOpt.ifPresent(instant -> metadata.put("io.confluent/key-creation-time", Long.toString(instant.toEpochMilli())));
        metadata.put("io.confluent/base64-encrypted-data-key", encryptedDataKey.base64Encoded());
        return metadata;
    }

    @Override
    public TierObjectStore.ByokKeyHolder getActiveKey(String logicalClusterId) {
        TierObjectStore.ByokKeyHolder holder = super.getActiveKey(logicalClusterId);
        return new TierObjectStore.ByokKeyHolder(holder.opaqueData, null);
    }

    @Override
    protected Map<String, String> fetchWellKnownPathMetadata(String logicalClusterId) {
        String path = GcsDedicatedEncryptionManager.getGcsDedicatedLastActiveKeyPath(this.gcsPrefix);
        log.info("[{}] Downloading previously generated key from path {}", (Object)logicalClusterId, (Object)path);
        BlobId blobId = BlobId.of(this.bucket, path);
        Blob blob = this.storage.get(blobId, Storage.BlobGetOption.fields(Storage.BlobField.METADATA));
        if (blob != null) {
            return blob.getMetadata();
        }
        return new HashMap<String, String>();
    }

    @Override
    protected void writeWellKnownPathMetadata(String logicalClusterId, Map<String, String> metadata) {
        String path = GcsDedicatedEncryptionManager.getGcsDedicatedLastActiveKeyPath(this.gcsPrefix);
        log.info("[{}] Uploading newly generated key to path {}", (Object)logicalClusterId, (Object)path);
        BlobId blobId = BlobId.of(this.bucket, path);
        BlobInfo blobInfo = BlobInfo.newBuilder(blobId).setMetadata(metadata).build();
        this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    protected byte[] getEncodedDataKeyBytes(String logicalClusterId) {
        return new byte[0];
    }

    private static String getGcsDedicatedLastActiveKeyPath(String gcsPrefix) {
        return gcsPrefix + DataTypePathPrefix.LAST_ACTIVE_ENCRYPTION_KEY.prefix() + "last-active-key";
    }

    @Override
    protected CleartextDataKey decryptKey(String logicalClusterId, EncryptedDataKey encryptedDataKey, ByokMetadata byokMetadataUnused) {
        JsonKeysetReader reader;
        ByteBuffer bb = ByteBuffer.wrap(encryptedDataKey.keyMaterial());
        ByteBufferInputStream in = new ByteBufferInputStream(bb);
        try {
            reader = JsonKeysetReader.withInputStream((InputStream)in);
        }
        catch (IOException e) {
            throw new TierObjectStoreRetriableException(String.format("[%s] Failed to decrypt data encryption key from object metadata", logicalClusterId), e);
        }
        long decryptStartMs = this.time.hiResClockMs();
        KeysetHandle keyset = null;
        try {
            keyset = KeysetHandle.read(reader, this.remoteKek);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new TierObjectStoreRetriableException(String.format("[%s] Failed to decrypt data encryption key from object metadata", logicalClusterId), e);
        }
        if (this.metrics != null) {
            this.metrics.recordDecryptCall(this.time.hiResClockMs() - decryptStartMs);
        }
        Keyset cleartext = CleartextKeysetHandle.getKeyset(keyset);
        return new CleartextDataKey(Util.extractRawAes256GCMKey(cleartext));
    }

    @Override
    protected DataEncryptionKeyHolder encryptKey(String logicalClusterId, Optional<CleartextDataKey> dataKeyOpt, ByokMetadata byokMetadataUnused) {
        KeysetHandle dekKeysetHandle;
        if (dataKeyOpt.isPresent()) {
            throw new UnsupportedOperationException("Cleartext data key should not be supplied for GcsDedicatedEncryptionManager encryption.");
        }
        try {
            dekKeysetHandle = KeysetHandle.generateNew(KeyTemplates.get(this.getDataEncryptionKeyAlgorithm()));
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException(String.format("[%s] Exception trying to encrypt key using master key", logicalClusterId), e);
        }
        ByteBufferOutputStream out = new ByteBufferOutputStream(256);
        try {
            KeysetWriter writer = JsonKeysetWriter.withOutputStream((OutputStream)out);
            long encryptStartMs = this.time.hiResClockMs();
            dekKeysetHandle.write(writer, this.remoteKek);
            if (this.metrics != null) {
                this.metrics.recordEncryptCall(this.time.hiResClockMs() - encryptStartMs);
            }
        }
        catch (Exception e) {
            throw new TierObjectStoreRetriableException(String.format("[%s] Exception trying to encrypt key using master key", logicalClusterId), e);
        }
        ByteBuffer edekBuf = out.buffer();
        edekBuf.flip();
        byte[] encryptedDataKeyArr = new byte[edekBuf.remaining()];
        edekBuf.get(encryptedDataKeyArr);
        EncryptedDataKey encryptedDataKey = new EncryptedDataKey(encryptedDataKeyArr);
        Keyset cleartext = CleartextKeysetHandle.getKeyset(dekKeysetHandle);
        CleartextDataKey cleartextDataKey = new CleartextDataKey(Util.extractRawAes256GCMKey(cleartext));
        return new DataEncryptionKeyHolder(encryptedDataKey, cleartextDataKey, Optional.of(Instant.ofEpochMilli(this.time.milliseconds())));
    }

    @Override
    protected String getDataEncryptionKeyAlgorithm() {
        return "AES256_GCM_RAW";
    }

    @Override
    protected int getDataEncryptionKeySizeBytes() {
        return -1;
    }

    @Override
    public String getKeyManagementClientEncryptionAlgorithm() {
        return null;
    }
}

