/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import io.confluent.kafka.multitenant.ByokMetadata;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import kafka.tier.store.encryption.TenantKeyCache;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.Defaults;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;

public class MockTenantAwareEncryptionKeyManager
extends TenantAwareEncryptionKeyManager {
    Map<String, Map<String, String>> wellKnownMetadata = new HashMap<String, Map<String, String>>();

    public MockTenantAwareEncryptionKeyManager(MultiTenantMetadata multiTenantMetadata, Duration maxKeyAge, int maxTenantKeyCacheSize, long tenantKeyCacheEvictionTimeSec, Time time, Metrics metrics, KafkaScheduler kafkaScheduler) {
        super(multiTenantMetadata, maxKeyAge, maxTenantKeyCacheSize, tenantKeyCacheEvictionTimeSec, time, metrics, kafkaScheduler, true);
    }

    public MockTenantAwareEncryptionKeyManager(MultiTenantMetadata multiTenantMetadata, KafkaScheduler scheduler, Time time, Metrics metrics) {
        this(multiTenantMetadata, Duration.ofMillis(Defaults.TENANT_AWARE_ENCRYPTION_KEY_MANAGER_KEY_ROTATION_INTERVAL_MS), 100, Defaults.TENANT_AWARE_ENCRYPTION_KEY_MANAGER_TENANT_KEY_CACHE_EVICTION_TIME_SEC, time, metrics, scheduler);
    }

    @Override
    protected Map<String, String> fetchWellKnownPathMetadata(String logicalClusterId) {
        return this.wellKnownMetadata.get(logicalClusterId);
    }

    @Override
    protected void writeWellKnownPathMetadata(String logicalClusterId, Map<String, String> metadata) {
        this.wellKnownMetadata.put(logicalClusterId, metadata);
    }

    @Override
    protected CleartextDataKey decryptKey(String logicalClusterId, EncryptedDataKey encryptedDataKey, ByokMetadata byokMetadata) {
        byte[] rawKeyMaterial = Base64.getDecoder().decode(encryptedDataKey.keyMaterial());
        return new CleartextDataKey(rawKeyMaterial);
    }

    @Override
    protected DataEncryptionKeyHolder encryptKey(String logicalClusterId, Optional<CleartextDataKey> dataKey, ByokMetadata byokMetadata) {
        EncryptedDataKey encryptedDataKey = new EncryptedDataKey(Base64.getEncoder().encode(dataKey.get().rawKeyMaterial()));
        Instant keyCreationTime = Instant.ofEpochMilli(this.getTime().milliseconds());
        return new DataEncryptionKeyHolder(encryptedDataKey, dataKey.get(), Optional.of(keyCreationTime));
    }

    @Override
    protected String getDataEncryptionKeyAlgorithm() {
        return "AES";
    }

    @Override
    protected int getDataEncryptionKeySizeBytes() {
        return 256;
    }

    @Override
    public String getKeyManagementClientEncryptionAlgorithm() {
        return "AES";
    }

    public int tenantKeyCacheSize(String tenant) {
        TenantKeyCache cache = this.tenantKeyCache(tenant);
        if (cache == null) {
            return 0;
        }
        return cache.size();
    }

    public KeySha activeKeySha(String tenant) {
        TenantKeyCache cache = this.tenantKeyCache(tenant);
        if (cache == null) {
            return null;
        }
        return cache.activeKeySha();
    }
}

