/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

class TenantAwareEncryptionKeyManagerMetrics {
    private static final String METRIC_GROUP_NAME = "EncryptionKeyManager";
    private static final String NUMBER_OF_BYOK_TENANTS_PREFIX = "NumberOfByokTenants";
    private static final String OLDEST_ACTIVE_KEY_AGE_PREFIX = "OldestActiveKeyAge";
    private static final String LATEST_ACTIVE_KEY_AGE_PREFIX = "LatestActiveKeyAge";
    private static final String MAX_KEY_AGE_PREFIX = "MaxKeyAge";
    private static final String KEY_REVOCATION_ERROR_PREFIX = "KeyRevocationError";
    private static final String WRITE_KEY_CALL_PREFIX = "WriteKeyCall";
    private static final String FETCH_KEY_CALL_PREFIX = "FetchKeyCall";
    private static final String RETRIABLE_ERROR_SUFFIX = "RetriableError";
    private static final String FATAL_ERROR_SUFFIX = "FatalError";
    static final String ENCRYPT_CALL_PREFIX = "EncryptCall";
    static final String DECRYPT_CALL_PREFIX = "DecryptCall";
    private final Metrics metrics;
    final MetricName numberOfByokTenantsMetricName;
    final MetricName oldestActiveKeyAgeMetricName;
    final MetricName latestActiveKeyAgeMetricName;
    final MetricName maxKeyAgeMetricName;
    final MetricName numberOfByokTenantsWithKeyRevocationErrorMetricName;
    final MetricName encryptRetriableErrorMetricName;
    final MetricName encryptFatalErrorMetricName;
    final MetricName encrypt50PMetricName;
    final MetricName encrypt90PMetricName;
    final MetricName encrypt99PMetricName;
    final MetricName encryptCountMetricName;
    final MetricName decryptRetriableErrorMetricName;
    final MetricName decryptFatalErrorMetricName;
    final MetricName decrypt50PMetricName;
    final MetricName decrypt90PMetricName;
    final MetricName decrypt99PMetricName;
    final MetricName decryptCountMetricName;
    final MetricName writeKeyRetriableErrorMetricName;
    final MetricName writeKeyFatalErrorMetricName;
    final MetricName fetchKeyRetriableErrorMetricName;
    final MetricName fetchKeyFatalErrorMetricName;
    private final Sensor encrypt;
    private final Sensor decrypt;
    private final Sensor encryptRetriableError;
    private final Sensor encryptFatalError;
    private final Sensor decryptRetriableError;
    private final Sensor decryptFatalError;
    private final Sensor writeKeyRetriableError;
    private final Sensor writeKeyFatalError;
    private final Sensor fetchKeyRetriableError;
    private final Sensor fetchKeyFatalError;
    private final ArrayList<Sensor> sensors = new ArrayList();
    private AtomicInteger numberOfByokTenants = new AtomicInteger(0);
    private ConcurrentHashMap.KeySetView<String, Boolean> byokTenantsWithKeyRevocationError = ConcurrentHashMap.newKeySet();
    private volatile Instant oldestActiveKeyCreationTime;
    private volatile Instant latestActiveKeyCreationTime;
    private volatile Duration maxKeyAge;

    public TenantAwareEncryptionKeyManagerMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.numberOfByokTenantsMetricName = metrics.metricName(NUMBER_OF_BYOK_TENANTS_PREFIX, METRIC_GROUP_NAME, "The number of BYOK tenants on the cluster");
        this.oldestActiveKeyAgeMetricName = metrics.metricName(OLDEST_ACTIVE_KEY_AGE_PREFIX, METRIC_GROUP_NAME, "The age of the oldest current active key across all tenants in milliseconds");
        this.latestActiveKeyAgeMetricName = metrics.metricName(LATEST_ACTIVE_KEY_AGE_PREFIX, METRIC_GROUP_NAME, "The age of the newest current active key across all tenants in milliseconds");
        this.maxKeyAgeMetricName = metrics.metricName(MAX_KEY_AGE_PREFIX, METRIC_GROUP_NAME, "The current max key age in milliseconds");
        this.numberOfByokTenantsWithKeyRevocationErrorMetricName = metrics.metricName(KEY_REVOCATION_ERROR_PREFIX, METRIC_GROUP_NAME, "The number of BYOK tenants with key revocation errors");
        this.encrypt = this.sensor(ENCRYPT_CALL_PREFIX, new Sensor[0]);
        this.decrypt = this.sensor(DECRYPT_CALL_PREFIX, new Sensor[0]);
        this.metrics.addMetric(this.numberOfByokTenantsMetricName, (MetricValueProvider)new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return TenantAwareEncryptionKeyManagerMetrics.this.numberOfByokTenants.get();
            }
        });
        this.metrics.addMetric(this.oldestActiveKeyAgeMetricName, (MetricValueProvider)new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                if (TenantAwareEncryptionKeyManagerMetrics.this.oldestActiveKeyCreationTime == null) {
                    return 0L;
                }
                Instant tNow = Instant.ofEpochMilli(now);
                return tNow.minusMillis(TenantAwareEncryptionKeyManagerMetrics.this.oldestActiveKeyCreationTime.toEpochMilli()).toEpochMilli();
            }
        });
        this.metrics.addMetric(this.latestActiveKeyAgeMetricName, (MetricValueProvider)new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                if (TenantAwareEncryptionKeyManagerMetrics.this.latestActiveKeyCreationTime == null) {
                    return 0L;
                }
                Instant tNow = Instant.ofEpochMilli(now);
                return tNow.minusMillis(TenantAwareEncryptionKeyManagerMetrics.this.latestActiveKeyCreationTime.toEpochMilli()).toEpochMilli();
            }
        });
        this.metrics.addMetric(this.maxKeyAgeMetricName, (MetricValueProvider)new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                if (TenantAwareEncryptionKeyManagerMetrics.this.maxKeyAge == null) {
                    return 0L;
                }
                return TenantAwareEncryptionKeyManagerMetrics.this.maxKeyAge.toMillis();
            }
        });
        this.metrics.addMetric(this.numberOfByokTenantsWithKeyRevocationErrorMetricName, (MetricValueProvider)new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return TenantAwareEncryptionKeyManagerMetrics.this.byokTenantsWithKeyRevocationError.size();
            }
        });
        this.encryptRetriableError = this.sensor("EncryptCallRetriableError", new Sensor[0]);
        this.encryptRetriableErrorMetricName = metrics.metricName("EncryptCallRetriableError", METRIC_GROUP_NAME, "The number of retriable errors for encrypt calls using the master key");
        this.encryptRetriableError.add(this.encryptRetriableErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.encryptFatalError = this.sensor("EncryptCallFatalError", new Sensor[0]);
        this.encryptFatalErrorMetricName = metrics.metricName("EncryptCallFatalError", METRIC_GROUP_NAME, "The number of fatal errors for encrypt calls using the master key");
        this.encryptFatalError.add(this.encryptFatalErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.decryptRetriableError = this.sensor("DecryptCallRetriableError", new Sensor[0]);
        this.decryptRetriableErrorMetricName = metrics.metricName("DecryptCallRetriableError", METRIC_GROUP_NAME, "The number of retriable errors for decrypt calls using the master key");
        this.decryptRetriableError.add(this.decryptRetriableErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.decryptFatalError = this.sensor("DecryptCallFatalError", new Sensor[0]);
        this.decryptFatalErrorMetricName = metrics.metricName("DecryptCallFatalError", METRIC_GROUP_NAME, "The number of fatal errors for decrypt calls using the master key");
        this.decryptFatalError.add(this.decryptFatalErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.writeKeyRetriableError = this.sensor("WriteKeyCallRetriableError", new Sensor[0]);
        this.writeKeyRetriableErrorMetricName = metrics.metricName("WriteKeyCallRetriableError", METRIC_GROUP_NAME, "The number of retriable errors when writing the master key to a well known path");
        this.writeKeyRetriableError.add(this.writeKeyRetriableErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.writeKeyFatalError = this.sensor("WriteKeyCallFatalError", new Sensor[0]);
        this.writeKeyFatalErrorMetricName = metrics.metricName("WriteKeyCallFatalError", METRIC_GROUP_NAME, "The number of fatal errors when writing the master key to a well known path");
        this.writeKeyFatalError.add(this.writeKeyFatalErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.fetchKeyRetriableError = this.sensor("FetchKeyCallRetriableError", new Sensor[0]);
        this.fetchKeyRetriableErrorMetricName = metrics.metricName("FetchKeyCallRetriableError", METRIC_GROUP_NAME, "The number of retriable errors when fetching the master key from a well known path");
        this.fetchKeyRetriableError.add(this.fetchKeyRetriableErrorMetricName, (MeasurableStat)new CumulativeCount());
        this.fetchKeyFatalError = this.sensor("FetchKeyCallFatalError", new Sensor[0]);
        this.fetchKeyFatalErrorMetricName = metrics.metricName("FetchKeyCallFatalError", METRIC_GROUP_NAME, "The number of fatal errors when fetching the master key from a well known path");
        this.fetchKeyFatalError.add(this.fetchKeyFatalErrorMetricName, (MeasurableStat)new CumulativeCount());
        int maxEncryptDecryptTime = 30000;
        this.encrypt50PMetricName = metrics.metricName("EncryptCallP50Percentile", METRIC_GROUP_NAME, "The 50th-percentile latency for encrypt calls using the master key");
        this.encrypt90PMetricName = metrics.metricName("EncryptCallP90Percentile", METRIC_GROUP_NAME, "The 90th-percentile latency for encrypt calls using the master key");
        this.encrypt99PMetricName = metrics.metricName("EncryptCallP99Percentile", METRIC_GROUP_NAME, "The 99th-percentile latency for encrypt calls using the master key");
        this.encryptCountMetricName = metrics.metricName("EncryptCallCount", METRIC_GROUP_NAME, "The number of times a key was encrypted using the master key");
        this.encrypt.add((CompoundStat)new Percentiles(maxEncryptDecryptTime * 4, (double)maxEncryptDecryptTime, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.encrypt50PMetricName, 50.0), new Percentile(this.encrypt90PMetricName, 90.0), new Percentile(this.encrypt99PMetricName, 99.0)}));
        this.encrypt.add(this.encryptCountMetricName, (MeasurableStat)new CumulativeCount());
        this.decrypt50PMetricName = metrics.metricName("DecryptCallP50Percentile", METRIC_GROUP_NAME, "The 50th-percentile latency for decrypt calls using the master key");
        this.decrypt90PMetricName = metrics.metricName("DecryptCallP90Percentile", METRIC_GROUP_NAME, "The 90th-percentile latency for decrypt calls using the master key");
        this.decrypt99PMetricName = metrics.metricName("DecryptCallP99Percentile", METRIC_GROUP_NAME, "The 99th-percentile latency for decrypt calls using the master key");
        this.decryptCountMetricName = metrics.metricName("DecryptCallCount", METRIC_GROUP_NAME, "The number of times a key was decrypted using the master key");
        this.decrypt.add((CompoundStat)new Percentiles(maxEncryptDecryptTime * 4, (double)maxEncryptDecryptTime, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.decrypt50PMetricName, 50.0), new Percentile(this.decrypt90PMetricName, 90.0), new Percentile(this.decrypt99PMetricName, 99.0)}));
        this.decrypt.add(this.decryptCountMetricName, (MeasurableStat)new CumulativeCount());
    }

    public void recordEncryptCall(long timeMs) {
        this.encrypt.record((double)timeMs);
    }

    public void recordDecryptCall(long timeMs) {
        this.decrypt.record((double)timeMs);
    }

    public void recordEncryptRetriableError() {
        this.encryptRetriableError.record();
    }

    public void recordEncryptFatalError() {
        this.encryptFatalError.record();
    }

    public void recordDecryptRetriableError() {
        this.decryptRetriableError.record();
    }

    public void recordDecryptFatalError() {
        this.decryptFatalError.record();
    }

    public void recordWriteKeyRetriableError() {
        this.writeKeyRetriableError.record();
    }

    public void recordWriteKeyFatalError() {
        this.writeKeyFatalError.record();
    }

    public void recordFetchKeyRetriableError() {
        this.fetchKeyRetriableError.record();
    }

    public void recordFetchKeyFatalError() {
        this.fetchKeyFatalError.record();
    }

    public void incrementNumberOfByokTenants() {
        this.numberOfByokTenants.incrementAndGet();
    }

    public void decrementNumberOfByokTenants() {
        this.numberOfByokTenants.decrementAndGet();
    }

    public synchronized void updateActiveKeyCreationTime(Instant creationTime) {
        if (this.latestActiveKeyCreationTime == null || creationTime.isAfter(this.latestActiveKeyCreationTime)) {
            this.latestActiveKeyCreationTime = creationTime;
        }
        if (this.oldestActiveKeyCreationTime == null || creationTime.isBefore(this.oldestActiveKeyCreationTime)) {
            this.oldestActiveKeyCreationTime = creationTime;
        }
    }

    public void updateMaxKeyAge(Duration maxKeyAge) {
        this.maxKeyAge = maxKeyAge;
    }

    public void addByokTenantWithKeyRevocationError(String tenantId) {
        this.byokTenantsWithKeyRevocationError.add(tenantId);
    }

    public void removeByokTenantWithKeyRevocationError(String tenantId) {
        this.byokTenantsWithKeyRevocationError.remove(tenantId);
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor = this.metrics.sensor(name, parents);
        this.sensors.add(sensor);
        return sensor;
    }

    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
        this.metrics.removeMetric(this.oldestActiveKeyAgeMetricName);
        this.metrics.removeMetric(this.latestActiveKeyAgeMetricName);
        this.metrics.removeMetric(this.maxKeyAgeMetricName);
        this.metrics.removeMetric(this.numberOfByokTenantsMetricName);
    }
}

