/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BackupObjectsListMetadata
implements ObjectStoreMetadata {
    private final String clusterId;
    private final String date;
    private final String name;

    public BackupObjectsListMetadata(String clusterId, String date, String name) {
        this.clusterId = clusterId;
        this.date = date;
        this.name = name;
    }

    public String generateKeyPrefix(String prefix) {
        return prefix + DataTypePathPrefix.LIFECYCLE_MANAGER_STATE.prefix + "/" + this.clusterId;
    }

    public String getDateFromKey(String key) {
        String prefix = this.generateKeyPrefix("");
        if (key.length() <= prefix.length()) {
            return null;
        }
        String[] tokens = key.substring(prefix.length()).split("/");
        return tokens[1];
    }

    public String getListNameFromKey(String key) {
        String prefix = this.generateKeyPrefix("");
        if (key.length() <= prefix.length()) {
            return null;
        }
        String[] tokens = key.substring(prefix.length()).split("/");
        return tokens[2].split("\\.")[0];
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.BACKUP_OBJECTS_LIST) {
            throw new UnsupportedOperationException(String.format("BackupObjectsListMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return this.generateKeyPrefix(keyPrefix) + "/" + this.date + "/" + this.name + "." + objectType.suffix();
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("clusterId", this.clusterId());
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public String toString() {
        return "BackupObjectsListMetadata(clusterId=" + this.clusterId + ", date=" + this.date + ", name=" + this.name + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }
}

