/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.utils.Utils;

public class DurabilityAuditsOffsetMapMetadata
implements ObjectStoreMetadata {
    private final int version = 0;
    private final UUID objectId;
    private final TopicIdPartition topicIdPartition;

    public DurabilityAuditsOffsetMapMetadata(TopicIdPartition topicIdPartition, UUID objectId) {
        this.objectId = objectId;
        this.topicIdPartition = topicIdPartition;
    }

    public String objectIdAsBase64() {
        return Utils.uuidToBase64((UUID)this.objectId);
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("brokerid", Integer.toString(0));
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterid", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerid", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.DA_OFFSET_MAP) {
            throw new UnsupportedOperationException(String.format("DurabilityAuditsOffsetMapMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return keyPrefix + DataTypePathPrefix.DA_OFFSET_MAP.prefix + "/" + this.topicIdPartition.topicIdAsBase64() + "/" + this.topicIdPartition.partition() + "/" + this.objectIdAsBase64() + "_v0." + objectType.suffix();
    }

    public String toString() {
        return "DurabilityAuditsOffsetMapMetadata{TopicIdPartition=" + String.valueOf(this.topicIdPartition) + ", objectId=" + this.objectIdAsBase64() + ", version=0}";
    }
}

