/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public class FileTierPartitionStateRecoveryUploadMetadata
implements ObjectStoreMetadata {
    public static final int CURRENT_KEY_PATH_VERSION = 0;
    private static final String OBJECT_PATH_DELIMITER = "/";
    private static final String SUFFIX_DELIMITER = ".";
    private static final String RECOVERY_DIR_PREFIX = "recovery-";
    private static final String VERSION_CONSTANT = "_v";
    private static final String FILE_TIER_PARTITION_STATE_DIR = "ftps";
    private final String identifier;
    private final Integer broker;
    private final TopicIdPartition topicIdPartition;
    private final FileTierPartitionStateUploadObject uploadObject;
    private final int version = 0;

    public FileTierPartitionStateRecoveryUploadMetadata(String identifier, Integer broker, TopicIdPartition topicIdPartition, FileTierPartitionStateUploadObject uploadObject) {
        this.identifier = identifier;
        this.broker = broker;
        this.topicIdPartition = topicIdPartition;
        this.uploadObject = uploadObject;
    }

    public FileTierPartitionStateRecoveryUploadMetadata(String identifier, Integer broker, TopicIdPartition topicIdPartition, FileTierPartitionStateUploadObject uploadObject, Integer version) {
        if (!version.equals(0)) {
            throw new IllegalArgumentException("Received invalid version for FileTierPartitionStateRecoveryUploadMetadata: " + version);
        }
        this.identifier = identifier;
        this.broker = broker;
        this.topicIdPartition = topicIdPartition;
        this.uploadObject = uploadObject;
    }

    public String identifier() {
        return this.identifier;
    }

    public Integer broker() {
        return this.broker;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FileTierPartitionStateUploadObject uploadObject() {
        return this.uploadObject;
    }

    public int version() {
        return 0;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD) {
            throw new UnsupportedOperationException(String.format("TierPartitionStateUploadMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    public String toPath(String keyPrefix, ObjectType objectType) {
        String fileName = this.uploadObject.encodeRecoveryUploadName() + "_v0." + objectType.suffix();
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, FileTierPartitionStateRecoveryUploadMetadata.pathPrefix(keyPrefix, this.identifier, this.broker, this.topicIdPartition), fileName);
    }

    public static FileTierPartitionStateRecoveryUploadMetadata fromPath(String filePath) {
        String errorMessage = String.format("The filePath: %s does not have the expected format.", filePath);
        String prefixDelimiter = DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix() + OBJECT_PATH_DELIMITER;
        String[] prefix = filePath.split(prefixDelimiter, 2);
        String[] attributes = prefix[1].split(OBJECT_PATH_DELIMITER);
        String identifier = attributes[0].split(RECOVERY_DIR_PREFIX)[1];
        int broker = Integer.parseInt(attributes[1]);
        FileTierPartitionStateRecoveryUploadMetadata.validateAssertion(attributes[2].equals(FILE_TIER_PARTITION_STATE_DIR), errorMessage);
        UUID topicId = Utils.uuidFromBase64((String)attributes[3]);
        TopicPartition topicPartition = TopicPartition.fromString((String)attributes[4]);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), topicId, topicPartition.partition());
        String suffix = attributes[5];
        String[] uploadNameArr = suffix.split(SUFFIX_DELIMITER + ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD.suffix());
        FileTierPartitionStateRecoveryUploadMetadata.validateAssertion(uploadNameArr.length == 1, errorMessage);
        String[] uploadNameSplitByVersionArr = uploadNameArr[0].split(VERSION_CONSTANT);
        FileTierPartitionStateRecoveryUploadMetadata.validateAssertion(uploadNameSplitByVersionArr.length == 2, errorMessage);
        String uploadNameWithoutVersion = uploadNameSplitByVersionArr[0];
        Integer version = Integer.parseInt(uploadNameSplitByVersionArr[1]);
        FileTierPartitionStateUploadObject uploadObject = FileTierPartitionStateUploadObject.decodeUploadName(uploadNameWithoutVersion);
        return new FileTierPartitionStateRecoveryUploadMetadata(identifier, broker, topicIdPartition, uploadObject, version);
    }

    private static void validateAssertion(Boolean assertion, String errorMessage) {
        if (!assertion.booleanValue()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static String pathPrefix(String keyPrefix, String identifier, Integer broker, TopicIdPartition topicIdPartition) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, keyPrefix + DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), RECOVERY_DIR_PREFIX + identifier, broker.toString(), FILE_TIER_PARTITION_STATE_DIR, topicIdPartition.topicIdAsBase64(), topicIdPartition.topicPartition().toString());
    }

    public static String extractEncodedName(String uploadPath) {
        String[] tokens = uploadPath.split(OBJECT_PATH_DELIMITER);
        String uploadNameWithSuffix = tokens[tokens.length - 1];
        return uploadNameWithSuffix.split("_v0")[0];
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("identifier", this.identifier);
        metadata.put("broker", Integer.toString(this.broker));
        metadata.put("topicId", this.topicIdPartition().topicIdAsBase64());
        metadata.put("topic", this.topicIdPartition().topic());
        metadata.put("partition", String.valueOf(this.topicIdPartition().partition()));
        metadata.put("version", String.valueOf(0));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTierPartitionStateRecoveryUploadMetadata that = (FileTierPartitionStateRecoveryUploadMetadata)o;
        return this.broker.equals(that.broker) && this.topicIdPartition.equals(that.topicIdPartition) && this.uploadObject.equals(that.uploadObject) && this.identifier.equals(that.identifier) && 0 == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.identifier, this.topicIdPartition, this.uploadObject, 0);
    }

    public String toString() {
        return "TierPartitionStateUploadMetadata{broker=" + this.broker + ", identifier=" + this.identifier + ", topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", uploadObject=" + String.valueOf(this.uploadObject) + ", version=0}";
    }
}

