/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.tier.store.DataTypePathPrefix;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentLocation;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TierRecoveryUploadMetadata
implements ObjectStoreMetadata {
    public static final Integer CURRENT_METADATA_VERSION = 0;
    public static final String OBJECT_PATH_DELIMITER = "/";
    public static final String RECOVERY_DIR_PREFIX = "recovery-";
    private static final String FILE_NAME_PREFIX = "tier-recovery-upload-metadata";
    private static final String VERSION_CONSTANT = "_v";
    private static final String TIER_RECOVERY_UPLOAD_METADATA_DIR = "upload-metadata";
    private final String identifier;
    private final Integer broker;
    private final Integer version = CURRENT_METADATA_VERSION;

    public TierRecoveryUploadMetadata(String identifier, Integer broker) {
        this.identifier = identifier;
        this.broker = broker;
    }

    public TierRecoveryUploadMetadata(String identifier, Integer broker, Integer version) {
        if (!version.equals(CURRENT_METADATA_VERSION)) {
            throw new IllegalArgumentException("Received invalid version for TierRecoveryUploadMetadata: " + version);
        }
        this.identifier = identifier;
        this.broker = broker;
    }

    public String identifier() {
        return this.identifier;
    }

    public Integer broker() {
        return this.broker;
    }

    public Integer version() {
        return this.version;
    }

    public static String pathPrefix(String keyPrefix, String identifier, Integer broker) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, keyPrefix + DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), RECOVERY_DIR_PREFIX + identifier, broker.toString(), TIER_RECOVERY_UPLOAD_METADATA_DIR);
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, TierRecoveryUploadMetadata.pathPrefix(keyPrefix, this.identifier, this.broker), "tier-recovery-upload-metadata_v" + this.version.toString() + "." + objectType.suffix());
    }

    public static TierRecoveryUploadMetadata fromPath(String filePath) {
        String errorMessage = String.format("The filePath: %s does not have the expected format.", filePath);
        String prefixDelimiter = DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix() + OBJECT_PATH_DELIMITER;
        String[] prefix = filePath.split(prefixDelimiter, 2);
        String[] attributes = prefix[1].split(OBJECT_PATH_DELIMITER);
        String identifier = attributes[0].split(RECOVERY_DIR_PREFIX)[1];
        Integer broker = Integer.parseInt(attributes[1]);
        Integer version = Integer.parseInt(attributes[3].split(VERSION_CONSTANT)[1].split("\\.")[0]);
        TierRecoveryUploadMetadata.validateAssertion(attributes[2].equals(TIER_RECOVERY_UPLOAD_METADATA_DIR), errorMessage);
        TierRecoveryUploadMetadata.validateAssertion(attributes[3].startsWith(FILE_NAME_PREFIX), errorMessage);
        return new TierRecoveryUploadMetadata(identifier, broker, version);
    }

    private static void validateAssertion(Boolean assertion, String errorMessage) {
        if (!assertion.booleanValue()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_RECOVERY_METADATA_UPLOAD) {
            throw new UnsupportedOperationException(String.format("TierPartitionStateUploadMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("broker", String.valueOf(this.broker));
        metadata.put("identifier", this.identifier);
        metadata.put("version", String.valueOf(this.version));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public String toString() {
        return "TierRecoveryUploadMetadata{broker=" + this.broker + ", identifier=" + this.identifier + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierRecoveryUploadMetadata that = (TierRecoveryUploadMetadata)o;
        return this.broker.equals(that.broker) && this.identifier.equals(that.identifier) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.identifier, this.version);
    }
}

