/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.utils.ThreadsCpuMeter;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.resource.DiskIOManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.compaction.CompactionSummarizer;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.tasks.config.SnapshotTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig$;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.HeartbeatingShutdownableThread;
import kafka.utils.HeartbeatingShutdownableThread$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002(P\u0001YC\u0001B\u001a\u0001\u0003\u0002\u0004%\ta\u001a\u0005\t[\u0002\u0011\t\u0019!C\u0001]\"Aq\u000f\u0001B\u0001B\u0003&\u0001\u000e\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005=\u0002A!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002v\u0001!\t&a\u001e\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAQ\u0001\u0001\u0006I!a%\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\"CAW\u0001\u0001\u0007I\u0011BAX\u0011!\t\u0019\f\u0001Q!\n\u0005\u001d\u0006\"CA[\u0001\u0001\u0007I\u0011BAS\u0011%\t9\f\u0001a\u0001\n\u0013\tI\f\u0003\u0005\u0002>\u0002\u0001\u000b\u0015BAT\u0011%\ty\f\u0001a\u0001\n\u0013\t)\u000bC\u0005\u0002B\u0002\u0001\r\u0011\"\u0003\u0002D\"A\u0011q\u0019\u0001!B\u0013\t9\u000bC\u0005\u0002J\u0002\u0011\r\u0011\"\u0003\u0002L\"A\u0011\u0011\u001c\u0001!\u0002\u0013\ti\rC\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\"A\u00111\u001f\u0001!\u0002\u0013\ty\u000eC\u0005\u0002v\u0002\u0011\r\u0011\"\u0003\u0002x\"A!1\u0003\u0001!\u0002\u0013\tI\u0010C\u0005\u0003\u0016\u0001\u0001\r\u0011\"\u0003\u0003\u0018!I!1\u0007\u0001A\u0002\u0013%!Q\u0007\u0005\t\u0005s\u0001\u0001\u0015)\u0003\u0003\u001a!Q!1\b\u0001C\u0002\u0013\u0005\u0011+!8\t\u0011\tu\u0002\u0001)A\u0005\u0003?D!Ba\u0010\u0001\u0005\u0004%\t!UAo\u0011!\u0011\t\u0005\u0001Q\u0001\n\u0005}\u0007\"\u0003B\"\u0001\t\u0007I\u0011\u0002B#\u0011!\u0011\t\u0006\u0001Q\u0001\n\t\u001d\u0003\"\u0003B*\u0001\t\u0007I\u0011\u0002B+\u0011!\u0011\u0019\u0007\u0001Q\u0001\n\t]\u0003\"\u0003B3\u0001\t\u0007I\u0011\u0002B4\u0011!\u0011)\b\u0001Q\u0001\n\t%\u0004B\u0003B<\u0001\t\u0007I\u0011A)\u0003z!A!\u0011\u0012\u0001!\u0002\u0013\u0011Y\b\u0003\u0006\u0003\f\u0002\u0011\r\u0011\"\u0001R\u0005\u001bC\u0001B!(\u0001A\u0003%!q\u0012\u0005\n\u0005?\u0003!\u0019!C\u0005\u0005CC\u0001B!/\u0001A\u0003%!1\u0015\u0005\n\u0005\u0013\u0004!\u0019!C\u0005\u0005\u0017D\u0001Ba5\u0001A\u0003%!Q\u001a\u0005\n\u0005+\u0004!\u0019!C\u0005\u0005/D\u0001Ba<\u0001A\u0003%!\u0011\u001c\u0005\b\u0005c\u0004A\u0011\tBz\u0011\u001d\u0011)\u0010\u0001C\u0001\u0005gDqAa>\u0001\t\u0003\u0011\u0019\u0010C\u0004\u0003z\u0002!\tAa=\t\u000f\tm\b\u0001\"\u0011\u0003t\"9!Q \u0001\u0005\u0002\t}\bbBB\u0004\u0001\u0011\u00051\u0011\u0002\u0005\b\u0007'\u0001A\u0011AB\u000b\u0011\u001d\u0019y\u0002\u0001C!\u0007CAqaa\u000b\u0001\t\u0003\u001ai\u0003C\u0004\u0004:\u0001!\tea\u000f\t\u0011\re\u0002\u0001\"\u0001R\u0007\u0007:qa!\u0013P\u0011\u0003\u0019YE\u0002\u0004O\u001f\"\u00051Q\n\u0005\b\u0003;\u0012E\u0011AB+\u0011%\u00199F\u0011b\u0001\n\u000b\u0019I\u0006\u0003\u0005\u0004b\t\u0003\u000bQBB.\u0011%\u0019\u0019G\u0011b\u0001\n\u000b\u0019I\u0006\u0003\u0005\u0004f\t\u0003\u000bQBB.\u0011%\u00199G\u0011b\u0001\n\u000b\u0019I\u0006\u0003\u0005\u0004j\t\u0003\u000bQBB.\u0011%\u0019YG\u0011b\u0001\n\u0003\u0019\t\u0003\u0003\u0005\u0004n\t\u0003\u000b\u0011BB\u0012\u0011%\u0019yGQI\u0001\n\u0003\u0019\t\bC\u0005\u0004\b\n\u000b\n\u0011\"\u0001\u0004\n\nIA+[3s)\u0006\u001c8n\u001d\u0006\u0003!F\u000bQ\u0001^1tWNT!AU*\u0002\tQLWM\u001d\u0006\u0002)\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001X;\u0002\u0004\"\u0001W.\u000e\u0003eS!AW*\u0002\u000bU$\u0018\u000e\\:\n\u0005qK&A\b%fCJ$(-Z1uS:<7\u000b[;uI><h.\u00192mKRC'/Z1e!\tAf,\u0003\u0002`3\n9Aj\\4hS:<\u0007CA1e\u001b\u0005\u0011'BA2T\u0003\u0019\u0019XM\u001d<fe&\u0011QM\u0019\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\r\r|gNZ5h+\u0005A\u0007CA5l\u001b\u0005Q'B\u00014P\u0013\ta'NA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003_V\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014A!\u00168ji\"9aOAA\u0001\u0002\u0004A\u0017a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003FA\u0002z!\t\u0001(0\u0003\u0002|c\nAao\u001c7bi&dW-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005\u0005t\u0018BA@c\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011QAA\u0004\u001b\u0005\t\u0016bAA\u0005#\n\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0001\"\u0018.\u001a:EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005\u0015\u0011qB\u0005\u0004\u0003#\t&\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\f\u0011\u0003^5feR{\u0007/[2BaB,g\u000eZ3s!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e#\u0006)Ao\u001c9jG&!\u0011qDA\r\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM]\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*E\u000bQa\u001d;pe\u0016LA!!\f\u0002(\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\u0003uS6,\u0007\u0003BA\u001a\u0003\u000bj!!!\u000e\u000b\u0007i\u000b9D\u0003\u0003\u0002:\u0005m\u0012AB2p[6|gNC\u0002U\u0003{QA!a\u0010\u0002B\u00051\u0011\r]1dQ\u0016T!!a\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002H\u0005U\"\u0001\u0002+j[\u0016\f\u0001\u0003Z5tW&{U*\u00198bO\u0016\u0014x\n\u001d;\u0011\u000bA\fi%!\u0015\n\u0007\u0005=\u0013O\u0001\u0004PaRLwN\u001c\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b2\u0002\u0011I,7o\\;sG\u0016LA!a\u0017\u0002V\tiA)[:l\u0013>k\u0015M\\1hKJ\fa\u0001P5oSRtDCEA1\u0003K\n9'!\u001b\u0002l\u00055\u0014qNA9\u0003g\u00022!a\u0019\u0001\u001b\u0005y\u0005\"\u00024\f\u0001\u0004A\u0007\"\u0002?\f\u0001\u0004i\bbBA\u0001\u0017\u0001\u0007\u00111\u0001\u0005\b\u0003\u0017Y\u0001\u0019AA\u0007\u0011\u001d\t\u0019b\u0003a\u0001\u0003+Aq!!\t\f\u0001\u0004\t\u0019\u0003C\u0005\u00020-\u0001\n\u00111\u0001\u00022!I\u0011\u0011J\u0006\u0011\u0002\u0003\u0007\u00111J\u0001\u000bY><w-\u001a:OC6,WCAA=!\u0011\tY(!#\u000f\t\u0005u\u0014Q\u0011\t\u0004\u0003\u007f\nXBAAA\u0015\r\t\u0019)V\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\u0015/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u000biI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000f\u000b\u0018\u0001D7fiJL7m]$s_V\u0004XCAAJ!\u0011\t)*!(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bq!\\3ue&\u001c7OC\u0002d\u0003wIA!a(\u0002\u0018\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003Ia\u0017m\u001d;MC\u001e\u0004&/\u001b8u)&lW-T:\u0016\u0005\u0005\u001d\u0006c\u00019\u0002*&\u0019\u00111V9\u0003\t1{gnZ\u0001\u0017Y\u0006\u001cH\u000fT1h!JLg\u000e\u001e+j[\u0016l5o\u0018\u0013fcR\u0019q.!-\t\u0011Y\u0004\u0012\u0011!a\u0001\u0003O\u000b1\u0003\\1ti2\u000bw\r\u0015:j]R$\u0016.\\3Ng\u0002\n\u0001\u0005\\1ti\u000e{W\u000e]1di&|gnU;n[\u0006\u0014\u0018\u0010\u0015:j]R$\u0016.\\3Ng\u0006!C.Y:u\u0007>l\u0007/Y2uS>t7+^7nCJL\bK]5oiRKW.Z't?\u0012*\u0017\u000fF\u0002p\u0003wC\u0001B^\n\u0002\u0002\u0003\u0007\u0011qU\u0001\"Y\u0006\u001cHoQ8na\u0006\u001cG/[8o'VlW.\u0019:z!JLg\u000e\u001e+j[\u0016l5\u000fI\u0001%Y\u0006\u001cH\u000fV5fe\u0012+G.\u001a;j_:\u001c\b+\u001a8eS:<W*\u001a;sS\u000e$\u0016.\\3Ng\u0006AC.Y:u)&,'\u000fR3mKRLwN\\:QK:$\u0017N\\4NKR\u0014\u0018n\u0019+j[\u0016l5o\u0018\u0013fcR\u0019q.!2\t\u0011Y4\u0012\u0011!a\u0001\u0003O\u000bQ\u0005\\1tiRKWM\u001d#fY\u0016$\u0018n\u001c8t!\u0016tG-\u001b8h\u001b\u0016$(/[2US6,Wj\u001d\u0011\u0002\u0007\r$\b0\u0006\u0002\u0002NB!\u0011qZAk\u001b\t\t\tNC\u0002\u0002TF\u000bqAZ3uG\",'/\u0003\u0003\u0002X\u0006E'aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\nq#\u0019:dQ&4X\rR3mKRLwN\\#yK\u000e,Ho\u001c:\u0016\u0005\u0005}\u0007\u0003BAq\u0003_l!!a9\u000b\t\u0005\u0015\u0018q]\u0001\u000bG>t7-\u001e:sK:$(\u0002BAu\u0003W\fA!\u001e;jY*\u0011\u0011Q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002r\u0006\r(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u00021\u0005\u00148\r[5wK\u0012+G.\u001a;j_:,\u00050Z2vi>\u0014\b%\u0001\bdY\u0016\fg.\u001a:UQJ,\u0017\rZ:\u0016\u0005\u0005e\bCBA~\u0005\u000b\u0011I!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003\u001diW\u000f^1cY\u0016T1Aa\u0001r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\tiPA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u00111^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002,\n5\u0011aD2mK\u0006tWM\u001d+ie\u0016\fGm\u001d\u0011\u0002-QLWM]\"p[B\f7\r^5p]\u000e\u0003X/T3uKJ,\"A!\u0007\u0011\u000bA\fiEa\u0007\u0011\t\tu!qF\u0007\u0003\u0005?Q1A\u0017B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\u000fM$xN]1hK*\u0019AKa\n\u000b\t\t%\"1F\u0001\nG>tg\r\\;f]RT!A!\f\u0002\u0005%|\u0017\u0002\u0002B\u0019\u0005?\u0011q\u0002\u00165sK\u0006$7o\u00119v\u001b\u0016$XM]\u0001\u001bi&,'oQ8na\u0006\u001cG/[8o\u0007B,X*\u001a;fe~#S-\u001d\u000b\u0004_\n]\u0002\u0002\u0003< \u0003\u0003\u0005\rA!\u0007\u0002/QLWM]\"p[B\f7\r^5p]\u000e\u0003X/T3uKJ\u0004\u0013\u0001E2mK\u0006t\u0017N\\4Fq\u0016\u001cW\u000f^8s\u0003E\u0019G.Z1oS:<W\t_3dkR|'\u000fI\u0001\u0011g:\f\u0007o\u001d5pi\u0016CXmY;u_J\f\u0011c\u001d8baNDw\u000e^#yK\u000e,Ho\u001c:!\u0003M\t'o\u00195jm\u0016$U\r\\3uS>t\u0007k\\8m+\t\u00119\u0005\u0005\u0003\u0003J\t5SB\u0001B&\u0015\r\t)/]\u0005\u0005\u0005\u001f\u0012YE\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\fA#\u0019:dQ&4X\rR3mKRLwN\u001c)p_2\u0004\u0013\u0001\u0004;jKJ\f%o\u00195jm\u0016\u0014XC\u0001B,!\u0011\u0011IFa\u0018\u000e\u0005\tm#b\u0001B/\u001f\u00069\u0011M]2iSZ,\u0017\u0002\u0002B1\u00057\u0012A\u0002V5fe\u0006\u00138\r[5wKJ\fQ\u0002^5fe\u0006\u00138\r[5wKJ\u0004\u0013a\u0005;jKJ$U\r\\3uS>tW*\u00198bO\u0016\u0014XC\u0001B5!\u0011\u0011YG!\u001d\u000e\u0005\t5$b\u0001B8\u001f\u00061A-\u001a7fi\u0016LAAa\u001d\u0003n\t\u0019B+[3s\t\u0016dW\r^5p]6\u000bg.Y4fe\u0006!B/[3s\t\u0016dW\r^5p]6\u000bg.Y4fe\u0002\nQ\u0003^5fe2{wm\u00117fC:,'/T1oC\u001e,'/\u0006\u0002\u0003|A)\u0001/!\u0014\u0003~A!!q\u0010BC\u001b\t\u0011\tIC\u0002\u0003\u0004>\u000b!bY8na\u0006\u001cG/[8o\u0013\u0011\u00119I!!\u0003+QKWM\u001d'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u00061B/[3s\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b%A\u000euS\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'b]\u0006<WM]\u000b\u0003\u0005\u001f\u0003R\u0001]A'\u0005#\u0003BAa%\u0003\u001a6\u0011!Q\u0013\u0006\u0004\u0005/{\u0015\u0001C:oCB\u001c\bn\u001c;\n\t\tm%Q\u0013\u0002\u001c)&,'/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u00029QLWM]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3sA\u0005qA/[3s)\u0006\u001c8.U;fk\u0016\u001cXC\u0001BR!\u0019\tYP!*\u0003*&!!qUA\u007f\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\u0019\u0005\u0005W\u0013)\f\u0005\u0004\u0002d\t5&\u0011W\u0005\u0004\u0005_{%!\u0004+jKJ$\u0016m]6Rk\u0016,X\r\u0005\u0003\u00034\nUF\u0002\u0001\u0003\f\u0005o\u0003\u0014\u0011!A\u0001\u0006\u0003\u0011YLA\u0002`IE\nq\u0002^5feR\u000b7o[)vKV,7\u000fI\t\u0005\u0005{\u0013\u0019\rE\u0002q\u0005\u007fK1A!1r\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u001dBc\u0013\r\u00119-\u001d\u0002\u0004\u0003:L\u0018!D2iC:<W-T1oC\u001e,'/\u0006\u0002\u0003NB!\u00111\rBh\u0013\r\u0011\tn\u0014\u0002\u000e\u0007\"\fgnZ3NC:\fw-\u001a:\u0002\u001d\rD\u0017M\\4f\u001b\u0006t\u0017mZ3sA\u0005y1-_2mKRKW.Z'fiJL7-\u0006\u0002\u0003ZB!!1\u001cBv\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018\u0001B2pe\u0016TA!!'\u0003d*!!Q\u001dBt\u0003\u0019I\u0018-\\7fe*\u0011!\u0011^\u0001\u0004G>l\u0017\u0002\u0002Bw\u0005;\u0014Q!T3uKJ\f\u0001cY=dY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u0011\u0002\r\u0011|wk\u001c:l)\u0005y\u0017aG7bs\n,Gj\\4US\u0016\u0014\u0018I]2iSZ,'\u000fT1h\u0013:4w.A\rnCf\u0014W\rT8h\u0007>l\u0007/Y2uS>t7+^7nCJL\u0018aG7bs\n,W\u000b\u001d3bi\u0016$U\r\\3uS>t7\u000fU3oI&tw-\u0001\u0005tQV$Hm\\<o\u0003E\t'o\u00195jm\u0016\u0014H+Y:l#V,W/Z\u000b\u0003\u0007\u0003\u0001BA!\u0017\u0004\u0004%!1Q\u0001B.\u0005E\t%o\u00195jm\u0016\u0014H+Y:l#V,W/Z\u0001\u0014G>l\u0007/Y2uS>tG+Y:l#V,W/Z\u000b\u0003\u0007\u0017\u0001R\u0001]A'\u0007\u001b\u0001BAa \u0004\u0010%!1\u0011\u0003BA\u0005M\u0019u.\u001c9bGRLwN\u001c+bg.\fV/Z;f\u0003eiW\r^1eCR\f7K\\1qg\"|G\u000fV1tWF+X-^3\u0016\u0005\r]\u0001#\u00029\u0002N\re\u0001\u0003\u0002BJ\u00077IAa!\b\u0003\u0016\nIR*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e+bg.\fV/Z;f\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"aa\t\u0011\r\r\u00152qEA=\u001b\t\u0011\t!\u0003\u0003\u0004*\t\u0005!aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004_\u000e=\u0002bBB\u0019}\u0001\u000711G\u0001\n]\u0016<8i\u001c8gS\u001e\u00042!YB\u001b\u0013\r\u00199D\u0019\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,G#B8\u0004>\r\u0005\u0003bBB \u007f\u0001\u000711G\u0001\n_2$7i\u001c8gS\u001eDqa!\r@\u0001\u0004\u0019\u0019\u0004F\u0003p\u0007\u000b\u001a9\u0005\u0003\u0004\u0004@\u0001\u0003\r\u0001\u001b\u0005\u0007\u0007c\u0001\u0005\u0019\u00015\u0002\u0013QKWM\u001d+bg.\u001c\bcAA2\u0005N\u0019!ia\u0014\u0011\u0007A\u001c\t&C\u0002\u0004TE\u0014a!\u00118z%\u00164GCAB&\u0003M\u0001VIU%P\t&\u001bu\fT(H?2\u000buiX'T+\t\u0019Y\u0006E\u0002q\u0007;J1aa\u0018r\u0005\rIe\u000e^\u0001\u0015!\u0016\u0013\u0016j\u0014#J\u0007~cujR0M\u0003\u001e{Vj\u0015\u0011\u0002EA+%+S(E\u0013\u000e{FjT$`\u0007>k\u0005+Q\"U\u0013>sulU+N\u001b\u0006\u0013\u0016lX'T\u0003\r\u0002VIU%P\t&\u001bu\fT(H?\u000e{U\nU!D)&{ejX*V\u001b6\u000b%+W0N'\u0002\n\u0011\u0005U#S\u0013>#\u0015jQ0E\u000b2+E+S(O?F+V)V#`\u001b\u0016#&+S\"`\u001bN\u000b!\u0005U#S\u0013>#\u0015jQ0E\u000b2+E+S(O?F+V)V#`\u001b\u0016#&+S\"`\u001bN\u0003\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"aa\u001d+\t\u0005E2QO\u0016\u0003\u0007o\u0002Ba!\u001f\u0004\u00046\u001111\u0010\u0006\u0005\u0007{\u001ay(A\u0005v]\u000eDWmY6fI*\u00191\u0011Q9\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0006\u000em$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"aa#+\t\u0005-3Q\u000f")
public class TierTasks
extends HeartbeatingShutdownableThread
implements Logging,
BrokerReconfigurable {
    private volatile TierTasksConfig config;
    private final ReplicaManager replicaManager;
    private final TierTopicAppender tierTopicAppender;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private long lastLagPrintTimeMs;
    private long lastCompactionSummaryPrintTimeMs;
    private long lastTierDeletionsPendingMetricTimeMs;
    private final CancellationContext ctx;
    private final ExecutorService archiveDeletionExecutor;
    private final ArrayBuffer<Long> kafka$tier$tasks$TierTasks$$cleanerThreads;
    private Option<ThreadsCpuMeter> kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    private final ExecutorService cleaningExecutor;
    private final ExecutorService snapshotExecutor;
    private final ExecutionContextExecutor archiveDeletionPool;
    private final TierArchiver tierArchiver;
    private final TierDeletionManager tierDeletionManager;
    private final Option<TierLogCleanerManager> tierLogCleanerManager;
    private final Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager;
    private final ListBuffer<TierTaskQueue<?>> tierTaskQueues;
    private final ChangeManager changeManager;
    private final Meter cycleTimeMetric;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<DiskIOManager> $lessinit$greater$default$8() {
        return TierTasks$.MODULE$.$lessinit$greater$default$8();
    }

    public static Time $lessinit$greater$default$7() {
        return TierTasks$.MODULE$.$lessinit$greater$default$7();
    }

    public static Set<String> ReconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    public static int PERIODIC_DELETION_QUEUE_METRIC_MS() {
        return TierTasks$.MODULE$.PERIODIC_DELETION_QUEUE_METRIC_MS();
    }

    public static int PERIODIC_LOG_COMPACTION_SUMMARY_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_COMPACTION_SUMMARY_MS();
    }

    public static int PERIODIC_LOG_LAG_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierTasks tierTasks = this;
        synchronized (tierTasks) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    public void config_$eq(TierTasksConfig x$1) {
        this.config = x$1;
    }

    @Override
    public String loggerName() {
        return TierTasks.class.getName();
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private long lastLagPrintTimeMs() {
        return this.lastLagPrintTimeMs;
    }

    private void lastLagPrintTimeMs_$eq(long x$1) {
        this.lastLagPrintTimeMs = x$1;
    }

    private long lastCompactionSummaryPrintTimeMs() {
        return this.lastCompactionSummaryPrintTimeMs;
    }

    private void lastCompactionSummaryPrintTimeMs_$eq(long x$1) {
        this.lastCompactionSummaryPrintTimeMs = x$1;
    }

    private long lastTierDeletionsPendingMetricTimeMs() {
        return this.lastTierDeletionsPendingMetricTimeMs;
    }

    private void lastTierDeletionsPendingMetricTimeMs_$eq(long x$1) {
        this.lastTierDeletionsPendingMetricTimeMs = x$1;
    }

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ExecutorService archiveDeletionExecutor() {
        return this.archiveDeletionExecutor;
    }

    public ArrayBuffer<Long> kafka$tier$tasks$TierTasks$$cleanerThreads() {
        return this.kafka$tier$tasks$TierTasks$$cleanerThreads;
    }

    private Option<ThreadsCpuMeter> tierCompactionCpuMeter() {
        return this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    }

    public void kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = x$1;
    }

    public ExecutorService cleaningExecutor() {
        return this.cleaningExecutor;
    }

    public ExecutorService snapshotExecutor() {
        return this.snapshotExecutor;
    }

    private ExecutionContextExecutor archiveDeletionPool() {
        return this.archiveDeletionPool;
    }

    private TierArchiver tierArchiver() {
        return this.tierArchiver;
    }

    private TierDeletionManager tierDeletionManager() {
        return this.tierDeletionManager;
    }

    public Option<TierLogCleanerManager> tierLogCleanerManager() {
        return this.tierLogCleanerManager;
    }

    public Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager() {
        return this.tierMetadataSnapshotManager;
    }

    private ListBuffer<TierTaskQueue<?>> tierTaskQueues() {
        return this.tierTaskQueues;
    }

    private ChangeManager changeManager() {
        return this.changeManager;
    }

    private Meter cycleTimeMetric() {
        return this.cycleTimeMetric;
    }

    @Override
    public void doWork() {
        if (!this.tierTopicAppender.isReadyForWrites()) {
            this.info((Function0<String> & Serializable)() -> "TierTopicAppender is not ready. Backing off.");
            while (!this.tierTopicAppender.isReadyForWrites() && this.isRunning()) {
                this.pause(this.config().updateIntervalMs(), TimeUnit.MILLISECONDS);
            }
            if (!this.isRunning()) {
                return;
            }
            this.info((Function0<String> & Serializable)() -> "TierTopicAppender is ready.");
        }
        this.cycleTimeMetric().mark();
        this.changeManager().process();
        this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, List> & Serializable)x$8 -> x$8.doWork());
        this.tierArchiver().doWork();
        this.tierDeletionManager().doWork();
        this.tierMetadataSnapshotManager().map((Function1<TierMetadataSnapshotManager, List> & Serializable)x$9 -> x$9.doWork());
        this.maybeLogTierArchiverLagInfo();
        this.maybeLogCompactionSummary();
        this.maybeUpdateDeletionsPending();
        if (this.tierArchiver().taskQueue().taskCount() == 0 && this.tierDeletionManager().taskQueue().taskCount() == 0 && BoxesRunTime.unboxToInt(this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, Object> & Serializable)x$10 -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$doWork$5(x$10))).getOrElse(() -> 0)) == 0 && BoxesRunTime.unboxToInt(this.tierMetadataSnapshotManager().map((Function1<TierMetadataSnapshotManager, Object> & Serializable)x$11 -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$doWork$7(x$11))).getOrElse(() -> 0)) == 0) {
            this.changeManager().processAtLeastOne();
            return;
        }
        this.time.sleep((long)this.config().updateIntervalMs());
    }

    public void maybeLogTierArchiverLagInfo() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastLagPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS()) {
            this.tierArchiver().logPartitionLagInfo(currentTime);
            this.lastLagPrintTimeMs_$eq(currentTime);
            return;
        }
    }

    public void maybeLogCompactionSummary() {
        if (this.config().tierCleanerFeatureEnable() && this.tierLogCleanerManager().isDefined()) {
            long currentTime = this.time.milliseconds();
            if (currentTime > this.lastCompactionSummaryPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_COMPACTION_SUMMARY_MS()) {
                CompactionSummarizer compactionSummarizer = new CompactionSummarizer(this.replicaManager, this.config(), this.time);
                compactionSummarizer.logCompactionSummary((List)this.tierLogCleanerManager().get().taskQueue().withAllTasks((Function1<scala.collection.immutable.Set, List> & Serializable)x$12 -> x$12.toList()));
                this.lastCompactionSummaryPrintTimeMs_$eq(currentTime);
                return;
            }
            return;
        }
    }

    public void maybeUpdateDeletionsPending() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastTierDeletionsPendingMetricTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_DELETION_QUEUE_METRIC_MS()) {
            this.tierDeletionManager().recordDeletionsPendingMetric();
            this.lastTierDeletionsPendingMetricTimeMs_$eq(currentTime);
            return;
        }
    }

    @Override
    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "shutting down");
        this.initiateShutdown();
        this.ctx().cancel();
        this.changeManager().close();
        this.tierArchiver().shutdown();
        this.tierDeletionManager().shutdown();
        this.tierLogCleanerManager().foreach((Function1<TierLogCleanerManager, Object> & Serializable)x$13 -> {
            x$13.shutdown();
            return BoxedUnit.UNIT;
        });
        this.tierMetadataSnapshotManager().foreach((Function1<TierMetadataSnapshotManager, Object> & Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        this.archiveDeletionExecutor().shutdown();
        this.archiveDeletionExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.cleaningExecutor().shutdown();
        this.cleaningExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.snapshotExecutor().shutdown();
        this.snapshotExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.awaitShutdown();
    }

    public ArchiverTaskQueue archiverTaskQueue() {
        return this.tierArchiver().taskQueue();
    }

    public Option<CompactionTaskQueue> compactionTaskQueue() {
        return this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, CompactionTaskQueue> & Serializable)x$15 -> x$15.taskQueue());
    }

    public Option<MetadataSnapshotTaskQueue> metadataSnapshotTaskQueue() {
        return this.tierMetadataSnapshotManager().map((Function1<TierMetadataSnapshotManager, MetadataSnapshotTaskQueue> & Serializable)x$16 -> x$16.taskQueue());
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        if (newTierTasksConfig.numCleanerThreads() < 1) {
            throw new ConfigException("Tier cleaner threads should be at least 1");
        }
        if (newTierTasksConfig.numCleanerThreads() < this.config().numCleanerThreads() / 2) {
            throw new ConfigException("Tier cleaner threads cannot be reduced to less than half the current value " + this.config().numCleanerThreads());
        }
        if (newTierTasksConfig.numCleanerThreads() > this.config().numCleanerThreads() * 2) {
            throw new ConfigException("Tier cleaner threads cannot be increased to more than double the current value " + this.config().numCleanerThreads());
        }
        if (newTierTasksConfig.snapshotTaskConfig().exists((Function1<SnapshotTasksConfig, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(TierTasks.$anonfun$validateReconfiguration$1(c)))) {
            throw new ConfigException(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsRetentionDaysProp() + " must have a value of at least " + 2 + " days");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        TierTasksConfig oldTierTasksConfig = this.config();
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        this.reconfigure(oldTierTasksConfig, newTierTasksConfig);
    }

    public void reconfigure(TierTasksConfig oldConfig, TierTasksConfig newConfig) {
        this.config_$eq(newConfig);
        this.tierLogCleanerManager().foreach((Function1<TierLogCleanerManager, Object> & Serializable)x$17 -> {
            x$17.updateConfig(newConfig);
            return BoxedUnit.UNIT;
        });
        if (newConfig.numCleanerThreads() != oldConfig.numCleanerThreads()) {
            ThreadPoolExecutor cleaningThreadPool = (ThreadPoolExecutor)this.cleaningExecutor();
            cleaningThreadPool.setMaximumPoolSize(newConfig.numCleanerThreads());
            cleaningThreadPool.setCorePoolSize(newConfig.numCleanerThreads());
            return;
        }
    }

    public final /* synthetic */ Double kafka$tier$tasks$TierTasks$$$anonfun$new$2() {
        return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(this.tierCompactionCpuMeter().map((Function1<ThreadsCpuMeter, Object> & Serializable)x$2 -> BoxesRunTime.boxToDouble(x$2.computeCpuUtilizationPercent())).getOrElse(() -> 0.0)) * (double)100);
    }

    public static final /* synthetic */ void $anonfun$new$1(TierTasks $this, TierLogCleanerManager x$1) {
        x$1.logCleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Double>($this){
            private final /* synthetic */ TierTasks $outer;

            public final Double value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final /* synthetic */ long $anonfun$new$7(TierTasks $this) {
        return System.currentTimeMillis() - $this.lastHeartbeatMs();
    }

    public static final /* synthetic */ int $anonfun$new$9(TierLogCleanerManager x$5) {
        return x$5.taskQueue().errorPartitionCount();
    }

    public static final /* synthetic */ int $anonfun$new$8(TierTasks $this) {
        return $this.tierArchiver().taskQueue().errorPartitionCount() + $this.tierDeletionManager().taskQueue().errorPartitionCount() + BoxesRunTime.unboxToInt($this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$9(x$5))).getOrElse(() -> 0));
    }

    public static final /* synthetic */ int $anonfun$new$11(TierTasks $this) {
        return $this.tierArchiver().taskQueue().errorPartitionCount();
    }

    public static final /* synthetic */ int $anonfun$new$12(TierTasks $this) {
        return $this.tierDeletionManager().taskQueue().errorPartitionCount();
    }

    public static final /* synthetic */ int $anonfun$new$14(TierLogCleanerManager x$6) {
        return x$6.taskQueue().errorPartitionCount();
    }

    public static final /* synthetic */ int $anonfun$new$13(TierTasks $this) {
        return BoxesRunTime.unboxToInt($this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$14(x$6))).getOrElse(() -> 0));
    }

    public static final /* synthetic */ int $anonfun$new$17(TierMetadataSnapshotManager x$7) {
        return x$7.taskQueue().errorPartitionCount();
    }

    public static final /* synthetic */ int $anonfun$new$16(TierTasks $this) {
        return BoxesRunTime.unboxToInt($this.tierMetadataSnapshotManager().map((Function1<TierMetadataSnapshotManager, Object> & Serializable)x$7 -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$17(x$7))).getOrElse(() -> 0));
    }

    public static final /* synthetic */ int $anonfun$doWork$5(TierLogCleanerManager x$10) {
        return x$10.taskQueue().taskCount();
    }

    public static final /* synthetic */ int $anonfun$doWork$7(TierMetadataSnapshotManager x$11) {
        return x$11.taskQueue().taskCount();
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$1(SnapshotTasksConfig c) {
        return c.retentionDays().apply$mcI$sp() < 2;
    }

    public TierTasks(TierTasksConfig config, ReplicaManager replicaManager, TierReplicaManager tierReplicaManager, TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time, Option<DiskIOManager> diskIOManagerOpt) {
        Option option;
        Option option2;
        this.config = config;
        this.replicaManager = replicaManager;
        this.tierTopicAppender = tierTopicAppender;
        this.time = time;
        super("tier-tasks", HeartbeatingShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.lastLagPrintTimeMs = time.milliseconds();
        this.lastCompactionSummaryPrintTimeMs = time.milliseconds();
        this.lastTierDeletionsPendingMetricTimeMs = time.milliseconds();
        this.ctx = CancellationContext.newContext();
        this.archiveDeletionExecutor = Executors.newFixedThreadPool(this.config().numArchiverThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                return KafkaThread.nonDaemon((String)("TierTask-" + newThreadNum), (Runnable)r);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.kafka$tier$tasks$TierTasks$$cleanerThreads = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = None$.MODULE$;
        this.cleaningExecutor = Executors.newFixedThreadPool(this.config().numCleanerThreads(), new ThreadFactory(this){
            private final AtomicInteger threadNum;
            private final /* synthetic */ TierTasks $outer;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                KafkaThread thread = KafkaThread.nonDaemon((String)("TierCompactionTask-" + newThreadNum), (Runnable)r);
                this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().append(Predef$.MODULE$.long2Long(thread.getId()));
                this.$outer.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq(new Some<ThreadsCpuMeter>(new ThreadsCpuMeter(CollectionConverters$.MODULE$.BufferHasAsJava(this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads()).asJava())));
                return thread;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.snapshotExecutor = Executors.newFixedThreadPool(this.config().numSnapshotThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                return KafkaThread.nonDaemon((String)("TierSnapshotTask-" + newThreadNum), (Runnable)r);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.archiveDeletionPool = ExecutionContext$.MODULE$.fromExecutor(this.archiveDeletionExecutor());
        this.tierArchiver = new TierArchiver(this.config(), replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, time, diskIOManagerOpt, this.archiveDeletionPool());
        this.tierDeletionManager = new TierDeletionManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, this.archiveDeletionPool());
        if (this.config().tierCleanerFeatureEnable()) {
            ExecutionContextExecutor cleaningPool = ExecutionContext$.MODULE$.fromExecutor(this.cleaningExecutor());
            option2 = new Some<TierLogCleanerManager>(new TierLogCleanerManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, cleaningPool));
        } else {
            option2 = None$.MODULE$;
        }
        this.tierLogCleanerManager = option2;
        this.tierLogCleanerManager().foreach((Function1<TierLogCleanerManager, Object> & Serializable)x$1 -> {
            TierTasks.$anonfun$new$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        if (this.config().snapshotTaskConfig().isDefined()) {
            ExecutionContextExecutor snapshotPool = ExecutionContext$.MODULE$.fromExecutor(this.snapshotExecutor());
            option = new Some<TierMetadataSnapshotManager>(new TierMetadataSnapshotManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, snapshotPool));
        } else {
            option = None$.MODULE$;
        }
        this.tierMetadataSnapshotManager = option;
        this.tierTaskQueues = new ListBuffer();
        this.tierTaskQueues().$plus$plus$eq((IterableOnce)((IterableOps)new $colon$colon<Nothing$>((Nothing$)((Object)this.tierArchiver().taskQueue()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.tierDeletionManager().taskQueue()), Nil$.MODULE$)).$plus$plus((IterableOnce)this.tierLogCleanerManager().map((Function1<TierLogCleanerManager, CompactionTaskQueue> & Serializable)x$3 -> x$3.taskQueue()))).$plus$plus(this.tierMetadataSnapshotManager().map((Function1<TierMetadataSnapshotManager, MetadataSnapshotTaskQueue> & Serializable)x$4 -> x$4.taskQueue())));
        this.changeManager = new ChangeManager(this.ctx().subContext(), this.tierTaskQueues().toSeq(), time);
        this.metricsGroup().removeMetric("HeartbeatMs");
        this.metricsGroup().newGauge("HeartbeatMs", () -> BoxesRunTime.boxToLong(TierTasks.$anonfun$new$7(this)));
        this.metricsGroup().removeMetric("CyclesPerSec");
        this.cycleTimeMetric = this.metricsGroup().newMeter("CyclesPerSec", "tier tasks cycles per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("NumPartitionsInError");
        this.metricsGroup().newGauge("NumPartitionsInError", () -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$8(this)), Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringArchival");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringArchival", () -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$11(this)), Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringDeletion");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringDeletion", () -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$12(this)), Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringCompaction");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringCompaction", () -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$13(this)), Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringMetadataSnapshot");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringMetadataSnapshot", () -> BoxesRunTime.boxToInteger(TierTasks.$anonfun$new$16(this)), Collections.emptyMap());
        tierReplicaManager.addListener(this.changeManager());
        tierDeletedPartitionsCoordinator.registerListener(this.changeManager());
        Predef$.MODULE$.locally(BoxedUnit.UNIT);
    }
}

