/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.server.ReplicaManager;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUe\u0001\u0002\u001b6\u0005yB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0005\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005S\u000b\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003W\u0011!\u0019\u0007A!a\u0001\n\u0003!\u0007\u0002\u00035\u0001\u0005\u0003\u0007I\u0011A5\t\u0011I\u0004!\u0011!Q!\n\u0015D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\to\u0002\u0011)\u0019!C\u0001q\"AA\u0010\u0001B\u0001B\u0003%\u0011\u0010C\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u00111\u0017\u0001\u0005B\u0005UvaBAck!\u0005\u0011q\u0019\u0004\u0007iUB\t!!3\t\ru\u0004B\u0011AAi\u0011\u001d\tI\u0001\u0005C)\u0003\u0017Aq!a5\u0011\t\u0003\t)\u000e\u0003\u0005\u0002dB!\t!NAs\u0011!\t)\u0010\u0005C\u0001k\u0005]\b\u0002\u0003B\u000b!\u0011\u0005QGa\u0006\t\u0011\t-\u0002\u0003\"\u00016\u0005[A!B!\u0015\u0011#\u0003%\t!\u000eB*\u0011!\u0011I\u0007\u0005C\u0001k\t-\u0004\u0002\u0003BL!\u0011\u0005QG!'\t\u000f\t}\u0006\u0003\"\u0003\u0003B\u001a1!1\u001a\tA\u0005\u001bD!Ba=\u001d\u0005+\u0007I\u0011AA\u0006\u0011)\u0011)\u0010\bB\tB\u0003%\u0011Q\u0002\u0005\u000b\u0005od\"Q3A\u0005\u0002\te\bBCB\u00019\tE\t\u0015!\u0003\u0003|\"1Q\u0010\bC\u0001\u0007\u0007A\u0011b!\u0004\u001d\u0003\u0003%\taa\u0004\t\u0013\rUA$%A\u0005\u0002\r]\u0001\"CB\u000e9E\u0005I\u0011AB\u000f\u0011%\u0019\t\u0003HA\u0001\n\u0003\u001a\u0019\u0003\u0003\u0005\u0004&q\t\t\u0011\"\u0001y\u0011%\u00199\u0003HA\u0001\n\u0003\u0019I\u0003C\u0005\u00044q\t\t\u0011\"\u0011\u00046!I11\t\u000f\u0002\u0002\u0013\u00051Q\t\u0005\n\u0007\u0013b\u0012\u0011!C!\u0007\u0017B\u0011ba\u0014\u001d\u0003\u0003%\te!\u0015\t\u0013\rMC$!A\u0005B\rUs!CB-!\u0005\u0005\t\u0012AB.\r%\u0011Y\rEA\u0001\u0012\u0003\u0019i\u0006\u0003\u0004~]\u0011\u000511\u000f\u0005\n\u0003gs\u0013\u0011!C#\u0003kC\u0011\"a5/\u0003\u0003%\ti!\u001e\t\u0013\rmd&!A\u0005\u0002\u000eu\u0004\"CBF]\u0005\u0005I\u0011BBG\u0005-\t%o\u00195jm\u0016$\u0016m]6\u000b\u0005Y:\u0014aB1sG\"Lg/\u001a\u0006\u0003qe\nQ\u0001^1tWNT!AO\u001e\u0002\tQLWM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001@\u000bB\u0019\u0001)Q\"\u000e\u0003]J!AQ\u001c\u0003\u0011QKWM\u001d+bg.\u0004\"\u0001\u0012\u0001\u000e\u0003U\u0002\"AR%\u000e\u0003\u001dS!\u0001S\u001e\u0002\u000bU$\u0018\u000e\\:\n\u0005);%a\u0002'pO\u001eLgnZ\u0001\u0004GRDX#A'\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0014a\u00024fi\u000eDWM]\u0005\u0003%>\u00131cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\fAa\u0019;yA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002-B\u0011q\u000bY\u0007\u00021*\u0011!(\u0017\u0006\u00035n\u000bqa\u001d;pe\u0006<WM\u0003\u0002=9*\u0011QLX\u0001\nG>tg\r\\;f]RT\u0011aX\u0001\u0003S>L!!\u0019-\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005)1\u000f^1uKV\tQ\r\u0005\u0002EM&\u0011q-\u000e\u0002\u0011\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8n\u0015;bi\u0016\f\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005)\u0004\bCA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'\u0001B+oSRDq!\u001d\u0004\u0002\u0002\u0003\u0007Q-A\u0002yIE\naa\u001d;bi\u0016\u0004\u0013aD1sG\"Lg/\u001a:NKR\u0014\u0018nY:\u0011\u0005\u0011+\u0018B\u0001<6\u0005=\t%o\u00195jm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003e\u0004\"a\u001b>\n\u0005md'aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\r{\u0018\u0011AA\u0002\u0003\u000b\t9\u0001C\u0003L\u0017\u0001\u0007Q\nC\u0003U\u0017\u0001\u0007a\u000bC\u0003d\u0017\u0001\u0007Q\rC\u0003t\u0017\u0001\u0007A\u000fC\u0003x\u0017\u0001\u0007\u00110\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!\u0004\u0011\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tI\u0002E\u0002\u0002\u00141l!!!\u0006\u000b\u0007\u0005]Q(\u0001\u0004=e>|GOP\u0005\u0004\u00037a\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"AB*ue&twMC\u0002\u0002\u001c1\f!\u0002\u001e:b]NLG/[8o)9\t9#a\u0010\u0002\\\u0005-\u00141PAF\u00033#B!!\u000b\u00026A)\u00111FA\u0019\u00076\u0011\u0011Q\u0006\u0006\u0004\u0003_a\u0017AC2p]\u000e,(O]3oi&!\u00111GA\u0017\u0005\u00191U\u000f^;sK\"9\u0011qG\u0007A\u0004\u0005e\u0012AA3d!\u0011\tY#a\u000f\n\t\u0005u\u0012Q\u0006\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\u0011\u000e\u0001\u0004\t\u0019%\u0001\u0003uS6,\u0007\u0003BA#\u0003/j!!a\u0012\u000b\u0007!\u000bIE\u0003\u0003\u0002L\u00055\u0013AB2p[6|gNC\u0002=\u0003\u001fRA!!\u0015\u0002T\u00051\u0011\r]1dQ\u0016T!!!\u0016\u0002\u0007=\u0014x-\u0003\u0003\u0002Z\u0005\u001d#\u0001\u0002+j[\u0016Dq!!\u0018\u000e\u0001\u0004\ty&A\tuS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003KJ\u0014!\u0002;pa&\u001c\u0017\u0002BA5\u0003G\u0012\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s\u0011\u001d\ti'\u0004a\u0001\u0003_\nq\u0002^5fe>\u0013'.Z2u'R|'/\u001a\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO\u001d\u0002\u000bM$xN]3\n\t\u0005e\u00141\u000f\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\"9\u0011QP\u0007A\u0002\u0005}\u0014A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011QQ\u001e\u0002\rM,'O^3s\u0013\u0011\tI)a!\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"9\u0011QR\u0007A\u0002\u0005=\u0015AB2p]\u001aLw\r\u0005\u0003\u0002\u0012\u0006UUBAAJ\u0015\r\tiiN\u0005\u0005\u0003/\u000b\u0019JA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0011\u001d\tY*\u0004a\u0001\u0003;\u000b\u0011\u0002\u001e5s_R$H.\u001a:\u0011\u000b-\fy*a)\n\u0007\u0005\u0005FN\u0001\u0004PaRLwN\u001c\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*\u0019\u0001*!+\u000b\t\u0005-\u0016QV\u0001\nS:$XM\u001d8bYNT1AWA'\u0013\u0011\t\t,a*\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0006\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0006!!.\u0019<b\u0013\u0011\ty\"a/\u0002\u0017\u0005\u00138\r[5wKR\u000b7o\u001b\t\u0003\tB\u0019B\u0001EAf\u000bB\u00191.!4\n\u0007\u0005=GN\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u000f\fQ!\u00199qYf$2bQAl\u00033\fY.a8\u0002b\")1j\u0005a\u0001\u001b\")Ak\u0005a\u0001-\"1\u0011Q\\\nA\u0002e\f1\u0002\\3bI\u0016\u0014X\t]8dQ\")1o\u0005a\u0001i\")qo\u0005a\u0001s\u0006\u00012\r[3dW\u001a\u000b\u0017\u000e\\3e'R\fG/\u001a\u000b\t\u0003O\fI/!=\u0002tB)\u00111FA\u0019K\"11\r\u0006a\u0001\u0003W\u00042\u0001RAw\u0013\r\ty/\u000e\u0002\f\r\u0006LG.\u001a3Ti\u0006$X\rC\u0003U)\u0001\u0007a\u000bC\u0004\u0002~Q\u0001\r!a \u0002'\u0015\u001cH/\u00192mSNDG*Z1eKJ\u001c\b.\u001b9\u0015\u0019\u0005e(Q\u0001B\u0007\u0005\u001f\u0011\tBa\u0005\u0015\t\u0005m(1\u0001\t\u0007\u0003W\t\t$!@\u0011\u0007\u0011\u000by0C\u0002\u0003\u0002U\u0012ABQ3g_J,W\u000b\u001d7pC\u0012Dq!a\u000e\u0016\u0001\b\tI\u0004\u0003\u0004d+\u0001\u0007!q\u0001\t\u0004\t\n%\u0011b\u0001B\u0006k\ta!)\u001a4pe\u0016dU-\u00193fe\")A+\u0006a\u0001-\"9\u0011QL\u000bA\u0002\u0005}\u0003\"B<\u0016\u0001\u0004I\bbBA?+\u0001\u0007\u0011qP\u0001\u0014[\u0006L(-Z%oSRL\u0017\r^3Va2|\u0017\r\u001a\u000b\u0011\u00053\u0011iBa\b\u0003\"\t\r\"Q\u0005B\u0014\u0005S!B!a:\u0003\u001c!9\u0011q\u0007\fA\u0004\u0005e\u0002BB2\u0017\u0001\u0004\ti\u0010C\u0003U-\u0001\u0007a\u000bC\u0004\u0002BY\u0001\r!a\u0011\t\u000f\u0005uc\u00031\u0001\u0002`!9\u0011Q\u000e\fA\u0002\u0005=\u0004bBA?-\u0001\u0007\u0011q\u0010\u0005\b\u0003\u001b3\u0002\u0019AAH\u0003\u0019)\b\u000f\\8bIR\u0001\"q\u0006B\u001e\u0005\u0007\u0012)Ea\u0012\u0003J\t-#q\n\u000b\u0005\u0005c\u0011I\u0004\u0005\u0004\u0002,\u0005E\"1\u0007\t\u0004\t\nU\u0012b\u0001B\u001ck\tY\u0011I\u001a;feV\u0003Hn\\1e\u0011\u001d\t9d\u0006a\u0002\u0003sAaaY\fA\u0002\tu\u0002c\u0001#\u0003@%\u0019!\u0011I\u001b\u0003\rU\u0003Hn\\1e\u0011\u0015!v\u00031\u0001W\u0011\u001d\t\te\u0006a\u0001\u0003\u0007BQaS\fA\u00025Cq!!\u001c\u0018\u0001\u0004\ty\u0007C\u0005\u0003N]\u0001\n\u00111\u0001\u0002\u001e\u0006aA\u000f\u001b:piRdWM](qi\"9\u0011QR\fA\u0002\u0005=\u0015\u0001E;qY>\fG\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011)F\u000b\u0003\u0002\u001e\n]3F\u0001B-!\u0011\u0011YF!\u001a\u000e\u0005\tu#\u0002\u0002B0\u0005C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\rD.\u0001\u0006b]:|G/\u0019;j_:LAAa\u001a\u0003^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\u0019Lg.\u00197ju\u0016,\u0006\u000f\\8bIRa!Q\u000eB9\u0005g\u0012)Ha\u001e\u0003zQ!\u00111 B8\u0011\u001d\t9$\u0007a\u0002\u0003sAaaY\rA\u0002\tM\u0002\"\u0002+\u001a\u0001\u00041\u0006bBA!3\u0001\u0007\u00111\t\u0005\b\u0003;J\u0002\u0019AA0\u0011\u001d\u0011Y(\u0007a\u0001\u0005{\naBY=uKJ\u000bG/Z'fiJL7\rE\u0003l\u0003?\u0013y\b\u0005\u0003\u0003\u0002\nMUB\u0001BB\u0015\u0011\u0011)Ia\"\u0002\t\r|'/\u001a\u0006\u0005\u0005\u0013\u0013Y)A\u0004nKR\u0014\u0018nY:\u000b\t\t5%qR\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\tE\u0015aA2p[&!!Q\u0013BB\u0005\u0015iU\r^3s\u0003E)\b\u000f\\8bI\u0006\u0014G.Z*fO6,g\u000e\u001e\u000b\t\u00057\u00139Ka,\u0003>B!!Q\u0014BR\u001b\t\u0011yJC\u0002\u0003\"f\u000b1\u0001\\8h\u0013\u0011\u0011)Ka(\u0003#U\u0003Hn\\1eC\ndWmU3h[\u0016tG\u000fC\u0004\u0003\"j\u0001\rA!+\u0011\t\tu%1V\u0005\u0005\u0005[\u0013yJA\u0006BEN$(/Y2u\u0019><\u0007b\u0002BY5\u0001\u0007!1W\u0001\u000bY><7+Z4nK:$\b\u0003\u0002B[\u0005sk!Aa.\u000b\t\t\u0005\u0016\u0011V\u0005\u0005\u0005w\u00139L\u0001\u0006M_\u001e\u001cVmZ7f]RDQ\u0001\u0016\u000eA\u0002Y\u000b\u0011c]3h[\u0016tGOR5mKN,\u00050[:u)\u0011\u0011\u0019M!3\u0011\u0007-\u0014)-C\u0002\u0003H2\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0003\u0018n\u0001\rAa'\u0003/M+w-\\3oi\u0012+G.\u001a;fI\u0016C8-\u001a9uS>t7c\u0002\u000f\u0003P\nm'\u0011\u001d\t\u0005\u0005#\u00149.\u0004\u0002\u0003T*!!Q[A%\u0003\u0019)'O]8sg&!!\u0011\u001cBj\u0005I\u0011V\r\u001e:jC\ndW-\u0012=dKB$\u0018n\u001c8\u0011\u0007-\u0014i.C\u0002\u0003`2\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003d\n5h\u0002\u0002Bs\u0005StA!a\u0005\u0003h&\tQ.C\u0002\u0003l2\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003p\nE(\u0001D*fe&\fG.\u001b>bE2,'b\u0001BvY\u0006\u0019Qn]4\u0002\t5\u001cx\rI\u0001\u0006G\u0006,8/Z\u000b\u0003\u0005w\u0004BAa9\u0003~&!!q By\u0005%!\u0006N]8xC\ndW-\u0001\u0004dCV\u001cX\r\t\u000b\u0007\u0007\u000b\u0019Iaa\u0003\u0011\u0007\r\u001dA$D\u0001\u0011\u0011\u001d\u0011\u00190\ta\u0001\u0003\u001bAqAa>\"\u0001\u0004\u0011Y0\u0001\u0003d_BLHCBB\u0003\u0007#\u0019\u0019\u0002C\u0005\u0003t\n\u0002\n\u00111\u0001\u0002\u000e!I!q\u001f\u0012\u0011\u0002\u0003\u0007!1`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019IB\u000b\u0003\u0002\u000e\t]\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007?QCAa?\u0003X\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a.\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!11FB\u0019!\rY7QF\u0005\u0004\u0007_a'aA!os\"9\u0011oJA\u0001\u0002\u0004I\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r]\u0002CBB\u001d\u0007\u007f\u0019Y#\u0004\u0002\u0004<)\u00191Q\b7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004B\rm\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa1\u0004H!A\u0011/KA\u0001\u0002\u0004\u0019Y#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\\\u0007\u001bBq!\u001d\u0016\u0002\u0002\u0003\u0007\u00110\u0001\u0005iCND7i\u001c3f)\u0005I\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003D\u000e]\u0003\u0002C9-\u0003\u0003\u0005\raa\u000b\u0002/M+w-\\3oi\u0012+G.\u001a;fI\u0016C8-\u001a9uS>t\u0007cAB\u0004]M)afa\u0018\u0004lAQ1\u0011MB4\u0003\u001b\u0011Yp!\u0002\u000e\u0005\r\r$bAB3Y\u00069!/\u001e8uS6,\u0017\u0002BB5\u0007G\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019ig!\u001d\u000e\u0005\r=$bA0\u0002@&!!q^B8)\t\u0019Y\u0006\u0006\u0004\u0004\u0006\r]4\u0011\u0010\u0005\b\u0005g\f\u0004\u0019AA\u0007\u0011\u001d\u001190\ra\u0001\u0005w\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0000\r\u001d\u0005#B6\u0002 \u000e\u0005\u0005cB6\u0004\u0004\u00065!1`\u0005\u0004\u0007\u000bc'A\u0002+va2,'\u0007C\u0005\u0004\nJ\n\t\u00111\u0001\u0004\u0006\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r=\u0005\u0003BA]\u0007#KAaa%\u0002<\n1qJ\u00196fGR\u0004")
public final class ArchiveTask
extends TierTask<ArchiveTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private ArchiveTaskState state;
    public final ArchiverMetrics kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics;
    private final int brokerId;

    public static ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return ArchiveTask$.MODULE$.apply(ctx, topicIdPartition, leaderEpoch, archiverMetrics, brokerId);
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ArchiveTaskState state() {
        return this.state;
    }

    public void state_$eq(ArchiveTaskState x$1) {
        this.state = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    @Override
    public Future<ArchiveTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        Future<ArchiveTaskState> future;
        if (this.ctx().isCancelled()) {
            future = Future$.MODULE$.successful(this.state());
        } else {
            ArchiveTaskState archiveTaskState = this.state();
            if (archiveTaskState instanceof BeforeLeader) {
                BeforeLeader beforeLeader = (BeforeLeader)archiveTaskState;
                future = ArchiveTask$.MODULE$.establishLeadership(beforeLeader, this.topicIdPartition(), tierTopicAppender, this.brokerId(), replicaManager, ec);
            } else if (archiveTaskState instanceof BeforeUpload) {
                BeforeUpload beforeUpload = (BeforeUpload)archiveTaskState;
                future = ArchiveTask$.MODULE$.maybeInitiateUpload(beforeUpload, this.topicIdPartition(), time, tierTopicAppender, tierObjectStore, replicaManager, config, ec);
            } else if (archiveTaskState instanceof Upload) {
                Upload upload = (Upload)archiveTaskState;
                future = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), time, this.ctx(), tierObjectStore, throttler, config, ec);
            } else if (archiveTaskState instanceof AfterUpload) {
                AfterUpload afterUpload = (AfterUpload)archiveTaskState;
                future = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), time, tierTopicAppender, this.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.byteRateOpt(), ec);
            } else if (archiveTaskState instanceof FailedState) {
                FailedState failedState = (FailedState)archiveTaskState;
                future = ArchiveTask$.MODULE$.checkFailedState(failedState, this.topicIdPartition(), replicaManager);
            } else {
                throw new MatchError(archiveTaskState);
            }
        }
        Future<ArchiveTaskState> newState = future;
        return newState.map((Function1<ArchiveTaskState, ArchiveTask> & Serializable)result -> {
            this.onSuccessfulTransition();
            this.state_$eq((ArchiveTaskState)result);
            return this;
        }, ec).recover(new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)A1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)A1);
                    this.$outer.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.exceptionsRateOpt().foreach((Function1<Meter, Object> & Serializable)x$1 -> {
                        $anonfun$transition$2.$anonfun$applyOrElse$1(x$1);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierArchiverFailedException) {
                    TierArchiverFailedException tierArchiverFailedException = (TierArchiverFailedException)A1;
                    this.$outer.warn((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " failed, pausing archival process and marking " + $this.$outer.topicIdPartition() + " to be in error", (Function0<Throwable>)(Function0<TierArchiverFailedException> & Serializable)() -> tierArchiverFailedException);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierArchiverFailedException);
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierArchiverRestoreFencedException) {
                    this.$outer.debug((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " encountered metadata fencing due to state restoration");
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierArchiverFencedException) {
                    TierArchiverFencedException tierArchiverFencedException = (TierArchiverFencedException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " was fenced, stopping archival process", (Function0<Throwable>)(Function0<TierArchiverFencedException> & Serializable)() -> tierArchiverFencedException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " is not tierable and cannot be archived", (Function0<Throwable>)(Function0<NotTierablePartitionException> & Serializable)() -> notTierablePartitionException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof SegmentDeletedException) {
                    SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)A1);
                    this.$outer.state_$eq(this.$outer.state().handleSegmentDeletedException(segmentDeletedException));
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)segmentDeletedException));
                    return (B1)this.$outer;
                }
                if (A1 instanceof E2EChecksumInvalidException) {
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)A1;
                    this.$outer.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics.e2eChecksumInvalidCount().foreach((Function1<Counter, Object> & Serializable)x$2 -> {
                        $anonfun$transition$2.$anonfun$applyOrElse$9(x$2);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.error((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " failed due to E2E Checksum mismatch, stopping archival process and marking " + $this.$outer.topicIdPartition() + " to be in error", (Function0<Throwable>)(Function0<E2EChecksumInvalidException> & Serializable)() -> e2EChecksumInvalidException);
                    this.$outer.cancelAndSetErrorState(e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.error((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " failed due to unhandled exception, stopping archival process and marking " + $this.$outer.topicIdPartition() + " to be in error", (Function0<Throwable> & Serializable)() -> A12);
                    this.$outer.cancelAndSetErrorState(A12);
                    return (B1)this.$outer;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (throwable instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (throwable instanceof TierArchiverFailedException) {
                    return true;
                }
                if (throwable instanceof TierArchiverRestoreFencedException) {
                    return true;
                }
                if (throwable instanceof TierArchiverFencedException) {
                    return true;
                }
                if (throwable instanceof NotTierablePartitionException) {
                    return true;
                }
                if (throwable instanceof SegmentDeletedException) {
                    return true;
                }
                if (throwable instanceof E2EChecksumInvalidException) {
                    return true;
                }
                return throwable != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(Meter x$1) {
                x$1.mark();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Counter x$2) {
                x$2.inc();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.yammer.metrics.core.Meter ), $anonfun$applyOrElse$10(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$11(kafka.tier.exceptions.E2EChecksumInvalidException ), $anonfun$applyOrElse$12(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$13(java.lang.Throwable ), $anonfun$applyOrElse$2(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$3(kafka.tier.exceptions.TierArchiverFailedException ), $anonfun$applyOrElse$4(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$5(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$6(kafka.tier.exceptions.TierArchiverFencedException ), $anonfun$applyOrElse$7(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$8(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$9$adapted(com.yammer.metrics.core.Counter )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return "ArchiveTask(" + this.topicIdPartition() + ", state=" + this.state().getClass().getName() + ", epoch=" + this.state().leaderEpoch() + ", cancelled=" + this.ctx().isCancelled() + ")";
    }

    public ArchiveTask(CancellationContext ctx, TopicIdPartition topicIdPartition, ArchiveTaskState state, ArchiverMetrics archiverMetrics, int brokerId) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.kafka$tier$tasks$archive$ArchiveTask$$archiverMetrics = archiverMetrics;
        this.brokerId = brokerId;
        super(archiverMetrics.retryRateOpt());
    }

    public static class SegmentDeletedException
    extends RetriableException
    implements Product {
        private final String msg;
        private final Throwable cause;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public String msg() {
            return this.msg;
        }

        public Throwable cause() {
            return this.cause;
        }

        public SegmentDeletedException copy(String msg, Throwable cause) {
            return new SegmentDeletedException(msg, cause);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        @Override
        public String productPrefix() {
            return "SegmentDeletedException";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.msg();
                }
                case 1: {
                    return this.cause();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof SegmentDeletedException;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "cause";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SegmentDeletedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            SegmentDeletedException segmentDeletedException = (SegmentDeletedException)x$1;
            String string = this.msg();
            String string2 = segmentDeletedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = segmentDeletedException.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!segmentDeletedException.canEqual(this)) return false;
            return true;
        }

        public SegmentDeletedException(String msg, Throwable cause) {
            this.msg = msg;
            this.cause = cause;
            super(msg, cause);
            Product.$init$(this);
        }
    }
}

