/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import io.confluent.kafka.storage.log.TierLogSegment;
import java.nio.ByteBuffer;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter$;
import org.apache.kafka.storage.internals.log.LogSegmentReadAdapter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ur!B\u000b\u0017\u0011\u0003yb!B\u0011\u0017\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u0017\u00019B\u0001B\u0012\u0003\u0003\u0006\u0004%\ta\u0012\u0005\t'\u0012\u0011\t\u0011)A\u0005\u0011\"AA\u000b\u0002BC\u0002\u0013\u0005Q\u000b\u0003\u0005]\t\t\u0005\t\u0015!\u0003W\u0011!iFA!b\u0001\n\u0003q\u0006\u0002C3\u0005\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0019$!\u0011!Q\u0001\n\u001dDQ!\u000b\u0003\u0005\u0002)Dqa\u001c\u0003C\u0002\u0013%\u0001\u000f\u0003\u0004u\t\u0001\u0006I!\u001d\u0005\u0006k\u0012!\tE\u001e\u0005\u0006u\u0012!\tE\u001e\u0005\u0006w\u0012!\t\u0005 \u0005\u0006{\u0012!\t\u0005 \u0005\u0006}\u0012!\te \u0005\b\u00037!A\u0011IA\u000f\u0003e!\u0016.\u001a:M_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\u000b\u0005]A\u0012AC2p[B\f7\r^5p]*\u0011\u0011DG\u0001\u0006i\u0006\u001c8n\u001d\u0006\u00037q\tA\u0001^5fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\f\u00033QKWM\u001d'pON+w-\\3oiJ+\u0017\rZ!eCB$XM]\n\u0003\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 \u0003\u0015\t\u0007\u000f\u001d7z)%i\u0013QGA\u001c\u0003s\tY\u0004\u0005\u0002!\tM\u0019AaL\u001c\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00027b]\u001eT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\t1qJ\u00196fGR\u0004\"\u0001\u000f#\u000e\u0003eR!AO\u001e\u0002\u00071|wM\u0003\u0002={\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003}}\nqa\u001d;pe\u0006<WM\u0003\u0002\u001e\u0001*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0013\t)\u0015HA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\u0002\u000fM,w-\\3oiV\t\u0001\n\u0005\u0002J#6\t!J\u0003\u0002;\u0017*\u0011a\b\u0014\u0006\u0003;5S!AT(\u0002\u0013\r|gN\u001a7vK:$(\"\u0001)\u0002\u0005%|\u0017B\u0001*K\u00059!\u0016.\u001a:M_\u001e\u001cVmZ7f]R\f\u0001b]3h[\u0016tG\u000fI\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z5\u0005)1\u000f^8sK&\u00111\f\u0017\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u0001B/[3s\u001f\nTWm\u0019;Ti>\u0014X\rI\u0001\u0014G\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!MG\u0001\bM\u0016$8\r[3s\u0013\t!\u0017MA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u000bdC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH\u000fI\u0001\fe\u0016$(/\u001f)pY&\u001c\u0017\u0010\u0005\u0002XQ&\u0011\u0011\u000e\u0017\u0002\u001b)&,'o\u00142kK\u000e$8\u000b^8sKJ+GO]=Q_2L7-\u001f\u000b\u0006[-dWN\u001c\u0005\u0006\r2\u0001\r\u0001\u0013\u0005\u0006)2\u0001\rA\u0016\u0005\u0006;2\u0001\ra\u0018\u0005\u0006M2\u0001\raZ\u0001\tgR\f'\u000f\u001e)pgV\t\u0011\u000f\u0005\u0002%e&\u00111/\n\u0002\u0004\u0013:$\u0018!C:uCJ$\bk\\:!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u000b\u0002oB\u0011A\u0005_\u0005\u0003s\u0016\u0012A\u0001T8oO\u0006IQM\u001c3PM\u001a\u001cX\r^\u0001\u000egR\f'\u000f\u001e)pg&$\u0018n\u001c8\u0015\u0003E\f1\"\u001a8e!>\u001c\u0018\u000e^5p]\u0006I!/Z1e\u0005f$Xm\u001d\u000b\u0007\u0003\u0003\t9!a\u0006\u0011\u0007\u0011\n\u0019!C\u0002\u0002\u0006\u0015\u0012A!\u00168ji\"9\u0011\u0011B\nA\u0002\u0005-\u0011A\u00022vM\u001a,'\u000f\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbM\u0001\u0004]&|\u0017\u0002BA\u000b\u0003\u001f\u0011!BQ=uK\n+hMZ3s\u0011\u0019\tIb\u0005a\u0001c\u0006A\u0001o\\:ji&|g.\u0001\u0005u_N#(/\u001b8h)\t\ty\u0002\u0005\u0003\u0002\"\u0005=b\u0002BA\u0012\u0003W\u00012!!\n&\u001b\t\t9CC\u0002\u0002*y\ta\u0001\u0010:p_Rt\u0014bAA\u0017K\u00051\u0001K]3eK\u001aLA!!\r\u00024\t11\u000b\u001e:j]\u001eT1!!\f&\u0011\u001515\u00011\u0001I\u0011\u0015!6\u00011\u0001W\u0011\u0015i6\u00011\u0001`\u0011\u001517\u00011\u0001h\u0001")
public class TierLogSegmentReadAdapter
implements LogSegmentReadAdapter {
    private final TierLogSegment segment;
    private final TierObjectStore tierObjectStore;
    private final CancellationContext cancellationContext;
    private final TierObjectStoreRetryPolicy retryPolicy;
    private final int startPos;

    public static TierLogSegmentReadAdapter apply(TierLogSegment segment, TierObjectStore tierObjectStore, CancellationContext cancellationContext, TierObjectStoreRetryPolicy retryPolicy) {
        return TierLogSegmentReadAdapter$.MODULE$.apply(segment, tierObjectStore, cancellationContext, retryPolicy);
    }

    public TierLogSegment segment() {
        return this.segment;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public CancellationContext cancellationContext() {
        return this.cancellationContext;
    }

    private int startPos() {
        return this.startPos;
    }

    @Override
    public long baseOffset() {
        return this.segment().baseOffset();
    }

    @Override
    public long endOffset() {
        return this.segment().endOffset();
    }

    @Override
    public int startPosition() {
        return this.startPos();
    }

    @Override
    public int endPosition() {
        return this.segment().size();
    }

    @Override
    public void readBytes(ByteBuffer buffer, int position) {
        if (position < this.startPosition() || position > this.endPosition()) {
            throw new IllegalArgumentException("Invalid position: " + position + ". Valid position range is [" + this.startPosition() + ", " + this.endPosition() + "]");
        }
        TierLogCompactionUtils$.MODULE$.readSegment(this.segment(), this.tierObjectStore(), position, buffer, this.cancellationContext(), this.retryPolicy);
    }

    public String toString() {
        return "TierLogSegmentReadAdapter(log segment: " + this.segment() + ", startPosition: " + this.startPosition() + ", endPosition: " + this.endPosition() + ", baseOffset: " + this.baseOffset() + ", endOffset: " + this.endOffset() + ")";
    }

    public TierLogSegmentReadAdapter(TierLogSegment segment, TierObjectStore tierObjectStore, CancellationContext cancellationContext, TierObjectStoreRetryPolicy retryPolicy) {
        this.segment = segment;
        this.tierObjectStore = tierObjectStore;
        this.cancellationContext = cancellationContext;
        this.retryPolicy = retryPolicy;
        this.startPos = segment.baseOffset() == segment.objectBaseOffset() ? 0 : TierLogCompactionUtils$.MODULE$.startingPosition(segment, tierObjectStore, cancellationContext, retryPolicy);
    }
}

