/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentDeleteComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentDeleteInitiate;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.tier.exceptions.TierDeletionFailedException;
import kafka.tier.exceptions.TierDeletionFencedException;
import kafka.tier.exceptions.TierDeletionFencedException$;
import kafka.tier.exceptions.TierDeletionRestoreFencedException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeletionTask$
implements Logging {
    public static final DeletionTask$ MODULE$ = new DeletionTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DeletionTask$ deletionTask$ = this;
        synchronized (deletionTask$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return DeletionTask.class.getName();
    }

    public void kafka$tier$tasks$delete$DeletionTask$$garbageCollectAllSnapshots(TopicIdPartition topicIdPartition, TierObjectStore tierObjectStore) {
        String snapshotPrefix = TierPartitionStateSnapshotMetadata.pathPrefix("", topicIdPartition);
        Map<String, List<VersionInformation>> allSnapshots = tierObjectStore.listObject(snapshotPrefix, false);
        List<TierObjectStore.KeyAndVersion> snapshotsToDelete = allSnapshots.keySet().stream().map(snapshotPath -> new TierObjectStore.KeyAndVersion((String)snapshotPath)).collect(Collectors.toList());
        if (snapshotsToDelete.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "No snapshot to delete for the deleted partition " + topicIdPartition);
            return;
        }
        StringBuilder sb = new StringBuilder("Following snapshots are to be deleted for the deleted partition: " + topicIdPartition + "\n");
        snapshotsToDelete.forEach(kv -> sb.append(kv.key()).append(" "));
        this.info((Function0<String> & Serializable)() -> sb.toString());
        tierObjectStore.deleteVersions(snapshotsToDelete);
    }

    public String kafka$tier$tasks$delete$DeletionTask$$printableSegmentDeletions(Iterable<ObjectMetadata> toDelete) {
        return ((IterableOnceOps)toDelete.map((Function1<ObjectMetadata, Tuple2> & Serializable)metadata -> new Tuple2<Long, String>(BoxesRunTime.boxToLong(metadata.baseOffset()), metadata.objectIdAsBase64()))).mkString(",");
    }

    public long getDelayFromLogConfig(Option<AbstractLog> log) {
        return BoxesRunTime.unboxToLong(log.map((Function1<AbstractLog, Object> & Serializable)x$16 -> BoxesRunTime.boxToLong(x$16.config().fileDeleteDelayMs)).getOrElse(() -> 0L));
    }

    public Future<BoxedUnit> writeDeletionInitiatedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, Optional<OffsetAndEpoch> stateOffset, ObjectMetadata segment, Time time, ExecutionContext ec) {
        TierSegmentDeleteInitiate marker = new TierSegmentDeleteInitiate(segment.topicIdPartition(), leaderEpoch, segment.objectId(), stateOffset);
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writeDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, Optional<OffsetAndEpoch> stateOffset, ObjectMetadata objectMetadata, Time time, ExecutionContext ec) {
        TierSegmentDeleteComplete marker = new TierSegmentDeleteComplete(objectMetadata.topicIdPartition(), leaderEpoch, objectMetadata.objectId(), stateOffset);
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writePartitionDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, Time time, ExecutionContext ec) {
        TierPartitionDeleteComplete marker = new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID());
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writeMarker(TierTopicAppender tierTopicAppender, AbstractTierMetadata marker, Time time, ExecutionContext ec) {
        long startTimeMs = time.milliseconds();
        this.info((Function0<String> & Serializable)() -> "Emitting " + marker + " for " + marker.topicIdPartition());
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(marker))).map((Function1<TierPartitionState.AppendResult, Object> & Serializable)appendResult -> {
            DeletionTask$.$anonfun$writeMarker$2(marker, time, startTimeMs, appendResult);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ void $anonfun$writeMarker$2(AbstractTierMetadata marker$1, Time time$2, long startTimeMs$1, TierPartitionState.AppendResult appendResult) {
        TierPartitionState.AppendResult appendResult2 = appendResult;
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult2)) {
            MODULE$.info((Function0<String> & Serializable)() -> "Completed " + marker$1 + " for " + marker$1.topicIdPartition() + " in " + (time$2.milliseconds() - startTimeMs$1) + "ms");
            return;
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult2)) {
            MODULE$.info((Function0<String> & Serializable)() -> "Stopping state machine for " + marker$1.topicIdPartition() + " as attempt to transition was fenced");
            throw new TierDeletionFencedException(marker$1.topicIdPartition(), TierDeletionFencedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult2)) {
            MODULE$.warn((Function0<String> & Serializable)() -> "Stopping state machine for " + marker$1.topicIdPartition() + " as attempt to transition failed");
            throw new TierDeletionFailedException(marker$1.topicIdPartition());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult2)) {
            throw new TierDeletionRestoreFencedException(marker$1.topicIdPartition());
        }
        throw new IllegalStateException("Unexpected append result for " + marker$1.topicIdPartition() + ": " + appendResult);
    }

    private DeletionTask$() {
    }
}

