/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.tools.TierToolsUtils;
import kafka.tier.tools.commands.GetTierRecoveryDataUploadJobResultCommandResponse;
import kafka.tier.tools.commands.InitiateTierRecoveryDataUploadCommandResponse;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public final class InitiateTierRecoveryDataUploadCommand {
    static final String COMMAND = "initiate-tier-recovery-data-upload";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTIFIER_DOC = "Unique identifier representing the recovery upload job.";
    private static final Integer DEFAULT_NUM_THREADS = 4;
    private static final String NUM_THREADS_OVERRIDE = "num-threads-override";
    private static final String NUM_THREADS_OVERRIDE_DOC = String.format("Number of threads required to upload the recovery data. Defaults to %d, but we should not use a non-default value unless absolutely necessary.", DEFAULT_NUM_THREADS);
    private static final String RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT = "reconciled-data-loss-validator-output";
    private static final String RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC = "Name of the file that contains the reconciled output of data loss validator.";
    private static final String NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT = "nonreconciled-data-loss-validator-output";
    private static final String NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC = "Name of the file that contains the output of the data loss validator.";
    private static final String AFFECTED_TOPIC_PARTITIONS = "affected-topic-partitions";
    private static final String AFFECTED_TOPIC_PARTITIONS_DOC = "Name of the file that contains the list of affected topic partitions.";
    private static final String WAIT = "wait-completion-sec";
    private static final String WAIT_DOC = "Waits for the recovery data upload command to complete on the specified brokers for the provided time duration.If not provided, by default, will wait infinitely for the recovery data upload command to complete on the specified brokers.";
    private static final String NO_WAIT = "no-wait";
    private static final String NO_WAIT_DOC = "When provided, will not wait for the recovery data upload operation to complete.";

    static void addCommand(Subparsers subparsers) {
        Subparser tierRecoveryDataUpload = subparsers.addParser(COMMAND).help("Upload the FTPS, tier.offsets, and upload metadata to the object store.");
        MutuallyExclusiveGroup runScopeGroup = tierRecoveryDataUpload.addMutuallyExclusiveGroup().required(true);
        runScopeGroup.addArgument(RecoveryUtils.makeArgument("broker-ids")).dest("broker-ids").action(Arguments.store()).type(String.class).help("Runs the operation only on the specified brokers supplied as a comma-separated list. (i.e., 0,1,2,3)");
        runScopeGroup.addArgument(RecoveryUtils.makeArgument("all-brokers")).dest("all-brokers").action(Arguments.storeTrue()).help("Runs the operation for all brokers in the cluster");
        tierRecoveryDataUpload.addArgument(RecoveryUtils.makeArgument("rest-server-port-override")).dest("rest-server-port-override").action(Arguments.store()).type(Integer.class).setDefault(TierToolsUtils.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierToolsUtils.REST_SERVER_PORT_OVERRIDE_DOC);
        tierRecoveryDataUpload.addArgument(RecoveryUtils.makeArgument(IDENTIFIER)).required(true).dest(IDENTIFIER).action(Arguments.store()).type(String.class).help(IDENTIFIER_DOC);
        tierRecoveryDataUpload.addArgument(RecoveryUtils.makeArgument(NUM_THREADS_OVERRIDE)).setDefault(DEFAULT_NUM_THREADS).dest(NUM_THREADS_OVERRIDE).action(Arguments.store()).type(Integer.class).help(NUM_THREADS_OVERRIDE_DOC);
        MutuallyExclusiveGroup inputDataGroup = tierRecoveryDataUpload.addMutuallyExclusiveGroup().required(true);
        inputDataGroup.addArgument(RecoveryUtils.makeArgument(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT)).dest(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC);
        inputDataGroup.addArgument(RecoveryUtils.makeArgument(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT)).dest(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC);
        inputDataGroup.addArgument(RecoveryUtils.makeArgument(AFFECTED_TOPIC_PARTITIONS)).dest(AFFECTED_TOPIC_PARTITIONS).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(AFFECTED_TOPIC_PARTITIONS_DOC);
        MutuallyExclusiveGroup waitGroup = tierRecoveryDataUpload.addMutuallyExclusiveGroup();
        waitGroup.addArgument(RecoveryUtils.makeArgument(WAIT)).dest(WAIT).action(Arguments.store()).type(Integer.class).help(WAIT_DOC);
        waitGroup.addArgument(RecoveryUtils.makeArgument(NO_WAIT)).dest(NO_WAIT).action(Arguments.storeTrue()).help(NO_WAIT_DOC);
    }

    static int waitForUploadToComplete(InitiateTierRecoveryDataUploadCommandResponse response, TierMetadataRecoveryOrchestrator orchestrator, int waitTimeoutSec, int sleepTimeSec) throws ExecutionException, JsonProcessingException, InterruptedException {
        int exitCode = 0;
        Map<Integer, UUID> brokerToJobId = response.getSuccess().stream().collect(Collectors.toMap(InitiateTierRecoveryDataUploadCommandResponse.SuccessBrokerDetail::broker, InitiateTierRecoveryDataUploadCommandResponse.SuccessBrokerDetail::jobId));
        Map<Integer, String> brokerToUrl = orchestrator.getBrokerUrlsIfBrokerExists(brokerToJobId.keySet());
        Time time = Time.SYSTEM;
        long waitTimeoutMs = (long)waitTimeoutSec * 1000L;
        long startTimeMs = time.milliseconds();
        while (!brokerToJobId.isEmpty() && time.milliseconds() - startTimeMs < waitTimeoutMs) {
            GetTierRecoveryDataUploadJobResultCommandResponse res = orchestrator.getTierRecoveryDataUploadJobResultForBrokers(brokerToJobId, brokerToUrl);
            if (!res.getFailed().isEmpty()) {
                exitCode = 1;
                for (GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail failed : res.getFailed()) {
                    System.out.printf("Failed to get expected result of the upload job for broker %s with job id %s. Received: %s\n\n", failed.broker(), failed.jobId(), failed.result());
                    brokerToJobId.remove(failed.broker());
                }
            }
            for (GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail completed : res.getCompleted()) {
                System.out.println(completed.result().printReport(completed.jobId(), completed.broker()));
                brokerToJobId.remove(completed.broker());
            }
            Thread.sleep((long)sleepTimeSec * 1000L);
        }
        if (!brokerToJobId.isEmpty()) {
            exitCode = 1;
            System.out.println(String.format("Upload job did not complete within the specified timeout %ds for the following brokers:", waitTimeoutSec));
            for (Map.Entry<Integer, UUID> entry : brokerToJobId.entrySet()) {
                System.out.printf("\t- Broker: %s, Job ID: %s\n", entry.getKey(), entry.getValue());
            }
        }
        return exitCode;
    }

    static int execute(Namespace namespace) throws ExecutionException, InterruptedException, IOException {
        int exitCode;
        InitiateTierRecoveryDataUploadCommandResponse response;
        Set<TopicIdPartition> topicIdPartitions;
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        TierMetadataRecoveryOrchestrator orchestrator = TierMetadataRecoveryUtils.getTierMetadataRecoveryOrchestrator(adminConfig, bootstrapServers, restServerPort);
        String identifier = namespace.getString(IDENTIFIER);
        int numThreads = namespace.getInt(NUM_THREADS_OVERRIDE);
        String reconciledDataLossValidatorOutput = namespace.getString(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT);
        String dataLossValidatorOutput = namespace.getString(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT);
        String affectedTopicPartitions = namespace.getString(AFFECTED_TOPIC_PARTITIONS);
        Integer waitTimeout = namespace.getInt(WAIT);
        Boolean noWait = namespace.getBoolean(NO_WAIT);
        if (noWait.booleanValue() && waitTimeout != null) {
            throw new IllegalArgumentException(String.format("Can only provide one of --%s or --%s arguments.", WAIT, NO_WAIT));
        }
        boolean shouldWaitForUploadToComplete = waitTimeout != null || noWait == false;
        waitTimeout = waitTimeout == null ? Integer.MAX_VALUE : waitTimeout;
        if (reconciledDataLossValidatorOutput != null) {
            topicIdPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromReconciledDLVOutput(reconciledDataLossValidatorOutput).stream().map(tp -> new TopicIdPartition(Utils.toKafkaUuid((UUID)tp.topicId()), tp.topicPartition())).collect(Collectors.toSet());
        } else if (dataLossValidatorOutput != null) {
            topicIdPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromNonReconciledDLVOutput(dataLossValidatorOutput).stream().map(tp -> new TopicIdPartition(Utils.toKafkaUuid((UUID)tp.topicId()), tp.topicPartition())).collect(Collectors.toSet());
        } else if (affectedTopicPartitions != null) {
            topicIdPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromTargetTopicPartitionsFile(affectedTopicPartitions).stream().map(tp -> new TopicIdPartition(Utils.toKafkaUuid((UUID)tp.topicId()), tp.topicPartition())).collect(Collectors.toSet());
        } else {
            throw new IllegalArgumentException(String.format("Either %s or %s must be provided", NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT, AFFECTED_TOPIC_PARTITIONS));
        }
        if (namespace.getBoolean("all-brokers").booleanValue()) {
            response = orchestrator.initiateTierRecoveryDataUploadForCluster(topicIdPartitions, identifier, numThreads);
        } else {
            Set<Integer> brokers = TierMetadataRecoveryUtils.getBrokerList(namespace);
            response = new InitiateTierRecoveryDataUploadCommandResponse();
            for (Integer broker : brokers) {
                InitiateTierRecoveryDataUploadCommandResponse brokerRes = orchestrator.initiateTierRecoveryDataUploadForBroker(topicIdPartitions, identifier, numThreads, broker);
                response.getSuccess().addAll(brokerRes.getSuccess());
                response.getFailed().addAll(brokerRes.getFailed());
            }
        }
        int n = exitCode = response.getFailed().isEmpty() ? 0 : 1;
        if (exitCode == 1) {
            System.out.printf("Failed to initiate upload on %d brokers: [%s]\n", response.getFailed().size(), String.join((CharSequence)",", response.getFailed().stream().map(failedBroker -> failedBroker.broker().toString()).collect(Collectors.toList())));
        }
        if (shouldWaitForUploadToComplete) {
            int sleepTimeSec = 5;
            exitCode = Math.max(InitiateTierRecoveryDataUploadCommand.waitForUploadToComplete(response, orchestrator, waitTimeout, sleepTimeSec), exitCode);
        }
        return exitCode;
    }
}

